package software.amazon.awscdk.core;

/**
 * Options to the resolve() operation.
 * 
 * NOT the same as the ResolveContext; ResolveContext is exposed to Token
 * implementors and resolution hooks, whereas this struct is just to bundle
 * a number of things that would otherwise be arguments to resolve() in a
 * readable way.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.14.3 (build 1b1062d)", date = "2019-08-14T08:10:20.292Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ResolveOptions extends software.amazon.jsii.JsiiSerializable {
    /**
     * The resolver to apply to any resolvable tokens found.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.core.ITokenResolver getResolver();
    /**
     * The scope from which resolution is performed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.core.IConstruct getScope();

    /**
     * @return a {@link Builder} of {@link ResolveOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link ResolveOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        private software.amazon.awscdk.core.ITokenResolver _resolver;
        private software.amazon.awscdk.core.IConstruct _scope;

        /**
         * Sets the value of Resolver
         * @param value The resolver to apply to any resolvable tokens found.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withResolver(final software.amazon.awscdk.core.ITokenResolver value) {
            this._resolver = java.util.Objects.requireNonNull(value, "resolver is required");
            return this;
        }
        /**
         * Sets the value of Scope
         * @param value The scope from which resolution is performed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withScope(final software.amazon.awscdk.core.IConstruct value) {
            this._scope = java.util.Objects.requireNonNull(value, "scope is required");
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ResolveOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public ResolveOptions build() {
            return new ResolveOptions() {
                private final software.amazon.awscdk.core.ITokenResolver $resolver = java.util.Objects.requireNonNull(_resolver, "resolver is required");
                private final software.amazon.awscdk.core.IConstruct $scope = java.util.Objects.requireNonNull(_scope, "scope is required");

                @Override
                public software.amazon.awscdk.core.ITokenResolver getResolver() {
                    return this.$resolver;
                }

                @Override
                public software.amazon.awscdk.core.IConstruct getScope() {
                    return this.$scope;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("resolver", om.valueToTree(this.getResolver()));
                    obj.set("scope", om.valueToTree(this.getScope()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.core.ResolveOptions {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The resolver to apply to any resolvable tokens found.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.core.ITokenResolver getResolver() {
            return this.jsiiGet("resolver", software.amazon.awscdk.core.ITokenResolver.class);
        }

        /**
         * The scope from which resolution is performed.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.core.IConstruct getScope() {
            return this.jsiiGet("scope", software.amazon.awscdk.core.IConstruct.class);
        }
    }
}
