package software.amazon.awscdk.core;

/**
 * Represents the building block of the construct graph.
 * 
 * All constructs besides the root construct must be created within the scope of
 * another construct.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.14.3 (build 1b1062d)", date = "2019-08-14T08:10:20.276Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.Construct")
public class Construct extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.core.IConstruct {
    protected Construct(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    /**
     * Creates a new construct node.
     * 
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Construct(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Return whether the given object is a Construct.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static java.lang.Boolean isConstruct(@javax.annotation.Nullable final java.lang.Object x) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Construct.class, "isConstruct", java.lang.Boolean.class, new Object[] { x });
    }

    /**
     * Perform final modifications before synthesis.
     * 
     * This method can be implemented by derived constructs in order to perform
     * final changes before synthesis. prepare() will be called after child
     * constructs have been prepared.
     * 
     * This is an advanced framework feature. Only use this if you
     * understand the implications.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void prepare() {
        this.jsiiCall("prepare", Void.class);
    }

    /**
     * Allows this construct to emit artifacts into the cloud assembly during synthesis.
     * 
     * This method is usually implemented by framework-level constructs such as `Stack` and `Asset`
     * as they participate in synthesizing the cloud assembly.
     * 
     * @param session The synthesis session.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void synthesize(final software.amazon.awscdk.core.ISynthesisSession session) {
        this.jsiiCall("synthesize", Void.class, new Object[] { java.util.Objects.requireNonNull(session, "session is required") });
    }

    /**
     * Returns a string representation of this construct.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String toString() {
        return this.jsiiCall("toString", java.lang.String.class);
    }

    /**
     * Validate the current construct.
     * 
     * This method can be implemented by derived constructs in order to perform
     * validation logic. It is called on all constructs before synthesis.
     * 
     * @return An array of validation error messages, or an empty array if there the construct is valid.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected java.util.List<java.lang.String> validate() {
        return this.jsiiCall("validate", java.util.List.class);
    }

    /**
     * Construct tree node which offers APIs for interacting with the construct tree.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.core.ConstructNode getNode() {
        return this.jsiiGet("node", software.amazon.awscdk.core.ConstructNode.class);
    }
}
