package software.amazon.awscdk.core;

/**
 * Specifies whether an Auto Scaling group and the instances it contains are replaced during an update.
 * 
 * During replacement,
 * AWS CloudFormation retains the old group until it finishes creating the new one. If the update fails, AWS CloudFormation
 * can roll back to the old Auto Scaling group and delete the new Auto Scaling group.
 * 
 * While AWS CloudFormation creates the new group, it doesn't detach or attach any instances. After successfully creating
 * the new Auto Scaling group, AWS CloudFormation deletes the old Auto Scaling group during the cleanup process.
 * 
 * When you set the WillReplace parameter, remember to specify a matching CreationPolicy. If the minimum number of
 * instances (specified by the MinSuccessfulInstancesPercent property) don't signal success within the Timeout period
 * (specified in the CreationPolicy policy), the replacement update fails and AWS CloudFormation rolls back to the old
 * Auto Scaling group.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.14.3 (build 1b1062d)", date = "2019-08-14T08:10:20.263Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnAutoScalingReplacingUpdate extends software.amazon.jsii.JsiiSerializable {
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Boolean getWillReplace();

    /**
     * @return a {@link Builder} of {@link CfnAutoScalingReplacingUpdate}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link CfnAutoScalingReplacingUpdate}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        @javax.annotation.Nullable
        private java.lang.Boolean _willReplace;

        /**
         * Sets the value of WillReplace
         * @param value the value to be set
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withWillReplace(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._willReplace = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnAutoScalingReplacingUpdate}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public CfnAutoScalingReplacingUpdate build() {
            return new CfnAutoScalingReplacingUpdate() {
                @javax.annotation.Nullable
                private final java.lang.Boolean $willReplace = _willReplace;

                @Override
                public java.lang.Boolean getWillReplace() {
                    return this.$willReplace;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    if (this.getWillReplace() != null) {
                        obj.set("willReplace", om.valueToTree(this.getWillReplace()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.core.CfnAutoScalingReplacingUpdate {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.Boolean getWillReplace() {
            return this.jsiiGet("willReplace", java.lang.Boolean.class);
        }
    }
}
