package software.amazon.awscdk.core;

/**
 * A rule can include a RuleCondition property and must include an Assertions property. For each rule, you can define only one rule condition; you can define one or more asserts within the Assertions property. You define a rule condition and assertions by using rule-specific intrinsic functions.
 * 
 * You can use the following rule-specific intrinsic functions to define rule conditions and assertions:
 * 
 *   Fn::And
 *   Fn::Contains
 *   Fn::EachMemberEquals
 *   Fn::EachMemberIn
 *   Fn::Equals
 *   Fn::If
 *   Fn::Not
 *   Fn::Or
 *   Fn::RefAll
 *   Fn::ValueOf
 *   Fn::ValueOfAll
 * 
 * https://docs.aws.amazon.com/servicecatalog/latest/adminguide/reference-template_constraint_rules.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.14.2 (build e881f16)", date = "2019-07-25T16:26:52.063Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnRuleProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * Assertions which define the rule.
     * 
     * Default: - No assertions for the rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<software.amazon.awscdk.core.CfnRuleAssertion> getAssertions();
    /**
     * If the rule condition evaluates to false, the rule doesn't take effect. If the function in the rule condition evaluates to true, expressions in each assert are evaluated and applied.
     * 
     * Default: - Rule's assertions will always take effect.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.core.ICfnConditionExpression getRuleCondition();

    /**
     * @return a {@link Builder} of {@link CfnRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link CfnRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.core.CfnRuleAssertion> _assertions;
        @javax.annotation.Nullable
        private software.amazon.awscdk.core.ICfnConditionExpression _ruleCondition;

        /**
         * Sets the value of Assertions
         * @param value Assertions which define the rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withAssertions(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.core.CfnRuleAssertion> value) {
            this._assertions = value;
            return this;
        }
        /**
         * Sets the value of RuleCondition
         * @param value If the rule condition evaluates to false, the rule doesn't take effect. If the function in the rule condition evaluates to true, expressions in each assert are evaluated and applied.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withRuleCondition(@javax.annotation.Nullable final software.amazon.awscdk.core.ICfnConditionExpression value) {
            this._ruleCondition = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnRuleProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public CfnRuleProps build() {
            return new CfnRuleProps() {
                @javax.annotation.Nullable
                private final java.util.List<software.amazon.awscdk.core.CfnRuleAssertion> $assertions = _assertions;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.core.ICfnConditionExpression $ruleCondition = _ruleCondition;

                @Override
                public java.util.List<software.amazon.awscdk.core.CfnRuleAssertion> getAssertions() {
                    return this.$assertions;
                }

                @Override
                public software.amazon.awscdk.core.ICfnConditionExpression getRuleCondition() {
                    return this.$ruleCondition;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    if (this.getAssertions() != null) {
                        obj.set("assertions", om.valueToTree(this.getAssertions()));
                    }
                    if (this.getRuleCondition() != null) {
                        obj.set("ruleCondition", om.valueToTree(this.getRuleCondition()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.core.CfnRuleProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * Assertions which define the rule.
         * 
         * Default: - No assertions for the rule.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.core.CfnRuleAssertion> getAssertions() {
            return this.jsiiGet("assertions", java.util.List.class);
        }

        /**
         * If the rule condition evaluates to false, the rule doesn't take effect. If the function in the rule condition evaluates to true, expressions in each assert are evaluated and applied.
         * 
         * Default: - Rule's assertions will always take effect.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.core.ICfnConditionExpression getRuleCondition() {
            return this.jsiiGet("ruleCondition", software.amazon.awscdk.core.ICfnConditionExpression.class);
        }
    }
}
