package software.amazon.awscdk.core;

/**
 * Specifies whether an Auto Scaling group and the instances it contains are replaced during an update.
 * 
 * During replacement,
 * AWS CloudFormation retains the old group until it finishes creating the new one. If the update fails, AWS CloudFormation
 * can roll back to the old Auto Scaling group and delete the new Auto Scaling group.
 * 
 * While AWS CloudFormation creates the new group, it doesn't detach or attach any instances. After successfully creating
 * the new Auto Scaling group, AWS CloudFormation deletes the old Auto Scaling group during the cleanup process.
 * 
 * When you set the WillReplace parameter, remember to specify a matching CreationPolicy. If the minimum number of
 * instances (specified by the MinSuccessfulInstancesPercent property) don't signal success within the Timeout period
 * (specified in the CreationPolicy policy), the replacement update fails and AWS CloudFormation rolls back to the old
 * Auto Scaling group.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.20.3 (build 26aa77c)", date = "2019-11-12T00:10:00.899Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.CfnAutoScalingReplacingUpdate")
@software.amazon.jsii.Jsii.Proxy(CfnAutoScalingReplacingUpdate.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnAutoScalingReplacingUpdate extends software.amazon.jsii.JsiiSerializable {

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default java.lang.Boolean getWillReplace() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnAutoScalingReplacingUpdate}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnAutoScalingReplacingUpdate}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private java.lang.Boolean willReplace;

        /**
         * Sets the value of WillReplace
         * @param willReplace the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder willReplace(java.lang.Boolean willReplace) {
            this.willReplace = willReplace;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnAutoScalingReplacingUpdate}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public CfnAutoScalingReplacingUpdate build() {
            return new Jsii$Proxy(willReplace);
        }
    }

    /**
     * An implementation for {@link CfnAutoScalingReplacingUpdate}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnAutoScalingReplacingUpdate {
        private final java.lang.Boolean willReplace;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.willReplace = this.jsiiGet("willReplace", java.lang.Boolean.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.Boolean willReplace) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.willReplace = willReplace;
        }

        @Override
        public java.lang.Boolean getWillReplace() {
            return this.willReplace;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getWillReplace() != null) {
                data.set("willReplace", om.valueToTree(this.getWillReplace()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/core.CfnAutoScalingReplacingUpdate"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnAutoScalingReplacingUpdate.Jsii$Proxy that = (CfnAutoScalingReplacingUpdate.Jsii$Proxy) o;

            return this.willReplace != null ? this.willReplace.equals(that.willReplace) : that.willReplace == null;
        }

        @Override
        public int hashCode() {
            int result = this.willReplace != null ? this.willReplace.hashCode() : 0;
            return result;
        }
    }
}
