package software.amazon.awscdk.core;

/**
 * Represents a special or lazily-evaluated value.
 * 
 * Can be used to delay evaluation of a certain value in case, for example,
 * that it requires some context or late-bound data. Can also be used to
 * mark values that need special processing at document rendering time.
 * 
 * Tokens can be embedded into strings while retaining their original
 * semantics.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.19.0 (build 7c562bc)", date = "2019-10-15T19:44:26.037Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.Token")
public class Token extends software.amazon.jsii.JsiiObject {

    protected Token(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Token(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Return a resolvable representation of the given value.
     * 
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.core.IResolvable asAny(final java.lang.Object value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Token.class, "asAny", software.amazon.awscdk.core.IResolvable.class, new Object[] { value });
    }

    /**
     * Return a reversible list representation of this token.
     * 
     * @param value This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static java.util.List<java.lang.String> asList(final java.lang.Object value, final software.amazon.awscdk.core.EncodingOptions options) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Token.class, "asList", java.util.List.class, new Object[] { value, options }));
    }

    /**
     * Return a reversible list representation of this token.
     * 
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static java.util.List<java.lang.String> asList(final java.lang.Object value) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Token.class, "asList", java.util.List.class, new Object[] { value }));
    }

    /**
     * Return a reversible number representation of this token.
     * 
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static java.lang.Number asNumber(final java.lang.Object value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Token.class, "asNumber", java.lang.Number.class, new Object[] { value });
    }

    /**
     * Return a reversible string representation of this token.
     * 
     * If the Token is initialized with a literal, the stringified value of the
     * literal is returned. Otherwise, a special quoted string representation
     * of the Token is returned that can be embedded into other strings.
     * 
     * Strings with quoted Tokens in them can be restored back into
     * complex values with the Tokens restored by calling `resolve()`
     * on the string.
     * 
     * @param value This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static java.lang.String asString(final java.lang.Object value, final software.amazon.awscdk.core.EncodingOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Token.class, "asString", java.lang.String.class, new Object[] { value, options });
    }

    /**
     * Return a reversible string representation of this token.
     * 
     * If the Token is initialized with a literal, the stringified value of the
     * literal is returned. Otherwise, a special quoted string representation
     * of the Token is returned that can be embedded into other strings.
     * 
     * Strings with quoted Tokens in them can be restored back into
     * complex values with the Tokens restored by calling `resolve()`
     * on the string.
     * 
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static java.lang.String asString(final java.lang.Object value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Token.class, "asString", java.lang.String.class, new Object[] { value });
    }

    /**
     * Returns true if obj represents an unresolved value.
     * 
     * One of these must be true:
     * 
     * - `obj` is an IResolvable
     * - `obj` is a string containing at least one encoded `IResolvable`
     * - `obj` is either an encoded number or list
     * 
     * This does NOT recurse into lists or objects to see if they
     * containing resolvables.
     * 
     * @param obj The object to test. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static java.lang.Boolean isUnresolved(final java.lang.Object obj) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Token.class, "isUnresolved", java.lang.Boolean.class, new Object[] { obj });
    }
}
