package software.amazon.awscdk.core;

/**
 * A root construct which represents a single CloudFormation stack.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.19.0 (build 7c562bc)", date = "2019-10-15T19:44:26.034Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.Stack")
public class Stack extends software.amazon.awscdk.core.Construct implements software.amazon.awscdk.core.ITaggable {

    protected Stack(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Stack(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Creates a new stack.
     * 
     * @param scope Parent of this stack, usually a Program instance.
     * @param name The name of the CloudFormation stack.
     * @param props Stack properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Stack(final software.amazon.awscdk.core.Construct scope, final java.lang.String name, final software.amazon.awscdk.core.StackProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        this.setObjRef(software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { scope, name, props }));
    }

    /**
     * Creates a new stack.
     * 
     * @param scope Parent of this stack, usually a Program instance.
     * @param name The name of the CloudFormation stack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Stack(final software.amazon.awscdk.core.Construct scope, final java.lang.String name) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        this.setObjRef(software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { scope, name }));
    }

    /**
     * Creates a new stack.
     * 
     * @param scope Parent of this stack, usually a Program instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Stack(final software.amazon.awscdk.core.Construct scope) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        this.setObjRef(software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { scope }));
    }

    /**
     * Creates a new stack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Stack() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        this.setObjRef(software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this));
    }

    /**
     * Return whether the given object is a Stack.
     * 
     * We do attribute detection since we can't reliably use 'instanceof'.
     * 
     * @param x This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static java.lang.Boolean isStack(final java.lang.Object x) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Stack.class, "isStack", java.lang.Boolean.class, new Object[] { x });
    }

    /**
     * Looks up the first stack scope in which `construct` is defined.
     * 
     * Fails if there is no stack up the tree.
     * 
     * @param construct The construct to start the search from. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.core.Stack of(final software.amazon.awscdk.core.IConstruct construct) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Stack.class, "of", software.amazon.awscdk.core.Stack.class, new Object[] { java.util.Objects.requireNonNull(construct, "construct is required") });
    }

    /**
     * Add a dependency between this stack and another stack.
     * 
     * @param stack This parameter is required.
     * @param reason
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addDependency(final software.amazon.awscdk.core.Stack stack, final java.lang.String reason) {
        this.jsiiCall("addDependency", Void.class, new Object[] { java.util.Objects.requireNonNull(stack, "stack is required"), reason });
    }

    /**
     * Add a dependency between this stack and another stack.
     * 
     * @param stack This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addDependency(final software.amazon.awscdk.core.Stack stack) {
        this.jsiiCall("addDependency", Void.class, new Object[] { java.util.Objects.requireNonNull(stack, "stack is required") });
    }

    /**
     * @param asset This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.core.DockerImageAssetLocation addDockerImageAsset(final software.amazon.awscdk.core.DockerImageAssetSource asset) {
        return this.jsiiCall("addDockerImageAsset", software.amazon.awscdk.core.DockerImageAssetLocation.class, new Object[] { java.util.Objects.requireNonNull(asset, "asset is required") });
    }

    /**
     * @param asset This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.core.FileAssetLocation addFileAsset(final software.amazon.awscdk.core.FileAssetSource asset) {
        return this.jsiiCall("addFileAsset", software.amazon.awscdk.core.FileAssetLocation.class, new Object[] { java.util.Objects.requireNonNull(asset, "asset is required") });
    }

    /**
     * Returns the naming scheme used to allocate logical IDs.
     * 
     * By default, uses
     * the `HashedAddressingScheme` but this method can be overridden to customize
     * this behavior.
     * 
     * In order to make sure logical IDs are unique and stable, we hash the resource
     * construct tree path (i.e. toplevel/secondlevel/.../myresource) and add it as
     * a suffix to the path components joined without a separator (CloudFormation
     * IDs only allow alphanumeric characters).
     * 
     * The result will be:
     * 
     *    <path.join('')><md5(path.join('/')>
     *      "human"      "hash"
     * 
     * If the "human" part of the ID exceeds 240 characters, we simply trim it so
     * the total ID doesn't exceed CloudFormation's 255 character limit.
     * 
     * We only take 8 characters from the md5 hash (0.000005 chance of collision).
     * 
     * Special cases:
     * 
     * - If the path only contains a single component (i.e. it's a top-level
     *    resource), we won't add the hash to it. The hash is not needed for
     *    disamiguation and also, it allows for a more straightforward migration an
     *    existing CloudFormation template to a CDK stack without logical ID changes
     *    (or renames).
     * - For aesthetic reasons, if the last components of the path are the same
     *    (i.e. `L1/L2/Pipeline/Pipeline`), they will be de-duplicated to make the
     *    resulting human portion of the ID more pleasing: `L1L2Pipeline<HASH>`
     *    instead of `L1L2PipelinePipeline<HASH>`
     * - If a component is named "Default" it will be omitted from the path. This
     *    allows refactoring higher level abstractions around constructs without affecting
     *    the IDs of already deployed resources.
     * - If a component is named "Resource" it will be omitted from the user-visible
     *    path, but included in the hash. This reduces visual noise in the human readable
     *    part of the identifier.
     * 
     * @param cfnElement The element for which the logical ID is allocated. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected java.lang.String allocateLogicalId(final software.amazon.awscdk.core.CfnElement cfnElement) {
        return this.jsiiCall("allocateLogicalId", java.lang.String.class, new Object[] { java.util.Objects.requireNonNull(cfnElement, "cfnElement is required") });
    }

    /**
     * Creates an ARN from components.
     * 
     * If `partition`, `region` or `account` are not specified, the stack's
     * partition, region and account will be used.
     * 
     * If any component is the empty string, an empty string will be inserted
     * into the generated ARN at the location that component corresponds to.
     * 
     * The ARN will be formatted as follows:
     * 
     *    arn:{partition}:{service}:{region}:{account}:{resource}{sep}}{resource-name}
     * 
     * The required ARN pieces that are omitted will be taken from the stack that
     * the 'scope' is attached to. If all ARN pieces are supplied, the supplied scope
     * can be 'undefined'.
     * 
     * @param components This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String formatArn(final software.amazon.awscdk.core.ArnComponents components) {
        return this.jsiiCall("formatArn", java.lang.String.class, new Object[] { java.util.Objects.requireNonNull(components, "components is required") });
    }

    /**
     * Allocates a stack-unique CloudFormation-compatible logical identity for a specific resource.
     * 
     * This method is called when a `CfnElement` is created and used to render the
     * initial logical identity of resources. Logical ID renames are applied at
     * this stage.
     * 
     * This method uses the protected method `allocateLogicalId` to render the
     * logical ID for an element. To modify the naming scheme, extend the `Stack`
     * class and override this method.
     * 
     * @param element The CloudFormation element for which a logical identity is needed. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getLogicalId(final software.amazon.awscdk.core.CfnElement element) {
        return this.jsiiCall("getLogicalId", java.lang.String.class, new Object[] { java.util.Objects.requireNonNull(element, "element is required") });
    }

    /**
     * Given an ARN, parses it and returns components.
     * 
     * If the ARN is a concrete string, it will be parsed and validated. The
     * separator (`sep`) will be set to '/' if the 6th component includes a '/',
     * in which case, `resource` will be set to the value before the '/' and
     * `resourceName` will be the rest. In case there is no '/', `resource` will
     * be set to the 6th components and `resourceName` will be set to the rest
     * of the string.
     * 
     * If the ARN includes tokens (or is a token), the ARN cannot be validated,
     * since we don't have the actual value yet at the time of this function
     * call. You will have to know the separator and the type of ARN. The
     * resulting `ArnComponents` object will contain tokens for the
     * subexpressions of the ARN, not string literals. In this case this
     * function cannot properly parse the complete final resourceName (path) out
     * of ARNs that use '/' to both separate the 'resource' from the
     * 'resourceName' AND to subdivide the resourceName further. For example, in
     * S3 ARNs:
     * 
     *     arn:aws:s3:::my_corporate_bucket/path/to/exampleobject.png
     * 
     * After parsing the resourceName will not contain
     * 'path/to/exampleobject.png' but simply 'path'. This is a limitation
     * because there is no slicing functionality in CloudFormation templates.
     * 
     * @return an ArnComponents object which allows access to the various
     * components of the ARN.
     * @param arn The ARN string to parse. This parameter is required.
     * @param sepIfToken The separator used to separate resource from resourceName.
     * @param hasName Whether there is a name component in the ARN at all.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.core.ArnComponents parseArn(final java.lang.String arn, final java.lang.String sepIfToken, final java.lang.Boolean hasName) {
        return this.jsiiCall("parseArn", software.amazon.awscdk.core.ArnComponents.class, new Object[] { java.util.Objects.requireNonNull(arn, "arn is required"), sepIfToken, hasName });
    }

    /**
     * Given an ARN, parses it and returns components.
     * 
     * If the ARN is a concrete string, it will be parsed and validated. The
     * separator (`sep`) will be set to '/' if the 6th component includes a '/',
     * in which case, `resource` will be set to the value before the '/' and
     * `resourceName` will be the rest. In case there is no '/', `resource` will
     * be set to the 6th components and `resourceName` will be set to the rest
     * of the string.
     * 
     * If the ARN includes tokens (or is a token), the ARN cannot be validated,
     * since we don't have the actual value yet at the time of this function
     * call. You will have to know the separator and the type of ARN. The
     * resulting `ArnComponents` object will contain tokens for the
     * subexpressions of the ARN, not string literals. In this case this
     * function cannot properly parse the complete final resourceName (path) out
     * of ARNs that use '/' to both separate the 'resource' from the
     * 'resourceName' AND to subdivide the resourceName further. For example, in
     * S3 ARNs:
     * 
     *     arn:aws:s3:::my_corporate_bucket/path/to/exampleobject.png
     * 
     * After parsing the resourceName will not contain
     * 'path/to/exampleobject.png' but simply 'path'. This is a limitation
     * because there is no slicing functionality in CloudFormation templates.
     * 
     * @return an ArnComponents object which allows access to the various
     * components of the ARN.
     * @param arn The ARN string to parse. This parameter is required.
     * @param sepIfToken The separator used to separate resource from resourceName.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.core.ArnComponents parseArn(final java.lang.String arn, final java.lang.String sepIfToken) {
        return this.jsiiCall("parseArn", software.amazon.awscdk.core.ArnComponents.class, new Object[] { java.util.Objects.requireNonNull(arn, "arn is required"), sepIfToken });
    }

    /**
     * Given an ARN, parses it and returns components.
     * 
     * If the ARN is a concrete string, it will be parsed and validated. The
     * separator (`sep`) will be set to '/' if the 6th component includes a '/',
     * in which case, `resource` will be set to the value before the '/' and
     * `resourceName` will be the rest. In case there is no '/', `resource` will
     * be set to the 6th components and `resourceName` will be set to the rest
     * of the string.
     * 
     * If the ARN includes tokens (or is a token), the ARN cannot be validated,
     * since we don't have the actual value yet at the time of this function
     * call. You will have to know the separator and the type of ARN. The
     * resulting `ArnComponents` object will contain tokens for the
     * subexpressions of the ARN, not string literals. In this case this
     * function cannot properly parse the complete final resourceName (path) out
     * of ARNs that use '/' to both separate the 'resource' from the
     * 'resourceName' AND to subdivide the resourceName further. For example, in
     * S3 ARNs:
     * 
     *     arn:aws:s3:::my_corporate_bucket/path/to/exampleobject.png
     * 
     * After parsing the resourceName will not contain
     * 'path/to/exampleobject.png' but simply 'path'. This is a limitation
     * because there is no slicing functionality in CloudFormation templates.
     * 
     * @return an ArnComponents object which allows access to the various
     * components of the ARN.
     * @param arn The ARN string to parse. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.core.ArnComponents parseArn(final java.lang.String arn) {
        return this.jsiiCall("parseArn", software.amazon.awscdk.core.ArnComponents.class, new Object[] { java.util.Objects.requireNonNull(arn, "arn is required") });
    }

    /**
     * Prepare stack.
     * 
     * Find all CloudFormation references and tell them we're consuming them.
     * 
     * Find all dependencies as well and add the appropriate DependsOn fields.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected void prepare() {
        this.jsiiCall("prepare", Void.class);
    }

    /**
     * Exports a resolvable value for use in another stack.
     * 
     * @return a token that can be used to reference the value from the producing stack.
     * @param sourceStack This parameter is required.
     * @param reference This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected software.amazon.awscdk.core.IResolvable prepareCrossReference(final software.amazon.awscdk.core.Stack sourceStack, final software.amazon.awscdk.core.Reference reference) {
        return this.jsiiCall("prepareCrossReference", software.amazon.awscdk.core.IResolvable.class, new Object[] { java.util.Objects.requireNonNull(sourceStack, "sourceStack is required"), java.util.Objects.requireNonNull(reference, "reference is required") });
    }

    /**
     * Rename a generated logical identities.
     * 
     * To modify the naming scheme strategy, extend the `Stack` class and
     * override the `createNamingScheme` method.
     * 
     * @param oldId This parameter is required.
     * @param newId This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void renameLogicalId(final java.lang.String oldId, final java.lang.String newId) {
        this.jsiiCall("renameLogicalId", Void.class, new Object[] { java.util.Objects.requireNonNull(oldId, "oldId is required"), java.util.Objects.requireNonNull(newId, "newId is required") });
    }

    /**
     * Indicate that a context key was expected.
     * 
     * Contains instructions which will be emitted into the cloud assembly on how
     * the key should be supplied.
     * 
     * @param report The set of parameters needed to obtain the context. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void reportMissingContext(final software.amazon.awscdk.cxapi.MissingContext report) {
        this.jsiiCall("reportMissingContext", Void.class, new Object[] { java.util.Objects.requireNonNull(report, "report is required") });
    }

    /**
     * Resolve a tokenized value in the context of the current stack.
     * 
     * @param obj This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.Object resolve(final java.lang.Object obj) {
        return this.jsiiCall("resolve", java.lang.Object.class, new Object[] { obj });
    }

    /**
     * Allows this construct to emit artifacts into the cloud assembly during synthesis.
     * 
     * This method is usually implemented by framework-level constructs such as `Stack` and `Asset`
     * as they participate in synthesizing the cloud assembly.
     * 
     * @param session This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected void synthesize(final software.amazon.awscdk.core.ISynthesisSession session) {
        this.jsiiCall("synthesize", Void.class, new Object[] { java.util.Objects.requireNonNull(session, "session is required") });
    }

    /**
     * Convert an object, potentially containing tokens, to a JSON string.
     * 
     * @param obj This parameter is required.
     * @param space
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String toJsonString(final java.lang.Object obj, final java.lang.Number space) {
        return this.jsiiCall("toJsonString", java.lang.String.class, new Object[] { obj, space });
    }

    /**
     * Convert an object, potentially containing tokens, to a JSON string.
     * 
     * @param obj This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String toJsonString(final java.lang.Object obj) {
        return this.jsiiCall("toJsonString", java.lang.String.class, new Object[] { obj });
    }

    /**
     * The AWS account into which this stack will be deployed.
     * 
     * This value is resolved according to the following rules:
     * 
     * 1. The value provided to `env.account` when the stack is defined. This can
     *     either be a concerete account (e.g. `585695031111`) or the
     *     `Aws.accountId` token.
     * 3. `Aws.accountId`, which represents the CloudFormation intrinsic reference
     *     `{ "Ref": "AWS::AccountId" }` encoded as a string token.
     * 
     * Preferably, you should use the return value as an opaque string and not
     * attempt to parse it to implement your logic. If you do, you must first
     * check that it is a concerete value an not an unresolved token. If this
     * value is an unresolved token (`Token.isUnresolved(stack.account)` returns
     * `true`), this implies that the user wishes that this stack will synthesize
     * into a **account-agnostic template**. In this case, your code should either
     * fail (throw an error, emit a synth error using `node.addError`) or
     * implement some other region-agnostic behavior.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getAccount() {
        return this.jsiiGet("account", java.lang.String.class);
    }

    /**
     * Returnst the list of AZs that are availability in the AWS environment (account/region) associated with this stack.
     * 
     * If the stack is environment-agnostic (either account and/or region are
     * tokens), this property will return an array with 2 tokens that will resolve
     * at deploy-time to the first two availability zones returned from CloudFormation's
     * `Fn::GetAZs` intrinsic function.
     * 
     * If they are not available in the context, returns a set of dummy values and
     * reports them as missing, and let the CLI resolve them by calling EC2
     * `DescribeAvailabilityZones` on the target environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.util.List<java.lang.String> getAvailabilityZones() {
        return java.util.Collections.unmodifiableList(this.jsiiGet("availabilityZones", java.util.List.class));
    }

    /**
     * Return the stacks this stack depends on.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.util.List<software.amazon.awscdk.core.Stack> getDependencies() {
        return java.util.Collections.unmodifiableList(this.jsiiGet("dependencies", java.util.List.class));
    }

    /**
     * The environment coordinates in which this stack is deployed.
     * 
     * In the form
     * `aws://account/region`. Use `stack.account` and `stack.region` to obtain
     * the specific values, no need to parse.
     * 
     * You can use this value to determine if two stacks are targeting the same
     * environment.
     * 
     * If either `stack.account` or `stack.region` are not concrete values (e.g.
     * `Aws.account` or `Aws.region`) the special strings `unknown-account` and/or
     * `unknown-region` will be used respectively to indicate this stack is
     * region/account-agnostic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getEnvironment() {
        return this.jsiiGet("environment", java.lang.String.class);
    }

    /**
     * Indicates if this is a nested stack, in which case `parentStack` will include a reference to it's parent.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.Boolean getNested() {
        return this.jsiiGet("nested", java.lang.Boolean.class);
    }

    /**
     * Returns the list of notification Amazon Resource Names (ARNs) for the current stack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.util.List<java.lang.String> getNotificationArns() {
        return java.util.Collections.unmodifiableList(this.jsiiGet("notificationArns", java.util.List.class));
    }

    /**
     * The partition in which this stack is defined.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getPartition() {
        return this.jsiiGet("partition", java.lang.String.class);
    }

    /**
     * The AWS region into which this stack will be deployed (e.g. `us-west-2`).
     * 
     * This value is resolved according to the following rules:
     * 
     * 1. The value provided to `env.region` when the stack is defined. This can
     *     either be a concerete region (e.g. `us-west-2`) or the `Aws.region`
     *     token.
     * 3. `Aws.region`, which is represents the CloudFormation intrinsic reference
     *     `{ "Ref": "AWS::Region" }` encoded as a string token.
     * 
     * Preferably, you should use the return value as an opaque string and not
     * attempt to parse it to implement your logic. If you do, you must first
     * check that it is a concerete value an not an unresolved token. If this
     * value is an unresolved token (`Token.isUnresolved(stack.region)` returns
     * `true`), this implies that the user wishes that this stack will synthesize
     * into a **region-agnostic template**. In this case, your code should either
     * fail (throw an error, emit a synth error using `node.addError`) or
     * implement some other region-agnostic behavior.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getRegion() {
        return this.jsiiGet("region", java.lang.String.class);
    }

    /**
     * The ID of the stack.
     * 
     * Example:
     * 
     * After resolving, looks like arn:aws:cloudformation:us-west-2:123456789012:stack/teststack/51af3dc0-da77-11e4-872e-1234567db123
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getStackId() {
        return this.jsiiGet("stackId", java.lang.String.class);
    }

    /**
     * The concrete CloudFormation physical stack name.
     * 
     * This is either the name defined explicitly in the `stackName` prop or
     * allocated based on the stack's location in the construct tree. Stacks that
     * are directly defined under the app use their construct `id` as their stack
     * name. Stacks that are defined deeper within the tree will use a hashed naming
     * scheme based on the construct path to ensure uniqueness.
     * 
     * If you wish to obtain the deploy-time AWS::StackName intrinsic,
     * you can use `Aws.stackName` directly.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getStackName() {
        return this.jsiiGet("stackName", java.lang.String.class);
    }

    /**
     * Tags to be applied to the stack.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.core.TagManager getTags() {
        return this.jsiiGet("tags", software.amazon.awscdk.core.TagManager.class);
    }

    /**
     * The name of the CloudFormation template file emitted to the output directory during synthesis.
     * 
     * Example:
     * 
     * MyStack.template.json
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getTemplateFile() {
        return this.jsiiGet("templateFile", java.lang.String.class);
    }

    /**
     * Options for CloudFormation template (like version, transform, description).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.core.ITemplateOptions getTemplateOptions() {
        return this.jsiiGet("templateOptions", software.amazon.awscdk.core.ITemplateOptions.class);
    }

    /**
     * An attribute (late-bound) that represents the URL of the template file in the deployment bucket.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public java.lang.String getTemplateUrl() {
        return this.jsiiGet("templateUrl", java.lang.String.class);
    }

    /**
     * The Amazon domain suffix for the region in which this stack is defined.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String getUrlSuffix() {
        return this.jsiiGet("urlSuffix", java.lang.String.class);
    }

    /**
     * Returns the parent stack if this stack is nested.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public software.amazon.awscdk.core.Stack getParentStack() {
        return this.jsiiGet("parentStack", software.amazon.awscdk.core.Stack.class);
    }
}
