package software.amazon.awscdk.core;

/**
 * Represents the source for a file asset.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.19.0 (build 7c562bc)", date = "2019-10-15T12:19:13.803Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface FileAssetSource extends software.amazon.jsii.JsiiSerializable {

    /**
     * The path, relative to the root of the cloud assembly, in which this asset source resides.
     * 
     * This can be a path to a file or a directory, dependning on the
     * packaging type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getFileName();

    /**
     * Which type of packaging to perform.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.core.FileAssetPackaging getPackaging();

    /**
     * A hash on the content source.
     * 
     * This hash is used to uniquely identify this
     * asset throughout the system. If this value doesn't change, the asset will
     * not be rebuilt or republished.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getSourceHash();

    /**
     * @return a {@link Builder} of {@link FileAssetSource}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link FileAssetSource}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private java.lang.String fileName;
        private software.amazon.awscdk.core.FileAssetPackaging packaging;
        private java.lang.String sourceHash;

        /**
         * Sets the value of FileName
         * @param fileName The path, relative to the root of the cloud assembly, in which this asset source resides. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileName(java.lang.String fileName) {
            this.fileName = fileName;
            return this;
        }

        /**
         * Sets the value of Packaging
         * @param packaging Which type of packaging to perform. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder packaging(software.amazon.awscdk.core.FileAssetPackaging packaging) {
            this.packaging = packaging;
            return this;
        }

        /**
         * Sets the value of SourceHash
         * @param sourceHash A hash on the content source. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceHash(java.lang.String sourceHash) {
            this.sourceHash = sourceHash;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link FileAssetSource}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public FileAssetSource build() {
            return new Jsii$Proxy(fileName, packaging, sourceHash);
        }
    }

    /**
     * An implementation for {@link FileAssetSource}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FileAssetSource {
        private final java.lang.String fileName;
        private final software.amazon.awscdk.core.FileAssetPackaging packaging;
        private final java.lang.String sourceHash;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.fileName = this.jsiiGet("fileName", java.lang.String.class);
            this.packaging = this.jsiiGet("packaging", software.amazon.awscdk.core.FileAssetPackaging.class);
            this.sourceHash = this.jsiiGet("sourceHash", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.String fileName, software.amazon.awscdk.core.FileAssetPackaging packaging, java.lang.String sourceHash) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.fileName = java.util.Objects.requireNonNull(fileName, "fileName is required");
            this.packaging = java.util.Objects.requireNonNull(packaging, "packaging is required");
            this.sourceHash = java.util.Objects.requireNonNull(sourceHash, "sourceHash is required");
        }

        @Override
        public java.lang.String getFileName() {
            return this.fileName;
        }

        @Override
        public software.amazon.awscdk.core.FileAssetPackaging getPackaging() {
            return this.packaging;
        }

        @Override
        public java.lang.String getSourceHash() {
            return this.sourceHash;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("fileName", om.valueToTree(this.getFileName()));
            obj.set("packaging", om.valueToTree(this.getPackaging()));
            obj.set("sourceHash", om.valueToTree(this.getSourceHash()));
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            FileAssetSource.Jsii$Proxy that = (FileAssetSource.Jsii$Proxy) o;

            if (!fileName.equals(that.fileName)) return false;
            if (!packaging.equals(that.packaging)) return false;
            return this.sourceHash.equals(that.sourceHash);
        }

        @Override
        public int hashCode() {
            int result = this.fileName.hashCode();
            result = 31 * result + (this.packaging.hashCode());
            result = 31 * result + (this.sourceHash.hashCode());
            return result;
        }
    }
}
