package software.amazon.awscdk.core;

/**
 * Represents a length of time.
 * 
 * The amount can be specified either as a literal value (e.g: `10`) which
 * cannot be negative, or as an unresolved number token.
 * 
 * Whent he amount is passed as an token, unit conversion is not possible.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.18.0 (build f29d29c)", date = "2019-10-07T15:30:25.493Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "@aws-cdk/core.Duration")
public class Duration extends software.amazon.jsii.JsiiObject {

    protected Duration(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Duration(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @return a new `Duration` representing `amount` Days.
     * @param amount the amount of Days the `Duration` will represent. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.core.Duration days(final java.lang.Number amount) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Duration.class, "days", software.amazon.awscdk.core.Duration.class, new Object[] { java.util.Objects.requireNonNull(amount, "amount is required") });
    }

    /**
     * @return a new `Duration` representing `amount` Hours.
     * @param amount the amount of Hours the `Duration` will represent. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.core.Duration hours(final java.lang.Number amount) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Duration.class, "hours", software.amazon.awscdk.core.Duration.class, new Object[] { java.util.Objects.requireNonNull(amount, "amount is required") });
    }

    /**
     * @return a new `Duration` representing `amount` ms.
     * @param amount the amount of Milliseconds the `Duration` will represent. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.core.Duration millis(final java.lang.Number amount) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Duration.class, "millis", software.amazon.awscdk.core.Duration.class, new Object[] { java.util.Objects.requireNonNull(amount, "amount is required") });
    }

    /**
     * @return a new `Duration` representing `amount` Minutes.
     * @param amount the amount of Minutes the `Duration` will represent. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.core.Duration minutes(final java.lang.Number amount) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Duration.class, "minutes", software.amazon.awscdk.core.Duration.class, new Object[] { java.util.Objects.requireNonNull(amount, "amount is required") });
    }

    /**
     * Parse a period formatted according to the ISO 8601 standard (see https://www.iso.org/fr/standard/70907.html).
     * 
     * @return the parsed `Duration`.
     * @param duration an ISO-formtted duration to be parsed. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.core.Duration parse(final java.lang.String duration) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Duration.class, "parse", software.amazon.awscdk.core.Duration.class, new Object[] { java.util.Objects.requireNonNull(duration, "duration is required") });
    }

    /**
     * @return a new `Duration` representing `amount` Seconds.
     * @param amount the amount of Seconds the `Duration` will represent. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static software.amazon.awscdk.core.Duration seconds(final java.lang.Number amount) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Duration.class, "seconds", software.amazon.awscdk.core.Duration.class, new Object[] { java.util.Objects.requireNonNull(amount, "amount is required") });
    }

    /**
     * @return the value of this `Duration` expressed in Days.
     * @param opts
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.Number toDays(final software.amazon.awscdk.core.TimeConversionOptions opts) {
        return this.jsiiCall("toDays", java.lang.Number.class, new Object[] { opts });
    }

    /**
     * @return the value of this `Duration` expressed in Days.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.Number toDays() {
        return this.jsiiCall("toDays", java.lang.Number.class);
    }

    /**
     * @return the value of this `Duration` expressed in Hours.
     * @param opts
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.Number toHours(final software.amazon.awscdk.core.TimeConversionOptions opts) {
        return this.jsiiCall("toHours", java.lang.Number.class, new Object[] { opts });
    }

    /**
     * @return the value of this `Duration` expressed in Hours.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.Number toHours() {
        return this.jsiiCall("toHours", java.lang.Number.class);
    }

    /**
     * @return an ISO 8601 representation of this period (see https://www.iso.org/fr/standard/70907.html).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String toISOString() {
        return this.jsiiCall("toISOString", java.lang.String.class);
    }

    /**
     * @return the value of this `Duration` expressed in Seconds.
     * @param opts
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.Number toMilliseconds(final software.amazon.awscdk.core.TimeConversionOptions opts) {
        return this.jsiiCall("toMilliseconds", java.lang.Number.class, new Object[] { opts });
    }

    /**
     * @return the value of this `Duration` expressed in Seconds.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.Number toMilliseconds() {
        return this.jsiiCall("toMilliseconds", java.lang.Number.class);
    }

    /**
     * @return the value of this `Duration` expressed in Minutes.
     * @param opts
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.Number toMinutes(final software.amazon.awscdk.core.TimeConversionOptions opts) {
        return this.jsiiCall("toMinutes", java.lang.Number.class, new Object[] { opts });
    }

    /**
     * @return the value of this `Duration` expressed in Minutes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.Number toMinutes() {
        return this.jsiiCall("toMinutes", java.lang.Number.class);
    }

    /**
     * @return the value of this `Duration` expressed in Seconds.
     * @param opts
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.Number toSeconds(final software.amazon.awscdk.core.TimeConversionOptions opts) {
        return this.jsiiCall("toSeconds", java.lang.Number.class, new Object[] { opts });
    }

    /**
     * @return the value of this `Duration` expressed in Seconds.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.Number toSeconds() {
        return this.jsiiCall("toSeconds", java.lang.Number.class);
    }

    /**
     * Returns a string representation of this `Duration` that is also a Token that cannot be successfully resolved.
     * 
     * This
     * protects users against inadvertently stringifying a `Duration` object, when they should have called one of the
     * `to*` methods instead.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public java.lang.String toString() {
        return this.jsiiCall("toString", java.lang.String.class);
    }
}
