/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.core;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface ArnComponents
extends JsiiSerializable {
    public String getResource();

    public String getService();

    public String getAccount();

    public String getPartition();

    public String getRegion();

    public String getResourceName();

    public String getSep();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String _resource;
        private String _service;
        @Nullable
        private String _account;
        @Nullable
        private String _partition;
        @Nullable
        private String _region;
        @Nullable
        private String _resourceName;
        @Nullable
        private String _sep;

        public Builder withResource(String value) {
            this._resource = Objects.requireNonNull(value, "resource is required");
            return this;
        }

        public Builder withService(String value) {
            this._service = Objects.requireNonNull(value, "service is required");
            return this;
        }

        public Builder withAccount(@Nullable String value) {
            this._account = value;
            return this;
        }

        public Builder withPartition(@Nullable String value) {
            this._partition = value;
            return this;
        }

        public Builder withRegion(@Nullable String value) {
            this._region = value;
            return this;
        }

        public Builder withResourceName(@Nullable String value) {
            this._resourceName = value;
            return this;
        }

        public Builder withSep(@Nullable String value) {
            this._sep = value;
            return this;
        }

        public ArnComponents build() {
            return new ArnComponents(){
                private final String $resource;
                private final String $service;
                @Nullable
                private final String $account;
                @Nullable
                private final String $partition;
                @Nullable
                private final String $region;
                @Nullable
                private final String $resourceName;
                @Nullable
                private final String $sep;
                {
                    this.$resource = Objects.requireNonNull(_resource, "resource is required");
                    this.$service = Objects.requireNonNull(_service, "service is required");
                    this.$account = _account;
                    this.$partition = _partition;
                    this.$region = _region;
                    this.$resourceName = _resourceName;
                    this.$sep = _sep;
                }

                @Override
                public String getResource() {
                    return this.$resource;
                }

                @Override
                public String getService() {
                    return this.$service;
                }

                @Override
                public String getAccount() {
                    return this.$account;
                }

                @Override
                public String getPartition() {
                    return this.$partition;
                }

                @Override
                public String getRegion() {
                    return this.$region;
                }

                @Override
                public String getResourceName() {
                    return this.$resourceName;
                }

                @Override
                public String getSep() {
                    return this.$sep;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("resource", om.valueToTree((Object)this.getResource()));
                    obj.set("service", om.valueToTree((Object)this.getService()));
                    if (this.getAccount() != null) {
                        obj.set("account", om.valueToTree((Object)this.getAccount()));
                    }
                    if (this.getPartition() != null) {
                        obj.set("partition", om.valueToTree((Object)this.getPartition()));
                    }
                    if (this.getRegion() != null) {
                        obj.set("region", om.valueToTree((Object)this.getRegion()));
                    }
                    if (this.getResourceName() != null) {
                        obj.set("resourceName", om.valueToTree((Object)this.getResourceName()));
                    }
                    if (this.getSep() != null) {
                        obj.set("sep", om.valueToTree((Object)this.getSep()));
                    }
                    return obj;
                }
            };
        }
    }
}

