package software.amazon.awscdk.core;

/**
 * The deployment environment for a stack.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.13.3 (build 3624e0f)", date = "2019-07-04T19:18:56.697Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface Environment extends software.amazon.jsii.JsiiSerializable {
    /**
     * The AWS account ID for this environment.
     * 
     * This can be either a concrete value such as `585191031104` or `Aws.accountId` which
     * indicates that account ID will only be determined during deployment (it
     * will resolve to the CloudFormation intrinsic `{"Ref":"AWS::AccountId"}`).
     * Note that certain features, such as cross-stack references and
     * environmental context providers require concerete region information and
     * will cause this stack to emit synthesis errors.
     * 
     * Default: Aws.accountId which means that the stack will be account-agnostic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getAccount();
    /**
     * The AWS region for this environment.
     * 
     * This can be either a concrete value such as `eu-west-2` or `Aws.region`
     * which indicates that account ID will only be determined during deployment
     * (it will resolve to the CloudFormation intrinsic `{"Ref":"AWS::Region"}`).
     * Note that certain features, such as cross-stack references and
     * environmental context providers require concerete region information and
     * will cause this stack to emit synthesis errors.
     * 
     * Default: Aws.region which means that the stack will be region-agnostic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getRegion();

    /**
     * @return a {@link Builder} of {@link Environment}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link Environment}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        @javax.annotation.Nullable
        private java.lang.String _account;
        @javax.annotation.Nullable
        private java.lang.String _region;

        /**
         * Sets the value of Account
         * @param value The AWS account ID for this environment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withAccount(@javax.annotation.Nullable final java.lang.String value) {
            this._account = value;
            return this;
        }
        /**
         * Sets the value of Region
         * @param value The AWS region for this environment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withRegion(@javax.annotation.Nullable final java.lang.String value) {
            this._region = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link Environment}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Environment build() {
            return new Environment() {
                @javax.annotation.Nullable
                private final java.lang.String $account = _account;
                @javax.annotation.Nullable
                private final java.lang.String $region = _region;

                @Override
                public java.lang.String getAccount() {
                    return this.$account;
                }

                @Override
                public java.lang.String getRegion() {
                    return this.$region;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    if (this.getAccount() != null) {
                        obj.set("account", om.valueToTree(this.getAccount()));
                    }
                    if (this.getRegion() != null) {
                        obj.set("region", om.valueToTree(this.getRegion()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.core.Environment {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The AWS account ID for this environment.
         * 
         * This can be either a concrete value such as `585191031104` or `Aws.accountId` which
         * indicates that account ID will only be determined during deployment (it
         * will resolve to the CloudFormation intrinsic `{"Ref":"AWS::AccountId"}`).
         * Note that certain features, such as cross-stack references and
         * environmental context providers require concerete region information and
         * will cause this stack to emit synthesis errors.
         * 
         * Default: Aws.accountId which means that the stack will be account-agnostic.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getAccount() {
            return this.jsiiGet("account", java.lang.String.class);
        }

        /**
         * The AWS region for this environment.
         * 
         * This can be either a concrete value such as `eu-west-2` or `Aws.region`
         * which indicates that account ID will only be determined during deployment
         * (it will resolve to the CloudFormation intrinsic `{"Ref":"AWS::Region"}`).
         * Note that certain features, such as cross-stack references and
         * environmental context providers require concerete region information and
         * will cause this stack to emit synthesis errors.
         * 
         * Default: Aws.region which means that the stack will be region-agnostic.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getRegion() {
            return this.jsiiGet("region", java.lang.String.class);
        }
    }
}
