package software.amazon.awscdk.core;

/**
 * Use the UpdatePolicy attribute to specify how AWS CloudFormation handles updates to the AWS::AutoScaling::AutoScalingGroup resource.
 * 
 * AWS CloudFormation invokes one of three update policies depending on the type of change you make or whether a
 * scheduled action is associated with the Auto Scaling group.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.13.3 (build 3624e0f)", date = "2019-07-03T12:00:49.681Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnUpdatePolicy extends software.amazon.jsii.JsiiSerializable {
    /**
     * Specifies whether an Auto Scaling group and the instances it contains are replaced during an update.
     * 
     * During replacement,
     * AWS CloudFormation retains the old group until it finishes creating the new one. If the update fails, AWS CloudFormation
     * can roll back to the old Auto Scaling group and delete the new Auto Scaling group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.core.CfnAutoScalingReplacingUpdate getAutoScalingReplacingUpdate();
    /**
     * To specify how AWS CloudFormation handles rolling updates for an Auto Scaling group, use the AutoScalingRollingUpdate policy.
     * 
     * Rolling updates enable you to specify whether AWS CloudFormation updates instances that are in an Auto Scaling
     * group in batches or all at once.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.core.CfnAutoScalingRollingUpdate getAutoScalingRollingUpdate();
    /**
     * To specify how AWS CloudFormation handles updates for the MinSize, MaxSize, and DesiredCapacity properties when the AWS::AutoScaling::AutoScalingGroup resource has an associated scheduled action, use the AutoScalingScheduledAction policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.core.CfnAutoScalingScheduledAction getAutoScalingScheduledAction();
    /**
     * To perform an AWS CodeDeploy deployment when the version changes on an AWS::Lambda::Alias resource, use the CodeDeployLambdaAliasUpdate update policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.core.CfnCodeDeployLambdaAliasUpdate getCodeDeployLambdaAliasUpdate();
    /**
     * To modify a replication group's shards by adding or removing shards, rather than replacing the entire AWS::ElastiCache::ReplicationGroup resource, use the UseOnlineResharding update policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Boolean getUseOnlineResharding();

    /**
     * @return a {@link Builder} of {@link CfnUpdatePolicy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link CfnUpdatePolicy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        @javax.annotation.Nullable
        private software.amazon.awscdk.core.CfnAutoScalingReplacingUpdate _autoScalingReplacingUpdate;
        @javax.annotation.Nullable
        private software.amazon.awscdk.core.CfnAutoScalingRollingUpdate _autoScalingRollingUpdate;
        @javax.annotation.Nullable
        private software.amazon.awscdk.core.CfnAutoScalingScheduledAction _autoScalingScheduledAction;
        @javax.annotation.Nullable
        private software.amazon.awscdk.core.CfnCodeDeployLambdaAliasUpdate _codeDeployLambdaAliasUpdate;
        @javax.annotation.Nullable
        private java.lang.Boolean _useOnlineResharding;

        /**
         * Sets the value of AutoScalingReplacingUpdate
         * @param value Specifies whether an Auto Scaling group and the instances it contains are replaced during an update.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withAutoScalingReplacingUpdate(@javax.annotation.Nullable final software.amazon.awscdk.core.CfnAutoScalingReplacingUpdate value) {
            this._autoScalingReplacingUpdate = value;
            return this;
        }
        /**
         * Sets the value of AutoScalingRollingUpdate
         * @param value To specify how AWS CloudFormation handles rolling updates for an Auto Scaling group, use the AutoScalingRollingUpdate policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withAutoScalingRollingUpdate(@javax.annotation.Nullable final software.amazon.awscdk.core.CfnAutoScalingRollingUpdate value) {
            this._autoScalingRollingUpdate = value;
            return this;
        }
        /**
         * Sets the value of AutoScalingScheduledAction
         * @param value To specify how AWS CloudFormation handles updates for the MinSize, MaxSize, and DesiredCapacity properties when the AWS::AutoScaling::AutoScalingGroup resource has an associated scheduled action, use the AutoScalingScheduledAction policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withAutoScalingScheduledAction(@javax.annotation.Nullable final software.amazon.awscdk.core.CfnAutoScalingScheduledAction value) {
            this._autoScalingScheduledAction = value;
            return this;
        }
        /**
         * Sets the value of CodeDeployLambdaAliasUpdate
         * @param value To perform an AWS CodeDeploy deployment when the version changes on an AWS::Lambda::Alias resource, use the CodeDeployLambdaAliasUpdate update policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withCodeDeployLambdaAliasUpdate(@javax.annotation.Nullable final software.amazon.awscdk.core.CfnCodeDeployLambdaAliasUpdate value) {
            this._codeDeployLambdaAliasUpdate = value;
            return this;
        }
        /**
         * Sets the value of UseOnlineResharding
         * @param value To modify a replication group's shards by adding or removing shards, rather than replacing the entire AWS::ElastiCache::ReplicationGroup resource, use the UseOnlineResharding update policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withUseOnlineResharding(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._useOnlineResharding = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnUpdatePolicy}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public CfnUpdatePolicy build() {
            return new CfnUpdatePolicy() {
                @javax.annotation.Nullable
                private final software.amazon.awscdk.core.CfnAutoScalingReplacingUpdate $autoScalingReplacingUpdate = _autoScalingReplacingUpdate;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.core.CfnAutoScalingRollingUpdate $autoScalingRollingUpdate = _autoScalingRollingUpdate;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.core.CfnAutoScalingScheduledAction $autoScalingScheduledAction = _autoScalingScheduledAction;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.core.CfnCodeDeployLambdaAliasUpdate $codeDeployLambdaAliasUpdate = _codeDeployLambdaAliasUpdate;
                @javax.annotation.Nullable
                private final java.lang.Boolean $useOnlineResharding = _useOnlineResharding;

                @Override
                public software.amazon.awscdk.core.CfnAutoScalingReplacingUpdate getAutoScalingReplacingUpdate() {
                    return this.$autoScalingReplacingUpdate;
                }

                @Override
                public software.amazon.awscdk.core.CfnAutoScalingRollingUpdate getAutoScalingRollingUpdate() {
                    return this.$autoScalingRollingUpdate;
                }

                @Override
                public software.amazon.awscdk.core.CfnAutoScalingScheduledAction getAutoScalingScheduledAction() {
                    return this.$autoScalingScheduledAction;
                }

                @Override
                public software.amazon.awscdk.core.CfnCodeDeployLambdaAliasUpdate getCodeDeployLambdaAliasUpdate() {
                    return this.$codeDeployLambdaAliasUpdate;
                }

                @Override
                public java.lang.Boolean getUseOnlineResharding() {
                    return this.$useOnlineResharding;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    if (this.getAutoScalingReplacingUpdate() != null) {
                        obj.set("autoScalingReplacingUpdate", om.valueToTree(this.getAutoScalingReplacingUpdate()));
                    }
                    if (this.getAutoScalingRollingUpdate() != null) {
                        obj.set("autoScalingRollingUpdate", om.valueToTree(this.getAutoScalingRollingUpdate()));
                    }
                    if (this.getAutoScalingScheduledAction() != null) {
                        obj.set("autoScalingScheduledAction", om.valueToTree(this.getAutoScalingScheduledAction()));
                    }
                    if (this.getCodeDeployLambdaAliasUpdate() != null) {
                        obj.set("codeDeployLambdaAliasUpdate", om.valueToTree(this.getCodeDeployLambdaAliasUpdate()));
                    }
                    if (this.getUseOnlineResharding() != null) {
                        obj.set("useOnlineResharding", om.valueToTree(this.getUseOnlineResharding()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.core.CfnUpdatePolicy {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * Specifies whether an Auto Scaling group and the instances it contains are replaced during an update.
         * 
         * During replacement,
         * AWS CloudFormation retains the old group until it finishes creating the new one. If the update fails, AWS CloudFormation
         * can roll back to the old Auto Scaling group and delete the new Auto Scaling group.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.core.CfnAutoScalingReplacingUpdate getAutoScalingReplacingUpdate() {
            return this.jsiiGet("autoScalingReplacingUpdate", software.amazon.awscdk.core.CfnAutoScalingReplacingUpdate.class);
        }

        /**
         * To specify how AWS CloudFormation handles rolling updates for an Auto Scaling group, use the AutoScalingRollingUpdate policy.
         * 
         * Rolling updates enable you to specify whether AWS CloudFormation updates instances that are in an Auto Scaling
         * group in batches or all at once.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.core.CfnAutoScalingRollingUpdate getAutoScalingRollingUpdate() {
            return this.jsiiGet("autoScalingRollingUpdate", software.amazon.awscdk.core.CfnAutoScalingRollingUpdate.class);
        }

        /**
         * To specify how AWS CloudFormation handles updates for the MinSize, MaxSize, and DesiredCapacity properties when the AWS::AutoScaling::AutoScalingGroup resource has an associated scheduled action, use the AutoScalingScheduledAction policy.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.core.CfnAutoScalingScheduledAction getAutoScalingScheduledAction() {
            return this.jsiiGet("autoScalingScheduledAction", software.amazon.awscdk.core.CfnAutoScalingScheduledAction.class);
        }

        /**
         * To perform an AWS CodeDeploy deployment when the version changes on an AWS::Lambda::Alias resource, use the CodeDeployLambdaAliasUpdate update policy.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.core.CfnCodeDeployLambdaAliasUpdate getCodeDeployLambdaAliasUpdate() {
            return this.jsiiGet("codeDeployLambdaAliasUpdate", software.amazon.awscdk.core.CfnCodeDeployLambdaAliasUpdate.class);
        }

        /**
         * To modify a replication group's shards by adding or removing shards, rather than replacing the entire AWS::ElastiCache::ReplicationGroup resource, use the UseOnlineResharding update policy.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.Boolean getUseOnlineResharding() {
            return this.jsiiGet("useOnlineResharding", java.lang.Boolean.class);
        }
    }
}
