package software.amazon.awscdk.core;

/**
 * To perform an AWS CodeDeploy deployment when the version changes on an AWS::Lambda::Alias resource, use the CodeDeployLambdaAliasUpdate update policy.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.13.3 (build 3624e0f)", date = "2019-07-03T12:00:49.671Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnCodeDeployLambdaAliasUpdate extends software.amazon.jsii.JsiiSerializable {
    /**
     * The name of the AWS CodeDeploy application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getApplicationName();
    /**
     * The name of the AWS CodeDeploy deployment group.
     * 
     * This is where the traffic-shifting policy is set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getDeploymentGroupName();
    /**
     * The name of the Lambda function to run after traffic routing completes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getAfterAllowTrafficHook();
    /**
     * The name of the Lambda function to run before traffic routing starts.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getBeforeAllowTrafficHook();

    /**
     * @return a {@link Builder} of {@link CfnCodeDeployLambdaAliasUpdate}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link CfnCodeDeployLambdaAliasUpdate}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        private java.lang.String _applicationName;
        private java.lang.String _deploymentGroupName;
        @javax.annotation.Nullable
        private java.lang.String _afterAllowTrafficHook;
        @javax.annotation.Nullable
        private java.lang.String _beforeAllowTrafficHook;

        /**
         * Sets the value of ApplicationName
         * @param value The name of the AWS CodeDeploy application.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withApplicationName(final java.lang.String value) {
            this._applicationName = java.util.Objects.requireNonNull(value, "applicationName is required");
            return this;
        }
        /**
         * Sets the value of DeploymentGroupName
         * @param value The name of the AWS CodeDeploy deployment group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withDeploymentGroupName(final java.lang.String value) {
            this._deploymentGroupName = java.util.Objects.requireNonNull(value, "deploymentGroupName is required");
            return this;
        }
        /**
         * Sets the value of AfterAllowTrafficHook
         * @param value The name of the Lambda function to run after traffic routing completes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withAfterAllowTrafficHook(@javax.annotation.Nullable final java.lang.String value) {
            this._afterAllowTrafficHook = value;
            return this;
        }
        /**
         * Sets the value of BeforeAllowTrafficHook
         * @param value The name of the Lambda function to run before traffic routing starts.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withBeforeAllowTrafficHook(@javax.annotation.Nullable final java.lang.String value) {
            this._beforeAllowTrafficHook = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnCodeDeployLambdaAliasUpdate}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public CfnCodeDeployLambdaAliasUpdate build() {
            return new CfnCodeDeployLambdaAliasUpdate() {
                private final java.lang.String $applicationName = java.util.Objects.requireNonNull(_applicationName, "applicationName is required");
                private final java.lang.String $deploymentGroupName = java.util.Objects.requireNonNull(_deploymentGroupName, "deploymentGroupName is required");
                @javax.annotation.Nullable
                private final java.lang.String $afterAllowTrafficHook = _afterAllowTrafficHook;
                @javax.annotation.Nullable
                private final java.lang.String $beforeAllowTrafficHook = _beforeAllowTrafficHook;

                @Override
                public java.lang.String getApplicationName() {
                    return this.$applicationName;
                }

                @Override
                public java.lang.String getDeploymentGroupName() {
                    return this.$deploymentGroupName;
                }

                @Override
                public java.lang.String getAfterAllowTrafficHook() {
                    return this.$afterAllowTrafficHook;
                }

                @Override
                public java.lang.String getBeforeAllowTrafficHook() {
                    return this.$beforeAllowTrafficHook;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("applicationName", om.valueToTree(this.getApplicationName()));
                    obj.set("deploymentGroupName", om.valueToTree(this.getDeploymentGroupName()));
                    if (this.getAfterAllowTrafficHook() != null) {
                        obj.set("afterAllowTrafficHook", om.valueToTree(this.getAfterAllowTrafficHook()));
                    }
                    if (this.getBeforeAllowTrafficHook() != null) {
                        obj.set("beforeAllowTrafficHook", om.valueToTree(this.getBeforeAllowTrafficHook()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.core.CfnCodeDeployLambdaAliasUpdate {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The name of the AWS CodeDeploy application.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public java.lang.String getApplicationName() {
            return this.jsiiGet("applicationName", java.lang.String.class);
        }

        /**
         * The name of the AWS CodeDeploy deployment group.
         * 
         * This is where the traffic-shifting policy is set.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public java.lang.String getDeploymentGroupName() {
            return this.jsiiGet("deploymentGroupName", java.lang.String.class);
        }

        /**
         * The name of the Lambda function to run after traffic routing completes.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getAfterAllowTrafficHook() {
            return this.jsiiGet("afterAllowTrafficHook", java.lang.String.class);
        }

        /**
         * The name of the Lambda function to run before traffic routing starts.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getBeforeAllowTrafficHook() {
            return this.jsiiGet("beforeAllowTrafficHook", java.lang.String.class);
        }
    }
}
