package software.amazon.awscdk.services.codebuild;

/**
 * A CodeBuild GPU image running Linux.
 * <p>
 * This class has public constants that represent the most popular GPU images from AWS Deep Learning Containers.
 * <p>
 * @see https://aws.amazon.com/releasenotes/available-deep-learning-containers-images
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:32.923Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codebuild.$Module.class, fqn = "@aws-cdk/aws-codebuild.LinuxGpuBuildImage")
public class LinuxGpuBuildImage extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codebuild.IBindableBuildImage {

    protected LinuxGpuBuildImage(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected LinuxGpuBuildImage(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        DLC_MXNET_1_4_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxGpuBuildImage.class, "DLC_MXNET_1_4_1", software.amazon.awscdk.services.codebuild.IBuildImage.class);
        DLC_MXNET_1_6_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxGpuBuildImage.class, "DLC_MXNET_1_6_0", software.amazon.awscdk.services.codebuild.IBuildImage.class);
        DLC_PYTORCH_1_2_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxGpuBuildImage.class, "DLC_PYTORCH_1_2_0", software.amazon.awscdk.services.codebuild.IBuildImage.class);
        DLC_PYTORCH_1_3_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxGpuBuildImage.class, "DLC_PYTORCH_1_3_1", software.amazon.awscdk.services.codebuild.IBuildImage.class);
        DLC_PYTORCH_1_4_0_INFERENCE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxGpuBuildImage.class, "DLC_PYTORCH_1_4_0_INFERENCE", software.amazon.awscdk.services.codebuild.IBuildImage.class);
        DLC_PYTORCH_1_4_0_TRAINING = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxGpuBuildImage.class, "DLC_PYTORCH_1_4_0_TRAINING", software.amazon.awscdk.services.codebuild.IBuildImage.class);
        DLC_PYTORCH_1_5_0_INFERENCE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxGpuBuildImage.class, "DLC_PYTORCH_1_5_0_INFERENCE", software.amazon.awscdk.services.codebuild.IBuildImage.class);
        DLC_PYTORCH_1_5_0_TRAINING = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxGpuBuildImage.class, "DLC_PYTORCH_1_5_0_TRAINING", software.amazon.awscdk.services.codebuild.IBuildImage.class);
        DLC_TENSORFLOW_1_14_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxGpuBuildImage.class, "DLC_TENSORFLOW_1_14_0", software.amazon.awscdk.services.codebuild.IBuildImage.class);
        DLC_TENSORFLOW_1_15_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxGpuBuildImage.class, "DLC_TENSORFLOW_1_15_0", software.amazon.awscdk.services.codebuild.IBuildImage.class);
        DLC_TENSORFLOW_1_15_2_INFERENCE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxGpuBuildImage.class, "DLC_TENSORFLOW_1_15_2_INFERENCE", software.amazon.awscdk.services.codebuild.IBuildImage.class);
        DLC_TENSORFLOW_1_15_2_TRAINING = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxGpuBuildImage.class, "DLC_TENSORFLOW_1_15_2_TRAINING", software.amazon.awscdk.services.codebuild.IBuildImage.class);
        DLC_TENSORFLOW_2_0_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxGpuBuildImage.class, "DLC_TENSORFLOW_2_0_0", software.amazon.awscdk.services.codebuild.IBuildImage.class);
        DLC_TENSORFLOW_2_0_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxGpuBuildImage.class, "DLC_TENSORFLOW_2_0_1", software.amazon.awscdk.services.codebuild.IBuildImage.class);
        DLC_TENSORFLOW_2_1_0_INFERENCE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxGpuBuildImage.class, "DLC_TENSORFLOW_2_1_0_INFERENCE", software.amazon.awscdk.services.codebuild.IBuildImage.class);
        DLC_TENSORFLOW_2_1_0_TRAINING = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxGpuBuildImage.class, "DLC_TENSORFLOW_2_1_0_TRAINING", software.amazon.awscdk.services.codebuild.IBuildImage.class);
        DLC_TENSORFLOW_2_2_0_TRAINING = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.LinuxGpuBuildImage.class, "DLC_TENSORFLOW_2_2_0_TRAINING", software.amazon.awscdk.services.codebuild.IBuildImage.class);
    }

    /**
     * Returns a Linux GPU build image from AWS Deep Learning Containers.
     * <p>
     * @see https://aws.amazon.com/releasenotes/available-deep-learning-containers-images
     * @param repositoryName the name of the repository, for example "pytorch-inference". This parameter is required.
     * @param tag the tag of the image, for example "1.5.0-gpu-py36-cu101-ubuntu16.04". This parameter is required.
     * @param account the AWS account ID where the DLC repository for this region is hosted in.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.IBuildImage awsDeepLearningContainersImage(final @org.jetbrains.annotations.NotNull java.lang.String repositoryName, final @org.jetbrains.annotations.NotNull java.lang.String tag, final @org.jetbrains.annotations.Nullable java.lang.String account) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codebuild.LinuxGpuBuildImage.class, "awsDeepLearningContainersImage", software.amazon.awscdk.services.codebuild.IBuildImage.class, new Object[] { java.util.Objects.requireNonNull(repositoryName, "repositoryName is required"), java.util.Objects.requireNonNull(tag, "tag is required"), account });
    }

    /**
     * Returns a Linux GPU build image from AWS Deep Learning Containers.
     * <p>
     * @see https://aws.amazon.com/releasenotes/available-deep-learning-containers-images
     * @param repositoryName the name of the repository, for example "pytorch-inference". This parameter is required.
     * @param tag the tag of the image, for example "1.5.0-gpu-py36-cu101-ubuntu16.04". This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.IBuildImage awsDeepLearningContainersImage(final @org.jetbrains.annotations.NotNull java.lang.String repositoryName, final @org.jetbrains.annotations.NotNull java.lang.String tag) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codebuild.LinuxGpuBuildImage.class, "awsDeepLearningContainersImage", software.amazon.awscdk.services.codebuild.IBuildImage.class, new Object[] { java.util.Objects.requireNonNull(repositoryName, "repositoryName is required"), java.util.Objects.requireNonNull(tag, "tag is required") });
    }

    /**
     * Function that allows the build image access to the construct tree.
     * <p>
     * @param scope This parameter is required.
     * @param project This parameter is required.
     * @param _options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.BuildImageConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.IProject project, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.BuildImageBindOptions _options) {
        return this.jsiiCall("bind", software.amazon.awscdk.services.codebuild.BuildImageConfig.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(project, "project is required"), java.util.Objects.requireNonNull(_options, "_options is required") });
    }

    /**
     * Make a buildspec to run the indicated script.
     * <p>
     * @param entrypoint This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.BuildSpec runScriptBuildspec(final @org.jetbrains.annotations.NotNull java.lang.String entrypoint) {
        return this.jsiiCall("runScriptBuildspec", software.amazon.awscdk.services.codebuild.BuildSpec.class, new Object[] { java.util.Objects.requireNonNull(entrypoint, "entrypoint is required") });
    }

    /**
     * Allows the image a chance to validate whether the passed configuration is correct.
     * <p>
     * @param buildEnvironment This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> validate(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.BuildEnvironment buildEnvironment) {
        return java.util.Collections.unmodifiableList(this.jsiiCall("validate", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)), new Object[] { java.util.Objects.requireNonNull(buildEnvironment, "buildEnvironment is required") }));
    }

    /**
     * MXNet 1.4.1 GPU image from AWS Deep Learning Containers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.codebuild.IBuildImage DLC_MXNET_1_4_1;

    /**
     * MXNet 1.6.0 GPU image from AWS Deep Learning Containers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.codebuild.IBuildImage DLC_MXNET_1_6_0;

    /**
     * PyTorch 1.2.0 GPU image from AWS Deep Learning Containers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.codebuild.IBuildImage DLC_PYTORCH_1_2_0;

    /**
     * PyTorch 1.3.1 GPU image from AWS Deep Learning Containers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.codebuild.IBuildImage DLC_PYTORCH_1_3_1;

    /**
     * PyTorch 1.4.0 GPU inference image from AWS Deep Learning Containers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.codebuild.IBuildImage DLC_PYTORCH_1_4_0_INFERENCE;

    /**
     * PyTorch 1.4.0 GPU training image from AWS Deep Learning Containers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.codebuild.IBuildImage DLC_PYTORCH_1_4_0_TRAINING;

    /**
     * PyTorch 1.5.0 GPU inference image from AWS Deep Learning Containers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.codebuild.IBuildImage DLC_PYTORCH_1_5_0_INFERENCE;

    /**
     * PyTorch 1.5.0 GPU training image from AWS Deep Learning Containers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.codebuild.IBuildImage DLC_PYTORCH_1_5_0_TRAINING;

    /**
     * Tensorflow 1.14.0 GPU image from AWS Deep Learning Containers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.codebuild.IBuildImage DLC_TENSORFLOW_1_14_0;

    /**
     * Tensorflow 1.15.0 GPU image from AWS Deep Learning Containers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.codebuild.IBuildImage DLC_TENSORFLOW_1_15_0;

    /**
     * Tensorflow 1.15.2 GPU inference image from AWS Deep Learning Containers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.codebuild.IBuildImage DLC_TENSORFLOW_1_15_2_INFERENCE;

    /**
     * Tensorflow 1.15.2 GPU training image from AWS Deep Learning Containers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.codebuild.IBuildImage DLC_TENSORFLOW_1_15_2_TRAINING;

    /**
     * Tensorflow 2.0.0 GPU image from AWS Deep Learning Containers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.codebuild.IBuildImage DLC_TENSORFLOW_2_0_0;

    /**
     * Tensorflow 2.0.1 GPU image from AWS Deep Learning Containers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.codebuild.IBuildImage DLC_TENSORFLOW_2_0_1;

    /**
     * Tensorflow 2.1.0 GPU inference image from AWS Deep Learning Containers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.codebuild.IBuildImage DLC_TENSORFLOW_2_1_0_INFERENCE;

    /**
     * Tensorflow 2.1.0 GPU training image from AWS Deep Learning Containers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.codebuild.IBuildImage DLC_TENSORFLOW_2_1_0_TRAINING;

    /**
     * Tensorflow 2.2.0 GPU training image from AWS Deep Learning Containers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.codebuild.IBuildImage DLC_TENSORFLOW_2_2_0_TRAINING;

    /**
     * The default {@link ComputeType} to use with this image, if one was not specified in {@link BuildEnvironment#computeType} explicitly.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.ComputeType getDefaultComputeType() {
        return this.jsiiGet("defaultComputeType", software.amazon.awscdk.services.codebuild.ComputeType.class);
    }

    /**
     * The Docker image identifier that the build environment uses.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getImageId() {
        return this.jsiiGet("imageId", java.lang.String.class);
    }

    /**
     * The type of build environment.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getType() {
        return this.jsiiGet("type", java.lang.String.class);
    }

    /**
     * The type of principal that CodeBuild will use to pull this build Docker image.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.ImagePullPrincipalType getImagePullPrincipalType() {
        return this.jsiiGet("imagePullPrincipalType", software.amazon.awscdk.services.codebuild.ImagePullPrincipalType.class);
    }
}
