package software.amazon.awscdk.services.codebuild;

/**
 * Information about logs for the build project.
 * <p>
 * A project can create logs in Amazon CloudWatch Logs, an S3 bucket, or both.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Project.Builder.create(this, "Project")
 *         .logging(LoggingOptions.builder()
 *                 .cloudWatch(CloudWatchLoggingOptions.builder()
 *                         .logGroup(new LogGroup(this, "MyLogGroup"))
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-16T18:50:31.137Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codebuild.$Module.class, fqn = "@aws-cdk/aws-codebuild.LoggingOptions")
@software.amazon.jsii.Jsii.Proxy(LoggingOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LoggingOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Information about Amazon CloudWatch Logs for a build project.
     * <p>
     * Default: - enabled
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.CloudWatchLoggingOptions getCloudWatch() {
        return null;
    }

    /**
     * Information about logs built to an S3 bucket for a build project.
     * <p>
     * Default: - disabled
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.S3LoggingOptions getS3() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link LoggingOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LoggingOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<LoggingOptions> {
        software.amazon.awscdk.services.codebuild.CloudWatchLoggingOptions cloudWatch;
        software.amazon.awscdk.services.codebuild.S3LoggingOptions s3;

        /**
         * Sets the value of {@link LoggingOptions#getCloudWatch}
         * @param cloudWatch Information about Amazon CloudWatch Logs for a build project.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudWatch(software.amazon.awscdk.services.codebuild.CloudWatchLoggingOptions cloudWatch) {
            this.cloudWatch = cloudWatch;
            return this;
        }

        /**
         * Sets the value of {@link LoggingOptions#getS3}
         * @param s3 Information about logs built to an S3 bucket for a build project.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3(software.amazon.awscdk.services.codebuild.S3LoggingOptions s3) {
            this.s3 = s3;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LoggingOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public LoggingOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link LoggingOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LoggingOptions {
        private final software.amazon.awscdk.services.codebuild.CloudWatchLoggingOptions cloudWatch;
        private final software.amazon.awscdk.services.codebuild.S3LoggingOptions s3;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.cloudWatch = software.amazon.jsii.Kernel.get(this, "cloudWatch", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.CloudWatchLoggingOptions.class));
            this.s3 = software.amazon.jsii.Kernel.get(this, "s3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codebuild.S3LoggingOptions.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.cloudWatch = builder.cloudWatch;
            this.s3 = builder.s3;
        }

        @Override
        public final software.amazon.awscdk.services.codebuild.CloudWatchLoggingOptions getCloudWatch() {
            return this.cloudWatch;
        }

        @Override
        public final software.amazon.awscdk.services.codebuild.S3LoggingOptions getS3() {
            return this.s3;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCloudWatch() != null) {
                data.set("cloudWatch", om.valueToTree(this.getCloudWatch()));
            }
            if (this.getS3() != null) {
                data.set("s3", om.valueToTree(this.getS3()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-codebuild.LoggingOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LoggingOptions.Jsii$Proxy that = (LoggingOptions.Jsii$Proxy) o;

            if (this.cloudWatch != null ? !this.cloudWatch.equals(that.cloudWatch) : that.cloudWatch != null) return false;
            return this.s3 != null ? this.s3.equals(that.s3) : that.s3 == null;
        }

        @Override
        public final int hashCode() {
            int result = this.cloudWatch != null ? this.cloudWatch.hashCode() : 0;
            result = 31 * result + (this.s3 != null ? this.s3.hashCode() : 0);
            return result;
        }
    }
}
