package software.amazon.awscdk.cloudassembly.schema;

/**
 * Artifact properties for CloudFormation stacks.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:24:16.906Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.cloudassembly.schema.$Module.class, fqn = "@aws-cdk/cloud-assembly-schema.AwsCloudFormationStackProperties")
@software.amazon.jsii.Jsii.Proxy(AwsCloudFormationStackProperties.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AwsCloudFormationStackProperties extends software.amazon.jsii.JsiiSerializable {

    /**
     * A file relative to the assembly root which contains the CloudFormation template for this stack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTemplateFile();

    /**
     * The role that needs to be assumed to deploy the stack.
     * <p>
     * Default: - No role is assumed (current credentials are used)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAssumeRoleArn() {
        return null;
    }

    /**
     * The role that is passed to CloudFormation to execute the change set.
     * <p>
     * Default: - No role is passed (currently assumed role/credentials are used)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCloudFormationExecutionRoleArn() {
        return null;
    }

    /**
     * Values for CloudFormation stack parameters that should be passed when the stack is deployed.
     * <p>
     * Default: - No parameters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getParameters() {
        return null;
    }

    /**
     * Version of bootstrap stack required to deploy this stack.
     * <p>
     * Default: - No bootstrap stack required
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getRequiresBootstrapStackVersion() {
        return null;
    }

    /**
     * The name to use for the CloudFormation stack.
     * <p>
     * Default: - name derived from artifact ID
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStackName() {
        return null;
    }

    /**
     * If the stack template has already been included in the asset manifest, its asset URL.
     * <p>
     * Default: - Not uploaded yet, upload just before deploying
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStackTemplateAssetObjectUrl() {
        return null;
    }

    /**
     * Whether to enable termination protection for this stack.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getTerminationProtection() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AwsCloudFormationStackProperties}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AwsCloudFormationStackProperties}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AwsCloudFormationStackProperties> {
        private java.lang.String templateFile;
        private java.lang.String assumeRoleArn;
        private java.lang.String cloudFormationExecutionRoleArn;
        private java.util.Map<java.lang.String, java.lang.String> parameters;
        private java.lang.Number requiresBootstrapStackVersion;
        private java.lang.String stackName;
        private java.lang.String stackTemplateAssetObjectUrl;
        private java.lang.Boolean terminationProtection;

        /**
         * Sets the value of {@link AwsCloudFormationStackProperties#getTemplateFile}
         * @param templateFile A file relative to the assembly root which contains the CloudFormation template for this stack. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder templateFile(java.lang.String templateFile) {
            this.templateFile = templateFile;
            return this;
        }

        /**
         * Sets the value of {@link AwsCloudFormationStackProperties#getAssumeRoleArn}
         * @param assumeRoleArn The role that needs to be assumed to deploy the stack.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assumeRoleArn(java.lang.String assumeRoleArn) {
            this.assumeRoleArn = assumeRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link AwsCloudFormationStackProperties#getCloudFormationExecutionRoleArn}
         * @param cloudFormationExecutionRoleArn The role that is passed to CloudFormation to execute the change set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudFormationExecutionRoleArn(java.lang.String cloudFormationExecutionRoleArn) {
            this.cloudFormationExecutionRoleArn = cloudFormationExecutionRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link AwsCloudFormationStackProperties#getParameters}
         * @param parameters Values for CloudFormation stack parameters that should be passed when the stack is deployed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(java.util.Map<java.lang.String, java.lang.String> parameters) {
            this.parameters = parameters;
            return this;
        }

        /**
         * Sets the value of {@link AwsCloudFormationStackProperties#getRequiresBootstrapStackVersion}
         * @param requiresBootstrapStackVersion Version of bootstrap stack required to deploy this stack.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requiresBootstrapStackVersion(java.lang.Number requiresBootstrapStackVersion) {
            this.requiresBootstrapStackVersion = requiresBootstrapStackVersion;
            return this;
        }

        /**
         * Sets the value of {@link AwsCloudFormationStackProperties#getStackName}
         * @param stackName The name to use for the CloudFormation stack.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stackName(java.lang.String stackName) {
            this.stackName = stackName;
            return this;
        }

        /**
         * Sets the value of {@link AwsCloudFormationStackProperties#getStackTemplateAssetObjectUrl}
         * @param stackTemplateAssetObjectUrl If the stack template has already been included in the asset manifest, its asset URL.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stackTemplateAssetObjectUrl(java.lang.String stackTemplateAssetObjectUrl) {
            this.stackTemplateAssetObjectUrl = stackTemplateAssetObjectUrl;
            return this;
        }

        /**
         * Sets the value of {@link AwsCloudFormationStackProperties#getTerminationProtection}
         * @param terminationProtection Whether to enable termination protection for this stack.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder terminationProtection(java.lang.Boolean terminationProtection) {
            this.terminationProtection = terminationProtection;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AwsCloudFormationStackProperties}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AwsCloudFormationStackProperties build() {
            return new Jsii$Proxy(templateFile, assumeRoleArn, cloudFormationExecutionRoleArn, parameters, requiresBootstrapStackVersion, stackName, stackTemplateAssetObjectUrl, terminationProtection);
        }
    }

    /**
     * An implementation for {@link AwsCloudFormationStackProperties}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AwsCloudFormationStackProperties {
        private final java.lang.String templateFile;
        private final java.lang.String assumeRoleArn;
        private final java.lang.String cloudFormationExecutionRoleArn;
        private final java.util.Map<java.lang.String, java.lang.String> parameters;
        private final java.lang.Number requiresBootstrapStackVersion;
        private final java.lang.String stackName;
        private final java.lang.String stackTemplateAssetObjectUrl;
        private final java.lang.Boolean terminationProtection;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.templateFile = this.jsiiGet("templateFile", java.lang.String.class);
            this.assumeRoleArn = this.jsiiGet("assumeRoleArn", java.lang.String.class);
            this.cloudFormationExecutionRoleArn = this.jsiiGet("cloudFormationExecutionRoleArn", java.lang.String.class);
            this.parameters = this.jsiiGet("parameters", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.requiresBootstrapStackVersion = this.jsiiGet("requiresBootstrapStackVersion", java.lang.Number.class);
            this.stackName = this.jsiiGet("stackName", java.lang.String.class);
            this.stackTemplateAssetObjectUrl = this.jsiiGet("stackTemplateAssetObjectUrl", java.lang.String.class);
            this.terminationProtection = this.jsiiGet("terminationProtection", java.lang.Boolean.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String templateFile, final java.lang.String assumeRoleArn, final java.lang.String cloudFormationExecutionRoleArn, final java.util.Map<java.lang.String, java.lang.String> parameters, final java.lang.Number requiresBootstrapStackVersion, final java.lang.String stackName, final java.lang.String stackTemplateAssetObjectUrl, final java.lang.Boolean terminationProtection) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.templateFile = java.util.Objects.requireNonNull(templateFile, "templateFile is required");
            this.assumeRoleArn = assumeRoleArn;
            this.cloudFormationExecutionRoleArn = cloudFormationExecutionRoleArn;
            this.parameters = parameters;
            this.requiresBootstrapStackVersion = requiresBootstrapStackVersion;
            this.stackName = stackName;
            this.stackTemplateAssetObjectUrl = stackTemplateAssetObjectUrl;
            this.terminationProtection = terminationProtection;
        }

        @Override
        public java.lang.String getTemplateFile() {
            return this.templateFile;
        }

        @Override
        public java.lang.String getAssumeRoleArn() {
            return this.assumeRoleArn;
        }

        @Override
        public java.lang.String getCloudFormationExecutionRoleArn() {
            return this.cloudFormationExecutionRoleArn;
        }

        @Override
        public java.util.Map<java.lang.String, java.lang.String> getParameters() {
            return this.parameters;
        }

        @Override
        public java.lang.Number getRequiresBootstrapStackVersion() {
            return this.requiresBootstrapStackVersion;
        }

        @Override
        public java.lang.String getStackName() {
            return this.stackName;
        }

        @Override
        public java.lang.String getStackTemplateAssetObjectUrl() {
            return this.stackTemplateAssetObjectUrl;
        }

        @Override
        public java.lang.Boolean getTerminationProtection() {
            return this.terminationProtection;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("templateFile", om.valueToTree(this.getTemplateFile()));
            if (this.getAssumeRoleArn() != null) {
                data.set("assumeRoleArn", om.valueToTree(this.getAssumeRoleArn()));
            }
            if (this.getCloudFormationExecutionRoleArn() != null) {
                data.set("cloudFormationExecutionRoleArn", om.valueToTree(this.getCloudFormationExecutionRoleArn()));
            }
            if (this.getParameters() != null) {
                data.set("parameters", om.valueToTree(this.getParameters()));
            }
            if (this.getRequiresBootstrapStackVersion() != null) {
                data.set("requiresBootstrapStackVersion", om.valueToTree(this.getRequiresBootstrapStackVersion()));
            }
            if (this.getStackName() != null) {
                data.set("stackName", om.valueToTree(this.getStackName()));
            }
            if (this.getStackTemplateAssetObjectUrl() != null) {
                data.set("stackTemplateAssetObjectUrl", om.valueToTree(this.getStackTemplateAssetObjectUrl()));
            }
            if (this.getTerminationProtection() != null) {
                data.set("terminationProtection", om.valueToTree(this.getTerminationProtection()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/cloud-assembly-schema.AwsCloudFormationStackProperties"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AwsCloudFormationStackProperties.Jsii$Proxy that = (AwsCloudFormationStackProperties.Jsii$Proxy) o;

            if (!templateFile.equals(that.templateFile)) return false;
            if (this.assumeRoleArn != null ? !this.assumeRoleArn.equals(that.assumeRoleArn) : that.assumeRoleArn != null) return false;
            if (this.cloudFormationExecutionRoleArn != null ? !this.cloudFormationExecutionRoleArn.equals(that.cloudFormationExecutionRoleArn) : that.cloudFormationExecutionRoleArn != null) return false;
            if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) return false;
            if (this.requiresBootstrapStackVersion != null ? !this.requiresBootstrapStackVersion.equals(that.requiresBootstrapStackVersion) : that.requiresBootstrapStackVersion != null) return false;
            if (this.stackName != null ? !this.stackName.equals(that.stackName) : that.stackName != null) return false;
            if (this.stackTemplateAssetObjectUrl != null ? !this.stackTemplateAssetObjectUrl.equals(that.stackTemplateAssetObjectUrl) : that.stackTemplateAssetObjectUrl != null) return false;
            return this.terminationProtection != null ? this.terminationProtection.equals(that.terminationProtection) : that.terminationProtection == null;
        }

        @Override
        public int hashCode() {
            int result = this.templateFile.hashCode();
            result = 31 * result + (this.assumeRoleArn != null ? this.assumeRoleArn.hashCode() : 0);
            result = 31 * result + (this.cloudFormationExecutionRoleArn != null ? this.cloudFormationExecutionRoleArn.hashCode() : 0);
            result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
            result = 31 * result + (this.requiresBootstrapStackVersion != null ? this.requiresBootstrapStackVersion.hashCode() : 0);
            result = 31 * result + (this.stackName != null ? this.stackName.hashCode() : 0);
            result = 31 * result + (this.stackTemplateAssetObjectUrl != null ? this.stackTemplateAssetObjectUrl.hashCode() : 0);
            result = 31 * result + (this.terminationProtection != null ? this.terminationProtection.hashCode() : 0);
            return result;
        }
    }
}
