package software.amazon.awscdk.cloudassembly.schema;

/**
 * Options for the loadManifest operation.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.cloudassembly.schema.*;
 * LoadManifestOptions loadManifestOptions = LoadManifestOptions.builder()
 *         .skipEnumCheck(false)
 *         .skipVersionCheck(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-28T18:14:31.696Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.cloudassembly.schema.$Module.class, fqn = "@aws-cdk/cloud-assembly-schema.LoadManifestOptions")
@software.amazon.jsii.Jsii.Proxy(LoadManifestOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LoadManifestOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Skip enum checks.
     * <p>
     * This means you may read enum values you don't know about yet. Make sure to always
     * check the values of enums you encounter in the manifest.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getSkipEnumCheck() {
        return null;
    }

    /**
     * Skip the version check.
     * <p>
     * This means you may read a newer cloud assembly than the CX API is designed
     * to support, and your application may not be aware of all features that in use
     * in the Cloud Assembly.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getSkipVersionCheck() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link LoadManifestOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LoadManifestOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<LoadManifestOptions> {
        java.lang.Boolean skipEnumCheck;
        java.lang.Boolean skipVersionCheck;

        /**
         * Sets the value of {@link LoadManifestOptions#getSkipEnumCheck}
         * @param skipEnumCheck Skip enum checks.
         *                      This means you may read enum values you don't know about yet. Make sure to always
         *                      check the values of enums you encounter in the manifest.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder skipEnumCheck(java.lang.Boolean skipEnumCheck) {
            this.skipEnumCheck = skipEnumCheck;
            return this;
        }

        /**
         * Sets the value of {@link LoadManifestOptions#getSkipVersionCheck}
         * @param skipVersionCheck Skip the version check.
         *                         This means you may read a newer cloud assembly than the CX API is designed
         *                         to support, and your application may not be aware of all features that in use
         *                         in the Cloud Assembly.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder skipVersionCheck(java.lang.Boolean skipVersionCheck) {
            this.skipVersionCheck = skipVersionCheck;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LoadManifestOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public LoadManifestOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link LoadManifestOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LoadManifestOptions {
        private final java.lang.Boolean skipEnumCheck;
        private final java.lang.Boolean skipVersionCheck;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.skipEnumCheck = software.amazon.jsii.Kernel.get(this, "skipEnumCheck", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.skipVersionCheck = software.amazon.jsii.Kernel.get(this, "skipVersionCheck", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.skipEnumCheck = builder.skipEnumCheck;
            this.skipVersionCheck = builder.skipVersionCheck;
        }

        @Override
        public final java.lang.Boolean getSkipEnumCheck() {
            return this.skipEnumCheck;
        }

        @Override
        public final java.lang.Boolean getSkipVersionCheck() {
            return this.skipVersionCheck;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getSkipEnumCheck() != null) {
                data.set("skipEnumCheck", om.valueToTree(this.getSkipEnumCheck()));
            }
            if (this.getSkipVersionCheck() != null) {
                data.set("skipVersionCheck", om.valueToTree(this.getSkipVersionCheck()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/cloud-assembly-schema.LoadManifestOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LoadManifestOptions.Jsii$Proxy that = (LoadManifestOptions.Jsii$Proxy) o;

            if (this.skipEnumCheck != null ? !this.skipEnumCheck.equals(that.skipEnumCheck) : that.skipEnumCheck != null) return false;
            return this.skipVersionCheck != null ? this.skipVersionCheck.equals(that.skipVersionCheck) : that.skipVersionCheck == null;
        }

        @Override
        public final int hashCode() {
            int result = this.skipEnumCheck != null ? this.skipEnumCheck.hashCode() : 0;
            result = 31 * result + (this.skipVersionCheck != null ? this.skipVersionCheck.hashCode() : 0);
            return result;
        }
    }
}
