package software.amazon.awscdk.assets;

/**
 * Stages a file or directory from a location on the file system into a staging directory.
 * 
 * This is controlled by the context key 'aws:cdk:asset-staging' and enabled
 * by the CLI by default in order to ensure that when the CDK app exists, all
 * assets are available for deployment. Otherwise, if an app references assets
 * in temporary locations, those will not be available when it exists (see
 * https://github.com/awslabs/aws-cdk/issues/1716).
 * 
 * The `stagedPath` property is a stringified token that represents the location
 * of the file or directory after staging. It will be resolved only during the
 * "prepare" stage and may be either the original path or the staged path
 * depending on the context setting.
 * 
 * The file/directory are staged based on their content hash (fingerprint). This
 * means that only if content was changed, copy will happen.
 * 
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.13.2 (build a2116e9)", date = "2019-07-01T16:48:59.513Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.assets.$Module.class, fqn = "@aws-cdk/assets.Staging")
public class Staging extends software.amazon.awscdk.core.Construct {
    protected Staging(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    /**
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public Staging(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.assets.StagingProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Allows this construct to emit artifacts into the cloud assembly during synthesis.
     * 
     * This method is usually implemented by framework-level constructs such as `Stack` and `Asset`
     * as they participate in synthesizing the cloud assembly.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    protected void synthesize(final software.amazon.awscdk.core.ISynthesisSession session) {
        this.jsiiCall("synthesize", Void.class, new Object[] { java.util.Objects.requireNonNull(session, "session is required") });
    }

    /**
     * A cryptographic hash of the source document(s).
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public java.lang.String getSourceHash() {
        return this.jsiiGet("sourceHash", java.lang.String.class);
    }

    /**
     * The path of the asset as it was referenced by the user.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public java.lang.String getSourcePath() {
        return this.jsiiGet("sourcePath", java.lang.String.class);
    }

    /**
     * The path to the asset (stringinfied token).
     * 
     * If asset staging is disabled, this will just be the original path.
     * If asset staging is enabled it will be the staged path.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public java.lang.String getStagedPath() {
        return this.jsiiGet("stagedPath", java.lang.String.class);
    }
}
