package software.amazon.awscdk.services.wisdom;

/**
 * Creates an Amazon Q in Connect message template.
 * <p>
 * The name of the message template has to be unique for each knowledge base. The channel subtype of the message template is immutable and cannot be modified after creation. After the message template is created, you can use the <code>$LATEST</code> qualifier to reference the created message template.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.wisdom.*;
 * CfnMessageTemplate cfnMessageTemplate = CfnMessageTemplate.Builder.create(this, "MyCfnMessageTemplate")
 *         .channelSubtype("channelSubtype")
 *         .content(ContentProperty.builder()
 *                 .emailMessageTemplateContent(EmailMessageTemplateContentProperty.builder()
 *                         .body(EmailMessageTemplateContentBodyProperty.builder()
 *                                 .html(MessageTemplateBodyContentProviderProperty.builder()
 *                                         .content("content")
 *                                         .build())
 *                                 .plainText(MessageTemplateBodyContentProviderProperty.builder()
 *                                         .content("content")
 *                                         .build())
 *                                 .build())
 *                         .headers(List.of(EmailMessageTemplateHeaderProperty.builder()
 *                                 .name("name")
 *                                 .value("value")
 *                                 .build()))
 *                         .subject("subject")
 *                         .build())
 *                 .smsMessageTemplateContent(SmsMessageTemplateContentProperty.builder()
 *                         .body(SmsMessageTemplateContentBodyProperty.builder()
 *                                 .plainText(MessageTemplateBodyContentProviderProperty.builder()
 *                                         .content("content")
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .knowledgeBaseArn("knowledgeBaseArn")
 *         .name("name")
 *         // the properties below are optional
 *         .defaultAttributes(MessageTemplateAttributesProperty.builder()
 *                 .agentAttributes(AgentAttributesProperty.builder()
 *                         .firstName("firstName")
 *                         .lastName("lastName")
 *                         .build())
 *                 .customAttributes(Map.of(
 *                         "customAttributesKey", "customAttributes"))
 *                 .customerProfileAttributes(CustomerProfileAttributesProperty.builder()
 *                         .accountNumber("accountNumber")
 *                         .additionalInformation("additionalInformation")
 *                         .address1("address1")
 *                         .address2("address2")
 *                         .address3("address3")
 *                         .address4("address4")
 *                         .billingAddress1("billingAddress1")
 *                         .billingAddress2("billingAddress2")
 *                         .billingAddress3("billingAddress3")
 *                         .billingAddress4("billingAddress4")
 *                         .billingCity("billingCity")
 *                         .billingCountry("billingCountry")
 *                         .billingCounty("billingCounty")
 *                         .billingPostalCode("billingPostalCode")
 *                         .billingProvince("billingProvince")
 *                         .billingState("billingState")
 *                         .birthDate("birthDate")
 *                         .businessEmailAddress("businessEmailAddress")
 *                         .businessName("businessName")
 *                         .businessPhoneNumber("businessPhoneNumber")
 *                         .city("city")
 *                         .country("country")
 *                         .county("county")
 *                         .custom(Map.of(
 *                                 "customKey", "custom"))
 *                         .emailAddress("emailAddress")
 *                         .firstName("firstName")
 *                         .gender("gender")
 *                         .homePhoneNumber("homePhoneNumber")
 *                         .lastName("lastName")
 *                         .mailingAddress1("mailingAddress1")
 *                         .mailingAddress2("mailingAddress2")
 *                         .mailingAddress3("mailingAddress3")
 *                         .mailingAddress4("mailingAddress4")
 *                         .mailingCity("mailingCity")
 *                         .mailingCountry("mailingCountry")
 *                         .mailingCounty("mailingCounty")
 *                         .mailingPostalCode("mailingPostalCode")
 *                         .mailingProvince("mailingProvince")
 *                         .mailingState("mailingState")
 *                         .middleName("middleName")
 *                         .mobilePhoneNumber("mobilePhoneNumber")
 *                         .partyType("partyType")
 *                         .phoneNumber("phoneNumber")
 *                         .postalCode("postalCode")
 *                         .profileArn("profileArn")
 *                         .profileId("profileId")
 *                         .province("province")
 *                         .shippingAddress1("shippingAddress1")
 *                         .shippingAddress2("shippingAddress2")
 *                         .shippingAddress3("shippingAddress3")
 *                         .shippingAddress4("shippingAddress4")
 *                         .shippingCity("shippingCity")
 *                         .shippingCountry("shippingCountry")
 *                         .shippingCounty("shippingCounty")
 *                         .shippingPostalCode("shippingPostalCode")
 *                         .shippingProvince("shippingProvince")
 *                         .shippingState("shippingState")
 *                         .state("state")
 *                         .build())
 *                 .systemAttributes(SystemAttributesProperty.builder()
 *                         .customerEndpoint(SystemEndpointAttributesProperty.builder()
 *                                 .address("address")
 *                                 .build())
 *                         .name("name")
 *                         .systemEndpoint(SystemEndpointAttributesProperty.builder()
 *                                 .address("address")
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .description("description")
 *         .groupingConfiguration(GroupingConfigurationProperty.builder()
 *                 .criteria("criteria")
 *                 .values(List.of("values"))
 *                 .build())
 *         .language("language")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-messagetemplate.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-messagetemplate.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:22.397Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wisdom.CfnMessageTemplate")
public class CfnMessageTemplate extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnMessageTemplate(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnMessageTemplate(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.wisdom.CfnMessageTemplate.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnMessageTemplate(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.wisdom.CfnMessageTemplateProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the message template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrMessageTemplateArn() {
        return software.amazon.jsii.Kernel.get(this, "attrMessageTemplateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The checksum value of the message template content that is referenced by the <code>$LATEST</code> qualifier.
     * <p>
     * It can be returned in <code>MessageTemplateData</code> or <code>ExtendedMessageTemplateData</code> . It’s calculated by content, language, <code>defaultAttributes</code> and <code>Attachments</code> of the message template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrMessageTemplateContentSha256() {
        return software.amazon.jsii.Kernel.get(this, "attrMessageTemplateContentSha256", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identifier of the message template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrMessageTemplateId() {
        return software.amazon.jsii.Kernel.get(this, "attrMessageTemplateId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The channel subtype this message template applies to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getChannelSubtype() {
        return software.amazon.jsii.Kernel.get(this, "channelSubtype", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The channel subtype this message template applies to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setChannelSubtype(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "channelSubtype", java.util.Objects.requireNonNull(value, "channelSubtype is required"));
    }

    /**
     * The content of the message template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getContent() {
        return software.amazon.jsii.Kernel.get(this, "content", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The content of the message template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setContent(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "content", java.util.Objects.requireNonNull(value, "content is required"));
    }

    /**
     * The content of the message template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setContent(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.wisdom.CfnMessageTemplate.ContentProperty value) {
        software.amazon.jsii.Kernel.set(this, "content", java.util.Objects.requireNonNull(value, "content is required"));
    }

    /**
     * The Amazon Resource Name (ARN) of the knowledge base.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getKnowledgeBaseArn() {
        return software.amazon.jsii.Kernel.get(this, "knowledgeBaseArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the knowledge base.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKnowledgeBaseArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "knowledgeBaseArn", java.util.Objects.requireNonNull(value, "knowledgeBaseArn is required"));
    }

    /**
     * The name of the message template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the message template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * An object that specifies the default values to use for variables in the message template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDefaultAttributes() {
        return software.amazon.jsii.Kernel.get(this, "defaultAttributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An object that specifies the default values to use for variables in the message template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefaultAttributes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "defaultAttributes", value);
    }

    /**
     * An object that specifies the default values to use for variables in the message template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefaultAttributes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.wisdom.CfnMessageTemplate.MessageTemplateAttributesProperty value) {
        software.amazon.jsii.Kernel.set(this, "defaultAttributes", value);
    }

    /**
     * The description of the message template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The description of the message template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * The configuration information of the external data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getGroupingConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "groupingConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The configuration information of the external data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGroupingConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "groupingConfiguration", value);
    }

    /**
     * The configuration information of the external data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGroupingConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.wisdom.CfnMessageTemplate.GroupingConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "groupingConfiguration", value);
    }

    /**
     * The language code value for the language in which the quick response is written.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getLanguage() {
        return software.amazon.jsii.Kernel.get(this, "language", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The language code value for the language in which the quick response is written.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLanguage(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "language", value);
    }

    /**
     * The tags used to organize, track, or control access for this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The tags used to organize, track, or control access for this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * Information about an agent.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wisdom.*;
     * AgentAttributesProperty agentAttributesProperty = AgentAttributesProperty.builder()
     *         .firstName("firstName")
     *         .lastName("lastName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-agentattributes.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-agentattributes.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wisdom.CfnMessageTemplate.AgentAttributesProperty")
    @software.amazon.jsii.Jsii.Proxy(AgentAttributesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AgentAttributesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The agent’s first name as entered in their Amazon Connect user account.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-agentattributes.html#cfn-wisdom-messagetemplate-agentattributes-firstname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-agentattributes.html#cfn-wisdom-messagetemplate-agentattributes-firstname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFirstName() {
            return null;
        }

        /**
         * The agent’s last name as entered in their Amazon Connect user account.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-agentattributes.html#cfn-wisdom-messagetemplate-agentattributes-lastname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-agentattributes.html#cfn-wisdom-messagetemplate-agentattributes-lastname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLastName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AgentAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AgentAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AgentAttributesProperty> {
            java.lang.String firstName;
            java.lang.String lastName;

            /**
             * Sets the value of {@link AgentAttributesProperty#getFirstName}
             * @param firstName The agent’s first name as entered in their Amazon Connect user account.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder firstName(java.lang.String firstName) {
                this.firstName = firstName;
                return this;
            }

            /**
             * Sets the value of {@link AgentAttributesProperty#getLastName}
             * @param lastName The agent’s last name as entered in their Amazon Connect user account.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lastName(java.lang.String lastName) {
                this.lastName = lastName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AgentAttributesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AgentAttributesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AgentAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AgentAttributesProperty {
            private final java.lang.String firstName;
            private final java.lang.String lastName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.firstName = software.amazon.jsii.Kernel.get(this, "firstName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.lastName = software.amazon.jsii.Kernel.get(this, "lastName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.firstName = builder.firstName;
                this.lastName = builder.lastName;
            }

            @Override
            public final java.lang.String getFirstName() {
                return this.firstName;
            }

            @Override
            public final java.lang.String getLastName() {
                return this.lastName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getFirstName() != null) {
                    data.set("firstName", om.valueToTree(this.getFirstName()));
                }
                if (this.getLastName() != null) {
                    data.set("lastName", om.valueToTree(this.getLastName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wisdom.CfnMessageTemplate.AgentAttributesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AgentAttributesProperty.Jsii$Proxy that = (AgentAttributesProperty.Jsii$Proxy) o;

                if (this.firstName != null ? !this.firstName.equals(that.firstName) : that.firstName != null) return false;
                return this.lastName != null ? this.lastName.equals(that.lastName) : that.lastName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.firstName != null ? this.firstName.hashCode() : 0;
                result = 31 * result + (this.lastName != null ? this.lastName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The content of the message template.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wisdom.*;
     * ContentProperty contentProperty = ContentProperty.builder()
     *         .emailMessageTemplateContent(EmailMessageTemplateContentProperty.builder()
     *                 .body(EmailMessageTemplateContentBodyProperty.builder()
     *                         .html(MessageTemplateBodyContentProviderProperty.builder()
     *                                 .content("content")
     *                                 .build())
     *                         .plainText(MessageTemplateBodyContentProviderProperty.builder()
     *                                 .content("content")
     *                                 .build())
     *                         .build())
     *                 .headers(List.of(EmailMessageTemplateHeaderProperty.builder()
     *                         .name("name")
     *                         .value("value")
     *                         .build()))
     *                 .subject("subject")
     *                 .build())
     *         .smsMessageTemplateContent(SmsMessageTemplateContentProperty.builder()
     *                 .body(SmsMessageTemplateContentBodyProperty.builder()
     *                         .plainText(MessageTemplateBodyContentProviderProperty.builder()
     *                                 .content("content")
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-content.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-content.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wisdom.CfnMessageTemplate.ContentProperty")
    @software.amazon.jsii.Jsii.Proxy(ContentProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ContentProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The content of the message template that applies to the email channel subtype.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-content.html#cfn-wisdom-messagetemplate-content-emailmessagetemplatecontent">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-content.html#cfn-wisdom-messagetemplate-content-emailmessagetemplatecontent</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEmailMessageTemplateContent() {
            return null;
        }

        /**
         * The content of message template that applies to SMS channel subtype.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-content.html#cfn-wisdom-messagetemplate-content-smsmessagetemplatecontent">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-content.html#cfn-wisdom-messagetemplate-content-smsmessagetemplatecontent</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSmsMessageTemplateContent() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ContentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ContentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ContentProperty> {
            java.lang.Object emailMessageTemplateContent;
            java.lang.Object smsMessageTemplateContent;

            /**
             * Sets the value of {@link ContentProperty#getEmailMessageTemplateContent}
             * @param emailMessageTemplateContent The content of the message template that applies to the email channel subtype.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder emailMessageTemplateContent(software.amazon.awscdk.IResolvable emailMessageTemplateContent) {
                this.emailMessageTemplateContent = emailMessageTemplateContent;
                return this;
            }

            /**
             * Sets the value of {@link ContentProperty#getEmailMessageTemplateContent}
             * @param emailMessageTemplateContent The content of the message template that applies to the email channel subtype.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder emailMessageTemplateContent(software.amazon.awscdk.services.wisdom.CfnMessageTemplate.EmailMessageTemplateContentProperty emailMessageTemplateContent) {
                this.emailMessageTemplateContent = emailMessageTemplateContent;
                return this;
            }

            /**
             * Sets the value of {@link ContentProperty#getSmsMessageTemplateContent}
             * @param smsMessageTemplateContent The content of message template that applies to SMS channel subtype.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder smsMessageTemplateContent(software.amazon.awscdk.IResolvable smsMessageTemplateContent) {
                this.smsMessageTemplateContent = smsMessageTemplateContent;
                return this;
            }

            /**
             * Sets the value of {@link ContentProperty#getSmsMessageTemplateContent}
             * @param smsMessageTemplateContent The content of message template that applies to SMS channel subtype.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder smsMessageTemplateContent(software.amazon.awscdk.services.wisdom.CfnMessageTemplate.SmsMessageTemplateContentProperty smsMessageTemplateContent) {
                this.smsMessageTemplateContent = smsMessageTemplateContent;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ContentProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ContentProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ContentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ContentProperty {
            private final java.lang.Object emailMessageTemplateContent;
            private final java.lang.Object smsMessageTemplateContent;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.emailMessageTemplateContent = software.amazon.jsii.Kernel.get(this, "emailMessageTemplateContent", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.smsMessageTemplateContent = software.amazon.jsii.Kernel.get(this, "smsMessageTemplateContent", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.emailMessageTemplateContent = builder.emailMessageTemplateContent;
                this.smsMessageTemplateContent = builder.smsMessageTemplateContent;
            }

            @Override
            public final java.lang.Object getEmailMessageTemplateContent() {
                return this.emailMessageTemplateContent;
            }

            @Override
            public final java.lang.Object getSmsMessageTemplateContent() {
                return this.smsMessageTemplateContent;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEmailMessageTemplateContent() != null) {
                    data.set("emailMessageTemplateContent", om.valueToTree(this.getEmailMessageTemplateContent()));
                }
                if (this.getSmsMessageTemplateContent() != null) {
                    data.set("smsMessageTemplateContent", om.valueToTree(this.getSmsMessageTemplateContent()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wisdom.CfnMessageTemplate.ContentProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ContentProperty.Jsii$Proxy that = (ContentProperty.Jsii$Proxy) o;

                if (this.emailMessageTemplateContent != null ? !this.emailMessageTemplateContent.equals(that.emailMessageTemplateContent) : that.emailMessageTemplateContent != null) return false;
                return this.smsMessageTemplateContent != null ? this.smsMessageTemplateContent.equals(that.smsMessageTemplateContent) : that.smsMessageTemplateContent == null;
            }

            @Override
            public final int hashCode() {
                int result = this.emailMessageTemplateContent != null ? this.emailMessageTemplateContent.hashCode() : 0;
                result = 31 * result + (this.smsMessageTemplateContent != null ? this.smsMessageTemplateContent.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The customer profile attributes that are used with the message template.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wisdom.*;
     * CustomerProfileAttributesProperty customerProfileAttributesProperty = CustomerProfileAttributesProperty.builder()
     *         .accountNumber("accountNumber")
     *         .additionalInformation("additionalInformation")
     *         .address1("address1")
     *         .address2("address2")
     *         .address3("address3")
     *         .address4("address4")
     *         .billingAddress1("billingAddress1")
     *         .billingAddress2("billingAddress2")
     *         .billingAddress3("billingAddress3")
     *         .billingAddress4("billingAddress4")
     *         .billingCity("billingCity")
     *         .billingCountry("billingCountry")
     *         .billingCounty("billingCounty")
     *         .billingPostalCode("billingPostalCode")
     *         .billingProvince("billingProvince")
     *         .billingState("billingState")
     *         .birthDate("birthDate")
     *         .businessEmailAddress("businessEmailAddress")
     *         .businessName("businessName")
     *         .businessPhoneNumber("businessPhoneNumber")
     *         .city("city")
     *         .country("country")
     *         .county("county")
     *         .custom(Map.of(
     *                 "customKey", "custom"))
     *         .emailAddress("emailAddress")
     *         .firstName("firstName")
     *         .gender("gender")
     *         .homePhoneNumber("homePhoneNumber")
     *         .lastName("lastName")
     *         .mailingAddress1("mailingAddress1")
     *         .mailingAddress2("mailingAddress2")
     *         .mailingAddress3("mailingAddress3")
     *         .mailingAddress4("mailingAddress4")
     *         .mailingCity("mailingCity")
     *         .mailingCountry("mailingCountry")
     *         .mailingCounty("mailingCounty")
     *         .mailingPostalCode("mailingPostalCode")
     *         .mailingProvince("mailingProvince")
     *         .mailingState("mailingState")
     *         .middleName("middleName")
     *         .mobilePhoneNumber("mobilePhoneNumber")
     *         .partyType("partyType")
     *         .phoneNumber("phoneNumber")
     *         .postalCode("postalCode")
     *         .profileArn("profileArn")
     *         .profileId("profileId")
     *         .province("province")
     *         .shippingAddress1("shippingAddress1")
     *         .shippingAddress2("shippingAddress2")
     *         .shippingAddress3("shippingAddress3")
     *         .shippingAddress4("shippingAddress4")
     *         .shippingCity("shippingCity")
     *         .shippingCountry("shippingCountry")
     *         .shippingCounty("shippingCounty")
     *         .shippingPostalCode("shippingPostalCode")
     *         .shippingProvince("shippingProvince")
     *         .shippingState("shippingState")
     *         .state("state")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wisdom.CfnMessageTemplate.CustomerProfileAttributesProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomerProfileAttributesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomerProfileAttributesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A unique account number that you have given to the customer.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-accountnumber">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-accountnumber</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAccountNumber() {
            return null;
        }

        /**
         * Any additional information relevant to the customer's profile.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-additionalinformation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-additionalinformation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAdditionalInformation() {
            return null;
        }

        /**
         * The first line of a customer address.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-address1">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-address1</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAddress1() {
            return null;
        }

        /**
         * The second line of a customer address.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-address2">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-address2</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAddress2() {
            return null;
        }

        /**
         * The third line of a customer address.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-address3">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-address3</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAddress3() {
            return null;
        }

        /**
         * The fourth line of a customer address.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-address4">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-address4</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAddress4() {
            return null;
        }

        /**
         * The first line of a customer’s billing address.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-billingaddress1">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-billingaddress1</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBillingAddress1() {
            return null;
        }

        /**
         * The second line of a customer’s billing address.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-billingaddress2">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-billingaddress2</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBillingAddress2() {
            return null;
        }

        /**
         * The third line of a customer’s billing address.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-billingaddress3">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-billingaddress3</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBillingAddress3() {
            return null;
        }

        /**
         * The fourth line of a customer’s billing address.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-billingaddress4">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-billingaddress4</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBillingAddress4() {
            return null;
        }

        /**
         * The city of a customer’s billing address.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-billingcity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-billingcity</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBillingCity() {
            return null;
        }

        /**
         * The country of a customer’s billing address.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-billingcountry">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-billingcountry</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBillingCountry() {
            return null;
        }

        /**
         * The county of a customer’s billing address.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-billingcounty">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-billingcounty</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBillingCounty() {
            return null;
        }

        /**
         * The postal code of a customer’s billing address.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-billingpostalcode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-billingpostalcode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBillingPostalCode() {
            return null;
        }

        /**
         * The province of a customer’s billing address.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-billingprovince">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-billingprovince</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBillingProvince() {
            return null;
        }

        /**
         * The state of a customer’s billing address.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-billingstate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-billingstate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBillingState() {
            return null;
        }

        /**
         * The customer's birth date.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-birthdate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-birthdate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBirthDate() {
            return null;
        }

        /**
         * The customer's business email address.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-businessemailaddress">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-businessemailaddress</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBusinessEmailAddress() {
            return null;
        }

        /**
         * The name of the customer's business.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-businessname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-businessname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBusinessName() {
            return null;
        }

        /**
         * The customer's business phone number.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-businessphonenumber">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-businessphonenumber</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBusinessPhoneNumber() {
            return null;
        }

        /**
         * The city in which a customer lives.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-city">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-city</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCity() {
            return null;
        }

        /**
         * The country in which a customer lives.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-country">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-country</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCountry() {
            return null;
        }

        /**
         * The county in which a customer lives.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-county">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-county</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCounty() {
            return null;
        }

        /**
         * The custom attributes in customer profile attributes.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-custom">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-custom</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustom() {
            return null;
        }

        /**
         * The customer's email address, which has not been specified as a personal or business address.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-emailaddress">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-emailaddress</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEmailAddress() {
            return null;
        }

        /**
         * The customer's first name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-firstname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-firstname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFirstName() {
            return null;
        }

        /**
         * The customer's gender.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-gender">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-gender</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getGender() {
            return null;
        }

        /**
         * The customer's mobile phone number.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-homephonenumber">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-homephonenumber</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHomePhoneNumber() {
            return null;
        }

        /**
         * The customer's last name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-lastname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-lastname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLastName() {
            return null;
        }

        /**
         * The first line of a customer’s mailing address.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-mailingaddress1">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-mailingaddress1</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMailingAddress1() {
            return null;
        }

        /**
         * The second line of a customer’s mailing address.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-mailingaddress2">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-mailingaddress2</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMailingAddress2() {
            return null;
        }

        /**
         * The third line of a customer’s mailing address.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-mailingaddress3">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-mailingaddress3</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMailingAddress3() {
            return null;
        }

        /**
         * The fourth line of a customer’s mailing address.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-mailingaddress4">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-mailingaddress4</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMailingAddress4() {
            return null;
        }

        /**
         * The city of a customer’s mailing address.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-mailingcity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-mailingcity</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMailingCity() {
            return null;
        }

        /**
         * The country of a customer’s mailing address.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-mailingcountry">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-mailingcountry</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMailingCountry() {
            return null;
        }

        /**
         * The county of a customer’s mailing address.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-mailingcounty">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-mailingcounty</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMailingCounty() {
            return null;
        }

        /**
         * The postal code of a customer’s mailing address.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-mailingpostalcode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-mailingpostalcode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMailingPostalCode() {
            return null;
        }

        /**
         * The province of a customer’s mailing address.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-mailingprovince">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-mailingprovince</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMailingProvince() {
            return null;
        }

        /**
         * The state of a customer’s mailing address.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-mailingstate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-mailingstate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMailingState() {
            return null;
        }

        /**
         * The customer's middle name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-middlename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-middlename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMiddleName() {
            return null;
        }

        /**
         * The customer's mobile phone number.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-mobilephonenumber">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-mobilephonenumber</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMobilePhoneNumber() {
            return null;
        }

        /**
         * The customer's party type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-partytype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-partytype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPartyType() {
            return null;
        }

        /**
         * The customer's phone number, which has not been specified as a mobile, home, or business number.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-phonenumber">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-phonenumber</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPhoneNumber() {
            return null;
        }

        /**
         * The postal code of a customer address.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-postalcode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-postalcode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPostalCode() {
            return null;
        }

        /**
         * The ARN of a customer profile.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-profilearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-profilearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getProfileArn() {
            return null;
        }

        /**
         * The unique identifier of a customer profile.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-profileid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-profileid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getProfileId() {
            return null;
        }

        /**
         * The province in which a customer lives.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-province">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-province</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getProvince() {
            return null;
        }

        /**
         * The first line of a customer’s shipping address.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-shippingaddress1">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-shippingaddress1</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getShippingAddress1() {
            return null;
        }

        /**
         * The second line of a customer’s shipping address.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-shippingaddress2">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-shippingaddress2</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getShippingAddress2() {
            return null;
        }

        /**
         * The third line of a customer’s shipping address.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-shippingaddress3">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-shippingaddress3</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getShippingAddress3() {
            return null;
        }

        /**
         * The fourth line of a customer’s shipping address.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-shippingaddress4">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-shippingaddress4</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getShippingAddress4() {
            return null;
        }

        /**
         * The city of a customer’s shipping address.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-shippingcity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-shippingcity</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getShippingCity() {
            return null;
        }

        /**
         * The country of a customer’s shipping address.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-shippingcountry">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-shippingcountry</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getShippingCountry() {
            return null;
        }

        /**
         * The county of a customer’s shipping address.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-shippingcounty">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-shippingcounty</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getShippingCounty() {
            return null;
        }

        /**
         * The postal code of a customer’s shipping address.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-shippingpostalcode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-shippingpostalcode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getShippingPostalCode() {
            return null;
        }

        /**
         * The province of a customer’s shipping address.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-shippingprovince">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-shippingprovince</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getShippingProvince() {
            return null;
        }

        /**
         * The state of a customer’s shipping address.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-shippingstate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-shippingstate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getShippingState() {
            return null;
        }

        /**
         * The state in which a customer lives.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-state">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-customerprofileattributes.html#cfn-wisdom-messagetemplate-customerprofileattributes-state</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getState() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CustomerProfileAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomerProfileAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomerProfileAttributesProperty> {
            java.lang.String accountNumber;
            java.lang.String additionalInformation;
            java.lang.String address1;
            java.lang.String address2;
            java.lang.String address3;
            java.lang.String address4;
            java.lang.String billingAddress1;
            java.lang.String billingAddress2;
            java.lang.String billingAddress3;
            java.lang.String billingAddress4;
            java.lang.String billingCity;
            java.lang.String billingCountry;
            java.lang.String billingCounty;
            java.lang.String billingPostalCode;
            java.lang.String billingProvince;
            java.lang.String billingState;
            java.lang.String birthDate;
            java.lang.String businessEmailAddress;
            java.lang.String businessName;
            java.lang.String businessPhoneNumber;
            java.lang.String city;
            java.lang.String country;
            java.lang.String county;
            java.lang.Object custom;
            java.lang.String emailAddress;
            java.lang.String firstName;
            java.lang.String gender;
            java.lang.String homePhoneNumber;
            java.lang.String lastName;
            java.lang.String mailingAddress1;
            java.lang.String mailingAddress2;
            java.lang.String mailingAddress3;
            java.lang.String mailingAddress4;
            java.lang.String mailingCity;
            java.lang.String mailingCountry;
            java.lang.String mailingCounty;
            java.lang.String mailingPostalCode;
            java.lang.String mailingProvince;
            java.lang.String mailingState;
            java.lang.String middleName;
            java.lang.String mobilePhoneNumber;
            java.lang.String partyType;
            java.lang.String phoneNumber;
            java.lang.String postalCode;
            java.lang.String profileArn;
            java.lang.String profileId;
            java.lang.String province;
            java.lang.String shippingAddress1;
            java.lang.String shippingAddress2;
            java.lang.String shippingAddress3;
            java.lang.String shippingAddress4;
            java.lang.String shippingCity;
            java.lang.String shippingCountry;
            java.lang.String shippingCounty;
            java.lang.String shippingPostalCode;
            java.lang.String shippingProvince;
            java.lang.String shippingState;
            java.lang.String state;

            /**
             * Sets the value of {@link CustomerProfileAttributesProperty#getAccountNumber}
             * @param accountNumber A unique account number that you have given to the customer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accountNumber(java.lang.String accountNumber) {
                this.accountNumber = accountNumber;
                return this;
            }

            /**
             * Sets the value of {@link CustomerProfileAttributesProperty#getAdditionalInformation}
             * @param additionalInformation Any additional information relevant to the customer's profile.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder additionalInformation(java.lang.String additionalInformation) {
                this.additionalInformation = additionalInformation;
                return this;
            }

            /**
             * Sets the value of {@link CustomerProfileAttributesProperty#getAddress1}
             * @param address1 The first line of a customer address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder address1(java.lang.String address1) {
                this.address1 = address1;
                return this;
            }

            /**
             * Sets the value of {@link CustomerProfileAttributesProperty#getAddress2}
             * @param address2 The second line of a customer address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder address2(java.lang.String address2) {
                this.address2 = address2;
                return this;
            }

            /**
             * Sets the value of {@link CustomerProfileAttributesProperty#getAddress3}
             * @param address3 The third line of a customer address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder address3(java.lang.String address3) {
                this.address3 = address3;
                return this;
            }

            /**
             * Sets the value of {@link CustomerProfileAttributesProperty#getAddress4}
             * @param address4 The fourth line of a customer address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder address4(java.lang.String address4) {
                this.address4 = address4;
                return this;
            }

            /**
             * Sets the value of {@link CustomerProfileAttributesProperty#getBillingAddress1}
             * @param billingAddress1 The first line of a customer’s billing address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder billingAddress1(java.lang.String billingAddress1) {
                this.billingAddress1 = billingAddress1;
                return this;
            }

            /**
             * Sets the value of {@link CustomerProfileAttributesProperty#getBillingAddress2}
             * @param billingAddress2 The second line of a customer’s billing address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder billingAddress2(java.lang.String billingAddress2) {
                this.billingAddress2 = billingAddress2;
                return this;
            }

            /**
             * Sets the value of {@link CustomerProfileAttributesProperty#getBillingAddress3}
             * @param billingAddress3 The third line of a customer’s billing address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder billingAddress3(java.lang.String billingAddress3) {
                this.billingAddress3 = billingAddress3;
                return this;
            }

            /**
             * Sets the value of {@link CustomerProfileAttributesProperty#getBillingAddress4}
             * @param billingAddress4 The fourth line of a customer’s billing address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder billingAddress4(java.lang.String billingAddress4) {
                this.billingAddress4 = billingAddress4;
                return this;
            }

            /**
             * Sets the value of {@link CustomerProfileAttributesProperty#getBillingCity}
             * @param billingCity The city of a customer’s billing address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder billingCity(java.lang.String billingCity) {
                this.billingCity = billingCity;
                return this;
            }

            /**
             * Sets the value of {@link CustomerProfileAttributesProperty#getBillingCountry}
             * @param billingCountry The country of a customer’s billing address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder billingCountry(java.lang.String billingCountry) {
                this.billingCountry = billingCountry;
                return this;
            }

            /**
             * Sets the value of {@link CustomerProfileAttributesProperty#getBillingCounty}
             * @param billingCounty The county of a customer’s billing address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder billingCounty(java.lang.String billingCounty) {
                this.billingCounty = billingCounty;
                return this;
            }

            /**
             * Sets the value of {@link CustomerProfileAttributesProperty#getBillingPostalCode}
             * @param billingPostalCode The postal code of a customer’s billing address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder billingPostalCode(java.lang.String billingPostalCode) {
                this.billingPostalCode = billingPostalCode;
                return this;
            }

            /**
             * Sets the value of {@link CustomerProfileAttributesProperty#getBillingProvince}
             * @param billingProvince The province of a customer’s billing address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder billingProvince(java.lang.String billingProvince) {
                this.billingProvince = billingProvince;
                return this;
            }

            /**
             * Sets the value of {@link CustomerProfileAttributesProperty#getBillingState}
             * @param billingState The state of a customer’s billing address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder billingState(java.lang.String billingState) {
                this.billingState = billingState;
                return this;
            }

            /**
             * Sets the value of {@link CustomerProfileAttributesProperty#getBirthDate}
             * @param birthDate The customer's birth date.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder birthDate(java.lang.String birthDate) {
                this.birthDate = birthDate;
                return this;
            }

            /**
             * Sets the value of {@link CustomerProfileAttributesProperty#getBusinessEmailAddress}
             * @param businessEmailAddress The customer's business email address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder businessEmailAddress(java.lang.String businessEmailAddress) {
                this.businessEmailAddress = businessEmailAddress;
                return this;
            }

            /**
             * Sets the value of {@link CustomerProfileAttributesProperty#getBusinessName}
             * @param businessName The name of the customer's business.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder businessName(java.lang.String businessName) {
                this.businessName = businessName;
                return this;
            }

            /**
             * Sets the value of {@link CustomerProfileAttributesProperty#getBusinessPhoneNumber}
             * @param businessPhoneNumber The customer's business phone number.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder businessPhoneNumber(java.lang.String businessPhoneNumber) {
                this.businessPhoneNumber = businessPhoneNumber;
                return this;
            }

            /**
             * Sets the value of {@link CustomerProfileAttributesProperty#getCity}
             * @param city The city in which a customer lives.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder city(java.lang.String city) {
                this.city = city;
                return this;
            }

            /**
             * Sets the value of {@link CustomerProfileAttributesProperty#getCountry}
             * @param country The country in which a customer lives.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder country(java.lang.String country) {
                this.country = country;
                return this;
            }

            /**
             * Sets the value of {@link CustomerProfileAttributesProperty#getCounty}
             * @param county The county in which a customer lives.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder county(java.lang.String county) {
                this.county = county;
                return this;
            }

            /**
             * Sets the value of {@link CustomerProfileAttributesProperty#getCustom}
             * @param custom The custom attributes in customer profile attributes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder custom(java.util.Map<java.lang.String, java.lang.String> custom) {
                this.custom = custom;
                return this;
            }

            /**
             * Sets the value of {@link CustomerProfileAttributesProperty#getCustom}
             * @param custom The custom attributes in customer profile attributes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder custom(software.amazon.awscdk.IResolvable custom) {
                this.custom = custom;
                return this;
            }

            /**
             * Sets the value of {@link CustomerProfileAttributesProperty#getEmailAddress}
             * @param emailAddress The customer's email address, which has not been specified as a personal or business address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder emailAddress(java.lang.String emailAddress) {
                this.emailAddress = emailAddress;
                return this;
            }

            /**
             * Sets the value of {@link CustomerProfileAttributesProperty#getFirstName}
             * @param firstName The customer's first name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder firstName(java.lang.String firstName) {
                this.firstName = firstName;
                return this;
            }

            /**
             * Sets the value of {@link CustomerProfileAttributesProperty#getGender}
             * @param gender The customer's gender.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder gender(java.lang.String gender) {
                this.gender = gender;
                return this;
            }

            /**
             * Sets the value of {@link CustomerProfileAttributesProperty#getHomePhoneNumber}
             * @param homePhoneNumber The customer's mobile phone number.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder homePhoneNumber(java.lang.String homePhoneNumber) {
                this.homePhoneNumber = homePhoneNumber;
                return this;
            }

            /**
             * Sets the value of {@link CustomerProfileAttributesProperty#getLastName}
             * @param lastName The customer's last name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lastName(java.lang.String lastName) {
                this.lastName = lastName;
                return this;
            }

            /**
             * Sets the value of {@link CustomerProfileAttributesProperty#getMailingAddress1}
             * @param mailingAddress1 The first line of a customer’s mailing address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mailingAddress1(java.lang.String mailingAddress1) {
                this.mailingAddress1 = mailingAddress1;
                return this;
            }

            /**
             * Sets the value of {@link CustomerProfileAttributesProperty#getMailingAddress2}
             * @param mailingAddress2 The second line of a customer’s mailing address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mailingAddress2(java.lang.String mailingAddress2) {
                this.mailingAddress2 = mailingAddress2;
                return this;
            }

            /**
             * Sets the value of {@link CustomerProfileAttributesProperty#getMailingAddress3}
             * @param mailingAddress3 The third line of a customer’s mailing address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mailingAddress3(java.lang.String mailingAddress3) {
                this.mailingAddress3 = mailingAddress3;
                return this;
            }

            /**
             * Sets the value of {@link CustomerProfileAttributesProperty#getMailingAddress4}
             * @param mailingAddress4 The fourth line of a customer’s mailing address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mailingAddress4(java.lang.String mailingAddress4) {
                this.mailingAddress4 = mailingAddress4;
                return this;
            }

            /**
             * Sets the value of {@link CustomerProfileAttributesProperty#getMailingCity}
             * @param mailingCity The city of a customer’s mailing address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mailingCity(java.lang.String mailingCity) {
                this.mailingCity = mailingCity;
                return this;
            }

            /**
             * Sets the value of {@link CustomerProfileAttributesProperty#getMailingCountry}
             * @param mailingCountry The country of a customer’s mailing address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mailingCountry(java.lang.String mailingCountry) {
                this.mailingCountry = mailingCountry;
                return this;
            }

            /**
             * Sets the value of {@link CustomerProfileAttributesProperty#getMailingCounty}
             * @param mailingCounty The county of a customer’s mailing address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mailingCounty(java.lang.String mailingCounty) {
                this.mailingCounty = mailingCounty;
                return this;
            }

            /**
             * Sets the value of {@link CustomerProfileAttributesProperty#getMailingPostalCode}
             * @param mailingPostalCode The postal code of a customer’s mailing address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mailingPostalCode(java.lang.String mailingPostalCode) {
                this.mailingPostalCode = mailingPostalCode;
                return this;
            }

            /**
             * Sets the value of {@link CustomerProfileAttributesProperty#getMailingProvince}
             * @param mailingProvince The province of a customer’s mailing address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mailingProvince(java.lang.String mailingProvince) {
                this.mailingProvince = mailingProvince;
                return this;
            }

            /**
             * Sets the value of {@link CustomerProfileAttributesProperty#getMailingState}
             * @param mailingState The state of a customer’s mailing address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mailingState(java.lang.String mailingState) {
                this.mailingState = mailingState;
                return this;
            }

            /**
             * Sets the value of {@link CustomerProfileAttributesProperty#getMiddleName}
             * @param middleName The customer's middle name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder middleName(java.lang.String middleName) {
                this.middleName = middleName;
                return this;
            }

            /**
             * Sets the value of {@link CustomerProfileAttributesProperty#getMobilePhoneNumber}
             * @param mobilePhoneNumber The customer's mobile phone number.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mobilePhoneNumber(java.lang.String mobilePhoneNumber) {
                this.mobilePhoneNumber = mobilePhoneNumber;
                return this;
            }

            /**
             * Sets the value of {@link CustomerProfileAttributesProperty#getPartyType}
             * @param partyType The customer's party type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder partyType(java.lang.String partyType) {
                this.partyType = partyType;
                return this;
            }

            /**
             * Sets the value of {@link CustomerProfileAttributesProperty#getPhoneNumber}
             * @param phoneNumber The customer's phone number, which has not been specified as a mobile, home, or business number.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder phoneNumber(java.lang.String phoneNumber) {
                this.phoneNumber = phoneNumber;
                return this;
            }

            /**
             * Sets the value of {@link CustomerProfileAttributesProperty#getPostalCode}
             * @param postalCode The postal code of a customer address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder postalCode(java.lang.String postalCode) {
                this.postalCode = postalCode;
                return this;
            }

            /**
             * Sets the value of {@link CustomerProfileAttributesProperty#getProfileArn}
             * @param profileArn The ARN of a customer profile.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder profileArn(java.lang.String profileArn) {
                this.profileArn = profileArn;
                return this;
            }

            /**
             * Sets the value of {@link CustomerProfileAttributesProperty#getProfileId}
             * @param profileId The unique identifier of a customer profile.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder profileId(java.lang.String profileId) {
                this.profileId = profileId;
                return this;
            }

            /**
             * Sets the value of {@link CustomerProfileAttributesProperty#getProvince}
             * @param province The province in which a customer lives.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder province(java.lang.String province) {
                this.province = province;
                return this;
            }

            /**
             * Sets the value of {@link CustomerProfileAttributesProperty#getShippingAddress1}
             * @param shippingAddress1 The first line of a customer’s shipping address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder shippingAddress1(java.lang.String shippingAddress1) {
                this.shippingAddress1 = shippingAddress1;
                return this;
            }

            /**
             * Sets the value of {@link CustomerProfileAttributesProperty#getShippingAddress2}
             * @param shippingAddress2 The second line of a customer’s shipping address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder shippingAddress2(java.lang.String shippingAddress2) {
                this.shippingAddress2 = shippingAddress2;
                return this;
            }

            /**
             * Sets the value of {@link CustomerProfileAttributesProperty#getShippingAddress3}
             * @param shippingAddress3 The third line of a customer’s shipping address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder shippingAddress3(java.lang.String shippingAddress3) {
                this.shippingAddress3 = shippingAddress3;
                return this;
            }

            /**
             * Sets the value of {@link CustomerProfileAttributesProperty#getShippingAddress4}
             * @param shippingAddress4 The fourth line of a customer’s shipping address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder shippingAddress4(java.lang.String shippingAddress4) {
                this.shippingAddress4 = shippingAddress4;
                return this;
            }

            /**
             * Sets the value of {@link CustomerProfileAttributesProperty#getShippingCity}
             * @param shippingCity The city of a customer’s shipping address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder shippingCity(java.lang.String shippingCity) {
                this.shippingCity = shippingCity;
                return this;
            }

            /**
             * Sets the value of {@link CustomerProfileAttributesProperty#getShippingCountry}
             * @param shippingCountry The country of a customer’s shipping address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder shippingCountry(java.lang.String shippingCountry) {
                this.shippingCountry = shippingCountry;
                return this;
            }

            /**
             * Sets the value of {@link CustomerProfileAttributesProperty#getShippingCounty}
             * @param shippingCounty The county of a customer’s shipping address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder shippingCounty(java.lang.String shippingCounty) {
                this.shippingCounty = shippingCounty;
                return this;
            }

            /**
             * Sets the value of {@link CustomerProfileAttributesProperty#getShippingPostalCode}
             * @param shippingPostalCode The postal code of a customer’s shipping address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder shippingPostalCode(java.lang.String shippingPostalCode) {
                this.shippingPostalCode = shippingPostalCode;
                return this;
            }

            /**
             * Sets the value of {@link CustomerProfileAttributesProperty#getShippingProvince}
             * @param shippingProvince The province of a customer’s shipping address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder shippingProvince(java.lang.String shippingProvince) {
                this.shippingProvince = shippingProvince;
                return this;
            }

            /**
             * Sets the value of {@link CustomerProfileAttributesProperty#getShippingState}
             * @param shippingState The state of a customer’s shipping address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder shippingState(java.lang.String shippingState) {
                this.shippingState = shippingState;
                return this;
            }

            /**
             * Sets the value of {@link CustomerProfileAttributesProperty#getState}
             * @param state The state in which a customer lives.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder state(java.lang.String state) {
                this.state = state;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomerProfileAttributesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomerProfileAttributesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomerProfileAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomerProfileAttributesProperty {
            private final java.lang.String accountNumber;
            private final java.lang.String additionalInformation;
            private final java.lang.String address1;
            private final java.lang.String address2;
            private final java.lang.String address3;
            private final java.lang.String address4;
            private final java.lang.String billingAddress1;
            private final java.lang.String billingAddress2;
            private final java.lang.String billingAddress3;
            private final java.lang.String billingAddress4;
            private final java.lang.String billingCity;
            private final java.lang.String billingCountry;
            private final java.lang.String billingCounty;
            private final java.lang.String billingPostalCode;
            private final java.lang.String billingProvince;
            private final java.lang.String billingState;
            private final java.lang.String birthDate;
            private final java.lang.String businessEmailAddress;
            private final java.lang.String businessName;
            private final java.lang.String businessPhoneNumber;
            private final java.lang.String city;
            private final java.lang.String country;
            private final java.lang.String county;
            private final java.lang.Object custom;
            private final java.lang.String emailAddress;
            private final java.lang.String firstName;
            private final java.lang.String gender;
            private final java.lang.String homePhoneNumber;
            private final java.lang.String lastName;
            private final java.lang.String mailingAddress1;
            private final java.lang.String mailingAddress2;
            private final java.lang.String mailingAddress3;
            private final java.lang.String mailingAddress4;
            private final java.lang.String mailingCity;
            private final java.lang.String mailingCountry;
            private final java.lang.String mailingCounty;
            private final java.lang.String mailingPostalCode;
            private final java.lang.String mailingProvince;
            private final java.lang.String mailingState;
            private final java.lang.String middleName;
            private final java.lang.String mobilePhoneNumber;
            private final java.lang.String partyType;
            private final java.lang.String phoneNumber;
            private final java.lang.String postalCode;
            private final java.lang.String profileArn;
            private final java.lang.String profileId;
            private final java.lang.String province;
            private final java.lang.String shippingAddress1;
            private final java.lang.String shippingAddress2;
            private final java.lang.String shippingAddress3;
            private final java.lang.String shippingAddress4;
            private final java.lang.String shippingCity;
            private final java.lang.String shippingCountry;
            private final java.lang.String shippingCounty;
            private final java.lang.String shippingPostalCode;
            private final java.lang.String shippingProvince;
            private final java.lang.String shippingState;
            private final java.lang.String state;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.accountNumber = software.amazon.jsii.Kernel.get(this, "accountNumber", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.additionalInformation = software.amazon.jsii.Kernel.get(this, "additionalInformation", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.address1 = software.amazon.jsii.Kernel.get(this, "address1", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.address2 = software.amazon.jsii.Kernel.get(this, "address2", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.address3 = software.amazon.jsii.Kernel.get(this, "address3", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.address4 = software.amazon.jsii.Kernel.get(this, "address4", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.billingAddress1 = software.amazon.jsii.Kernel.get(this, "billingAddress1", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.billingAddress2 = software.amazon.jsii.Kernel.get(this, "billingAddress2", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.billingAddress3 = software.amazon.jsii.Kernel.get(this, "billingAddress3", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.billingAddress4 = software.amazon.jsii.Kernel.get(this, "billingAddress4", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.billingCity = software.amazon.jsii.Kernel.get(this, "billingCity", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.billingCountry = software.amazon.jsii.Kernel.get(this, "billingCountry", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.billingCounty = software.amazon.jsii.Kernel.get(this, "billingCounty", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.billingPostalCode = software.amazon.jsii.Kernel.get(this, "billingPostalCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.billingProvince = software.amazon.jsii.Kernel.get(this, "billingProvince", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.billingState = software.amazon.jsii.Kernel.get(this, "billingState", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.birthDate = software.amazon.jsii.Kernel.get(this, "birthDate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.businessEmailAddress = software.amazon.jsii.Kernel.get(this, "businessEmailAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.businessName = software.amazon.jsii.Kernel.get(this, "businessName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.businessPhoneNumber = software.amazon.jsii.Kernel.get(this, "businessPhoneNumber", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.city = software.amazon.jsii.Kernel.get(this, "city", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.country = software.amazon.jsii.Kernel.get(this, "country", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.county = software.amazon.jsii.Kernel.get(this, "county", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.custom = software.amazon.jsii.Kernel.get(this, "custom", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.emailAddress = software.amazon.jsii.Kernel.get(this, "emailAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.firstName = software.amazon.jsii.Kernel.get(this, "firstName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.gender = software.amazon.jsii.Kernel.get(this, "gender", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.homePhoneNumber = software.amazon.jsii.Kernel.get(this, "homePhoneNumber", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.lastName = software.amazon.jsii.Kernel.get(this, "lastName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.mailingAddress1 = software.amazon.jsii.Kernel.get(this, "mailingAddress1", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.mailingAddress2 = software.amazon.jsii.Kernel.get(this, "mailingAddress2", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.mailingAddress3 = software.amazon.jsii.Kernel.get(this, "mailingAddress3", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.mailingAddress4 = software.amazon.jsii.Kernel.get(this, "mailingAddress4", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.mailingCity = software.amazon.jsii.Kernel.get(this, "mailingCity", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.mailingCountry = software.amazon.jsii.Kernel.get(this, "mailingCountry", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.mailingCounty = software.amazon.jsii.Kernel.get(this, "mailingCounty", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.mailingPostalCode = software.amazon.jsii.Kernel.get(this, "mailingPostalCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.mailingProvince = software.amazon.jsii.Kernel.get(this, "mailingProvince", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.mailingState = software.amazon.jsii.Kernel.get(this, "mailingState", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.middleName = software.amazon.jsii.Kernel.get(this, "middleName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.mobilePhoneNumber = software.amazon.jsii.Kernel.get(this, "mobilePhoneNumber", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.partyType = software.amazon.jsii.Kernel.get(this, "partyType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.phoneNumber = software.amazon.jsii.Kernel.get(this, "phoneNumber", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.postalCode = software.amazon.jsii.Kernel.get(this, "postalCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.profileArn = software.amazon.jsii.Kernel.get(this, "profileArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.profileId = software.amazon.jsii.Kernel.get(this, "profileId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.province = software.amazon.jsii.Kernel.get(this, "province", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.shippingAddress1 = software.amazon.jsii.Kernel.get(this, "shippingAddress1", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.shippingAddress2 = software.amazon.jsii.Kernel.get(this, "shippingAddress2", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.shippingAddress3 = software.amazon.jsii.Kernel.get(this, "shippingAddress3", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.shippingAddress4 = software.amazon.jsii.Kernel.get(this, "shippingAddress4", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.shippingCity = software.amazon.jsii.Kernel.get(this, "shippingCity", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.shippingCountry = software.amazon.jsii.Kernel.get(this, "shippingCountry", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.shippingCounty = software.amazon.jsii.Kernel.get(this, "shippingCounty", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.shippingPostalCode = software.amazon.jsii.Kernel.get(this, "shippingPostalCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.shippingProvince = software.amazon.jsii.Kernel.get(this, "shippingProvince", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.shippingState = software.amazon.jsii.Kernel.get(this, "shippingState", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.state = software.amazon.jsii.Kernel.get(this, "state", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.accountNumber = builder.accountNumber;
                this.additionalInformation = builder.additionalInformation;
                this.address1 = builder.address1;
                this.address2 = builder.address2;
                this.address3 = builder.address3;
                this.address4 = builder.address4;
                this.billingAddress1 = builder.billingAddress1;
                this.billingAddress2 = builder.billingAddress2;
                this.billingAddress3 = builder.billingAddress3;
                this.billingAddress4 = builder.billingAddress4;
                this.billingCity = builder.billingCity;
                this.billingCountry = builder.billingCountry;
                this.billingCounty = builder.billingCounty;
                this.billingPostalCode = builder.billingPostalCode;
                this.billingProvince = builder.billingProvince;
                this.billingState = builder.billingState;
                this.birthDate = builder.birthDate;
                this.businessEmailAddress = builder.businessEmailAddress;
                this.businessName = builder.businessName;
                this.businessPhoneNumber = builder.businessPhoneNumber;
                this.city = builder.city;
                this.country = builder.country;
                this.county = builder.county;
                this.custom = builder.custom;
                this.emailAddress = builder.emailAddress;
                this.firstName = builder.firstName;
                this.gender = builder.gender;
                this.homePhoneNumber = builder.homePhoneNumber;
                this.lastName = builder.lastName;
                this.mailingAddress1 = builder.mailingAddress1;
                this.mailingAddress2 = builder.mailingAddress2;
                this.mailingAddress3 = builder.mailingAddress3;
                this.mailingAddress4 = builder.mailingAddress4;
                this.mailingCity = builder.mailingCity;
                this.mailingCountry = builder.mailingCountry;
                this.mailingCounty = builder.mailingCounty;
                this.mailingPostalCode = builder.mailingPostalCode;
                this.mailingProvince = builder.mailingProvince;
                this.mailingState = builder.mailingState;
                this.middleName = builder.middleName;
                this.mobilePhoneNumber = builder.mobilePhoneNumber;
                this.partyType = builder.partyType;
                this.phoneNumber = builder.phoneNumber;
                this.postalCode = builder.postalCode;
                this.profileArn = builder.profileArn;
                this.profileId = builder.profileId;
                this.province = builder.province;
                this.shippingAddress1 = builder.shippingAddress1;
                this.shippingAddress2 = builder.shippingAddress2;
                this.shippingAddress3 = builder.shippingAddress3;
                this.shippingAddress4 = builder.shippingAddress4;
                this.shippingCity = builder.shippingCity;
                this.shippingCountry = builder.shippingCountry;
                this.shippingCounty = builder.shippingCounty;
                this.shippingPostalCode = builder.shippingPostalCode;
                this.shippingProvince = builder.shippingProvince;
                this.shippingState = builder.shippingState;
                this.state = builder.state;
            }

            @Override
            public final java.lang.String getAccountNumber() {
                return this.accountNumber;
            }

            @Override
            public final java.lang.String getAdditionalInformation() {
                return this.additionalInformation;
            }

            @Override
            public final java.lang.String getAddress1() {
                return this.address1;
            }

            @Override
            public final java.lang.String getAddress2() {
                return this.address2;
            }

            @Override
            public final java.lang.String getAddress3() {
                return this.address3;
            }

            @Override
            public final java.lang.String getAddress4() {
                return this.address4;
            }

            @Override
            public final java.lang.String getBillingAddress1() {
                return this.billingAddress1;
            }

            @Override
            public final java.lang.String getBillingAddress2() {
                return this.billingAddress2;
            }

            @Override
            public final java.lang.String getBillingAddress3() {
                return this.billingAddress3;
            }

            @Override
            public final java.lang.String getBillingAddress4() {
                return this.billingAddress4;
            }

            @Override
            public final java.lang.String getBillingCity() {
                return this.billingCity;
            }

            @Override
            public final java.lang.String getBillingCountry() {
                return this.billingCountry;
            }

            @Override
            public final java.lang.String getBillingCounty() {
                return this.billingCounty;
            }

            @Override
            public final java.lang.String getBillingPostalCode() {
                return this.billingPostalCode;
            }

            @Override
            public final java.lang.String getBillingProvince() {
                return this.billingProvince;
            }

            @Override
            public final java.lang.String getBillingState() {
                return this.billingState;
            }

            @Override
            public final java.lang.String getBirthDate() {
                return this.birthDate;
            }

            @Override
            public final java.lang.String getBusinessEmailAddress() {
                return this.businessEmailAddress;
            }

            @Override
            public final java.lang.String getBusinessName() {
                return this.businessName;
            }

            @Override
            public final java.lang.String getBusinessPhoneNumber() {
                return this.businessPhoneNumber;
            }

            @Override
            public final java.lang.String getCity() {
                return this.city;
            }

            @Override
            public final java.lang.String getCountry() {
                return this.country;
            }

            @Override
            public final java.lang.String getCounty() {
                return this.county;
            }

            @Override
            public final java.lang.Object getCustom() {
                return this.custom;
            }

            @Override
            public final java.lang.String getEmailAddress() {
                return this.emailAddress;
            }

            @Override
            public final java.lang.String getFirstName() {
                return this.firstName;
            }

            @Override
            public final java.lang.String getGender() {
                return this.gender;
            }

            @Override
            public final java.lang.String getHomePhoneNumber() {
                return this.homePhoneNumber;
            }

            @Override
            public final java.lang.String getLastName() {
                return this.lastName;
            }

            @Override
            public final java.lang.String getMailingAddress1() {
                return this.mailingAddress1;
            }

            @Override
            public final java.lang.String getMailingAddress2() {
                return this.mailingAddress2;
            }

            @Override
            public final java.lang.String getMailingAddress3() {
                return this.mailingAddress3;
            }

            @Override
            public final java.lang.String getMailingAddress4() {
                return this.mailingAddress4;
            }

            @Override
            public final java.lang.String getMailingCity() {
                return this.mailingCity;
            }

            @Override
            public final java.lang.String getMailingCountry() {
                return this.mailingCountry;
            }

            @Override
            public final java.lang.String getMailingCounty() {
                return this.mailingCounty;
            }

            @Override
            public final java.lang.String getMailingPostalCode() {
                return this.mailingPostalCode;
            }

            @Override
            public final java.lang.String getMailingProvince() {
                return this.mailingProvince;
            }

            @Override
            public final java.lang.String getMailingState() {
                return this.mailingState;
            }

            @Override
            public final java.lang.String getMiddleName() {
                return this.middleName;
            }

            @Override
            public final java.lang.String getMobilePhoneNumber() {
                return this.mobilePhoneNumber;
            }

            @Override
            public final java.lang.String getPartyType() {
                return this.partyType;
            }

            @Override
            public final java.lang.String getPhoneNumber() {
                return this.phoneNumber;
            }

            @Override
            public final java.lang.String getPostalCode() {
                return this.postalCode;
            }

            @Override
            public final java.lang.String getProfileArn() {
                return this.profileArn;
            }

            @Override
            public final java.lang.String getProfileId() {
                return this.profileId;
            }

            @Override
            public final java.lang.String getProvince() {
                return this.province;
            }

            @Override
            public final java.lang.String getShippingAddress1() {
                return this.shippingAddress1;
            }

            @Override
            public final java.lang.String getShippingAddress2() {
                return this.shippingAddress2;
            }

            @Override
            public final java.lang.String getShippingAddress3() {
                return this.shippingAddress3;
            }

            @Override
            public final java.lang.String getShippingAddress4() {
                return this.shippingAddress4;
            }

            @Override
            public final java.lang.String getShippingCity() {
                return this.shippingCity;
            }

            @Override
            public final java.lang.String getShippingCountry() {
                return this.shippingCountry;
            }

            @Override
            public final java.lang.String getShippingCounty() {
                return this.shippingCounty;
            }

            @Override
            public final java.lang.String getShippingPostalCode() {
                return this.shippingPostalCode;
            }

            @Override
            public final java.lang.String getShippingProvince() {
                return this.shippingProvince;
            }

            @Override
            public final java.lang.String getShippingState() {
                return this.shippingState;
            }

            @Override
            public final java.lang.String getState() {
                return this.state;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAccountNumber() != null) {
                    data.set("accountNumber", om.valueToTree(this.getAccountNumber()));
                }
                if (this.getAdditionalInformation() != null) {
                    data.set("additionalInformation", om.valueToTree(this.getAdditionalInformation()));
                }
                if (this.getAddress1() != null) {
                    data.set("address1", om.valueToTree(this.getAddress1()));
                }
                if (this.getAddress2() != null) {
                    data.set("address2", om.valueToTree(this.getAddress2()));
                }
                if (this.getAddress3() != null) {
                    data.set("address3", om.valueToTree(this.getAddress3()));
                }
                if (this.getAddress4() != null) {
                    data.set("address4", om.valueToTree(this.getAddress4()));
                }
                if (this.getBillingAddress1() != null) {
                    data.set("billingAddress1", om.valueToTree(this.getBillingAddress1()));
                }
                if (this.getBillingAddress2() != null) {
                    data.set("billingAddress2", om.valueToTree(this.getBillingAddress2()));
                }
                if (this.getBillingAddress3() != null) {
                    data.set("billingAddress3", om.valueToTree(this.getBillingAddress3()));
                }
                if (this.getBillingAddress4() != null) {
                    data.set("billingAddress4", om.valueToTree(this.getBillingAddress4()));
                }
                if (this.getBillingCity() != null) {
                    data.set("billingCity", om.valueToTree(this.getBillingCity()));
                }
                if (this.getBillingCountry() != null) {
                    data.set("billingCountry", om.valueToTree(this.getBillingCountry()));
                }
                if (this.getBillingCounty() != null) {
                    data.set("billingCounty", om.valueToTree(this.getBillingCounty()));
                }
                if (this.getBillingPostalCode() != null) {
                    data.set("billingPostalCode", om.valueToTree(this.getBillingPostalCode()));
                }
                if (this.getBillingProvince() != null) {
                    data.set("billingProvince", om.valueToTree(this.getBillingProvince()));
                }
                if (this.getBillingState() != null) {
                    data.set("billingState", om.valueToTree(this.getBillingState()));
                }
                if (this.getBirthDate() != null) {
                    data.set("birthDate", om.valueToTree(this.getBirthDate()));
                }
                if (this.getBusinessEmailAddress() != null) {
                    data.set("businessEmailAddress", om.valueToTree(this.getBusinessEmailAddress()));
                }
                if (this.getBusinessName() != null) {
                    data.set("businessName", om.valueToTree(this.getBusinessName()));
                }
                if (this.getBusinessPhoneNumber() != null) {
                    data.set("businessPhoneNumber", om.valueToTree(this.getBusinessPhoneNumber()));
                }
                if (this.getCity() != null) {
                    data.set("city", om.valueToTree(this.getCity()));
                }
                if (this.getCountry() != null) {
                    data.set("country", om.valueToTree(this.getCountry()));
                }
                if (this.getCounty() != null) {
                    data.set("county", om.valueToTree(this.getCounty()));
                }
                if (this.getCustom() != null) {
                    data.set("custom", om.valueToTree(this.getCustom()));
                }
                if (this.getEmailAddress() != null) {
                    data.set("emailAddress", om.valueToTree(this.getEmailAddress()));
                }
                if (this.getFirstName() != null) {
                    data.set("firstName", om.valueToTree(this.getFirstName()));
                }
                if (this.getGender() != null) {
                    data.set("gender", om.valueToTree(this.getGender()));
                }
                if (this.getHomePhoneNumber() != null) {
                    data.set("homePhoneNumber", om.valueToTree(this.getHomePhoneNumber()));
                }
                if (this.getLastName() != null) {
                    data.set("lastName", om.valueToTree(this.getLastName()));
                }
                if (this.getMailingAddress1() != null) {
                    data.set("mailingAddress1", om.valueToTree(this.getMailingAddress1()));
                }
                if (this.getMailingAddress2() != null) {
                    data.set("mailingAddress2", om.valueToTree(this.getMailingAddress2()));
                }
                if (this.getMailingAddress3() != null) {
                    data.set("mailingAddress3", om.valueToTree(this.getMailingAddress3()));
                }
                if (this.getMailingAddress4() != null) {
                    data.set("mailingAddress4", om.valueToTree(this.getMailingAddress4()));
                }
                if (this.getMailingCity() != null) {
                    data.set("mailingCity", om.valueToTree(this.getMailingCity()));
                }
                if (this.getMailingCountry() != null) {
                    data.set("mailingCountry", om.valueToTree(this.getMailingCountry()));
                }
                if (this.getMailingCounty() != null) {
                    data.set("mailingCounty", om.valueToTree(this.getMailingCounty()));
                }
                if (this.getMailingPostalCode() != null) {
                    data.set("mailingPostalCode", om.valueToTree(this.getMailingPostalCode()));
                }
                if (this.getMailingProvince() != null) {
                    data.set("mailingProvince", om.valueToTree(this.getMailingProvince()));
                }
                if (this.getMailingState() != null) {
                    data.set("mailingState", om.valueToTree(this.getMailingState()));
                }
                if (this.getMiddleName() != null) {
                    data.set("middleName", om.valueToTree(this.getMiddleName()));
                }
                if (this.getMobilePhoneNumber() != null) {
                    data.set("mobilePhoneNumber", om.valueToTree(this.getMobilePhoneNumber()));
                }
                if (this.getPartyType() != null) {
                    data.set("partyType", om.valueToTree(this.getPartyType()));
                }
                if (this.getPhoneNumber() != null) {
                    data.set("phoneNumber", om.valueToTree(this.getPhoneNumber()));
                }
                if (this.getPostalCode() != null) {
                    data.set("postalCode", om.valueToTree(this.getPostalCode()));
                }
                if (this.getProfileArn() != null) {
                    data.set("profileArn", om.valueToTree(this.getProfileArn()));
                }
                if (this.getProfileId() != null) {
                    data.set("profileId", om.valueToTree(this.getProfileId()));
                }
                if (this.getProvince() != null) {
                    data.set("province", om.valueToTree(this.getProvince()));
                }
                if (this.getShippingAddress1() != null) {
                    data.set("shippingAddress1", om.valueToTree(this.getShippingAddress1()));
                }
                if (this.getShippingAddress2() != null) {
                    data.set("shippingAddress2", om.valueToTree(this.getShippingAddress2()));
                }
                if (this.getShippingAddress3() != null) {
                    data.set("shippingAddress3", om.valueToTree(this.getShippingAddress3()));
                }
                if (this.getShippingAddress4() != null) {
                    data.set("shippingAddress4", om.valueToTree(this.getShippingAddress4()));
                }
                if (this.getShippingCity() != null) {
                    data.set("shippingCity", om.valueToTree(this.getShippingCity()));
                }
                if (this.getShippingCountry() != null) {
                    data.set("shippingCountry", om.valueToTree(this.getShippingCountry()));
                }
                if (this.getShippingCounty() != null) {
                    data.set("shippingCounty", om.valueToTree(this.getShippingCounty()));
                }
                if (this.getShippingPostalCode() != null) {
                    data.set("shippingPostalCode", om.valueToTree(this.getShippingPostalCode()));
                }
                if (this.getShippingProvince() != null) {
                    data.set("shippingProvince", om.valueToTree(this.getShippingProvince()));
                }
                if (this.getShippingState() != null) {
                    data.set("shippingState", om.valueToTree(this.getShippingState()));
                }
                if (this.getState() != null) {
                    data.set("state", om.valueToTree(this.getState()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wisdom.CfnMessageTemplate.CustomerProfileAttributesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomerProfileAttributesProperty.Jsii$Proxy that = (CustomerProfileAttributesProperty.Jsii$Proxy) o;

                if (this.accountNumber != null ? !this.accountNumber.equals(that.accountNumber) : that.accountNumber != null) return false;
                if (this.additionalInformation != null ? !this.additionalInformation.equals(that.additionalInformation) : that.additionalInformation != null) return false;
                if (this.address1 != null ? !this.address1.equals(that.address1) : that.address1 != null) return false;
                if (this.address2 != null ? !this.address2.equals(that.address2) : that.address2 != null) return false;
                if (this.address3 != null ? !this.address3.equals(that.address3) : that.address3 != null) return false;
                if (this.address4 != null ? !this.address4.equals(that.address4) : that.address4 != null) return false;
                if (this.billingAddress1 != null ? !this.billingAddress1.equals(that.billingAddress1) : that.billingAddress1 != null) return false;
                if (this.billingAddress2 != null ? !this.billingAddress2.equals(that.billingAddress2) : that.billingAddress2 != null) return false;
                if (this.billingAddress3 != null ? !this.billingAddress3.equals(that.billingAddress3) : that.billingAddress3 != null) return false;
                if (this.billingAddress4 != null ? !this.billingAddress4.equals(that.billingAddress4) : that.billingAddress4 != null) return false;
                if (this.billingCity != null ? !this.billingCity.equals(that.billingCity) : that.billingCity != null) return false;
                if (this.billingCountry != null ? !this.billingCountry.equals(that.billingCountry) : that.billingCountry != null) return false;
                if (this.billingCounty != null ? !this.billingCounty.equals(that.billingCounty) : that.billingCounty != null) return false;
                if (this.billingPostalCode != null ? !this.billingPostalCode.equals(that.billingPostalCode) : that.billingPostalCode != null) return false;
                if (this.billingProvince != null ? !this.billingProvince.equals(that.billingProvince) : that.billingProvince != null) return false;
                if (this.billingState != null ? !this.billingState.equals(that.billingState) : that.billingState != null) return false;
                if (this.birthDate != null ? !this.birthDate.equals(that.birthDate) : that.birthDate != null) return false;
                if (this.businessEmailAddress != null ? !this.businessEmailAddress.equals(that.businessEmailAddress) : that.businessEmailAddress != null) return false;
                if (this.businessName != null ? !this.businessName.equals(that.businessName) : that.businessName != null) return false;
                if (this.businessPhoneNumber != null ? !this.businessPhoneNumber.equals(that.businessPhoneNumber) : that.businessPhoneNumber != null) return false;
                if (this.city != null ? !this.city.equals(that.city) : that.city != null) return false;
                if (this.country != null ? !this.country.equals(that.country) : that.country != null) return false;
                if (this.county != null ? !this.county.equals(that.county) : that.county != null) return false;
                if (this.custom != null ? !this.custom.equals(that.custom) : that.custom != null) return false;
                if (this.emailAddress != null ? !this.emailAddress.equals(that.emailAddress) : that.emailAddress != null) return false;
                if (this.firstName != null ? !this.firstName.equals(that.firstName) : that.firstName != null) return false;
                if (this.gender != null ? !this.gender.equals(that.gender) : that.gender != null) return false;
                if (this.homePhoneNumber != null ? !this.homePhoneNumber.equals(that.homePhoneNumber) : that.homePhoneNumber != null) return false;
                if (this.lastName != null ? !this.lastName.equals(that.lastName) : that.lastName != null) return false;
                if (this.mailingAddress1 != null ? !this.mailingAddress1.equals(that.mailingAddress1) : that.mailingAddress1 != null) return false;
                if (this.mailingAddress2 != null ? !this.mailingAddress2.equals(that.mailingAddress2) : that.mailingAddress2 != null) return false;
                if (this.mailingAddress3 != null ? !this.mailingAddress3.equals(that.mailingAddress3) : that.mailingAddress3 != null) return false;
                if (this.mailingAddress4 != null ? !this.mailingAddress4.equals(that.mailingAddress4) : that.mailingAddress4 != null) return false;
                if (this.mailingCity != null ? !this.mailingCity.equals(that.mailingCity) : that.mailingCity != null) return false;
                if (this.mailingCountry != null ? !this.mailingCountry.equals(that.mailingCountry) : that.mailingCountry != null) return false;
                if (this.mailingCounty != null ? !this.mailingCounty.equals(that.mailingCounty) : that.mailingCounty != null) return false;
                if (this.mailingPostalCode != null ? !this.mailingPostalCode.equals(that.mailingPostalCode) : that.mailingPostalCode != null) return false;
                if (this.mailingProvince != null ? !this.mailingProvince.equals(that.mailingProvince) : that.mailingProvince != null) return false;
                if (this.mailingState != null ? !this.mailingState.equals(that.mailingState) : that.mailingState != null) return false;
                if (this.middleName != null ? !this.middleName.equals(that.middleName) : that.middleName != null) return false;
                if (this.mobilePhoneNumber != null ? !this.mobilePhoneNumber.equals(that.mobilePhoneNumber) : that.mobilePhoneNumber != null) return false;
                if (this.partyType != null ? !this.partyType.equals(that.partyType) : that.partyType != null) return false;
                if (this.phoneNumber != null ? !this.phoneNumber.equals(that.phoneNumber) : that.phoneNumber != null) return false;
                if (this.postalCode != null ? !this.postalCode.equals(that.postalCode) : that.postalCode != null) return false;
                if (this.profileArn != null ? !this.profileArn.equals(that.profileArn) : that.profileArn != null) return false;
                if (this.profileId != null ? !this.profileId.equals(that.profileId) : that.profileId != null) return false;
                if (this.province != null ? !this.province.equals(that.province) : that.province != null) return false;
                if (this.shippingAddress1 != null ? !this.shippingAddress1.equals(that.shippingAddress1) : that.shippingAddress1 != null) return false;
                if (this.shippingAddress2 != null ? !this.shippingAddress2.equals(that.shippingAddress2) : that.shippingAddress2 != null) return false;
                if (this.shippingAddress3 != null ? !this.shippingAddress3.equals(that.shippingAddress3) : that.shippingAddress3 != null) return false;
                if (this.shippingAddress4 != null ? !this.shippingAddress4.equals(that.shippingAddress4) : that.shippingAddress4 != null) return false;
                if (this.shippingCity != null ? !this.shippingCity.equals(that.shippingCity) : that.shippingCity != null) return false;
                if (this.shippingCountry != null ? !this.shippingCountry.equals(that.shippingCountry) : that.shippingCountry != null) return false;
                if (this.shippingCounty != null ? !this.shippingCounty.equals(that.shippingCounty) : that.shippingCounty != null) return false;
                if (this.shippingPostalCode != null ? !this.shippingPostalCode.equals(that.shippingPostalCode) : that.shippingPostalCode != null) return false;
                if (this.shippingProvince != null ? !this.shippingProvince.equals(that.shippingProvince) : that.shippingProvince != null) return false;
                if (this.shippingState != null ? !this.shippingState.equals(that.shippingState) : that.shippingState != null) return false;
                return this.state != null ? this.state.equals(that.state) : that.state == null;
            }

            @Override
            public final int hashCode() {
                int result = this.accountNumber != null ? this.accountNumber.hashCode() : 0;
                result = 31 * result + (this.additionalInformation != null ? this.additionalInformation.hashCode() : 0);
                result = 31 * result + (this.address1 != null ? this.address1.hashCode() : 0);
                result = 31 * result + (this.address2 != null ? this.address2.hashCode() : 0);
                result = 31 * result + (this.address3 != null ? this.address3.hashCode() : 0);
                result = 31 * result + (this.address4 != null ? this.address4.hashCode() : 0);
                result = 31 * result + (this.billingAddress1 != null ? this.billingAddress1.hashCode() : 0);
                result = 31 * result + (this.billingAddress2 != null ? this.billingAddress2.hashCode() : 0);
                result = 31 * result + (this.billingAddress3 != null ? this.billingAddress3.hashCode() : 0);
                result = 31 * result + (this.billingAddress4 != null ? this.billingAddress4.hashCode() : 0);
                result = 31 * result + (this.billingCity != null ? this.billingCity.hashCode() : 0);
                result = 31 * result + (this.billingCountry != null ? this.billingCountry.hashCode() : 0);
                result = 31 * result + (this.billingCounty != null ? this.billingCounty.hashCode() : 0);
                result = 31 * result + (this.billingPostalCode != null ? this.billingPostalCode.hashCode() : 0);
                result = 31 * result + (this.billingProvince != null ? this.billingProvince.hashCode() : 0);
                result = 31 * result + (this.billingState != null ? this.billingState.hashCode() : 0);
                result = 31 * result + (this.birthDate != null ? this.birthDate.hashCode() : 0);
                result = 31 * result + (this.businessEmailAddress != null ? this.businessEmailAddress.hashCode() : 0);
                result = 31 * result + (this.businessName != null ? this.businessName.hashCode() : 0);
                result = 31 * result + (this.businessPhoneNumber != null ? this.businessPhoneNumber.hashCode() : 0);
                result = 31 * result + (this.city != null ? this.city.hashCode() : 0);
                result = 31 * result + (this.country != null ? this.country.hashCode() : 0);
                result = 31 * result + (this.county != null ? this.county.hashCode() : 0);
                result = 31 * result + (this.custom != null ? this.custom.hashCode() : 0);
                result = 31 * result + (this.emailAddress != null ? this.emailAddress.hashCode() : 0);
                result = 31 * result + (this.firstName != null ? this.firstName.hashCode() : 0);
                result = 31 * result + (this.gender != null ? this.gender.hashCode() : 0);
                result = 31 * result + (this.homePhoneNumber != null ? this.homePhoneNumber.hashCode() : 0);
                result = 31 * result + (this.lastName != null ? this.lastName.hashCode() : 0);
                result = 31 * result + (this.mailingAddress1 != null ? this.mailingAddress1.hashCode() : 0);
                result = 31 * result + (this.mailingAddress2 != null ? this.mailingAddress2.hashCode() : 0);
                result = 31 * result + (this.mailingAddress3 != null ? this.mailingAddress3.hashCode() : 0);
                result = 31 * result + (this.mailingAddress4 != null ? this.mailingAddress4.hashCode() : 0);
                result = 31 * result + (this.mailingCity != null ? this.mailingCity.hashCode() : 0);
                result = 31 * result + (this.mailingCountry != null ? this.mailingCountry.hashCode() : 0);
                result = 31 * result + (this.mailingCounty != null ? this.mailingCounty.hashCode() : 0);
                result = 31 * result + (this.mailingPostalCode != null ? this.mailingPostalCode.hashCode() : 0);
                result = 31 * result + (this.mailingProvince != null ? this.mailingProvince.hashCode() : 0);
                result = 31 * result + (this.mailingState != null ? this.mailingState.hashCode() : 0);
                result = 31 * result + (this.middleName != null ? this.middleName.hashCode() : 0);
                result = 31 * result + (this.mobilePhoneNumber != null ? this.mobilePhoneNumber.hashCode() : 0);
                result = 31 * result + (this.partyType != null ? this.partyType.hashCode() : 0);
                result = 31 * result + (this.phoneNumber != null ? this.phoneNumber.hashCode() : 0);
                result = 31 * result + (this.postalCode != null ? this.postalCode.hashCode() : 0);
                result = 31 * result + (this.profileArn != null ? this.profileArn.hashCode() : 0);
                result = 31 * result + (this.profileId != null ? this.profileId.hashCode() : 0);
                result = 31 * result + (this.province != null ? this.province.hashCode() : 0);
                result = 31 * result + (this.shippingAddress1 != null ? this.shippingAddress1.hashCode() : 0);
                result = 31 * result + (this.shippingAddress2 != null ? this.shippingAddress2.hashCode() : 0);
                result = 31 * result + (this.shippingAddress3 != null ? this.shippingAddress3.hashCode() : 0);
                result = 31 * result + (this.shippingAddress4 != null ? this.shippingAddress4.hashCode() : 0);
                result = 31 * result + (this.shippingCity != null ? this.shippingCity.hashCode() : 0);
                result = 31 * result + (this.shippingCountry != null ? this.shippingCountry.hashCode() : 0);
                result = 31 * result + (this.shippingCounty != null ? this.shippingCounty.hashCode() : 0);
                result = 31 * result + (this.shippingPostalCode != null ? this.shippingPostalCode.hashCode() : 0);
                result = 31 * result + (this.shippingProvince != null ? this.shippingProvince.hashCode() : 0);
                result = 31 * result + (this.shippingState != null ? this.shippingState.hashCode() : 0);
                result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The body to use in email messages.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wisdom.*;
     * EmailMessageTemplateContentBodyProperty emailMessageTemplateContentBodyProperty = EmailMessageTemplateContentBodyProperty.builder()
     *         .html(MessageTemplateBodyContentProviderProperty.builder()
     *                 .content("content")
     *                 .build())
     *         .plainText(MessageTemplateBodyContentProviderProperty.builder()
     *                 .content("content")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-emailmessagetemplatecontentbody.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-emailmessagetemplatecontentbody.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wisdom.CfnMessageTemplate.EmailMessageTemplateContentBodyProperty")
    @software.amazon.jsii.Jsii.Proxy(EmailMessageTemplateContentBodyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EmailMessageTemplateContentBodyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The message body, in HTML format, to use in email messages that are based on the message template.
         * <p>
         * We recommend using HTML format for email clients that render HTML content. You can include links, formatted text, and more in an HTML message.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-emailmessagetemplatecontentbody.html#cfn-wisdom-messagetemplate-emailmessagetemplatecontentbody-html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-emailmessagetemplatecontentbody.html#cfn-wisdom-messagetemplate-emailmessagetemplatecontentbody-html</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHtml() {
            return null;
        }

        /**
         * The message body, in plain text format, to use in email messages that are based on the message template.
         * <p>
         * We recommend using plain text format for email clients that don't render HTML content and clients that are connected to high-latency networks, such as mobile devices.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-emailmessagetemplatecontentbody.html#cfn-wisdom-messagetemplate-emailmessagetemplatecontentbody-plaintext">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-emailmessagetemplatecontentbody.html#cfn-wisdom-messagetemplate-emailmessagetemplatecontentbody-plaintext</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPlainText() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EmailMessageTemplateContentBodyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EmailMessageTemplateContentBodyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EmailMessageTemplateContentBodyProperty> {
            java.lang.Object html;
            java.lang.Object plainText;

            /**
             * Sets the value of {@link EmailMessageTemplateContentBodyProperty#getHtml}
             * @param html The message body, in HTML format, to use in email messages that are based on the message template.
             *             We recommend using HTML format for email clients that render HTML content. You can include links, formatted text, and more in an HTML message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder html(software.amazon.awscdk.IResolvable html) {
                this.html = html;
                return this;
            }

            /**
             * Sets the value of {@link EmailMessageTemplateContentBodyProperty#getHtml}
             * @param html The message body, in HTML format, to use in email messages that are based on the message template.
             *             We recommend using HTML format for email clients that render HTML content. You can include links, formatted text, and more in an HTML message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder html(software.amazon.awscdk.services.wisdom.CfnMessageTemplate.MessageTemplateBodyContentProviderProperty html) {
                this.html = html;
                return this;
            }

            /**
             * Sets the value of {@link EmailMessageTemplateContentBodyProperty#getPlainText}
             * @param plainText The message body, in plain text format, to use in email messages that are based on the message template.
             *                  We recommend using plain text format for email clients that don't render HTML content and clients that are connected to high-latency networks, such as mobile devices.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder plainText(software.amazon.awscdk.IResolvable plainText) {
                this.plainText = plainText;
                return this;
            }

            /**
             * Sets the value of {@link EmailMessageTemplateContentBodyProperty#getPlainText}
             * @param plainText The message body, in plain text format, to use in email messages that are based on the message template.
             *                  We recommend using plain text format for email clients that don't render HTML content and clients that are connected to high-latency networks, such as mobile devices.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder plainText(software.amazon.awscdk.services.wisdom.CfnMessageTemplate.MessageTemplateBodyContentProviderProperty plainText) {
                this.plainText = plainText;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EmailMessageTemplateContentBodyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EmailMessageTemplateContentBodyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EmailMessageTemplateContentBodyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EmailMessageTemplateContentBodyProperty {
            private final java.lang.Object html;
            private final java.lang.Object plainText;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.html = software.amazon.jsii.Kernel.get(this, "html", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.plainText = software.amazon.jsii.Kernel.get(this, "plainText", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.html = builder.html;
                this.plainText = builder.plainText;
            }

            @Override
            public final java.lang.Object getHtml() {
                return this.html;
            }

            @Override
            public final java.lang.Object getPlainText() {
                return this.plainText;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getHtml() != null) {
                    data.set("html", om.valueToTree(this.getHtml()));
                }
                if (this.getPlainText() != null) {
                    data.set("plainText", om.valueToTree(this.getPlainText()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wisdom.CfnMessageTemplate.EmailMessageTemplateContentBodyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EmailMessageTemplateContentBodyProperty.Jsii$Proxy that = (EmailMessageTemplateContentBodyProperty.Jsii$Proxy) o;

                if (this.html != null ? !this.html.equals(that.html) : that.html != null) return false;
                return this.plainText != null ? this.plainText.equals(that.plainText) : that.plainText == null;
            }

            @Override
            public final int hashCode() {
                int result = this.html != null ? this.html.hashCode() : 0;
                result = 31 * result + (this.plainText != null ? this.plainText.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The content of the message template that applies to the email channel subtype.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wisdom.*;
     * EmailMessageTemplateContentProperty emailMessageTemplateContentProperty = EmailMessageTemplateContentProperty.builder()
     *         .body(EmailMessageTemplateContentBodyProperty.builder()
     *                 .html(MessageTemplateBodyContentProviderProperty.builder()
     *                         .content("content")
     *                         .build())
     *                 .plainText(MessageTemplateBodyContentProviderProperty.builder()
     *                         .content("content")
     *                         .build())
     *                 .build())
     *         .headers(List.of(EmailMessageTemplateHeaderProperty.builder()
     *                 .name("name")
     *                 .value("value")
     *                 .build()))
     *         .subject("subject")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-emailmessagetemplatecontent.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-emailmessagetemplatecontent.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wisdom.CfnMessageTemplate.EmailMessageTemplateContentProperty")
    @software.amazon.jsii.Jsii.Proxy(EmailMessageTemplateContentProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EmailMessageTemplateContentProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The body to use in email messages.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-emailmessagetemplatecontent.html#cfn-wisdom-messagetemplate-emailmessagetemplatecontent-body">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-emailmessagetemplatecontent.html#cfn-wisdom-messagetemplate-emailmessagetemplatecontent-body</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getBody();

        /**
         * The email headers to include in email messages.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-emailmessagetemplatecontent.html#cfn-wisdom-messagetemplate-emailmessagetemplatecontent-headers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-emailmessagetemplatecontent.html#cfn-wisdom-messagetemplate-emailmessagetemplatecontent-headers</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getHeaders();

        /**
         * The subject line, or title, to use in email messages.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-emailmessagetemplatecontent.html#cfn-wisdom-messagetemplate-emailmessagetemplatecontent-subject">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-emailmessagetemplatecontent.html#cfn-wisdom-messagetemplate-emailmessagetemplatecontent-subject</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSubject();

        /**
         * @return a {@link Builder} of {@link EmailMessageTemplateContentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EmailMessageTemplateContentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EmailMessageTemplateContentProperty> {
            java.lang.Object body;
            java.lang.Object headers;
            java.lang.String subject;

            /**
             * Sets the value of {@link EmailMessageTemplateContentProperty#getBody}
             * @param body The body to use in email messages. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder body(software.amazon.awscdk.IResolvable body) {
                this.body = body;
                return this;
            }

            /**
             * Sets the value of {@link EmailMessageTemplateContentProperty#getBody}
             * @param body The body to use in email messages. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder body(software.amazon.awscdk.services.wisdom.CfnMessageTemplate.EmailMessageTemplateContentBodyProperty body) {
                this.body = body;
                return this;
            }

            /**
             * Sets the value of {@link EmailMessageTemplateContentProperty#getHeaders}
             * @param headers The email headers to include in email messages. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder headers(software.amazon.awscdk.IResolvable headers) {
                this.headers = headers;
                return this;
            }

            /**
             * Sets the value of {@link EmailMessageTemplateContentProperty#getHeaders}
             * @param headers The email headers to include in email messages. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder headers(java.util.List<? extends java.lang.Object> headers) {
                this.headers = headers;
                return this;
            }

            /**
             * Sets the value of {@link EmailMessageTemplateContentProperty#getSubject}
             * @param subject The subject line, or title, to use in email messages. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subject(java.lang.String subject) {
                this.subject = subject;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EmailMessageTemplateContentProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EmailMessageTemplateContentProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EmailMessageTemplateContentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EmailMessageTemplateContentProperty {
            private final java.lang.Object body;
            private final java.lang.Object headers;
            private final java.lang.String subject;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.body = software.amazon.jsii.Kernel.get(this, "body", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.headers = software.amazon.jsii.Kernel.get(this, "headers", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.subject = software.amazon.jsii.Kernel.get(this, "subject", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.body = java.util.Objects.requireNonNull(builder.body, "body is required");
                this.headers = java.util.Objects.requireNonNull(builder.headers, "headers is required");
                this.subject = java.util.Objects.requireNonNull(builder.subject, "subject is required");
            }

            @Override
            public final java.lang.Object getBody() {
                return this.body;
            }

            @Override
            public final java.lang.Object getHeaders() {
                return this.headers;
            }

            @Override
            public final java.lang.String getSubject() {
                return this.subject;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("body", om.valueToTree(this.getBody()));
                data.set("headers", om.valueToTree(this.getHeaders()));
                data.set("subject", om.valueToTree(this.getSubject()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wisdom.CfnMessageTemplate.EmailMessageTemplateContentProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EmailMessageTemplateContentProperty.Jsii$Proxy that = (EmailMessageTemplateContentProperty.Jsii$Proxy) o;

                if (!body.equals(that.body)) return false;
                if (!headers.equals(that.headers)) return false;
                return this.subject.equals(that.subject);
            }

            @Override
            public final int hashCode() {
                int result = this.body.hashCode();
                result = 31 * result + (this.headers.hashCode());
                result = 31 * result + (this.subject.hashCode());
                return result;
            }
        }
    }
    /**
     * The email headers to include in email messages.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wisdom.*;
     * EmailMessageTemplateHeaderProperty emailMessageTemplateHeaderProperty = EmailMessageTemplateHeaderProperty.builder()
     *         .name("name")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-emailmessagetemplateheader.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-emailmessagetemplateheader.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wisdom.CfnMessageTemplate.EmailMessageTemplateHeaderProperty")
    @software.amazon.jsii.Jsii.Proxy(EmailMessageTemplateHeaderProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EmailMessageTemplateHeaderProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the email header.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-emailmessagetemplateheader.html#cfn-wisdom-messagetemplate-emailmessagetemplateheader-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-emailmessagetemplateheader.html#cfn-wisdom-messagetemplate-emailmessagetemplateheader-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * The value of the email header.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-emailmessagetemplateheader.html#cfn-wisdom-messagetemplate-emailmessagetemplateheader-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-emailmessagetemplateheader.html#cfn-wisdom-messagetemplate-emailmessagetemplateheader-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EmailMessageTemplateHeaderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EmailMessageTemplateHeaderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EmailMessageTemplateHeaderProperty> {
            java.lang.String name;
            java.lang.String value;

            /**
             * Sets the value of {@link EmailMessageTemplateHeaderProperty#getName}
             * @param name The name of the email header.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link EmailMessageTemplateHeaderProperty#getValue}
             * @param value The value of the email header.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EmailMessageTemplateHeaderProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EmailMessageTemplateHeaderProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EmailMessageTemplateHeaderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EmailMessageTemplateHeaderProperty {
            private final java.lang.String name;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = builder.name;
                this.value = builder.value;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wisdom.CfnMessageTemplate.EmailMessageTemplateHeaderProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EmailMessageTemplateHeaderProperty.Jsii$Proxy that = (EmailMessageTemplateHeaderProperty.Jsii$Proxy) o;

                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name != null ? this.name.hashCode() : 0;
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration information of the grouping of Amazon Q in Connect users.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wisdom.*;
     * GroupingConfigurationProperty groupingConfigurationProperty = GroupingConfigurationProperty.builder()
     *         .criteria("criteria")
     *         .values(List.of("values"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-groupingconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-groupingconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wisdom.CfnMessageTemplate.GroupingConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(GroupingConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GroupingConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The criteria used for grouping Amazon Q in Connect users.
         * <p>
         * The following is the list of supported criteria values.
         * <p>
         * <ul>
         * <li><code>RoutingProfileArn</code> : Grouping the users by their <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_RoutingProfile.html">Amazon Connect routing profile ARN</a> . User should have <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_SearchRoutingProfiles.html">SearchRoutingProfile</a> and <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribeRoutingProfile.html">DescribeRoutingProfile</a> permissions when setting criteria to this value.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-groupingconfiguration.html#cfn-wisdom-messagetemplate-groupingconfiguration-criteria">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-groupingconfiguration.html#cfn-wisdom-messagetemplate-groupingconfiguration-criteria</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCriteria();

        /**
         * The list of values that define different groups of Amazon Q in Connect users.
         * <p>
         * <ul>
         * <li>When setting <code>criteria</code> to <code>RoutingProfileArn</code> , you need to provide a list of ARNs of <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_RoutingProfile.html">Amazon Connect routing profiles</a> as values of this parameter.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-groupingconfiguration.html#cfn-wisdom-messagetemplate-groupingconfiguration-values">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-groupingconfiguration.html#cfn-wisdom-messagetemplate-groupingconfiguration-values</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getValues();

        /**
         * @return a {@link Builder} of {@link GroupingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GroupingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GroupingConfigurationProperty> {
            java.lang.String criteria;
            java.util.List<java.lang.String> values;

            /**
             * Sets the value of {@link GroupingConfigurationProperty#getCriteria}
             * @param criteria The criteria used for grouping Amazon Q in Connect users. This parameter is required.
             *                 The following is the list of supported criteria values.
             *                 <p>
             *                 <ul>
             *                 <li><code>RoutingProfileArn</code> : Grouping the users by their <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_RoutingProfile.html">Amazon Connect routing profile ARN</a> . User should have <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_SearchRoutingProfiles.html">SearchRoutingProfile</a> and <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribeRoutingProfile.html">DescribeRoutingProfile</a> permissions when setting criteria to this value.</li>
             *                 </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder criteria(java.lang.String criteria) {
                this.criteria = criteria;
                return this;
            }

            /**
             * Sets the value of {@link GroupingConfigurationProperty#getValues}
             * @param values The list of values that define different groups of Amazon Q in Connect users. This parameter is required.
             *               <ul>
             *               <li>When setting <code>criteria</code> to <code>RoutingProfileArn</code> , you need to provide a list of ARNs of <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_RoutingProfile.html">Amazon Connect routing profiles</a> as values of this parameter.</li>
             *               </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder values(java.util.List<java.lang.String> values) {
                this.values = values;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GroupingConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GroupingConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GroupingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GroupingConfigurationProperty {
            private final java.lang.String criteria;
            private final java.util.List<java.lang.String> values;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.criteria = software.amazon.jsii.Kernel.get(this, "criteria", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.values = software.amazon.jsii.Kernel.get(this, "values", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.criteria = java.util.Objects.requireNonNull(builder.criteria, "criteria is required");
                this.values = java.util.Objects.requireNonNull(builder.values, "values is required");
            }

            @Override
            public final java.lang.String getCriteria() {
                return this.criteria;
            }

            @Override
            public final java.util.List<java.lang.String> getValues() {
                return this.values;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("criteria", om.valueToTree(this.getCriteria()));
                data.set("values", om.valueToTree(this.getValues()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wisdom.CfnMessageTemplate.GroupingConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GroupingConfigurationProperty.Jsii$Proxy that = (GroupingConfigurationProperty.Jsii$Proxy) o;

                if (!criteria.equals(that.criteria)) return false;
                return this.values.equals(that.values);
            }

            @Override
            public final int hashCode() {
                int result = this.criteria.hashCode();
                result = 31 * result + (this.values.hashCode());
                return result;
            }
        }
    }
    /**
     * The attributes that are used with the message template.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wisdom.*;
     * MessageTemplateAttributesProperty messageTemplateAttributesProperty = MessageTemplateAttributesProperty.builder()
     *         .agentAttributes(AgentAttributesProperty.builder()
     *                 .firstName("firstName")
     *                 .lastName("lastName")
     *                 .build())
     *         .customAttributes(Map.of(
     *                 "customAttributesKey", "customAttributes"))
     *         .customerProfileAttributes(CustomerProfileAttributesProperty.builder()
     *                 .accountNumber("accountNumber")
     *                 .additionalInformation("additionalInformation")
     *                 .address1("address1")
     *                 .address2("address2")
     *                 .address3("address3")
     *                 .address4("address4")
     *                 .billingAddress1("billingAddress1")
     *                 .billingAddress2("billingAddress2")
     *                 .billingAddress3("billingAddress3")
     *                 .billingAddress4("billingAddress4")
     *                 .billingCity("billingCity")
     *                 .billingCountry("billingCountry")
     *                 .billingCounty("billingCounty")
     *                 .billingPostalCode("billingPostalCode")
     *                 .billingProvince("billingProvince")
     *                 .billingState("billingState")
     *                 .birthDate("birthDate")
     *                 .businessEmailAddress("businessEmailAddress")
     *                 .businessName("businessName")
     *                 .businessPhoneNumber("businessPhoneNumber")
     *                 .city("city")
     *                 .country("country")
     *                 .county("county")
     *                 .custom(Map.of(
     *                         "customKey", "custom"))
     *                 .emailAddress("emailAddress")
     *                 .firstName("firstName")
     *                 .gender("gender")
     *                 .homePhoneNumber("homePhoneNumber")
     *                 .lastName("lastName")
     *                 .mailingAddress1("mailingAddress1")
     *                 .mailingAddress2("mailingAddress2")
     *                 .mailingAddress3("mailingAddress3")
     *                 .mailingAddress4("mailingAddress4")
     *                 .mailingCity("mailingCity")
     *                 .mailingCountry("mailingCountry")
     *                 .mailingCounty("mailingCounty")
     *                 .mailingPostalCode("mailingPostalCode")
     *                 .mailingProvince("mailingProvince")
     *                 .mailingState("mailingState")
     *                 .middleName("middleName")
     *                 .mobilePhoneNumber("mobilePhoneNumber")
     *                 .partyType("partyType")
     *                 .phoneNumber("phoneNumber")
     *                 .postalCode("postalCode")
     *                 .profileArn("profileArn")
     *                 .profileId("profileId")
     *                 .province("province")
     *                 .shippingAddress1("shippingAddress1")
     *                 .shippingAddress2("shippingAddress2")
     *                 .shippingAddress3("shippingAddress3")
     *                 .shippingAddress4("shippingAddress4")
     *                 .shippingCity("shippingCity")
     *                 .shippingCountry("shippingCountry")
     *                 .shippingCounty("shippingCounty")
     *                 .shippingPostalCode("shippingPostalCode")
     *                 .shippingProvince("shippingProvince")
     *                 .shippingState("shippingState")
     *                 .state("state")
     *                 .build())
     *         .systemAttributes(SystemAttributesProperty.builder()
     *                 .customerEndpoint(SystemEndpointAttributesProperty.builder()
     *                         .address("address")
     *                         .build())
     *                 .name("name")
     *                 .systemEndpoint(SystemEndpointAttributesProperty.builder()
     *                         .address("address")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-messagetemplateattributes.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-messagetemplateattributes.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wisdom.CfnMessageTemplate.MessageTemplateAttributesProperty")
    @software.amazon.jsii.Jsii.Proxy(MessageTemplateAttributesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MessageTemplateAttributesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The agent attributes that are used with the message template.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-messagetemplateattributes.html#cfn-wisdom-messagetemplate-messagetemplateattributes-agentattributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-messagetemplateattributes.html#cfn-wisdom-messagetemplate-messagetemplateattributes-agentattributes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAgentAttributes() {
            return null;
        }

        /**
         * The custom attributes that are used with the message template.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-messagetemplateattributes.html#cfn-wisdom-messagetemplate-messagetemplateattributes-customattributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-messagetemplateattributes.html#cfn-wisdom-messagetemplate-messagetemplateattributes-customattributes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomAttributes() {
            return null;
        }

        /**
         * The customer profile attributes that are used with the message template.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-messagetemplateattributes.html#cfn-wisdom-messagetemplate-messagetemplateattributes-customerprofileattributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-messagetemplateattributes.html#cfn-wisdom-messagetemplate-messagetemplateattributes-customerprofileattributes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomerProfileAttributes() {
            return null;
        }

        /**
         * The system attributes that are used with the message template.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-messagetemplateattributes.html#cfn-wisdom-messagetemplate-messagetemplateattributes-systemattributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-messagetemplateattributes.html#cfn-wisdom-messagetemplate-messagetemplateattributes-systemattributes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSystemAttributes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MessageTemplateAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MessageTemplateAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MessageTemplateAttributesProperty> {
            java.lang.Object agentAttributes;
            java.lang.Object customAttributes;
            java.lang.Object customerProfileAttributes;
            java.lang.Object systemAttributes;

            /**
             * Sets the value of {@link MessageTemplateAttributesProperty#getAgentAttributes}
             * @param agentAttributes The agent attributes that are used with the message template.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder agentAttributes(software.amazon.awscdk.IResolvable agentAttributes) {
                this.agentAttributes = agentAttributes;
                return this;
            }

            /**
             * Sets the value of {@link MessageTemplateAttributesProperty#getAgentAttributes}
             * @param agentAttributes The agent attributes that are used with the message template.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder agentAttributes(software.amazon.awscdk.services.wisdom.CfnMessageTemplate.AgentAttributesProperty agentAttributes) {
                this.agentAttributes = agentAttributes;
                return this;
            }

            /**
             * Sets the value of {@link MessageTemplateAttributesProperty#getCustomAttributes}
             * @param customAttributes The custom attributes that are used with the message template.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customAttributes(java.util.Map<java.lang.String, java.lang.String> customAttributes) {
                this.customAttributes = customAttributes;
                return this;
            }

            /**
             * Sets the value of {@link MessageTemplateAttributesProperty#getCustomAttributes}
             * @param customAttributes The custom attributes that are used with the message template.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customAttributes(software.amazon.awscdk.IResolvable customAttributes) {
                this.customAttributes = customAttributes;
                return this;
            }

            /**
             * Sets the value of {@link MessageTemplateAttributesProperty#getCustomerProfileAttributes}
             * @param customerProfileAttributes The customer profile attributes that are used with the message template.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customerProfileAttributes(software.amazon.awscdk.IResolvable customerProfileAttributes) {
                this.customerProfileAttributes = customerProfileAttributes;
                return this;
            }

            /**
             * Sets the value of {@link MessageTemplateAttributesProperty#getCustomerProfileAttributes}
             * @param customerProfileAttributes The customer profile attributes that are used with the message template.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customerProfileAttributes(software.amazon.awscdk.services.wisdom.CfnMessageTemplate.CustomerProfileAttributesProperty customerProfileAttributes) {
                this.customerProfileAttributes = customerProfileAttributes;
                return this;
            }

            /**
             * Sets the value of {@link MessageTemplateAttributesProperty#getSystemAttributes}
             * @param systemAttributes The system attributes that are used with the message template.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder systemAttributes(software.amazon.awscdk.IResolvable systemAttributes) {
                this.systemAttributes = systemAttributes;
                return this;
            }

            /**
             * Sets the value of {@link MessageTemplateAttributesProperty#getSystemAttributes}
             * @param systemAttributes The system attributes that are used with the message template.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder systemAttributes(software.amazon.awscdk.services.wisdom.CfnMessageTemplate.SystemAttributesProperty systemAttributes) {
                this.systemAttributes = systemAttributes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MessageTemplateAttributesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MessageTemplateAttributesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MessageTemplateAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MessageTemplateAttributesProperty {
            private final java.lang.Object agentAttributes;
            private final java.lang.Object customAttributes;
            private final java.lang.Object customerProfileAttributes;
            private final java.lang.Object systemAttributes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.agentAttributes = software.amazon.jsii.Kernel.get(this, "agentAttributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.customAttributes = software.amazon.jsii.Kernel.get(this, "customAttributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.customerProfileAttributes = software.amazon.jsii.Kernel.get(this, "customerProfileAttributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.systemAttributes = software.amazon.jsii.Kernel.get(this, "systemAttributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.agentAttributes = builder.agentAttributes;
                this.customAttributes = builder.customAttributes;
                this.customerProfileAttributes = builder.customerProfileAttributes;
                this.systemAttributes = builder.systemAttributes;
            }

            @Override
            public final java.lang.Object getAgentAttributes() {
                return this.agentAttributes;
            }

            @Override
            public final java.lang.Object getCustomAttributes() {
                return this.customAttributes;
            }

            @Override
            public final java.lang.Object getCustomerProfileAttributes() {
                return this.customerProfileAttributes;
            }

            @Override
            public final java.lang.Object getSystemAttributes() {
                return this.systemAttributes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAgentAttributes() != null) {
                    data.set("agentAttributes", om.valueToTree(this.getAgentAttributes()));
                }
                if (this.getCustomAttributes() != null) {
                    data.set("customAttributes", om.valueToTree(this.getCustomAttributes()));
                }
                if (this.getCustomerProfileAttributes() != null) {
                    data.set("customerProfileAttributes", om.valueToTree(this.getCustomerProfileAttributes()));
                }
                if (this.getSystemAttributes() != null) {
                    data.set("systemAttributes", om.valueToTree(this.getSystemAttributes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wisdom.CfnMessageTemplate.MessageTemplateAttributesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MessageTemplateAttributesProperty.Jsii$Proxy that = (MessageTemplateAttributesProperty.Jsii$Proxy) o;

                if (this.agentAttributes != null ? !this.agentAttributes.equals(that.agentAttributes) : that.agentAttributes != null) return false;
                if (this.customAttributes != null ? !this.customAttributes.equals(that.customAttributes) : that.customAttributes != null) return false;
                if (this.customerProfileAttributes != null ? !this.customerProfileAttributes.equals(that.customerProfileAttributes) : that.customerProfileAttributes != null) return false;
                return this.systemAttributes != null ? this.systemAttributes.equals(that.systemAttributes) : that.systemAttributes == null;
            }

            @Override
            public final int hashCode() {
                int result = this.agentAttributes != null ? this.agentAttributes.hashCode() : 0;
                result = 31 * result + (this.customAttributes != null ? this.customAttributes.hashCode() : 0);
                result = 31 * result + (this.customerProfileAttributes != null ? this.customerProfileAttributes.hashCode() : 0);
                result = 31 * result + (this.systemAttributes != null ? this.systemAttributes.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The container of the message template body.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wisdom.*;
     * MessageTemplateBodyContentProviderProperty messageTemplateBodyContentProviderProperty = MessageTemplateBodyContentProviderProperty.builder()
     *         .content("content")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-messagetemplatebodycontentprovider.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-messagetemplatebodycontentprovider.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wisdom.CfnMessageTemplate.MessageTemplateBodyContentProviderProperty")
    @software.amazon.jsii.Jsii.Proxy(MessageTemplateBodyContentProviderProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MessageTemplateBodyContentProviderProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The content of the message template.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-messagetemplatebodycontentprovider.html#cfn-wisdom-messagetemplate-messagetemplatebodycontentprovider-content">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-messagetemplatebodycontentprovider.html#cfn-wisdom-messagetemplate-messagetemplatebodycontentprovider-content</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getContent() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MessageTemplateBodyContentProviderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MessageTemplateBodyContentProviderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MessageTemplateBodyContentProviderProperty> {
            java.lang.String content;

            /**
             * Sets the value of {@link MessageTemplateBodyContentProviderProperty#getContent}
             * @param content The content of the message template.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder content(java.lang.String content) {
                this.content = content;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MessageTemplateBodyContentProviderProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MessageTemplateBodyContentProviderProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MessageTemplateBodyContentProviderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MessageTemplateBodyContentProviderProperty {
            private final java.lang.String content;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.content = software.amazon.jsii.Kernel.get(this, "content", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.content = builder.content;
            }

            @Override
            public final java.lang.String getContent() {
                return this.content;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getContent() != null) {
                    data.set("content", om.valueToTree(this.getContent()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wisdom.CfnMessageTemplate.MessageTemplateBodyContentProviderProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MessageTemplateBodyContentProviderProperty.Jsii$Proxy that = (MessageTemplateBodyContentProviderProperty.Jsii$Proxy) o;

                return this.content != null ? this.content.equals(that.content) : that.content == null;
            }

            @Override
            public final int hashCode() {
                int result = this.content != null ? this.content.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The body to use in SMS messages.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wisdom.*;
     * SmsMessageTemplateContentBodyProperty smsMessageTemplateContentBodyProperty = SmsMessageTemplateContentBodyProperty.builder()
     *         .plainText(MessageTemplateBodyContentProviderProperty.builder()
     *                 .content("content")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-smsmessagetemplatecontentbody.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-smsmessagetemplatecontentbody.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wisdom.CfnMessageTemplate.SmsMessageTemplateContentBodyProperty")
    @software.amazon.jsii.Jsii.Proxy(SmsMessageTemplateContentBodyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SmsMessageTemplateContentBodyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The message body to use in SMS messages.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-smsmessagetemplatecontentbody.html#cfn-wisdom-messagetemplate-smsmessagetemplatecontentbody-plaintext">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-smsmessagetemplatecontentbody.html#cfn-wisdom-messagetemplate-smsmessagetemplatecontentbody-plaintext</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPlainText() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SmsMessageTemplateContentBodyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SmsMessageTemplateContentBodyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SmsMessageTemplateContentBodyProperty> {
            java.lang.Object plainText;

            /**
             * Sets the value of {@link SmsMessageTemplateContentBodyProperty#getPlainText}
             * @param plainText The message body to use in SMS messages.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder plainText(software.amazon.awscdk.IResolvable plainText) {
                this.plainText = plainText;
                return this;
            }

            /**
             * Sets the value of {@link SmsMessageTemplateContentBodyProperty#getPlainText}
             * @param plainText The message body to use in SMS messages.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder plainText(software.amazon.awscdk.services.wisdom.CfnMessageTemplate.MessageTemplateBodyContentProviderProperty plainText) {
                this.plainText = plainText;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SmsMessageTemplateContentBodyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SmsMessageTemplateContentBodyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SmsMessageTemplateContentBodyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SmsMessageTemplateContentBodyProperty {
            private final java.lang.Object plainText;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.plainText = software.amazon.jsii.Kernel.get(this, "plainText", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.plainText = builder.plainText;
            }

            @Override
            public final java.lang.Object getPlainText() {
                return this.plainText;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getPlainText() != null) {
                    data.set("plainText", om.valueToTree(this.getPlainText()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wisdom.CfnMessageTemplate.SmsMessageTemplateContentBodyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SmsMessageTemplateContentBodyProperty.Jsii$Proxy that = (SmsMessageTemplateContentBodyProperty.Jsii$Proxy) o;

                return this.plainText != null ? this.plainText.equals(that.plainText) : that.plainText == null;
            }

            @Override
            public final int hashCode() {
                int result = this.plainText != null ? this.plainText.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The content of the message template that applies to the SMS channel subtype.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wisdom.*;
     * SmsMessageTemplateContentProperty smsMessageTemplateContentProperty = SmsMessageTemplateContentProperty.builder()
     *         .body(SmsMessageTemplateContentBodyProperty.builder()
     *                 .plainText(MessageTemplateBodyContentProviderProperty.builder()
     *                         .content("content")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-smsmessagetemplatecontent.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-smsmessagetemplatecontent.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wisdom.CfnMessageTemplate.SmsMessageTemplateContentProperty")
    @software.amazon.jsii.Jsii.Proxy(SmsMessageTemplateContentProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SmsMessageTemplateContentProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The body to use in SMS messages.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-smsmessagetemplatecontent.html#cfn-wisdom-messagetemplate-smsmessagetemplatecontent-body">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-smsmessagetemplatecontent.html#cfn-wisdom-messagetemplate-smsmessagetemplatecontent-body</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getBody();

        /**
         * @return a {@link Builder} of {@link SmsMessageTemplateContentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SmsMessageTemplateContentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SmsMessageTemplateContentProperty> {
            java.lang.Object body;

            /**
             * Sets the value of {@link SmsMessageTemplateContentProperty#getBody}
             * @param body The body to use in SMS messages. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder body(software.amazon.awscdk.IResolvable body) {
                this.body = body;
                return this;
            }

            /**
             * Sets the value of {@link SmsMessageTemplateContentProperty#getBody}
             * @param body The body to use in SMS messages. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder body(software.amazon.awscdk.services.wisdom.CfnMessageTemplate.SmsMessageTemplateContentBodyProperty body) {
                this.body = body;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SmsMessageTemplateContentProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SmsMessageTemplateContentProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SmsMessageTemplateContentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SmsMessageTemplateContentProperty {
            private final java.lang.Object body;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.body = software.amazon.jsii.Kernel.get(this, "body", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.body = java.util.Objects.requireNonNull(builder.body, "body is required");
            }

            @Override
            public final java.lang.Object getBody() {
                return this.body;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("body", om.valueToTree(this.getBody()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wisdom.CfnMessageTemplate.SmsMessageTemplateContentProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SmsMessageTemplateContentProperty.Jsii$Proxy that = (SmsMessageTemplateContentProperty.Jsii$Proxy) o;

                return this.body.equals(that.body);
            }

            @Override
            public final int hashCode() {
                int result = this.body.hashCode();
                return result;
            }
        }
    }
    /**
     * The system attributes that are used with the message template.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wisdom.*;
     * SystemAttributesProperty systemAttributesProperty = SystemAttributesProperty.builder()
     *         .customerEndpoint(SystemEndpointAttributesProperty.builder()
     *                 .address("address")
     *                 .build())
     *         .name("name")
     *         .systemEndpoint(SystemEndpointAttributesProperty.builder()
     *                 .address("address")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-systemattributes.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-systemattributes.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wisdom.CfnMessageTemplate.SystemAttributesProperty")
    @software.amazon.jsii.Jsii.Proxy(SystemAttributesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SystemAttributesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The CustomerEndpoint attribute.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-systemattributes.html#cfn-wisdom-messagetemplate-systemattributes-customerendpoint">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-systemattributes.html#cfn-wisdom-messagetemplate-systemattributes-customerendpoint</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomerEndpoint() {
            return null;
        }

        /**
         * The name of the task.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-systemattributes.html#cfn-wisdom-messagetemplate-systemattributes-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-systemattributes.html#cfn-wisdom-messagetemplate-systemattributes-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * The SystemEndpoint attribute.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-systemattributes.html#cfn-wisdom-messagetemplate-systemattributes-systemendpoint">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-systemattributes.html#cfn-wisdom-messagetemplate-systemattributes-systemendpoint</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSystemEndpoint() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SystemAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SystemAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SystemAttributesProperty> {
            java.lang.Object customerEndpoint;
            java.lang.String name;
            java.lang.Object systemEndpoint;

            /**
             * Sets the value of {@link SystemAttributesProperty#getCustomerEndpoint}
             * @param customerEndpoint The CustomerEndpoint attribute.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customerEndpoint(software.amazon.awscdk.IResolvable customerEndpoint) {
                this.customerEndpoint = customerEndpoint;
                return this;
            }

            /**
             * Sets the value of {@link SystemAttributesProperty#getCustomerEndpoint}
             * @param customerEndpoint The CustomerEndpoint attribute.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customerEndpoint(software.amazon.awscdk.services.wisdom.CfnMessageTemplate.SystemEndpointAttributesProperty customerEndpoint) {
                this.customerEndpoint = customerEndpoint;
                return this;
            }

            /**
             * Sets the value of {@link SystemAttributesProperty#getName}
             * @param name The name of the task.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link SystemAttributesProperty#getSystemEndpoint}
             * @param systemEndpoint The SystemEndpoint attribute.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder systemEndpoint(software.amazon.awscdk.IResolvable systemEndpoint) {
                this.systemEndpoint = systemEndpoint;
                return this;
            }

            /**
             * Sets the value of {@link SystemAttributesProperty#getSystemEndpoint}
             * @param systemEndpoint The SystemEndpoint attribute.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder systemEndpoint(software.amazon.awscdk.services.wisdom.CfnMessageTemplate.SystemEndpointAttributesProperty systemEndpoint) {
                this.systemEndpoint = systemEndpoint;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SystemAttributesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SystemAttributesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SystemAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SystemAttributesProperty {
            private final java.lang.Object customerEndpoint;
            private final java.lang.String name;
            private final java.lang.Object systemEndpoint;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.customerEndpoint = software.amazon.jsii.Kernel.get(this, "customerEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.systemEndpoint = software.amazon.jsii.Kernel.get(this, "systemEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.customerEndpoint = builder.customerEndpoint;
                this.name = builder.name;
                this.systemEndpoint = builder.systemEndpoint;
            }

            @Override
            public final java.lang.Object getCustomerEndpoint() {
                return this.customerEndpoint;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Object getSystemEndpoint() {
                return this.systemEndpoint;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCustomerEndpoint() != null) {
                    data.set("customerEndpoint", om.valueToTree(this.getCustomerEndpoint()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getSystemEndpoint() != null) {
                    data.set("systemEndpoint", om.valueToTree(this.getSystemEndpoint()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wisdom.CfnMessageTemplate.SystemAttributesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SystemAttributesProperty.Jsii$Proxy that = (SystemAttributesProperty.Jsii$Proxy) o;

                if (this.customerEndpoint != null ? !this.customerEndpoint.equals(that.customerEndpoint) : that.customerEndpoint != null) return false;
                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                return this.systemEndpoint != null ? this.systemEndpoint.equals(that.systemEndpoint) : that.systemEndpoint == null;
            }

            @Override
            public final int hashCode() {
                int result = this.customerEndpoint != null ? this.customerEndpoint.hashCode() : 0;
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                result = 31 * result + (this.systemEndpoint != null ? this.systemEndpoint.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The system endpoint attributes that are used with the message template.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wisdom.*;
     * SystemEndpointAttributesProperty systemEndpointAttributesProperty = SystemEndpointAttributesProperty.builder()
     *         .address("address")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-systemendpointattributes.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-systemendpointattributes.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wisdom.CfnMessageTemplate.SystemEndpointAttributesProperty")
    @software.amazon.jsii.Jsii.Proxy(SystemEndpointAttributesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SystemEndpointAttributesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The customer's phone number if used with <code>customerEndpoint</code> , or the number the customer dialed to call your contact center if used with <code>systemEndpoint</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-systemendpointattributes.html#cfn-wisdom-messagetemplate-systemendpointattributes-address">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-messagetemplate-systemendpointattributes.html#cfn-wisdom-messagetemplate-systemendpointattributes-address</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAddress() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SystemEndpointAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SystemEndpointAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SystemEndpointAttributesProperty> {
            java.lang.String address;

            /**
             * Sets the value of {@link SystemEndpointAttributesProperty#getAddress}
             * @param address The customer's phone number if used with <code>customerEndpoint</code> , or the number the customer dialed to call your contact center if used with <code>systemEndpoint</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder address(java.lang.String address) {
                this.address = address;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SystemEndpointAttributesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SystemEndpointAttributesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SystemEndpointAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SystemEndpointAttributesProperty {
            private final java.lang.String address;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.address = software.amazon.jsii.Kernel.get(this, "address", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.address = builder.address;
            }

            @Override
            public final java.lang.String getAddress() {
                return this.address;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAddress() != null) {
                    data.set("address", om.valueToTree(this.getAddress()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wisdom.CfnMessageTemplate.SystemEndpointAttributesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SystemEndpointAttributesProperty.Jsii$Proxy that = (SystemEndpointAttributesProperty.Jsii$Proxy) o;

                return this.address != null ? this.address.equals(that.address) : that.address == null;
            }

            @Override
            public final int hashCode() {
                int result = this.address != null ? this.address.hashCode() : 0;
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.wisdom.CfnMessageTemplate}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.wisdom.CfnMessageTemplate> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.wisdom.CfnMessageTemplateProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.wisdom.CfnMessageTemplateProps.Builder();
        }

        /**
         * The channel subtype this message template applies to.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-messagetemplate.html#cfn-wisdom-messagetemplate-channelsubtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-messagetemplate.html#cfn-wisdom-messagetemplate-channelsubtype</a>
         * @param channelSubtype The channel subtype this message template applies to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder channelSubtype(final java.lang.String channelSubtype) {
            this.props.channelSubtype(channelSubtype);
            return this;
        }

        /**
         * The content of the message template.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-messagetemplate.html#cfn-wisdom-messagetemplate-content">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-messagetemplate.html#cfn-wisdom-messagetemplate-content</a>
         * @param content The content of the message template. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder content(final software.amazon.awscdk.IResolvable content) {
            this.props.content(content);
            return this;
        }
        /**
         * The content of the message template.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-messagetemplate.html#cfn-wisdom-messagetemplate-content">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-messagetemplate.html#cfn-wisdom-messagetemplate-content</a>
         * @param content The content of the message template. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder content(final software.amazon.awscdk.services.wisdom.CfnMessageTemplate.ContentProperty content) {
            this.props.content(content);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the knowledge base.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-messagetemplate.html#cfn-wisdom-messagetemplate-knowledgebasearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-messagetemplate.html#cfn-wisdom-messagetemplate-knowledgebasearn</a>
         * @param knowledgeBaseArn The Amazon Resource Name (ARN) of the knowledge base. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder knowledgeBaseArn(final java.lang.String knowledgeBaseArn) {
            this.props.knowledgeBaseArn(knowledgeBaseArn);
            return this;
        }

        /**
         * The name of the message template.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-messagetemplate.html#cfn-wisdom-messagetemplate-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-messagetemplate.html#cfn-wisdom-messagetemplate-name</a>
         * @param name The name of the message template. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * An object that specifies the default values to use for variables in the message template.
         * <p>
         * This object contains different categories of key-value pairs. Each key defines a variable or placeholder in the message template. The corresponding value defines the default value for that variable.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-messagetemplate.html#cfn-wisdom-messagetemplate-defaultattributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-messagetemplate.html#cfn-wisdom-messagetemplate-defaultattributes</a>
         * @param defaultAttributes An object that specifies the default values to use for variables in the message template. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultAttributes(final software.amazon.awscdk.IResolvable defaultAttributes) {
            this.props.defaultAttributes(defaultAttributes);
            return this;
        }
        /**
         * An object that specifies the default values to use for variables in the message template.
         * <p>
         * This object contains different categories of key-value pairs. Each key defines a variable or placeholder in the message template. The corresponding value defines the default value for that variable.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-messagetemplate.html#cfn-wisdom-messagetemplate-defaultattributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-messagetemplate.html#cfn-wisdom-messagetemplate-defaultattributes</a>
         * @param defaultAttributes An object that specifies the default values to use for variables in the message template. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultAttributes(final software.amazon.awscdk.services.wisdom.CfnMessageTemplate.MessageTemplateAttributesProperty defaultAttributes) {
            this.props.defaultAttributes(defaultAttributes);
            return this;
        }

        /**
         * The description of the message template.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-messagetemplate.html#cfn-wisdom-messagetemplate-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-messagetemplate.html#cfn-wisdom-messagetemplate-description</a>
         * @param description The description of the message template. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The configuration information of the external data source.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-messagetemplate.html#cfn-wisdom-messagetemplate-groupingconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-messagetemplate.html#cfn-wisdom-messagetemplate-groupingconfiguration</a>
         * @param groupingConfiguration The configuration information of the external data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder groupingConfiguration(final software.amazon.awscdk.IResolvable groupingConfiguration) {
            this.props.groupingConfiguration(groupingConfiguration);
            return this;
        }
        /**
         * The configuration information of the external data source.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-messagetemplate.html#cfn-wisdom-messagetemplate-groupingconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-messagetemplate.html#cfn-wisdom-messagetemplate-groupingconfiguration</a>
         * @param groupingConfiguration The configuration information of the external data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder groupingConfiguration(final software.amazon.awscdk.services.wisdom.CfnMessageTemplate.GroupingConfigurationProperty groupingConfiguration) {
            this.props.groupingConfiguration(groupingConfiguration);
            return this;
        }

        /**
         * The language code value for the language in which the quick response is written.
         * <p>
         * The supported language codes include <code>de_DE</code> , <code>en_US</code> , <code>es_ES</code> , <code>fr_FR</code> , <code>id_ID</code> , <code>it_IT</code> , <code>ja_JP</code> , <code>ko_KR</code> , <code>pt_BR</code> , <code>zh_CN</code> , <code>zh_TW</code>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-messagetemplate.html#cfn-wisdom-messagetemplate-language">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-messagetemplate.html#cfn-wisdom-messagetemplate-language</a>
         * @param language The language code value for the language in which the quick response is written. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder language(final java.lang.String language) {
            this.props.language(language);
            return this;
        }

        /**
         * The tags used to organize, track, or control access for this resource.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-messagetemplate.html#cfn-wisdom-messagetemplate-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-messagetemplate.html#cfn-wisdom-messagetemplate-tags</a>
         * @param tags The tags used to organize, track, or control access for this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.wisdom.CfnMessageTemplate}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.wisdom.CfnMessageTemplate build() {
            return new software.amazon.awscdk.services.wisdom.CfnMessageTemplate(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
