package software.amazon.awscdk.services.stepfunctions;

/**
 * The result of a Pass operation.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Makes the current JSON state { ..., "subObject": { "hello": "world" } }
 * Pass pass = Pass.Builder.create(this, "Add Hello World")
 *         .result(Result.fromObject(Map.of("hello", "world")))
 *         .resultPath("$.subObject")
 *         .build();
 * // Set the next state
 * Pass nextState = new Pass(this, "NextState");
 * pass.next(nextState);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:21.351Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.Result")
public class Result extends software.amazon.jsii.JsiiObject {

    protected Result(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Result(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param value result of the Pass operation. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected Result(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { value });
    }

    /**
     * The result of the operation is an array.
     * <p>
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Result fromArray(final @org.jetbrains.annotations.NotNull java.util.List<? extends java.lang.Object> value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Result.class, "fromArray", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Result.class), new Object[] { java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * The result of the operation is a boolean.
     * <p>
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Result fromBoolean(final @org.jetbrains.annotations.NotNull java.lang.Boolean value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Result.class, "fromBoolean", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Result.class), new Object[] { java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * The result of the operation is a number.
     * <p>
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Result fromNumber(final @org.jetbrains.annotations.NotNull java.lang.Number value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Result.class, "fromNumber", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Result.class), new Object[] { java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * The result of the operation is an object.
     * <p>
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Result fromObject(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, ? extends java.lang.Object> value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Result.class, "fromObject", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Result.class), new Object[] { java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * The result of the operation is a string.
     * <p>
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Result fromString(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Result.class, "fromString", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Result.class), new Object[] { java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * result of the Pass operation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getValue() {
        return software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }
}
