package software.amazon.awscdk.services.ssmincidents;

/**
 * Properties for defining a <code>CfnResponsePlan</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ssmincidents.*;
 * CfnResponsePlanProps cfnResponsePlanProps = CfnResponsePlanProps.builder()
 *         .incidentTemplate(IncidentTemplateProperty.builder()
 *                 .impact(123)
 *                 .title("title")
 *                 // the properties below are optional
 *                 .dedupeString("dedupeString")
 *                 .incidentTags(List.of(CfnTag.builder()
 *                         .key("key")
 *                         .value("value")
 *                         .build()))
 *                 .notificationTargets(List.of(NotificationTargetItemProperty.builder()
 *                         .snsTopicArn("snsTopicArn")
 *                         .build()))
 *                 .summary("summary")
 *                 .build())
 *         .name("name")
 *         // the properties below are optional
 *         .actions(List.of(ActionProperty.builder()
 *                 .ssmAutomation(SsmAutomationProperty.builder()
 *                         .documentName("documentName")
 *                         .roleArn("roleArn")
 *                         // the properties below are optional
 *                         .documentVersion("documentVersion")
 *                         .dynamicParameters(List.of(DynamicSsmParameterProperty.builder()
 *                                 .key("key")
 *                                 .value(DynamicSsmParameterValueProperty.builder()
 *                                         .variable("variable")
 *                                         .build())
 *                                 .build()))
 *                         .parameters(List.of(SsmParameterProperty.builder()
 *                                 .key("key")
 *                                 .values(List.of("values"))
 *                                 .build()))
 *                         .targetAccount("targetAccount")
 *                         .build())
 *                 .build()))
 *         .chatChannel(ChatChannelProperty.builder()
 *                 .chatbotSns(List.of("chatbotSns"))
 *                 .build())
 *         .displayName("displayName")
 *         .engagements(List.of("engagements"))
 *         .integrations(List.of(IntegrationProperty.builder()
 *                 .pagerDutyConfiguration(PagerDutyConfigurationProperty.builder()
 *                         .name("name")
 *                         .pagerDutyIncidentConfiguration(PagerDutyIncidentConfigurationProperty.builder()
 *                                 .serviceId("serviceId")
 *                                 .build())
 *                         .secretId("secretId")
 *                         .build())
 *                 .build()))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmincidents-responseplan.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmincidents-responseplan.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:21.204Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ssmincidents.CfnResponsePlanProps")
@software.amazon.jsii.Jsii.Proxy(CfnResponsePlanProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnResponsePlanProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Details used to create an incident when using this response plan.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmincidents-responseplan.html#cfn-ssmincidents-responseplan-incidenttemplate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmincidents-responseplan.html#cfn-ssmincidents-responseplan-incidenttemplate</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getIncidentTemplate();

    /**
     * The name of the response plan.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmincidents-responseplan.html#cfn-ssmincidents-responseplan-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmincidents-responseplan.html#cfn-ssmincidents-responseplan-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The actions that the response plan starts at the beginning of an incident.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmincidents-responseplan.html#cfn-ssmincidents-responseplan-actions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmincidents-responseplan.html#cfn-ssmincidents-responseplan-actions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getActions() {
        return null;
    }

    /**
     * The  chat channel used for collaboration during an incident.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmincidents-responseplan.html#cfn-ssmincidents-responseplan-chatchannel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmincidents-responseplan.html#cfn-ssmincidents-responseplan-chatchannel</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getChatChannel() {
        return null;
    }

    /**
     * The human readable name of the response plan.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmincidents-responseplan.html#cfn-ssmincidents-responseplan-displayname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmincidents-responseplan.html#cfn-ssmincidents-responseplan-displayname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDisplayName() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) for the contacts and escalation plans that the response plan engages during an incident.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmincidents-responseplan.html#cfn-ssmincidents-responseplan-engagements">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmincidents-responseplan.html#cfn-ssmincidents-responseplan-engagements</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getEngagements() {
        return null;
    }

    /**
     * Information about third-party services integrated into the response plan.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmincidents-responseplan.html#cfn-ssmincidents-responseplan-integrations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmincidents-responseplan.html#cfn-ssmincidents-responseplan-integrations</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getIntegrations() {
        return null;
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmincidents-responseplan.html#cfn-ssmincidents-responseplan-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssmincidents-responseplan.html#cfn-ssmincidents-responseplan-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnResponsePlanProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnResponsePlanProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnResponsePlanProps> {
        java.lang.Object incidentTemplate;
        java.lang.String name;
        java.lang.Object actions;
        java.lang.Object chatChannel;
        java.lang.String displayName;
        java.util.List<java.lang.String> engagements;
        java.lang.Object integrations;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnResponsePlanProps#getIncidentTemplate}
         * @param incidentTemplate Details used to create an incident when using this response plan. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder incidentTemplate(software.amazon.awscdk.IResolvable incidentTemplate) {
            this.incidentTemplate = incidentTemplate;
            return this;
        }

        /**
         * Sets the value of {@link CfnResponsePlanProps#getIncidentTemplate}
         * @param incidentTemplate Details used to create an incident when using this response plan. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder incidentTemplate(software.amazon.awscdk.services.ssmincidents.CfnResponsePlan.IncidentTemplateProperty incidentTemplate) {
            this.incidentTemplate = incidentTemplate;
            return this;
        }

        /**
         * Sets the value of {@link CfnResponsePlanProps#getName}
         * @param name The name of the response plan. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnResponsePlanProps#getActions}
         * @param actions The actions that the response plan starts at the beginning of an incident.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actions(software.amazon.awscdk.IResolvable actions) {
            this.actions = actions;
            return this;
        }

        /**
         * Sets the value of {@link CfnResponsePlanProps#getActions}
         * @param actions The actions that the response plan starts at the beginning of an incident.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actions(java.util.List<? extends java.lang.Object> actions) {
            this.actions = actions;
            return this;
        }

        /**
         * Sets the value of {@link CfnResponsePlanProps#getChatChannel}
         * @param chatChannel The  chat channel used for collaboration during an incident.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder chatChannel(software.amazon.awscdk.IResolvable chatChannel) {
            this.chatChannel = chatChannel;
            return this;
        }

        /**
         * Sets the value of {@link CfnResponsePlanProps#getChatChannel}
         * @param chatChannel The  chat channel used for collaboration during an incident.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder chatChannel(software.amazon.awscdk.services.ssmincidents.CfnResponsePlan.ChatChannelProperty chatChannel) {
            this.chatChannel = chatChannel;
            return this;
        }

        /**
         * Sets the value of {@link CfnResponsePlanProps#getDisplayName}
         * @param displayName The human readable name of the response plan.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder displayName(java.lang.String displayName) {
            this.displayName = displayName;
            return this;
        }

        /**
         * Sets the value of {@link CfnResponsePlanProps#getEngagements}
         * @param engagements The Amazon Resource Name (ARN) for the contacts and escalation plans that the response plan engages during an incident.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engagements(java.util.List<java.lang.String> engagements) {
            this.engagements = engagements;
            return this;
        }

        /**
         * Sets the value of {@link CfnResponsePlanProps#getIntegrations}
         * @param integrations Information about third-party services integrated into the response plan.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrations(software.amazon.awscdk.IResolvable integrations) {
            this.integrations = integrations;
            return this;
        }

        /**
         * Sets the value of {@link CfnResponsePlanProps#getIntegrations}
         * @param integrations Information about third-party services integrated into the response plan.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrations(java.util.List<? extends java.lang.Object> integrations) {
            this.integrations = integrations;
            return this;
        }

        /**
         * Sets the value of {@link CfnResponsePlanProps#getTags}
         * @param tags An array of key-value pairs to apply to this resource.
         *             For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnResponsePlanProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnResponsePlanProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnResponsePlanProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnResponsePlanProps {
        private final java.lang.Object incidentTemplate;
        private final java.lang.String name;
        private final java.lang.Object actions;
        private final java.lang.Object chatChannel;
        private final java.lang.String displayName;
        private final java.util.List<java.lang.String> engagements;
        private final java.lang.Object integrations;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.incidentTemplate = software.amazon.jsii.Kernel.get(this, "incidentTemplate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.actions = software.amazon.jsii.Kernel.get(this, "actions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.chatChannel = software.amazon.jsii.Kernel.get(this, "chatChannel", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.displayName = software.amazon.jsii.Kernel.get(this, "displayName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.engagements = software.amazon.jsii.Kernel.get(this, "engagements", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.integrations = software.amazon.jsii.Kernel.get(this, "integrations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.incidentTemplate = java.util.Objects.requireNonNull(builder.incidentTemplate, "incidentTemplate is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.actions = builder.actions;
            this.chatChannel = builder.chatChannel;
            this.displayName = builder.displayName;
            this.engagements = builder.engagements;
            this.integrations = builder.integrations;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getIncidentTemplate() {
            return this.incidentTemplate;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getActions() {
            return this.actions;
        }

        @Override
        public final java.lang.Object getChatChannel() {
            return this.chatChannel;
        }

        @Override
        public final java.lang.String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final java.util.List<java.lang.String> getEngagements() {
            return this.engagements;
        }

        @Override
        public final java.lang.Object getIntegrations() {
            return this.integrations;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("incidentTemplate", om.valueToTree(this.getIncidentTemplate()));
            data.set("name", om.valueToTree(this.getName()));
            if (this.getActions() != null) {
                data.set("actions", om.valueToTree(this.getActions()));
            }
            if (this.getChatChannel() != null) {
                data.set("chatChannel", om.valueToTree(this.getChatChannel()));
            }
            if (this.getDisplayName() != null) {
                data.set("displayName", om.valueToTree(this.getDisplayName()));
            }
            if (this.getEngagements() != null) {
                data.set("engagements", om.valueToTree(this.getEngagements()));
            }
            if (this.getIntegrations() != null) {
                data.set("integrations", om.valueToTree(this.getIntegrations()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ssmincidents.CfnResponsePlanProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnResponsePlanProps.Jsii$Proxy that = (CfnResponsePlanProps.Jsii$Proxy) o;

            if (!incidentTemplate.equals(that.incidentTemplate)) return false;
            if (!name.equals(that.name)) return false;
            if (this.actions != null ? !this.actions.equals(that.actions) : that.actions != null) return false;
            if (this.chatChannel != null ? !this.chatChannel.equals(that.chatChannel) : that.chatChannel != null) return false;
            if (this.displayName != null ? !this.displayName.equals(that.displayName) : that.displayName != null) return false;
            if (this.engagements != null ? !this.engagements.equals(that.engagements) : that.engagements != null) return false;
            if (this.integrations != null ? !this.integrations.equals(that.integrations) : that.integrations != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.incidentTemplate.hashCode();
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.actions != null ? this.actions.hashCode() : 0);
            result = 31 * result + (this.chatChannel != null ? this.chatChannel.hashCode() : 0);
            result = 31 * result + (this.displayName != null ? this.displayName.hashCode() : 0);
            result = 31 * result + (this.engagements != null ? this.engagements.hashCode() : 0);
            result = 31 * result + (this.integrations != null ? this.integrations.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
