package software.amazon.awscdk.services.securitylake;

/**
 * Properties for defining a <code>CfnSubscriberNotification</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.securitylake.*;
 * Object sqsNotificationConfiguration;
 * CfnSubscriberNotificationProps cfnSubscriberNotificationProps = CfnSubscriberNotificationProps.builder()
 *         .notificationConfiguration(NotificationConfigurationProperty.builder()
 *                 .httpsNotificationConfiguration(HttpsNotificationConfigurationProperty.builder()
 *                         .endpoint("endpoint")
 *                         .targetRoleArn("targetRoleArn")
 *                         // the properties below are optional
 *                         .authorizationApiKeyName("authorizationApiKeyName")
 *                         .authorizationApiKeyValue("authorizationApiKeyValue")
 *                         .httpMethod("httpMethod")
 *                         .build())
 *                 .sqsNotificationConfiguration(sqsNotificationConfiguration)
 *                 .build())
 *         .subscriberArn("subscriberArn")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securitylake-subscribernotification.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securitylake-subscribernotification.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:20.714Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_securitylake.CfnSubscriberNotificationProps")
@software.amazon.jsii.Jsii.Proxy(CfnSubscriberNotificationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnSubscriberNotificationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Specify the configurations you want to use for subscriber notification.
     * <p>
     * The subscriber is notified when new data is written to the data lake for sources that the subscriber consumes in Security Lake .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securitylake-subscribernotification.html#cfn-securitylake-subscribernotification-notificationconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securitylake-subscribernotification.html#cfn-securitylake-subscribernotification-notificationconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getNotificationConfiguration();

    /**
     * The Amazon Resource Name (ARN) of the Security Lake subscriber.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securitylake-subscribernotification.html#cfn-securitylake-subscribernotification-subscriberarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securitylake-subscribernotification.html#cfn-securitylake-subscribernotification-subscriberarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSubscriberArn();

    /**
     * @return a {@link Builder} of {@link CfnSubscriberNotificationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnSubscriberNotificationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnSubscriberNotificationProps> {
        java.lang.Object notificationConfiguration;
        java.lang.String subscriberArn;

        /**
         * Sets the value of {@link CfnSubscriberNotificationProps#getNotificationConfiguration}
         * @param notificationConfiguration Specify the configurations you want to use for subscriber notification. This parameter is required.
         *                                  The subscriber is notified when new data is written to the data lake for sources that the subscriber consumes in Security Lake .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationConfiguration(software.amazon.awscdk.IResolvable notificationConfiguration) {
            this.notificationConfiguration = notificationConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubscriberNotificationProps#getNotificationConfiguration}
         * @param notificationConfiguration Specify the configurations you want to use for subscriber notification. This parameter is required.
         *                                  The subscriber is notified when new data is written to the data lake for sources that the subscriber consumes in Security Lake .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationConfiguration(software.amazon.awscdk.services.securitylake.CfnSubscriberNotification.NotificationConfigurationProperty notificationConfiguration) {
            this.notificationConfiguration = notificationConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnSubscriberNotificationProps#getSubscriberArn}
         * @param subscriberArn The Amazon Resource Name (ARN) of the Security Lake subscriber. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subscriberArn(java.lang.String subscriberArn) {
            this.subscriberArn = subscriberArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnSubscriberNotificationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnSubscriberNotificationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnSubscriberNotificationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnSubscriberNotificationProps {
        private final java.lang.Object notificationConfiguration;
        private final java.lang.String subscriberArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.notificationConfiguration = software.amazon.jsii.Kernel.get(this, "notificationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.subscriberArn = software.amazon.jsii.Kernel.get(this, "subscriberArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.notificationConfiguration = java.util.Objects.requireNonNull(builder.notificationConfiguration, "notificationConfiguration is required");
            this.subscriberArn = java.util.Objects.requireNonNull(builder.subscriberArn, "subscriberArn is required");
        }

        @Override
        public final java.lang.Object getNotificationConfiguration() {
            return this.notificationConfiguration;
        }

        @Override
        public final java.lang.String getSubscriberArn() {
            return this.subscriberArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("notificationConfiguration", om.valueToTree(this.getNotificationConfiguration()));
            data.set("subscriberArn", om.valueToTree(this.getSubscriberArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_securitylake.CfnSubscriberNotificationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnSubscriberNotificationProps.Jsii$Proxy that = (CfnSubscriberNotificationProps.Jsii$Proxy) o;

            if (!notificationConfiguration.equals(that.notificationConfiguration)) return false;
            return this.subscriberArn.equals(that.subscriberArn);
        }

        @Override
        public final int hashCode() {
            int result = this.notificationConfiguration.hashCode();
            result = 31 * result + (this.subscriberArn.hashCode());
            return result;
        }
    }
}
