package software.amazon.awscdk.services.sagemaker;

/**
 * The <code>AWS::SageMaker::MonitoringSchedule</code> resource is an Amazon SageMaker resource type that regularly starts SageMaker processing Jobs to monitor the data captured for a SageMaker endpoint.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sagemaker.*;
 * CfnMonitoringSchedule cfnMonitoringSchedule = CfnMonitoringSchedule.Builder.create(this, "MyCfnMonitoringSchedule")
 *         .monitoringScheduleConfig(MonitoringScheduleConfigProperty.builder()
 *                 .monitoringJobDefinition(MonitoringJobDefinitionProperty.builder()
 *                         .monitoringAppSpecification(MonitoringAppSpecificationProperty.builder()
 *                                 .imageUri("imageUri")
 *                                 // the properties below are optional
 *                                 .containerArguments(List.of("containerArguments"))
 *                                 .containerEntrypoint(List.of("containerEntrypoint"))
 *                                 .postAnalyticsProcessorSourceUri("postAnalyticsProcessorSourceUri")
 *                                 .recordPreprocessorSourceUri("recordPreprocessorSourceUri")
 *                                 .build())
 *                         .monitoringInputs(List.of(MonitoringInputProperty.builder()
 *                                 .batchTransformInput(BatchTransformInputProperty.builder()
 *                                         .dataCapturedDestinationS3Uri("dataCapturedDestinationS3Uri")
 *                                         .datasetFormat(DatasetFormatProperty.builder()
 *                                                 .csv(CsvProperty.builder()
 *                                                         .header(false)
 *                                                         .build())
 *                                                 .json(JsonProperty.builder()
 *                                                         .line(false)
 *                                                         .build())
 *                                                 .parquet(false)
 *                                                 .build())
 *                                         .localPath("localPath")
 *                                         // the properties below are optional
 *                                         .excludeFeaturesAttribute("excludeFeaturesAttribute")
 *                                         .s3DataDistributionType("s3DataDistributionType")
 *                                         .s3InputMode("s3InputMode")
 *                                         .build())
 *                                 .endpointInput(EndpointInputProperty.builder()
 *                                         .endpointName("endpointName")
 *                                         .localPath("localPath")
 *                                         // the properties below are optional
 *                                         .excludeFeaturesAttribute("excludeFeaturesAttribute")
 *                                         .s3DataDistributionType("s3DataDistributionType")
 *                                         .s3InputMode("s3InputMode")
 *                                         .build())
 *                                 .build()))
 *                         .monitoringOutputConfig(MonitoringOutputConfigProperty.builder()
 *                                 .monitoringOutputs(List.of(MonitoringOutputProperty.builder()
 *                                         .s3Output(S3OutputProperty.builder()
 *                                                 .localPath("localPath")
 *                                                 .s3Uri("s3Uri")
 *                                                 // the properties below are optional
 *                                                 .s3UploadMode("s3UploadMode")
 *                                                 .build())
 *                                         .build()))
 *                                 // the properties below are optional
 *                                 .kmsKeyId("kmsKeyId")
 *                                 .build())
 *                         .monitoringResources(MonitoringResourcesProperty.builder()
 *                                 .clusterConfig(ClusterConfigProperty.builder()
 *                                         .instanceCount(123)
 *                                         .instanceType("instanceType")
 *                                         .volumeSizeInGb(123)
 *                                         // the properties below are optional
 *                                         .volumeKmsKeyId("volumeKmsKeyId")
 *                                         .build())
 *                                 .build())
 *                         .roleArn("roleArn")
 *                         // the properties below are optional
 *                         .baselineConfig(BaselineConfigProperty.builder()
 *                                 .constraintsResource(ConstraintsResourceProperty.builder()
 *                                         .s3Uri("s3Uri")
 *                                         .build())
 *                                 .statisticsResource(StatisticsResourceProperty.builder()
 *                                         .s3Uri("s3Uri")
 *                                         .build())
 *                                 .build())
 *                         .environment(Map.of(
 *                                 "environmentKey", "environment"))
 *                         .networkConfig(NetworkConfigProperty.builder()
 *                                 .enableInterContainerTrafficEncryption(false)
 *                                 .enableNetworkIsolation(false)
 *                                 .vpcConfig(VpcConfigProperty.builder()
 *                                         .securityGroupIds(List.of("securityGroupIds"))
 *                                         .subnets(List.of("subnets"))
 *                                         .build())
 *                                 .build())
 *                         .stoppingCondition(StoppingConditionProperty.builder()
 *                                 .maxRuntimeInSeconds(123)
 *                                 .build())
 *                         .build())
 *                 .monitoringJobDefinitionName("monitoringJobDefinitionName")
 *                 .monitoringType("monitoringType")
 *                 .scheduleConfig(ScheduleConfigProperty.builder()
 *                         .scheduleExpression("scheduleExpression")
 *                         // the properties below are optional
 *                         .dataAnalysisEndTime("dataAnalysisEndTime")
 *                         .dataAnalysisStartTime("dataAnalysisStartTime")
 *                         .build())
 *                 .build())
 *         .monitoringScheduleName("monitoringScheduleName")
 *         // the properties below are optional
 *         .endpointName("endpointName")
 *         .failureReason("failureReason")
 *         .lastMonitoringExecutionSummary(MonitoringExecutionSummaryProperty.builder()
 *                 .creationTime("creationTime")
 *                 .lastModifiedTime("lastModifiedTime")
 *                 .monitoringExecutionStatus("monitoringExecutionStatus")
 *                 .monitoringScheduleName("monitoringScheduleName")
 *                 .scheduledTime("scheduledTime")
 *                 // the properties below are optional
 *                 .endpointName("endpointName")
 *                 .failureReason("failureReason")
 *                 .processingJobArn("processingJobArn")
 *                 .build())
 *         .monitoringScheduleStatus("monitoringScheduleStatus")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:20.338Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnMonitoringSchedule")
public class CfnMonitoringSchedule extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnMonitoringSchedule(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnMonitoringSchedule(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.sagemaker.CfnMonitoringSchedule.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnMonitoringSchedule(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sagemaker.CfnMonitoringScheduleProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The time when the monitoring schedule was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreationTime() {
        return software.amazon.jsii.Kernel.get(this, "attrCreationTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The last time that the monitoring schedule was modified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrLastModifiedTime() {
        return software.amazon.jsii.Kernel.get(this, "attrLastModifiedTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the monitoring schedule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrMonitoringScheduleArn() {
        return software.amazon.jsii.Kernel.get(this, "attrMonitoringScheduleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The configuration object that specifies the monitoring schedule and defines the monitoring job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getMonitoringScheduleConfig() {
        return software.amazon.jsii.Kernel.get(this, "monitoringScheduleConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The configuration object that specifies the monitoring schedule and defines the monitoring job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMonitoringScheduleConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "monitoringScheduleConfig", java.util.Objects.requireNonNull(value, "monitoringScheduleConfig is required"));
    }

    /**
     * The configuration object that specifies the monitoring schedule and defines the monitoring job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMonitoringScheduleConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sagemaker.CfnMonitoringSchedule.MonitoringScheduleConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "monitoringScheduleConfig", java.util.Objects.requireNonNull(value, "monitoringScheduleConfig is required"));
    }

    /**
     * The name of the monitoring schedule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getMonitoringScheduleName() {
        return software.amazon.jsii.Kernel.get(this, "monitoringScheduleName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the monitoring schedule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMonitoringScheduleName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "monitoringScheduleName", java.util.Objects.requireNonNull(value, "monitoringScheduleName is required"));
    }

    /**
     * The name of the endpoint using the monitoring schedule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEndpointName() {
        return software.amazon.jsii.Kernel.get(this, "endpointName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the endpoint using the monitoring schedule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEndpointName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "endpointName", value);
    }

    /**
     * Contains the reason a monitoring job failed, if it failed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getFailureReason() {
        return software.amazon.jsii.Kernel.get(this, "failureReason", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Contains the reason a monitoring job failed, if it failed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFailureReason(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "failureReason", value);
    }

    /**
     * Describes metadata on the last execution to run, if there was one.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLastMonitoringExecutionSummary() {
        return software.amazon.jsii.Kernel.get(this, "lastMonitoringExecutionSummary", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Describes metadata on the last execution to run, if there was one.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLastMonitoringExecutionSummary(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "lastMonitoringExecutionSummary", value);
    }

    /**
     * Describes metadata on the last execution to run, if there was one.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLastMonitoringExecutionSummary(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sagemaker.CfnMonitoringSchedule.MonitoringExecutionSummaryProperty value) {
        software.amazon.jsii.Kernel.set(this, "lastMonitoringExecutionSummary", value);
    }

    /**
     * The status of the monitoring schedule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getMonitoringScheduleStatus() {
        return software.amazon.jsii.Kernel.get(this, "monitoringScheduleStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The status of the monitoring schedule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMonitoringScheduleStatus(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "monitoringScheduleStatus", value);
    }

    /**
     * An array of key-value pairs to apply to this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * An array of key-value pairs to apply to this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * Baseline configuration used to validate that the data conforms to the specified constraints and statistics.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * BaselineConfigProperty baselineConfigProperty = BaselineConfigProperty.builder()
     *         .constraintsResource(ConstraintsResourceProperty.builder()
     *                 .s3Uri("s3Uri")
     *                 .build())
     *         .statisticsResource(StatisticsResourceProperty.builder()
     *                 .s3Uri("s3Uri")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-baselineconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-baselineconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnMonitoringSchedule.BaselineConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(BaselineConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BaselineConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon S3 URI for the constraints resource.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-baselineconfig.html#cfn-sagemaker-monitoringschedule-baselineconfig-constraintsresource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-baselineconfig.html#cfn-sagemaker-monitoringschedule-baselineconfig-constraintsresource</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConstraintsResource() {
            return null;
        }

        /**
         * The baseline statistics file in Amazon S3 that the current monitoring job should be validated against.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-baselineconfig.html#cfn-sagemaker-monitoringschedule-baselineconfig-statisticsresource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-baselineconfig.html#cfn-sagemaker-monitoringschedule-baselineconfig-statisticsresource</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStatisticsResource() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BaselineConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BaselineConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BaselineConfigProperty> {
            java.lang.Object constraintsResource;
            java.lang.Object statisticsResource;

            /**
             * Sets the value of {@link BaselineConfigProperty#getConstraintsResource}
             * @param constraintsResource The Amazon S3 URI for the constraints resource.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder constraintsResource(software.amazon.awscdk.IResolvable constraintsResource) {
                this.constraintsResource = constraintsResource;
                return this;
            }

            /**
             * Sets the value of {@link BaselineConfigProperty#getConstraintsResource}
             * @param constraintsResource The Amazon S3 URI for the constraints resource.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder constraintsResource(software.amazon.awscdk.services.sagemaker.CfnMonitoringSchedule.ConstraintsResourceProperty constraintsResource) {
                this.constraintsResource = constraintsResource;
                return this;
            }

            /**
             * Sets the value of {@link BaselineConfigProperty#getStatisticsResource}
             * @param statisticsResource The baseline statistics file in Amazon S3 that the current monitoring job should be validated against.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statisticsResource(software.amazon.awscdk.IResolvable statisticsResource) {
                this.statisticsResource = statisticsResource;
                return this;
            }

            /**
             * Sets the value of {@link BaselineConfigProperty#getStatisticsResource}
             * @param statisticsResource The baseline statistics file in Amazon S3 that the current monitoring job should be validated against.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statisticsResource(software.amazon.awscdk.services.sagemaker.CfnMonitoringSchedule.StatisticsResourceProperty statisticsResource) {
                this.statisticsResource = statisticsResource;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BaselineConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BaselineConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BaselineConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BaselineConfigProperty {
            private final java.lang.Object constraintsResource;
            private final java.lang.Object statisticsResource;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.constraintsResource = software.amazon.jsii.Kernel.get(this, "constraintsResource", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.statisticsResource = software.amazon.jsii.Kernel.get(this, "statisticsResource", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.constraintsResource = builder.constraintsResource;
                this.statisticsResource = builder.statisticsResource;
            }

            @Override
            public final java.lang.Object getConstraintsResource() {
                return this.constraintsResource;
            }

            @Override
            public final java.lang.Object getStatisticsResource() {
                return this.statisticsResource;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getConstraintsResource() != null) {
                    data.set("constraintsResource", om.valueToTree(this.getConstraintsResource()));
                }
                if (this.getStatisticsResource() != null) {
                    data.set("statisticsResource", om.valueToTree(this.getStatisticsResource()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnMonitoringSchedule.BaselineConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BaselineConfigProperty.Jsii$Proxy that = (BaselineConfigProperty.Jsii$Proxy) o;

                if (this.constraintsResource != null ? !this.constraintsResource.equals(that.constraintsResource) : that.constraintsResource != null) return false;
                return this.statisticsResource != null ? this.statisticsResource.equals(that.statisticsResource) : that.statisticsResource == null;
            }

            @Override
            public final int hashCode() {
                int result = this.constraintsResource != null ? this.constraintsResource.hashCode() : 0;
                result = 31 * result + (this.statisticsResource != null ? this.statisticsResource.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Input object for the batch transform job.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * BatchTransformInputProperty batchTransformInputProperty = BatchTransformInputProperty.builder()
     *         .dataCapturedDestinationS3Uri("dataCapturedDestinationS3Uri")
     *         .datasetFormat(DatasetFormatProperty.builder()
     *                 .csv(CsvProperty.builder()
     *                         .header(false)
     *                         .build())
     *                 .json(JsonProperty.builder()
     *                         .line(false)
     *                         .build())
     *                 .parquet(false)
     *                 .build())
     *         .localPath("localPath")
     *         // the properties below are optional
     *         .excludeFeaturesAttribute("excludeFeaturesAttribute")
     *         .s3DataDistributionType("s3DataDistributionType")
     *         .s3InputMode("s3InputMode")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-batchtransforminput.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-batchtransforminput.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnMonitoringSchedule.BatchTransformInputProperty")
    @software.amazon.jsii.Jsii.Proxy(BatchTransformInputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BatchTransformInputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon S3 location being used to capture the data.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-batchtransforminput.html#cfn-sagemaker-monitoringschedule-batchtransforminput-datacaptureddestinations3uri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-batchtransforminput.html#cfn-sagemaker-monitoringschedule-batchtransforminput-datacaptureddestinations3uri</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDataCapturedDestinationS3Uri();

        /**
         * The dataset format for your batch transform job.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-batchtransforminput.html#cfn-sagemaker-monitoringschedule-batchtransforminput-datasetformat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-batchtransforminput.html#cfn-sagemaker-monitoringschedule-batchtransforminput-datasetformat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getDatasetFormat();

        /**
         * Path to the filesystem where the batch transform data is available to the container.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-batchtransforminput.html#cfn-sagemaker-monitoringschedule-batchtransforminput-localpath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-batchtransforminput.html#cfn-sagemaker-monitoringschedule-batchtransforminput-localpath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLocalPath();

        /**
         * The attributes of the input data to exclude from the analysis.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-batchtransforminput.html#cfn-sagemaker-monitoringschedule-batchtransforminput-excludefeaturesattribute">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-batchtransforminput.html#cfn-sagemaker-monitoringschedule-batchtransforminput-excludefeaturesattribute</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExcludeFeaturesAttribute() {
            return null;
        }

        /**
         * Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key.
         * <p>
         * Defaults to <code>FullyReplicated</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-batchtransforminput.html#cfn-sagemaker-monitoringschedule-batchtransforminput-s3datadistributiontype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-batchtransforminput.html#cfn-sagemaker-monitoringschedule-batchtransforminput-s3datadistributiontype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3DataDistributionType() {
            return null;
        }

        /**
         * Whether the <code>Pipe</code> or <code>File</code> is used as the input mode for transferring data for the monitoring job.
         * <p>
         * <code>Pipe</code> mode is recommended for large datasets. <code>File</code> mode is useful for small files that fit in memory. Defaults to <code>File</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-batchtransforminput.html#cfn-sagemaker-monitoringschedule-batchtransforminput-s3inputmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-batchtransforminput.html#cfn-sagemaker-monitoringschedule-batchtransforminput-s3inputmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3InputMode() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BatchTransformInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BatchTransformInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BatchTransformInputProperty> {
            java.lang.String dataCapturedDestinationS3Uri;
            java.lang.Object datasetFormat;
            java.lang.String localPath;
            java.lang.String excludeFeaturesAttribute;
            java.lang.String s3DataDistributionType;
            java.lang.String s3InputMode;

            /**
             * Sets the value of {@link BatchTransformInputProperty#getDataCapturedDestinationS3Uri}
             * @param dataCapturedDestinationS3Uri The Amazon S3 location being used to capture the data. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataCapturedDestinationS3Uri(java.lang.String dataCapturedDestinationS3Uri) {
                this.dataCapturedDestinationS3Uri = dataCapturedDestinationS3Uri;
                return this;
            }

            /**
             * Sets the value of {@link BatchTransformInputProperty#getDatasetFormat}
             * @param datasetFormat The dataset format for your batch transform job. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder datasetFormat(software.amazon.awscdk.IResolvable datasetFormat) {
                this.datasetFormat = datasetFormat;
                return this;
            }

            /**
             * Sets the value of {@link BatchTransformInputProperty#getDatasetFormat}
             * @param datasetFormat The dataset format for your batch transform job. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder datasetFormat(software.amazon.awscdk.services.sagemaker.CfnMonitoringSchedule.DatasetFormatProperty datasetFormat) {
                this.datasetFormat = datasetFormat;
                return this;
            }

            /**
             * Sets the value of {@link BatchTransformInputProperty#getLocalPath}
             * @param localPath Path to the filesystem where the batch transform data is available to the container. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder localPath(java.lang.String localPath) {
                this.localPath = localPath;
                return this;
            }

            /**
             * Sets the value of {@link BatchTransformInputProperty#getExcludeFeaturesAttribute}
             * @param excludeFeaturesAttribute The attributes of the input data to exclude from the analysis.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excludeFeaturesAttribute(java.lang.String excludeFeaturesAttribute) {
                this.excludeFeaturesAttribute = excludeFeaturesAttribute;
                return this;
            }

            /**
             * Sets the value of {@link BatchTransformInputProperty#getS3DataDistributionType}
             * @param s3DataDistributionType Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key.
             *                               Defaults to <code>FullyReplicated</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3DataDistributionType(java.lang.String s3DataDistributionType) {
                this.s3DataDistributionType = s3DataDistributionType;
                return this;
            }

            /**
             * Sets the value of {@link BatchTransformInputProperty#getS3InputMode}
             * @param s3InputMode Whether the <code>Pipe</code> or <code>File</code> is used as the input mode for transferring data for the monitoring job.
             *                    <code>Pipe</code> mode is recommended for large datasets. <code>File</code> mode is useful for small files that fit in memory. Defaults to <code>File</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3InputMode(java.lang.String s3InputMode) {
                this.s3InputMode = s3InputMode;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BatchTransformInputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BatchTransformInputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BatchTransformInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BatchTransformInputProperty {
            private final java.lang.String dataCapturedDestinationS3Uri;
            private final java.lang.Object datasetFormat;
            private final java.lang.String localPath;
            private final java.lang.String excludeFeaturesAttribute;
            private final java.lang.String s3DataDistributionType;
            private final java.lang.String s3InputMode;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dataCapturedDestinationS3Uri = software.amazon.jsii.Kernel.get(this, "dataCapturedDestinationS3Uri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.datasetFormat = software.amazon.jsii.Kernel.get(this, "datasetFormat", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.localPath = software.amazon.jsii.Kernel.get(this, "localPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.excludeFeaturesAttribute = software.amazon.jsii.Kernel.get(this, "excludeFeaturesAttribute", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3DataDistributionType = software.amazon.jsii.Kernel.get(this, "s3DataDistributionType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3InputMode = software.amazon.jsii.Kernel.get(this, "s3InputMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dataCapturedDestinationS3Uri = java.util.Objects.requireNonNull(builder.dataCapturedDestinationS3Uri, "dataCapturedDestinationS3Uri is required");
                this.datasetFormat = java.util.Objects.requireNonNull(builder.datasetFormat, "datasetFormat is required");
                this.localPath = java.util.Objects.requireNonNull(builder.localPath, "localPath is required");
                this.excludeFeaturesAttribute = builder.excludeFeaturesAttribute;
                this.s3DataDistributionType = builder.s3DataDistributionType;
                this.s3InputMode = builder.s3InputMode;
            }

            @Override
            public final java.lang.String getDataCapturedDestinationS3Uri() {
                return this.dataCapturedDestinationS3Uri;
            }

            @Override
            public final java.lang.Object getDatasetFormat() {
                return this.datasetFormat;
            }

            @Override
            public final java.lang.String getLocalPath() {
                return this.localPath;
            }

            @Override
            public final java.lang.String getExcludeFeaturesAttribute() {
                return this.excludeFeaturesAttribute;
            }

            @Override
            public final java.lang.String getS3DataDistributionType() {
                return this.s3DataDistributionType;
            }

            @Override
            public final java.lang.String getS3InputMode() {
                return this.s3InputMode;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("dataCapturedDestinationS3Uri", om.valueToTree(this.getDataCapturedDestinationS3Uri()));
                data.set("datasetFormat", om.valueToTree(this.getDatasetFormat()));
                data.set("localPath", om.valueToTree(this.getLocalPath()));
                if (this.getExcludeFeaturesAttribute() != null) {
                    data.set("excludeFeaturesAttribute", om.valueToTree(this.getExcludeFeaturesAttribute()));
                }
                if (this.getS3DataDistributionType() != null) {
                    data.set("s3DataDistributionType", om.valueToTree(this.getS3DataDistributionType()));
                }
                if (this.getS3InputMode() != null) {
                    data.set("s3InputMode", om.valueToTree(this.getS3InputMode()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnMonitoringSchedule.BatchTransformInputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BatchTransformInputProperty.Jsii$Proxy that = (BatchTransformInputProperty.Jsii$Proxy) o;

                if (!dataCapturedDestinationS3Uri.equals(that.dataCapturedDestinationS3Uri)) return false;
                if (!datasetFormat.equals(that.datasetFormat)) return false;
                if (!localPath.equals(that.localPath)) return false;
                if (this.excludeFeaturesAttribute != null ? !this.excludeFeaturesAttribute.equals(that.excludeFeaturesAttribute) : that.excludeFeaturesAttribute != null) return false;
                if (this.s3DataDistributionType != null ? !this.s3DataDistributionType.equals(that.s3DataDistributionType) : that.s3DataDistributionType != null) return false;
                return this.s3InputMode != null ? this.s3InputMode.equals(that.s3InputMode) : that.s3InputMode == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dataCapturedDestinationS3Uri.hashCode();
                result = 31 * result + (this.datasetFormat.hashCode());
                result = 31 * result + (this.localPath.hashCode());
                result = 31 * result + (this.excludeFeaturesAttribute != null ? this.excludeFeaturesAttribute.hashCode() : 0);
                result = 31 * result + (this.s3DataDistributionType != null ? this.s3DataDistributionType.hashCode() : 0);
                result = 31 * result + (this.s3InputMode != null ? this.s3InputMode.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configuration for the cluster used to run model monitoring jobs.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * ClusterConfigProperty clusterConfigProperty = ClusterConfigProperty.builder()
     *         .instanceCount(123)
     *         .instanceType("instanceType")
     *         .volumeSizeInGb(123)
     *         // the properties below are optional
     *         .volumeKmsKeyId("volumeKmsKeyId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-clusterconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-clusterconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnMonitoringSchedule.ClusterConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ClusterConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ClusterConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The number of ML compute instances to use in the model monitoring job.
         * <p>
         * For distributed processing jobs, specify a value greater than 1. The default value is 1.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-clusterconfig.html#cfn-sagemaker-monitoringschedule-clusterconfig-instancecount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-clusterconfig.html#cfn-sagemaker-monitoringschedule-clusterconfig-instancecount</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getInstanceCount();

        /**
         * The ML compute instance type for the processing job.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-clusterconfig.html#cfn-sagemaker-monitoringschedule-clusterconfig-instancetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-clusterconfig.html#cfn-sagemaker-monitoringschedule-clusterconfig-instancetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getInstanceType();

        /**
         * The size of the ML storage volume, in gigabytes, that you want to provision.
         * <p>
         * You must specify sufficient ML storage for your scenario.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-clusterconfig.html#cfn-sagemaker-monitoringschedule-clusterconfig-volumesizeingb">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-clusterconfig.html#cfn-sagemaker-monitoringschedule-clusterconfig-volumesizeingb</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getVolumeSizeInGb();

        /**
         * The AWS Key Management Service ( AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance(s) that run the model monitoring job.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-clusterconfig.html#cfn-sagemaker-monitoringschedule-clusterconfig-volumekmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-clusterconfig.html#cfn-sagemaker-monitoringschedule-clusterconfig-volumekmskeyid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVolumeKmsKeyId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ClusterConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ClusterConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ClusterConfigProperty> {
            java.lang.Number instanceCount;
            java.lang.String instanceType;
            java.lang.Number volumeSizeInGb;
            java.lang.String volumeKmsKeyId;

            /**
             * Sets the value of {@link ClusterConfigProperty#getInstanceCount}
             * @param instanceCount The number of ML compute instances to use in the model monitoring job. This parameter is required.
             *                      For distributed processing jobs, specify a value greater than 1. The default value is 1.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceCount(java.lang.Number instanceCount) {
                this.instanceCount = instanceCount;
                return this;
            }

            /**
             * Sets the value of {@link ClusterConfigProperty#getInstanceType}
             * @param instanceType The ML compute instance type for the processing job. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceType(java.lang.String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            /**
             * Sets the value of {@link ClusterConfigProperty#getVolumeSizeInGb}
             * @param volumeSizeInGb The size of the ML storage volume, in gigabytes, that you want to provision. This parameter is required.
             *                       You must specify sufficient ML storage for your scenario.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumeSizeInGb(java.lang.Number volumeSizeInGb) {
                this.volumeSizeInGb = volumeSizeInGb;
                return this;
            }

            /**
             * Sets the value of {@link ClusterConfigProperty#getVolumeKmsKeyId}
             * @param volumeKmsKeyId The AWS Key Management Service ( AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance(s) that run the model monitoring job.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumeKmsKeyId(java.lang.String volumeKmsKeyId) {
                this.volumeKmsKeyId = volumeKmsKeyId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ClusterConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ClusterConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ClusterConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ClusterConfigProperty {
            private final java.lang.Number instanceCount;
            private final java.lang.String instanceType;
            private final java.lang.Number volumeSizeInGb;
            private final java.lang.String volumeKmsKeyId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.instanceCount = software.amazon.jsii.Kernel.get(this, "instanceCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.instanceType = software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.volumeSizeInGb = software.amazon.jsii.Kernel.get(this, "volumeSizeInGb", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.volumeKmsKeyId = software.amazon.jsii.Kernel.get(this, "volumeKmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.instanceCount = java.util.Objects.requireNonNull(builder.instanceCount, "instanceCount is required");
                this.instanceType = java.util.Objects.requireNonNull(builder.instanceType, "instanceType is required");
                this.volumeSizeInGb = java.util.Objects.requireNonNull(builder.volumeSizeInGb, "volumeSizeInGb is required");
                this.volumeKmsKeyId = builder.volumeKmsKeyId;
            }

            @Override
            public final java.lang.Number getInstanceCount() {
                return this.instanceCount;
            }

            @Override
            public final java.lang.String getInstanceType() {
                return this.instanceType;
            }

            @Override
            public final java.lang.Number getVolumeSizeInGb() {
                return this.volumeSizeInGb;
            }

            @Override
            public final java.lang.String getVolumeKmsKeyId() {
                return this.volumeKmsKeyId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("instanceCount", om.valueToTree(this.getInstanceCount()));
                data.set("instanceType", om.valueToTree(this.getInstanceType()));
                data.set("volumeSizeInGb", om.valueToTree(this.getVolumeSizeInGb()));
                if (this.getVolumeKmsKeyId() != null) {
                    data.set("volumeKmsKeyId", om.valueToTree(this.getVolumeKmsKeyId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnMonitoringSchedule.ClusterConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ClusterConfigProperty.Jsii$Proxy that = (ClusterConfigProperty.Jsii$Proxy) o;

                if (!instanceCount.equals(that.instanceCount)) return false;
                if (!instanceType.equals(that.instanceType)) return false;
                if (!volumeSizeInGb.equals(that.volumeSizeInGb)) return false;
                return this.volumeKmsKeyId != null ? this.volumeKmsKeyId.equals(that.volumeKmsKeyId) : that.volumeKmsKeyId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.instanceCount.hashCode();
                result = 31 * result + (this.instanceType.hashCode());
                result = 31 * result + (this.volumeSizeInGb.hashCode());
                result = 31 * result + (this.volumeKmsKeyId != null ? this.volumeKmsKeyId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The Amazon S3 URI for the constraints resource.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * ConstraintsResourceProperty constraintsResourceProperty = ConstraintsResourceProperty.builder()
     *         .s3Uri("s3Uri")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-constraintsresource.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-constraintsresource.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnMonitoringSchedule.ConstraintsResourceProperty")
    @software.amazon.jsii.Jsii.Proxy(ConstraintsResourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConstraintsResourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon S3 URI for the constraints resource.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-constraintsresource.html#cfn-sagemaker-monitoringschedule-constraintsresource-s3uri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-constraintsresource.html#cfn-sagemaker-monitoringschedule-constraintsresource-s3uri</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3Uri() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConstraintsResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConstraintsResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConstraintsResourceProperty> {
            java.lang.String s3Uri;

            /**
             * Sets the value of {@link ConstraintsResourceProperty#getS3Uri}
             * @param s3Uri The Amazon S3 URI for the constraints resource.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Uri(java.lang.String s3Uri) {
                this.s3Uri = s3Uri;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConstraintsResourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConstraintsResourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConstraintsResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConstraintsResourceProperty {
            private final java.lang.String s3Uri;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.s3Uri = software.amazon.jsii.Kernel.get(this, "s3Uri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.s3Uri = builder.s3Uri;
            }

            @Override
            public final java.lang.String getS3Uri() {
                return this.s3Uri;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getS3Uri() != null) {
                    data.set("s3Uri", om.valueToTree(this.getS3Uri()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnMonitoringSchedule.ConstraintsResourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConstraintsResourceProperty.Jsii$Proxy that = (ConstraintsResourceProperty.Jsii$Proxy) o;

                return this.s3Uri != null ? this.s3Uri.equals(that.s3Uri) : that.s3Uri == null;
            }

            @Override
            public final int hashCode() {
                int result = this.s3Uri != null ? this.s3Uri.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The CSV format.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * CsvProperty csvProperty = CsvProperty.builder()
     *         .header(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-csv.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-csv.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnMonitoringSchedule.CsvProperty")
    @software.amazon.jsii.Jsii.Proxy(CsvProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CsvProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A boolean flag indicating if given CSV has header.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-csv.html#cfn-sagemaker-monitoringschedule-csv-header">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-csv.html#cfn-sagemaker-monitoringschedule-csv-header</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHeader() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CsvProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CsvProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CsvProperty> {
            java.lang.Object header;

            /**
             * Sets the value of {@link CsvProperty#getHeader}
             * @param header A boolean flag indicating if given CSV has header.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder header(java.lang.Boolean header) {
                this.header = header;
                return this;
            }

            /**
             * Sets the value of {@link CsvProperty#getHeader}
             * @param header A boolean flag indicating if given CSV has header.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder header(software.amazon.awscdk.IResolvable header) {
                this.header = header;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CsvProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CsvProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CsvProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CsvProperty {
            private final java.lang.Object header;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.header = software.amazon.jsii.Kernel.get(this, "header", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.header = builder.header;
            }

            @Override
            public final java.lang.Object getHeader() {
                return this.header;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getHeader() != null) {
                    data.set("header", om.valueToTree(this.getHeader()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnMonitoringSchedule.CsvProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CsvProperty.Jsii$Proxy that = (CsvProperty.Jsii$Proxy) o;

                return this.header != null ? this.header.equals(that.header) : that.header == null;
            }

            @Override
            public final int hashCode() {
                int result = this.header != null ? this.header.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The dataset format of the data to monitor.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * DatasetFormatProperty datasetFormatProperty = DatasetFormatProperty.builder()
     *         .csv(CsvProperty.builder()
     *                 .header(false)
     *                 .build())
     *         .json(JsonProperty.builder()
     *                 .line(false)
     *                 .build())
     *         .parquet(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-datasetformat.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-datasetformat.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnMonitoringSchedule.DatasetFormatProperty")
    @software.amazon.jsii.Jsii.Proxy(DatasetFormatProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DatasetFormatProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The CSV format.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-datasetformat.html#cfn-sagemaker-monitoringschedule-datasetformat-csv">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-datasetformat.html#cfn-sagemaker-monitoringschedule-datasetformat-csv</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCsv() {
            return null;
        }

        /**
         * The Json format.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-datasetformat.html#cfn-sagemaker-monitoringschedule-datasetformat-json">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-datasetformat.html#cfn-sagemaker-monitoringschedule-datasetformat-json</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getJson() {
            return null;
        }

        /**
         * A flag indicating if the dataset format is Parquet.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-datasetformat.html#cfn-sagemaker-monitoringschedule-datasetformat-parquet">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-datasetformat.html#cfn-sagemaker-monitoringschedule-datasetformat-parquet</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getParquet() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DatasetFormatProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DatasetFormatProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DatasetFormatProperty> {
            java.lang.Object csv;
            java.lang.Object json;
            java.lang.Object parquet;

            /**
             * Sets the value of {@link DatasetFormatProperty#getCsv}
             * @param csv The CSV format.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder csv(software.amazon.awscdk.IResolvable csv) {
                this.csv = csv;
                return this;
            }

            /**
             * Sets the value of {@link DatasetFormatProperty#getCsv}
             * @param csv The CSV format.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder csv(software.amazon.awscdk.services.sagemaker.CfnMonitoringSchedule.CsvProperty csv) {
                this.csv = csv;
                return this;
            }

            /**
             * Sets the value of {@link DatasetFormatProperty#getJson}
             * @param json The Json format.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder json(software.amazon.awscdk.IResolvable json) {
                this.json = json;
                return this;
            }

            /**
             * Sets the value of {@link DatasetFormatProperty#getJson}
             * @param json The Json format.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder json(software.amazon.awscdk.services.sagemaker.CfnMonitoringSchedule.JsonProperty json) {
                this.json = json;
                return this;
            }

            /**
             * Sets the value of {@link DatasetFormatProperty#getParquet}
             * @param parquet A flag indicating if the dataset format is Parquet.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parquet(java.lang.Boolean parquet) {
                this.parquet = parquet;
                return this;
            }

            /**
             * Sets the value of {@link DatasetFormatProperty#getParquet}
             * @param parquet A flag indicating if the dataset format is Parquet.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parquet(software.amazon.awscdk.IResolvable parquet) {
                this.parquet = parquet;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DatasetFormatProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DatasetFormatProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DatasetFormatProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DatasetFormatProperty {
            private final java.lang.Object csv;
            private final java.lang.Object json;
            private final java.lang.Object parquet;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.csv = software.amazon.jsii.Kernel.get(this, "csv", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.json = software.amazon.jsii.Kernel.get(this, "json", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.parquet = software.amazon.jsii.Kernel.get(this, "parquet", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.csv = builder.csv;
                this.json = builder.json;
                this.parquet = builder.parquet;
            }

            @Override
            public final java.lang.Object getCsv() {
                return this.csv;
            }

            @Override
            public final java.lang.Object getJson() {
                return this.json;
            }

            @Override
            public final java.lang.Object getParquet() {
                return this.parquet;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCsv() != null) {
                    data.set("csv", om.valueToTree(this.getCsv()));
                }
                if (this.getJson() != null) {
                    data.set("json", om.valueToTree(this.getJson()));
                }
                if (this.getParquet() != null) {
                    data.set("parquet", om.valueToTree(this.getParquet()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnMonitoringSchedule.DatasetFormatProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DatasetFormatProperty.Jsii$Proxy that = (DatasetFormatProperty.Jsii$Proxy) o;

                if (this.csv != null ? !this.csv.equals(that.csv) : that.csv != null) return false;
                if (this.json != null ? !this.json.equals(that.json) : that.json != null) return false;
                return this.parquet != null ? this.parquet.equals(that.parquet) : that.parquet == null;
            }

            @Override
            public final int hashCode() {
                int result = this.csv != null ? this.csv.hashCode() : 0;
                result = 31 * result + (this.json != null ? this.json.hashCode() : 0);
                result = 31 * result + (this.parquet != null ? this.parquet.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Input object for the endpoint.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * EndpointInputProperty endpointInputProperty = EndpointInputProperty.builder()
     *         .endpointName("endpointName")
     *         .localPath("localPath")
     *         // the properties below are optional
     *         .excludeFeaturesAttribute("excludeFeaturesAttribute")
     *         .s3DataDistributionType("s3DataDistributionType")
     *         .s3InputMode("s3InputMode")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-endpointinput.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-endpointinput.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnMonitoringSchedule.EndpointInputProperty")
    @software.amazon.jsii.Jsii.Proxy(EndpointInputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EndpointInputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An endpoint in customer's account which has enabled <code>DataCaptureConfig</code> enabled.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-endpointinput.html#cfn-sagemaker-monitoringschedule-endpointinput-endpointname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-endpointinput.html#cfn-sagemaker-monitoringschedule-endpointinput-endpointname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEndpointName();

        /**
         * Path to the filesystem where the endpoint data is available to the container.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-endpointinput.html#cfn-sagemaker-monitoringschedule-endpointinput-localpath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-endpointinput.html#cfn-sagemaker-monitoringschedule-endpointinput-localpath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLocalPath();

        /**
         * The attributes of the input data to exclude from the analysis.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-endpointinput.html#cfn-sagemaker-monitoringschedule-endpointinput-excludefeaturesattribute">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-endpointinput.html#cfn-sagemaker-monitoringschedule-endpointinput-excludefeaturesattribute</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExcludeFeaturesAttribute() {
            return null;
        }

        /**
         * Whether input data distributed in Amazon S3 is fully replicated or sharded by an Amazon S3 key.
         * <p>
         * Defaults to <code>FullyReplicated</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-endpointinput.html#cfn-sagemaker-monitoringschedule-endpointinput-s3datadistributiontype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-endpointinput.html#cfn-sagemaker-monitoringschedule-endpointinput-s3datadistributiontype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3DataDistributionType() {
            return null;
        }

        /**
         * Whether the <code>Pipe</code> or <code>File</code> is used as the input mode for transferring data for the monitoring job.
         * <p>
         * <code>Pipe</code> mode is recommended for large datasets. <code>File</code> mode is useful for small files that fit in memory. Defaults to <code>File</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-endpointinput.html#cfn-sagemaker-monitoringschedule-endpointinput-s3inputmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-endpointinput.html#cfn-sagemaker-monitoringschedule-endpointinput-s3inputmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3InputMode() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EndpointInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EndpointInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EndpointInputProperty> {
            java.lang.String endpointName;
            java.lang.String localPath;
            java.lang.String excludeFeaturesAttribute;
            java.lang.String s3DataDistributionType;
            java.lang.String s3InputMode;

            /**
             * Sets the value of {@link EndpointInputProperty#getEndpointName}
             * @param endpointName An endpoint in customer's account which has enabled <code>DataCaptureConfig</code> enabled. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endpointName(java.lang.String endpointName) {
                this.endpointName = endpointName;
                return this;
            }

            /**
             * Sets the value of {@link EndpointInputProperty#getLocalPath}
             * @param localPath Path to the filesystem where the endpoint data is available to the container. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder localPath(java.lang.String localPath) {
                this.localPath = localPath;
                return this;
            }

            /**
             * Sets the value of {@link EndpointInputProperty#getExcludeFeaturesAttribute}
             * @param excludeFeaturesAttribute The attributes of the input data to exclude from the analysis.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excludeFeaturesAttribute(java.lang.String excludeFeaturesAttribute) {
                this.excludeFeaturesAttribute = excludeFeaturesAttribute;
                return this;
            }

            /**
             * Sets the value of {@link EndpointInputProperty#getS3DataDistributionType}
             * @param s3DataDistributionType Whether input data distributed in Amazon S3 is fully replicated or sharded by an Amazon S3 key.
             *                               Defaults to <code>FullyReplicated</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3DataDistributionType(java.lang.String s3DataDistributionType) {
                this.s3DataDistributionType = s3DataDistributionType;
                return this;
            }

            /**
             * Sets the value of {@link EndpointInputProperty#getS3InputMode}
             * @param s3InputMode Whether the <code>Pipe</code> or <code>File</code> is used as the input mode for transferring data for the monitoring job.
             *                    <code>Pipe</code> mode is recommended for large datasets. <code>File</code> mode is useful for small files that fit in memory. Defaults to <code>File</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3InputMode(java.lang.String s3InputMode) {
                this.s3InputMode = s3InputMode;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EndpointInputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EndpointInputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EndpointInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EndpointInputProperty {
            private final java.lang.String endpointName;
            private final java.lang.String localPath;
            private final java.lang.String excludeFeaturesAttribute;
            private final java.lang.String s3DataDistributionType;
            private final java.lang.String s3InputMode;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.endpointName = software.amazon.jsii.Kernel.get(this, "endpointName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.localPath = software.amazon.jsii.Kernel.get(this, "localPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.excludeFeaturesAttribute = software.amazon.jsii.Kernel.get(this, "excludeFeaturesAttribute", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3DataDistributionType = software.amazon.jsii.Kernel.get(this, "s3DataDistributionType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3InputMode = software.amazon.jsii.Kernel.get(this, "s3InputMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.endpointName = java.util.Objects.requireNonNull(builder.endpointName, "endpointName is required");
                this.localPath = java.util.Objects.requireNonNull(builder.localPath, "localPath is required");
                this.excludeFeaturesAttribute = builder.excludeFeaturesAttribute;
                this.s3DataDistributionType = builder.s3DataDistributionType;
                this.s3InputMode = builder.s3InputMode;
            }

            @Override
            public final java.lang.String getEndpointName() {
                return this.endpointName;
            }

            @Override
            public final java.lang.String getLocalPath() {
                return this.localPath;
            }

            @Override
            public final java.lang.String getExcludeFeaturesAttribute() {
                return this.excludeFeaturesAttribute;
            }

            @Override
            public final java.lang.String getS3DataDistributionType() {
                return this.s3DataDistributionType;
            }

            @Override
            public final java.lang.String getS3InputMode() {
                return this.s3InputMode;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("endpointName", om.valueToTree(this.getEndpointName()));
                data.set("localPath", om.valueToTree(this.getLocalPath()));
                if (this.getExcludeFeaturesAttribute() != null) {
                    data.set("excludeFeaturesAttribute", om.valueToTree(this.getExcludeFeaturesAttribute()));
                }
                if (this.getS3DataDistributionType() != null) {
                    data.set("s3DataDistributionType", om.valueToTree(this.getS3DataDistributionType()));
                }
                if (this.getS3InputMode() != null) {
                    data.set("s3InputMode", om.valueToTree(this.getS3InputMode()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnMonitoringSchedule.EndpointInputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EndpointInputProperty.Jsii$Proxy that = (EndpointInputProperty.Jsii$Proxy) o;

                if (!endpointName.equals(that.endpointName)) return false;
                if (!localPath.equals(that.localPath)) return false;
                if (this.excludeFeaturesAttribute != null ? !this.excludeFeaturesAttribute.equals(that.excludeFeaturesAttribute) : that.excludeFeaturesAttribute != null) return false;
                if (this.s3DataDistributionType != null ? !this.s3DataDistributionType.equals(that.s3DataDistributionType) : that.s3DataDistributionType != null) return false;
                return this.s3InputMode != null ? this.s3InputMode.equals(that.s3InputMode) : that.s3InputMode == null;
            }

            @Override
            public final int hashCode() {
                int result = this.endpointName.hashCode();
                result = 31 * result + (this.localPath.hashCode());
                result = 31 * result + (this.excludeFeaturesAttribute != null ? this.excludeFeaturesAttribute.hashCode() : 0);
                result = 31 * result + (this.s3DataDistributionType != null ? this.s3DataDistributionType.hashCode() : 0);
                result = 31 * result + (this.s3InputMode != null ? this.s3InputMode.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The Json format.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * JsonProperty jsonProperty = JsonProperty.builder()
     *         .line(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-json.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-json.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnMonitoringSchedule.JsonProperty")
    @software.amazon.jsii.Jsii.Proxy(JsonProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface JsonProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A boolean flag indicating if it is JSON line format.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-json.html#cfn-sagemaker-monitoringschedule-json-line">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-json.html#cfn-sagemaker-monitoringschedule-json-line</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLine() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link JsonProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link JsonProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<JsonProperty> {
            java.lang.Object line;

            /**
             * Sets the value of {@link JsonProperty#getLine}
             * @param line A boolean flag indicating if it is JSON line format.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder line(java.lang.Boolean line) {
                this.line = line;
                return this;
            }

            /**
             * Sets the value of {@link JsonProperty#getLine}
             * @param line A boolean flag indicating if it is JSON line format.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder line(software.amazon.awscdk.IResolvable line) {
                this.line = line;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link JsonProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public JsonProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link JsonProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements JsonProperty {
            private final java.lang.Object line;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.line = software.amazon.jsii.Kernel.get(this, "line", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.line = builder.line;
            }

            @Override
            public final java.lang.Object getLine() {
                return this.line;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getLine() != null) {
                    data.set("line", om.valueToTree(this.getLine()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnMonitoringSchedule.JsonProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                JsonProperty.Jsii$Proxy that = (JsonProperty.Jsii$Proxy) o;

                return this.line != null ? this.line.equals(that.line) : that.line == null;
            }

            @Override
            public final int hashCode() {
                int result = this.line != null ? this.line.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Container image configuration object for the monitoring job.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * MonitoringAppSpecificationProperty monitoringAppSpecificationProperty = MonitoringAppSpecificationProperty.builder()
     *         .imageUri("imageUri")
     *         // the properties below are optional
     *         .containerArguments(List.of("containerArguments"))
     *         .containerEntrypoint(List.of("containerEntrypoint"))
     *         .postAnalyticsProcessorSourceUri("postAnalyticsProcessorSourceUri")
     *         .recordPreprocessorSourceUri("recordPreprocessorSourceUri")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringappspecification.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringappspecification.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnMonitoringSchedule.MonitoringAppSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(MonitoringAppSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MonitoringAppSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The container image to be run by the monitoring job.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringappspecification.html#cfn-sagemaker-monitoringschedule-monitoringappspecification-imageuri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringappspecification.html#cfn-sagemaker-monitoringschedule-monitoringappspecification-imageuri</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getImageUri();

        /**
         * An array of arguments for the container used to run the monitoring job.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringappspecification.html#cfn-sagemaker-monitoringschedule-monitoringappspecification-containerarguments">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringappspecification.html#cfn-sagemaker-monitoringschedule-monitoringappspecification-containerarguments</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getContainerArguments() {
            return null;
        }

        /**
         * Specifies the entrypoint for a container used to run the monitoring job.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringappspecification.html#cfn-sagemaker-monitoringschedule-monitoringappspecification-containerentrypoint">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringappspecification.html#cfn-sagemaker-monitoringschedule-monitoringappspecification-containerentrypoint</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getContainerEntrypoint() {
            return null;
        }

        /**
         * An Amazon S3 URI to a script that is called after analysis has been performed.
         * <p>
         * Applicable only for the built-in (first party) containers.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringappspecification.html#cfn-sagemaker-monitoringschedule-monitoringappspecification-postanalyticsprocessorsourceuri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringappspecification.html#cfn-sagemaker-monitoringschedule-monitoringappspecification-postanalyticsprocessorsourceuri</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPostAnalyticsProcessorSourceUri() {
            return null;
        }

        /**
         * An Amazon S3 URI to a script that is called per row prior to running analysis.
         * <p>
         * It can base64 decode the payload and convert it into a flattened JSON so that the built-in container can use the converted data. Applicable only for the built-in (first party) containers.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringappspecification.html#cfn-sagemaker-monitoringschedule-monitoringappspecification-recordpreprocessorsourceuri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringappspecification.html#cfn-sagemaker-monitoringschedule-monitoringappspecification-recordpreprocessorsourceuri</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRecordPreprocessorSourceUri() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MonitoringAppSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MonitoringAppSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MonitoringAppSpecificationProperty> {
            java.lang.String imageUri;
            java.util.List<java.lang.String> containerArguments;
            java.util.List<java.lang.String> containerEntrypoint;
            java.lang.String postAnalyticsProcessorSourceUri;
            java.lang.String recordPreprocessorSourceUri;

            /**
             * Sets the value of {@link MonitoringAppSpecificationProperty#getImageUri}
             * @param imageUri The container image to be run by the monitoring job. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder imageUri(java.lang.String imageUri) {
                this.imageUri = imageUri;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringAppSpecificationProperty#getContainerArguments}
             * @param containerArguments An array of arguments for the container used to run the monitoring job.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containerArguments(java.util.List<java.lang.String> containerArguments) {
                this.containerArguments = containerArguments;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringAppSpecificationProperty#getContainerEntrypoint}
             * @param containerEntrypoint Specifies the entrypoint for a container used to run the monitoring job.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containerEntrypoint(java.util.List<java.lang.String> containerEntrypoint) {
                this.containerEntrypoint = containerEntrypoint;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringAppSpecificationProperty#getPostAnalyticsProcessorSourceUri}
             * @param postAnalyticsProcessorSourceUri An Amazon S3 URI to a script that is called after analysis has been performed.
             *                                        Applicable only for the built-in (first party) containers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder postAnalyticsProcessorSourceUri(java.lang.String postAnalyticsProcessorSourceUri) {
                this.postAnalyticsProcessorSourceUri = postAnalyticsProcessorSourceUri;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringAppSpecificationProperty#getRecordPreprocessorSourceUri}
             * @param recordPreprocessorSourceUri An Amazon S3 URI to a script that is called per row prior to running analysis.
             *                                    It can base64 decode the payload and convert it into a flattened JSON so that the built-in container can use the converted data. Applicable only for the built-in (first party) containers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recordPreprocessorSourceUri(java.lang.String recordPreprocessorSourceUri) {
                this.recordPreprocessorSourceUri = recordPreprocessorSourceUri;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MonitoringAppSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MonitoringAppSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MonitoringAppSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MonitoringAppSpecificationProperty {
            private final java.lang.String imageUri;
            private final java.util.List<java.lang.String> containerArguments;
            private final java.util.List<java.lang.String> containerEntrypoint;
            private final java.lang.String postAnalyticsProcessorSourceUri;
            private final java.lang.String recordPreprocessorSourceUri;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.imageUri = software.amazon.jsii.Kernel.get(this, "imageUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.containerArguments = software.amazon.jsii.Kernel.get(this, "containerArguments", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.containerEntrypoint = software.amazon.jsii.Kernel.get(this, "containerEntrypoint", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.postAnalyticsProcessorSourceUri = software.amazon.jsii.Kernel.get(this, "postAnalyticsProcessorSourceUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.recordPreprocessorSourceUri = software.amazon.jsii.Kernel.get(this, "recordPreprocessorSourceUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.imageUri = java.util.Objects.requireNonNull(builder.imageUri, "imageUri is required");
                this.containerArguments = builder.containerArguments;
                this.containerEntrypoint = builder.containerEntrypoint;
                this.postAnalyticsProcessorSourceUri = builder.postAnalyticsProcessorSourceUri;
                this.recordPreprocessorSourceUri = builder.recordPreprocessorSourceUri;
            }

            @Override
            public final java.lang.String getImageUri() {
                return this.imageUri;
            }

            @Override
            public final java.util.List<java.lang.String> getContainerArguments() {
                return this.containerArguments;
            }

            @Override
            public final java.util.List<java.lang.String> getContainerEntrypoint() {
                return this.containerEntrypoint;
            }

            @Override
            public final java.lang.String getPostAnalyticsProcessorSourceUri() {
                return this.postAnalyticsProcessorSourceUri;
            }

            @Override
            public final java.lang.String getRecordPreprocessorSourceUri() {
                return this.recordPreprocessorSourceUri;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("imageUri", om.valueToTree(this.getImageUri()));
                if (this.getContainerArguments() != null) {
                    data.set("containerArguments", om.valueToTree(this.getContainerArguments()));
                }
                if (this.getContainerEntrypoint() != null) {
                    data.set("containerEntrypoint", om.valueToTree(this.getContainerEntrypoint()));
                }
                if (this.getPostAnalyticsProcessorSourceUri() != null) {
                    data.set("postAnalyticsProcessorSourceUri", om.valueToTree(this.getPostAnalyticsProcessorSourceUri()));
                }
                if (this.getRecordPreprocessorSourceUri() != null) {
                    data.set("recordPreprocessorSourceUri", om.valueToTree(this.getRecordPreprocessorSourceUri()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnMonitoringSchedule.MonitoringAppSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MonitoringAppSpecificationProperty.Jsii$Proxy that = (MonitoringAppSpecificationProperty.Jsii$Proxy) o;

                if (!imageUri.equals(that.imageUri)) return false;
                if (this.containerArguments != null ? !this.containerArguments.equals(that.containerArguments) : that.containerArguments != null) return false;
                if (this.containerEntrypoint != null ? !this.containerEntrypoint.equals(that.containerEntrypoint) : that.containerEntrypoint != null) return false;
                if (this.postAnalyticsProcessorSourceUri != null ? !this.postAnalyticsProcessorSourceUri.equals(that.postAnalyticsProcessorSourceUri) : that.postAnalyticsProcessorSourceUri != null) return false;
                return this.recordPreprocessorSourceUri != null ? this.recordPreprocessorSourceUri.equals(that.recordPreprocessorSourceUri) : that.recordPreprocessorSourceUri == null;
            }

            @Override
            public final int hashCode() {
                int result = this.imageUri.hashCode();
                result = 31 * result + (this.containerArguments != null ? this.containerArguments.hashCode() : 0);
                result = 31 * result + (this.containerEntrypoint != null ? this.containerEntrypoint.hashCode() : 0);
                result = 31 * result + (this.postAnalyticsProcessorSourceUri != null ? this.postAnalyticsProcessorSourceUri.hashCode() : 0);
                result = 31 * result + (this.recordPreprocessorSourceUri != null ? this.recordPreprocessorSourceUri.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Summary of information about the last monitoring job to run.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * MonitoringExecutionSummaryProperty monitoringExecutionSummaryProperty = MonitoringExecutionSummaryProperty.builder()
     *         .creationTime("creationTime")
     *         .lastModifiedTime("lastModifiedTime")
     *         .monitoringExecutionStatus("monitoringExecutionStatus")
     *         .monitoringScheduleName("monitoringScheduleName")
     *         .scheduledTime("scheduledTime")
     *         // the properties below are optional
     *         .endpointName("endpointName")
     *         .failureReason("failureReason")
     *         .processingJobArn("processingJobArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringexecutionsummary.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringexecutionsummary.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnMonitoringSchedule.MonitoringExecutionSummaryProperty")
    @software.amazon.jsii.Jsii.Proxy(MonitoringExecutionSummaryProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MonitoringExecutionSummaryProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The time at which the monitoring job was created.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringexecutionsummary.html#cfn-sagemaker-monitoringschedule-monitoringexecutionsummary-creationtime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringexecutionsummary.html#cfn-sagemaker-monitoringschedule-monitoringexecutionsummary-creationtime</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCreationTime();

        /**
         * A timestamp that indicates the last time the monitoring job was modified.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringexecutionsummary.html#cfn-sagemaker-monitoringschedule-monitoringexecutionsummary-lastmodifiedtime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringexecutionsummary.html#cfn-sagemaker-monitoringschedule-monitoringexecutionsummary-lastmodifiedtime</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLastModifiedTime();

        /**
         * The status of the monitoring job.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringexecutionsummary.html#cfn-sagemaker-monitoringschedule-monitoringexecutionsummary-monitoringexecutionstatus">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringexecutionsummary.html#cfn-sagemaker-monitoringschedule-monitoringexecutionsummary-monitoringexecutionstatus</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMonitoringExecutionStatus();

        /**
         * The name of the monitoring schedule.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringexecutionsummary.html#cfn-sagemaker-monitoringschedule-monitoringexecutionsummary-monitoringschedulename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringexecutionsummary.html#cfn-sagemaker-monitoringschedule-monitoringexecutionsummary-monitoringschedulename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMonitoringScheduleName();

        /**
         * The time the monitoring job was scheduled.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringexecutionsummary.html#cfn-sagemaker-monitoringschedule-monitoringexecutionsummary-scheduledtime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringexecutionsummary.html#cfn-sagemaker-monitoringschedule-monitoringexecutionsummary-scheduledtime</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getScheduledTime();

        /**
         * The name of the endpoint used to run the monitoring job.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringexecutionsummary.html#cfn-sagemaker-monitoringschedule-monitoringexecutionsummary-endpointname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringexecutionsummary.html#cfn-sagemaker-monitoringschedule-monitoringexecutionsummary-endpointname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEndpointName() {
            return null;
        }

        /**
         * Contains the reason a monitoring job failed, if it failed.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringexecutionsummary.html#cfn-sagemaker-monitoringschedule-monitoringexecutionsummary-failurereason">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringexecutionsummary.html#cfn-sagemaker-monitoringschedule-monitoringexecutionsummary-failurereason</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFailureReason() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) of the monitoring job.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringexecutionsummary.html#cfn-sagemaker-monitoringschedule-monitoringexecutionsummary-processingjobarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringexecutionsummary.html#cfn-sagemaker-monitoringschedule-monitoringexecutionsummary-processingjobarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getProcessingJobArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MonitoringExecutionSummaryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MonitoringExecutionSummaryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MonitoringExecutionSummaryProperty> {
            java.lang.String creationTime;
            java.lang.String lastModifiedTime;
            java.lang.String monitoringExecutionStatus;
            java.lang.String monitoringScheduleName;
            java.lang.String scheduledTime;
            java.lang.String endpointName;
            java.lang.String failureReason;
            java.lang.String processingJobArn;

            /**
             * Sets the value of {@link MonitoringExecutionSummaryProperty#getCreationTime}
             * @param creationTime The time at which the monitoring job was created. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder creationTime(java.lang.String creationTime) {
                this.creationTime = creationTime;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringExecutionSummaryProperty#getLastModifiedTime}
             * @param lastModifiedTime A timestamp that indicates the last time the monitoring job was modified. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lastModifiedTime(java.lang.String lastModifiedTime) {
                this.lastModifiedTime = lastModifiedTime;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringExecutionSummaryProperty#getMonitoringExecutionStatus}
             * @param monitoringExecutionStatus The status of the monitoring job. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder monitoringExecutionStatus(java.lang.String monitoringExecutionStatus) {
                this.monitoringExecutionStatus = monitoringExecutionStatus;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringExecutionSummaryProperty#getMonitoringScheduleName}
             * @param monitoringScheduleName The name of the monitoring schedule. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder monitoringScheduleName(java.lang.String monitoringScheduleName) {
                this.monitoringScheduleName = monitoringScheduleName;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringExecutionSummaryProperty#getScheduledTime}
             * @param scheduledTime The time the monitoring job was scheduled. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scheduledTime(java.lang.String scheduledTime) {
                this.scheduledTime = scheduledTime;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringExecutionSummaryProperty#getEndpointName}
             * @param endpointName The name of the endpoint used to run the monitoring job.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endpointName(java.lang.String endpointName) {
                this.endpointName = endpointName;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringExecutionSummaryProperty#getFailureReason}
             * @param failureReason Contains the reason a monitoring job failed, if it failed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder failureReason(java.lang.String failureReason) {
                this.failureReason = failureReason;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringExecutionSummaryProperty#getProcessingJobArn}
             * @param processingJobArn The Amazon Resource Name (ARN) of the monitoring job.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder processingJobArn(java.lang.String processingJobArn) {
                this.processingJobArn = processingJobArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MonitoringExecutionSummaryProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MonitoringExecutionSummaryProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MonitoringExecutionSummaryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MonitoringExecutionSummaryProperty {
            private final java.lang.String creationTime;
            private final java.lang.String lastModifiedTime;
            private final java.lang.String monitoringExecutionStatus;
            private final java.lang.String monitoringScheduleName;
            private final java.lang.String scheduledTime;
            private final java.lang.String endpointName;
            private final java.lang.String failureReason;
            private final java.lang.String processingJobArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.creationTime = software.amazon.jsii.Kernel.get(this, "creationTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.lastModifiedTime = software.amazon.jsii.Kernel.get(this, "lastModifiedTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.monitoringExecutionStatus = software.amazon.jsii.Kernel.get(this, "monitoringExecutionStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.monitoringScheduleName = software.amazon.jsii.Kernel.get(this, "monitoringScheduleName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.scheduledTime = software.amazon.jsii.Kernel.get(this, "scheduledTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.endpointName = software.amazon.jsii.Kernel.get(this, "endpointName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.failureReason = software.amazon.jsii.Kernel.get(this, "failureReason", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.processingJobArn = software.amazon.jsii.Kernel.get(this, "processingJobArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.creationTime = java.util.Objects.requireNonNull(builder.creationTime, "creationTime is required");
                this.lastModifiedTime = java.util.Objects.requireNonNull(builder.lastModifiedTime, "lastModifiedTime is required");
                this.monitoringExecutionStatus = java.util.Objects.requireNonNull(builder.monitoringExecutionStatus, "monitoringExecutionStatus is required");
                this.monitoringScheduleName = java.util.Objects.requireNonNull(builder.monitoringScheduleName, "monitoringScheduleName is required");
                this.scheduledTime = java.util.Objects.requireNonNull(builder.scheduledTime, "scheduledTime is required");
                this.endpointName = builder.endpointName;
                this.failureReason = builder.failureReason;
                this.processingJobArn = builder.processingJobArn;
            }

            @Override
            public final java.lang.String getCreationTime() {
                return this.creationTime;
            }

            @Override
            public final java.lang.String getLastModifiedTime() {
                return this.lastModifiedTime;
            }

            @Override
            public final java.lang.String getMonitoringExecutionStatus() {
                return this.monitoringExecutionStatus;
            }

            @Override
            public final java.lang.String getMonitoringScheduleName() {
                return this.monitoringScheduleName;
            }

            @Override
            public final java.lang.String getScheduledTime() {
                return this.scheduledTime;
            }

            @Override
            public final java.lang.String getEndpointName() {
                return this.endpointName;
            }

            @Override
            public final java.lang.String getFailureReason() {
                return this.failureReason;
            }

            @Override
            public final java.lang.String getProcessingJobArn() {
                return this.processingJobArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("creationTime", om.valueToTree(this.getCreationTime()));
                data.set("lastModifiedTime", om.valueToTree(this.getLastModifiedTime()));
                data.set("monitoringExecutionStatus", om.valueToTree(this.getMonitoringExecutionStatus()));
                data.set("monitoringScheduleName", om.valueToTree(this.getMonitoringScheduleName()));
                data.set("scheduledTime", om.valueToTree(this.getScheduledTime()));
                if (this.getEndpointName() != null) {
                    data.set("endpointName", om.valueToTree(this.getEndpointName()));
                }
                if (this.getFailureReason() != null) {
                    data.set("failureReason", om.valueToTree(this.getFailureReason()));
                }
                if (this.getProcessingJobArn() != null) {
                    data.set("processingJobArn", om.valueToTree(this.getProcessingJobArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnMonitoringSchedule.MonitoringExecutionSummaryProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MonitoringExecutionSummaryProperty.Jsii$Proxy that = (MonitoringExecutionSummaryProperty.Jsii$Proxy) o;

                if (!creationTime.equals(that.creationTime)) return false;
                if (!lastModifiedTime.equals(that.lastModifiedTime)) return false;
                if (!monitoringExecutionStatus.equals(that.monitoringExecutionStatus)) return false;
                if (!monitoringScheduleName.equals(that.monitoringScheduleName)) return false;
                if (!scheduledTime.equals(that.scheduledTime)) return false;
                if (this.endpointName != null ? !this.endpointName.equals(that.endpointName) : that.endpointName != null) return false;
                if (this.failureReason != null ? !this.failureReason.equals(that.failureReason) : that.failureReason != null) return false;
                return this.processingJobArn != null ? this.processingJobArn.equals(that.processingJobArn) : that.processingJobArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.creationTime.hashCode();
                result = 31 * result + (this.lastModifiedTime.hashCode());
                result = 31 * result + (this.monitoringExecutionStatus.hashCode());
                result = 31 * result + (this.monitoringScheduleName.hashCode());
                result = 31 * result + (this.scheduledTime.hashCode());
                result = 31 * result + (this.endpointName != null ? this.endpointName.hashCode() : 0);
                result = 31 * result + (this.failureReason != null ? this.failureReason.hashCode() : 0);
                result = 31 * result + (this.processingJobArn != null ? this.processingJobArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The inputs for a monitoring job.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * MonitoringInputProperty monitoringInputProperty = MonitoringInputProperty.builder()
     *         .batchTransformInput(BatchTransformInputProperty.builder()
     *                 .dataCapturedDestinationS3Uri("dataCapturedDestinationS3Uri")
     *                 .datasetFormat(DatasetFormatProperty.builder()
     *                         .csv(CsvProperty.builder()
     *                                 .header(false)
     *                                 .build())
     *                         .json(JsonProperty.builder()
     *                                 .line(false)
     *                                 .build())
     *                         .parquet(false)
     *                         .build())
     *                 .localPath("localPath")
     *                 // the properties below are optional
     *                 .excludeFeaturesAttribute("excludeFeaturesAttribute")
     *                 .s3DataDistributionType("s3DataDistributionType")
     *                 .s3InputMode("s3InputMode")
     *                 .build())
     *         .endpointInput(EndpointInputProperty.builder()
     *                 .endpointName("endpointName")
     *                 .localPath("localPath")
     *                 // the properties below are optional
     *                 .excludeFeaturesAttribute("excludeFeaturesAttribute")
     *                 .s3DataDistributionType("s3DataDistributionType")
     *                 .s3InputMode("s3InputMode")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringinput.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringinput.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnMonitoringSchedule.MonitoringInputProperty")
    @software.amazon.jsii.Jsii.Proxy(MonitoringInputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MonitoringInputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Input object for the batch transform job.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringinput.html#cfn-sagemaker-monitoringschedule-monitoringinput-batchtransforminput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringinput.html#cfn-sagemaker-monitoringschedule-monitoringinput-batchtransforminput</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBatchTransformInput() {
            return null;
        }

        /**
         * The endpoint for a monitoring job.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringinput.html#cfn-sagemaker-monitoringschedule-monitoringinput-endpointinput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringinput.html#cfn-sagemaker-monitoringschedule-monitoringinput-endpointinput</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEndpointInput() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MonitoringInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MonitoringInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MonitoringInputProperty> {
            java.lang.Object batchTransformInput;
            java.lang.Object endpointInput;

            /**
             * Sets the value of {@link MonitoringInputProperty#getBatchTransformInput}
             * @param batchTransformInput Input object for the batch transform job.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder batchTransformInput(software.amazon.awscdk.IResolvable batchTransformInput) {
                this.batchTransformInput = batchTransformInput;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringInputProperty#getBatchTransformInput}
             * @param batchTransformInput Input object for the batch transform job.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder batchTransformInput(software.amazon.awscdk.services.sagemaker.CfnMonitoringSchedule.BatchTransformInputProperty batchTransformInput) {
                this.batchTransformInput = batchTransformInput;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringInputProperty#getEndpointInput}
             * @param endpointInput The endpoint for a monitoring job.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endpointInput(software.amazon.awscdk.IResolvable endpointInput) {
                this.endpointInput = endpointInput;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringInputProperty#getEndpointInput}
             * @param endpointInput The endpoint for a monitoring job.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endpointInput(software.amazon.awscdk.services.sagemaker.CfnMonitoringSchedule.EndpointInputProperty endpointInput) {
                this.endpointInput = endpointInput;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MonitoringInputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MonitoringInputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MonitoringInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MonitoringInputProperty {
            private final java.lang.Object batchTransformInput;
            private final java.lang.Object endpointInput;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.batchTransformInput = software.amazon.jsii.Kernel.get(this, "batchTransformInput", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.endpointInput = software.amazon.jsii.Kernel.get(this, "endpointInput", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.batchTransformInput = builder.batchTransformInput;
                this.endpointInput = builder.endpointInput;
            }

            @Override
            public final java.lang.Object getBatchTransformInput() {
                return this.batchTransformInput;
            }

            @Override
            public final java.lang.Object getEndpointInput() {
                return this.endpointInput;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBatchTransformInput() != null) {
                    data.set("batchTransformInput", om.valueToTree(this.getBatchTransformInput()));
                }
                if (this.getEndpointInput() != null) {
                    data.set("endpointInput", om.valueToTree(this.getEndpointInput()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnMonitoringSchedule.MonitoringInputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MonitoringInputProperty.Jsii$Proxy that = (MonitoringInputProperty.Jsii$Proxy) o;

                if (this.batchTransformInput != null ? !this.batchTransformInput.equals(that.batchTransformInput) : that.batchTransformInput != null) return false;
                return this.endpointInput != null ? this.endpointInput.equals(that.endpointInput) : that.endpointInput == null;
            }

            @Override
            public final int hashCode() {
                int result = this.batchTransformInput != null ? this.batchTransformInput.hashCode() : 0;
                result = 31 * result + (this.endpointInput != null ? this.endpointInput.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Defines the monitoring job.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * MonitoringJobDefinitionProperty monitoringJobDefinitionProperty = MonitoringJobDefinitionProperty.builder()
     *         .monitoringAppSpecification(MonitoringAppSpecificationProperty.builder()
     *                 .imageUri("imageUri")
     *                 // the properties below are optional
     *                 .containerArguments(List.of("containerArguments"))
     *                 .containerEntrypoint(List.of("containerEntrypoint"))
     *                 .postAnalyticsProcessorSourceUri("postAnalyticsProcessorSourceUri")
     *                 .recordPreprocessorSourceUri("recordPreprocessorSourceUri")
     *                 .build())
     *         .monitoringInputs(List.of(MonitoringInputProperty.builder()
     *                 .batchTransformInput(BatchTransformInputProperty.builder()
     *                         .dataCapturedDestinationS3Uri("dataCapturedDestinationS3Uri")
     *                         .datasetFormat(DatasetFormatProperty.builder()
     *                                 .csv(CsvProperty.builder()
     *                                         .header(false)
     *                                         .build())
     *                                 .json(JsonProperty.builder()
     *                                         .line(false)
     *                                         .build())
     *                                 .parquet(false)
     *                                 .build())
     *                         .localPath("localPath")
     *                         // the properties below are optional
     *                         .excludeFeaturesAttribute("excludeFeaturesAttribute")
     *                         .s3DataDistributionType("s3DataDistributionType")
     *                         .s3InputMode("s3InputMode")
     *                         .build())
     *                 .endpointInput(EndpointInputProperty.builder()
     *                         .endpointName("endpointName")
     *                         .localPath("localPath")
     *                         // the properties below are optional
     *                         .excludeFeaturesAttribute("excludeFeaturesAttribute")
     *                         .s3DataDistributionType("s3DataDistributionType")
     *                         .s3InputMode("s3InputMode")
     *                         .build())
     *                 .build()))
     *         .monitoringOutputConfig(MonitoringOutputConfigProperty.builder()
     *                 .monitoringOutputs(List.of(MonitoringOutputProperty.builder()
     *                         .s3Output(S3OutputProperty.builder()
     *                                 .localPath("localPath")
     *                                 .s3Uri("s3Uri")
     *                                 // the properties below are optional
     *                                 .s3UploadMode("s3UploadMode")
     *                                 .build())
     *                         .build()))
     *                 // the properties below are optional
     *                 .kmsKeyId("kmsKeyId")
     *                 .build())
     *         .monitoringResources(MonitoringResourcesProperty.builder()
     *                 .clusterConfig(ClusterConfigProperty.builder()
     *                         .instanceCount(123)
     *                         .instanceType("instanceType")
     *                         .volumeSizeInGb(123)
     *                         // the properties below are optional
     *                         .volumeKmsKeyId("volumeKmsKeyId")
     *                         .build())
     *                 .build())
     *         .roleArn("roleArn")
     *         // the properties below are optional
     *         .baselineConfig(BaselineConfigProperty.builder()
     *                 .constraintsResource(ConstraintsResourceProperty.builder()
     *                         .s3Uri("s3Uri")
     *                         .build())
     *                 .statisticsResource(StatisticsResourceProperty.builder()
     *                         .s3Uri("s3Uri")
     *                         .build())
     *                 .build())
     *         .environment(Map.of(
     *                 "environmentKey", "environment"))
     *         .networkConfig(NetworkConfigProperty.builder()
     *                 .enableInterContainerTrafficEncryption(false)
     *                 .enableNetworkIsolation(false)
     *                 .vpcConfig(VpcConfigProperty.builder()
     *                         .securityGroupIds(List.of("securityGroupIds"))
     *                         .subnets(List.of("subnets"))
     *                         .build())
     *                 .build())
     *         .stoppingCondition(StoppingConditionProperty.builder()
     *                 .maxRuntimeInSeconds(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringjobdefinition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringjobdefinition.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnMonitoringSchedule.MonitoringJobDefinitionProperty")
    @software.amazon.jsii.Jsii.Proxy(MonitoringJobDefinitionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MonitoringJobDefinitionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Configures the monitoring job to run a specified Docker container image.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringjobdefinition.html#cfn-sagemaker-monitoringschedule-monitoringjobdefinition-monitoringappspecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringjobdefinition.html#cfn-sagemaker-monitoringschedule-monitoringjobdefinition-monitoringappspecification</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getMonitoringAppSpecification();

        /**
         * The array of inputs for the monitoring job.
         * <p>
         * Currently we support monitoring an Amazon SageMaker AI Endpoint.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringjobdefinition.html#cfn-sagemaker-monitoringschedule-monitoringjobdefinition-monitoringinputs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringjobdefinition.html#cfn-sagemaker-monitoringschedule-monitoringjobdefinition-monitoringinputs</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getMonitoringInputs();

        /**
         * The array of outputs from the monitoring job to be uploaded to Amazon S3.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringjobdefinition.html#cfn-sagemaker-monitoringschedule-monitoringjobdefinition-monitoringoutputconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringjobdefinition.html#cfn-sagemaker-monitoringschedule-monitoringjobdefinition-monitoringoutputconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getMonitoringOutputConfig();

        /**
         * Identifies the resources, ML compute instances, and ML storage volumes to deploy for a monitoring job.
         * <p>
         * In distributed processing, you specify more than one instance.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringjobdefinition.html#cfn-sagemaker-monitoringschedule-monitoringjobdefinition-monitoringresources">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringjobdefinition.html#cfn-sagemaker-monitoringschedule-monitoringjobdefinition-monitoringresources</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getMonitoringResources();

        /**
         * The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker AI can assume to perform tasks on your behalf.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringjobdefinition.html#cfn-sagemaker-monitoringschedule-monitoringjobdefinition-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringjobdefinition.html#cfn-sagemaker-monitoringschedule-monitoringjobdefinition-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * Baseline configuration used to validate that the data conforms to the specified constraints and statistics.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringjobdefinition.html#cfn-sagemaker-monitoringschedule-monitoringjobdefinition-baselineconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringjobdefinition.html#cfn-sagemaker-monitoringschedule-monitoringjobdefinition-baselineconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBaselineConfig() {
            return null;
        }

        /**
         * Sets the environment variables in the Docker container.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringjobdefinition.html#cfn-sagemaker-monitoringschedule-monitoringjobdefinition-environment">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringjobdefinition.html#cfn-sagemaker-monitoringschedule-monitoringjobdefinition-environment</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnvironment() {
            return null;
        }

        /**
         * Specifies networking options for an monitoring job.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringjobdefinition.html#cfn-sagemaker-monitoringschedule-monitoringjobdefinition-networkconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringjobdefinition.html#cfn-sagemaker-monitoringschedule-monitoringjobdefinition-networkconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNetworkConfig() {
            return null;
        }

        /**
         * Specifies a time limit for how long the monitoring job is allowed to run.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringjobdefinition.html#cfn-sagemaker-monitoringschedule-monitoringjobdefinition-stoppingcondition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringjobdefinition.html#cfn-sagemaker-monitoringschedule-monitoringjobdefinition-stoppingcondition</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStoppingCondition() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MonitoringJobDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MonitoringJobDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MonitoringJobDefinitionProperty> {
            java.lang.Object monitoringAppSpecification;
            java.lang.Object monitoringInputs;
            java.lang.Object monitoringOutputConfig;
            java.lang.Object monitoringResources;
            java.lang.String roleArn;
            java.lang.Object baselineConfig;
            java.lang.Object environment;
            java.lang.Object networkConfig;
            java.lang.Object stoppingCondition;

            /**
             * Sets the value of {@link MonitoringJobDefinitionProperty#getMonitoringAppSpecification}
             * @param monitoringAppSpecification Configures the monitoring job to run a specified Docker container image. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder monitoringAppSpecification(software.amazon.awscdk.IResolvable monitoringAppSpecification) {
                this.monitoringAppSpecification = monitoringAppSpecification;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringJobDefinitionProperty#getMonitoringAppSpecification}
             * @param monitoringAppSpecification Configures the monitoring job to run a specified Docker container image. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder monitoringAppSpecification(software.amazon.awscdk.services.sagemaker.CfnMonitoringSchedule.MonitoringAppSpecificationProperty monitoringAppSpecification) {
                this.monitoringAppSpecification = monitoringAppSpecification;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringJobDefinitionProperty#getMonitoringInputs}
             * @param monitoringInputs The array of inputs for the monitoring job. This parameter is required.
             *                         Currently we support monitoring an Amazon SageMaker AI Endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder monitoringInputs(software.amazon.awscdk.IResolvable monitoringInputs) {
                this.monitoringInputs = monitoringInputs;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringJobDefinitionProperty#getMonitoringInputs}
             * @param monitoringInputs The array of inputs for the monitoring job. This parameter is required.
             *                         Currently we support monitoring an Amazon SageMaker AI Endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder monitoringInputs(java.util.List<? extends java.lang.Object> monitoringInputs) {
                this.monitoringInputs = monitoringInputs;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringJobDefinitionProperty#getMonitoringOutputConfig}
             * @param monitoringOutputConfig The array of outputs from the monitoring job to be uploaded to Amazon S3. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder monitoringOutputConfig(software.amazon.awscdk.IResolvable monitoringOutputConfig) {
                this.monitoringOutputConfig = monitoringOutputConfig;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringJobDefinitionProperty#getMonitoringOutputConfig}
             * @param monitoringOutputConfig The array of outputs from the monitoring job to be uploaded to Amazon S3. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder monitoringOutputConfig(software.amazon.awscdk.services.sagemaker.CfnMonitoringSchedule.MonitoringOutputConfigProperty monitoringOutputConfig) {
                this.monitoringOutputConfig = monitoringOutputConfig;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringJobDefinitionProperty#getMonitoringResources}
             * @param monitoringResources Identifies the resources, ML compute instances, and ML storage volumes to deploy for a monitoring job. This parameter is required.
             *                            In distributed processing, you specify more than one instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder monitoringResources(software.amazon.awscdk.IResolvable monitoringResources) {
                this.monitoringResources = monitoringResources;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringJobDefinitionProperty#getMonitoringResources}
             * @param monitoringResources Identifies the resources, ML compute instances, and ML storage volumes to deploy for a monitoring job. This parameter is required.
             *                            In distributed processing, you specify more than one instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder monitoringResources(software.amazon.awscdk.services.sagemaker.CfnMonitoringSchedule.MonitoringResourcesProperty monitoringResources) {
                this.monitoringResources = monitoringResources;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringJobDefinitionProperty#getRoleArn}
             * @param roleArn The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker AI can assume to perform tasks on your behalf. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringJobDefinitionProperty#getBaselineConfig}
             * @param baselineConfig Baseline configuration used to validate that the data conforms to the specified constraints and statistics.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder baselineConfig(software.amazon.awscdk.IResolvable baselineConfig) {
                this.baselineConfig = baselineConfig;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringJobDefinitionProperty#getBaselineConfig}
             * @param baselineConfig Baseline configuration used to validate that the data conforms to the specified constraints and statistics.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder baselineConfig(software.amazon.awscdk.services.sagemaker.CfnMonitoringSchedule.BaselineConfigProperty baselineConfig) {
                this.baselineConfig = baselineConfig;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringJobDefinitionProperty#getEnvironment}
             * @param environment Sets the environment variables in the Docker container.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder environment(java.util.Map<java.lang.String, java.lang.String> environment) {
                this.environment = environment;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringJobDefinitionProperty#getEnvironment}
             * @param environment Sets the environment variables in the Docker container.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder environment(software.amazon.awscdk.IResolvable environment) {
                this.environment = environment;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringJobDefinitionProperty#getNetworkConfig}
             * @param networkConfig Specifies networking options for an monitoring job.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkConfig(software.amazon.awscdk.IResolvable networkConfig) {
                this.networkConfig = networkConfig;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringJobDefinitionProperty#getNetworkConfig}
             * @param networkConfig Specifies networking options for an monitoring job.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkConfig(software.amazon.awscdk.services.sagemaker.CfnMonitoringSchedule.NetworkConfigProperty networkConfig) {
                this.networkConfig = networkConfig;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringJobDefinitionProperty#getStoppingCondition}
             * @param stoppingCondition Specifies a time limit for how long the monitoring job is allowed to run.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stoppingCondition(software.amazon.awscdk.IResolvable stoppingCondition) {
                this.stoppingCondition = stoppingCondition;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringJobDefinitionProperty#getStoppingCondition}
             * @param stoppingCondition Specifies a time limit for how long the monitoring job is allowed to run.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stoppingCondition(software.amazon.awscdk.services.sagemaker.CfnMonitoringSchedule.StoppingConditionProperty stoppingCondition) {
                this.stoppingCondition = stoppingCondition;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MonitoringJobDefinitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MonitoringJobDefinitionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MonitoringJobDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MonitoringJobDefinitionProperty {
            private final java.lang.Object monitoringAppSpecification;
            private final java.lang.Object monitoringInputs;
            private final java.lang.Object monitoringOutputConfig;
            private final java.lang.Object monitoringResources;
            private final java.lang.String roleArn;
            private final java.lang.Object baselineConfig;
            private final java.lang.Object environment;
            private final java.lang.Object networkConfig;
            private final java.lang.Object stoppingCondition;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.monitoringAppSpecification = software.amazon.jsii.Kernel.get(this, "monitoringAppSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.monitoringInputs = software.amazon.jsii.Kernel.get(this, "monitoringInputs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.monitoringOutputConfig = software.amazon.jsii.Kernel.get(this, "monitoringOutputConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.monitoringResources = software.amazon.jsii.Kernel.get(this, "monitoringResources", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.baselineConfig = software.amazon.jsii.Kernel.get(this, "baselineConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.environment = software.amazon.jsii.Kernel.get(this, "environment", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.networkConfig = software.amazon.jsii.Kernel.get(this, "networkConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.stoppingCondition = software.amazon.jsii.Kernel.get(this, "stoppingCondition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.monitoringAppSpecification = java.util.Objects.requireNonNull(builder.monitoringAppSpecification, "monitoringAppSpecification is required");
                this.monitoringInputs = java.util.Objects.requireNonNull(builder.monitoringInputs, "monitoringInputs is required");
                this.monitoringOutputConfig = java.util.Objects.requireNonNull(builder.monitoringOutputConfig, "monitoringOutputConfig is required");
                this.monitoringResources = java.util.Objects.requireNonNull(builder.monitoringResources, "monitoringResources is required");
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
                this.baselineConfig = builder.baselineConfig;
                this.environment = builder.environment;
                this.networkConfig = builder.networkConfig;
                this.stoppingCondition = builder.stoppingCondition;
            }

            @Override
            public final java.lang.Object getMonitoringAppSpecification() {
                return this.monitoringAppSpecification;
            }

            @Override
            public final java.lang.Object getMonitoringInputs() {
                return this.monitoringInputs;
            }

            @Override
            public final java.lang.Object getMonitoringOutputConfig() {
                return this.monitoringOutputConfig;
            }

            @Override
            public final java.lang.Object getMonitoringResources() {
                return this.monitoringResources;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.Object getBaselineConfig() {
                return this.baselineConfig;
            }

            @Override
            public final java.lang.Object getEnvironment() {
                return this.environment;
            }

            @Override
            public final java.lang.Object getNetworkConfig() {
                return this.networkConfig;
            }

            @Override
            public final java.lang.Object getStoppingCondition() {
                return this.stoppingCondition;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("monitoringAppSpecification", om.valueToTree(this.getMonitoringAppSpecification()));
                data.set("monitoringInputs", om.valueToTree(this.getMonitoringInputs()));
                data.set("monitoringOutputConfig", om.valueToTree(this.getMonitoringOutputConfig()));
                data.set("monitoringResources", om.valueToTree(this.getMonitoringResources()));
                data.set("roleArn", om.valueToTree(this.getRoleArn()));
                if (this.getBaselineConfig() != null) {
                    data.set("baselineConfig", om.valueToTree(this.getBaselineConfig()));
                }
                if (this.getEnvironment() != null) {
                    data.set("environment", om.valueToTree(this.getEnvironment()));
                }
                if (this.getNetworkConfig() != null) {
                    data.set("networkConfig", om.valueToTree(this.getNetworkConfig()));
                }
                if (this.getStoppingCondition() != null) {
                    data.set("stoppingCondition", om.valueToTree(this.getStoppingCondition()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnMonitoringSchedule.MonitoringJobDefinitionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MonitoringJobDefinitionProperty.Jsii$Proxy that = (MonitoringJobDefinitionProperty.Jsii$Proxy) o;

                if (!monitoringAppSpecification.equals(that.monitoringAppSpecification)) return false;
                if (!monitoringInputs.equals(that.monitoringInputs)) return false;
                if (!monitoringOutputConfig.equals(that.monitoringOutputConfig)) return false;
                if (!monitoringResources.equals(that.monitoringResources)) return false;
                if (!roleArn.equals(that.roleArn)) return false;
                if (this.baselineConfig != null ? !this.baselineConfig.equals(that.baselineConfig) : that.baselineConfig != null) return false;
                if (this.environment != null ? !this.environment.equals(that.environment) : that.environment != null) return false;
                if (this.networkConfig != null ? !this.networkConfig.equals(that.networkConfig) : that.networkConfig != null) return false;
                return this.stoppingCondition != null ? this.stoppingCondition.equals(that.stoppingCondition) : that.stoppingCondition == null;
            }

            @Override
            public final int hashCode() {
                int result = this.monitoringAppSpecification.hashCode();
                result = 31 * result + (this.monitoringInputs.hashCode());
                result = 31 * result + (this.monitoringOutputConfig.hashCode());
                result = 31 * result + (this.monitoringResources.hashCode());
                result = 31 * result + (this.roleArn.hashCode());
                result = 31 * result + (this.baselineConfig != null ? this.baselineConfig.hashCode() : 0);
                result = 31 * result + (this.environment != null ? this.environment.hashCode() : 0);
                result = 31 * result + (this.networkConfig != null ? this.networkConfig.hashCode() : 0);
                result = 31 * result + (this.stoppingCondition != null ? this.stoppingCondition.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The output configuration for monitoring jobs.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * MonitoringOutputConfigProperty monitoringOutputConfigProperty = MonitoringOutputConfigProperty.builder()
     *         .monitoringOutputs(List.of(MonitoringOutputProperty.builder()
     *                 .s3Output(S3OutputProperty.builder()
     *                         .localPath("localPath")
     *                         .s3Uri("s3Uri")
     *                         // the properties below are optional
     *                         .s3UploadMode("s3UploadMode")
     *                         .build())
     *                 .build()))
     *         // the properties below are optional
     *         .kmsKeyId("kmsKeyId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringoutputconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringoutputconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnMonitoringSchedule.MonitoringOutputConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(MonitoringOutputConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MonitoringOutputConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Monitoring outputs for monitoring jobs.
         * <p>
         * This is where the output of the periodic monitoring jobs is uploaded.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringoutputconfig.html#cfn-sagemaker-monitoringschedule-monitoringoutputconfig-monitoringoutputs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringoutputconfig.html#cfn-sagemaker-monitoringschedule-monitoringoutputconfig-monitoringoutputs</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getMonitoringOutputs();

        /**
         * The AWS Key Management Service ( AWS KMS ) key that Amazon SageMaker AI uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringoutputconfig.html#cfn-sagemaker-monitoringschedule-monitoringoutputconfig-kmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringoutputconfig.html#cfn-sagemaker-monitoringschedule-monitoringoutputconfig-kmskeyid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MonitoringOutputConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MonitoringOutputConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MonitoringOutputConfigProperty> {
            java.lang.Object monitoringOutputs;
            java.lang.String kmsKeyId;

            /**
             * Sets the value of {@link MonitoringOutputConfigProperty#getMonitoringOutputs}
             * @param monitoringOutputs Monitoring outputs for monitoring jobs. This parameter is required.
             *                          This is where the output of the periodic monitoring jobs is uploaded.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder monitoringOutputs(software.amazon.awscdk.IResolvable monitoringOutputs) {
                this.monitoringOutputs = monitoringOutputs;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringOutputConfigProperty#getMonitoringOutputs}
             * @param monitoringOutputs Monitoring outputs for monitoring jobs. This parameter is required.
             *                          This is where the output of the periodic monitoring jobs is uploaded.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder monitoringOutputs(java.util.List<? extends java.lang.Object> monitoringOutputs) {
                this.monitoringOutputs = monitoringOutputs;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringOutputConfigProperty#getKmsKeyId}
             * @param kmsKeyId The AWS Key Management Service ( AWS KMS ) key that Amazon SageMaker AI uses to encrypt the model artifacts at rest using Amazon S3 server-side encryption.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKeyId(java.lang.String kmsKeyId) {
                this.kmsKeyId = kmsKeyId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MonitoringOutputConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MonitoringOutputConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MonitoringOutputConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MonitoringOutputConfigProperty {
            private final java.lang.Object monitoringOutputs;
            private final java.lang.String kmsKeyId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.monitoringOutputs = software.amazon.jsii.Kernel.get(this, "monitoringOutputs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.monitoringOutputs = java.util.Objects.requireNonNull(builder.monitoringOutputs, "monitoringOutputs is required");
                this.kmsKeyId = builder.kmsKeyId;
            }

            @Override
            public final java.lang.Object getMonitoringOutputs() {
                return this.monitoringOutputs;
            }

            @Override
            public final java.lang.String getKmsKeyId() {
                return this.kmsKeyId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("monitoringOutputs", om.valueToTree(this.getMonitoringOutputs()));
                if (this.getKmsKeyId() != null) {
                    data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnMonitoringSchedule.MonitoringOutputConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MonitoringOutputConfigProperty.Jsii$Proxy that = (MonitoringOutputConfigProperty.Jsii$Proxy) o;

                if (!monitoringOutputs.equals(that.monitoringOutputs)) return false;
                return this.kmsKeyId != null ? this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.monitoringOutputs.hashCode();
                result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The output object for a monitoring job.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * MonitoringOutputProperty monitoringOutputProperty = MonitoringOutputProperty.builder()
     *         .s3Output(S3OutputProperty.builder()
     *                 .localPath("localPath")
     *                 .s3Uri("s3Uri")
     *                 // the properties below are optional
     *                 .s3UploadMode("s3UploadMode")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringoutput.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringoutput.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnMonitoringSchedule.MonitoringOutputProperty")
    @software.amazon.jsii.Jsii.Proxy(MonitoringOutputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MonitoringOutputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon S3 storage location where the results of a monitoring job are saved.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringoutput.html#cfn-sagemaker-monitoringschedule-monitoringoutput-s3output">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringoutput.html#cfn-sagemaker-monitoringschedule-monitoringoutput-s3output</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getS3Output();

        /**
         * @return a {@link Builder} of {@link MonitoringOutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MonitoringOutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MonitoringOutputProperty> {
            java.lang.Object s3Output;

            /**
             * Sets the value of {@link MonitoringOutputProperty#getS3Output}
             * @param s3Output The Amazon S3 storage location where the results of a monitoring job are saved. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Output(software.amazon.awscdk.IResolvable s3Output) {
                this.s3Output = s3Output;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringOutputProperty#getS3Output}
             * @param s3Output The Amazon S3 storage location where the results of a monitoring job are saved. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Output(software.amazon.awscdk.services.sagemaker.CfnMonitoringSchedule.S3OutputProperty s3Output) {
                this.s3Output = s3Output;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MonitoringOutputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MonitoringOutputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MonitoringOutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MonitoringOutputProperty {
            private final java.lang.Object s3Output;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.s3Output = software.amazon.jsii.Kernel.get(this, "s3Output", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.s3Output = java.util.Objects.requireNonNull(builder.s3Output, "s3Output is required");
            }

            @Override
            public final java.lang.Object getS3Output() {
                return this.s3Output;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("s3Output", om.valueToTree(this.getS3Output()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnMonitoringSchedule.MonitoringOutputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MonitoringOutputProperty.Jsii$Proxy that = (MonitoringOutputProperty.Jsii$Proxy) o;

                return this.s3Output.equals(that.s3Output);
            }

            @Override
            public final int hashCode() {
                int result = this.s3Output.hashCode();
                return result;
            }
        }
    }
    /**
     * Identifies the resources to deploy for a monitoring job.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * MonitoringResourcesProperty monitoringResourcesProperty = MonitoringResourcesProperty.builder()
     *         .clusterConfig(ClusterConfigProperty.builder()
     *                 .instanceCount(123)
     *                 .instanceType("instanceType")
     *                 .volumeSizeInGb(123)
     *                 // the properties below are optional
     *                 .volumeKmsKeyId("volumeKmsKeyId")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringresources.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringresources.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnMonitoringSchedule.MonitoringResourcesProperty")
    @software.amazon.jsii.Jsii.Proxy(MonitoringResourcesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MonitoringResourcesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The configuration for the cluster resources used to run the processing job.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringresources.html#cfn-sagemaker-monitoringschedule-monitoringresources-clusterconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringresources.html#cfn-sagemaker-monitoringschedule-monitoringresources-clusterconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getClusterConfig();

        /**
         * @return a {@link Builder} of {@link MonitoringResourcesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MonitoringResourcesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MonitoringResourcesProperty> {
            java.lang.Object clusterConfig;

            /**
             * Sets the value of {@link MonitoringResourcesProperty#getClusterConfig}
             * @param clusterConfig The configuration for the cluster resources used to run the processing job. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clusterConfig(software.amazon.awscdk.IResolvable clusterConfig) {
                this.clusterConfig = clusterConfig;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringResourcesProperty#getClusterConfig}
             * @param clusterConfig The configuration for the cluster resources used to run the processing job. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clusterConfig(software.amazon.awscdk.services.sagemaker.CfnMonitoringSchedule.ClusterConfigProperty clusterConfig) {
                this.clusterConfig = clusterConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MonitoringResourcesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MonitoringResourcesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MonitoringResourcesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MonitoringResourcesProperty {
            private final java.lang.Object clusterConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.clusterConfig = software.amazon.jsii.Kernel.get(this, "clusterConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.clusterConfig = java.util.Objects.requireNonNull(builder.clusterConfig, "clusterConfig is required");
            }

            @Override
            public final java.lang.Object getClusterConfig() {
                return this.clusterConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("clusterConfig", om.valueToTree(this.getClusterConfig()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnMonitoringSchedule.MonitoringResourcesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MonitoringResourcesProperty.Jsii$Proxy that = (MonitoringResourcesProperty.Jsii$Proxy) o;

                return this.clusterConfig.equals(that.clusterConfig);
            }

            @Override
            public final int hashCode() {
                int result = this.clusterConfig.hashCode();
                return result;
            }
        }
    }
    /**
     * Configures the monitoring schedule and defines the monitoring job.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * MonitoringScheduleConfigProperty monitoringScheduleConfigProperty = MonitoringScheduleConfigProperty.builder()
     *         .monitoringJobDefinition(MonitoringJobDefinitionProperty.builder()
     *                 .monitoringAppSpecification(MonitoringAppSpecificationProperty.builder()
     *                         .imageUri("imageUri")
     *                         // the properties below are optional
     *                         .containerArguments(List.of("containerArguments"))
     *                         .containerEntrypoint(List.of("containerEntrypoint"))
     *                         .postAnalyticsProcessorSourceUri("postAnalyticsProcessorSourceUri")
     *                         .recordPreprocessorSourceUri("recordPreprocessorSourceUri")
     *                         .build())
     *                 .monitoringInputs(List.of(MonitoringInputProperty.builder()
     *                         .batchTransformInput(BatchTransformInputProperty.builder()
     *                                 .dataCapturedDestinationS3Uri("dataCapturedDestinationS3Uri")
     *                                 .datasetFormat(DatasetFormatProperty.builder()
     *                                         .csv(CsvProperty.builder()
     *                                                 .header(false)
     *                                                 .build())
     *                                         .json(JsonProperty.builder()
     *                                                 .line(false)
     *                                                 .build())
     *                                         .parquet(false)
     *                                         .build())
     *                                 .localPath("localPath")
     *                                 // the properties below are optional
     *                                 .excludeFeaturesAttribute("excludeFeaturesAttribute")
     *                                 .s3DataDistributionType("s3DataDistributionType")
     *                                 .s3InputMode("s3InputMode")
     *                                 .build())
     *                         .endpointInput(EndpointInputProperty.builder()
     *                                 .endpointName("endpointName")
     *                                 .localPath("localPath")
     *                                 // the properties below are optional
     *                                 .excludeFeaturesAttribute("excludeFeaturesAttribute")
     *                                 .s3DataDistributionType("s3DataDistributionType")
     *                                 .s3InputMode("s3InputMode")
     *                                 .build())
     *                         .build()))
     *                 .monitoringOutputConfig(MonitoringOutputConfigProperty.builder()
     *                         .monitoringOutputs(List.of(MonitoringOutputProperty.builder()
     *                                 .s3Output(S3OutputProperty.builder()
     *                                         .localPath("localPath")
     *                                         .s3Uri("s3Uri")
     *                                         // the properties below are optional
     *                                         .s3UploadMode("s3UploadMode")
     *                                         .build())
     *                                 .build()))
     *                         // the properties below are optional
     *                         .kmsKeyId("kmsKeyId")
     *                         .build())
     *                 .monitoringResources(MonitoringResourcesProperty.builder()
     *                         .clusterConfig(ClusterConfigProperty.builder()
     *                                 .instanceCount(123)
     *                                 .instanceType("instanceType")
     *                                 .volumeSizeInGb(123)
     *                                 // the properties below are optional
     *                                 .volumeKmsKeyId("volumeKmsKeyId")
     *                                 .build())
     *                         .build())
     *                 .roleArn("roleArn")
     *                 // the properties below are optional
     *                 .baselineConfig(BaselineConfigProperty.builder()
     *                         .constraintsResource(ConstraintsResourceProperty.builder()
     *                                 .s3Uri("s3Uri")
     *                                 .build())
     *                         .statisticsResource(StatisticsResourceProperty.builder()
     *                                 .s3Uri("s3Uri")
     *                                 .build())
     *                         .build())
     *                 .environment(Map.of(
     *                         "environmentKey", "environment"))
     *                 .networkConfig(NetworkConfigProperty.builder()
     *                         .enableInterContainerTrafficEncryption(false)
     *                         .enableNetworkIsolation(false)
     *                         .vpcConfig(VpcConfigProperty.builder()
     *                                 .securityGroupIds(List.of("securityGroupIds"))
     *                                 .subnets(List.of("subnets"))
     *                                 .build())
     *                         .build())
     *                 .stoppingCondition(StoppingConditionProperty.builder()
     *                         .maxRuntimeInSeconds(123)
     *                         .build())
     *                 .build())
     *         .monitoringJobDefinitionName("monitoringJobDefinitionName")
     *         .monitoringType("monitoringType")
     *         .scheduleConfig(ScheduleConfigProperty.builder()
     *                 .scheduleExpression("scheduleExpression")
     *                 // the properties below are optional
     *                 .dataAnalysisEndTime("dataAnalysisEndTime")
     *                 .dataAnalysisStartTime("dataAnalysisStartTime")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringscheduleconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringscheduleconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnMonitoringSchedule.MonitoringScheduleConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(MonitoringScheduleConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MonitoringScheduleConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Defines the monitoring job.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringscheduleconfig.html#cfn-sagemaker-monitoringschedule-monitoringscheduleconfig-monitoringjobdefinition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringscheduleconfig.html#cfn-sagemaker-monitoringschedule-monitoringscheduleconfig-monitoringjobdefinition</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMonitoringJobDefinition() {
            return null;
        }

        /**
         * The name of the monitoring job definition to schedule.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringscheduleconfig.html#cfn-sagemaker-monitoringschedule-monitoringscheduleconfig-monitoringjobdefinitionname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringscheduleconfig.html#cfn-sagemaker-monitoringschedule-monitoringscheduleconfig-monitoringjobdefinitionname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMonitoringJobDefinitionName() {
            return null;
        }

        /**
         * The type of the monitoring job definition to schedule.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringscheduleconfig.html#cfn-sagemaker-monitoringschedule-monitoringscheduleconfig-monitoringtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringscheduleconfig.html#cfn-sagemaker-monitoringschedule-monitoringscheduleconfig-monitoringtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMonitoringType() {
            return null;
        }

        /**
         * Configures the monitoring schedule.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringscheduleconfig.html#cfn-sagemaker-monitoringschedule-monitoringscheduleconfig-scheduleconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-monitoringscheduleconfig.html#cfn-sagemaker-monitoringschedule-monitoringscheduleconfig-scheduleconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getScheduleConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MonitoringScheduleConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MonitoringScheduleConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MonitoringScheduleConfigProperty> {
            java.lang.Object monitoringJobDefinition;
            java.lang.String monitoringJobDefinitionName;
            java.lang.String monitoringType;
            java.lang.Object scheduleConfig;

            /**
             * Sets the value of {@link MonitoringScheduleConfigProperty#getMonitoringJobDefinition}
             * @param monitoringJobDefinition Defines the monitoring job.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder monitoringJobDefinition(software.amazon.awscdk.IResolvable monitoringJobDefinition) {
                this.monitoringJobDefinition = monitoringJobDefinition;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringScheduleConfigProperty#getMonitoringJobDefinition}
             * @param monitoringJobDefinition Defines the monitoring job.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder monitoringJobDefinition(software.amazon.awscdk.services.sagemaker.CfnMonitoringSchedule.MonitoringJobDefinitionProperty monitoringJobDefinition) {
                this.monitoringJobDefinition = monitoringJobDefinition;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringScheduleConfigProperty#getMonitoringJobDefinitionName}
             * @param monitoringJobDefinitionName The name of the monitoring job definition to schedule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder monitoringJobDefinitionName(java.lang.String monitoringJobDefinitionName) {
                this.monitoringJobDefinitionName = monitoringJobDefinitionName;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringScheduleConfigProperty#getMonitoringType}
             * @param monitoringType The type of the monitoring job definition to schedule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder monitoringType(java.lang.String monitoringType) {
                this.monitoringType = monitoringType;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringScheduleConfigProperty#getScheduleConfig}
             * @param scheduleConfig Configures the monitoring schedule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scheduleConfig(software.amazon.awscdk.IResolvable scheduleConfig) {
                this.scheduleConfig = scheduleConfig;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringScheduleConfigProperty#getScheduleConfig}
             * @param scheduleConfig Configures the monitoring schedule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scheduleConfig(software.amazon.awscdk.services.sagemaker.CfnMonitoringSchedule.ScheduleConfigProperty scheduleConfig) {
                this.scheduleConfig = scheduleConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MonitoringScheduleConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MonitoringScheduleConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MonitoringScheduleConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MonitoringScheduleConfigProperty {
            private final java.lang.Object monitoringJobDefinition;
            private final java.lang.String monitoringJobDefinitionName;
            private final java.lang.String monitoringType;
            private final java.lang.Object scheduleConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.monitoringJobDefinition = software.amazon.jsii.Kernel.get(this, "monitoringJobDefinition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.monitoringJobDefinitionName = software.amazon.jsii.Kernel.get(this, "monitoringJobDefinitionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.monitoringType = software.amazon.jsii.Kernel.get(this, "monitoringType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.scheduleConfig = software.amazon.jsii.Kernel.get(this, "scheduleConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.monitoringJobDefinition = builder.monitoringJobDefinition;
                this.monitoringJobDefinitionName = builder.monitoringJobDefinitionName;
                this.monitoringType = builder.monitoringType;
                this.scheduleConfig = builder.scheduleConfig;
            }

            @Override
            public final java.lang.Object getMonitoringJobDefinition() {
                return this.monitoringJobDefinition;
            }

            @Override
            public final java.lang.String getMonitoringJobDefinitionName() {
                return this.monitoringJobDefinitionName;
            }

            @Override
            public final java.lang.String getMonitoringType() {
                return this.monitoringType;
            }

            @Override
            public final java.lang.Object getScheduleConfig() {
                return this.scheduleConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMonitoringJobDefinition() != null) {
                    data.set("monitoringJobDefinition", om.valueToTree(this.getMonitoringJobDefinition()));
                }
                if (this.getMonitoringJobDefinitionName() != null) {
                    data.set("monitoringJobDefinitionName", om.valueToTree(this.getMonitoringJobDefinitionName()));
                }
                if (this.getMonitoringType() != null) {
                    data.set("monitoringType", om.valueToTree(this.getMonitoringType()));
                }
                if (this.getScheduleConfig() != null) {
                    data.set("scheduleConfig", om.valueToTree(this.getScheduleConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnMonitoringSchedule.MonitoringScheduleConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MonitoringScheduleConfigProperty.Jsii$Proxy that = (MonitoringScheduleConfigProperty.Jsii$Proxy) o;

                if (this.monitoringJobDefinition != null ? !this.monitoringJobDefinition.equals(that.monitoringJobDefinition) : that.monitoringJobDefinition != null) return false;
                if (this.monitoringJobDefinitionName != null ? !this.monitoringJobDefinitionName.equals(that.monitoringJobDefinitionName) : that.monitoringJobDefinitionName != null) return false;
                if (this.monitoringType != null ? !this.monitoringType.equals(that.monitoringType) : that.monitoringType != null) return false;
                return this.scheduleConfig != null ? this.scheduleConfig.equals(that.scheduleConfig) : that.scheduleConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.monitoringJobDefinition != null ? this.monitoringJobDefinition.hashCode() : 0;
                result = 31 * result + (this.monitoringJobDefinitionName != null ? this.monitoringJobDefinitionName.hashCode() : 0);
                result = 31 * result + (this.monitoringType != null ? this.monitoringType.hashCode() : 0);
                result = 31 * result + (this.scheduleConfig != null ? this.scheduleConfig.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Networking options for a job, such as network traffic encryption between containers, whether to allow inbound and outbound network calls to and from containers, and the VPC subnets and security groups to use for VPC-enabled jobs.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * NetworkConfigProperty networkConfigProperty = NetworkConfigProperty.builder()
     *         .enableInterContainerTrafficEncryption(false)
     *         .enableNetworkIsolation(false)
     *         .vpcConfig(VpcConfigProperty.builder()
     *                 .securityGroupIds(List.of("securityGroupIds"))
     *                 .subnets(List.of("subnets"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-networkconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-networkconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnMonitoringSchedule.NetworkConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(NetworkConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NetworkConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Whether to encrypt all communications between distributed processing jobs.
         * <p>
         * Choose <code>True</code> to encrypt communications. Encryption provides greater security for distributed processing jobs, but the processing might take longer.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-networkconfig.html#cfn-sagemaker-monitoringschedule-networkconfig-enableintercontainertrafficencryption">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-networkconfig.html#cfn-sagemaker-monitoringschedule-networkconfig-enableintercontainertrafficencryption</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnableInterContainerTrafficEncryption() {
            return null;
        }

        /**
         * Whether to allow inbound and outbound network calls to and from the containers used for the processing job.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-networkconfig.html#cfn-sagemaker-monitoringschedule-networkconfig-enablenetworkisolation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-networkconfig.html#cfn-sagemaker-monitoringschedule-networkconfig-enablenetworkisolation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnableNetworkIsolation() {
            return null;
        }

        /**
         * Specifies a VPC that your training jobs and hosted models have access to.
         * <p>
         * Control access to and from your training and model containers by configuring the VPC. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/host-vpc.html">Protect Endpoints by Using an Amazon Virtual Private Cloud</a> and <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html">Protect Training Jobs by Using an Amazon Virtual Private Cloud</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-networkconfig.html#cfn-sagemaker-monitoringschedule-networkconfig-vpcconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-networkconfig.html#cfn-sagemaker-monitoringschedule-networkconfig-vpcconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVpcConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NetworkConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NetworkConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NetworkConfigProperty> {
            java.lang.Object enableInterContainerTrafficEncryption;
            java.lang.Object enableNetworkIsolation;
            java.lang.Object vpcConfig;

            /**
             * Sets the value of {@link NetworkConfigProperty#getEnableInterContainerTrafficEncryption}
             * @param enableInterContainerTrafficEncryption Whether to encrypt all communications between distributed processing jobs.
             *                                              Choose <code>True</code> to encrypt communications. Encryption provides greater security for distributed processing jobs, but the processing might take longer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableInterContainerTrafficEncryption(java.lang.Boolean enableInterContainerTrafficEncryption) {
                this.enableInterContainerTrafficEncryption = enableInterContainerTrafficEncryption;
                return this;
            }

            /**
             * Sets the value of {@link NetworkConfigProperty#getEnableInterContainerTrafficEncryption}
             * @param enableInterContainerTrafficEncryption Whether to encrypt all communications between distributed processing jobs.
             *                                              Choose <code>True</code> to encrypt communications. Encryption provides greater security for distributed processing jobs, but the processing might take longer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableInterContainerTrafficEncryption(software.amazon.awscdk.IResolvable enableInterContainerTrafficEncryption) {
                this.enableInterContainerTrafficEncryption = enableInterContainerTrafficEncryption;
                return this;
            }

            /**
             * Sets the value of {@link NetworkConfigProperty#getEnableNetworkIsolation}
             * @param enableNetworkIsolation Whether to allow inbound and outbound network calls to and from the containers used for the processing job.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableNetworkIsolation(java.lang.Boolean enableNetworkIsolation) {
                this.enableNetworkIsolation = enableNetworkIsolation;
                return this;
            }

            /**
             * Sets the value of {@link NetworkConfigProperty#getEnableNetworkIsolation}
             * @param enableNetworkIsolation Whether to allow inbound and outbound network calls to and from the containers used for the processing job.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableNetworkIsolation(software.amazon.awscdk.IResolvable enableNetworkIsolation) {
                this.enableNetworkIsolation = enableNetworkIsolation;
                return this;
            }

            /**
             * Sets the value of {@link NetworkConfigProperty#getVpcConfig}
             * @param vpcConfig Specifies a VPC that your training jobs and hosted models have access to.
             *                  Control access to and from your training and model containers by configuring the VPC. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/host-vpc.html">Protect Endpoints by Using an Amazon Virtual Private Cloud</a> and <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html">Protect Training Jobs by Using an Amazon Virtual Private Cloud</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcConfig(software.amazon.awscdk.IResolvable vpcConfig) {
                this.vpcConfig = vpcConfig;
                return this;
            }

            /**
             * Sets the value of {@link NetworkConfigProperty#getVpcConfig}
             * @param vpcConfig Specifies a VPC that your training jobs and hosted models have access to.
             *                  Control access to and from your training and model containers by configuring the VPC. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/host-vpc.html">Protect Endpoints by Using an Amazon Virtual Private Cloud</a> and <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html">Protect Training Jobs by Using an Amazon Virtual Private Cloud</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcConfig(software.amazon.awscdk.services.sagemaker.CfnMonitoringSchedule.VpcConfigProperty vpcConfig) {
                this.vpcConfig = vpcConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NetworkConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NetworkConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NetworkConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NetworkConfigProperty {
            private final java.lang.Object enableInterContainerTrafficEncryption;
            private final java.lang.Object enableNetworkIsolation;
            private final java.lang.Object vpcConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enableInterContainerTrafficEncryption = software.amazon.jsii.Kernel.get(this, "enableInterContainerTrafficEncryption", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.enableNetworkIsolation = software.amazon.jsii.Kernel.get(this, "enableNetworkIsolation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.vpcConfig = software.amazon.jsii.Kernel.get(this, "vpcConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enableInterContainerTrafficEncryption = builder.enableInterContainerTrafficEncryption;
                this.enableNetworkIsolation = builder.enableNetworkIsolation;
                this.vpcConfig = builder.vpcConfig;
            }

            @Override
            public final java.lang.Object getEnableInterContainerTrafficEncryption() {
                return this.enableInterContainerTrafficEncryption;
            }

            @Override
            public final java.lang.Object getEnableNetworkIsolation() {
                return this.enableNetworkIsolation;
            }

            @Override
            public final java.lang.Object getVpcConfig() {
                return this.vpcConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEnableInterContainerTrafficEncryption() != null) {
                    data.set("enableInterContainerTrafficEncryption", om.valueToTree(this.getEnableInterContainerTrafficEncryption()));
                }
                if (this.getEnableNetworkIsolation() != null) {
                    data.set("enableNetworkIsolation", om.valueToTree(this.getEnableNetworkIsolation()));
                }
                if (this.getVpcConfig() != null) {
                    data.set("vpcConfig", om.valueToTree(this.getVpcConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnMonitoringSchedule.NetworkConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NetworkConfigProperty.Jsii$Proxy that = (NetworkConfigProperty.Jsii$Proxy) o;

                if (this.enableInterContainerTrafficEncryption != null ? !this.enableInterContainerTrafficEncryption.equals(that.enableInterContainerTrafficEncryption) : that.enableInterContainerTrafficEncryption != null) return false;
                if (this.enableNetworkIsolation != null ? !this.enableNetworkIsolation.equals(that.enableNetworkIsolation) : that.enableNetworkIsolation != null) return false;
                return this.vpcConfig != null ? this.vpcConfig.equals(that.vpcConfig) : that.vpcConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enableInterContainerTrafficEncryption != null ? this.enableInterContainerTrafficEncryption.hashCode() : 0;
                result = 31 * result + (this.enableNetworkIsolation != null ? this.enableNetworkIsolation.hashCode() : 0);
                result = 31 * result + (this.vpcConfig != null ? this.vpcConfig.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about where and how you want to store the results of a monitoring job.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * S3OutputProperty s3OutputProperty = S3OutputProperty.builder()
     *         .localPath("localPath")
     *         .s3Uri("s3Uri")
     *         // the properties below are optional
     *         .s3UploadMode("s3UploadMode")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-s3output.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-s3output.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnMonitoringSchedule.S3OutputProperty")
    @software.amazon.jsii.Jsii.Proxy(S3OutputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3OutputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The local path to the S3 storage location where SageMaker saves the results of a monitoring job.
         * <p>
         * LocalPath is an absolute path for the output data.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-s3output.html#cfn-sagemaker-monitoringschedule-s3output-localpath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-s3output.html#cfn-sagemaker-monitoringschedule-s3output-localpath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLocalPath();

        /**
         * A URI that identifies the S3 storage location where SageMaker saves the results of a monitoring job.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-s3output.html#cfn-sagemaker-monitoringschedule-s3output-s3uri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-s3output.html#cfn-sagemaker-monitoringschedule-s3output-s3uri</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getS3Uri();

        /**
         * Whether to upload the results of the monitoring job continuously or after the job completes.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-s3output.html#cfn-sagemaker-monitoringschedule-s3output-s3uploadmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-s3output.html#cfn-sagemaker-monitoringschedule-s3output-s3uploadmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3UploadMode() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3OutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3OutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3OutputProperty> {
            java.lang.String localPath;
            java.lang.String s3Uri;
            java.lang.String s3UploadMode;

            /**
             * Sets the value of {@link S3OutputProperty#getLocalPath}
             * @param localPath The local path to the S3 storage location where SageMaker saves the results of a monitoring job. This parameter is required.
             *                  LocalPath is an absolute path for the output data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder localPath(java.lang.String localPath) {
                this.localPath = localPath;
                return this;
            }

            /**
             * Sets the value of {@link S3OutputProperty#getS3Uri}
             * @param s3Uri A URI that identifies the S3 storage location where SageMaker saves the results of a monitoring job. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Uri(java.lang.String s3Uri) {
                this.s3Uri = s3Uri;
                return this;
            }

            /**
             * Sets the value of {@link S3OutputProperty#getS3UploadMode}
             * @param s3UploadMode Whether to upload the results of the monitoring job continuously or after the job completes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3UploadMode(java.lang.String s3UploadMode) {
                this.s3UploadMode = s3UploadMode;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3OutputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3OutputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3OutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3OutputProperty {
            private final java.lang.String localPath;
            private final java.lang.String s3Uri;
            private final java.lang.String s3UploadMode;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.localPath = software.amazon.jsii.Kernel.get(this, "localPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3Uri = software.amazon.jsii.Kernel.get(this, "s3Uri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3UploadMode = software.amazon.jsii.Kernel.get(this, "s3UploadMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.localPath = java.util.Objects.requireNonNull(builder.localPath, "localPath is required");
                this.s3Uri = java.util.Objects.requireNonNull(builder.s3Uri, "s3Uri is required");
                this.s3UploadMode = builder.s3UploadMode;
            }

            @Override
            public final java.lang.String getLocalPath() {
                return this.localPath;
            }

            @Override
            public final java.lang.String getS3Uri() {
                return this.s3Uri;
            }

            @Override
            public final java.lang.String getS3UploadMode() {
                return this.s3UploadMode;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("localPath", om.valueToTree(this.getLocalPath()));
                data.set("s3Uri", om.valueToTree(this.getS3Uri()));
                if (this.getS3UploadMode() != null) {
                    data.set("s3UploadMode", om.valueToTree(this.getS3UploadMode()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnMonitoringSchedule.S3OutputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3OutputProperty.Jsii$Proxy that = (S3OutputProperty.Jsii$Proxy) o;

                if (!localPath.equals(that.localPath)) return false;
                if (!s3Uri.equals(that.s3Uri)) return false;
                return this.s3UploadMode != null ? this.s3UploadMode.equals(that.s3UploadMode) : that.s3UploadMode == null;
            }

            @Override
            public final int hashCode() {
                int result = this.localPath.hashCode();
                result = 31 * result + (this.s3Uri.hashCode());
                result = 31 * result + (this.s3UploadMode != null ? this.s3UploadMode.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configuration details about the monitoring schedule.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * ScheduleConfigProperty scheduleConfigProperty = ScheduleConfigProperty.builder()
     *         .scheduleExpression("scheduleExpression")
     *         // the properties below are optional
     *         .dataAnalysisEndTime("dataAnalysisEndTime")
     *         .dataAnalysisStartTime("dataAnalysisStartTime")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-scheduleconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-scheduleconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnMonitoringSchedule.ScheduleConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ScheduleConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ScheduleConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A cron expression that describes details about the monitoring schedule.
         * <p>
         * The supported cron expressions are:
         * <p>
         * <ul>
         * <li>If you want to set the job to start every hour, use the following:</li>
         * </ul>
         * <p>
         * <code>Hourly: cron(0 * ? * * *)</code>
         * <p>
         * <ul>
         * <li>If you want to start the job daily:</li>
         * </ul>
         * <p>
         * <code>cron(0 [00-23] ? * * *)</code>
         * <p>
         * <ul>
         * <li>If you want to run the job one time, immediately, use the following keyword:</li>
         * </ul>
         * <p>
         * <code>NOW</code>
         * <p>
         * For example, the following are valid cron expressions:
         * <p>
         * <ul>
         * <li>Daily at noon UTC: <code>cron(0 12 ? * * *)</code></li>
         * <li>Daily at midnight UTC: <code>cron(0 0 ? * * *)</code></li>
         * </ul>
         * <p>
         * To support running every 6, 12 hours, the following are also supported:
         * <p>
         * <code>cron(0 [00-23]/[01-24] ? * * *)</code>
         * <p>
         * For example, the following are valid cron expressions:
         * <p>
         * <ul>
         * <li>Every 12 hours, starting at 5pm UTC: <code>cron(0 17/12 ? * * *)</code></li>
         * <li>Every two hours starting at midnight: <code>cron(0 0/2 ? * * *)</code></li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * <ul>
         * <li>Even though the cron expression is set to start at 5PM UTC, note that there could be a delay of 0-20 minutes from the actual requested time to run the execution.</li>
         * <li>We recommend that if you would like a daily schedule, you do not provide this parameter. Amazon SageMaker AI will pick a time for running every day.</li>
         * </ul>
         * <p>
         * </blockquote>
         * <p>
         * You can also specify the keyword <code>NOW</code> to run the monitoring job immediately, one time, without recurring.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-scheduleconfig.html#cfn-sagemaker-monitoringschedule-scheduleconfig-scheduleexpression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-scheduleconfig.html#cfn-sagemaker-monitoringschedule-scheduleconfig-scheduleexpression</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getScheduleExpression();

        /**
         * Sets the end time for a monitoring job window.
         * <p>
         * Express this time as an offset to the times that you schedule your monitoring jobs to run. You schedule monitoring jobs with the <code>ScheduleExpression</code> parameter. Specify this offset in ISO 8601 duration format. For example, if you want to end the window one hour before the start of each monitoring job, you would specify: <code>"-PT1H"</code> .
         * <p>
         * The end time that you specify must not follow the start time that you specify by more than 24 hours. You specify the start time with the <code>DataAnalysisStartTime</code> parameter.
         * <p>
         * If you set <code>ScheduleExpression</code> to <code>NOW</code> , this parameter is required.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-scheduleconfig.html#cfn-sagemaker-monitoringschedule-scheduleconfig-dataanalysisendtime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-scheduleconfig.html#cfn-sagemaker-monitoringschedule-scheduleconfig-dataanalysisendtime</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDataAnalysisEndTime() {
            return null;
        }

        /**
         * Sets the start time for a monitoring job window.
         * <p>
         * Express this time as an offset to the times that you schedule your monitoring jobs to run. You schedule monitoring jobs with the <code>ScheduleExpression</code> parameter. Specify this offset in ISO 8601 duration format. For example, if you want to monitor the five hours of data in your dataset that precede the start of each monitoring job, you would specify: <code>"-PT5H"</code> .
         * <p>
         * The start time that you specify must not precede the end time that you specify by more than 24 hours. You specify the end time with the <code>DataAnalysisEndTime</code> parameter.
         * <p>
         * If you set <code>ScheduleExpression</code> to <code>NOW</code> , this parameter is required.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-scheduleconfig.html#cfn-sagemaker-monitoringschedule-scheduleconfig-dataanalysisstarttime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-scheduleconfig.html#cfn-sagemaker-monitoringschedule-scheduleconfig-dataanalysisstarttime</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDataAnalysisStartTime() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ScheduleConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ScheduleConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ScheduleConfigProperty> {
            java.lang.String scheduleExpression;
            java.lang.String dataAnalysisEndTime;
            java.lang.String dataAnalysisStartTime;

            /**
             * Sets the value of {@link ScheduleConfigProperty#getScheduleExpression}
             * @param scheduleExpression A cron expression that describes details about the monitoring schedule. This parameter is required.
             *                           The supported cron expressions are:
             *                           <p>
             *                           <ul>
             *                           <li>If you want to set the job to start every hour, use the following:</li>
             *                           </ul>
             *                           <p>
             *                           <code>Hourly: cron(0 * ? * * *)</code>
             *                           <p>
             *                           <ul>
             *                           <li>If you want to start the job daily:</li>
             *                           </ul>
             *                           <p>
             *                           <code>cron(0 [00-23] ? * * *)</code>
             *                           <p>
             *                           <ul>
             *                           <li>If you want to run the job one time, immediately, use the following keyword:</li>
             *                           </ul>
             *                           <p>
             *                           <code>NOW</code>
             *                           <p>
             *                           For example, the following are valid cron expressions:
             *                           <p>
             *                           <ul>
             *                           <li>Daily at noon UTC: <code>cron(0 12 ? * * *)</code></li>
             *                           <li>Daily at midnight UTC: <code>cron(0 0 ? * * *)</code></li>
             *                           </ul>
             *                           <p>
             *                           To support running every 6, 12 hours, the following are also supported:
             *                           <p>
             *                           <code>cron(0 [00-23]/[01-24] ? * * *)</code>
             *                           <p>
             *                           For example, the following are valid cron expressions:
             *                           <p>
             *                           <ul>
             *                           <li>Every 12 hours, starting at 5pm UTC: <code>cron(0 17/12 ? * * *)</code></li>
             *                           <li>Every two hours starting at midnight: <code>cron(0 0/2 ? * * *)</code></li>
             *                           </ul>
             *                           <p>
             *                           <blockquote>
             *                           <p>
             *                           <ul>
             *                           <li>Even though the cron expression is set to start at 5PM UTC, note that there could be a delay of 0-20 minutes from the actual requested time to run the execution.</li>
             *                           <li>We recommend that if you would like a daily schedule, you do not provide this parameter. Amazon SageMaker AI will pick a time for running every day.</li>
             *                           </ul>
             *                           <p>
             *                           </blockquote>
             *                           <p>
             *                           You can also specify the keyword <code>NOW</code> to run the monitoring job immediately, one time, without recurring.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scheduleExpression(java.lang.String scheduleExpression) {
                this.scheduleExpression = scheduleExpression;
                return this;
            }

            /**
             * Sets the value of {@link ScheduleConfigProperty#getDataAnalysisEndTime}
             * @param dataAnalysisEndTime Sets the end time for a monitoring job window.
             *                            Express this time as an offset to the times that you schedule your monitoring jobs to run. You schedule monitoring jobs with the <code>ScheduleExpression</code> parameter. Specify this offset in ISO 8601 duration format. For example, if you want to end the window one hour before the start of each monitoring job, you would specify: <code>"-PT1H"</code> .
             *                            <p>
             *                            The end time that you specify must not follow the start time that you specify by more than 24 hours. You specify the start time with the <code>DataAnalysisStartTime</code> parameter.
             *                            <p>
             *                            If you set <code>ScheduleExpression</code> to <code>NOW</code> , this parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataAnalysisEndTime(java.lang.String dataAnalysisEndTime) {
                this.dataAnalysisEndTime = dataAnalysisEndTime;
                return this;
            }

            /**
             * Sets the value of {@link ScheduleConfigProperty#getDataAnalysisStartTime}
             * @param dataAnalysisStartTime Sets the start time for a monitoring job window.
             *                              Express this time as an offset to the times that you schedule your monitoring jobs to run. You schedule monitoring jobs with the <code>ScheduleExpression</code> parameter. Specify this offset in ISO 8601 duration format. For example, if you want to monitor the five hours of data in your dataset that precede the start of each monitoring job, you would specify: <code>"-PT5H"</code> .
             *                              <p>
             *                              The start time that you specify must not precede the end time that you specify by more than 24 hours. You specify the end time with the <code>DataAnalysisEndTime</code> parameter.
             *                              <p>
             *                              If you set <code>ScheduleExpression</code> to <code>NOW</code> , this parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataAnalysisStartTime(java.lang.String dataAnalysisStartTime) {
                this.dataAnalysisStartTime = dataAnalysisStartTime;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ScheduleConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ScheduleConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ScheduleConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScheduleConfigProperty {
            private final java.lang.String scheduleExpression;
            private final java.lang.String dataAnalysisEndTime;
            private final java.lang.String dataAnalysisStartTime;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.scheduleExpression = software.amazon.jsii.Kernel.get(this, "scheduleExpression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dataAnalysisEndTime = software.amazon.jsii.Kernel.get(this, "dataAnalysisEndTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dataAnalysisStartTime = software.amazon.jsii.Kernel.get(this, "dataAnalysisStartTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.scheduleExpression = java.util.Objects.requireNonNull(builder.scheduleExpression, "scheduleExpression is required");
                this.dataAnalysisEndTime = builder.dataAnalysisEndTime;
                this.dataAnalysisStartTime = builder.dataAnalysisStartTime;
            }

            @Override
            public final java.lang.String getScheduleExpression() {
                return this.scheduleExpression;
            }

            @Override
            public final java.lang.String getDataAnalysisEndTime() {
                return this.dataAnalysisEndTime;
            }

            @Override
            public final java.lang.String getDataAnalysisStartTime() {
                return this.dataAnalysisStartTime;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("scheduleExpression", om.valueToTree(this.getScheduleExpression()));
                if (this.getDataAnalysisEndTime() != null) {
                    data.set("dataAnalysisEndTime", om.valueToTree(this.getDataAnalysisEndTime()));
                }
                if (this.getDataAnalysisStartTime() != null) {
                    data.set("dataAnalysisStartTime", om.valueToTree(this.getDataAnalysisStartTime()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnMonitoringSchedule.ScheduleConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ScheduleConfigProperty.Jsii$Proxy that = (ScheduleConfigProperty.Jsii$Proxy) o;

                if (!scheduleExpression.equals(that.scheduleExpression)) return false;
                if (this.dataAnalysisEndTime != null ? !this.dataAnalysisEndTime.equals(that.dataAnalysisEndTime) : that.dataAnalysisEndTime != null) return false;
                return this.dataAnalysisStartTime != null ? this.dataAnalysisStartTime.equals(that.dataAnalysisStartTime) : that.dataAnalysisStartTime == null;
            }

            @Override
            public final int hashCode() {
                int result = this.scheduleExpression.hashCode();
                result = 31 * result + (this.dataAnalysisEndTime != null ? this.dataAnalysisEndTime.hashCode() : 0);
                result = 31 * result + (this.dataAnalysisStartTime != null ? this.dataAnalysisStartTime.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The baseline statistics file in Amazon S3 that the current monitoring job should be validated against.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * StatisticsResourceProperty statisticsResourceProperty = StatisticsResourceProperty.builder()
     *         .s3Uri("s3Uri")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-statisticsresource.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-statisticsresource.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnMonitoringSchedule.StatisticsResourceProperty")
    @software.amazon.jsii.Jsii.Proxy(StatisticsResourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StatisticsResourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The S3 URI for the statistics resource.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-statisticsresource.html#cfn-sagemaker-monitoringschedule-statisticsresource-s3uri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-statisticsresource.html#cfn-sagemaker-monitoringschedule-statisticsresource-s3uri</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3Uri() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link StatisticsResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StatisticsResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StatisticsResourceProperty> {
            java.lang.String s3Uri;

            /**
             * Sets the value of {@link StatisticsResourceProperty#getS3Uri}
             * @param s3Uri The S3 URI for the statistics resource.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Uri(java.lang.String s3Uri) {
                this.s3Uri = s3Uri;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StatisticsResourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StatisticsResourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StatisticsResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StatisticsResourceProperty {
            private final java.lang.String s3Uri;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.s3Uri = software.amazon.jsii.Kernel.get(this, "s3Uri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.s3Uri = builder.s3Uri;
            }

            @Override
            public final java.lang.String getS3Uri() {
                return this.s3Uri;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getS3Uri() != null) {
                    data.set("s3Uri", om.valueToTree(this.getS3Uri()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnMonitoringSchedule.StatisticsResourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StatisticsResourceProperty.Jsii$Proxy that = (StatisticsResourceProperty.Jsii$Proxy) o;

                return this.s3Uri != null ? this.s3Uri.equals(that.s3Uri) : that.s3Uri == null;
            }

            @Override
            public final int hashCode() {
                int result = this.s3Uri != null ? this.s3Uri.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Specifies a limit to how long a job can run.
     * <p>
     * When the job reaches the time limit, SageMaker ends the job. Use this API to cap costs.
     * <p>
     * To stop a training job, SageMaker sends the algorithm the <code>SIGTERM</code> signal, which delays job termination for 120 seconds. Algorithms can use this 120-second window to save the model artifacts, so the results of training are not lost.
     * <p>
     * The training algorithms provided by SageMaker automatically save the intermediate results of a model training job when possible. This attempt to save artifacts is only a best effort case as model might not be in a state from which it can be saved. For example, if training has just started, the model might not be ready to save. When saved, this intermediate data is a valid model artifact. You can use it to create a model with <code>CreateModel</code> .
     * <p>
     * <blockquote>
     * <p>
     * The Neural Topic Model (NTM) currently does not support saving intermediate model artifacts. When training NTMs, make sure that the maximum runtime is sufficient for the training job to complete.
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * StoppingConditionProperty stoppingConditionProperty = StoppingConditionProperty.builder()
     *         .maxRuntimeInSeconds(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-stoppingcondition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-stoppingcondition.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnMonitoringSchedule.StoppingConditionProperty")
    @software.amazon.jsii.Jsii.Proxy(StoppingConditionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StoppingConditionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum length of time, in seconds, that a training or compilation job can run before it is stopped.
         * <p>
         * For compilation jobs, if the job does not complete during this time, a <code>TimeOut</code> error is generated. We recommend starting with 900 seconds and increasing as necessary based on your model.
         * <p>
         * For all other jobs, if the job does not complete during this time, SageMaker ends the job. When <code>RetryStrategy</code> is specified in the job request, <code>MaxRuntimeInSeconds</code> specifies the maximum time for all of the attempts in total, not each individual attempt. The default value is 1 day. The maximum value is 28 days.
         * <p>
         * The maximum time that a <code>TrainingJob</code> can run in total, including any time spent publishing metrics or archiving and uploading models after it has been stopped, is 30 days.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-stoppingcondition.html#cfn-sagemaker-monitoringschedule-stoppingcondition-maxruntimeinseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-stoppingcondition.html#cfn-sagemaker-monitoringschedule-stoppingcondition-maxruntimeinseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMaxRuntimeInSeconds();

        /**
         * @return a {@link Builder} of {@link StoppingConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StoppingConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StoppingConditionProperty> {
            java.lang.Number maxRuntimeInSeconds;

            /**
             * Sets the value of {@link StoppingConditionProperty#getMaxRuntimeInSeconds}
             * @param maxRuntimeInSeconds The maximum length of time, in seconds, that a training or compilation job can run before it is stopped. This parameter is required.
             *                            For compilation jobs, if the job does not complete during this time, a <code>TimeOut</code> error is generated. We recommend starting with 900 seconds and increasing as necessary based on your model.
             *                            <p>
             *                            For all other jobs, if the job does not complete during this time, SageMaker ends the job. When <code>RetryStrategy</code> is specified in the job request, <code>MaxRuntimeInSeconds</code> specifies the maximum time for all of the attempts in total, not each individual attempt. The default value is 1 day. The maximum value is 28 days.
             *                            <p>
             *                            The maximum time that a <code>TrainingJob</code> can run in total, including any time spent publishing metrics or archiving and uploading models after it has been stopped, is 30 days.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxRuntimeInSeconds(java.lang.Number maxRuntimeInSeconds) {
                this.maxRuntimeInSeconds = maxRuntimeInSeconds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StoppingConditionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StoppingConditionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StoppingConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StoppingConditionProperty {
            private final java.lang.Number maxRuntimeInSeconds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maxRuntimeInSeconds = software.amazon.jsii.Kernel.get(this, "maxRuntimeInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maxRuntimeInSeconds = java.util.Objects.requireNonNull(builder.maxRuntimeInSeconds, "maxRuntimeInSeconds is required");
            }

            @Override
            public final java.lang.Number getMaxRuntimeInSeconds() {
                return this.maxRuntimeInSeconds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("maxRuntimeInSeconds", om.valueToTree(this.getMaxRuntimeInSeconds()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnMonitoringSchedule.StoppingConditionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StoppingConditionProperty.Jsii$Proxy that = (StoppingConditionProperty.Jsii$Proxy) o;

                return this.maxRuntimeInSeconds.equals(that.maxRuntimeInSeconds);
            }

            @Override
            public final int hashCode() {
                int result = this.maxRuntimeInSeconds.hashCode();
                return result;
            }
        }
    }
    /**
     * Specifies an Amazon Virtual Private Cloud (VPC) that your SageMaker jobs, hosted models, and compute resources have access to.
     * <p>
     * You can control access to and from your resources by configuring a VPC. For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/infrastructure-give-access.html">Give SageMaker Access to Resources in your Amazon VPC</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * VpcConfigProperty vpcConfigProperty = VpcConfigProperty.builder()
     *         .securityGroupIds(List.of("securityGroupIds"))
     *         .subnets(List.of("subnets"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-vpcconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-vpcconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnMonitoringSchedule.VpcConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(VpcConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VpcConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The VPC security group IDs, in the form <code>sg-xxxxxxxx</code> .
         * <p>
         * Specify the security groups for the VPC that is specified in the <code>Subnets</code> field.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-vpcconfig.html#cfn-sagemaker-monitoringschedule-vpcconfig-securitygroupids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-vpcconfig.html#cfn-sagemaker-monitoringschedule-vpcconfig-securitygroupids</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSecurityGroupIds();

        /**
         * The ID of the subnets in the VPC to which you want to connect your training job or model.
         * <p>
         * For information about the availability of specific instance types, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/instance-types-az.html">Supported Instance Types and Availability Zones</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-vpcconfig.html#cfn-sagemaker-monitoringschedule-vpcconfig-subnets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-monitoringschedule-vpcconfig.html#cfn-sagemaker-monitoringschedule-vpcconfig-subnets</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSubnets();

        /**
         * @return a {@link Builder} of {@link VpcConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VpcConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VpcConfigProperty> {
            java.util.List<java.lang.String> securityGroupIds;
            java.util.List<java.lang.String> subnets;

            /**
             * Sets the value of {@link VpcConfigProperty#getSecurityGroupIds}
             * @param securityGroupIds The VPC security group IDs, in the form <code>sg-xxxxxxxx</code> . This parameter is required.
             *                         Specify the security groups for the VPC that is specified in the <code>Subnets</code> field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityGroupIds(java.util.List<java.lang.String> securityGroupIds) {
                this.securityGroupIds = securityGroupIds;
                return this;
            }

            /**
             * Sets the value of {@link VpcConfigProperty#getSubnets}
             * @param subnets The ID of the subnets in the VPC to which you want to connect your training job or model. This parameter is required.
             *                For information about the availability of specific instance types, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/instance-types-az.html">Supported Instance Types and Availability Zones</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subnets(java.util.List<java.lang.String> subnets) {
                this.subnets = subnets;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VpcConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VpcConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VpcConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VpcConfigProperty {
            private final java.util.List<java.lang.String> securityGroupIds;
            private final java.util.List<java.lang.String> subnets;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.securityGroupIds = software.amazon.jsii.Kernel.get(this, "securityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.subnets = software.amazon.jsii.Kernel.get(this, "subnets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.securityGroupIds = java.util.Objects.requireNonNull(builder.securityGroupIds, "securityGroupIds is required");
                this.subnets = java.util.Objects.requireNonNull(builder.subnets, "subnets is required");
            }

            @Override
            public final java.util.List<java.lang.String> getSecurityGroupIds() {
                return this.securityGroupIds;
            }

            @Override
            public final java.util.List<java.lang.String> getSubnets() {
                return this.subnets;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("securityGroupIds", om.valueToTree(this.getSecurityGroupIds()));
                data.set("subnets", om.valueToTree(this.getSubnets()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnMonitoringSchedule.VpcConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VpcConfigProperty.Jsii$Proxy that = (VpcConfigProperty.Jsii$Proxy) o;

                if (!securityGroupIds.equals(that.securityGroupIds)) return false;
                return this.subnets.equals(that.subnets);
            }

            @Override
            public final int hashCode() {
                int result = this.securityGroupIds.hashCode();
                result = 31 * result + (this.subnets.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.sagemaker.CfnMonitoringSchedule}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.sagemaker.CfnMonitoringSchedule> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.sagemaker.CfnMonitoringScheduleProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.sagemaker.CfnMonitoringScheduleProps.Builder();
        }

        /**
         * The configuration object that specifies the monitoring schedule and defines the monitoring job.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-monitoringscheduleconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-monitoringscheduleconfig</a>
         * @param monitoringScheduleConfig The configuration object that specifies the monitoring schedule and defines the monitoring job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder monitoringScheduleConfig(final software.amazon.awscdk.IResolvable monitoringScheduleConfig) {
            this.props.monitoringScheduleConfig(monitoringScheduleConfig);
            return this;
        }
        /**
         * The configuration object that specifies the monitoring schedule and defines the monitoring job.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-monitoringscheduleconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-monitoringscheduleconfig</a>
         * @param monitoringScheduleConfig The configuration object that specifies the monitoring schedule and defines the monitoring job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder monitoringScheduleConfig(final software.amazon.awscdk.services.sagemaker.CfnMonitoringSchedule.MonitoringScheduleConfigProperty monitoringScheduleConfig) {
            this.props.monitoringScheduleConfig(monitoringScheduleConfig);
            return this;
        }

        /**
         * The name of the monitoring schedule.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-monitoringschedulename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-monitoringschedulename</a>
         * @param monitoringScheduleName The name of the monitoring schedule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder monitoringScheduleName(final java.lang.String monitoringScheduleName) {
            this.props.monitoringScheduleName(monitoringScheduleName);
            return this;
        }

        /**
         * The name of the endpoint using the monitoring schedule.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-endpointname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-endpointname</a>
         * @param endpointName The name of the endpoint using the monitoring schedule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointName(final java.lang.String endpointName) {
            this.props.endpointName(endpointName);
            return this;
        }

        /**
         * Contains the reason a monitoring job failed, if it failed.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-failurereason">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-failurereason</a>
         * @param failureReason Contains the reason a monitoring job failed, if it failed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder failureReason(final java.lang.String failureReason) {
            this.props.failureReason(failureReason);
            return this;
        }

        /**
         * Describes metadata on the last execution to run, if there was one.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-lastmonitoringexecutionsummary">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-lastmonitoringexecutionsummary</a>
         * @param lastMonitoringExecutionSummary Describes metadata on the last execution to run, if there was one. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lastMonitoringExecutionSummary(final software.amazon.awscdk.IResolvable lastMonitoringExecutionSummary) {
            this.props.lastMonitoringExecutionSummary(lastMonitoringExecutionSummary);
            return this;
        }
        /**
         * Describes metadata on the last execution to run, if there was one.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-lastmonitoringexecutionsummary">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-lastmonitoringexecutionsummary</a>
         * @param lastMonitoringExecutionSummary Describes metadata on the last execution to run, if there was one. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lastMonitoringExecutionSummary(final software.amazon.awscdk.services.sagemaker.CfnMonitoringSchedule.MonitoringExecutionSummaryProperty lastMonitoringExecutionSummary) {
            this.props.lastMonitoringExecutionSummary(lastMonitoringExecutionSummary);
            return this;
        }

        /**
         * The status of the monitoring schedule.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-monitoringschedulestatus">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-monitoringschedulestatus</a>
         * @param monitoringScheduleStatus The status of the monitoring schedule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder monitoringScheduleStatus(final java.lang.String monitoringScheduleStatus) {
            this.props.monitoringScheduleStatus(monitoringScheduleStatus);
            return this;
        }

        /**
         * An array of key-value pairs to apply to this resource.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-monitoringschedule.html#cfn-sagemaker-monitoringschedule-tags</a>
         * @param tags An array of key-value pairs to apply to this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.sagemaker.CfnMonitoringSchedule}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.sagemaker.CfnMonitoringSchedule build() {
            return new software.amazon.awscdk.services.sagemaker.CfnMonitoringSchedule(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
