package software.amazon.awscdk.services.s3.assets;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.*;
 * Asset asset = Asset.Builder.create(this, "BundledAsset")
 *         .path("/path/to/asset")
 *         .bundling(BundlingOptions.builder()
 *                 .image(DockerImage.fromRegistry("alpine"))
 *                 .command(List.of("command-that-produces-an-archive.sh"))
 *                 .outputType(BundlingOutput.NOT_ARCHIVED)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:19.991Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3_assets.AssetProps")
@software.amazon.jsii.Jsii.Proxy(AssetProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AssetProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.s3.assets.AssetOptions {

    /**
     * The disk location of the asset.
     * <p>
     * The path should refer to one of the following:
     * <p>
     * <ul>
     * <li>A regular file or a .zip file, in which case the file will be uploaded as-is to S3.</li>
     * <li>A directory, in which case it will be archived into a .zip file and uploaded to S3.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPath();

    /**
     * @return a {@link Builder} of {@link AssetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AssetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AssetProps> {
        java.lang.String path;
        java.lang.Boolean deployTime;
        java.lang.String displayName;
        java.util.List<software.amazon.awscdk.services.iam.IGrantable> readers;
        software.amazon.awscdk.services.kms.IKey sourceKmsKey;
        java.lang.String assetHash;
        software.amazon.awscdk.AssetHashType assetHashType;
        software.amazon.awscdk.BundlingOptions bundling;
        java.util.List<java.lang.String> exclude;
        software.amazon.awscdk.SymlinkFollowMode followSymlinks;
        software.amazon.awscdk.IgnoreMode ignoreMode;

        /**
         * Sets the value of {@link AssetProps#getPath}
         * @param path The disk location of the asset. This parameter is required.
         *             The path should refer to one of the following:
         *             <p>
         *             <ul>
         *             <li>A regular file or a .zip file, in which case the file will be uploaded as-is to S3.</li>
         *             <li>A directory, in which case it will be archived into a .zip file and uploaded to S3.</li>
         *             </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder path(java.lang.String path) {
            this.path = path;
            return this;
        }

        /**
         * Sets the value of {@link AssetProps#getDeployTime}
         * @param deployTime Whether or not the asset needs to exist beyond deployment time;.
         *                   i.e.
         *                   are copied over to a different location and not needed afterwards.
         *                   Setting this property to true has an impact on the lifecycle of the asset,
         *                   because we will assume that it is safe to delete after the CloudFormation
         *                   deployment succeeds.
         *                   <p>
         *                   For example, Lambda Function assets are copied over to Lambda during
         *                   deployment. Therefore, it is not necessary to store the asset in S3, so
         *                   we consider those deployTime assets.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deployTime(java.lang.Boolean deployTime) {
            this.deployTime = deployTime;
            return this;
        }

        /**
         * Sets the value of {@link AssetProps#getDisplayName}
         * @param displayName A display name for this asset.
         *                    If supplied, the display name will be used in locations where the asset
         *                    identifier is printed, like in the CLI progress information. If the same
         *                    asset is added multiple times, the display name of the first occurrence is
         *                    used.
         *                    <p>
         *                    The default is the construct path of the Asset construct, with respect to
         *                    the enclosing stack. If the asset is produced by a construct helper
         *                    function (such as <code>lambda.Code.fromAsset()</code>), this will look like
         *                    <code>MyFunction/Code</code>.
         *                    <p>
         *                    We use the stack-relative construct path so that in the common case where
         *                    you have multiple stacks with the same asset, we won't show something like
         *                    <code>/MyBetaStack/MyFunction/Code</code> when you are actually deploying to
         *                    production.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder displayName(java.lang.String displayName) {
            this.displayName = displayName;
            return this;
        }

        /**
         * Sets the value of {@link AssetProps#getReaders}
         * @param readers A list of principals that should be able to read this asset from S3.
         *                You can use <code>asset.grantRead(principal)</code> to grant read permissions later.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder readers(java.util.List<? extends software.amazon.awscdk.services.iam.IGrantable> readers) {
            this.readers = (java.util.List<software.amazon.awscdk.services.iam.IGrantable>)readers;
            return this;
        }

        /**
         * Sets the value of {@link AssetProps#getSourceKmsKey}
         * @param sourceKmsKey The ARN of the KMS key used to encrypt the handler code.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceKmsKey(software.amazon.awscdk.services.kms.IKey sourceKmsKey) {
            this.sourceKmsKey = sourceKmsKey;
            return this;
        }

        /**
         * Sets the value of {@link AssetProps#getAssetHash}
         * @param assetHash Specify a custom hash for this asset.
         *                  If <code>assetHashType</code> is set it must
         *                  be set to <code>AssetHashType.CUSTOM</code>. For consistency, this custom hash will
         *                  be SHA256 hashed and encoded as hex. The resulting hash will be the asset
         *                  hash.
         *                  <p>
         *                  NOTE: the hash is used in order to identify a specific revision of the asset, and
         *                  used for optimizing and caching deployment activities related to this asset such as
         *                  packaging, uploading to Amazon S3, etc. If you chose to customize the hash, you will
         *                  need to make sure it is updated every time the asset changes, or otherwise it is
         *                  possible that some deployments will not be invalidated.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetHash(java.lang.String assetHash) {
            this.assetHash = assetHash;
            return this;
        }

        /**
         * Sets the value of {@link AssetProps#getAssetHashType}
         * @param assetHashType Specifies the type of hash to calculate for this asset.
         *                      If <code>assetHash</code> is configured, this option must be <code>undefined</code> or
         *                      <code>AssetHashType.CUSTOM</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetHashType(software.amazon.awscdk.AssetHashType assetHashType) {
            this.assetHashType = assetHashType;
            return this;
        }

        /**
         * Sets the value of {@link AssetProps#getBundling}
         * @param bundling Bundle the asset by executing a command in a Docker container or a custom bundling provider.
         *                 The asset path will be mounted at <code>/asset-input</code>. The Docker
         *                 container is responsible for putting content at <code>/asset-output</code>.
         *                 The content at <code>/asset-output</code> will be zipped and used as the
         *                 final asset.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bundling(software.amazon.awscdk.BundlingOptions bundling) {
            this.bundling = bundling;
            return this;
        }

        /**
         * Sets the value of {@link AssetProps#getExclude}
         * @param exclude File paths matching the patterns will be excluded.
         *                See <code>ignoreMode</code> to set the matching behavior.
         *                Has no effect on Assets bundled using the <code>bundling</code> property.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder exclude(java.util.List<java.lang.String> exclude) {
            this.exclude = exclude;
            return this;
        }

        /**
         * Sets the value of {@link AssetProps#getFollowSymlinks}
         * @param followSymlinks A strategy for how to handle symlinks.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder followSymlinks(software.amazon.awscdk.SymlinkFollowMode followSymlinks) {
            this.followSymlinks = followSymlinks;
            return this;
        }

        /**
         * Sets the value of {@link AssetProps#getIgnoreMode}
         * @param ignoreMode The ignore behavior to use for <code>exclude</code> patterns.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ignoreMode(software.amazon.awscdk.IgnoreMode ignoreMode) {
            this.ignoreMode = ignoreMode;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AssetProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AssetProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AssetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AssetProps {
        private final java.lang.String path;
        private final java.lang.Boolean deployTime;
        private final java.lang.String displayName;
        private final java.util.List<software.amazon.awscdk.services.iam.IGrantable> readers;
        private final software.amazon.awscdk.services.kms.IKey sourceKmsKey;
        private final java.lang.String assetHash;
        private final software.amazon.awscdk.AssetHashType assetHashType;
        private final software.amazon.awscdk.BundlingOptions bundling;
        private final java.util.List<java.lang.String> exclude;
        private final software.amazon.awscdk.SymlinkFollowMode followSymlinks;
        private final software.amazon.awscdk.IgnoreMode ignoreMode;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.path = software.amazon.jsii.Kernel.get(this, "path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.deployTime = software.amazon.jsii.Kernel.get(this, "deployTime", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.displayName = software.amazon.jsii.Kernel.get(this, "displayName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.readers = software.amazon.jsii.Kernel.get(this, "readers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IGrantable.class)));
            this.sourceKmsKey = software.amazon.jsii.Kernel.get(this, "sourceKMSKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
            this.assetHash = software.amazon.jsii.Kernel.get(this, "assetHash", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.assetHashType = software.amazon.jsii.Kernel.get(this, "assetHashType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.AssetHashType.class));
            this.bundling = software.amazon.jsii.Kernel.get(this, "bundling", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.BundlingOptions.class));
            this.exclude = software.amazon.jsii.Kernel.get(this, "exclude", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.followSymlinks = software.amazon.jsii.Kernel.get(this, "followSymlinks", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.SymlinkFollowMode.class));
            this.ignoreMode = software.amazon.jsii.Kernel.get(this, "ignoreMode", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IgnoreMode.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.path = java.util.Objects.requireNonNull(builder.path, "path is required");
            this.deployTime = builder.deployTime;
            this.displayName = builder.displayName;
            this.readers = (java.util.List<software.amazon.awscdk.services.iam.IGrantable>)builder.readers;
            this.sourceKmsKey = builder.sourceKmsKey;
            this.assetHash = builder.assetHash;
            this.assetHashType = builder.assetHashType;
            this.bundling = builder.bundling;
            this.exclude = builder.exclude;
            this.followSymlinks = builder.followSymlinks;
            this.ignoreMode = builder.ignoreMode;
        }

        @Override
        public final java.lang.String getPath() {
            return this.path;
        }

        @Override
        public final java.lang.Boolean getDeployTime() {
            return this.deployTime;
        }

        @Override
        public final java.lang.String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.iam.IGrantable> getReaders() {
            return this.readers;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getSourceKMSKey() {
            return this.sourceKmsKey;
        }

        @Override
        public final java.lang.String getAssetHash() {
            return this.assetHash;
        }

        @Override
        public final software.amazon.awscdk.AssetHashType getAssetHashType() {
            return this.assetHashType;
        }

        @Override
        public final software.amazon.awscdk.BundlingOptions getBundling() {
            return this.bundling;
        }

        @Override
        public final java.util.List<java.lang.String> getExclude() {
            return this.exclude;
        }

        @Override
        public final software.amazon.awscdk.SymlinkFollowMode getFollowSymlinks() {
            return this.followSymlinks;
        }

        @Override
        public final software.amazon.awscdk.IgnoreMode getIgnoreMode() {
            return this.ignoreMode;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("path", om.valueToTree(this.getPath()));
            if (this.getDeployTime() != null) {
                data.set("deployTime", om.valueToTree(this.getDeployTime()));
            }
            if (this.getDisplayName() != null) {
                data.set("displayName", om.valueToTree(this.getDisplayName()));
            }
            if (this.getReaders() != null) {
                data.set("readers", om.valueToTree(this.getReaders()));
            }
            if (this.getSourceKMSKey() != null) {
                data.set("sourceKMSKey", om.valueToTree(this.getSourceKMSKey()));
            }
            if (this.getAssetHash() != null) {
                data.set("assetHash", om.valueToTree(this.getAssetHash()));
            }
            if (this.getAssetHashType() != null) {
                data.set("assetHashType", om.valueToTree(this.getAssetHashType()));
            }
            if (this.getBundling() != null) {
                data.set("bundling", om.valueToTree(this.getBundling()));
            }
            if (this.getExclude() != null) {
                data.set("exclude", om.valueToTree(this.getExclude()));
            }
            if (this.getFollowSymlinks() != null) {
                data.set("followSymlinks", om.valueToTree(this.getFollowSymlinks()));
            }
            if (this.getIgnoreMode() != null) {
                data.set("ignoreMode", om.valueToTree(this.getIgnoreMode()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_s3_assets.AssetProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AssetProps.Jsii$Proxy that = (AssetProps.Jsii$Proxy) o;

            if (!path.equals(that.path)) return false;
            if (this.deployTime != null ? !this.deployTime.equals(that.deployTime) : that.deployTime != null) return false;
            if (this.displayName != null ? !this.displayName.equals(that.displayName) : that.displayName != null) return false;
            if (this.readers != null ? !this.readers.equals(that.readers) : that.readers != null) return false;
            if (this.sourceKmsKey != null ? !this.sourceKmsKey.equals(that.sourceKmsKey) : that.sourceKmsKey != null) return false;
            if (this.assetHash != null ? !this.assetHash.equals(that.assetHash) : that.assetHash != null) return false;
            if (this.assetHashType != null ? !this.assetHashType.equals(that.assetHashType) : that.assetHashType != null) return false;
            if (this.bundling != null ? !this.bundling.equals(that.bundling) : that.bundling != null) return false;
            if (this.exclude != null ? !this.exclude.equals(that.exclude) : that.exclude != null) return false;
            if (this.followSymlinks != null ? !this.followSymlinks.equals(that.followSymlinks) : that.followSymlinks != null) return false;
            return this.ignoreMode != null ? this.ignoreMode.equals(that.ignoreMode) : that.ignoreMode == null;
        }

        @Override
        public final int hashCode() {
            int result = this.path.hashCode();
            result = 31 * result + (this.deployTime != null ? this.deployTime.hashCode() : 0);
            result = 31 * result + (this.displayName != null ? this.displayName.hashCode() : 0);
            result = 31 * result + (this.readers != null ? this.readers.hashCode() : 0);
            result = 31 * result + (this.sourceKmsKey != null ? this.sourceKmsKey.hashCode() : 0);
            result = 31 * result + (this.assetHash != null ? this.assetHash.hashCode() : 0);
            result = 31 * result + (this.assetHashType != null ? this.assetHashType.hashCode() : 0);
            result = 31 * result + (this.bundling != null ? this.bundling.hashCode() : 0);
            result = 31 * result + (this.exclude != null ? this.exclude.hashCode() : 0);
            result = 31 * result + (this.followSymlinks != null ? this.followSymlinks.hashCode() : 0);
            result = 31 * result + (this.ignoreMode != null ? this.ignoreMode.hashCode() : 0);
            return result;
        }
    }
}
