package software.amazon.awscdk.services.resiliencehub;

/**
 * Creates an AWS Resilience Hub application.
 * <p>
 * An AWS Resilience Hub application is a collection of AWS resources structured to prevent and recover AWS application disruptions. To describe a AWS Resilience Hub application, you provide an application name, resources from one or more AWS CloudFormation stacks, AWS Resource Groups , Terraform state files, AppRegistry applications, and an appropriate resiliency policy. In addition, you can also add resources that are located on Amazon Elastic Kubernetes Service (Amazon EKS) clusters as optional resources. For more information about the number of resources supported per application, see <a href="https://docs.aws.amazon.com/general/latest/gr/resiliencehub.html#limits_resiliencehub">Service quotas</a> .
 * <p>
 * After you create an AWS Resilience Hub application, you publish it so that you can run a resiliency assessment on it. You can then use recommendations from the assessment to improve resiliency by running another assessment, comparing results, and then iterating the process until you achieve your goals for recovery time objective (RTO) and recovery point objective (RPO).
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.resiliencehub.*;
 * CfnApp cfnApp = CfnApp.Builder.create(this, "MyCfnApp")
 *         .appTemplateBody("appTemplateBody")
 *         .name("name")
 *         .resourceMappings(List.of(ResourceMappingProperty.builder()
 *                 .mappingType("mappingType")
 *                 .physicalResourceId(PhysicalResourceIdProperty.builder()
 *                         .identifier("identifier")
 *                         .type("type")
 *                         // the properties below are optional
 *                         .awsAccountId("awsAccountId")
 *                         .awsRegion("awsRegion")
 *                         .build())
 *                 // the properties below are optional
 *                 .eksSourceName("eksSourceName")
 *                 .logicalStackName("logicalStackName")
 *                 .resourceName("resourceName")
 *                 .terraformSourceName("terraformSourceName")
 *                 .build()))
 *         // the properties below are optional
 *         .appAssessmentSchedule("appAssessmentSchedule")
 *         .description("description")
 *         .eventSubscriptions(List.of(EventSubscriptionProperty.builder()
 *                 .eventType("eventType")
 *                 .name("name")
 *                 // the properties below are optional
 *                 .snsTopicArn("snsTopicArn")
 *                 .build()))
 *         .permissionModel(PermissionModelProperty.builder()
 *                 .type("type")
 *                 // the properties below are optional
 *                 .crossAccountRoleArns(List.of("crossAccountRoleArns"))
 *                 .invokerRoleName("invokerRoleName")
 *                 .build())
 *         .resiliencyPolicyArn("resiliencyPolicyArn")
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:19.533Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_resiliencehub.CfnApp")
public class CfnApp extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnApp(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnApp(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.resiliencehub.CfnApp.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnApp(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.resiliencehub.CfnAppProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the applcation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrAppArn() {
        return software.amazon.jsii.Kernel.get(this, "attrAppArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Indicates if compliance drifts (deviations) were detected while running an assessment for your application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDriftStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrDriftStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * A JSON string that provides information about your application structure.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAppTemplateBody() {
        return software.amazon.jsii.Kernel.get(this, "appTemplateBody", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A JSON string that provides information about your application structure.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAppTemplateBody(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "appTemplateBody", java.util.Objects.requireNonNull(value, "appTemplateBody is required"));
    }

    /**
     * Name for the application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Name for the application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * An array of <code>ResourceMapping</code> objects.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getResourceMappings() {
        return software.amazon.jsii.Kernel.get(this, "resourceMappings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An array of <code>ResourceMapping</code> objects.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResourceMappings(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "resourceMappings", java.util.Objects.requireNonNull(value, "resourceMappings is required"));
    }

    /**
     * An array of <code>ResourceMapping</code> objects.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResourceMappings(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.resiliencehub.CfnApp.ResourceMappingProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.resiliencehub.CfnApp.ResourceMappingProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "resourceMappings", java.util.Objects.requireNonNull(value, "resourceMappings is required"));
    }

    /**
     * Assessment execution schedule with 'Daily' or 'Disabled' values.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAppAssessmentSchedule() {
        return software.amazon.jsii.Kernel.get(this, "appAssessmentSchedule", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Assessment execution schedule with 'Daily' or 'Disabled' values.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAppAssessmentSchedule(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "appAssessmentSchedule", value);
    }

    /**
     * Optional description for an application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Optional description for an application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * The list of events you would like to subscribe and get notification for.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEventSubscriptions() {
        return software.amazon.jsii.Kernel.get(this, "eventSubscriptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The list of events you would like to subscribe and get notification for.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEventSubscriptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "eventSubscriptions", value);
    }

    /**
     * The list of events you would like to subscribe and get notification for.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEventSubscriptions(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.resiliencehub.CfnApp.EventSubscriptionProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.resiliencehub.CfnApp.EventSubscriptionProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "eventSubscriptions", value);
    }

    /**
     * Defines the roles and credentials that AWS Resilience Hub would use while creating the application, importing its resources, and running an assessment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPermissionModel() {
        return software.amazon.jsii.Kernel.get(this, "permissionModel", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Defines the roles and credentials that AWS Resilience Hub would use while creating the application, importing its resources, and running an assessment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPermissionModel(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "permissionModel", value);
    }

    /**
     * Defines the roles and credentials that AWS Resilience Hub would use while creating the application, importing its resources, and running an assessment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPermissionModel(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.resiliencehub.CfnApp.PermissionModelProperty value) {
        software.amazon.jsii.Kernel.set(this, "permissionModel", value);
    }

    /**
     * The Amazon Resource Name (ARN) of the resiliency policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getResiliencyPolicyArn() {
        return software.amazon.jsii.Kernel.get(this, "resiliencyPolicyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the resiliency policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResiliencyPolicyArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "resiliencyPolicyArn", value);
    }

    /**
     * Tags assigned to the resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.Map<java.lang.String, java.lang.String>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableMap).orElse(null);
    }

    /**
     * Tags assigned to the resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * Indicates an event you would like to subscribe and get notification for.
     * <p>
     * Currently, AWS Resilience Hub supports notifications only for <em>Drift detected</em> and <em>Scheduled assessment failure</em> events.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.resiliencehub.*;
     * EventSubscriptionProperty eventSubscriptionProperty = EventSubscriptionProperty.builder()
     *         .eventType("eventType")
     *         .name("name")
     *         // the properties below are optional
     *         .snsTopicArn("snsTopicArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resiliencehub-app-eventsubscription.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resiliencehub-app-eventsubscription.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_resiliencehub.CfnApp.EventSubscriptionProperty")
    @software.amazon.jsii.Jsii.Proxy(EventSubscriptionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EventSubscriptionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of event you would like to subscribe and get notification for.
         * <p>
         * Currently, AWS Resilience Hub supports notifications only for <em>Drift detected</em> ( <code>DriftDetected</code> ) and <em>Scheduled assessment failure</em> ( <code>ScheduledAssessmentFailure</code> ) events.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resiliencehub-app-eventsubscription.html#cfn-resiliencehub-app-eventsubscription-eventtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resiliencehub-app-eventsubscription.html#cfn-resiliencehub-app-eventsubscription-eventtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEventType();

        /**
         * Unique name to identify an event subscription.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resiliencehub-app-eventsubscription.html#cfn-resiliencehub-app-eventsubscription-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resiliencehub-app-eventsubscription.html#cfn-resiliencehub-app-eventsubscription-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * Amazon Resource Name (ARN) of the Amazon Simple Notification Service topic.
         * <p>
         * The format for this ARN is: <code>arn:partition:sns:region:account:topic-name</code> . For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <em>AWS General Reference</em> guide.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resiliencehub-app-eventsubscription.html#cfn-resiliencehub-app-eventsubscription-snstopicarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resiliencehub-app-eventsubscription.html#cfn-resiliencehub-app-eventsubscription-snstopicarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSnsTopicArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EventSubscriptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EventSubscriptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EventSubscriptionProperty> {
            java.lang.String eventType;
            java.lang.String name;
            java.lang.String snsTopicArn;

            /**
             * Sets the value of {@link EventSubscriptionProperty#getEventType}
             * @param eventType The type of event you would like to subscribe and get notification for. This parameter is required.
             *                  Currently, AWS Resilience Hub supports notifications only for <em>Drift detected</em> ( <code>DriftDetected</code> ) and <em>Scheduled assessment failure</em> ( <code>ScheduledAssessmentFailure</code> ) events.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eventType(java.lang.String eventType) {
                this.eventType = eventType;
                return this;
            }

            /**
             * Sets the value of {@link EventSubscriptionProperty#getName}
             * @param name Unique name to identify an event subscription. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link EventSubscriptionProperty#getSnsTopicArn}
             * @param snsTopicArn Amazon Resource Name (ARN) of the Amazon Simple Notification Service topic.
             *                    The format for this ARN is: <code>arn:partition:sns:region:account:topic-name</code> . For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <em>AWS General Reference</em> guide.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder snsTopicArn(java.lang.String snsTopicArn) {
                this.snsTopicArn = snsTopicArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EventSubscriptionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EventSubscriptionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EventSubscriptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EventSubscriptionProperty {
            private final java.lang.String eventType;
            private final java.lang.String name;
            private final java.lang.String snsTopicArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.eventType = software.amazon.jsii.Kernel.get(this, "eventType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.snsTopicArn = software.amazon.jsii.Kernel.get(this, "snsTopicArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.eventType = java.util.Objects.requireNonNull(builder.eventType, "eventType is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.snsTopicArn = builder.snsTopicArn;
            }

            @Override
            public final java.lang.String getEventType() {
                return this.eventType;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getSnsTopicArn() {
                return this.snsTopicArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("eventType", om.valueToTree(this.getEventType()));
                data.set("name", om.valueToTree(this.getName()));
                if (this.getSnsTopicArn() != null) {
                    data.set("snsTopicArn", om.valueToTree(this.getSnsTopicArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_resiliencehub.CfnApp.EventSubscriptionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EventSubscriptionProperty.Jsii$Proxy that = (EventSubscriptionProperty.Jsii$Proxy) o;

                if (!eventType.equals(that.eventType)) return false;
                if (!name.equals(that.name)) return false;
                return this.snsTopicArn != null ? this.snsTopicArn.equals(that.snsTopicArn) : that.snsTopicArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.eventType.hashCode();
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.snsTopicArn != null ? this.snsTopicArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Defines the roles and credentials that AWS Resilience Hub would use while creating the application, importing its resources, and running an assessment.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.resiliencehub.*;
     * PermissionModelProperty permissionModelProperty = PermissionModelProperty.builder()
     *         .type("type")
     *         // the properties below are optional
     *         .crossAccountRoleArns(List.of("crossAccountRoleArns"))
     *         .invokerRoleName("invokerRoleName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resiliencehub-app-permissionmodel.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resiliencehub-app-permissionmodel.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_resiliencehub.CfnApp.PermissionModelProperty")
    @software.amazon.jsii.Jsii.Proxy(PermissionModelProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PermissionModelProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Defines how AWS Resilience Hub scans your resources.
         * <p>
         * It can scan for the resources by using a pre-existing role in your AWS account, or by using the credentials of the current IAM user.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resiliencehub-app-permissionmodel.html#cfn-resiliencehub-app-permissionmodel-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resiliencehub-app-permissionmodel.html#cfn-resiliencehub-app-permissionmodel-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * Defines a list of role Amazon Resource Names (ARNs) to be used in other accounts.
         * <p>
         * These ARNs are used for querying purposes while importing resources and assessing your application.
         * <p>
         * <blockquote>
         * <p>
         * <ul>
         * <li>These ARNs are required only when your resources are in other accounts and you have different role name in these accounts. Else, the invoker role name will be used in the other accounts.</li>
         * <li>These roles must have a trust policy with <code>iam:AssumeRole</code> permission to the invoker role in the primary account.</li>
         * </ul>
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resiliencehub-app-permissionmodel.html#cfn-resiliencehub-app-permissionmodel-crossaccountrolearns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resiliencehub-app-permissionmodel.html#cfn-resiliencehub-app-permissionmodel-crossaccountrolearns</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCrossAccountRoleArns() {
            return null;
        }

        /**
         * Existing AWS IAM role name in the primary AWS account that will be assumed by AWS Resilience Hub Service Principle to obtain a read-only access to your application resources while running an assessment.
         * <p>
         * If your IAM role includes a path, you must include the path in the <code>invokerRoleName</code> parameter. For example, if your IAM role's ARN is <code>arn:aws:iam:123456789012:role/my-path/role-name</code> , you should pass <code>my-path/role-name</code> .
         * <p>
         * <blockquote>
         * <p>
         * <ul>
         * <li>You must have <code>iam:passRole</code> permission for this role while creating or updating the application.</li>
         * <li>Currently, <code>invokerRoleName</code> accepts only <code>[A-Za-z0-9_+=,.&#64;-]</code> characters.</li>
         * </ul>
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resiliencehub-app-permissionmodel.html#cfn-resiliencehub-app-permissionmodel-invokerrolename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resiliencehub-app-permissionmodel.html#cfn-resiliencehub-app-permissionmodel-invokerrolename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInvokerRoleName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PermissionModelProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PermissionModelProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PermissionModelProperty> {
            java.lang.String type;
            java.util.List<java.lang.String> crossAccountRoleArns;
            java.lang.String invokerRoleName;

            /**
             * Sets the value of {@link PermissionModelProperty#getType}
             * @param type Defines how AWS Resilience Hub scans your resources. This parameter is required.
             *             It can scan for the resources by using a pre-existing role in your AWS account, or by using the credentials of the current IAM user.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link PermissionModelProperty#getCrossAccountRoleArns}
             * @param crossAccountRoleArns Defines a list of role Amazon Resource Names (ARNs) to be used in other accounts.
             *                             These ARNs are used for querying purposes while importing resources and assessing your application.
             *                             <p>
             *                             <blockquote>
             *                             <p>
             *                             <ul>
             *                             <li>These ARNs are required only when your resources are in other accounts and you have different role name in these accounts. Else, the invoker role name will be used in the other accounts.</li>
             *                             <li>These roles must have a trust policy with <code>iam:AssumeRole</code> permission to the invoker role in the primary account.</li>
             *                             </ul>
             *                             <p>
             *                             </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder crossAccountRoleArns(java.util.List<java.lang.String> crossAccountRoleArns) {
                this.crossAccountRoleArns = crossAccountRoleArns;
                return this;
            }

            /**
             * Sets the value of {@link PermissionModelProperty#getInvokerRoleName}
             * @param invokerRoleName Existing AWS IAM role name in the primary AWS account that will be assumed by AWS Resilience Hub Service Principle to obtain a read-only access to your application resources while running an assessment.
             *                        If your IAM role includes a path, you must include the path in the <code>invokerRoleName</code> parameter. For example, if your IAM role's ARN is <code>arn:aws:iam:123456789012:role/my-path/role-name</code> , you should pass <code>my-path/role-name</code> .
             *                        <p>
             *                        <blockquote>
             *                        <p>
             *                        <ul>
             *                        <li>You must have <code>iam:passRole</code> permission for this role while creating or updating the application.</li>
             *                        <li>Currently, <code>invokerRoleName</code> accepts only <code>[A-Za-z0-9_+=,.&#64;-]</code> characters.</li>
             *                        </ul>
             *                        <p>
             *                        </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder invokerRoleName(java.lang.String invokerRoleName) {
                this.invokerRoleName = invokerRoleName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PermissionModelProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PermissionModelProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PermissionModelProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PermissionModelProperty {
            private final java.lang.String type;
            private final java.util.List<java.lang.String> crossAccountRoleArns;
            private final java.lang.String invokerRoleName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.crossAccountRoleArns = software.amazon.jsii.Kernel.get(this, "crossAccountRoleArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.invokerRoleName = software.amazon.jsii.Kernel.get(this, "invokerRoleName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.crossAccountRoleArns = builder.crossAccountRoleArns;
                this.invokerRoleName = builder.invokerRoleName;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.util.List<java.lang.String> getCrossAccountRoleArns() {
                return this.crossAccountRoleArns;
            }

            @Override
            public final java.lang.String getInvokerRoleName() {
                return this.invokerRoleName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                if (this.getCrossAccountRoleArns() != null) {
                    data.set("crossAccountRoleArns", om.valueToTree(this.getCrossAccountRoleArns()));
                }
                if (this.getInvokerRoleName() != null) {
                    data.set("invokerRoleName", om.valueToTree(this.getInvokerRoleName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_resiliencehub.CfnApp.PermissionModelProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PermissionModelProperty.Jsii$Proxy that = (PermissionModelProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                if (this.crossAccountRoleArns != null ? !this.crossAccountRoleArns.equals(that.crossAccountRoleArns) : that.crossAccountRoleArns != null) return false;
                return this.invokerRoleName != null ? this.invokerRoleName.equals(that.invokerRoleName) : that.invokerRoleName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.crossAccountRoleArns != null ? this.crossAccountRoleArns.hashCode() : 0);
                result = 31 * result + (this.invokerRoleName != null ? this.invokerRoleName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Defines a physical resource identifier.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.resiliencehub.*;
     * PhysicalResourceIdProperty physicalResourceIdProperty = PhysicalResourceIdProperty.builder()
     *         .identifier("identifier")
     *         .type("type")
     *         // the properties below are optional
     *         .awsAccountId("awsAccountId")
     *         .awsRegion("awsRegion")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resiliencehub-app-physicalresourceid.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resiliencehub-app-physicalresourceid.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_resiliencehub.CfnApp.PhysicalResourceIdProperty")
    @software.amazon.jsii.Jsii.Proxy(PhysicalResourceIdProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PhysicalResourceIdProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Identifier of the physical resource.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resiliencehub-app-physicalresourceid.html#cfn-resiliencehub-app-physicalresourceid-identifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resiliencehub-app-physicalresourceid.html#cfn-resiliencehub-app-physicalresourceid-identifier</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getIdentifier();

        /**
         * Specifies the type of physical resource identifier.
         * <p>
         * <ul>
         * <li><strong>Arn</strong> - The resource identifier is an Amazon Resource Name (ARN) and it can identify the following list of resources:</li>
         * <li><code>AWS::ECS::Service</code></li>
         * <li><code>AWS::EFS::FileSystem</code></li>
         * <li><code>AWS::ElasticLoadBalancingV2::LoadBalancer</code></li>
         * <li><code>AWS::Lambda::Function</code></li>
         * <li><code>AWS::SNS::Topic</code></li>
         * <li><strong>Native</strong> - The resource identifier is an AWS Resilience Hub -native identifier and it can identify the following list of resources:</li>
         * <li><code>AWS::ApiGateway::RestApi</code></li>
         * <li><code>AWS::ApiGatewayV2::Api</code></li>
         * <li><code>AWS::AutoScaling::AutoScalingGroup</code></li>
         * <li><code>AWS::DocDB::DBCluster</code></li>
         * <li><code>AWS::DocDB::DBGlobalCluster</code></li>
         * <li><code>AWS::DocDB::DBInstance</code></li>
         * <li><code>AWS::DynamoDB::GlobalTable</code></li>
         * <li><code>AWS::DynamoDB::Table</code></li>
         * <li><code>AWS::EC2::EC2Fleet</code></li>
         * <li><code>AWS::EC2::Instance</code></li>
         * <li><code>AWS::EC2::NatGateway</code></li>
         * <li><code>AWS::EC2::Volume</code></li>
         * <li><code>AWS::ElasticLoadBalancing::LoadBalancer</code></li>
         * <li><code>AWS::RDS::DBCluster</code></li>
         * <li><code>AWS::RDS::DBInstance</code></li>
         * <li><code>AWS::RDS::GlobalCluster</code></li>
         * <li><code>AWS::Route53::RecordSet</code></li>
         * <li><code>AWS::S3::Bucket</code></li>
         * <li><code>AWS::SQS::Queue</code></li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resiliencehub-app-physicalresourceid.html#cfn-resiliencehub-app-physicalresourceid-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resiliencehub-app-physicalresourceid.html#cfn-resiliencehub-app-physicalresourceid-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * The AWS account that owns the physical resource.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resiliencehub-app-physicalresourceid.html#cfn-resiliencehub-app-physicalresourceid-awsaccountid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resiliencehub-app-physicalresourceid.html#cfn-resiliencehub-app-physicalresourceid-awsaccountid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAwsAccountId() {
            return null;
        }

        /**
         * The AWS Region that the physical resource is located in.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resiliencehub-app-physicalresourceid.html#cfn-resiliencehub-app-physicalresourceid-awsregion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resiliencehub-app-physicalresourceid.html#cfn-resiliencehub-app-physicalresourceid-awsregion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAwsRegion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PhysicalResourceIdProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PhysicalResourceIdProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PhysicalResourceIdProperty> {
            java.lang.String identifier;
            java.lang.String type;
            java.lang.String awsAccountId;
            java.lang.String awsRegion;

            /**
             * Sets the value of {@link PhysicalResourceIdProperty#getIdentifier}
             * @param identifier Identifier of the physical resource. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder identifier(java.lang.String identifier) {
                this.identifier = identifier;
                return this;
            }

            /**
             * Sets the value of {@link PhysicalResourceIdProperty#getType}
             * @param type Specifies the type of physical resource identifier. This parameter is required.
             *             <ul>
             *             <li><strong>Arn</strong> - The resource identifier is an Amazon Resource Name (ARN) and it can identify the following list of resources:</li>
             *             <li><code>AWS::ECS::Service</code></li>
             *             <li><code>AWS::EFS::FileSystem</code></li>
             *             <li><code>AWS::ElasticLoadBalancingV2::LoadBalancer</code></li>
             *             <li><code>AWS::Lambda::Function</code></li>
             *             <li><code>AWS::SNS::Topic</code></li>
             *             <li><strong>Native</strong> - The resource identifier is an AWS Resilience Hub -native identifier and it can identify the following list of resources:</li>
             *             <li><code>AWS::ApiGateway::RestApi</code></li>
             *             <li><code>AWS::ApiGatewayV2::Api</code></li>
             *             <li><code>AWS::AutoScaling::AutoScalingGroup</code></li>
             *             <li><code>AWS::DocDB::DBCluster</code></li>
             *             <li><code>AWS::DocDB::DBGlobalCluster</code></li>
             *             <li><code>AWS::DocDB::DBInstance</code></li>
             *             <li><code>AWS::DynamoDB::GlobalTable</code></li>
             *             <li><code>AWS::DynamoDB::Table</code></li>
             *             <li><code>AWS::EC2::EC2Fleet</code></li>
             *             <li><code>AWS::EC2::Instance</code></li>
             *             <li><code>AWS::EC2::NatGateway</code></li>
             *             <li><code>AWS::EC2::Volume</code></li>
             *             <li><code>AWS::ElasticLoadBalancing::LoadBalancer</code></li>
             *             <li><code>AWS::RDS::DBCluster</code></li>
             *             <li><code>AWS::RDS::DBInstance</code></li>
             *             <li><code>AWS::RDS::GlobalCluster</code></li>
             *             <li><code>AWS::Route53::RecordSet</code></li>
             *             <li><code>AWS::S3::Bucket</code></li>
             *             <li><code>AWS::SQS::Queue</code></li>
             *             </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link PhysicalResourceIdProperty#getAwsAccountId}
             * @param awsAccountId The AWS account that owns the physical resource.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsAccountId(java.lang.String awsAccountId) {
                this.awsAccountId = awsAccountId;
                return this;
            }

            /**
             * Sets the value of {@link PhysicalResourceIdProperty#getAwsRegion}
             * @param awsRegion The AWS Region that the physical resource is located in.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsRegion(java.lang.String awsRegion) {
                this.awsRegion = awsRegion;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PhysicalResourceIdProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PhysicalResourceIdProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PhysicalResourceIdProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PhysicalResourceIdProperty {
            private final java.lang.String identifier;
            private final java.lang.String type;
            private final java.lang.String awsAccountId;
            private final java.lang.String awsRegion;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.identifier = software.amazon.jsii.Kernel.get(this, "identifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.awsAccountId = software.amazon.jsii.Kernel.get(this, "awsAccountId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.awsRegion = software.amazon.jsii.Kernel.get(this, "awsRegion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.identifier = java.util.Objects.requireNonNull(builder.identifier, "identifier is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.awsAccountId = builder.awsAccountId;
                this.awsRegion = builder.awsRegion;
            }

            @Override
            public final java.lang.String getIdentifier() {
                return this.identifier;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.String getAwsAccountId() {
                return this.awsAccountId;
            }

            @Override
            public final java.lang.String getAwsRegion() {
                return this.awsRegion;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("identifier", om.valueToTree(this.getIdentifier()));
                data.set("type", om.valueToTree(this.getType()));
                if (this.getAwsAccountId() != null) {
                    data.set("awsAccountId", om.valueToTree(this.getAwsAccountId()));
                }
                if (this.getAwsRegion() != null) {
                    data.set("awsRegion", om.valueToTree(this.getAwsRegion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_resiliencehub.CfnApp.PhysicalResourceIdProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PhysicalResourceIdProperty.Jsii$Proxy that = (PhysicalResourceIdProperty.Jsii$Proxy) o;

                if (!identifier.equals(that.identifier)) return false;
                if (!type.equals(that.type)) return false;
                if (this.awsAccountId != null ? !this.awsAccountId.equals(that.awsAccountId) : that.awsAccountId != null) return false;
                return this.awsRegion != null ? this.awsRegion.equals(that.awsRegion) : that.awsRegion == null;
            }

            @Override
            public final int hashCode() {
                int result = this.identifier.hashCode();
                result = 31 * result + (this.type.hashCode());
                result = 31 * result + (this.awsAccountId != null ? this.awsAccountId.hashCode() : 0);
                result = 31 * result + (this.awsRegion != null ? this.awsRegion.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Defines a resource mapping.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.resiliencehub.*;
     * ResourceMappingProperty resourceMappingProperty = ResourceMappingProperty.builder()
     *         .mappingType("mappingType")
     *         .physicalResourceId(PhysicalResourceIdProperty.builder()
     *                 .identifier("identifier")
     *                 .type("type")
     *                 // the properties below are optional
     *                 .awsAccountId("awsAccountId")
     *                 .awsRegion("awsRegion")
     *                 .build())
     *         // the properties below are optional
     *         .eksSourceName("eksSourceName")
     *         .logicalStackName("logicalStackName")
     *         .resourceName("resourceName")
     *         .terraformSourceName("terraformSourceName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resiliencehub-app-resourcemapping.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resiliencehub-app-resourcemapping.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_resiliencehub.CfnApp.ResourceMappingProperty")
    @software.amazon.jsii.Jsii.Proxy(ResourceMappingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ResourceMappingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the type of resource mapping.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resiliencehub-app-resourcemapping.html#cfn-resiliencehub-app-resourcemapping-mappingtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resiliencehub-app-resourcemapping.html#cfn-resiliencehub-app-resourcemapping-mappingtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMappingType();

        /**
         * Identifier of the physical resource.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resiliencehub-app-resourcemapping.html#cfn-resiliencehub-app-resourcemapping-physicalresourceid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resiliencehub-app-resourcemapping.html#cfn-resiliencehub-app-resourcemapping-physicalresourceid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getPhysicalResourceId();

        /**
         * Name of the Amazon Elastic Kubernetes Service cluster and namespace that this resource is mapped to when the <code>mappingType</code> is <code>EKS</code> .
         * <p>
         * <blockquote>
         * <p>
         * This parameter accepts values in "eks-cluster/namespace" format.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resiliencehub-app-resourcemapping.html#cfn-resiliencehub-app-resourcemapping-ekssourcename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resiliencehub-app-resourcemapping.html#cfn-resiliencehub-app-resourcemapping-ekssourcename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEksSourceName() {
            return null;
        }

        /**
         * Name of the AWS CloudFormation stack this resource is mapped to when the <code>mappingType</code> is <code>CfnStack</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resiliencehub-app-resourcemapping.html#cfn-resiliencehub-app-resourcemapping-logicalstackname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resiliencehub-app-resourcemapping.html#cfn-resiliencehub-app-resourcemapping-logicalstackname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLogicalStackName() {
            return null;
        }

        /**
         * Name of the resource that this resource is mapped to when the <code>mappingType</code> is <code>Resource</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resiliencehub-app-resourcemapping.html#cfn-resiliencehub-app-resourcemapping-resourcename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resiliencehub-app-resourcemapping.html#cfn-resiliencehub-app-resourcemapping-resourcename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getResourceName() {
            return null;
        }

        /**
         * Name of the Terraform source that this resource is mapped to when the <code>mappingType</code> is <code>Terraform</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resiliencehub-app-resourcemapping.html#cfn-resiliencehub-app-resourcemapping-terraformsourcename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resiliencehub-app-resourcemapping.html#cfn-resiliencehub-app-resourcemapping-terraformsourcename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTerraformSourceName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ResourceMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ResourceMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ResourceMappingProperty> {
            java.lang.String mappingType;
            java.lang.Object physicalResourceId;
            java.lang.String eksSourceName;
            java.lang.String logicalStackName;
            java.lang.String resourceName;
            java.lang.String terraformSourceName;

            /**
             * Sets the value of {@link ResourceMappingProperty#getMappingType}
             * @param mappingType Specifies the type of resource mapping. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mappingType(java.lang.String mappingType) {
                this.mappingType = mappingType;
                return this;
            }

            /**
             * Sets the value of {@link ResourceMappingProperty#getPhysicalResourceId}
             * @param physicalResourceId Identifier of the physical resource. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder physicalResourceId(software.amazon.awscdk.IResolvable physicalResourceId) {
                this.physicalResourceId = physicalResourceId;
                return this;
            }

            /**
             * Sets the value of {@link ResourceMappingProperty#getPhysicalResourceId}
             * @param physicalResourceId Identifier of the physical resource. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder physicalResourceId(software.amazon.awscdk.services.resiliencehub.CfnApp.PhysicalResourceIdProperty physicalResourceId) {
                this.physicalResourceId = physicalResourceId;
                return this;
            }

            /**
             * Sets the value of {@link ResourceMappingProperty#getEksSourceName}
             * @param eksSourceName Name of the Amazon Elastic Kubernetes Service cluster and namespace that this resource is mapped to when the <code>mappingType</code> is <code>EKS</code> .
             *                      <blockquote>
             *                      <p>
             *                      This parameter accepts values in "eks-cluster/namespace" format.
             *                      <p>
             *                      </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eksSourceName(java.lang.String eksSourceName) {
                this.eksSourceName = eksSourceName;
                return this;
            }

            /**
             * Sets the value of {@link ResourceMappingProperty#getLogicalStackName}
             * @param logicalStackName Name of the AWS CloudFormation stack this resource is mapped to when the <code>mappingType</code> is <code>CfnStack</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logicalStackName(java.lang.String logicalStackName) {
                this.logicalStackName = logicalStackName;
                return this;
            }

            /**
             * Sets the value of {@link ResourceMappingProperty#getResourceName}
             * @param resourceName Name of the resource that this resource is mapped to when the <code>mappingType</code> is <code>Resource</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceName(java.lang.String resourceName) {
                this.resourceName = resourceName;
                return this;
            }

            /**
             * Sets the value of {@link ResourceMappingProperty#getTerraformSourceName}
             * @param terraformSourceName Name of the Terraform source that this resource is mapped to when the <code>mappingType</code> is <code>Terraform</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder terraformSourceName(java.lang.String terraformSourceName) {
                this.terraformSourceName = terraformSourceName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ResourceMappingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ResourceMappingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ResourceMappingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResourceMappingProperty {
            private final java.lang.String mappingType;
            private final java.lang.Object physicalResourceId;
            private final java.lang.String eksSourceName;
            private final java.lang.String logicalStackName;
            private final java.lang.String resourceName;
            private final java.lang.String terraformSourceName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.mappingType = software.amazon.jsii.Kernel.get(this, "mappingType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.physicalResourceId = software.amazon.jsii.Kernel.get(this, "physicalResourceId", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.eksSourceName = software.amazon.jsii.Kernel.get(this, "eksSourceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.logicalStackName = software.amazon.jsii.Kernel.get(this, "logicalStackName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.resourceName = software.amazon.jsii.Kernel.get(this, "resourceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.terraformSourceName = software.amazon.jsii.Kernel.get(this, "terraformSourceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.mappingType = java.util.Objects.requireNonNull(builder.mappingType, "mappingType is required");
                this.physicalResourceId = java.util.Objects.requireNonNull(builder.physicalResourceId, "physicalResourceId is required");
                this.eksSourceName = builder.eksSourceName;
                this.logicalStackName = builder.logicalStackName;
                this.resourceName = builder.resourceName;
                this.terraformSourceName = builder.terraformSourceName;
            }

            @Override
            public final java.lang.String getMappingType() {
                return this.mappingType;
            }

            @Override
            public final java.lang.Object getPhysicalResourceId() {
                return this.physicalResourceId;
            }

            @Override
            public final java.lang.String getEksSourceName() {
                return this.eksSourceName;
            }

            @Override
            public final java.lang.String getLogicalStackName() {
                return this.logicalStackName;
            }

            @Override
            public final java.lang.String getResourceName() {
                return this.resourceName;
            }

            @Override
            public final java.lang.String getTerraformSourceName() {
                return this.terraformSourceName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("mappingType", om.valueToTree(this.getMappingType()));
                data.set("physicalResourceId", om.valueToTree(this.getPhysicalResourceId()));
                if (this.getEksSourceName() != null) {
                    data.set("eksSourceName", om.valueToTree(this.getEksSourceName()));
                }
                if (this.getLogicalStackName() != null) {
                    data.set("logicalStackName", om.valueToTree(this.getLogicalStackName()));
                }
                if (this.getResourceName() != null) {
                    data.set("resourceName", om.valueToTree(this.getResourceName()));
                }
                if (this.getTerraformSourceName() != null) {
                    data.set("terraformSourceName", om.valueToTree(this.getTerraformSourceName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_resiliencehub.CfnApp.ResourceMappingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ResourceMappingProperty.Jsii$Proxy that = (ResourceMappingProperty.Jsii$Proxy) o;

                if (!mappingType.equals(that.mappingType)) return false;
                if (!physicalResourceId.equals(that.physicalResourceId)) return false;
                if (this.eksSourceName != null ? !this.eksSourceName.equals(that.eksSourceName) : that.eksSourceName != null) return false;
                if (this.logicalStackName != null ? !this.logicalStackName.equals(that.logicalStackName) : that.logicalStackName != null) return false;
                if (this.resourceName != null ? !this.resourceName.equals(that.resourceName) : that.resourceName != null) return false;
                return this.terraformSourceName != null ? this.terraformSourceName.equals(that.terraformSourceName) : that.terraformSourceName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.mappingType.hashCode();
                result = 31 * result + (this.physicalResourceId.hashCode());
                result = 31 * result + (this.eksSourceName != null ? this.eksSourceName.hashCode() : 0);
                result = 31 * result + (this.logicalStackName != null ? this.logicalStackName.hashCode() : 0);
                result = 31 * result + (this.resourceName != null ? this.resourceName.hashCode() : 0);
                result = 31 * result + (this.terraformSourceName != null ? this.terraformSourceName.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.resiliencehub.CfnApp}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.resiliencehub.CfnApp> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.resiliencehub.CfnAppProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.resiliencehub.CfnAppProps.Builder();
        }

        /**
         * A JSON string that provides information about your application structure.
         * <p>
         * To learn more about the <code>appTemplateBody</code> template, see the sample template in <a href="https://docs.aws.amazon.com//resilience-hub/latest/APIReference/API_PutDraftAppVersionTemplate.html#API_PutDraftAppVersionTemplate_Examples">Sample appTemplateBody template</a> .
         * <p>
         * The <code>appTemplateBody</code> JSON string has the following structure:
         * <p>
         * <ul>
         * <li><em><code>resources</code></em></li>
         * </ul>
         * <p>
         * The list of logical resources that needs to be included in the AWS Resilience Hub application.
         * <p>
         * Type: Array
         * <p>
         * <blockquote>
         * <p>
         * Don't add the resources that you want to exclude.
         * <p>
         * </blockquote>
         * <p>
         * Each <code>resources</code> array item includes the following fields:
         * <p>
         * <ul>
         * <li><em><code>logicalResourceId</code></em></li>
         * </ul>
         * <p>
         * The logical identifier of the resource.
         * <p>
         * Type: Object
         * <p>
         * Each <code>logicalResourceId</code> object includes the following fields:
         * <p>
         * <ul>
         * <li><code>identifier</code></li>
         * </ul>
         * <p>
         * Identifier of the resource.
         * <p>
         * Type: String
         * <p>
         * <ul>
         * <li><code>logicalStackName</code></li>
         * </ul>
         * <p>
         * Name of the AWS CloudFormation stack this resource belongs to.
         * <p>
         * Type: String
         * <p>
         * <ul>
         * <li><code>resourceGroupName</code></li>
         * </ul>
         * <p>
         * Name of the resource group this resource belongs to.
         * <p>
         * Type: String
         * <p>
         * <ul>
         * <li><code>terraformSourceName</code></li>
         * </ul>
         * <p>
         * Name of the Terraform S3 state file this resource belongs to.
         * <p>
         * Type: String
         * <p>
         * <ul>
         * <li><code>eksSourceName</code></li>
         * </ul>
         * <p>
         * Name of the Amazon Elastic Kubernetes Service cluster and namespace this resource belongs to.
         * <p>
         * <blockquote>
         * <p>
         * This parameter accepts values in "eks-cluster/namespace" format.
         * <p>
         * </blockquote>
         * <p>
         * Type: String
         * <p>
         * <ul>
         * <li><em><code>type</code></em></li>
         * </ul>
         * <p>
         * The type of resource.
         * <p>
         * Type: string
         * <p>
         * <ul>
         * <li><em><code>name</code></em></li>
         * </ul>
         * <p>
         * Name of the resource.
         * <p>
         * Type: String
         * <p>
         * <ul>
         * <li><code>additionalInfo</code></li>
         * </ul>
         * <p>
         * Additional configuration parameters for an AWS Resilience Hub application. If you want to implement <code>additionalInfo</code> through the AWS Resilience Hub console rather than using an API call, see <a href="https://docs.aws.amazon.com//resilience-hub/latest/userguide/app-config-param.html">Configure the application configuration parameters</a> .
         * <p>
         * <blockquote>
         * <p>
         * Currently, this parameter accepts a key-value mapping (in a string format) of only one failover region and one associated account.
         * <p>
         * Key: <code>"failover-regions"</code>
         * <p>
         * Value: <code>"[{"region":"&lt;REGION&gt;", "accounts":[{"id":"&lt;ACCOUNT_ID&gt;"}]}]"</code>
         * <p>
         * </blockquote>
         * <p>
         * <ul>
         * <li><em><code>appComponents</code></em></li>
         * </ul>
         * <p>
         * The list of Application Components (AppComponent) that this resource belongs to. If an AppComponent is not part of the AWS Resilience Hub application, it will be added.
         * <p>
         * Type: Array
         * <p>
         * Each <code>appComponents</code> array item includes the following fields:
         * <p>
         * <ul>
         * <li><code>name</code></li>
         * </ul>
         * <p>
         * Name of the AppComponent.
         * <p>
         * Type: String
         * <p>
         * <ul>
         * <li><code>type</code></li>
         * </ul>
         * <p>
         * The type of AppComponent. For more information about the types of AppComponent, see <a href="https://docs.aws.amazon.com/resilience-hub/latest/userguide/AppComponent.grouping.html">Grouping resources in an AppComponent</a> .
         * <p>
         * Type: String
         * <p>
         * <ul>
         * <li><code>resourceNames</code></li>
         * </ul>
         * <p>
         * The list of included resources that are assigned to the AppComponent.
         * <p>
         * Type: Array of strings
         * <p>
         * <ul>
         * <li><code>additionalInfo</code></li>
         * </ul>
         * <p>
         * Additional configuration parameters for an AWS Resilience Hub application. If you want to implement <code>additionalInfo</code> through the AWS Resilience Hub console rather than using an API call, see <a href="https://docs.aws.amazon.com//resilience-hub/latest/userguide/app-config-param.html">Configure the application configuration parameters</a> .
         * <p>
         * <blockquote>
         * <p>
         * Currently, this parameter accepts a key-value mapping (in a string format) of only one failover region and one associated account.
         * <p>
         * Key: <code>"failover-regions"</code>
         * <p>
         * Value: <code>"[{"region":"&lt;REGION&gt;", "accounts":[{"id":"&lt;ACCOUNT_ID&gt;"}]}]"</code>
         * <p>
         * </blockquote>
         * <p>
         * <ul>
         * <li><em><code>excludedResources</code></em></li>
         * </ul>
         * <p>
         * The list of logical resource identifiers to be excluded from the application.
         * <p>
         * Type: Array
         * <p>
         * <blockquote>
         * <p>
         * Don't add the resources that you want to include.
         * <p>
         * </blockquote>
         * <p>
         * Each <code>excludedResources</code> array item includes the following fields:
         * <p>
         * <ul>
         * <li><em><code>logicalResourceIds</code></em></li>
         * </ul>
         * <p>
         * The logical identifier of the resource.
         * <p>
         * Type: Object
         * <p>
         * <blockquote>
         * <p>
         * You can configure only one of the following fields:
         * <p>
         * <ul>
         * <li><code>logicalStackName</code></li>
         * <li><code>resourceGroupName</code></li>
         * <li><code>terraformSourceName</code></li>
         * <li><code>eksSourceName</code></li>
         * </ul>
         * <p>
         * </blockquote>
         * <p>
         * Each <code>logicalResourceIds</code> object includes the following fields:
         * <p>
         * <ul>
         * <li><code>identifier</code></li>
         * </ul>
         * <p>
         * The identifier of the resource.
         * <p>
         * Type: String
         * <p>
         * <ul>
         * <li><code>logicalStackName</code></li>
         * </ul>
         * <p>
         * Name of the AWS CloudFormation stack this resource belongs to.
         * <p>
         * Type: String
         * <p>
         * <ul>
         * <li><code>resourceGroupName</code></li>
         * </ul>
         * <p>
         * Name of the resource group this resource belongs to.
         * <p>
         * Type: String
         * <p>
         * <ul>
         * <li><code>terraformSourceName</code></li>
         * </ul>
         * <p>
         * Name of the Terraform S3 state file this resource belongs to.
         * <p>
         * Type: String
         * <p>
         * <ul>
         * <li><code>eksSourceName</code></li>
         * </ul>
         * <p>
         * Name of the Amazon Elastic Kubernetes Service cluster and namespace this resource belongs to.
         * <p>
         * <blockquote>
         * <p>
         * This parameter accepts values in "eks-cluster/namespace" format.
         * <p>
         * </blockquote>
         * <p>
         * Type: String
         * <p>
         * <ul>
         * <li><em><code>version</code></em></li>
         * </ul>
         * <p>
         * The AWS Resilience Hub application version.
         * <p>
         * <ul>
         * <li><code>additionalInfo</code></li>
         * </ul>
         * <p>
         * Additional configuration parameters for an AWS Resilience Hub application. If you want to implement <code>additionalInfo</code> through the AWS Resilience Hub console rather than using an API call, see <a href="https://docs.aws.amazon.com//resilience-hub/latest/userguide/app-config-param.html">Configure the application configuration parameters</a> .
         * <p>
         * <blockquote>
         * <p>
         * Currently, this parameter accepts a key-value mapping (in a string format) of only one failover region and one associated account.
         * <p>
         * Key: <code>"failover-regions"</code>
         * <p>
         * Value: <code>"[{"region":"&lt;REGION&gt;", "accounts":[{"id":"&lt;ACCOUNT_ID&gt;"}]}]"</code>
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html#cfn-resiliencehub-app-apptemplatebody">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html#cfn-resiliencehub-app-apptemplatebody</a>
         * @param appTemplateBody A JSON string that provides information about your application structure. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder appTemplateBody(final java.lang.String appTemplateBody) {
            this.props.appTemplateBody(appTemplateBody);
            return this;
        }

        /**
         * Name for the application.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html#cfn-resiliencehub-app-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html#cfn-resiliencehub-app-name</a>
         * @param name Name for the application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * An array of <code>ResourceMapping</code> objects.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html#cfn-resiliencehub-app-resourcemappings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html#cfn-resiliencehub-app-resourcemappings</a>
         * @param resourceMappings An array of <code>ResourceMapping</code> objects. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceMappings(final software.amazon.awscdk.IResolvable resourceMappings) {
            this.props.resourceMappings(resourceMappings);
            return this;
        }
        /**
         * An array of <code>ResourceMapping</code> objects.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html#cfn-resiliencehub-app-resourcemappings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html#cfn-resiliencehub-app-resourcemappings</a>
         * @param resourceMappings An array of <code>ResourceMapping</code> objects. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceMappings(final java.util.List<? extends java.lang.Object> resourceMappings) {
            this.props.resourceMappings(resourceMappings);
            return this;
        }

        /**
         * Assessment execution schedule with 'Daily' or 'Disabled' values.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html#cfn-resiliencehub-app-appassessmentschedule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html#cfn-resiliencehub-app-appassessmentschedule</a>
         * @param appAssessmentSchedule Assessment execution schedule with 'Daily' or 'Disabled' values. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder appAssessmentSchedule(final java.lang.String appAssessmentSchedule) {
            this.props.appAssessmentSchedule(appAssessmentSchedule);
            return this;
        }

        /**
         * Optional description for an application.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html#cfn-resiliencehub-app-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html#cfn-resiliencehub-app-description</a>
         * @param description Optional description for an application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The list of events you would like to subscribe and get notification for.
         * <p>
         * Currently, AWS Resilience Hub supports notifications only for <em>Drift detected</em> and <em>Scheduled assessment failure</em> events.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html#cfn-resiliencehub-app-eventsubscriptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html#cfn-resiliencehub-app-eventsubscriptions</a>
         * @param eventSubscriptions The list of events you would like to subscribe and get notification for. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventSubscriptions(final software.amazon.awscdk.IResolvable eventSubscriptions) {
            this.props.eventSubscriptions(eventSubscriptions);
            return this;
        }
        /**
         * The list of events you would like to subscribe and get notification for.
         * <p>
         * Currently, AWS Resilience Hub supports notifications only for <em>Drift detected</em> and <em>Scheduled assessment failure</em> events.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html#cfn-resiliencehub-app-eventsubscriptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html#cfn-resiliencehub-app-eventsubscriptions</a>
         * @param eventSubscriptions The list of events you would like to subscribe and get notification for. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventSubscriptions(final java.util.List<? extends java.lang.Object> eventSubscriptions) {
            this.props.eventSubscriptions(eventSubscriptions);
            return this;
        }

        /**
         * Defines the roles and credentials that AWS Resilience Hub would use while creating the application, importing its resources, and running an assessment.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html#cfn-resiliencehub-app-permissionmodel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html#cfn-resiliencehub-app-permissionmodel</a>
         * @param permissionModel Defines the roles and credentials that AWS Resilience Hub would use while creating the application, importing its resources, and running an assessment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder permissionModel(final software.amazon.awscdk.IResolvable permissionModel) {
            this.props.permissionModel(permissionModel);
            return this;
        }
        /**
         * Defines the roles and credentials that AWS Resilience Hub would use while creating the application, importing its resources, and running an assessment.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html#cfn-resiliencehub-app-permissionmodel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html#cfn-resiliencehub-app-permissionmodel</a>
         * @param permissionModel Defines the roles and credentials that AWS Resilience Hub would use while creating the application, importing its resources, and running an assessment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder permissionModel(final software.amazon.awscdk.services.resiliencehub.CfnApp.PermissionModelProperty permissionModel) {
            this.props.permissionModel(permissionModel);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the resiliency policy.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html#cfn-resiliencehub-app-resiliencypolicyarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html#cfn-resiliencehub-app-resiliencypolicyarn</a>
         * @param resiliencyPolicyArn The Amazon Resource Name (ARN) of the resiliency policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resiliencyPolicyArn(final java.lang.String resiliencyPolicyArn) {
            this.props.resiliencyPolicyArn(resiliencyPolicyArn);
            return this;
        }

        /**
         * Tags assigned to the resource.
         * <p>
         * A tag is a label that you assign to an AWS resource. Each tag consists of a key/value pair.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html#cfn-resiliencehub-app-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html#cfn-resiliencehub-app-tags</a>
         * @param tags Tags assigned to the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.Map<java.lang.String, java.lang.String> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.resiliencehub.CfnApp}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.resiliencehub.CfnApp build() {
            return new software.amazon.awscdk.services.resiliencehub.CfnApp(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
