package software.amazon.awscdk.services.rds;

/**
 * Engine lifecycle support for Amazon RDS and Amazon Aurora.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * IVpc vpc;
 * DatabaseCluster.Builder.create(this, "DatabaseCluster")
 *         .engine(DatabaseClusterEngine.auroraMysql(AuroraMysqlClusterEngineProps.builder().version(AuroraMysqlEngineVersion.VER_3_07_0).build()))
 *         .writer(ClusterInstance.serverlessV2("writerInstance"))
 *         .vpc(vpc)
 *         .engineLifecycleSupport(EngineLifecycleSupport.OPEN_SOURCE_RDS_EXTENDED_SUPPORT)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:19.351Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.EngineLifecycleSupport")
public enum EngineLifecycleSupport {
    /**
     * Using Amazon RDS extended support.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    OPEN_SOURCE_RDS_EXTENDED_SUPPORT,
    /**
     * Not using Amazon RDS extended support.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    OPEN_SOURCE_RDS_EXTENDED_SUPPORT_DISABLED,
}
