package software.amazon.awscdk.services.opsworkscm;

/**
 * Properties for defining a <code>CfnServer</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.opsworkscm.*;
 * CfnServerProps cfnServerProps = CfnServerProps.builder()
 *         .instanceProfileArn("instanceProfileArn")
 *         .instanceType("instanceType")
 *         .serviceRoleArn("serviceRoleArn")
 *         // the properties below are optional
 *         .associatePublicIpAddress(false)
 *         .backupId("backupId")
 *         .backupRetentionCount(123)
 *         .customCertificate("customCertificate")
 *         .customDomain("customDomain")
 *         .customPrivateKey("customPrivateKey")
 *         .disableAutomatedBackup(false)
 *         .engine("engine")
 *         .engineAttributes(List.of(EngineAttributeProperty.builder()
 *                 .name("name")
 *                 .value("value")
 *                 .build()))
 *         .engineModel("engineModel")
 *         .engineVersion("engineVersion")
 *         .keyPair("keyPair")
 *         .preferredBackupWindow("preferredBackupWindow")
 *         .preferredMaintenanceWindow("preferredMaintenanceWindow")
 *         .securityGroupIds(List.of("securityGroupIds"))
 *         .serverName("serverName")
 *         .subnetIds(List.of("subnetIds"))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:16.951Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_opsworkscm.CfnServerProps")
@software.amazon.jsii.Jsii.Proxy(CfnServerProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnServerProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the instance profile that your Amazon EC2 instances use.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-instanceprofilearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-instanceprofilearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getInstanceProfileArn();

    /**
     * The Amazon EC2 instance type to use.
     * <p>
     * For example, <code>m5.large</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-instancetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-instancetype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getInstanceType();

    /**
     * The service role that the AWS OpsWorks CM service backend uses to work with your account.
     * <p>
     * Although the AWS OpsWorks management console typically creates the service role for you, if you are using the AWS CLI or API commands, run the service-role-creation.yaml AWS CloudFormation template, located at https://s3.amazonaws.com/opsworks-cm-us-east-1-prod-default-assets/misc/opsworks-cm-roles.yaml. This template creates a CloudFormation stack that includes the service role and instance profile that you need.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-servicerolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-servicerolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getServiceRoleArn();

    /**
     * Associate a public IP address with a server that you are launching.
     * <p>
     * Valid values are <code>true</code> or <code>false</code> . The default value is <code>true</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-associatepublicipaddress">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-associatepublicipaddress</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAssociatePublicIpAddress() {
        return null;
    }

    /**
     * If you specify this field, AWS OpsWorks CM creates the server by using the backup represented by BackupId.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-backupid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-backupid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getBackupId() {
        return null;
    }

    /**
     * The number of automated backups that you want to keep.
     * <p>
     * Whenever a new backup is created, AWS OpsWorks CM deletes the oldest backups if this number is exceeded. The default value is <code>1</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-backupretentioncount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-backupretentioncount</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getBackupRetentionCount() {
        return null;
    }

    /**
     * Supported on servers running Chef Automate 2.0 only. A PEM-formatted HTTPS certificate. The value can be be a single, self-signed certificate, or a certificate chain. If you specify a custom certificate, you must also specify values for <code>CustomDomain</code> and <code>CustomPrivateKey</code> . The following are requirements for the <code>CustomCertificate</code> value:.
     * <p>
     * <ul>
     * <li>You can provide either a self-signed, custom certificate, or the full certificate chain.</li>
     * <li>The certificate must be a valid X509 certificate, or a certificate chain in PEM format.</li>
     * <li>The certificate must be valid at the time of upload. A certificate can't be used before its validity period begins (the certificate's <code>NotBefore</code> date), or after it expires (the certificate's <code>NotAfter</code> date).</li>
     * <li>The certificate’s common name or subject alternative names (SANs), if present, must match the value of <code>CustomDomain</code> .</li>
     * <li>The certificate must match the value of <code>CustomPrivateKey</code> .</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-customcertificate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-customcertificate</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCustomCertificate() {
        return null;
    }

    /**
     * Supported on servers running Chef Automate 2.0 only. An optional public endpoint of a server, such as <code>https://aws.my-company.com</code> . To access the server, create a CNAME DNS record in your preferred DNS service that points the custom domain to the endpoint that is generated when the server is created (the value of the CreateServer Endpoint attribute). You cannot access the server by using the generated <code>Endpoint</code> value if the server is using a custom domain. If you specify a custom domain, you must also specify values for <code>CustomCertificate</code> and <code>CustomPrivateKey</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-customdomain">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-customdomain</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCustomDomain() {
        return null;
    }

    /**
     * Supported on servers running Chef Automate 2.0 only. A private key in PEM format for connecting to the server by using HTTPS. The private key must not be encrypted; it cannot be protected by a password or passphrase. If you specify a custom private key, you must also specify values for <code>CustomDomain</code> and <code>CustomCertificate</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-customprivatekey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-customprivatekey</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCustomPrivateKey() {
        return null;
    }

    /**
     * Enable or disable scheduled backups.
     * <p>
     * Valid values are <code>true</code> or <code>false</code> . The default value is <code>true</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-disableautomatedbackup">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-disableautomatedbackup</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDisableAutomatedBackup() {
        return null;
    }

    /**
     * The configuration management engine to use.
     * <p>
     * Valid values include <code>ChefAutomate</code> and <code>Puppet</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-engine">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-engine</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEngine() {
        return null;
    }

    /**
     * Optional engine attributes on a specified server.
     * <p>
     * <strong>Attributes accepted in a Chef createServer request:</strong> - <code>CHEF_AUTOMATE_PIVOTAL_KEY</code> : A base64-encoded RSA public key. The corresponding private key is required to access the Chef API. When no CHEF_AUTOMATE_PIVOTAL_KEY is set, a private key is generated and returned in the response. When you are specifying the value of CHEF_AUTOMATE_PIVOTAL_KEY as a parameter in the AWS CloudFormation console, you must add newline ( <code>\n</code> ) characters at the end of each line of the pivotal key value.
     * <p>
     * <ul>
     * <li><code>CHEF_AUTOMATE_ADMIN_PASSWORD</code> : The password for the administrative user in the Chef Automate web-based dashboard. The password length is a minimum of eight characters, and a maximum of 32. The password can contain letters, numbers, and special characters (!/&#64;#$%^&amp;+=_). The password must contain at least one lower case letter, one upper case letter, one number, and one special character. When no CHEF_AUTOMATE_ADMIN_PASSWORD is set, one is generated and returned in the response.</li>
     * </ul>
     * <p>
     * <strong>Attributes accepted in a Puppet createServer request:</strong> - <code>PUPPET_ADMIN_PASSWORD</code> : To work with the Puppet Enterprise console, a password must use ASCII characters.
     * <p>
     * <ul>
     * <li><code>PUPPET_R10K_REMOTE</code> : The r10k remote is the URL of your control repository (for example, ssh://git&#64;your.git-repo.com:user/control-repo.git). Specifying an r10k remote opens TCP port 8170.</li>
     * <li><code>PUPPET_R10K_PRIVATE_KEY</code> : If you are using a private Git repository, add PUPPET_R10K_PRIVATE_KEY to specify a PEM-encoded private SSH key.</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-engineattributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-engineattributes</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEngineAttributes() {
        return null;
    }

    /**
     * The engine model of the server.
     * <p>
     * Valid values in this release include <code>Monolithic</code> for Puppet and <code>Single</code> for Chef.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-enginemodel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-enginemodel</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEngineModel() {
        return null;
    }

    /**
     * The major release version of the engine that you want to use.
     * <p>
     * For a Chef server, the valid value for EngineVersion is currently <code>2</code> . For a Puppet server, valid values are <code>2019</code> or <code>2017</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-engineversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-engineversion</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEngineVersion() {
        return null;
    }

    /**
     * The Amazon EC2 key pair to set for the instance.
     * <p>
     * This parameter is optional; if desired, you may specify this parameter to connect to your instances by using SSH.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-keypair">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-keypair</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKeyPair() {
        return null;
    }

    /**
     * The start time for a one-hour period during which AWS OpsWorks CM backs up application-level data on your server if automated backups are enabled.
     * <p>
     * Valid values must be specified in one of the following formats:
     * <p>
     * <ul>
     * <li><code>HH:MM</code> for daily backups</li>
     * <li><code>DDD:HH:MM</code> for weekly backups</li>
     * </ul>
     * <p>
     * <code>MM</code> must be specified as <code>00</code> . The specified time is in coordinated universal time (UTC). The default value is a random, daily start time.
     * <p>
     * <em>Example:</em> <code>08:00</code> , which represents a daily start time of 08:00 UTC.
     * <p>
     * <em>Example:</em> <code>Mon:08:00</code> , which represents a start time of every Monday at 08:00 UTC. (8:00 a.m.)
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-preferredbackupwindow">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-preferredbackupwindow</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPreferredBackupWindow() {
        return null;
    }

    /**
     * The start time for a one-hour period each week during which AWS OpsWorks CM performs maintenance on the instance.
     * <p>
     * Valid values must be specified in the following format: <code>DDD:HH:MM</code> . <code>MM</code> must be specified as <code>00</code> . The specified time is in coordinated universal time (UTC). The default value is a random one-hour period on Tuesday, Wednesday, or Friday. See <code>TimeWindowDefinition</code> for more information.
     * <p>
     * <em>Example:</em> <code>Mon:08:00</code> , which represents a start time of every Monday at 08:00 UTC. (8:00 a.m.)
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-preferredmaintenancewindow">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-preferredmaintenancewindow</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPreferredMaintenanceWindow() {
        return null;
    }

    /**
     * A list of security group IDs to attach to the Amazon EC2 instance.
     * <p>
     * If you add this parameter, the specified security groups must be within the VPC that is specified by <code>SubnetIds</code> .
     * <p>
     * If you do not specify this parameter, AWS OpsWorks CM creates one new security group that uses TCP ports 22 and 443, open to 0.0.0.0/0 (everyone).
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-securitygroupids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-securitygroupids</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroupIds() {
        return null;
    }

    /**
     * The name of the server.
     * <p>
     * The server name must be unique within your AWS account, within each region. Server names must start with a letter; then letters, numbers, or hyphens (-) are allowed, up to a maximum of 40 characters.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-servername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-servername</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getServerName() {
        return null;
    }

    /**
     * The IDs of subnets in which to launch the server EC2 instance.
     * <p>
     * Amazon EC2-Classic customers: This field is required. All servers must run within a VPC. The VPC must have "Auto Assign Public IP" enabled.
     * <p>
     * EC2-VPC customers: This field is optional. If you do not specify subnet IDs, your EC2 instances are created in a default subnet that is selected by Amazon EC2. If you specify subnet IDs, the VPC must have "Auto Assign Public IP" enabled.
     * <p>
     * For more information about supported Amazon EC2 platforms, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html">Supported Platforms</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-subnetids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-subnetids</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSubnetIds() {
        return null;
    }

    /**
     * A map that contains tag keys and tag values to attach to an AWS OpsWorks for Chef Automate or OpsWorks for Puppet Enterprise server.
     * <p>
     * <ul>
     * <li>The key cannot be empty.</li>
     * <li>The key can be a maximum of 127 characters, and can contain only Unicode letters, numbers, or separators, or the following special characters: `+ - = . _ : /</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworkscm-server.html#cfn-opsworkscm-server-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnServerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnServerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnServerProps> {
        java.lang.String instanceProfileArn;
        java.lang.String instanceType;
        java.lang.String serviceRoleArn;
        java.lang.Object associatePublicIpAddress;
        java.lang.String backupId;
        java.lang.Number backupRetentionCount;
        java.lang.String customCertificate;
        java.lang.String customDomain;
        java.lang.String customPrivateKey;
        java.lang.Object disableAutomatedBackup;
        java.lang.String engine;
        java.lang.Object engineAttributes;
        java.lang.String engineModel;
        java.lang.String engineVersion;
        java.lang.String keyPair;
        java.lang.String preferredBackupWindow;
        java.lang.String preferredMaintenanceWindow;
        java.util.List<java.lang.String> securityGroupIds;
        java.lang.String serverName;
        java.util.List<java.lang.String> subnetIds;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnServerProps#getInstanceProfileArn}
         * @param instanceProfileArn The ARN of the instance profile that your Amazon EC2 instances use. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceProfileArn(java.lang.String instanceProfileArn) {
            this.instanceProfileArn = instanceProfileArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnServerProps#getInstanceType}
         * @param instanceType The Amazon EC2 instance type to use. This parameter is required.
         *                     For example, <code>m5.large</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceType(java.lang.String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        /**
         * Sets the value of {@link CfnServerProps#getServiceRoleArn}
         * @param serviceRoleArn The service role that the AWS OpsWorks CM service backend uses to work with your account. This parameter is required.
         *                       Although the AWS OpsWorks management console typically creates the service role for you, if you are using the AWS CLI or API commands, run the service-role-creation.yaml AWS CloudFormation template, located at https://s3.amazonaws.com/opsworks-cm-us-east-1-prod-default-assets/misc/opsworks-cm-roles.yaml. This template creates a CloudFormation stack that includes the service role and instance profile that you need.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceRoleArn(java.lang.String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnServerProps#getAssociatePublicIpAddress}
         * @param associatePublicIpAddress Associate a public IP address with a server that you are launching.
         *                                 Valid values are <code>true</code> or <code>false</code> . The default value is <code>true</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder associatePublicIpAddress(java.lang.Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
            return this;
        }

        /**
         * Sets the value of {@link CfnServerProps#getAssociatePublicIpAddress}
         * @param associatePublicIpAddress Associate a public IP address with a server that you are launching.
         *                                 Valid values are <code>true</code> or <code>false</code> . The default value is <code>true</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder associatePublicIpAddress(software.amazon.awscdk.IResolvable associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
            return this;
        }

        /**
         * Sets the value of {@link CfnServerProps#getBackupId}
         * @param backupId If you specify this field, AWS OpsWorks CM creates the server by using the backup represented by BackupId.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backupId(java.lang.String backupId) {
            this.backupId = backupId;
            return this;
        }

        /**
         * Sets the value of {@link CfnServerProps#getBackupRetentionCount}
         * @param backupRetentionCount The number of automated backups that you want to keep.
         *                             Whenever a new backup is created, AWS OpsWorks CM deletes the oldest backups if this number is exceeded. The default value is <code>1</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backupRetentionCount(java.lang.Number backupRetentionCount) {
            this.backupRetentionCount = backupRetentionCount;
            return this;
        }

        /**
         * Sets the value of {@link CfnServerProps#getCustomCertificate}
         * @param customCertificate Supported on servers running Chef Automate 2.0 only. A PEM-formatted HTTPS certificate. The value can be be a single, self-signed certificate, or a certificate chain. If you specify a custom certificate, you must also specify values for <code>CustomDomain</code> and <code>CustomPrivateKey</code> . The following are requirements for the <code>CustomCertificate</code> value:.
         *                          <ul>
         *                          <li>You can provide either a self-signed, custom certificate, or the full certificate chain.</li>
         *                          <li>The certificate must be a valid X509 certificate, or a certificate chain in PEM format.</li>
         *                          <li>The certificate must be valid at the time of upload. A certificate can't be used before its validity period begins (the certificate's <code>NotBefore</code> date), or after it expires (the certificate's <code>NotAfter</code> date).</li>
         *                          <li>The certificate’s common name or subject alternative names (SANs), if present, must match the value of <code>CustomDomain</code> .</li>
         *                          <li>The certificate must match the value of <code>CustomPrivateKey</code> .</li>
         *                          </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customCertificate(java.lang.String customCertificate) {
            this.customCertificate = customCertificate;
            return this;
        }

        /**
         * Sets the value of {@link CfnServerProps#getCustomDomain}
         * @param customDomain Supported on servers running Chef Automate 2.0 only. An optional public endpoint of a server, such as <code>https://aws.my-company.com</code> . To access the server, create a CNAME DNS record in your preferred DNS service that points the custom domain to the endpoint that is generated when the server is created (the value of the CreateServer Endpoint attribute). You cannot access the server by using the generated <code>Endpoint</code> value if the server is using a custom domain. If you specify a custom domain, you must also specify values for <code>CustomCertificate</code> and <code>CustomPrivateKey</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customDomain(java.lang.String customDomain) {
            this.customDomain = customDomain;
            return this;
        }

        /**
         * Sets the value of {@link CfnServerProps#getCustomPrivateKey}
         * @param customPrivateKey Supported on servers running Chef Automate 2.0 only. A private key in PEM format for connecting to the server by using HTTPS. The private key must not be encrypted; it cannot be protected by a password or passphrase. If you specify a custom private key, you must also specify values for <code>CustomDomain</code> and <code>CustomCertificate</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customPrivateKey(java.lang.String customPrivateKey) {
            this.customPrivateKey = customPrivateKey;
            return this;
        }

        /**
         * Sets the value of {@link CfnServerProps#getDisableAutomatedBackup}
         * @param disableAutomatedBackup Enable or disable scheduled backups.
         *                               Valid values are <code>true</code> or <code>false</code> . The default value is <code>true</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disableAutomatedBackup(java.lang.Boolean disableAutomatedBackup) {
            this.disableAutomatedBackup = disableAutomatedBackup;
            return this;
        }

        /**
         * Sets the value of {@link CfnServerProps#getDisableAutomatedBackup}
         * @param disableAutomatedBackup Enable or disable scheduled backups.
         *                               Valid values are <code>true</code> or <code>false</code> . The default value is <code>true</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disableAutomatedBackup(software.amazon.awscdk.IResolvable disableAutomatedBackup) {
            this.disableAutomatedBackup = disableAutomatedBackup;
            return this;
        }

        /**
         * Sets the value of {@link CfnServerProps#getEngine}
         * @param engine The configuration management engine to use.
         *               Valid values include <code>ChefAutomate</code> and <code>Puppet</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engine(java.lang.String engine) {
            this.engine = engine;
            return this;
        }

        /**
         * Sets the value of {@link CfnServerProps#getEngineAttributes}
         * @param engineAttributes Optional engine attributes on a specified server.
         *                         <strong>Attributes accepted in a Chef createServer request:</strong> - <code>CHEF_AUTOMATE_PIVOTAL_KEY</code> : A base64-encoded RSA public key. The corresponding private key is required to access the Chef API. When no CHEF_AUTOMATE_PIVOTAL_KEY is set, a private key is generated and returned in the response. When you are specifying the value of CHEF_AUTOMATE_PIVOTAL_KEY as a parameter in the AWS CloudFormation console, you must add newline ( <code>\n</code> ) characters at the end of each line of the pivotal key value.
         *                         <p>
         *                         <ul>
         *                         <li><code>CHEF_AUTOMATE_ADMIN_PASSWORD</code> : The password for the administrative user in the Chef Automate web-based dashboard. The password length is a minimum of eight characters, and a maximum of 32. The password can contain letters, numbers, and special characters (!/&#64;#$%^&amp;+=_). The password must contain at least one lower case letter, one upper case letter, one number, and one special character. When no CHEF_AUTOMATE_ADMIN_PASSWORD is set, one is generated and returned in the response.</li>
         *                         </ul>
         *                         <p>
         *                         <strong>Attributes accepted in a Puppet createServer request:</strong> - <code>PUPPET_ADMIN_PASSWORD</code> : To work with the Puppet Enterprise console, a password must use ASCII characters.
         *                         <p>
         *                         <ul>
         *                         <li><code>PUPPET_R10K_REMOTE</code> : The r10k remote is the URL of your control repository (for example, ssh://git&#64;your.git-repo.com:user/control-repo.git). Specifying an r10k remote opens TCP port 8170.</li>
         *                         <li><code>PUPPET_R10K_PRIVATE_KEY</code> : If you are using a private Git repository, add PUPPET_R10K_PRIVATE_KEY to specify a PEM-encoded private SSH key.</li>
         *                         </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engineAttributes(software.amazon.awscdk.IResolvable engineAttributes) {
            this.engineAttributes = engineAttributes;
            return this;
        }

        /**
         * Sets the value of {@link CfnServerProps#getEngineAttributes}
         * @param engineAttributes Optional engine attributes on a specified server.
         *                         <strong>Attributes accepted in a Chef createServer request:</strong> - <code>CHEF_AUTOMATE_PIVOTAL_KEY</code> : A base64-encoded RSA public key. The corresponding private key is required to access the Chef API. When no CHEF_AUTOMATE_PIVOTAL_KEY is set, a private key is generated and returned in the response. When you are specifying the value of CHEF_AUTOMATE_PIVOTAL_KEY as a parameter in the AWS CloudFormation console, you must add newline ( <code>\n</code> ) characters at the end of each line of the pivotal key value.
         *                         <p>
         *                         <ul>
         *                         <li><code>CHEF_AUTOMATE_ADMIN_PASSWORD</code> : The password for the administrative user in the Chef Automate web-based dashboard. The password length is a minimum of eight characters, and a maximum of 32. The password can contain letters, numbers, and special characters (!/&#64;#$%^&amp;+=_). The password must contain at least one lower case letter, one upper case letter, one number, and one special character. When no CHEF_AUTOMATE_ADMIN_PASSWORD is set, one is generated and returned in the response.</li>
         *                         </ul>
         *                         <p>
         *                         <strong>Attributes accepted in a Puppet createServer request:</strong> - <code>PUPPET_ADMIN_PASSWORD</code> : To work with the Puppet Enterprise console, a password must use ASCII characters.
         *                         <p>
         *                         <ul>
         *                         <li><code>PUPPET_R10K_REMOTE</code> : The r10k remote is the URL of your control repository (for example, ssh://git&#64;your.git-repo.com:user/control-repo.git). Specifying an r10k remote opens TCP port 8170.</li>
         *                         <li><code>PUPPET_R10K_PRIVATE_KEY</code> : If you are using a private Git repository, add PUPPET_R10K_PRIVATE_KEY to specify a PEM-encoded private SSH key.</li>
         *                         </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engineAttributes(java.util.List<? extends java.lang.Object> engineAttributes) {
            this.engineAttributes = engineAttributes;
            return this;
        }

        /**
         * Sets the value of {@link CfnServerProps#getEngineModel}
         * @param engineModel The engine model of the server.
         *                    Valid values in this release include <code>Monolithic</code> for Puppet and <code>Single</code> for Chef.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engineModel(java.lang.String engineModel) {
            this.engineModel = engineModel;
            return this;
        }

        /**
         * Sets the value of {@link CfnServerProps#getEngineVersion}
         * @param engineVersion The major release version of the engine that you want to use.
         *                      For a Chef server, the valid value for EngineVersion is currently <code>2</code> . For a Puppet server, valid values are <code>2019</code> or <code>2017</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engineVersion(java.lang.String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        /**
         * Sets the value of {@link CfnServerProps#getKeyPair}
         * @param keyPair The Amazon EC2 key pair to set for the instance.
         *                This parameter is optional; if desired, you may specify this parameter to connect to your instances by using SSH.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyPair(java.lang.String keyPair) {
            this.keyPair = keyPair;
            return this;
        }

        /**
         * Sets the value of {@link CfnServerProps#getPreferredBackupWindow}
         * @param preferredBackupWindow The start time for a one-hour period during which AWS OpsWorks CM backs up application-level data on your server if automated backups are enabled.
         *                              Valid values must be specified in one of the following formats:
         *                              <p>
         *                              <ul>
         *                              <li><code>HH:MM</code> for daily backups</li>
         *                              <li><code>DDD:HH:MM</code> for weekly backups</li>
         *                              </ul>
         *                              <p>
         *                              <code>MM</code> must be specified as <code>00</code> . The specified time is in coordinated universal time (UTC). The default value is a random, daily start time.
         *                              <p>
         *                              <em>Example:</em> <code>08:00</code> , which represents a daily start time of 08:00 UTC.
         *                              <p>
         *                              <em>Example:</em> <code>Mon:08:00</code> , which represents a start time of every Monday at 08:00 UTC. (8:00 a.m.)
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preferredBackupWindow(java.lang.String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
            return this;
        }

        /**
         * Sets the value of {@link CfnServerProps#getPreferredMaintenanceWindow}
         * @param preferredMaintenanceWindow The start time for a one-hour period each week during which AWS OpsWorks CM performs maintenance on the instance.
         *                                   Valid values must be specified in the following format: <code>DDD:HH:MM</code> . <code>MM</code> must be specified as <code>00</code> . The specified time is in coordinated universal time (UTC). The default value is a random one-hour period on Tuesday, Wednesday, or Friday. See <code>TimeWindowDefinition</code> for more information.
         *                                   <p>
         *                                   <em>Example:</em> <code>Mon:08:00</code> , which represents a start time of every Monday at 08:00 UTC. (8:00 a.m.)
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preferredMaintenanceWindow(java.lang.String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        /**
         * Sets the value of {@link CfnServerProps#getSecurityGroupIds}
         * @param securityGroupIds A list of security group IDs to attach to the Amazon EC2 instance.
         *                         If you add this parameter, the specified security groups must be within the VPC that is specified by <code>SubnetIds</code> .
         *                         <p>
         *                         If you do not specify this parameter, AWS OpsWorks CM creates one new security group that uses TCP ports 22 and 443, open to 0.0.0.0/0 (everyone).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroupIds(java.util.List<java.lang.String> securityGroupIds) {
            this.securityGroupIds = securityGroupIds;
            return this;
        }

        /**
         * Sets the value of {@link CfnServerProps#getServerName}
         * @param serverName The name of the server.
         *                   The server name must be unique within your AWS account, within each region. Server names must start with a letter; then letters, numbers, or hyphens (-) are allowed, up to a maximum of 40 characters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverName(java.lang.String serverName) {
            this.serverName = serverName;
            return this;
        }

        /**
         * Sets the value of {@link CfnServerProps#getSubnetIds}
         * @param subnetIds The IDs of subnets in which to launch the server EC2 instance.
         *                  Amazon EC2-Classic customers: This field is required. All servers must run within a VPC. The VPC must have "Auto Assign Public IP" enabled.
         *                  <p>
         *                  EC2-VPC customers: This field is optional. If you do not specify subnet IDs, your EC2 instances are created in a default subnet that is selected by Amazon EC2. If you specify subnet IDs, the VPC must have "Auto Assign Public IP" enabled.
         *                  <p>
         *                  For more information about supported Amazon EC2 platforms, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html">Supported Platforms</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetIds(java.util.List<java.lang.String> subnetIds) {
            this.subnetIds = subnetIds;
            return this;
        }

        /**
         * Sets the value of {@link CfnServerProps#getTags}
         * @param tags A map that contains tag keys and tag values to attach to an AWS OpsWorks for Chef Automate or OpsWorks for Puppet Enterprise server.
         *             <ul>
         *             <li>The key cannot be empty.</li>
         *             <li>The key can be a maximum of 127 characters, and can contain only Unicode letters, numbers, or separators, or the following special characters: `+ - = . _ : /</li>
         *             </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnServerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnServerProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnServerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnServerProps {
        private final java.lang.String instanceProfileArn;
        private final java.lang.String instanceType;
        private final java.lang.String serviceRoleArn;
        private final java.lang.Object associatePublicIpAddress;
        private final java.lang.String backupId;
        private final java.lang.Number backupRetentionCount;
        private final java.lang.String customCertificate;
        private final java.lang.String customDomain;
        private final java.lang.String customPrivateKey;
        private final java.lang.Object disableAutomatedBackup;
        private final java.lang.String engine;
        private final java.lang.Object engineAttributes;
        private final java.lang.String engineModel;
        private final java.lang.String engineVersion;
        private final java.lang.String keyPair;
        private final java.lang.String preferredBackupWindow;
        private final java.lang.String preferredMaintenanceWindow;
        private final java.util.List<java.lang.String> securityGroupIds;
        private final java.lang.String serverName;
        private final java.util.List<java.lang.String> subnetIds;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.instanceProfileArn = software.amazon.jsii.Kernel.get(this, "instanceProfileArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.instanceType = software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.serviceRoleArn = software.amazon.jsii.Kernel.get(this, "serviceRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.associatePublicIpAddress = software.amazon.jsii.Kernel.get(this, "associatePublicIpAddress", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.backupId = software.amazon.jsii.Kernel.get(this, "backupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.backupRetentionCount = software.amazon.jsii.Kernel.get(this, "backupRetentionCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.customCertificate = software.amazon.jsii.Kernel.get(this, "customCertificate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.customDomain = software.amazon.jsii.Kernel.get(this, "customDomain", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.customPrivateKey = software.amazon.jsii.Kernel.get(this, "customPrivateKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.disableAutomatedBackup = software.amazon.jsii.Kernel.get(this, "disableAutomatedBackup", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.engine = software.amazon.jsii.Kernel.get(this, "engine", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.engineAttributes = software.amazon.jsii.Kernel.get(this, "engineAttributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.engineModel = software.amazon.jsii.Kernel.get(this, "engineModel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.engineVersion = software.amazon.jsii.Kernel.get(this, "engineVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.keyPair = software.amazon.jsii.Kernel.get(this, "keyPair", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.preferredBackupWindow = software.amazon.jsii.Kernel.get(this, "preferredBackupWindow", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.preferredMaintenanceWindow = software.amazon.jsii.Kernel.get(this, "preferredMaintenanceWindow", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.securityGroupIds = software.amazon.jsii.Kernel.get(this, "securityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.serverName = software.amazon.jsii.Kernel.get(this, "serverName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.subnetIds = software.amazon.jsii.Kernel.get(this, "subnetIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.instanceProfileArn = java.util.Objects.requireNonNull(builder.instanceProfileArn, "instanceProfileArn is required");
            this.instanceType = java.util.Objects.requireNonNull(builder.instanceType, "instanceType is required");
            this.serviceRoleArn = java.util.Objects.requireNonNull(builder.serviceRoleArn, "serviceRoleArn is required");
            this.associatePublicIpAddress = builder.associatePublicIpAddress;
            this.backupId = builder.backupId;
            this.backupRetentionCount = builder.backupRetentionCount;
            this.customCertificate = builder.customCertificate;
            this.customDomain = builder.customDomain;
            this.customPrivateKey = builder.customPrivateKey;
            this.disableAutomatedBackup = builder.disableAutomatedBackup;
            this.engine = builder.engine;
            this.engineAttributes = builder.engineAttributes;
            this.engineModel = builder.engineModel;
            this.engineVersion = builder.engineVersion;
            this.keyPair = builder.keyPair;
            this.preferredBackupWindow = builder.preferredBackupWindow;
            this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
            this.securityGroupIds = builder.securityGroupIds;
            this.serverName = builder.serverName;
            this.subnetIds = builder.subnetIds;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getInstanceProfileArn() {
            return this.instanceProfileArn;
        }

        @Override
        public final java.lang.String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final java.lang.String getServiceRoleArn() {
            return this.serviceRoleArn;
        }

        @Override
        public final java.lang.Object getAssociatePublicIpAddress() {
            return this.associatePublicIpAddress;
        }

        @Override
        public final java.lang.String getBackupId() {
            return this.backupId;
        }

        @Override
        public final java.lang.Number getBackupRetentionCount() {
            return this.backupRetentionCount;
        }

        @Override
        public final java.lang.String getCustomCertificate() {
            return this.customCertificate;
        }

        @Override
        public final java.lang.String getCustomDomain() {
            return this.customDomain;
        }

        @Override
        public final java.lang.String getCustomPrivateKey() {
            return this.customPrivateKey;
        }

        @Override
        public final java.lang.Object getDisableAutomatedBackup() {
            return this.disableAutomatedBackup;
        }

        @Override
        public final java.lang.String getEngine() {
            return this.engine;
        }

        @Override
        public final java.lang.Object getEngineAttributes() {
            return this.engineAttributes;
        }

        @Override
        public final java.lang.String getEngineModel() {
            return this.engineModel;
        }

        @Override
        public final java.lang.String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final java.lang.String getKeyPair() {
            return this.keyPair;
        }

        @Override
        public final java.lang.String getPreferredBackupWindow() {
            return this.preferredBackupWindow;
        }

        @Override
        public final java.lang.String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        @Override
        public final java.util.List<java.lang.String> getSecurityGroupIds() {
            return this.securityGroupIds;
        }

        @Override
        public final java.lang.String getServerName() {
            return this.serverName;
        }

        @Override
        public final java.util.List<java.lang.String> getSubnetIds() {
            return this.subnetIds;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("instanceProfileArn", om.valueToTree(this.getInstanceProfileArn()));
            data.set("instanceType", om.valueToTree(this.getInstanceType()));
            data.set("serviceRoleArn", om.valueToTree(this.getServiceRoleArn()));
            if (this.getAssociatePublicIpAddress() != null) {
                data.set("associatePublicIpAddress", om.valueToTree(this.getAssociatePublicIpAddress()));
            }
            if (this.getBackupId() != null) {
                data.set("backupId", om.valueToTree(this.getBackupId()));
            }
            if (this.getBackupRetentionCount() != null) {
                data.set("backupRetentionCount", om.valueToTree(this.getBackupRetentionCount()));
            }
            if (this.getCustomCertificate() != null) {
                data.set("customCertificate", om.valueToTree(this.getCustomCertificate()));
            }
            if (this.getCustomDomain() != null) {
                data.set("customDomain", om.valueToTree(this.getCustomDomain()));
            }
            if (this.getCustomPrivateKey() != null) {
                data.set("customPrivateKey", om.valueToTree(this.getCustomPrivateKey()));
            }
            if (this.getDisableAutomatedBackup() != null) {
                data.set("disableAutomatedBackup", om.valueToTree(this.getDisableAutomatedBackup()));
            }
            if (this.getEngine() != null) {
                data.set("engine", om.valueToTree(this.getEngine()));
            }
            if (this.getEngineAttributes() != null) {
                data.set("engineAttributes", om.valueToTree(this.getEngineAttributes()));
            }
            if (this.getEngineModel() != null) {
                data.set("engineModel", om.valueToTree(this.getEngineModel()));
            }
            if (this.getEngineVersion() != null) {
                data.set("engineVersion", om.valueToTree(this.getEngineVersion()));
            }
            if (this.getKeyPair() != null) {
                data.set("keyPair", om.valueToTree(this.getKeyPair()));
            }
            if (this.getPreferredBackupWindow() != null) {
                data.set("preferredBackupWindow", om.valueToTree(this.getPreferredBackupWindow()));
            }
            if (this.getPreferredMaintenanceWindow() != null) {
                data.set("preferredMaintenanceWindow", om.valueToTree(this.getPreferredMaintenanceWindow()));
            }
            if (this.getSecurityGroupIds() != null) {
                data.set("securityGroupIds", om.valueToTree(this.getSecurityGroupIds()));
            }
            if (this.getServerName() != null) {
                data.set("serverName", om.valueToTree(this.getServerName()));
            }
            if (this.getSubnetIds() != null) {
                data.set("subnetIds", om.valueToTree(this.getSubnetIds()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_opsworkscm.CfnServerProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnServerProps.Jsii$Proxy that = (CfnServerProps.Jsii$Proxy) o;

            if (!instanceProfileArn.equals(that.instanceProfileArn)) return false;
            if (!instanceType.equals(that.instanceType)) return false;
            if (!serviceRoleArn.equals(that.serviceRoleArn)) return false;
            if (this.associatePublicIpAddress != null ? !this.associatePublicIpAddress.equals(that.associatePublicIpAddress) : that.associatePublicIpAddress != null) return false;
            if (this.backupId != null ? !this.backupId.equals(that.backupId) : that.backupId != null) return false;
            if (this.backupRetentionCount != null ? !this.backupRetentionCount.equals(that.backupRetentionCount) : that.backupRetentionCount != null) return false;
            if (this.customCertificate != null ? !this.customCertificate.equals(that.customCertificate) : that.customCertificate != null) return false;
            if (this.customDomain != null ? !this.customDomain.equals(that.customDomain) : that.customDomain != null) return false;
            if (this.customPrivateKey != null ? !this.customPrivateKey.equals(that.customPrivateKey) : that.customPrivateKey != null) return false;
            if (this.disableAutomatedBackup != null ? !this.disableAutomatedBackup.equals(that.disableAutomatedBackup) : that.disableAutomatedBackup != null) return false;
            if (this.engine != null ? !this.engine.equals(that.engine) : that.engine != null) return false;
            if (this.engineAttributes != null ? !this.engineAttributes.equals(that.engineAttributes) : that.engineAttributes != null) return false;
            if (this.engineModel != null ? !this.engineModel.equals(that.engineModel) : that.engineModel != null) return false;
            if (this.engineVersion != null ? !this.engineVersion.equals(that.engineVersion) : that.engineVersion != null) return false;
            if (this.keyPair != null ? !this.keyPair.equals(that.keyPair) : that.keyPair != null) return false;
            if (this.preferredBackupWindow != null ? !this.preferredBackupWindow.equals(that.preferredBackupWindow) : that.preferredBackupWindow != null) return false;
            if (this.preferredMaintenanceWindow != null ? !this.preferredMaintenanceWindow.equals(that.preferredMaintenanceWindow) : that.preferredMaintenanceWindow != null) return false;
            if (this.securityGroupIds != null ? !this.securityGroupIds.equals(that.securityGroupIds) : that.securityGroupIds != null) return false;
            if (this.serverName != null ? !this.serverName.equals(that.serverName) : that.serverName != null) return false;
            if (this.subnetIds != null ? !this.subnetIds.equals(that.subnetIds) : that.subnetIds != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.instanceProfileArn.hashCode();
            result = 31 * result + (this.instanceType.hashCode());
            result = 31 * result + (this.serviceRoleArn.hashCode());
            result = 31 * result + (this.associatePublicIpAddress != null ? this.associatePublicIpAddress.hashCode() : 0);
            result = 31 * result + (this.backupId != null ? this.backupId.hashCode() : 0);
            result = 31 * result + (this.backupRetentionCount != null ? this.backupRetentionCount.hashCode() : 0);
            result = 31 * result + (this.customCertificate != null ? this.customCertificate.hashCode() : 0);
            result = 31 * result + (this.customDomain != null ? this.customDomain.hashCode() : 0);
            result = 31 * result + (this.customPrivateKey != null ? this.customPrivateKey.hashCode() : 0);
            result = 31 * result + (this.disableAutomatedBackup != null ? this.disableAutomatedBackup.hashCode() : 0);
            result = 31 * result + (this.engine != null ? this.engine.hashCode() : 0);
            result = 31 * result + (this.engineAttributes != null ? this.engineAttributes.hashCode() : 0);
            result = 31 * result + (this.engineModel != null ? this.engineModel.hashCode() : 0);
            result = 31 * result + (this.engineVersion != null ? this.engineVersion.hashCode() : 0);
            result = 31 * result + (this.keyPair != null ? this.keyPair.hashCode() : 0);
            result = 31 * result + (this.preferredBackupWindow != null ? this.preferredBackupWindow.hashCode() : 0);
            result = 31 * result + (this.preferredMaintenanceWindow != null ? this.preferredMaintenanceWindow.hashCode() : 0);
            result = 31 * result + (this.securityGroupIds != null ? this.securityGroupIds.hashCode() : 0);
            result = 31 * result + (this.serverName != null ? this.serverName.hashCode() : 0);
            result = 31 * result + (this.subnetIds != null ? this.subnetIds.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
