package software.amazon.awscdk.services.opsworks;

/**
 * http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.opsworks.*;
 * Object customJson;
 * CfnStack cfnStack = CfnStack.Builder.create(this, "MyCfnStack")
 *         .defaultInstanceProfileArn("defaultInstanceProfileArn")
 *         .name("name")
 *         .serviceRoleArn("serviceRoleArn")
 *         // the properties below are optional
 *         .agentVersion("agentVersion")
 *         .attributes(Map.of(
 *                 "attributesKey", "attributes"))
 *         .chefConfiguration(ChefConfigurationProperty.builder()
 *                 .berkshelfVersion("berkshelfVersion")
 *                 .manageBerkshelf(false)
 *                 .build())
 *         .cloneAppIds(List.of("cloneAppIds"))
 *         .clonePermissions(false)
 *         .configurationManager(StackConfigurationManagerProperty.builder()
 *                 .name("name")
 *                 .version("version")
 *                 .build())
 *         .customCookbooksSource(SourceProperty.builder()
 *                 .password("password")
 *                 .revision("revision")
 *                 .sshKey("sshKey")
 *                 .type("type")
 *                 .url("url")
 *                 .username("username")
 *                 .build())
 *         .customJson(customJson)
 *         .defaultAvailabilityZone("defaultAvailabilityZone")
 *         .defaultOs("defaultOs")
 *         .defaultRootDeviceType("defaultRootDeviceType")
 *         .defaultSshKeyName("defaultSshKeyName")
 *         .defaultSubnetId("defaultSubnetId")
 *         .ecsClusterArn("ecsClusterArn")
 *         .elasticIps(List.of(ElasticIpProperty.builder()
 *                 .ip("ip")
 *                 // the properties below are optional
 *                 .name("name")
 *                 .build()))
 *         .hostnameTheme("hostnameTheme")
 *         .rdsDbInstances(List.of(RdsDbInstanceProperty.builder()
 *                 .dbPassword("dbPassword")
 *                 .dbUser("dbUser")
 *                 .rdsDbInstanceArn("rdsDbInstanceArn")
 *                 .build()))
 *         .sourceStackId("sourceStackId")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .useCustomCookbooks(false)
 *         .useOpsworksSecurityGroups(false)
 *         .vpcId("vpcId")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:16.932Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_opsworks.CfnStack")
public class CfnStack extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnStack(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnStack(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.opsworks.CfnStack.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnStack(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.opsworks.CfnStackProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The Amazon Resource Name (ARN) of an IAM profile that is the default profile for all of the stack's EC2 instances.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDefaultInstanceProfileArn() {
        return software.amazon.jsii.Kernel.get(this, "defaultInstanceProfileArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of an IAM profile that is the default profile for all of the stack's EC2 instances.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefaultInstanceProfileArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "defaultInstanceProfileArn", java.util.Objects.requireNonNull(value, "defaultInstanceProfileArn is required"));
    }

    /**
     * The stack name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The stack name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * The stack's IAM role, which allows AWS OpsWorks Stacks to work with AWS resources on your behalf.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getServiceRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "serviceRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The stack's IAM role, which allows AWS OpsWorks Stacks to work with AWS resources on your behalf.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setServiceRoleArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "serviceRoleArn", java.util.Objects.requireNonNull(value, "serviceRoleArn is required"));
    }

    /**
     * The default AWS OpsWorks Stacks agent version.
     * <p>
     * You have the following options:.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAgentVersion() {
        return software.amazon.jsii.Kernel.get(this, "agentVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The default AWS OpsWorks Stacks agent version.
     * <p>
     * You have the following options:.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAgentVersion(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "agentVersion", value);
    }

    /**
     * One or more user-defined key-value pairs to be added to the stack attributes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAttributes() {
        return software.amazon.jsii.Kernel.get(this, "attributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * One or more user-defined key-value pairs to be added to the stack attributes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAttributes(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "attributes", value);
    }

    /**
     * One or more user-defined key-value pairs to be added to the stack attributes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAttributes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "attributes", value);
    }

    /**
     * A <code>ChefConfiguration</code> object that specifies whether to enable Berkshelf and the Berkshelf version on Chef 11.10 stacks. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New Stack</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getChefConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "chefConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A <code>ChefConfiguration</code> object that specifies whether to enable Berkshelf and the Berkshelf version on Chef 11.10 stacks. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New Stack</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setChefConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "chefConfiguration", value);
    }

    /**
     * A <code>ChefConfiguration</code> object that specifies whether to enable Berkshelf and the Berkshelf version on Chef 11.10 stacks. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New Stack</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setChefConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.opsworks.CfnStack.ChefConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "chefConfiguration", value);
    }

    /**
     * If you're cloning an AWS OpsWorks stack, a list of AWS OpsWorks application stack IDs from the source stack to include in the cloned stack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCloneAppIds() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "cloneAppIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * If you're cloning an AWS OpsWorks stack, a list of AWS OpsWorks application stack IDs from the source stack to include in the cloned stack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCloneAppIds(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "cloneAppIds", value);
    }

    /**
     * If you're cloning an AWS OpsWorks stack, indicates whether to clone the source stack's permissions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getClonePermissions() {
        return software.amazon.jsii.Kernel.get(this, "clonePermissions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * If you're cloning an AWS OpsWorks stack, indicates whether to clone the source stack's permissions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setClonePermissions(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "clonePermissions", value);
    }

    /**
     * If you're cloning an AWS OpsWorks stack, indicates whether to clone the source stack's permissions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setClonePermissions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "clonePermissions", value);
    }

    /**
     * The configuration manager.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getConfigurationManager() {
        return software.amazon.jsii.Kernel.get(this, "configurationManager", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The configuration manager.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfigurationManager(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "configurationManager", value);
    }

    /**
     * The configuration manager.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfigurationManager(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.opsworks.CfnStack.StackConfigurationManagerProperty value) {
        software.amazon.jsii.Kernel.set(this, "configurationManager", value);
    }

    /**
     * Contains the information required to retrieve an app or cookbook from a repository.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCustomCookbooksSource() {
        return software.amazon.jsii.Kernel.get(this, "customCookbooksSource", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Contains the information required to retrieve an app or cookbook from a repository.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCustomCookbooksSource(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "customCookbooksSource", value);
    }

    /**
     * Contains the information required to retrieve an app or cookbook from a repository.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCustomCookbooksSource(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.opsworks.CfnStack.SourceProperty value) {
        software.amazon.jsii.Kernel.set(this, "customCookbooksSource", value);
    }

    /**
     * A string that contains user-defined, custom JSON.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCustomJson() {
        return software.amazon.jsii.Kernel.get(this, "customJson", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A string that contains user-defined, custom JSON.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCustomJson(final @org.jetbrains.annotations.Nullable java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "customJson", value);
    }

    /**
     * The stack's default Availability Zone, which must be in the specified region.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDefaultAvailabilityZone() {
        return software.amazon.jsii.Kernel.get(this, "defaultAvailabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The stack's default Availability Zone, which must be in the specified region.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefaultAvailabilityZone(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "defaultAvailabilityZone", value);
    }

    /**
     * The stack's default operating system, which is installed on every instance unless you specify a different operating system when you create the instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDefaultOs() {
        return software.amazon.jsii.Kernel.get(this, "defaultOs", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The stack's default operating system, which is installed on every instance unless you specify a different operating system when you create the instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefaultOs(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "defaultOs", value);
    }

    /**
     * The default root device type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDefaultRootDeviceType() {
        return software.amazon.jsii.Kernel.get(this, "defaultRootDeviceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The default root device type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefaultRootDeviceType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "defaultRootDeviceType", value);
    }

    /**
     * A default Amazon EC2 key pair name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDefaultSshKeyName() {
        return software.amazon.jsii.Kernel.get(this, "defaultSshKeyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A default Amazon EC2 key pair name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefaultSshKeyName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "defaultSshKeyName", value);
    }

    /**
     * The stack's default subnet ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDefaultSubnetId() {
        return software.amazon.jsii.Kernel.get(this, "defaultSubnetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The stack's default subnet ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefaultSubnetId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "defaultSubnetId", value);
    }

    /**
     * The Amazon Resource Name (ARN) of the Amazon Elastic Container Service ( Amazon ECS ) cluster to register with the AWS OpsWorks stack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEcsClusterArn() {
        return software.amazon.jsii.Kernel.get(this, "ecsClusterArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the Amazon Elastic Container Service ( Amazon ECS ) cluster to register with the AWS OpsWorks stack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEcsClusterArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "ecsClusterArn", value);
    }

    /**
     * A list of Elastic IP addresses to register with the AWS OpsWorks stack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getElasticIps() {
        return software.amazon.jsii.Kernel.get(this, "elasticIps", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of Elastic IP addresses to register with the AWS OpsWorks stack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setElasticIps(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "elasticIps", value);
    }

    /**
     * A list of Elastic IP addresses to register with the AWS OpsWorks stack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setElasticIps(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.opsworks.CfnStack.ElasticIpProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.opsworks.CfnStack.ElasticIpProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "elasticIps", value);
    }

    /**
     * The stack's host name theme, with spaces replaced by underscores.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getHostnameTheme() {
        return software.amazon.jsii.Kernel.get(this, "hostnameTheme", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The stack's host name theme, with spaces replaced by underscores.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHostnameTheme(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "hostnameTheme", value);
    }

    /**
     * The Amazon Relational Database Service ( Amazon RDS ) database instance to register with the AWS OpsWorks stack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRdsDbInstances() {
        return software.amazon.jsii.Kernel.get(this, "rdsDbInstances", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The Amazon Relational Database Service ( Amazon RDS ) database instance to register with the AWS OpsWorks stack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRdsDbInstances(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "rdsDbInstances", value);
    }

    /**
     * The Amazon Relational Database Service ( Amazon RDS ) database instance to register with the AWS OpsWorks stack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRdsDbInstances(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.opsworks.CfnStack.RdsDbInstanceProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.opsworks.CfnStack.RdsDbInstanceProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "rdsDbInstances", value);
    }

    /**
     * If you're cloning an AWS OpsWorks stack, the stack ID of the source AWS OpsWorks stack to clone.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSourceStackId() {
        return software.amazon.jsii.Kernel.get(this, "sourceStackId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * If you're cloning an AWS OpsWorks stack, the stack ID of the source AWS OpsWorks stack to clone.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSourceStackId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "sourceStackId", value);
    }

    /**
     * A map that contains tag keys and tag values that are attached to a stack or layer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A map that contains tag keys and tag values that are attached to a stack or layer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }

    /**
     * Whether the stack uses custom cookbooks.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getUseCustomCookbooks() {
        return software.amazon.jsii.Kernel.get(this, "useCustomCookbooks", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Whether the stack uses custom cookbooks.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUseCustomCookbooks(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "useCustomCookbooks", value);
    }

    /**
     * Whether the stack uses custom cookbooks.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUseCustomCookbooks(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "useCustomCookbooks", value);
    }

    /**
     * Whether to associate the AWS OpsWorks Stacks built-in security groups with the stack's layers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getUseOpsworksSecurityGroups() {
        return software.amazon.jsii.Kernel.get(this, "useOpsworksSecurityGroups", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Whether to associate the AWS OpsWorks Stacks built-in security groups with the stack's layers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUseOpsworksSecurityGroups(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "useOpsworksSecurityGroups", value);
    }

    /**
     * Whether to associate the AWS OpsWorks Stacks built-in security groups with the stack's layers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUseOpsworksSecurityGroups(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "useOpsworksSecurityGroups", value);
    }

    /**
     * The ID of the VPC that the stack is to be launched into.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getVpcId() {
        return software.amazon.jsii.Kernel.get(this, "vpcId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the VPC that the stack is to be launched into.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpcId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "vpcId", value);
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.opsworks.*;
     * ChefConfigurationProperty chefConfigurationProperty = ChefConfigurationProperty.builder()
     *         .berkshelfVersion("berkshelfVersion")
     *         .manageBerkshelf(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-chefconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-chefconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_opsworks.CfnStack.ChefConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ChefConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ChefConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Berkshelf version.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-chefconfiguration.html#cfn-opsworks-stack-chefconfiguration-berkshelfversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-chefconfiguration.html#cfn-opsworks-stack-chefconfiguration-berkshelfversion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBerkshelfVersion() {
            return null;
        }

        /**
         * Whether to enable Berkshelf.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-chefconfiguration.html#cfn-opsworks-stack-chefconfiguration-manageberkshelf">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-chefconfiguration.html#cfn-opsworks-stack-chefconfiguration-manageberkshelf</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getManageBerkshelf() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ChefConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ChefConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ChefConfigurationProperty> {
            java.lang.String berkshelfVersion;
            java.lang.Object manageBerkshelf;

            /**
             * Sets the value of {@link ChefConfigurationProperty#getBerkshelfVersion}
             * @param berkshelfVersion The Berkshelf version.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder berkshelfVersion(java.lang.String berkshelfVersion) {
                this.berkshelfVersion = berkshelfVersion;
                return this;
            }

            /**
             * Sets the value of {@link ChefConfigurationProperty#getManageBerkshelf}
             * @param manageBerkshelf Whether to enable Berkshelf.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder manageBerkshelf(java.lang.Boolean manageBerkshelf) {
                this.manageBerkshelf = manageBerkshelf;
                return this;
            }

            /**
             * Sets the value of {@link ChefConfigurationProperty#getManageBerkshelf}
             * @param manageBerkshelf Whether to enable Berkshelf.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder manageBerkshelf(software.amazon.awscdk.IResolvable manageBerkshelf) {
                this.manageBerkshelf = manageBerkshelf;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ChefConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ChefConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ChefConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ChefConfigurationProperty {
            private final java.lang.String berkshelfVersion;
            private final java.lang.Object manageBerkshelf;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.berkshelfVersion = software.amazon.jsii.Kernel.get(this, "berkshelfVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.manageBerkshelf = software.amazon.jsii.Kernel.get(this, "manageBerkshelf", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.berkshelfVersion = builder.berkshelfVersion;
                this.manageBerkshelf = builder.manageBerkshelf;
            }

            @Override
            public final java.lang.String getBerkshelfVersion() {
                return this.berkshelfVersion;
            }

            @Override
            public final java.lang.Object getManageBerkshelf() {
                return this.manageBerkshelf;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBerkshelfVersion() != null) {
                    data.set("berkshelfVersion", om.valueToTree(this.getBerkshelfVersion()));
                }
                if (this.getManageBerkshelf() != null) {
                    data.set("manageBerkshelf", om.valueToTree(this.getManageBerkshelf()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_opsworks.CfnStack.ChefConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ChefConfigurationProperty.Jsii$Proxy that = (ChefConfigurationProperty.Jsii$Proxy) o;

                if (this.berkshelfVersion != null ? !this.berkshelfVersion.equals(that.berkshelfVersion) : that.berkshelfVersion != null) return false;
                return this.manageBerkshelf != null ? this.manageBerkshelf.equals(that.manageBerkshelf) : that.manageBerkshelf == null;
            }

            @Override
            public final int hashCode() {
                int result = this.berkshelfVersion != null ? this.berkshelfVersion.hashCode() : 0;
                result = 31 * result + (this.manageBerkshelf != null ? this.manageBerkshelf.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.opsworks.*;
     * ElasticIpProperty elasticIpProperty = ElasticIpProperty.builder()
     *         .ip("ip")
     *         // the properties below are optional
     *         .name("name")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-elasticip.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-elasticip.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_opsworks.CfnStack.ElasticIpProperty")
    @software.amazon.jsii.Jsii.Proxy(ElasticIpProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ElasticIpProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The IP address.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-elasticip.html#cfn-opsworks-stack-elasticip-ip">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-elasticip.html#cfn-opsworks-stack-elasticip-ip</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getIp();

        /**
         * The name, which can be a maximum of 32 characters.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-elasticip.html#cfn-opsworks-stack-elasticip-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-elasticip.html#cfn-opsworks-stack-elasticip-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ElasticIpProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ElasticIpProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ElasticIpProperty> {
            java.lang.String ip;
            java.lang.String name;

            /**
             * Sets the value of {@link ElasticIpProperty#getIp}
             * @param ip The IP address. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ip(java.lang.String ip) {
                this.ip = ip;
                return this;
            }

            /**
             * Sets the value of {@link ElasticIpProperty#getName}
             * @param name The name, which can be a maximum of 32 characters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ElasticIpProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ElasticIpProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ElasticIpProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ElasticIpProperty {
            private final java.lang.String ip;
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.ip = software.amazon.jsii.Kernel.get(this, "ip", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.ip = java.util.Objects.requireNonNull(builder.ip, "ip is required");
                this.name = builder.name;
            }

            @Override
            public final java.lang.String getIp() {
                return this.ip;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("ip", om.valueToTree(this.getIp()));
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_opsworks.CfnStack.ElasticIpProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ElasticIpProperty.Jsii$Proxy that = (ElasticIpProperty.Jsii$Proxy) o;

                if (!ip.equals(that.ip)) return false;
                return this.name != null ? this.name.equals(that.name) : that.name == null;
            }

            @Override
            public final int hashCode() {
                int result = this.ip.hashCode();
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.opsworks.*;
     * RdsDbInstanceProperty rdsDbInstanceProperty = RdsDbInstanceProperty.builder()
     *         .dbPassword("dbPassword")
     *         .dbUser("dbUser")
     *         .rdsDbInstanceArn("rdsDbInstanceArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-rdsdbinstance.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-rdsdbinstance.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_opsworks.CfnStack.RdsDbInstanceProperty")
    @software.amazon.jsii.Jsii.Proxy(RdsDbInstanceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RdsDbInstanceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * AWS OpsWorks Stacks returns <code>*****FILTERED*****</code> instead of the actual value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-rdsdbinstance.html#cfn-opsworks-stack-rdsdbinstance-dbpassword">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-rdsdbinstance.html#cfn-opsworks-stack-rdsdbinstance-dbpassword</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDbPassword();

        /**
         * The master user name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-rdsdbinstance.html#cfn-opsworks-stack-rdsdbinstance-dbuser">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-rdsdbinstance.html#cfn-opsworks-stack-rdsdbinstance-dbuser</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDbUser();

        /**
         * The instance's ARN.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-rdsdbinstance.html#cfn-opsworks-stack-rdsdbinstance-rdsdbinstancearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-rdsdbinstance.html#cfn-opsworks-stack-rdsdbinstance-rdsdbinstancearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRdsDbInstanceArn();

        /**
         * @return a {@link Builder} of {@link RdsDbInstanceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RdsDbInstanceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RdsDbInstanceProperty> {
            java.lang.String dbPassword;
            java.lang.String dbUser;
            java.lang.String rdsDbInstanceArn;

            /**
             * Sets the value of {@link RdsDbInstanceProperty#getDbPassword}
             * @param dbPassword AWS OpsWorks Stacks returns <code>*****FILTERED*****</code> instead of the actual value. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dbPassword(java.lang.String dbPassword) {
                this.dbPassword = dbPassword;
                return this;
            }

            /**
             * Sets the value of {@link RdsDbInstanceProperty#getDbUser}
             * @param dbUser The master user name. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dbUser(java.lang.String dbUser) {
                this.dbUser = dbUser;
                return this;
            }

            /**
             * Sets the value of {@link RdsDbInstanceProperty#getRdsDbInstanceArn}
             * @param rdsDbInstanceArn The instance's ARN. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rdsDbInstanceArn(java.lang.String rdsDbInstanceArn) {
                this.rdsDbInstanceArn = rdsDbInstanceArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RdsDbInstanceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RdsDbInstanceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RdsDbInstanceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RdsDbInstanceProperty {
            private final java.lang.String dbPassword;
            private final java.lang.String dbUser;
            private final java.lang.String rdsDbInstanceArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dbPassword = software.amazon.jsii.Kernel.get(this, "dbPassword", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dbUser = software.amazon.jsii.Kernel.get(this, "dbUser", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.rdsDbInstanceArn = software.amazon.jsii.Kernel.get(this, "rdsDbInstanceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dbPassword = java.util.Objects.requireNonNull(builder.dbPassword, "dbPassword is required");
                this.dbUser = java.util.Objects.requireNonNull(builder.dbUser, "dbUser is required");
                this.rdsDbInstanceArn = java.util.Objects.requireNonNull(builder.rdsDbInstanceArn, "rdsDbInstanceArn is required");
            }

            @Override
            public final java.lang.String getDbPassword() {
                return this.dbPassword;
            }

            @Override
            public final java.lang.String getDbUser() {
                return this.dbUser;
            }

            @Override
            public final java.lang.String getRdsDbInstanceArn() {
                return this.rdsDbInstanceArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("dbPassword", om.valueToTree(this.getDbPassword()));
                data.set("dbUser", om.valueToTree(this.getDbUser()));
                data.set("rdsDbInstanceArn", om.valueToTree(this.getRdsDbInstanceArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_opsworks.CfnStack.RdsDbInstanceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RdsDbInstanceProperty.Jsii$Proxy that = (RdsDbInstanceProperty.Jsii$Proxy) o;

                if (!dbPassword.equals(that.dbPassword)) return false;
                if (!dbUser.equals(that.dbUser)) return false;
                return this.rdsDbInstanceArn.equals(that.rdsDbInstanceArn);
            }

            @Override
            public final int hashCode() {
                int result = this.dbPassword.hashCode();
                result = 31 * result + (this.dbUser.hashCode());
                result = 31 * result + (this.rdsDbInstanceArn.hashCode());
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.opsworks.*;
     * SourceProperty sourceProperty = SourceProperty.builder()
     *         .password("password")
     *         .revision("revision")
     *         .sshKey("sshKey")
     *         .type("type")
     *         .url("url")
     *         .username("username")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-source.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-source.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_opsworks.CfnStack.SourceProperty")
    @software.amazon.jsii.Jsii.Proxy(SourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * When included in a request, the parameter depends on the repository type.
         * <p>
         * <ul>
         * <li>For Amazon S3 bundles, set <code>Password</code> to the appropriate IAM secret access key.</li>
         * <li>For HTTP bundles and Subversion repositories, set <code>Password</code> to the password.</li>
         * </ul>
         * <p>
         * For more information on how to safely handle IAM credentials, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-access-keys-best-practices.html"></a> .
         * <p>
         * In responses, AWS OpsWorks Stacks returns <code>*****FILTERED*****</code> instead of the actual value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-source.html#cfn-opsworks-stack-source-password">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-source.html#cfn-opsworks-stack-source-password</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPassword() {
            return null;
        }

        /**
         * The application's version.
         * <p>
         * AWS OpsWorks Stacks enables you to easily deploy new versions of an application. One of the simplest approaches is to have branches or revisions in your repository that represent different versions that can potentially be deployed.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-source.html#cfn-opsworks-stack-source-revision">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-source.html#cfn-opsworks-stack-source-revision</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRevision() {
            return null;
        }

        /**
         * The repository's SSH key.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-deploykeys.html">Using Git Repository SSH Keys</a> in the <em>AWS OpsWorks User Guide</em> . To pass in an SSH key as a parameter, see the following example:
         * <p>
         * <code>"Parameters" : { "GitSSHKey" : { "Description" : "Change SSH key newlines to commas.", "Type" : "CommaDelimitedList", "NoEcho" : "true" }, ... "CustomCookbooksSource": { "Revision" : { "Ref": "GitRevision"}, "SshKey" : { "Fn::Join" : [ "\n", { "Ref": "GitSSHKey"} ] }, "Type": "git", "Url": { "Ref": "GitURL"} } ...</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-source.html#cfn-opsworks-stack-source-sshkey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-source.html#cfn-opsworks-stack-source-sshkey</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSshKey() {
            return null;
        }

        /**
         * The repository type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-source.html#cfn-opsworks-stack-source-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-source.html#cfn-opsworks-stack-source-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getType() {
            return null;
        }

        /**
         * The source URL.
         * <p>
         * The following is an example of an Amazon S3 source URL: <code>https://s3.amazonaws.com/opsworks-demo-bucket/opsworks_cookbook_demo.tar.gz</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-source.html#cfn-opsworks-stack-source-url">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-source.html#cfn-opsworks-stack-source-url</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUrl() {
            return null;
        }

        /**
         * This parameter depends on the repository type.
         * <p>
         * <ul>
         * <li>For Amazon S3 bundles, set <code>Username</code> to the appropriate IAM access key ID.</li>
         * <li>For HTTP bundles, Git repositories, and Subversion repositories, set <code>Username</code> to the user name.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-source.html#cfn-opsworks-stack-source-username">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-source.html#cfn-opsworks-stack-source-username</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUsername() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SourceProperty> {
            java.lang.String password;
            java.lang.String revision;
            java.lang.String sshKey;
            java.lang.String type;
            java.lang.String url;
            java.lang.String username;

            /**
             * Sets the value of {@link SourceProperty#getPassword}
             * @param password When included in a request, the parameter depends on the repository type.
             *                 <ul>
             *                 <li>For Amazon S3 bundles, set <code>Password</code> to the appropriate IAM secret access key.</li>
             *                 <li>For HTTP bundles and Subversion repositories, set <code>Password</code> to the password.</li>
             *                 </ul>
             *                 <p>
             *                 For more information on how to safely handle IAM credentials, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-access-keys-best-practices.html"></a> .
             *                 <p>
             *                 In responses, AWS OpsWorks Stacks returns <code>*****FILTERED*****</code> instead of the actual value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder password(java.lang.String password) {
                this.password = password;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getRevision}
             * @param revision The application's version.
             *                 AWS OpsWorks Stacks enables you to easily deploy new versions of an application. One of the simplest approaches is to have branches or revisions in your repository that represent different versions that can potentially be deployed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder revision(java.lang.String revision) {
                this.revision = revision;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getSshKey}
             * @param sshKey The repository's SSH key.
             *               For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-deploykeys.html">Using Git Repository SSH Keys</a> in the <em>AWS OpsWorks User Guide</em> . To pass in an SSH key as a parameter, see the following example:
             *               <p>
             *               <code>"Parameters" : { "GitSSHKey" : { "Description" : "Change SSH key newlines to commas.", "Type" : "CommaDelimitedList", "NoEcho" : "true" }, ... "CustomCookbooksSource": { "Revision" : { "Ref": "GitRevision"}, "SshKey" : { "Fn::Join" : [ "\n", { "Ref": "GitSSHKey"} ] }, "Type": "git", "Url": { "Ref": "GitURL"} } ...</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sshKey(java.lang.String sshKey) {
                this.sshKey = sshKey;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getType}
             * @param type The repository type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getUrl}
             * @param url The source URL.
             *            The following is an example of an Amazon S3 source URL: <code>https://s3.amazonaws.com/opsworks-demo-bucket/opsworks_cookbook_demo.tar.gz</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder url(java.lang.String url) {
                this.url = url;
                return this;
            }

            /**
             * Sets the value of {@link SourceProperty#getUsername}
             * @param username This parameter depends on the repository type.
             *                 <ul>
             *                 <li>For Amazon S3 bundles, set <code>Username</code> to the appropriate IAM access key ID.</li>
             *                 <li>For HTTP bundles, Git repositories, and Subversion repositories, set <code>Username</code> to the user name.</li>
             *                 </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder username(java.lang.String username) {
                this.username = username;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SourceProperty {
            private final java.lang.String password;
            private final java.lang.String revision;
            private final java.lang.String sshKey;
            private final java.lang.String type;
            private final java.lang.String url;
            private final java.lang.String username;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.password = software.amazon.jsii.Kernel.get(this, "password", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.revision = software.amazon.jsii.Kernel.get(this, "revision", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sshKey = software.amazon.jsii.Kernel.get(this, "sshKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.url = software.amazon.jsii.Kernel.get(this, "url", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.username = software.amazon.jsii.Kernel.get(this, "username", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.password = builder.password;
                this.revision = builder.revision;
                this.sshKey = builder.sshKey;
                this.type = builder.type;
                this.url = builder.url;
                this.username = builder.username;
            }

            @Override
            public final java.lang.String getPassword() {
                return this.password;
            }

            @Override
            public final java.lang.String getRevision() {
                return this.revision;
            }

            @Override
            public final java.lang.String getSshKey() {
                return this.sshKey;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.String getUrl() {
                return this.url;
            }

            @Override
            public final java.lang.String getUsername() {
                return this.username;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getPassword() != null) {
                    data.set("password", om.valueToTree(this.getPassword()));
                }
                if (this.getRevision() != null) {
                    data.set("revision", om.valueToTree(this.getRevision()));
                }
                if (this.getSshKey() != null) {
                    data.set("sshKey", om.valueToTree(this.getSshKey()));
                }
                if (this.getType() != null) {
                    data.set("type", om.valueToTree(this.getType()));
                }
                if (this.getUrl() != null) {
                    data.set("url", om.valueToTree(this.getUrl()));
                }
                if (this.getUsername() != null) {
                    data.set("username", om.valueToTree(this.getUsername()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_opsworks.CfnStack.SourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SourceProperty.Jsii$Proxy that = (SourceProperty.Jsii$Proxy) o;

                if (this.password != null ? !this.password.equals(that.password) : that.password != null) return false;
                if (this.revision != null ? !this.revision.equals(that.revision) : that.revision != null) return false;
                if (this.sshKey != null ? !this.sshKey.equals(that.sshKey) : that.sshKey != null) return false;
                if (this.type != null ? !this.type.equals(that.type) : that.type != null) return false;
                if (this.url != null ? !this.url.equals(that.url) : that.url != null) return false;
                return this.username != null ? this.username.equals(that.username) : that.username == null;
            }

            @Override
            public final int hashCode() {
                int result = this.password != null ? this.password.hashCode() : 0;
                result = 31 * result + (this.revision != null ? this.revision.hashCode() : 0);
                result = 31 * result + (this.sshKey != null ? this.sshKey.hashCode() : 0);
                result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
                result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
                result = 31 * result + (this.username != null ? this.username.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.opsworks.*;
     * StackConfigurationManagerProperty stackConfigurationManagerProperty = StackConfigurationManagerProperty.builder()
     *         .name("name")
     *         .version("version")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-stackconfigurationmanager.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-stackconfigurationmanager.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_opsworks.CfnStack.StackConfigurationManagerProperty")
    @software.amazon.jsii.Jsii.Proxy(StackConfigurationManagerProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StackConfigurationManagerProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name.
         * <p>
         * This parameter must be set to <code>Chef</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-stackconfigurationmanager.html#cfn-opsworks-stack-stackconfigurationmanager-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-stackconfigurationmanager.html#cfn-opsworks-stack-stackconfigurationmanager-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * The Chef version.
         * <p>
         * This parameter must be set to 12, 11.10, or 11.4 for Linux stacks, and to 12.2 for Windows stacks. The default value for Linux stacks is 12.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-stackconfigurationmanager.html#cfn-opsworks-stack-stackconfigurationmanager-version">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opsworks-stack-stackconfigurationmanager.html#cfn-opsworks-stack-stackconfigurationmanager-version</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVersion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link StackConfigurationManagerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StackConfigurationManagerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StackConfigurationManagerProperty> {
            java.lang.String name;
            java.lang.String version;

            /**
             * Sets the value of {@link StackConfigurationManagerProperty#getName}
             * @param name The name.
             *             This parameter must be set to <code>Chef</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link StackConfigurationManagerProperty#getVersion}
             * @param version The Chef version.
             *                This parameter must be set to 12, 11.10, or 11.4 for Linux stacks, and to 12.2 for Windows stacks. The default value for Linux stacks is 12.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder version(java.lang.String version) {
                this.version = version;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StackConfigurationManagerProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StackConfigurationManagerProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StackConfigurationManagerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StackConfigurationManagerProperty {
            private final java.lang.String name;
            private final java.lang.String version;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.version = software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = builder.name;
                this.version = builder.version;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getVersion() {
                return this.version;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getVersion() != null) {
                    data.set("version", om.valueToTree(this.getVersion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_opsworks.CfnStack.StackConfigurationManagerProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StackConfigurationManagerProperty.Jsii$Proxy that = (StackConfigurationManagerProperty.Jsii$Proxy) o;

                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                return this.version != null ? this.version.equals(that.version) : that.version == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name != null ? this.name.hashCode() : 0;
                result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.opsworks.CfnStack}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.opsworks.CfnStack> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.opsworks.CfnStackProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.opsworks.CfnStackProps.Builder();
        }

        /**
         * The Amazon Resource Name (ARN) of an IAM profile that is the default profile for all of the stack's EC2 instances.
         * <p>
         * For more information about IAM ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-defaultinstanceprofilearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-defaultinstanceprofilearn</a>
         * @param defaultInstanceProfileArn The Amazon Resource Name (ARN) of an IAM profile that is the default profile for all of the stack's EC2 instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultInstanceProfileArn(final java.lang.String defaultInstanceProfileArn) {
            this.props.defaultInstanceProfileArn(defaultInstanceProfileArn);
            return this;
        }

        /**
         * The stack name.
         * <p>
         * Stack names can be a maximum of 64 characters.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-name</a>
         * @param name The stack name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The stack's IAM role, which allows AWS OpsWorks Stacks to work with AWS resources on your behalf.
         * <p>
         * You must set this parameter to the Amazon Resource Name (ARN) for an existing IAM role. For more information about IAM ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-servicerolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-servicerolearn</a>
         * @param serviceRoleArn The stack's IAM role, which allows AWS OpsWorks Stacks to work with AWS resources on your behalf. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceRoleArn(final java.lang.String serviceRoleArn) {
            this.props.serviceRoleArn(serviceRoleArn);
            return this;
        }

        /**
         * The default AWS OpsWorks Stacks agent version. You have the following options:.
         * <p>
         * <ul>
         * <li>Auto-update - Set this parameter to <code>LATEST</code> . AWS OpsWorks Stacks automatically installs new agent versions on the stack's instances as soon as they are available.</li>
         * <li>Fixed version - Set this parameter to your preferred agent version. To update the agent version, you must edit the stack configuration and specify a new version. AWS OpsWorks Stacks installs that version on the stack's instances.</li>
         * </ul>
         * <p>
         * The default setting is the most recent release of the agent. To specify an agent version, you must use the complete version number, not the abbreviated number shown on the console. For a list of available agent version numbers, call <code>DescribeAgentVersions</code> . AgentVersion cannot be set to Chef 12.2.
         * <p>
         * <blockquote>
         * <p>
         * You can also specify an agent version when you create or update an instance, which overrides the stack's default setting.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-agentversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-agentversion</a>
         * @param agentVersion The default AWS OpsWorks Stacks agent version. You have the following options:. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder agentVersion(final java.lang.String agentVersion) {
            this.props.agentVersion(agentVersion);
            return this;
        }

        /**
         * One or more user-defined key-value pairs to be added to the stack attributes.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-attributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-attributes</a>
         * @param attributes One or more user-defined key-value pairs to be added to the stack attributes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder attributes(final java.util.Map<java.lang.String, java.lang.String> attributes) {
            this.props.attributes(attributes);
            return this;
        }
        /**
         * One or more user-defined key-value pairs to be added to the stack attributes.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-attributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-attributes</a>
         * @param attributes One or more user-defined key-value pairs to be added to the stack attributes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder attributes(final software.amazon.awscdk.IResolvable attributes) {
            this.props.attributes(attributes);
            return this;
        }

        /**
         * A <code>ChefConfiguration</code> object that specifies whether to enable Berkshelf and the Berkshelf version on Chef 11.10 stacks. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New Stack</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-chefconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-chefconfiguration</a>
         * @param chefConfiguration A <code>ChefConfiguration</code> object that specifies whether to enable Berkshelf and the Berkshelf version on Chef 11.10 stacks. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New Stack</a> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder chefConfiguration(final software.amazon.awscdk.IResolvable chefConfiguration) {
            this.props.chefConfiguration(chefConfiguration);
            return this;
        }
        /**
         * A <code>ChefConfiguration</code> object that specifies whether to enable Berkshelf and the Berkshelf version on Chef 11.10 stacks. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New Stack</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-chefconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-chefconfiguration</a>
         * @param chefConfiguration A <code>ChefConfiguration</code> object that specifies whether to enable Berkshelf and the Berkshelf version on Chef 11.10 stacks. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New Stack</a> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder chefConfiguration(final software.amazon.awscdk.services.opsworks.CfnStack.ChefConfigurationProperty chefConfiguration) {
            this.props.chefConfiguration(chefConfiguration);
            return this;
        }

        /**
         * If you're cloning an AWS OpsWorks stack, a list of AWS OpsWorks application stack IDs from the source stack to include in the cloned stack.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-cloneappids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-cloneappids</a>
         * @param cloneAppIds If you're cloning an AWS OpsWorks stack, a list of AWS OpsWorks application stack IDs from the source stack to include in the cloned stack. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloneAppIds(final java.util.List<java.lang.String> cloneAppIds) {
            this.props.cloneAppIds(cloneAppIds);
            return this;
        }

        /**
         * If you're cloning an AWS OpsWorks stack, indicates whether to clone the source stack's permissions.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-clonepermissions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-clonepermissions</a>
         * @param clonePermissions If you're cloning an AWS OpsWorks stack, indicates whether to clone the source stack's permissions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clonePermissions(final java.lang.Boolean clonePermissions) {
            this.props.clonePermissions(clonePermissions);
            return this;
        }
        /**
         * If you're cloning an AWS OpsWorks stack, indicates whether to clone the source stack's permissions.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-clonepermissions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-clonepermissions</a>
         * @param clonePermissions If you're cloning an AWS OpsWorks stack, indicates whether to clone the source stack's permissions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clonePermissions(final software.amazon.awscdk.IResolvable clonePermissions) {
            this.props.clonePermissions(clonePermissions);
            return this;
        }

        /**
         * The configuration manager.
         * <p>
         * When you create a stack we recommend that you use the configuration manager to specify the Chef version: 12, 11.10, or 11.4 for Linux stacks, or 12.2 for Windows stacks. The default value for Linux stacks is currently 12.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-configurationmanager">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-configurationmanager</a>
         * @param configurationManager The configuration manager. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configurationManager(final software.amazon.awscdk.IResolvable configurationManager) {
            this.props.configurationManager(configurationManager);
            return this;
        }
        /**
         * The configuration manager.
         * <p>
         * When you create a stack we recommend that you use the configuration manager to specify the Chef version: 12, 11.10, or 11.4 for Linux stacks, or 12.2 for Windows stacks. The default value for Linux stacks is currently 12.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-configurationmanager">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-configurationmanager</a>
         * @param configurationManager The configuration manager. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configurationManager(final software.amazon.awscdk.services.opsworks.CfnStack.StackConfigurationManagerProperty configurationManager) {
            this.props.configurationManager(configurationManager);
            return this;
        }

        /**
         * Contains the information required to retrieve an app or cookbook from a repository.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html">Adding Apps</a> or <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook.html">Cookbooks and Recipes</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-customcookbookssource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-customcookbookssource</a>
         * @param customCookbooksSource Contains the information required to retrieve an app or cookbook from a repository. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customCookbooksSource(final software.amazon.awscdk.IResolvable customCookbooksSource) {
            this.props.customCookbooksSource(customCookbooksSource);
            return this;
        }
        /**
         * Contains the information required to retrieve an app or cookbook from a repository.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html">Adding Apps</a> or <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook.html">Cookbooks and Recipes</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-customcookbookssource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-customcookbookssource</a>
         * @param customCookbooksSource Contains the information required to retrieve an app or cookbook from a repository. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customCookbooksSource(final software.amazon.awscdk.services.opsworks.CfnStack.SourceProperty customCookbooksSource) {
            this.props.customCookbooksSource(customCookbooksSource);
            return this;
        }

        /**
         * A string that contains user-defined, custom JSON.
         * <p>
         * It can be used to override the corresponding default stack configuration attribute values or to pass data to recipes. The string should be in the following format:
         * <p>
         * <code>"{\"key1\": \"value1\", \"key2\": \"value2\",...}"</code>
         * <p>
         * For more information about custom JSON, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html">Use Custom JSON to Modify the Stack Configuration Attributes</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-customjson">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-customjson</a>
         * @param customJson A string that contains user-defined, custom JSON. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customJson(final java.lang.Object customJson) {
            this.props.customJson(customJson);
            return this;
        }

        /**
         * The stack's default Availability Zone, which must be in the specified region.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a> . If you also specify a value for <code>DefaultSubnetId</code> , the subnet must be in the same zone. For more information, see the <code>VpcId</code> parameter description.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-defaultavailabilityzone">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-defaultavailabilityzone</a>
         * @param defaultAvailabilityZone The stack's default Availability Zone, which must be in the specified region. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultAvailabilityZone(final java.lang.String defaultAvailabilityZone) {
            this.props.defaultAvailabilityZone(defaultAvailabilityZone);
            return this;
        }

        /**
         * The stack's default operating system, which is installed on every instance unless you specify a different operating system when you create the instance.
         * <p>
         * You can specify one of the following.
         * <p>
         * <ul>
         * <li>A supported Linux operating system: An Amazon Linux version, such as <code>Amazon Linux 2</code> , <code>Amazon Linux 2018.03</code> , <code>Amazon Linux 2017.09</code> , <code>Amazon Linux 2017.03</code> , <code>Amazon Linux 2016.09</code> , <code>Amazon Linux 2016.03</code> , <code>Amazon Linux 2015.09</code> , or <code>Amazon Linux 2015.03</code> .</li>
         * <li>A supported Ubuntu operating system, such as <code>Ubuntu 18.04 LTS</code> , <code>Ubuntu 16.04 LTS</code> , <code>Ubuntu 14.04 LTS</code> , or <code>Ubuntu 12.04 LTS</code> .</li>
         * <li><code>CentOS Linux 7</code></li>
         * <li><code>Red Hat Enterprise Linux 7</code></li>
         * <li>A supported Windows operating system, such as <code>Microsoft Windows Server 2012 R2 Base</code> , <code>Microsoft Windows Server 2012 R2 with SQL Server Express</code> , <code>Microsoft Windows Server 2012 R2 with SQL Server Standard</code> , or <code>Microsoft Windows Server 2012 R2 with SQL Server Web</code> .</li>
         * <li>A custom AMI: <code>Custom</code> . You specify the custom AMI you want to use when you create instances. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html">Using Custom AMIs</a> .</li>
         * </ul>
         * <p>
         * The default option is the current Amazon Linux version. Not all operating systems are supported with all versions of Chef. For more information about supported operating systems, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html">AWS OpsWorks Stacks Operating Systems</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-defaultos">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-defaultos</a>
         * @param defaultOs The stack's default operating system, which is installed on every instance unless you specify a different operating system when you create the instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultOs(final java.lang.String defaultOs) {
            this.props.defaultOs(defaultOs);
            return this;
        }

        /**
         * The default root device type.
         * <p>
         * This value is the default for all instances in the stack, but you can override it when you create an instance. The default option is <code>instance-store</code> . For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device">Storage for the Root Device</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-defaultrootdevicetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-defaultrootdevicetype</a>
         * @param defaultRootDeviceType The default root device type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultRootDeviceType(final java.lang.String defaultRootDeviceType) {
            this.props.defaultRootDeviceType(defaultRootDeviceType);
            return this;
        }

        /**
         * A default Amazon EC2 key pair name.
         * <p>
         * The default value is none. If you specify a key pair name, AWS OpsWorks installs the public key on the instance and you can use the private key with an SSH client to log in to the instance. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-ssh.html">Using SSH to Communicate with an Instance</a> and <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/security-ssh-access.html">Managing SSH Access</a> . You can override this setting by specifying a different key pair, or no key pair, when you <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-add.html">create an instance</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-defaultsshkeyname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-defaultsshkeyname</a>
         * @param defaultSshKeyName A default Amazon EC2 key pair name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultSshKeyName(final java.lang.String defaultSshKeyName) {
            this.props.defaultSshKeyName(defaultSshKeyName);
            return this;
        }

        /**
         * The stack's default subnet ID.
         * <p>
         * All instances are launched into this subnet unless you specify another subnet ID when you create the instance. This parameter is required if you specify a value for the <code>VpcId</code> parameter. If you also specify a value for <code>DefaultAvailabilityZone</code> , the subnet must be in that zone.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-defaultsubnetid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-defaultsubnetid</a>
         * @param defaultSubnetId The stack's default subnet ID. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultSubnetId(final java.lang.String defaultSubnetId) {
            this.props.defaultSubnetId(defaultSubnetId);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the Amazon Elastic Container Service ( Amazon ECS ) cluster to register with the AWS OpsWorks stack.
         * <p>
         * <blockquote>
         * <p>
         * If you specify a cluster that's registered with another AWS OpsWorks stack, AWS CloudFormation deregisters the existing association before registering the cluster.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-ecsclusterarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-ecsclusterarn</a>
         * @param ecsClusterArn The Amazon Resource Name (ARN) of the Amazon Elastic Container Service ( Amazon ECS ) cluster to register with the AWS OpsWorks stack. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ecsClusterArn(final java.lang.String ecsClusterArn) {
            this.props.ecsClusterArn(ecsClusterArn);
            return this;
        }

        /**
         * A list of Elastic IP addresses to register with the AWS OpsWorks stack.
         * <p>
         * <blockquote>
         * <p>
         * If you specify an IP address that's registered with another AWS OpsWorks stack, AWS CloudFormation deregisters the existing association before registering the IP address.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-elasticips">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-elasticips</a>
         * @param elasticIps A list of Elastic IP addresses to register with the AWS OpsWorks stack. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder elasticIps(final software.amazon.awscdk.IResolvable elasticIps) {
            this.props.elasticIps(elasticIps);
            return this;
        }
        /**
         * A list of Elastic IP addresses to register with the AWS OpsWorks stack.
         * <p>
         * <blockquote>
         * <p>
         * If you specify an IP address that's registered with another AWS OpsWorks stack, AWS CloudFormation deregisters the existing association before registering the IP address.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-elasticips">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-elasticips</a>
         * @param elasticIps A list of Elastic IP addresses to register with the AWS OpsWorks stack. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder elasticIps(final java.util.List<? extends java.lang.Object> elasticIps) {
            this.props.elasticIps(elasticIps);
            return this;
        }

        /**
         * The stack's host name theme, with spaces replaced by underscores.
         * <p>
         * The theme is used to generate host names for the stack's instances. By default, <code>HostnameTheme</code> is set to <code>Layer_Dependent</code> , which creates host names by appending integers to the layer's short name. The other themes are:
         * <p>
         * <ul>
         * <li><code>Baked_Goods</code></li>
         * <li><code>Clouds</code></li>
         * <li><code>Europe_Cities</code></li>
         * <li><code>Fruits</code></li>
         * <li><code>Greek_Deities_and_Titans</code></li>
         * <li><code>Legendary_creatures_from_Japan</code></li>
         * <li><code>Planets_and_Moons</code></li>
         * <li><code>Roman_Deities</code></li>
         * <li><code>Scottish_Islands</code></li>
         * <li><code>US_Cities</code></li>
         * <li><code>Wild_Cats</code></li>
         * </ul>
         * <p>
         * To obtain a generated host name, call <code>GetHostNameSuggestion</code> , which returns a host name based on the current theme.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-hostnametheme">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-hostnametheme</a>
         * @param hostnameTheme The stack's host name theme, with spaces replaced by underscores. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostnameTheme(final java.lang.String hostnameTheme) {
            this.props.hostnameTheme(hostnameTheme);
            return this;
        }

        /**
         * The Amazon Relational Database Service ( Amazon RDS ) database instance to register with the AWS OpsWorks stack.
         * <p>
         * <blockquote>
         * <p>
         * If you specify a database instance that's registered with another AWS OpsWorks stack, AWS CloudFormation deregisters the existing association before registering the database instance.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-rdsdbinstances">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-rdsdbinstances</a>
         * @param rdsDbInstances The Amazon Relational Database Service ( Amazon RDS ) database instance to register with the AWS OpsWorks stack. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rdsDbInstances(final software.amazon.awscdk.IResolvable rdsDbInstances) {
            this.props.rdsDbInstances(rdsDbInstances);
            return this;
        }
        /**
         * The Amazon Relational Database Service ( Amazon RDS ) database instance to register with the AWS OpsWorks stack.
         * <p>
         * <blockquote>
         * <p>
         * If you specify a database instance that's registered with another AWS OpsWorks stack, AWS CloudFormation deregisters the existing association before registering the database instance.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-rdsdbinstances">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-rdsdbinstances</a>
         * @param rdsDbInstances The Amazon Relational Database Service ( Amazon RDS ) database instance to register with the AWS OpsWorks stack. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rdsDbInstances(final java.util.List<? extends java.lang.Object> rdsDbInstances) {
            this.props.rdsDbInstances(rdsDbInstances);
            return this;
        }

        /**
         * If you're cloning an AWS OpsWorks stack, the stack ID of the source AWS OpsWorks stack to clone.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-sourcestackid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-sourcestackid</a>
         * @param sourceStackId If you're cloning an AWS OpsWorks stack, the stack ID of the source AWS OpsWorks stack to clone. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceStackId(final java.lang.String sourceStackId) {
            this.props.sourceStackId(sourceStackId);
            return this;
        }

        /**
         * A map that contains tag keys and tag values that are attached to a stack or layer.
         * <p>
         * <ul>
         * <li>The key cannot be empty.</li>
         * <li>The key can be a maximum of 127 characters, and can contain only Unicode letters, numbers, or separators, or the following special characters: <code>+ - = . _ : /</code></li>
         * <li>The value can be a maximum 255 characters, and contain only Unicode letters, numbers, or separators, or the following special characters: <code>+ - = . _ : /</code></li>
         * <li>Leading and trailing white spaces are trimmed from both the key and value.</li>
         * <li>A maximum of 40 tags is allowed for any resource.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-tags</a>
         * @param tags A map that contains tag keys and tag values that are attached to a stack or layer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * Whether the stack uses custom cookbooks.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-usecustomcookbooks">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-usecustomcookbooks</a>
         * @param useCustomCookbooks Whether the stack uses custom cookbooks. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder useCustomCookbooks(final java.lang.Boolean useCustomCookbooks) {
            this.props.useCustomCookbooks(useCustomCookbooks);
            return this;
        }
        /**
         * Whether the stack uses custom cookbooks.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-usecustomcookbooks">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-usecustomcookbooks</a>
         * @param useCustomCookbooks Whether the stack uses custom cookbooks. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder useCustomCookbooks(final software.amazon.awscdk.IResolvable useCustomCookbooks) {
            this.props.useCustomCookbooks(useCustomCookbooks);
            return this;
        }

        /**
         * Whether to associate the AWS OpsWorks Stacks built-in security groups with the stack's layers.
         * <p>
         * AWS OpsWorks Stacks provides a standard set of built-in security groups, one for each layer, which are associated with layers by default. With <code>UseOpsworksSecurityGroups</code> you can instead provide your own custom security groups. <code>UseOpsworksSecurityGroups</code> has the following settings:
         * <p>
         * <ul>
         * <li>True - AWS OpsWorks Stacks automatically associates the appropriate built-in security group with each layer (default setting). You can associate additional security groups with a layer after you create it, but you cannot delete the built-in security group.</li>
         * <li>False - AWS OpsWorks Stacks does not associate built-in security groups with layers. You must create appropriate EC2 security groups and associate a security group with each layer that you create. However, you can still manually associate a built-in security group with a layer on creation; custom security groups are required only for those layers that need custom settings.</li>
         * </ul>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New Stack</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-useopsworkssecuritygroups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-useopsworkssecuritygroups</a>
         * @param useOpsworksSecurityGroups Whether to associate the AWS OpsWorks Stacks built-in security groups with the stack's layers. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder useOpsworksSecurityGroups(final java.lang.Boolean useOpsworksSecurityGroups) {
            this.props.useOpsworksSecurityGroups(useOpsworksSecurityGroups);
            return this;
        }
        /**
         * Whether to associate the AWS OpsWorks Stacks built-in security groups with the stack's layers.
         * <p>
         * AWS OpsWorks Stacks provides a standard set of built-in security groups, one for each layer, which are associated with layers by default. With <code>UseOpsworksSecurityGroups</code> you can instead provide your own custom security groups. <code>UseOpsworksSecurityGroups</code> has the following settings:
         * <p>
         * <ul>
         * <li>True - AWS OpsWorks Stacks automatically associates the appropriate built-in security group with each layer (default setting). You can associate additional security groups with a layer after you create it, but you cannot delete the built-in security group.</li>
         * <li>False - AWS OpsWorks Stacks does not associate built-in security groups with layers. You must create appropriate EC2 security groups and associate a security group with each layer that you create. However, you can still manually associate a built-in security group with a layer on creation; custom security groups are required only for those layers that need custom settings.</li>
         * </ul>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New Stack</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-useopsworkssecuritygroups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-useopsworkssecuritygroups</a>
         * @param useOpsworksSecurityGroups Whether to associate the AWS OpsWorks Stacks built-in security groups with the stack's layers. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder useOpsworksSecurityGroups(final software.amazon.awscdk.IResolvable useOpsworksSecurityGroups) {
            this.props.useOpsworksSecurityGroups(useOpsworksSecurityGroups);
            return this;
        }

        /**
         * The ID of the VPC that the stack is to be launched into.
         * <p>
         * The VPC must be in the stack's region. All instances are launched into this VPC. You cannot change the ID later.
         * <p>
         * <ul>
         * <li>If your account supports EC2-Classic, the default value is <code>no VPC</code> .</li>
         * <li>If your account does not support EC2-Classic, the default value is the default VPC for the specified region.</li>
         * </ul>
         * <p>
         * If the VPC ID corresponds to a default VPC and you have specified either the <code>DefaultAvailabilityZone</code> or the <code>DefaultSubnetId</code> parameter only, AWS OpsWorks Stacks infers the value of the other parameter. If you specify neither parameter, AWS OpsWorks Stacks sets these parameters to the first valid Availability Zone for the specified region and the corresponding default VPC subnet ID, respectively.
         * <p>
         * If you specify a nondefault VPC ID, note the following:
         * <p>
         * <ul>
         * <li>It must belong to a VPC in your account that is in the specified region.</li>
         * <li>You must specify a value for <code>DefaultSubnetId</code> .</li>
         * </ul>
         * <p>
         * For more information about how to use AWS OpsWorks Stacks with a VPC, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-vpc.html">Running a Stack in a VPC</a> . For more information about default VPC and EC2-Classic, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html">Supported Platforms</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-vpcid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-stack.html#cfn-opsworks-stack-vpcid</a>
         * @param vpcId The ID of the VPC that the stack is to be launched into. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcId(final java.lang.String vpcId) {
            this.props.vpcId(vpcId);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.opsworks.CfnStack}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.opsworks.CfnStack build() {
            return new software.amazon.awscdk.services.opsworks.CfnStack(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
