package software.amazon.awscdk.services.lambda;

/**
 * Properties for defining a <code>CfnEventInvokeConfig</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.lambda.*;
 * CfnEventInvokeConfigProps cfnEventInvokeConfigProps = CfnEventInvokeConfigProps.builder()
 *         .functionName("functionName")
 *         .qualifier("qualifier")
 *         // the properties below are optional
 *         .destinationConfig(DestinationConfigProperty.builder()
 *                 .onFailure(OnFailureProperty.builder()
 *                         .destination("destination")
 *                         .build())
 *                 .onSuccess(OnSuccessProperty.builder()
 *                         .destination("destination")
 *                         .build())
 *                 .build())
 *         .maximumEventAgeInSeconds(123)
 *         .maximumRetryAttempts(123)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventinvokeconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventinvokeconfig.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:15.530Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.CfnEventInvokeConfigProps")
@software.amazon.jsii.Jsii.Proxy(CfnEventInvokeConfigProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnEventInvokeConfigProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the Lambda function.
     * <p>
     * <em>Minimum</em> : <code>1</code>
     * <p>
     * <em>Maximum</em> : <code>64</code>
     * <p>
     * <em>Pattern</em> : <code>([a-zA-Z0-9-_]+)</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventinvokeconfig.html#cfn-lambda-eventinvokeconfig-functionname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventinvokeconfig.html#cfn-lambda-eventinvokeconfig-functionname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFunctionName();

    /**
     * The identifier of a version or alias.
     * <p>
     * <ul>
     * <li><em>Version</em> - A version number.</li>
     * <li><em>Alias</em> - An alias name.</li>
     * <li><em>Latest</em> - To specify the unpublished version, use <code>$LATEST</code> .</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventinvokeconfig.html#cfn-lambda-eventinvokeconfig-qualifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventinvokeconfig.html#cfn-lambda-eventinvokeconfig-qualifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getQualifier();

    /**
     * A destination for events after they have been sent to a function for processing.
     * <p>
     * <strong>Destinations</strong> - <em>Function</em> - The Amazon Resource Name (ARN) of a Lambda function.
     * <p>
     * <ul>
     * <li><em>Queue</em> - The ARN of a standard SQS queue.</li>
     * <li><em>Bucket</em> - The ARN of an Amazon S3 bucket.</li>
     * <li><em>Topic</em> - The ARN of a standard SNS topic.</li>
     * <li><em>Event Bus</em> - The ARN of an Amazon EventBridge event bus.</li>
     * </ul>
     * <p>
     * <blockquote>
     * <p>
     * S3 buckets are supported only for on-failure destinations. To retain records of successful invocations, use another destination type.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventinvokeconfig.html#cfn-lambda-eventinvokeconfig-destinationconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventinvokeconfig.html#cfn-lambda-eventinvokeconfig-destinationconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDestinationConfig() {
        return null;
    }

    /**
     * The maximum age of a request that Lambda sends to a function for processing.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventinvokeconfig.html#cfn-lambda-eventinvokeconfig-maximumeventageinseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventinvokeconfig.html#cfn-lambda-eventinvokeconfig-maximumeventageinseconds</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaximumEventAgeInSeconds() {
        return null;
    }

    /**
     * The maximum number of times to retry when the function returns an error.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventinvokeconfig.html#cfn-lambda-eventinvokeconfig-maximumretryattempts">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventinvokeconfig.html#cfn-lambda-eventinvokeconfig-maximumretryattempts</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaximumRetryAttempts() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnEventInvokeConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnEventInvokeConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnEventInvokeConfigProps> {
        java.lang.String functionName;
        java.lang.String qualifier;
        java.lang.Object destinationConfig;
        java.lang.Number maximumEventAgeInSeconds;
        java.lang.Number maximumRetryAttempts;

        /**
         * Sets the value of {@link CfnEventInvokeConfigProps#getFunctionName}
         * @param functionName The name of the Lambda function. This parameter is required.
         *                     <em>Minimum</em> : <code>1</code>
         *                     <p>
         *                     <em>Maximum</em> : <code>64</code>
         *                     <p>
         *                     <em>Pattern</em> : <code>([a-zA-Z0-9-_]+)</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder functionName(java.lang.String functionName) {
            this.functionName = functionName;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventInvokeConfigProps#getQualifier}
         * @param qualifier The identifier of a version or alias. This parameter is required.
         *                  <ul>
         *                  <li><em>Version</em> - A version number.</li>
         *                  <li><em>Alias</em> - An alias name.</li>
         *                  <li><em>Latest</em> - To specify the unpublished version, use <code>$LATEST</code> .</li>
         *                  </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder qualifier(java.lang.String qualifier) {
            this.qualifier = qualifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventInvokeConfigProps#getDestinationConfig}
         * @param destinationConfig A destination for events after they have been sent to a function for processing.
         *                          <strong>Destinations</strong> - <em>Function</em> - The Amazon Resource Name (ARN) of a Lambda function.
         *                          <p>
         *                          <ul>
         *                          <li><em>Queue</em> - The ARN of a standard SQS queue.</li>
         *                          <li><em>Bucket</em> - The ARN of an Amazon S3 bucket.</li>
         *                          <li><em>Topic</em> - The ARN of a standard SNS topic.</li>
         *                          <li><em>Event Bus</em> - The ARN of an Amazon EventBridge event bus.</li>
         *                          </ul>
         *                          <p>
         *                          <blockquote>
         *                          <p>
         *                          S3 buckets are supported only for on-failure destinations. To retain records of successful invocations, use another destination type.
         *                          <p>
         *                          </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinationConfig(software.amazon.awscdk.IResolvable destinationConfig) {
            this.destinationConfig = destinationConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventInvokeConfigProps#getDestinationConfig}
         * @param destinationConfig A destination for events after they have been sent to a function for processing.
         *                          <strong>Destinations</strong> - <em>Function</em> - The Amazon Resource Name (ARN) of a Lambda function.
         *                          <p>
         *                          <ul>
         *                          <li><em>Queue</em> - The ARN of a standard SQS queue.</li>
         *                          <li><em>Bucket</em> - The ARN of an Amazon S3 bucket.</li>
         *                          <li><em>Topic</em> - The ARN of a standard SNS topic.</li>
         *                          <li><em>Event Bus</em> - The ARN of an Amazon EventBridge event bus.</li>
         *                          </ul>
         *                          <p>
         *                          <blockquote>
         *                          <p>
         *                          S3 buckets are supported only for on-failure destinations. To retain records of successful invocations, use another destination type.
         *                          <p>
         *                          </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinationConfig(software.amazon.awscdk.services.lambda.CfnEventInvokeConfig.DestinationConfigProperty destinationConfig) {
            this.destinationConfig = destinationConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventInvokeConfigProps#getMaximumEventAgeInSeconds}
         * @param maximumEventAgeInSeconds The maximum age of a request that Lambda sends to a function for processing.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maximumEventAgeInSeconds(java.lang.Number maximumEventAgeInSeconds) {
            this.maximumEventAgeInSeconds = maximumEventAgeInSeconds;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventInvokeConfigProps#getMaximumRetryAttempts}
         * @param maximumRetryAttempts The maximum number of times to retry when the function returns an error.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maximumRetryAttempts(java.lang.Number maximumRetryAttempts) {
            this.maximumRetryAttempts = maximumRetryAttempts;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnEventInvokeConfigProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnEventInvokeConfigProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnEventInvokeConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnEventInvokeConfigProps {
        private final java.lang.String functionName;
        private final java.lang.String qualifier;
        private final java.lang.Object destinationConfig;
        private final java.lang.Number maximumEventAgeInSeconds;
        private final java.lang.Number maximumRetryAttempts;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.functionName = software.amazon.jsii.Kernel.get(this, "functionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.qualifier = software.amazon.jsii.Kernel.get(this, "qualifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.destinationConfig = software.amazon.jsii.Kernel.get(this, "destinationConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.maximumEventAgeInSeconds = software.amazon.jsii.Kernel.get(this, "maximumEventAgeInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.maximumRetryAttempts = software.amazon.jsii.Kernel.get(this, "maximumRetryAttempts", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.functionName = java.util.Objects.requireNonNull(builder.functionName, "functionName is required");
            this.qualifier = java.util.Objects.requireNonNull(builder.qualifier, "qualifier is required");
            this.destinationConfig = builder.destinationConfig;
            this.maximumEventAgeInSeconds = builder.maximumEventAgeInSeconds;
            this.maximumRetryAttempts = builder.maximumRetryAttempts;
        }

        @Override
        public final java.lang.String getFunctionName() {
            return this.functionName;
        }

        @Override
        public final java.lang.String getQualifier() {
            return this.qualifier;
        }

        @Override
        public final java.lang.Object getDestinationConfig() {
            return this.destinationConfig;
        }

        @Override
        public final java.lang.Number getMaximumEventAgeInSeconds() {
            return this.maximumEventAgeInSeconds;
        }

        @Override
        public final java.lang.Number getMaximumRetryAttempts() {
            return this.maximumRetryAttempts;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("functionName", om.valueToTree(this.getFunctionName()));
            data.set("qualifier", om.valueToTree(this.getQualifier()));
            if (this.getDestinationConfig() != null) {
                data.set("destinationConfig", om.valueToTree(this.getDestinationConfig()));
            }
            if (this.getMaximumEventAgeInSeconds() != null) {
                data.set("maximumEventAgeInSeconds", om.valueToTree(this.getMaximumEventAgeInSeconds()));
            }
            if (this.getMaximumRetryAttempts() != null) {
                data.set("maximumRetryAttempts", om.valueToTree(this.getMaximumRetryAttempts()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lambda.CfnEventInvokeConfigProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnEventInvokeConfigProps.Jsii$Proxy that = (CfnEventInvokeConfigProps.Jsii$Proxy) o;

            if (!functionName.equals(that.functionName)) return false;
            if (!qualifier.equals(that.qualifier)) return false;
            if (this.destinationConfig != null ? !this.destinationConfig.equals(that.destinationConfig) : that.destinationConfig != null) return false;
            if (this.maximumEventAgeInSeconds != null ? !this.maximumEventAgeInSeconds.equals(that.maximumEventAgeInSeconds) : that.maximumEventAgeInSeconds != null) return false;
            return this.maximumRetryAttempts != null ? this.maximumRetryAttempts.equals(that.maximumRetryAttempts) : that.maximumRetryAttempts == null;
        }

        @Override
        public final int hashCode() {
            int result = this.functionName.hashCode();
            result = 31 * result + (this.qualifier.hashCode());
            result = 31 * result + (this.destinationConfig != null ? this.destinationConfig.hashCode() : 0);
            result = 31 * result + (this.maximumEventAgeInSeconds != null ? this.maximumEventAgeInSeconds.hashCode() : 0);
            result = 31 * result + (this.maximumRetryAttempts != null ? this.maximumRetryAttempts.hashCode() : 0);
            return result;
        }
    }
}
