package software.amazon.awscdk.services.kinesisfirehose;

/**
 * The <code>AWS::KinesisFirehose::DeliveryStream</code> resource specifies an Amazon Kinesis Data Firehose (Kinesis Data Firehose) delivery stream that delivers real-time streaming data to an Amazon Simple Storage Service (Amazon S3), Amazon Redshift, or Amazon Elasticsearch Service (Amazon ES) destination.
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/basic-create.html">Creating an Amazon Kinesis Data Firehose Delivery Stream</a> in the <em>Amazon Kinesis Data Firehose Developer Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Bucket destinationBucket = new Bucket(this, "Bucket");
 * Role deliveryStreamRole = Role.Builder.create(this, "Role")
 *         .assumedBy(new ServicePrincipal("firehose.amazonaws.com"))
 *         .build();
 * CfnDeliveryStream stream = CfnDeliveryStream.Builder.create(this, "MyStream")
 *         .deliveryStreamName("amazon-apigateway-delivery-stream")
 *         .s3DestinationConfiguration(S3DestinationConfigurationProperty.builder()
 *                 .bucketArn(destinationBucket.getBucketArn())
 *                 .roleArn(deliveryStreamRole.getRoleArn())
 *                 .build())
 *         .build();
 * RestApi api = RestApi.Builder.create(this, "books")
 *         .deployOptions(StageOptions.builder()
 *                 .accessLogDestination(new FirehoseLogDestination(stream))
 *                 .accessLogFormat(AccessLogFormat.jsonWithStandardFields())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:15.317Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream")
public class CfnDeliveryStream extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnDeliveryStream(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDeliveryStream(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDeliveryStream(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStreamProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDeliveryStream(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the delivery stream, such as <code>arn:aws:firehose:us-east-2:123456789012:deliverystream/delivery-stream-name</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * Describes the configuration of a destination in the Serverless offering for Amazon OpenSearch Service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAmazonOpenSearchServerlessDestinationConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "amazonOpenSearchServerlessDestinationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Describes the configuration of a destination in the Serverless offering for Amazon OpenSearch Service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAmazonOpenSearchServerlessDestinationConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "amazonOpenSearchServerlessDestinationConfiguration", value);
    }

    /**
     * Describes the configuration of a destination in the Serverless offering for Amazon OpenSearch Service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAmazonOpenSearchServerlessDestinationConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.AmazonOpenSearchServerlessDestinationConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "amazonOpenSearchServerlessDestinationConfiguration", value);
    }

    /**
     * The destination in Amazon OpenSearch Service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAmazonopensearchserviceDestinationConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "amazonopensearchserviceDestinationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The destination in Amazon OpenSearch Service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAmazonopensearchserviceDestinationConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "amazonopensearchserviceDestinationConfiguration", value);
    }

    /**
     * The destination in Amazon OpenSearch Service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAmazonopensearchserviceDestinationConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.AmazonopensearchserviceDestinationConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "amazonopensearchserviceDestinationConfiguration", value);
    }

    /**
     * The top level object for configuring streams with database as a source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDatabaseSourceConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "databaseSourceConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The top level object for configuring streams with database as a source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDatabaseSourceConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "databaseSourceConfiguration", value);
    }

    /**
     * The top level object for configuring streams with database as a source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDatabaseSourceConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.DatabaseSourceConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "databaseSourceConfiguration", value);
    }

    /**
     * Specifies the type and Amazon Resource Name (ARN) of the CMK to use for Server-Side Encryption (SSE).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDeliveryStreamEncryptionConfigurationInput() {
        return software.amazon.jsii.Kernel.get(this, "deliveryStreamEncryptionConfigurationInput", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies the type and Amazon Resource Name (ARN) of the CMK to use for Server-Side Encryption (SSE).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeliveryStreamEncryptionConfigurationInput(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "deliveryStreamEncryptionConfigurationInput", value);
    }

    /**
     * Specifies the type and Amazon Resource Name (ARN) of the CMK to use for Server-Side Encryption (SSE).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeliveryStreamEncryptionConfigurationInput(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.DeliveryStreamEncryptionConfigurationInputProperty value) {
        software.amazon.jsii.Kernel.set(this, "deliveryStreamEncryptionConfigurationInput", value);
    }

    /**
     * The name of the Firehose stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDeliveryStreamName() {
        return software.amazon.jsii.Kernel.get(this, "deliveryStreamName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the Firehose stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeliveryStreamName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "deliveryStreamName", value);
    }

    /**
     * The Firehose stream type.
     * <p>
     * This can be one of the following values:.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDeliveryStreamType() {
        return software.amazon.jsii.Kernel.get(this, "deliveryStreamType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Firehose stream type.
     * <p>
     * This can be one of the following values:.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeliveryStreamType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "deliveryStreamType", value);
    }

    /**
     * The structure that configures parameters such as <code>ThroughputHintInMBs</code> for a stream configured with Direct PUT as a source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDirectPutSourceConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "directPutSourceConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The structure that configures parameters such as <code>ThroughputHintInMBs</code> for a stream configured with Direct PUT as a source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDirectPutSourceConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "directPutSourceConfiguration", value);
    }

    /**
     * The structure that configures parameters such as <code>ThroughputHintInMBs</code> for a stream configured with Direct PUT as a source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDirectPutSourceConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.DirectPutSourceConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "directPutSourceConfiguration", value);
    }

    /**
     * An Amazon ES destination for the delivery stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getElasticsearchDestinationConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "elasticsearchDestinationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An Amazon ES destination for the delivery stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setElasticsearchDestinationConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "elasticsearchDestinationConfiguration", value);
    }

    /**
     * An Amazon ES destination for the delivery stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setElasticsearchDestinationConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.ElasticsearchDestinationConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "elasticsearchDestinationConfiguration", value);
    }

    /**
     * An Amazon S3 destination for the delivery stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getExtendedS3DestinationConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "extendedS3DestinationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An Amazon S3 destination for the delivery stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExtendedS3DestinationConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "extendedS3DestinationConfiguration", value);
    }

    /**
     * An Amazon S3 destination for the delivery stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExtendedS3DestinationConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.ExtendedS3DestinationConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "extendedS3DestinationConfiguration", value);
    }

    /**
     * Enables configuring Kinesis Firehose to deliver data to any HTTP endpoint destination.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getHttpEndpointDestinationConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "httpEndpointDestinationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Enables configuring Kinesis Firehose to deliver data to any HTTP endpoint destination.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHttpEndpointDestinationConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "httpEndpointDestinationConfiguration", value);
    }

    /**
     * Enables configuring Kinesis Firehose to deliver data to any HTTP endpoint destination.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHttpEndpointDestinationConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.HttpEndpointDestinationConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "httpEndpointDestinationConfiguration", value);
    }

    /**
     * Specifies the destination configure settings for Apache Iceberg Table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getIcebergDestinationConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "icebergDestinationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies the destination configure settings for Apache Iceberg Table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIcebergDestinationConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "icebergDestinationConfiguration", value);
    }

    /**
     * Specifies the destination configure settings for Apache Iceberg Table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIcebergDestinationConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.IcebergDestinationConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "icebergDestinationConfiguration", value);
    }

    /**
     * When a Kinesis stream is used as the source for the delivery stream, a <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-kinesisstreamsourceconfiguration.html">KinesisStreamSourceConfiguration</a> containing the Kinesis stream ARN and the role ARN for the source stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getKinesisStreamSourceConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "kinesisStreamSourceConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * When a Kinesis stream is used as the source for the delivery stream, a <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-kinesisstreamsourceconfiguration.html">KinesisStreamSourceConfiguration</a> containing the Kinesis stream ARN and the role ARN for the source stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKinesisStreamSourceConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "kinesisStreamSourceConfiguration", value);
    }

    /**
     * When a Kinesis stream is used as the source for the delivery stream, a <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-kinesisstreamsourceconfiguration.html">KinesisStreamSourceConfiguration</a> containing the Kinesis stream ARN and the role ARN for the source stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKinesisStreamSourceConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.KinesisStreamSourceConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "kinesisStreamSourceConfiguration", value);
    }

    /**
     * The configuration for the Amazon MSK cluster to be used as the source for a delivery stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getMskSourceConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "mskSourceConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The configuration for the Amazon MSK cluster to be used as the source for a delivery stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMskSourceConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "mskSourceConfiguration", value);
    }

    /**
     * The configuration for the Amazon MSK cluster to be used as the source for a delivery stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMskSourceConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.MSKSourceConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "mskSourceConfiguration", value);
    }

    /**
     * An Amazon Redshift destination for the delivery stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRedshiftDestinationConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "redshiftDestinationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An Amazon Redshift destination for the delivery stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRedshiftDestinationConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "redshiftDestinationConfiguration", value);
    }

    /**
     * An Amazon Redshift destination for the delivery stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRedshiftDestinationConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.RedshiftDestinationConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "redshiftDestinationConfiguration", value);
    }

    /**
     * The <code>S3DestinationConfiguration</code> property type specifies an Amazon Simple Storage Service (Amazon S3) destination to which Amazon Kinesis Data Firehose (Kinesis Data Firehose) delivers data.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getS3DestinationConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "s3DestinationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The <code>S3DestinationConfiguration</code> property type specifies an Amazon Simple Storage Service (Amazon S3) destination to which Amazon Kinesis Data Firehose (Kinesis Data Firehose) delivers data.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setS3DestinationConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "s3DestinationConfiguration", value);
    }

    /**
     * The <code>S3DestinationConfiguration</code> property type specifies an Amazon Simple Storage Service (Amazon S3) destination to which Amazon Kinesis Data Firehose (Kinesis Data Firehose) delivers data.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setS3DestinationConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.S3DestinationConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "s3DestinationConfiguration", value);
    }

    /**
     * Configure Snowflake destination.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSnowflakeDestinationConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "snowflakeDestinationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Configure Snowflake destination.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSnowflakeDestinationConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "snowflakeDestinationConfiguration", value);
    }

    /**
     * Configure Snowflake destination.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSnowflakeDestinationConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.SnowflakeDestinationConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "snowflakeDestinationConfiguration", value);
    }

    /**
     * The configuration of a destination in Splunk for the delivery stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSplunkDestinationConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "splunkDestinationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The configuration of a destination in Splunk for the delivery stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSplunkDestinationConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "splunkDestinationConfiguration", value);
    }

    /**
     * The configuration of a destination in Splunk for the delivery stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSplunkDestinationConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.SplunkDestinationConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "splunkDestinationConfiguration", value);
    }

    /**
     * A set of tags to assign to the Firehose stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A set of tags to assign to the Firehose stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * Describes the buffering to perform before delivering data to the Serverless offering for Amazon OpenSearch Service destination.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * AmazonOpenSearchServerlessBufferingHintsProperty amazonOpenSearchServerlessBufferingHintsProperty = AmazonOpenSearchServerlessBufferingHintsProperty.builder()
     *         .intervalInSeconds(123)
     *         .sizeInMBs(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-amazonopensearchserverlessbufferinghints.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-amazonopensearchserverlessbufferinghints.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.AmazonOpenSearchServerlessBufferingHintsProperty")
    @software.amazon.jsii.Jsii.Proxy(AmazonOpenSearchServerlessBufferingHintsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AmazonOpenSearchServerlessBufferingHintsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Buffer incoming data for the specified period of time, in seconds, before delivering it to the destination.
         * <p>
         * The default value is 300 (5 minutes).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-amazonopensearchserverlessbufferinghints.html#cfn-kinesisfirehose-deliverystream-amazonopensearchserverlessbufferinghints-intervalinseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-amazonopensearchserverlessbufferinghints.html#cfn-kinesisfirehose-deliverystream-amazonopensearchserverlessbufferinghints-intervalinseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getIntervalInSeconds() {
            return null;
        }

        /**
         * Buffer incoming data to the specified size, in MBs, before delivering it to the destination.
         * <p>
         * The default value is 5.
         * <p>
         * We recommend setting this parameter to a value greater than the amount of data you typically ingest into the Firehose stream in 10 seconds. For example, if you typically ingest data at 1 MB/sec, the value should be 10 MB or higher.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-amazonopensearchserverlessbufferinghints.html#cfn-kinesisfirehose-deliverystream-amazonopensearchserverlessbufferinghints-sizeinmbs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-amazonopensearchserverlessbufferinghints.html#cfn-kinesisfirehose-deliverystream-amazonopensearchserverlessbufferinghints-sizeinmbs</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSizeInMBs() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AmazonOpenSearchServerlessBufferingHintsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AmazonOpenSearchServerlessBufferingHintsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AmazonOpenSearchServerlessBufferingHintsProperty> {
            java.lang.Number intervalInSeconds;
            java.lang.Number sizeInMBs;

            /**
             * Sets the value of {@link AmazonOpenSearchServerlessBufferingHintsProperty#getIntervalInSeconds}
             * @param intervalInSeconds Buffer incoming data for the specified period of time, in seconds, before delivering it to the destination.
             *                          The default value is 300 (5 minutes).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder intervalInSeconds(java.lang.Number intervalInSeconds) {
                this.intervalInSeconds = intervalInSeconds;
                return this;
            }

            /**
             * Sets the value of {@link AmazonOpenSearchServerlessBufferingHintsProperty#getSizeInMBs}
             * @param sizeInMBs Buffer incoming data to the specified size, in MBs, before delivering it to the destination.
             *                  The default value is 5.
             *                  <p>
             *                  We recommend setting this parameter to a value greater than the amount of data you typically ingest into the Firehose stream in 10 seconds. For example, if you typically ingest data at 1 MB/sec, the value should be 10 MB or higher.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sizeInMBs(java.lang.Number sizeInMBs) {
                this.sizeInMBs = sizeInMBs;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AmazonOpenSearchServerlessBufferingHintsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AmazonOpenSearchServerlessBufferingHintsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AmazonOpenSearchServerlessBufferingHintsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AmazonOpenSearchServerlessBufferingHintsProperty {
            private final java.lang.Number intervalInSeconds;
            private final java.lang.Number sizeInMBs;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.intervalInSeconds = software.amazon.jsii.Kernel.get(this, "intervalInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.sizeInMBs = software.amazon.jsii.Kernel.get(this, "sizeInMBs", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.intervalInSeconds = builder.intervalInSeconds;
                this.sizeInMBs = builder.sizeInMBs;
            }

            @Override
            public final java.lang.Number getIntervalInSeconds() {
                return this.intervalInSeconds;
            }

            @Override
            public final java.lang.Number getSizeInMBs() {
                return this.sizeInMBs;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getIntervalInSeconds() != null) {
                    data.set("intervalInSeconds", om.valueToTree(this.getIntervalInSeconds()));
                }
                if (this.getSizeInMBs() != null) {
                    data.set("sizeInMBs", om.valueToTree(this.getSizeInMBs()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.AmazonOpenSearchServerlessBufferingHintsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AmazonOpenSearchServerlessBufferingHintsProperty.Jsii$Proxy that = (AmazonOpenSearchServerlessBufferingHintsProperty.Jsii$Proxy) o;

                if (this.intervalInSeconds != null ? !this.intervalInSeconds.equals(that.intervalInSeconds) : that.intervalInSeconds != null) return false;
                return this.sizeInMBs != null ? this.sizeInMBs.equals(that.sizeInMBs) : that.sizeInMBs == null;
            }

            @Override
            public final int hashCode() {
                int result = this.intervalInSeconds != null ? this.intervalInSeconds.hashCode() : 0;
                result = 31 * result + (this.sizeInMBs != null ? this.sizeInMBs.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes the configuration of a destination in the Serverless offering for Amazon OpenSearch Service.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * AmazonOpenSearchServerlessDestinationConfigurationProperty amazonOpenSearchServerlessDestinationConfigurationProperty = AmazonOpenSearchServerlessDestinationConfigurationProperty.builder()
     *         .indexName("indexName")
     *         .roleArn("roleArn")
     *         .s3Configuration(S3DestinationConfigurationProperty.builder()
     *                 .bucketArn("bucketArn")
     *                 .roleArn("roleArn")
     *                 // the properties below are optional
     *                 .bufferingHints(BufferingHintsProperty.builder()
     *                         .intervalInSeconds(123)
     *                         .sizeInMBs(123)
     *                         .build())
     *                 .cloudWatchLoggingOptions(CloudWatchLoggingOptionsProperty.builder()
     *                         .enabled(false)
     *                         .logGroupName("logGroupName")
     *                         .logStreamName("logStreamName")
     *                         .build())
     *                 .compressionFormat("compressionFormat")
     *                 .encryptionConfiguration(EncryptionConfigurationProperty.builder()
     *                         .kmsEncryptionConfig(KMSEncryptionConfigProperty.builder()
     *                                 .awskmsKeyArn("awskmsKeyArn")
     *                                 .build())
     *                         .noEncryptionConfig("noEncryptionConfig")
     *                         .build())
     *                 .errorOutputPrefix("errorOutputPrefix")
     *                 .prefix("prefix")
     *                 .build())
     *         // the properties below are optional
     *         .bufferingHints(AmazonOpenSearchServerlessBufferingHintsProperty.builder()
     *                 .intervalInSeconds(123)
     *                 .sizeInMBs(123)
     *                 .build())
     *         .cloudWatchLoggingOptions(CloudWatchLoggingOptionsProperty.builder()
     *                 .enabled(false)
     *                 .logGroupName("logGroupName")
     *                 .logStreamName("logStreamName")
     *                 .build())
     *         .collectionEndpoint("collectionEndpoint")
     *         .processingConfiguration(ProcessingConfigurationProperty.builder()
     *                 .enabled(false)
     *                 .processors(List.of(ProcessorProperty.builder()
     *                         .type("type")
     *                         // the properties below are optional
     *                         .parameters(List.of(ProcessorParameterProperty.builder()
     *                                 .parameterName("parameterName")
     *                                 .parameterValue("parameterValue")
     *                                 .build()))
     *                         .build()))
     *                 .build())
     *         .retryOptions(AmazonOpenSearchServerlessRetryOptionsProperty.builder()
     *                 .durationInSeconds(123)
     *                 .build())
     *         .s3BackupMode("s3BackupMode")
     *         .vpcConfiguration(VpcConfigurationProperty.builder()
     *                 .roleArn("roleArn")
     *                 .securityGroupIds(List.of("securityGroupIds"))
     *                 .subnetIds(List.of("subnetIds"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-amazonopensearchserverlessdestinationconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-amazonopensearchserverlessdestinationconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.AmazonOpenSearchServerlessDestinationConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(AmazonOpenSearchServerlessDestinationConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AmazonOpenSearchServerlessDestinationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Serverless offering for Amazon OpenSearch Service index name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-amazonopensearchserverlessdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-amazonopensearchserverlessdestinationconfiguration-indexname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-amazonopensearchserverlessdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-amazonopensearchserverlessdestinationconfiguration-indexname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getIndexName();

        /**
         * The Amazon Resource Name (ARN) of the IAM role to be assumed by Firehose for calling the Serverless offering for Amazon OpenSearch Service Configuration API and for indexing documents.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-amazonopensearchserverlessdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-amazonopensearchserverlessdestinationconfiguration-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-amazonopensearchserverlessdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-amazonopensearchserverlessdestinationconfiguration-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-amazonopensearchserverlessdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-amazonopensearchserverlessdestinationconfiguration-s3configuration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-amazonopensearchserverlessdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-amazonopensearchserverlessdestinationconfiguration-s3configuration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getS3Configuration();

        /**
         * The buffering options.
         * <p>
         * If no value is specified, the default values for AmazonopensearchserviceBufferingHints are used.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-amazonopensearchserverlessdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-amazonopensearchserverlessdestinationconfiguration-bufferinghints">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-amazonopensearchserverlessdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-amazonopensearchserverlessdestinationconfiguration-bufferinghints</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBufferingHints() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-amazonopensearchserverlessdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-amazonopensearchserverlessdestinationconfiguration-cloudwatchloggingoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-amazonopensearchserverlessdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-amazonopensearchserverlessdestinationconfiguration-cloudwatchloggingoptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCloudWatchLoggingOptions() {
            return null;
        }

        /**
         * The endpoint to use when communicating with the collection in the Serverless offering for Amazon OpenSearch Service.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-amazonopensearchserverlessdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-amazonopensearchserverlessdestinationconfiguration-collectionendpoint">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-amazonopensearchserverlessdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-amazonopensearchserverlessdestinationconfiguration-collectionendpoint</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCollectionEndpoint() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-amazonopensearchserverlessdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-amazonopensearchserverlessdestinationconfiguration-processingconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-amazonopensearchserverlessdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-amazonopensearchserverlessdestinationconfiguration-processingconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getProcessingConfiguration() {
            return null;
        }

        /**
         * The retry behavior in case Firehose is unable to deliver documents to the Serverless offering for Amazon OpenSearch Service.
         * <p>
         * The default value is 300 (5 minutes).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-amazonopensearchserverlessdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-amazonopensearchserverlessdestinationconfiguration-retryoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-amazonopensearchserverlessdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-amazonopensearchserverlessdestinationconfiguration-retryoptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRetryOptions() {
            return null;
        }

        /**
         * Defines how documents should be delivered to Amazon S3.
         * <p>
         * When it is set to FailedDocumentsOnly, Firehose writes any documents that could not be indexed to the configured Amazon S3 destination, with AmazonOpenSearchService-failed/ appended to the key prefix. When set to AllDocuments, Firehose delivers all incoming records to Amazon S3, and also writes failed documents with AmazonOpenSearchService-failed/ appended to the prefix.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-amazonopensearchserverlessdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-amazonopensearchserverlessdestinationconfiguration-s3backupmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-amazonopensearchserverlessdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-amazonopensearchserverlessdestinationconfiguration-s3backupmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3BackupMode() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-amazonopensearchserverlessdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-amazonopensearchserverlessdestinationconfiguration-vpcconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-amazonopensearchserverlessdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-amazonopensearchserverlessdestinationconfiguration-vpcconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVpcConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AmazonOpenSearchServerlessDestinationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AmazonOpenSearchServerlessDestinationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AmazonOpenSearchServerlessDestinationConfigurationProperty> {
            java.lang.String indexName;
            java.lang.String roleArn;
            java.lang.Object s3Configuration;
            java.lang.Object bufferingHints;
            java.lang.Object cloudWatchLoggingOptions;
            java.lang.String collectionEndpoint;
            java.lang.Object processingConfiguration;
            java.lang.Object retryOptions;
            java.lang.String s3BackupMode;
            java.lang.Object vpcConfiguration;

            /**
             * Sets the value of {@link AmazonOpenSearchServerlessDestinationConfigurationProperty#getIndexName}
             * @param indexName The Serverless offering for Amazon OpenSearch Service index name. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder indexName(java.lang.String indexName) {
                this.indexName = indexName;
                return this;
            }

            /**
             * Sets the value of {@link AmazonOpenSearchServerlessDestinationConfigurationProperty#getRoleArn}
             * @param roleArn The Amazon Resource Name (ARN) of the IAM role to be assumed by Firehose for calling the Serverless offering for Amazon OpenSearch Service Configuration API and for indexing documents. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link AmazonOpenSearchServerlessDestinationConfigurationProperty#getS3Configuration}
             * @param s3Configuration the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Configuration(software.amazon.awscdk.IResolvable s3Configuration) {
                this.s3Configuration = s3Configuration;
                return this;
            }

            /**
             * Sets the value of {@link AmazonOpenSearchServerlessDestinationConfigurationProperty#getS3Configuration}
             * @param s3Configuration the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Configuration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.S3DestinationConfigurationProperty s3Configuration) {
                this.s3Configuration = s3Configuration;
                return this;
            }

            /**
             * Sets the value of {@link AmazonOpenSearchServerlessDestinationConfigurationProperty#getBufferingHints}
             * @param bufferingHints The buffering options.
             *                       If no value is specified, the default values for AmazonopensearchserviceBufferingHints are used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bufferingHints(software.amazon.awscdk.IResolvable bufferingHints) {
                this.bufferingHints = bufferingHints;
                return this;
            }

            /**
             * Sets the value of {@link AmazonOpenSearchServerlessDestinationConfigurationProperty#getBufferingHints}
             * @param bufferingHints The buffering options.
             *                       If no value is specified, the default values for AmazonopensearchserviceBufferingHints are used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bufferingHints(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.AmazonOpenSearchServerlessBufferingHintsProperty bufferingHints) {
                this.bufferingHints = bufferingHints;
                return this;
            }

            /**
             * Sets the value of {@link AmazonOpenSearchServerlessDestinationConfigurationProperty#getCloudWatchLoggingOptions}
             * @param cloudWatchLoggingOptions the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchLoggingOptions(software.amazon.awscdk.IResolvable cloudWatchLoggingOptions) {
                this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
                return this;
            }

            /**
             * Sets the value of {@link AmazonOpenSearchServerlessDestinationConfigurationProperty#getCloudWatchLoggingOptions}
             * @param cloudWatchLoggingOptions the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchLoggingOptions(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.CloudWatchLoggingOptionsProperty cloudWatchLoggingOptions) {
                this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
                return this;
            }

            /**
             * Sets the value of {@link AmazonOpenSearchServerlessDestinationConfigurationProperty#getCollectionEndpoint}
             * @param collectionEndpoint The endpoint to use when communicating with the collection in the Serverless offering for Amazon OpenSearch Service.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder collectionEndpoint(java.lang.String collectionEndpoint) {
                this.collectionEndpoint = collectionEndpoint;
                return this;
            }

            /**
             * Sets the value of {@link AmazonOpenSearchServerlessDestinationConfigurationProperty#getProcessingConfiguration}
             * @param processingConfiguration the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder processingConfiguration(software.amazon.awscdk.IResolvable processingConfiguration) {
                this.processingConfiguration = processingConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link AmazonOpenSearchServerlessDestinationConfigurationProperty#getProcessingConfiguration}
             * @param processingConfiguration the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder processingConfiguration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.ProcessingConfigurationProperty processingConfiguration) {
                this.processingConfiguration = processingConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link AmazonOpenSearchServerlessDestinationConfigurationProperty#getRetryOptions}
             * @param retryOptions The retry behavior in case Firehose is unable to deliver documents to the Serverless offering for Amazon OpenSearch Service.
             *                     The default value is 300 (5 minutes).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retryOptions(software.amazon.awscdk.IResolvable retryOptions) {
                this.retryOptions = retryOptions;
                return this;
            }

            /**
             * Sets the value of {@link AmazonOpenSearchServerlessDestinationConfigurationProperty#getRetryOptions}
             * @param retryOptions The retry behavior in case Firehose is unable to deliver documents to the Serverless offering for Amazon OpenSearch Service.
             *                     The default value is 300 (5 minutes).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retryOptions(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.AmazonOpenSearchServerlessRetryOptionsProperty retryOptions) {
                this.retryOptions = retryOptions;
                return this;
            }

            /**
             * Sets the value of {@link AmazonOpenSearchServerlessDestinationConfigurationProperty#getS3BackupMode}
             * @param s3BackupMode Defines how documents should be delivered to Amazon S3.
             *                     When it is set to FailedDocumentsOnly, Firehose writes any documents that could not be indexed to the configured Amazon S3 destination, with AmazonOpenSearchService-failed/ appended to the key prefix. When set to AllDocuments, Firehose delivers all incoming records to Amazon S3, and also writes failed documents with AmazonOpenSearchService-failed/ appended to the prefix.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3BackupMode(java.lang.String s3BackupMode) {
                this.s3BackupMode = s3BackupMode;
                return this;
            }

            /**
             * Sets the value of {@link AmazonOpenSearchServerlessDestinationConfigurationProperty#getVpcConfiguration}
             * @param vpcConfiguration the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcConfiguration(software.amazon.awscdk.IResolvable vpcConfiguration) {
                this.vpcConfiguration = vpcConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link AmazonOpenSearchServerlessDestinationConfigurationProperty#getVpcConfiguration}
             * @param vpcConfiguration the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcConfiguration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.VpcConfigurationProperty vpcConfiguration) {
                this.vpcConfiguration = vpcConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AmazonOpenSearchServerlessDestinationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AmazonOpenSearchServerlessDestinationConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AmazonOpenSearchServerlessDestinationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AmazonOpenSearchServerlessDestinationConfigurationProperty {
            private final java.lang.String indexName;
            private final java.lang.String roleArn;
            private final java.lang.Object s3Configuration;
            private final java.lang.Object bufferingHints;
            private final java.lang.Object cloudWatchLoggingOptions;
            private final java.lang.String collectionEndpoint;
            private final java.lang.Object processingConfiguration;
            private final java.lang.Object retryOptions;
            private final java.lang.String s3BackupMode;
            private final java.lang.Object vpcConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.indexName = software.amazon.jsii.Kernel.get(this, "indexName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3Configuration = software.amazon.jsii.Kernel.get(this, "s3Configuration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.bufferingHints = software.amazon.jsii.Kernel.get(this, "bufferingHints", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.cloudWatchLoggingOptions = software.amazon.jsii.Kernel.get(this, "cloudWatchLoggingOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.collectionEndpoint = software.amazon.jsii.Kernel.get(this, "collectionEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.processingConfiguration = software.amazon.jsii.Kernel.get(this, "processingConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.retryOptions = software.amazon.jsii.Kernel.get(this, "retryOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.s3BackupMode = software.amazon.jsii.Kernel.get(this, "s3BackupMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.vpcConfiguration = software.amazon.jsii.Kernel.get(this, "vpcConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.indexName = java.util.Objects.requireNonNull(builder.indexName, "indexName is required");
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
                this.s3Configuration = java.util.Objects.requireNonNull(builder.s3Configuration, "s3Configuration is required");
                this.bufferingHints = builder.bufferingHints;
                this.cloudWatchLoggingOptions = builder.cloudWatchLoggingOptions;
                this.collectionEndpoint = builder.collectionEndpoint;
                this.processingConfiguration = builder.processingConfiguration;
                this.retryOptions = builder.retryOptions;
                this.s3BackupMode = builder.s3BackupMode;
                this.vpcConfiguration = builder.vpcConfiguration;
            }

            @Override
            public final java.lang.String getIndexName() {
                return this.indexName;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.Object getS3Configuration() {
                return this.s3Configuration;
            }

            @Override
            public final java.lang.Object getBufferingHints() {
                return this.bufferingHints;
            }

            @Override
            public final java.lang.Object getCloudWatchLoggingOptions() {
                return this.cloudWatchLoggingOptions;
            }

            @Override
            public final java.lang.String getCollectionEndpoint() {
                return this.collectionEndpoint;
            }

            @Override
            public final java.lang.Object getProcessingConfiguration() {
                return this.processingConfiguration;
            }

            @Override
            public final java.lang.Object getRetryOptions() {
                return this.retryOptions;
            }

            @Override
            public final java.lang.String getS3BackupMode() {
                return this.s3BackupMode;
            }

            @Override
            public final java.lang.Object getVpcConfiguration() {
                return this.vpcConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("indexName", om.valueToTree(this.getIndexName()));
                data.set("roleArn", om.valueToTree(this.getRoleArn()));
                data.set("s3Configuration", om.valueToTree(this.getS3Configuration()));
                if (this.getBufferingHints() != null) {
                    data.set("bufferingHints", om.valueToTree(this.getBufferingHints()));
                }
                if (this.getCloudWatchLoggingOptions() != null) {
                    data.set("cloudWatchLoggingOptions", om.valueToTree(this.getCloudWatchLoggingOptions()));
                }
                if (this.getCollectionEndpoint() != null) {
                    data.set("collectionEndpoint", om.valueToTree(this.getCollectionEndpoint()));
                }
                if (this.getProcessingConfiguration() != null) {
                    data.set("processingConfiguration", om.valueToTree(this.getProcessingConfiguration()));
                }
                if (this.getRetryOptions() != null) {
                    data.set("retryOptions", om.valueToTree(this.getRetryOptions()));
                }
                if (this.getS3BackupMode() != null) {
                    data.set("s3BackupMode", om.valueToTree(this.getS3BackupMode()));
                }
                if (this.getVpcConfiguration() != null) {
                    data.set("vpcConfiguration", om.valueToTree(this.getVpcConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.AmazonOpenSearchServerlessDestinationConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AmazonOpenSearchServerlessDestinationConfigurationProperty.Jsii$Proxy that = (AmazonOpenSearchServerlessDestinationConfigurationProperty.Jsii$Proxy) o;

                if (!indexName.equals(that.indexName)) return false;
                if (!roleArn.equals(that.roleArn)) return false;
                if (!s3Configuration.equals(that.s3Configuration)) return false;
                if (this.bufferingHints != null ? !this.bufferingHints.equals(that.bufferingHints) : that.bufferingHints != null) return false;
                if (this.cloudWatchLoggingOptions != null ? !this.cloudWatchLoggingOptions.equals(that.cloudWatchLoggingOptions) : that.cloudWatchLoggingOptions != null) return false;
                if (this.collectionEndpoint != null ? !this.collectionEndpoint.equals(that.collectionEndpoint) : that.collectionEndpoint != null) return false;
                if (this.processingConfiguration != null ? !this.processingConfiguration.equals(that.processingConfiguration) : that.processingConfiguration != null) return false;
                if (this.retryOptions != null ? !this.retryOptions.equals(that.retryOptions) : that.retryOptions != null) return false;
                if (this.s3BackupMode != null ? !this.s3BackupMode.equals(that.s3BackupMode) : that.s3BackupMode != null) return false;
                return this.vpcConfiguration != null ? this.vpcConfiguration.equals(that.vpcConfiguration) : that.vpcConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.indexName.hashCode();
                result = 31 * result + (this.roleArn.hashCode());
                result = 31 * result + (this.s3Configuration.hashCode());
                result = 31 * result + (this.bufferingHints != null ? this.bufferingHints.hashCode() : 0);
                result = 31 * result + (this.cloudWatchLoggingOptions != null ? this.cloudWatchLoggingOptions.hashCode() : 0);
                result = 31 * result + (this.collectionEndpoint != null ? this.collectionEndpoint.hashCode() : 0);
                result = 31 * result + (this.processingConfiguration != null ? this.processingConfiguration.hashCode() : 0);
                result = 31 * result + (this.retryOptions != null ? this.retryOptions.hashCode() : 0);
                result = 31 * result + (this.s3BackupMode != null ? this.s3BackupMode.hashCode() : 0);
                result = 31 * result + (this.vpcConfiguration != null ? this.vpcConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configures retry behavior in case Firehose is unable to deliver documents to the Serverless offering for Amazon OpenSearch Service.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * AmazonOpenSearchServerlessRetryOptionsProperty amazonOpenSearchServerlessRetryOptionsProperty = AmazonOpenSearchServerlessRetryOptionsProperty.builder()
     *         .durationInSeconds(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-amazonopensearchserverlessretryoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-amazonopensearchserverlessretryoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.AmazonOpenSearchServerlessRetryOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(AmazonOpenSearchServerlessRetryOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AmazonOpenSearchServerlessRetryOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * After an initial failure to deliver to the Serverless offering for Amazon OpenSearch Service, the total amount of time during which Firehose retries delivery (including the first attempt).
         * <p>
         * After this time has elapsed, the failed documents are written to Amazon S3. Default value is 300 seconds (5 minutes). A value of 0 (zero) results in no retries.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-amazonopensearchserverlessretryoptions.html#cfn-kinesisfirehose-deliverystream-amazonopensearchserverlessretryoptions-durationinseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-amazonopensearchserverlessretryoptions.html#cfn-kinesisfirehose-deliverystream-amazonopensearchserverlessretryoptions-durationinseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDurationInSeconds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AmazonOpenSearchServerlessRetryOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AmazonOpenSearchServerlessRetryOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AmazonOpenSearchServerlessRetryOptionsProperty> {
            java.lang.Number durationInSeconds;

            /**
             * Sets the value of {@link AmazonOpenSearchServerlessRetryOptionsProperty#getDurationInSeconds}
             * @param durationInSeconds After an initial failure to deliver to the Serverless offering for Amazon OpenSearch Service, the total amount of time during which Firehose retries delivery (including the first attempt).
             *                          After this time has elapsed, the failed documents are written to Amazon S3. Default value is 300 seconds (5 minutes). A value of 0 (zero) results in no retries.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder durationInSeconds(java.lang.Number durationInSeconds) {
                this.durationInSeconds = durationInSeconds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AmazonOpenSearchServerlessRetryOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AmazonOpenSearchServerlessRetryOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AmazonOpenSearchServerlessRetryOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AmazonOpenSearchServerlessRetryOptionsProperty {
            private final java.lang.Number durationInSeconds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.durationInSeconds = software.amazon.jsii.Kernel.get(this, "durationInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.durationInSeconds = builder.durationInSeconds;
            }

            @Override
            public final java.lang.Number getDurationInSeconds() {
                return this.durationInSeconds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDurationInSeconds() != null) {
                    data.set("durationInSeconds", om.valueToTree(this.getDurationInSeconds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.AmazonOpenSearchServerlessRetryOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AmazonOpenSearchServerlessRetryOptionsProperty.Jsii$Proxy that = (AmazonOpenSearchServerlessRetryOptionsProperty.Jsii$Proxy) o;

                return this.durationInSeconds != null ? this.durationInSeconds.equals(that.durationInSeconds) : that.durationInSeconds == null;
            }

            @Override
            public final int hashCode() {
                int result = this.durationInSeconds != null ? this.durationInSeconds.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Describes the buffering to perform before delivering data to the Amazon OpenSearch Service destination.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * AmazonopensearchserviceBufferingHintsProperty amazonopensearchserviceBufferingHintsProperty = AmazonopensearchserviceBufferingHintsProperty.builder()
     *         .intervalInSeconds(123)
     *         .sizeInMBs(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-amazonopensearchservicebufferinghints.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-amazonopensearchservicebufferinghints.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.AmazonopensearchserviceBufferingHintsProperty")
    @software.amazon.jsii.Jsii.Proxy(AmazonopensearchserviceBufferingHintsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AmazonopensearchserviceBufferingHintsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Buffer incoming data for the specified period of time, in seconds, before delivering it to the destination.
         * <p>
         * The default value is 300 (5 minutes).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-amazonopensearchservicebufferinghints.html#cfn-kinesisfirehose-deliverystream-amazonopensearchservicebufferinghints-intervalinseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-amazonopensearchservicebufferinghints.html#cfn-kinesisfirehose-deliverystream-amazonopensearchservicebufferinghints-intervalinseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getIntervalInSeconds() {
            return null;
        }

        /**
         * Buffer incoming data to the specified size, in MBs, before delivering it to the destination.
         * <p>
         * The default value is 5. We recommend setting this parameter to a value greater than the amount of data you typically ingest into the delivery stream in 10 seconds. For example, if you typically ingest data at 1 MB/sec, the value should be 10 MB or higher.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-amazonopensearchservicebufferinghints.html#cfn-kinesisfirehose-deliverystream-amazonopensearchservicebufferinghints-sizeinmbs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-amazonopensearchservicebufferinghints.html#cfn-kinesisfirehose-deliverystream-amazonopensearchservicebufferinghints-sizeinmbs</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSizeInMBs() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AmazonopensearchserviceBufferingHintsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AmazonopensearchserviceBufferingHintsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AmazonopensearchserviceBufferingHintsProperty> {
            java.lang.Number intervalInSeconds;
            java.lang.Number sizeInMBs;

            /**
             * Sets the value of {@link AmazonopensearchserviceBufferingHintsProperty#getIntervalInSeconds}
             * @param intervalInSeconds Buffer incoming data for the specified period of time, in seconds, before delivering it to the destination.
             *                          The default value is 300 (5 minutes).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder intervalInSeconds(java.lang.Number intervalInSeconds) {
                this.intervalInSeconds = intervalInSeconds;
                return this;
            }

            /**
             * Sets the value of {@link AmazonopensearchserviceBufferingHintsProperty#getSizeInMBs}
             * @param sizeInMBs Buffer incoming data to the specified size, in MBs, before delivering it to the destination.
             *                  The default value is 5. We recommend setting this parameter to a value greater than the amount of data you typically ingest into the delivery stream in 10 seconds. For example, if you typically ingest data at 1 MB/sec, the value should be 10 MB or higher.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sizeInMBs(java.lang.Number sizeInMBs) {
                this.sizeInMBs = sizeInMBs;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AmazonopensearchserviceBufferingHintsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AmazonopensearchserviceBufferingHintsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AmazonopensearchserviceBufferingHintsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AmazonopensearchserviceBufferingHintsProperty {
            private final java.lang.Number intervalInSeconds;
            private final java.lang.Number sizeInMBs;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.intervalInSeconds = software.amazon.jsii.Kernel.get(this, "intervalInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.sizeInMBs = software.amazon.jsii.Kernel.get(this, "sizeInMBs", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.intervalInSeconds = builder.intervalInSeconds;
                this.sizeInMBs = builder.sizeInMBs;
            }

            @Override
            public final java.lang.Number getIntervalInSeconds() {
                return this.intervalInSeconds;
            }

            @Override
            public final java.lang.Number getSizeInMBs() {
                return this.sizeInMBs;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getIntervalInSeconds() != null) {
                    data.set("intervalInSeconds", om.valueToTree(this.getIntervalInSeconds()));
                }
                if (this.getSizeInMBs() != null) {
                    data.set("sizeInMBs", om.valueToTree(this.getSizeInMBs()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.AmazonopensearchserviceBufferingHintsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AmazonopensearchserviceBufferingHintsProperty.Jsii$Proxy that = (AmazonopensearchserviceBufferingHintsProperty.Jsii$Proxy) o;

                if (this.intervalInSeconds != null ? !this.intervalInSeconds.equals(that.intervalInSeconds) : that.intervalInSeconds != null) return false;
                return this.sizeInMBs != null ? this.sizeInMBs.equals(that.sizeInMBs) : that.sizeInMBs == null;
            }

            @Override
            public final int hashCode() {
                int result = this.intervalInSeconds != null ? this.intervalInSeconds.hashCode() : 0;
                result = 31 * result + (this.sizeInMBs != null ? this.sizeInMBs.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes the configuration of a destination in Amazon OpenSearch Service.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * AmazonopensearchserviceDestinationConfigurationProperty amazonopensearchserviceDestinationConfigurationProperty = AmazonopensearchserviceDestinationConfigurationProperty.builder()
     *         .indexName("indexName")
     *         .roleArn("roleArn")
     *         .s3Configuration(S3DestinationConfigurationProperty.builder()
     *                 .bucketArn("bucketArn")
     *                 .roleArn("roleArn")
     *                 // the properties below are optional
     *                 .bufferingHints(BufferingHintsProperty.builder()
     *                         .intervalInSeconds(123)
     *                         .sizeInMBs(123)
     *                         .build())
     *                 .cloudWatchLoggingOptions(CloudWatchLoggingOptionsProperty.builder()
     *                         .enabled(false)
     *                         .logGroupName("logGroupName")
     *                         .logStreamName("logStreamName")
     *                         .build())
     *                 .compressionFormat("compressionFormat")
     *                 .encryptionConfiguration(EncryptionConfigurationProperty.builder()
     *                         .kmsEncryptionConfig(KMSEncryptionConfigProperty.builder()
     *                                 .awskmsKeyArn("awskmsKeyArn")
     *                                 .build())
     *                         .noEncryptionConfig("noEncryptionConfig")
     *                         .build())
     *                 .errorOutputPrefix("errorOutputPrefix")
     *                 .prefix("prefix")
     *                 .build())
     *         // the properties below are optional
     *         .bufferingHints(AmazonopensearchserviceBufferingHintsProperty.builder()
     *                 .intervalInSeconds(123)
     *                 .sizeInMBs(123)
     *                 .build())
     *         .cloudWatchLoggingOptions(CloudWatchLoggingOptionsProperty.builder()
     *                 .enabled(false)
     *                 .logGroupName("logGroupName")
     *                 .logStreamName("logStreamName")
     *                 .build())
     *         .clusterEndpoint("clusterEndpoint")
     *         .documentIdOptions(DocumentIdOptionsProperty.builder()
     *                 .defaultDocumentIdFormat("defaultDocumentIdFormat")
     *                 .build())
     *         .domainArn("domainArn")
     *         .indexRotationPeriod("indexRotationPeriod")
     *         .processingConfiguration(ProcessingConfigurationProperty.builder()
     *                 .enabled(false)
     *                 .processors(List.of(ProcessorProperty.builder()
     *                         .type("type")
     *                         // the properties below are optional
     *                         .parameters(List.of(ProcessorParameterProperty.builder()
     *                                 .parameterName("parameterName")
     *                                 .parameterValue("parameterValue")
     *                                 .build()))
     *                         .build()))
     *                 .build())
     *         .retryOptions(AmazonopensearchserviceRetryOptionsProperty.builder()
     *                 .durationInSeconds(123)
     *                 .build())
     *         .s3BackupMode("s3BackupMode")
     *         .typeName("typeName")
     *         .vpcConfiguration(VpcConfigurationProperty.builder()
     *                 .roleArn("roleArn")
     *                 .securityGroupIds(List.of("securityGroupIds"))
     *                 .subnetIds(List.of("subnetIds"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-amazonopensearchservicedestinationconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-amazonopensearchservicedestinationconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.AmazonopensearchserviceDestinationConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(AmazonopensearchserviceDestinationConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AmazonopensearchserviceDestinationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon OpenSearch Service index name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-amazonopensearchservicedestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-amazonopensearchservicedestinationconfiguration-indexname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-amazonopensearchservicedestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-amazonopensearchservicedestinationconfiguration-indexname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getIndexName();

        /**
         * The Amazon Resource Name (ARN) of the IAM role to be assumed by Kinesis Data Firehose for calling the Amazon OpenSearch Service Configuration API and for indexing documents.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-amazonopensearchservicedestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-amazonopensearchservicedestinationconfiguration-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-amazonopensearchservicedestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-amazonopensearchservicedestinationconfiguration-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * Describes the configuration of a destination in Amazon S3.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-amazonopensearchservicedestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-amazonopensearchservicedestinationconfiguration-s3configuration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-amazonopensearchservicedestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-amazonopensearchservicedestinationconfiguration-s3configuration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getS3Configuration();

        /**
         * The buffering options.
         * <p>
         * If no value is specified, the default values for AmazonopensearchserviceBufferingHints are used.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-amazonopensearchservicedestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-amazonopensearchservicedestinationconfiguration-bufferinghints">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-amazonopensearchservicedestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-amazonopensearchservicedestinationconfiguration-bufferinghints</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBufferingHints() {
            return null;
        }

        /**
         * Describes the Amazon CloudWatch logging options for your delivery stream.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-amazonopensearchservicedestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-amazonopensearchservicedestinationconfiguration-cloudwatchloggingoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-amazonopensearchservicedestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-amazonopensearchservicedestinationconfiguration-cloudwatchloggingoptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCloudWatchLoggingOptions() {
            return null;
        }

        /**
         * The endpoint to use when communicating with the cluster.
         * <p>
         * Specify either this ClusterEndpoint or the DomainARN field.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-amazonopensearchservicedestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-amazonopensearchservicedestinationconfiguration-clusterendpoint">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-amazonopensearchservicedestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-amazonopensearchservicedestinationconfiguration-clusterendpoint</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getClusterEndpoint() {
            return null;
        }

        /**
         * Indicates the method for setting up document ID.
         * <p>
         * The supported methods are Firehose generated document ID and OpenSearch Service generated document ID.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-amazonopensearchservicedestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-amazonopensearchservicedestinationconfiguration-documentidoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-amazonopensearchservicedestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-amazonopensearchservicedestinationconfiguration-documentidoptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDocumentIdOptions() {
            return null;
        }

        /**
         * The ARN of the Amazon OpenSearch Service domain.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-amazonopensearchservicedestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-amazonopensearchservicedestinationconfiguration-domainarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-amazonopensearchservicedestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-amazonopensearchservicedestinationconfiguration-domainarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDomainArn() {
            return null;
        }

        /**
         * The Amazon OpenSearch Service index rotation period.
         * <p>
         * Index rotation appends a timestamp to the IndexName to facilitate the expiration of old data.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-amazonopensearchservicedestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-amazonopensearchservicedestinationconfiguration-indexrotationperiod">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-amazonopensearchservicedestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-amazonopensearchservicedestinationconfiguration-indexrotationperiod</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIndexRotationPeriod() {
            return null;
        }

        /**
         * Describes a data processing configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-amazonopensearchservicedestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-amazonopensearchservicedestinationconfiguration-processingconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-amazonopensearchservicedestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-amazonopensearchservicedestinationconfiguration-processingconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getProcessingConfiguration() {
            return null;
        }

        /**
         * The retry behavior in case Kinesis Data Firehose is unable to deliver documents to Amazon OpenSearch Service.
         * <p>
         * The default value is 300 (5 minutes).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-amazonopensearchservicedestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-amazonopensearchservicedestinationconfiguration-retryoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-amazonopensearchservicedestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-amazonopensearchservicedestinationconfiguration-retryoptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRetryOptions() {
            return null;
        }

        /**
         * Defines how documents should be delivered to Amazon S3.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-amazonopensearchservicedestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-amazonopensearchservicedestinationconfiguration-s3backupmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-amazonopensearchservicedestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-amazonopensearchservicedestinationconfiguration-s3backupmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3BackupMode() {
            return null;
        }

        /**
         * The Amazon OpenSearch Service type name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-amazonopensearchservicedestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-amazonopensearchservicedestinationconfiguration-typename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-amazonopensearchservicedestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-amazonopensearchservicedestinationconfiguration-typename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTypeName() {
            return null;
        }

        /**
         * The details of the VPC of the Amazon OpenSearch Service destination.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-amazonopensearchservicedestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-amazonopensearchservicedestinationconfiguration-vpcconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-amazonopensearchservicedestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-amazonopensearchservicedestinationconfiguration-vpcconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVpcConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AmazonopensearchserviceDestinationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AmazonopensearchserviceDestinationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AmazonopensearchserviceDestinationConfigurationProperty> {
            java.lang.String indexName;
            java.lang.String roleArn;
            java.lang.Object s3Configuration;
            java.lang.Object bufferingHints;
            java.lang.Object cloudWatchLoggingOptions;
            java.lang.String clusterEndpoint;
            java.lang.Object documentIdOptions;
            java.lang.String domainArn;
            java.lang.String indexRotationPeriod;
            java.lang.Object processingConfiguration;
            java.lang.Object retryOptions;
            java.lang.String s3BackupMode;
            java.lang.String typeName;
            java.lang.Object vpcConfiguration;

            /**
             * Sets the value of {@link AmazonopensearchserviceDestinationConfigurationProperty#getIndexName}
             * @param indexName The Amazon OpenSearch Service index name. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder indexName(java.lang.String indexName) {
                this.indexName = indexName;
                return this;
            }

            /**
             * Sets the value of {@link AmazonopensearchserviceDestinationConfigurationProperty#getRoleArn}
             * @param roleArn The Amazon Resource Name (ARN) of the IAM role to be assumed by Kinesis Data Firehose for calling the Amazon OpenSearch Service Configuration API and for indexing documents. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link AmazonopensearchserviceDestinationConfigurationProperty#getS3Configuration}
             * @param s3Configuration Describes the configuration of a destination in Amazon S3. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Configuration(software.amazon.awscdk.IResolvable s3Configuration) {
                this.s3Configuration = s3Configuration;
                return this;
            }

            /**
             * Sets the value of {@link AmazonopensearchserviceDestinationConfigurationProperty#getS3Configuration}
             * @param s3Configuration Describes the configuration of a destination in Amazon S3. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Configuration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.S3DestinationConfigurationProperty s3Configuration) {
                this.s3Configuration = s3Configuration;
                return this;
            }

            /**
             * Sets the value of {@link AmazonopensearchserviceDestinationConfigurationProperty#getBufferingHints}
             * @param bufferingHints The buffering options.
             *                       If no value is specified, the default values for AmazonopensearchserviceBufferingHints are used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bufferingHints(software.amazon.awscdk.IResolvable bufferingHints) {
                this.bufferingHints = bufferingHints;
                return this;
            }

            /**
             * Sets the value of {@link AmazonopensearchserviceDestinationConfigurationProperty#getBufferingHints}
             * @param bufferingHints The buffering options.
             *                       If no value is specified, the default values for AmazonopensearchserviceBufferingHints are used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bufferingHints(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.AmazonopensearchserviceBufferingHintsProperty bufferingHints) {
                this.bufferingHints = bufferingHints;
                return this;
            }

            /**
             * Sets the value of {@link AmazonopensearchserviceDestinationConfigurationProperty#getCloudWatchLoggingOptions}
             * @param cloudWatchLoggingOptions Describes the Amazon CloudWatch logging options for your delivery stream.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchLoggingOptions(software.amazon.awscdk.IResolvable cloudWatchLoggingOptions) {
                this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
                return this;
            }

            /**
             * Sets the value of {@link AmazonopensearchserviceDestinationConfigurationProperty#getCloudWatchLoggingOptions}
             * @param cloudWatchLoggingOptions Describes the Amazon CloudWatch logging options for your delivery stream.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchLoggingOptions(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.CloudWatchLoggingOptionsProperty cloudWatchLoggingOptions) {
                this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
                return this;
            }

            /**
             * Sets the value of {@link AmazonopensearchserviceDestinationConfigurationProperty#getClusterEndpoint}
             * @param clusterEndpoint The endpoint to use when communicating with the cluster.
             *                        Specify either this ClusterEndpoint or the DomainARN field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clusterEndpoint(java.lang.String clusterEndpoint) {
                this.clusterEndpoint = clusterEndpoint;
                return this;
            }

            /**
             * Sets the value of {@link AmazonopensearchserviceDestinationConfigurationProperty#getDocumentIdOptions}
             * @param documentIdOptions Indicates the method for setting up document ID.
             *                          The supported methods are Firehose generated document ID and OpenSearch Service generated document ID.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder documentIdOptions(software.amazon.awscdk.IResolvable documentIdOptions) {
                this.documentIdOptions = documentIdOptions;
                return this;
            }

            /**
             * Sets the value of {@link AmazonopensearchserviceDestinationConfigurationProperty#getDocumentIdOptions}
             * @param documentIdOptions Indicates the method for setting up document ID.
             *                          The supported methods are Firehose generated document ID and OpenSearch Service generated document ID.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder documentIdOptions(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.DocumentIdOptionsProperty documentIdOptions) {
                this.documentIdOptions = documentIdOptions;
                return this;
            }

            /**
             * Sets the value of {@link AmazonopensearchserviceDestinationConfigurationProperty#getDomainArn}
             * @param domainArn The ARN of the Amazon OpenSearch Service domain.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder domainArn(java.lang.String domainArn) {
                this.domainArn = domainArn;
                return this;
            }

            /**
             * Sets the value of {@link AmazonopensearchserviceDestinationConfigurationProperty#getIndexRotationPeriod}
             * @param indexRotationPeriod The Amazon OpenSearch Service index rotation period.
             *                            Index rotation appends a timestamp to the IndexName to facilitate the expiration of old data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder indexRotationPeriod(java.lang.String indexRotationPeriod) {
                this.indexRotationPeriod = indexRotationPeriod;
                return this;
            }

            /**
             * Sets the value of {@link AmazonopensearchserviceDestinationConfigurationProperty#getProcessingConfiguration}
             * @param processingConfiguration Describes a data processing configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder processingConfiguration(software.amazon.awscdk.IResolvable processingConfiguration) {
                this.processingConfiguration = processingConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link AmazonopensearchserviceDestinationConfigurationProperty#getProcessingConfiguration}
             * @param processingConfiguration Describes a data processing configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder processingConfiguration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.ProcessingConfigurationProperty processingConfiguration) {
                this.processingConfiguration = processingConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link AmazonopensearchserviceDestinationConfigurationProperty#getRetryOptions}
             * @param retryOptions The retry behavior in case Kinesis Data Firehose is unable to deliver documents to Amazon OpenSearch Service.
             *                     The default value is 300 (5 minutes).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retryOptions(software.amazon.awscdk.IResolvable retryOptions) {
                this.retryOptions = retryOptions;
                return this;
            }

            /**
             * Sets the value of {@link AmazonopensearchserviceDestinationConfigurationProperty#getRetryOptions}
             * @param retryOptions The retry behavior in case Kinesis Data Firehose is unable to deliver documents to Amazon OpenSearch Service.
             *                     The default value is 300 (5 minutes).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retryOptions(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.AmazonopensearchserviceRetryOptionsProperty retryOptions) {
                this.retryOptions = retryOptions;
                return this;
            }

            /**
             * Sets the value of {@link AmazonopensearchserviceDestinationConfigurationProperty#getS3BackupMode}
             * @param s3BackupMode Defines how documents should be delivered to Amazon S3.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3BackupMode(java.lang.String s3BackupMode) {
                this.s3BackupMode = s3BackupMode;
                return this;
            }

            /**
             * Sets the value of {@link AmazonopensearchserviceDestinationConfigurationProperty#getTypeName}
             * @param typeName The Amazon OpenSearch Service type name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder typeName(java.lang.String typeName) {
                this.typeName = typeName;
                return this;
            }

            /**
             * Sets the value of {@link AmazonopensearchserviceDestinationConfigurationProperty#getVpcConfiguration}
             * @param vpcConfiguration The details of the VPC of the Amazon OpenSearch Service destination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcConfiguration(software.amazon.awscdk.IResolvable vpcConfiguration) {
                this.vpcConfiguration = vpcConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link AmazonopensearchserviceDestinationConfigurationProperty#getVpcConfiguration}
             * @param vpcConfiguration The details of the VPC of the Amazon OpenSearch Service destination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcConfiguration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.VpcConfigurationProperty vpcConfiguration) {
                this.vpcConfiguration = vpcConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AmazonopensearchserviceDestinationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AmazonopensearchserviceDestinationConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AmazonopensearchserviceDestinationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AmazonopensearchserviceDestinationConfigurationProperty {
            private final java.lang.String indexName;
            private final java.lang.String roleArn;
            private final java.lang.Object s3Configuration;
            private final java.lang.Object bufferingHints;
            private final java.lang.Object cloudWatchLoggingOptions;
            private final java.lang.String clusterEndpoint;
            private final java.lang.Object documentIdOptions;
            private final java.lang.String domainArn;
            private final java.lang.String indexRotationPeriod;
            private final java.lang.Object processingConfiguration;
            private final java.lang.Object retryOptions;
            private final java.lang.String s3BackupMode;
            private final java.lang.String typeName;
            private final java.lang.Object vpcConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.indexName = software.amazon.jsii.Kernel.get(this, "indexName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3Configuration = software.amazon.jsii.Kernel.get(this, "s3Configuration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.bufferingHints = software.amazon.jsii.Kernel.get(this, "bufferingHints", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.cloudWatchLoggingOptions = software.amazon.jsii.Kernel.get(this, "cloudWatchLoggingOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.clusterEndpoint = software.amazon.jsii.Kernel.get(this, "clusterEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.documentIdOptions = software.amazon.jsii.Kernel.get(this, "documentIdOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.domainArn = software.amazon.jsii.Kernel.get(this, "domainArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.indexRotationPeriod = software.amazon.jsii.Kernel.get(this, "indexRotationPeriod", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.processingConfiguration = software.amazon.jsii.Kernel.get(this, "processingConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.retryOptions = software.amazon.jsii.Kernel.get(this, "retryOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.s3BackupMode = software.amazon.jsii.Kernel.get(this, "s3BackupMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.typeName = software.amazon.jsii.Kernel.get(this, "typeName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.vpcConfiguration = software.amazon.jsii.Kernel.get(this, "vpcConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.indexName = java.util.Objects.requireNonNull(builder.indexName, "indexName is required");
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
                this.s3Configuration = java.util.Objects.requireNonNull(builder.s3Configuration, "s3Configuration is required");
                this.bufferingHints = builder.bufferingHints;
                this.cloudWatchLoggingOptions = builder.cloudWatchLoggingOptions;
                this.clusterEndpoint = builder.clusterEndpoint;
                this.documentIdOptions = builder.documentIdOptions;
                this.domainArn = builder.domainArn;
                this.indexRotationPeriod = builder.indexRotationPeriod;
                this.processingConfiguration = builder.processingConfiguration;
                this.retryOptions = builder.retryOptions;
                this.s3BackupMode = builder.s3BackupMode;
                this.typeName = builder.typeName;
                this.vpcConfiguration = builder.vpcConfiguration;
            }

            @Override
            public final java.lang.String getIndexName() {
                return this.indexName;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.Object getS3Configuration() {
                return this.s3Configuration;
            }

            @Override
            public final java.lang.Object getBufferingHints() {
                return this.bufferingHints;
            }

            @Override
            public final java.lang.Object getCloudWatchLoggingOptions() {
                return this.cloudWatchLoggingOptions;
            }

            @Override
            public final java.lang.String getClusterEndpoint() {
                return this.clusterEndpoint;
            }

            @Override
            public final java.lang.Object getDocumentIdOptions() {
                return this.documentIdOptions;
            }

            @Override
            public final java.lang.String getDomainArn() {
                return this.domainArn;
            }

            @Override
            public final java.lang.String getIndexRotationPeriod() {
                return this.indexRotationPeriod;
            }

            @Override
            public final java.lang.Object getProcessingConfiguration() {
                return this.processingConfiguration;
            }

            @Override
            public final java.lang.Object getRetryOptions() {
                return this.retryOptions;
            }

            @Override
            public final java.lang.String getS3BackupMode() {
                return this.s3BackupMode;
            }

            @Override
            public final java.lang.String getTypeName() {
                return this.typeName;
            }

            @Override
            public final java.lang.Object getVpcConfiguration() {
                return this.vpcConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("indexName", om.valueToTree(this.getIndexName()));
                data.set("roleArn", om.valueToTree(this.getRoleArn()));
                data.set("s3Configuration", om.valueToTree(this.getS3Configuration()));
                if (this.getBufferingHints() != null) {
                    data.set("bufferingHints", om.valueToTree(this.getBufferingHints()));
                }
                if (this.getCloudWatchLoggingOptions() != null) {
                    data.set("cloudWatchLoggingOptions", om.valueToTree(this.getCloudWatchLoggingOptions()));
                }
                if (this.getClusterEndpoint() != null) {
                    data.set("clusterEndpoint", om.valueToTree(this.getClusterEndpoint()));
                }
                if (this.getDocumentIdOptions() != null) {
                    data.set("documentIdOptions", om.valueToTree(this.getDocumentIdOptions()));
                }
                if (this.getDomainArn() != null) {
                    data.set("domainArn", om.valueToTree(this.getDomainArn()));
                }
                if (this.getIndexRotationPeriod() != null) {
                    data.set("indexRotationPeriod", om.valueToTree(this.getIndexRotationPeriod()));
                }
                if (this.getProcessingConfiguration() != null) {
                    data.set("processingConfiguration", om.valueToTree(this.getProcessingConfiguration()));
                }
                if (this.getRetryOptions() != null) {
                    data.set("retryOptions", om.valueToTree(this.getRetryOptions()));
                }
                if (this.getS3BackupMode() != null) {
                    data.set("s3BackupMode", om.valueToTree(this.getS3BackupMode()));
                }
                if (this.getTypeName() != null) {
                    data.set("typeName", om.valueToTree(this.getTypeName()));
                }
                if (this.getVpcConfiguration() != null) {
                    data.set("vpcConfiguration", om.valueToTree(this.getVpcConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.AmazonopensearchserviceDestinationConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AmazonopensearchserviceDestinationConfigurationProperty.Jsii$Proxy that = (AmazonopensearchserviceDestinationConfigurationProperty.Jsii$Proxy) o;

                if (!indexName.equals(that.indexName)) return false;
                if (!roleArn.equals(that.roleArn)) return false;
                if (!s3Configuration.equals(that.s3Configuration)) return false;
                if (this.bufferingHints != null ? !this.bufferingHints.equals(that.bufferingHints) : that.bufferingHints != null) return false;
                if (this.cloudWatchLoggingOptions != null ? !this.cloudWatchLoggingOptions.equals(that.cloudWatchLoggingOptions) : that.cloudWatchLoggingOptions != null) return false;
                if (this.clusterEndpoint != null ? !this.clusterEndpoint.equals(that.clusterEndpoint) : that.clusterEndpoint != null) return false;
                if (this.documentIdOptions != null ? !this.documentIdOptions.equals(that.documentIdOptions) : that.documentIdOptions != null) return false;
                if (this.domainArn != null ? !this.domainArn.equals(that.domainArn) : that.domainArn != null) return false;
                if (this.indexRotationPeriod != null ? !this.indexRotationPeriod.equals(that.indexRotationPeriod) : that.indexRotationPeriod != null) return false;
                if (this.processingConfiguration != null ? !this.processingConfiguration.equals(that.processingConfiguration) : that.processingConfiguration != null) return false;
                if (this.retryOptions != null ? !this.retryOptions.equals(that.retryOptions) : that.retryOptions != null) return false;
                if (this.s3BackupMode != null ? !this.s3BackupMode.equals(that.s3BackupMode) : that.s3BackupMode != null) return false;
                if (this.typeName != null ? !this.typeName.equals(that.typeName) : that.typeName != null) return false;
                return this.vpcConfiguration != null ? this.vpcConfiguration.equals(that.vpcConfiguration) : that.vpcConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.indexName.hashCode();
                result = 31 * result + (this.roleArn.hashCode());
                result = 31 * result + (this.s3Configuration.hashCode());
                result = 31 * result + (this.bufferingHints != null ? this.bufferingHints.hashCode() : 0);
                result = 31 * result + (this.cloudWatchLoggingOptions != null ? this.cloudWatchLoggingOptions.hashCode() : 0);
                result = 31 * result + (this.clusterEndpoint != null ? this.clusterEndpoint.hashCode() : 0);
                result = 31 * result + (this.documentIdOptions != null ? this.documentIdOptions.hashCode() : 0);
                result = 31 * result + (this.domainArn != null ? this.domainArn.hashCode() : 0);
                result = 31 * result + (this.indexRotationPeriod != null ? this.indexRotationPeriod.hashCode() : 0);
                result = 31 * result + (this.processingConfiguration != null ? this.processingConfiguration.hashCode() : 0);
                result = 31 * result + (this.retryOptions != null ? this.retryOptions.hashCode() : 0);
                result = 31 * result + (this.s3BackupMode != null ? this.s3BackupMode.hashCode() : 0);
                result = 31 * result + (this.typeName != null ? this.typeName.hashCode() : 0);
                result = 31 * result + (this.vpcConfiguration != null ? this.vpcConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configures retry behavior in case Kinesis Data Firehose is unable to deliver documents to Amazon OpenSearch Service.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * AmazonopensearchserviceRetryOptionsProperty amazonopensearchserviceRetryOptionsProperty = AmazonopensearchserviceRetryOptionsProperty.builder()
     *         .durationInSeconds(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-amazonopensearchserviceretryoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-amazonopensearchserviceretryoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.AmazonopensearchserviceRetryOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(AmazonopensearchserviceRetryOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AmazonopensearchserviceRetryOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * After an initial failure to deliver to Amazon OpenSearch Service, the total amount of time during which Kinesis Data Firehose retries delivery (including the first attempt).
         * <p>
         * After this time has elapsed, the failed documents are written to Amazon S3. Default value is 300 seconds (5 minutes). A value of 0 (zero) results in no retries.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-amazonopensearchserviceretryoptions.html#cfn-kinesisfirehose-deliverystream-amazonopensearchserviceretryoptions-durationinseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-amazonopensearchserviceretryoptions.html#cfn-kinesisfirehose-deliverystream-amazonopensearchserviceretryoptions-durationinseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDurationInSeconds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AmazonopensearchserviceRetryOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AmazonopensearchserviceRetryOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AmazonopensearchserviceRetryOptionsProperty> {
            java.lang.Number durationInSeconds;

            /**
             * Sets the value of {@link AmazonopensearchserviceRetryOptionsProperty#getDurationInSeconds}
             * @param durationInSeconds After an initial failure to deliver to Amazon OpenSearch Service, the total amount of time during which Kinesis Data Firehose retries delivery (including the first attempt).
             *                          After this time has elapsed, the failed documents are written to Amazon S3. Default value is 300 seconds (5 minutes). A value of 0 (zero) results in no retries.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder durationInSeconds(java.lang.Number durationInSeconds) {
                this.durationInSeconds = durationInSeconds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AmazonopensearchserviceRetryOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AmazonopensearchserviceRetryOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AmazonopensearchserviceRetryOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AmazonopensearchserviceRetryOptionsProperty {
            private final java.lang.Number durationInSeconds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.durationInSeconds = software.amazon.jsii.Kernel.get(this, "durationInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.durationInSeconds = builder.durationInSeconds;
            }

            @Override
            public final java.lang.Number getDurationInSeconds() {
                return this.durationInSeconds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDurationInSeconds() != null) {
                    data.set("durationInSeconds", om.valueToTree(this.getDurationInSeconds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.AmazonopensearchserviceRetryOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AmazonopensearchserviceRetryOptionsProperty.Jsii$Proxy that = (AmazonopensearchserviceRetryOptionsProperty.Jsii$Proxy) o;

                return this.durationInSeconds != null ? this.durationInSeconds.equals(that.durationInSeconds) : that.durationInSeconds == null;
            }

            @Override
            public final int hashCode() {
                int result = this.durationInSeconds != null ? this.durationInSeconds.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The authentication configuration of the Amazon MSK cluster.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * AuthenticationConfigurationProperty authenticationConfigurationProperty = AuthenticationConfigurationProperty.builder()
     *         .connectivity("connectivity")
     *         .roleArn("roleArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-authenticationconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-authenticationconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.AuthenticationConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(AuthenticationConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AuthenticationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of connectivity used to access the Amazon MSK cluster.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-authenticationconfiguration.html#cfn-kinesisfirehose-deliverystream-authenticationconfiguration-connectivity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-authenticationconfiguration.html#cfn-kinesisfirehose-deliverystream-authenticationconfiguration-connectivity</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getConnectivity();

        /**
         * The ARN of the role used to access the Amazon MSK cluster.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-authenticationconfiguration.html#cfn-kinesisfirehose-deliverystream-authenticationconfiguration-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-authenticationconfiguration.html#cfn-kinesisfirehose-deliverystream-authenticationconfiguration-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * @return a {@link Builder} of {@link AuthenticationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AuthenticationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AuthenticationConfigurationProperty> {
            java.lang.String connectivity;
            java.lang.String roleArn;

            /**
             * Sets the value of {@link AuthenticationConfigurationProperty#getConnectivity}
             * @param connectivity The type of connectivity used to access the Amazon MSK cluster. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectivity(java.lang.String connectivity) {
                this.connectivity = connectivity;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticationConfigurationProperty#getRoleArn}
             * @param roleArn The ARN of the role used to access the Amazon MSK cluster. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AuthenticationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AuthenticationConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AuthenticationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AuthenticationConfigurationProperty {
            private final java.lang.String connectivity;
            private final java.lang.String roleArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.connectivity = software.amazon.jsii.Kernel.get(this, "connectivity", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.connectivity = java.util.Objects.requireNonNull(builder.connectivity, "connectivity is required");
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
            }

            @Override
            public final java.lang.String getConnectivity() {
                return this.connectivity;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("connectivity", om.valueToTree(this.getConnectivity()));
                data.set("roleArn", om.valueToTree(this.getRoleArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.AuthenticationConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AuthenticationConfigurationProperty.Jsii$Proxy that = (AuthenticationConfigurationProperty.Jsii$Proxy) o;

                if (!connectivity.equals(that.connectivity)) return false;
                return this.roleArn.equals(that.roleArn);
            }

            @Override
            public final int hashCode() {
                int result = this.connectivity.hashCode();
                result = 31 * result + (this.roleArn.hashCode());
                return result;
            }
        }
    }
    /**
     * The <code>BufferingHints</code> property type specifies how Amazon Kinesis Data Firehose (Kinesis Data Firehose) buffers incoming data before delivering it to the destination.
     * <p>
     * The first buffer condition that is satisfied triggers Kinesis Data Firehose to deliver the data.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * BufferingHintsProperty bufferingHintsProperty = BufferingHintsProperty.builder()
     *         .intervalInSeconds(123)
     *         .sizeInMBs(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-bufferinghints.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-bufferinghints.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.BufferingHintsProperty")
    @software.amazon.jsii.Jsii.Proxy(BufferingHintsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BufferingHintsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The length of time, in seconds, that Kinesis Data Firehose buffers incoming data before delivering it to the destination.
         * <p>
         * For valid values, see the <code>IntervalInSeconds</code> content for the <a href="https://docs.aws.amazon.com/firehose/latest/APIReference/API_BufferingHints.html">BufferingHints</a> data type in the <em>Amazon Kinesis Data Firehose API Reference</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-bufferinghints.html#cfn-kinesisfirehose-deliverystream-bufferinghints-intervalinseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-bufferinghints.html#cfn-kinesisfirehose-deliverystream-bufferinghints-intervalinseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getIntervalInSeconds() {
            return null;
        }

        /**
         * The size of the buffer, in MBs, that Kinesis Data Firehose uses for incoming data before delivering it to the destination.
         * <p>
         * For valid values, see the <code>SizeInMBs</code> content for the <a href="https://docs.aws.amazon.com/firehose/latest/APIReference/API_BufferingHints.html">BufferingHints</a> data type in the <em>Amazon Kinesis Data Firehose API Reference</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-bufferinghints.html#cfn-kinesisfirehose-deliverystream-bufferinghints-sizeinmbs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-bufferinghints.html#cfn-kinesisfirehose-deliverystream-bufferinghints-sizeinmbs</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSizeInMBs() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BufferingHintsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BufferingHintsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BufferingHintsProperty> {
            java.lang.Number intervalInSeconds;
            java.lang.Number sizeInMBs;

            /**
             * Sets the value of {@link BufferingHintsProperty#getIntervalInSeconds}
             * @param intervalInSeconds The length of time, in seconds, that Kinesis Data Firehose buffers incoming data before delivering it to the destination.
             *                          For valid values, see the <code>IntervalInSeconds</code> content for the <a href="https://docs.aws.amazon.com/firehose/latest/APIReference/API_BufferingHints.html">BufferingHints</a> data type in the <em>Amazon Kinesis Data Firehose API Reference</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder intervalInSeconds(java.lang.Number intervalInSeconds) {
                this.intervalInSeconds = intervalInSeconds;
                return this;
            }

            /**
             * Sets the value of {@link BufferingHintsProperty#getSizeInMBs}
             * @param sizeInMBs The size of the buffer, in MBs, that Kinesis Data Firehose uses for incoming data before delivering it to the destination.
             *                  For valid values, see the <code>SizeInMBs</code> content for the <a href="https://docs.aws.amazon.com/firehose/latest/APIReference/API_BufferingHints.html">BufferingHints</a> data type in the <em>Amazon Kinesis Data Firehose API Reference</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sizeInMBs(java.lang.Number sizeInMBs) {
                this.sizeInMBs = sizeInMBs;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BufferingHintsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BufferingHintsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BufferingHintsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BufferingHintsProperty {
            private final java.lang.Number intervalInSeconds;
            private final java.lang.Number sizeInMBs;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.intervalInSeconds = software.amazon.jsii.Kernel.get(this, "intervalInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.sizeInMBs = software.amazon.jsii.Kernel.get(this, "sizeInMBs", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.intervalInSeconds = builder.intervalInSeconds;
                this.sizeInMBs = builder.sizeInMBs;
            }

            @Override
            public final java.lang.Number getIntervalInSeconds() {
                return this.intervalInSeconds;
            }

            @Override
            public final java.lang.Number getSizeInMBs() {
                return this.sizeInMBs;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getIntervalInSeconds() != null) {
                    data.set("intervalInSeconds", om.valueToTree(this.getIntervalInSeconds()));
                }
                if (this.getSizeInMBs() != null) {
                    data.set("sizeInMBs", om.valueToTree(this.getSizeInMBs()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.BufferingHintsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BufferingHintsProperty.Jsii$Proxy that = (BufferingHintsProperty.Jsii$Proxy) o;

                if (this.intervalInSeconds != null ? !this.intervalInSeconds.equals(that.intervalInSeconds) : that.intervalInSeconds != null) return false;
                return this.sizeInMBs != null ? this.sizeInMBs.equals(that.sizeInMBs) : that.sizeInMBs == null;
            }

            @Override
            public final int hashCode() {
                int result = this.intervalInSeconds != null ? this.intervalInSeconds.hashCode() : 0;
                result = 31 * result + (this.sizeInMBs != null ? this.sizeInMBs.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes the containers where the destination Apache Iceberg Tables are persisted.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * CatalogConfigurationProperty catalogConfigurationProperty = CatalogConfigurationProperty.builder()
     *         .catalogArn("catalogArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-catalogconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-catalogconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.CatalogConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(CatalogConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CatalogConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the Glue catalog ARN identifier of the destination Apache Iceberg Tables.
         * <p>
         * You must specify the ARN in the format <code>arn:aws:glue:region:account-id:catalog</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-catalogconfiguration.html#cfn-kinesisfirehose-deliverystream-catalogconfiguration-catalogarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-catalogconfiguration.html#cfn-kinesisfirehose-deliverystream-catalogconfiguration-catalogarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCatalogArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CatalogConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CatalogConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CatalogConfigurationProperty> {
            java.lang.String catalogArn;

            /**
             * Sets the value of {@link CatalogConfigurationProperty#getCatalogArn}
             * @param catalogArn Specifies the Glue catalog ARN identifier of the destination Apache Iceberg Tables.
             *                   You must specify the ARN in the format <code>arn:aws:glue:region:account-id:catalog</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder catalogArn(java.lang.String catalogArn) {
                this.catalogArn = catalogArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CatalogConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CatalogConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CatalogConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CatalogConfigurationProperty {
            private final java.lang.String catalogArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.catalogArn = software.amazon.jsii.Kernel.get(this, "catalogArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.catalogArn = builder.catalogArn;
            }

            @Override
            public final java.lang.String getCatalogArn() {
                return this.catalogArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCatalogArn() != null) {
                    data.set("catalogArn", om.valueToTree(this.getCatalogArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.CatalogConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CatalogConfigurationProperty.Jsii$Proxy that = (CatalogConfigurationProperty.Jsii$Proxy) o;

                return this.catalogArn != null ? this.catalogArn.equals(that.catalogArn) : that.catalogArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.catalogArn != null ? this.catalogArn.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The <code>CloudWatchLoggingOptions</code> property type specifies Amazon CloudWatch Logs (CloudWatch Logs) logging options that Amazon Kinesis Data Firehose (Kinesis Data Firehose) uses for the delivery stream.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * CloudWatchLoggingOptionsProperty cloudWatchLoggingOptionsProperty = CloudWatchLoggingOptionsProperty.builder()
     *         .enabled(false)
     *         .logGroupName("logGroupName")
     *         .logStreamName("logStreamName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-cloudwatchloggingoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-cloudwatchloggingoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.CloudWatchLoggingOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(CloudWatchLoggingOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CloudWatchLoggingOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates whether CloudWatch Logs logging is enabled.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-cloudwatchloggingoptions.html#cfn-kinesisfirehose-deliverystream-cloudwatchloggingoptions-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-cloudwatchloggingoptions.html#cfn-kinesisfirehose-deliverystream-cloudwatchloggingoptions-enabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * The name of the CloudWatch Logs log group that contains the log stream that Kinesis Data Firehose will use.
         * <p>
         * Conditional. If you enable logging, you must specify this property.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-cloudwatchloggingoptions.html#cfn-kinesisfirehose-deliverystream-cloudwatchloggingoptions-loggroupname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-cloudwatchloggingoptions.html#cfn-kinesisfirehose-deliverystream-cloudwatchloggingoptions-loggroupname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLogGroupName() {
            return null;
        }

        /**
         * The name of the CloudWatch Logs log stream that Kinesis Data Firehose uses to send logs about data delivery.
         * <p>
         * Conditional. If you enable logging, you must specify this property.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-cloudwatchloggingoptions.html#cfn-kinesisfirehose-deliverystream-cloudwatchloggingoptions-logstreamname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-cloudwatchloggingoptions.html#cfn-kinesisfirehose-deliverystream-cloudwatchloggingoptions-logstreamname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLogStreamName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CloudWatchLoggingOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CloudWatchLoggingOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CloudWatchLoggingOptionsProperty> {
            java.lang.Object enabled;
            java.lang.String logGroupName;
            java.lang.String logStreamName;

            /**
             * Sets the value of {@link CloudWatchLoggingOptionsProperty#getEnabled}
             * @param enabled Indicates whether CloudWatch Logs logging is enabled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link CloudWatchLoggingOptionsProperty#getEnabled}
             * @param enabled Indicates whether CloudWatch Logs logging is enabled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link CloudWatchLoggingOptionsProperty#getLogGroupName}
             * @param logGroupName The name of the CloudWatch Logs log group that contains the log stream that Kinesis Data Firehose will use.
             *                     Conditional. If you enable logging, you must specify this property.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logGroupName(java.lang.String logGroupName) {
                this.logGroupName = logGroupName;
                return this;
            }

            /**
             * Sets the value of {@link CloudWatchLoggingOptionsProperty#getLogStreamName}
             * @param logStreamName The name of the CloudWatch Logs log stream that Kinesis Data Firehose uses to send logs about data delivery.
             *                      Conditional. If you enable logging, you must specify this property.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logStreamName(java.lang.String logStreamName) {
                this.logStreamName = logStreamName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CloudWatchLoggingOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CloudWatchLoggingOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CloudWatchLoggingOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CloudWatchLoggingOptionsProperty {
            private final java.lang.Object enabled;
            private final java.lang.String logGroupName;
            private final java.lang.String logStreamName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.logGroupName = software.amazon.jsii.Kernel.get(this, "logGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.logStreamName = software.amazon.jsii.Kernel.get(this, "logStreamName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = builder.enabled;
                this.logGroupName = builder.logGroupName;
                this.logStreamName = builder.logStreamName;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.String getLogGroupName() {
                return this.logGroupName;
            }

            @Override
            public final java.lang.String getLogStreamName() {
                return this.logStreamName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }
                if (this.getLogGroupName() != null) {
                    data.set("logGroupName", om.valueToTree(this.getLogGroupName()));
                }
                if (this.getLogStreamName() != null) {
                    data.set("logStreamName", om.valueToTree(this.getLogStreamName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.CloudWatchLoggingOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CloudWatchLoggingOptionsProperty.Jsii$Proxy that = (CloudWatchLoggingOptionsProperty.Jsii$Proxy) o;

                if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
                if (this.logGroupName != null ? !this.logGroupName.equals(that.logGroupName) : that.logGroupName != null) return false;
                return this.logStreamName != null ? this.logStreamName.equals(that.logStreamName) : that.logStreamName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled != null ? this.enabled.hashCode() : 0;
                result = 31 * result + (this.logGroupName != null ? this.logGroupName.hashCode() : 0);
                result = 31 * result + (this.logStreamName != null ? this.logStreamName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The <code>CopyCommand</code> property type configures the Amazon Redshift <code>COPY</code> command that Amazon Kinesis Data Firehose (Kinesis Data Firehose) uses to load data into an Amazon Redshift cluster from an Amazon S3 bucket.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * CopyCommandProperty copyCommandProperty = CopyCommandProperty.builder()
     *         .dataTableName("dataTableName")
     *         // the properties below are optional
     *         .copyOptions("copyOptions")
     *         .dataTableColumns("dataTableColumns")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-copycommand.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-copycommand.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.CopyCommandProperty")
    @software.amazon.jsii.Jsii.Proxy(CopyCommandProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CopyCommandProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the target table.
         * <p>
         * The table must already exist in the database.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-copycommand.html#cfn-kinesisfirehose-deliverystream-copycommand-datatablename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-copycommand.html#cfn-kinesisfirehose-deliverystream-copycommand-datatablename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDataTableName();

        /**
         * Parameters to use with the Amazon Redshift <code>COPY</code> command.
         * <p>
         * For examples, see the <code>CopyOptions</code> content for the <a href="https://docs.aws.amazon.com/firehose/latest/APIReference/API_CopyCommand.html">CopyCommand</a> data type in the <em>Amazon Kinesis Data Firehose API Reference</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-copycommand.html#cfn-kinesisfirehose-deliverystream-copycommand-copyoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-copycommand.html#cfn-kinesisfirehose-deliverystream-copycommand-copyoptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCopyOptions() {
            return null;
        }

        /**
         * A comma-separated list of column names.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-copycommand.html#cfn-kinesisfirehose-deliverystream-copycommand-datatablecolumns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-copycommand.html#cfn-kinesisfirehose-deliverystream-copycommand-datatablecolumns</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDataTableColumns() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CopyCommandProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CopyCommandProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CopyCommandProperty> {
            java.lang.String dataTableName;
            java.lang.String copyOptions;
            java.lang.String dataTableColumns;

            /**
             * Sets the value of {@link CopyCommandProperty#getDataTableName}
             * @param dataTableName The name of the target table. This parameter is required.
             *                      The table must already exist in the database.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataTableName(java.lang.String dataTableName) {
                this.dataTableName = dataTableName;
                return this;
            }

            /**
             * Sets the value of {@link CopyCommandProperty#getCopyOptions}
             * @param copyOptions Parameters to use with the Amazon Redshift <code>COPY</code> command.
             *                    For examples, see the <code>CopyOptions</code> content for the <a href="https://docs.aws.amazon.com/firehose/latest/APIReference/API_CopyCommand.html">CopyCommand</a> data type in the <em>Amazon Kinesis Data Firehose API Reference</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder copyOptions(java.lang.String copyOptions) {
                this.copyOptions = copyOptions;
                return this;
            }

            /**
             * Sets the value of {@link CopyCommandProperty#getDataTableColumns}
             * @param dataTableColumns A comma-separated list of column names.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataTableColumns(java.lang.String dataTableColumns) {
                this.dataTableColumns = dataTableColumns;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CopyCommandProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CopyCommandProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CopyCommandProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CopyCommandProperty {
            private final java.lang.String dataTableName;
            private final java.lang.String copyOptions;
            private final java.lang.String dataTableColumns;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dataTableName = software.amazon.jsii.Kernel.get(this, "dataTableName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.copyOptions = software.amazon.jsii.Kernel.get(this, "copyOptions", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dataTableColumns = software.amazon.jsii.Kernel.get(this, "dataTableColumns", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dataTableName = java.util.Objects.requireNonNull(builder.dataTableName, "dataTableName is required");
                this.copyOptions = builder.copyOptions;
                this.dataTableColumns = builder.dataTableColumns;
            }

            @Override
            public final java.lang.String getDataTableName() {
                return this.dataTableName;
            }

            @Override
            public final java.lang.String getCopyOptions() {
                return this.copyOptions;
            }

            @Override
            public final java.lang.String getDataTableColumns() {
                return this.dataTableColumns;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("dataTableName", om.valueToTree(this.getDataTableName()));
                if (this.getCopyOptions() != null) {
                    data.set("copyOptions", om.valueToTree(this.getCopyOptions()));
                }
                if (this.getDataTableColumns() != null) {
                    data.set("dataTableColumns", om.valueToTree(this.getDataTableColumns()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.CopyCommandProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CopyCommandProperty.Jsii$Proxy that = (CopyCommandProperty.Jsii$Proxy) o;

                if (!dataTableName.equals(that.dataTableName)) return false;
                if (this.copyOptions != null ? !this.copyOptions.equals(that.copyOptions) : that.copyOptions != null) return false;
                return this.dataTableColumns != null ? this.dataTableColumns.equals(that.dataTableColumns) : that.dataTableColumns == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dataTableName.hashCode();
                result = 31 * result + (this.copyOptions != null ? this.copyOptions.hashCode() : 0);
                result = 31 * result + (this.dataTableColumns != null ? this.dataTableColumns.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies that you want Kinesis Data Firehose to convert data from the JSON format to the Parquet or ORC format before writing it to Amazon S3.
     * <p>
     * Kinesis Data Firehose uses the serializer and deserializer that you specify, in addition to the column information from the AWS Glue table, to deserialize your input data from JSON and then serialize it to the Parquet or ORC format. For more information, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/record-format-conversion.html">Kinesis Data Firehose Record Format Conversion</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * DataFormatConversionConfigurationProperty dataFormatConversionConfigurationProperty = DataFormatConversionConfigurationProperty.builder()
     *         .enabled(false)
     *         .inputFormatConfiguration(InputFormatConfigurationProperty.builder()
     *                 .deserializer(DeserializerProperty.builder()
     *                         .hiveJsonSerDe(HiveJsonSerDeProperty.builder()
     *                                 .timestampFormats(List.of("timestampFormats"))
     *                                 .build())
     *                         .openXJsonSerDe(OpenXJsonSerDeProperty.builder()
     *                                 .caseInsensitive(false)
     *                                 .columnToJsonKeyMappings(Map.of(
     *                                         "columnToJsonKeyMappingsKey", "columnToJsonKeyMappings"))
     *                                 .convertDotsInJsonKeysToUnderscores(false)
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .outputFormatConfiguration(OutputFormatConfigurationProperty.builder()
     *                 .serializer(SerializerProperty.builder()
     *                         .orcSerDe(OrcSerDeProperty.builder()
     *                                 .blockSizeBytes(123)
     *                                 .bloomFilterColumns(List.of("bloomFilterColumns"))
     *                                 .bloomFilterFalsePositiveProbability(123)
     *                                 .compression("compression")
     *                                 .dictionaryKeyThreshold(123)
     *                                 .enablePadding(false)
     *                                 .formatVersion("formatVersion")
     *                                 .paddingTolerance(123)
     *                                 .rowIndexStride(123)
     *                                 .stripeSizeBytes(123)
     *                                 .build())
     *                         .parquetSerDe(ParquetSerDeProperty.builder()
     *                                 .blockSizeBytes(123)
     *                                 .compression("compression")
     *                                 .enableDictionaryCompression(false)
     *                                 .maxPaddingBytes(123)
     *                                 .pageSizeBytes(123)
     *                                 .writerVersion("writerVersion")
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .schemaConfiguration(SchemaConfigurationProperty.builder()
     *                 .catalogId("catalogId")
     *                 .databaseName("databaseName")
     *                 .region("region")
     *                 .roleArn("roleArn")
     *                 .tableName("tableName")
     *                 .versionId("versionId")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-dataformatconversionconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-dataformatconversionconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.DataFormatConversionConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(DataFormatConversionConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataFormatConversionConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Defaults to <code>true</code> .
         * <p>
         * Set it to <code>false</code> if you want to disable format conversion while preserving the configuration details.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-dataformatconversionconfiguration.html#cfn-kinesisfirehose-deliverystream-dataformatconversionconfiguration-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-dataformatconversionconfiguration.html#cfn-kinesisfirehose-deliverystream-dataformatconversionconfiguration-enabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * Specifies the deserializer that you want Firehose to use to convert the format of your data from JSON.
         * <p>
         * This parameter is required if <code>Enabled</code> is set to true.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-dataformatconversionconfiguration.html#cfn-kinesisfirehose-deliverystream-dataformatconversionconfiguration-inputformatconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-dataformatconversionconfiguration.html#cfn-kinesisfirehose-deliverystream-dataformatconversionconfiguration-inputformatconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInputFormatConfiguration() {
            return null;
        }

        /**
         * Specifies the serializer that you want Firehose to use to convert the format of your data to the Parquet or ORC format.
         * <p>
         * This parameter is required if <code>Enabled</code> is set to true.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-dataformatconversionconfiguration.html#cfn-kinesisfirehose-deliverystream-dataformatconversionconfiguration-outputformatconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-dataformatconversionconfiguration.html#cfn-kinesisfirehose-deliverystream-dataformatconversionconfiguration-outputformatconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOutputFormatConfiguration() {
            return null;
        }

        /**
         * Specifies the AWS Glue Data Catalog table that contains the column information.
         * <p>
         * This parameter is required if <code>Enabled</code> is set to true.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-dataformatconversionconfiguration.html#cfn-kinesisfirehose-deliverystream-dataformatconversionconfiguration-schemaconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-dataformatconversionconfiguration.html#cfn-kinesisfirehose-deliverystream-dataformatconversionconfiguration-schemaconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSchemaConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DataFormatConversionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataFormatConversionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataFormatConversionConfigurationProperty> {
            java.lang.Object enabled;
            java.lang.Object inputFormatConfiguration;
            java.lang.Object outputFormatConfiguration;
            java.lang.Object schemaConfiguration;

            /**
             * Sets the value of {@link DataFormatConversionConfigurationProperty#getEnabled}
             * @param enabled Defaults to <code>true</code> .
             *                Set it to <code>false</code> if you want to disable format conversion while preserving the configuration details.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link DataFormatConversionConfigurationProperty#getEnabled}
             * @param enabled Defaults to <code>true</code> .
             *                Set it to <code>false</code> if you want to disable format conversion while preserving the configuration details.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link DataFormatConversionConfigurationProperty#getInputFormatConfiguration}
             * @param inputFormatConfiguration Specifies the deserializer that you want Firehose to use to convert the format of your data from JSON.
             *                                 This parameter is required if <code>Enabled</code> is set to true.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputFormatConfiguration(software.amazon.awscdk.IResolvable inputFormatConfiguration) {
                this.inputFormatConfiguration = inputFormatConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DataFormatConversionConfigurationProperty#getInputFormatConfiguration}
             * @param inputFormatConfiguration Specifies the deserializer that you want Firehose to use to convert the format of your data from JSON.
             *                                 This parameter is required if <code>Enabled</code> is set to true.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputFormatConfiguration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.InputFormatConfigurationProperty inputFormatConfiguration) {
                this.inputFormatConfiguration = inputFormatConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DataFormatConversionConfigurationProperty#getOutputFormatConfiguration}
             * @param outputFormatConfiguration Specifies the serializer that you want Firehose to use to convert the format of your data to the Parquet or ORC format.
             *                                  This parameter is required if <code>Enabled</code> is set to true.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputFormatConfiguration(software.amazon.awscdk.IResolvable outputFormatConfiguration) {
                this.outputFormatConfiguration = outputFormatConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DataFormatConversionConfigurationProperty#getOutputFormatConfiguration}
             * @param outputFormatConfiguration Specifies the serializer that you want Firehose to use to convert the format of your data to the Parquet or ORC format.
             *                                  This parameter is required if <code>Enabled</code> is set to true.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputFormatConfiguration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.OutputFormatConfigurationProperty outputFormatConfiguration) {
                this.outputFormatConfiguration = outputFormatConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DataFormatConversionConfigurationProperty#getSchemaConfiguration}
             * @param schemaConfiguration Specifies the AWS Glue Data Catalog table that contains the column information.
             *                            This parameter is required if <code>Enabled</code> is set to true.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder schemaConfiguration(software.amazon.awscdk.IResolvable schemaConfiguration) {
                this.schemaConfiguration = schemaConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DataFormatConversionConfigurationProperty#getSchemaConfiguration}
             * @param schemaConfiguration Specifies the AWS Glue Data Catalog table that contains the column information.
             *                            This parameter is required if <code>Enabled</code> is set to true.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder schemaConfiguration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.SchemaConfigurationProperty schemaConfiguration) {
                this.schemaConfiguration = schemaConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataFormatConversionConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataFormatConversionConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataFormatConversionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataFormatConversionConfigurationProperty {
            private final java.lang.Object enabled;
            private final java.lang.Object inputFormatConfiguration;
            private final java.lang.Object outputFormatConfiguration;
            private final java.lang.Object schemaConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.inputFormatConfiguration = software.amazon.jsii.Kernel.get(this, "inputFormatConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.outputFormatConfiguration = software.amazon.jsii.Kernel.get(this, "outputFormatConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.schemaConfiguration = software.amazon.jsii.Kernel.get(this, "schemaConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = builder.enabled;
                this.inputFormatConfiguration = builder.inputFormatConfiguration;
                this.outputFormatConfiguration = builder.outputFormatConfiguration;
                this.schemaConfiguration = builder.schemaConfiguration;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.Object getInputFormatConfiguration() {
                return this.inputFormatConfiguration;
            }

            @Override
            public final java.lang.Object getOutputFormatConfiguration() {
                return this.outputFormatConfiguration;
            }

            @Override
            public final java.lang.Object getSchemaConfiguration() {
                return this.schemaConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }
                if (this.getInputFormatConfiguration() != null) {
                    data.set("inputFormatConfiguration", om.valueToTree(this.getInputFormatConfiguration()));
                }
                if (this.getOutputFormatConfiguration() != null) {
                    data.set("outputFormatConfiguration", om.valueToTree(this.getOutputFormatConfiguration()));
                }
                if (this.getSchemaConfiguration() != null) {
                    data.set("schemaConfiguration", om.valueToTree(this.getSchemaConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.DataFormatConversionConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataFormatConversionConfigurationProperty.Jsii$Proxy that = (DataFormatConversionConfigurationProperty.Jsii$Proxy) o;

                if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
                if (this.inputFormatConfiguration != null ? !this.inputFormatConfiguration.equals(that.inputFormatConfiguration) : that.inputFormatConfiguration != null) return false;
                if (this.outputFormatConfiguration != null ? !this.outputFormatConfiguration.equals(that.outputFormatConfiguration) : that.outputFormatConfiguration != null) return false;
                return this.schemaConfiguration != null ? this.schemaConfiguration.equals(that.schemaConfiguration) : that.schemaConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled != null ? this.enabled.hashCode() : 0;
                result = 31 * result + (this.inputFormatConfiguration != null ? this.inputFormatConfiguration.hashCode() : 0);
                result = 31 * result + (this.outputFormatConfiguration != null ? this.outputFormatConfiguration.hashCode() : 0);
                result = 31 * result + (this.schemaConfiguration != null ? this.schemaConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * DatabaseColumnsProperty databaseColumnsProperty = DatabaseColumnsProperty.builder()
     *         .exclude(List.of("exclude"))
     *         .include(List.of("include"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-databasecolumns.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-databasecolumns.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.DatabaseColumnsProperty")
    @software.amazon.jsii.Jsii.Proxy(DatabaseColumnsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DatabaseColumnsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-databasecolumns.html#cfn-kinesisfirehose-deliverystream-databasecolumns-exclude">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-databasecolumns.html#cfn-kinesisfirehose-deliverystream-databasecolumns-exclude</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExclude() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-databasecolumns.html#cfn-kinesisfirehose-deliverystream-databasecolumns-include">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-databasecolumns.html#cfn-kinesisfirehose-deliverystream-databasecolumns-include</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getInclude() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DatabaseColumnsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DatabaseColumnsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DatabaseColumnsProperty> {
            java.util.List<java.lang.String> exclude;
            java.util.List<java.lang.String> include;

            /**
             * Sets the value of {@link DatabaseColumnsProperty#getExclude}
             * @param exclude the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exclude(java.util.List<java.lang.String> exclude) {
                this.exclude = exclude;
                return this;
            }

            /**
             * Sets the value of {@link DatabaseColumnsProperty#getInclude}
             * @param include the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder include(java.util.List<java.lang.String> include) {
                this.include = include;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DatabaseColumnsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DatabaseColumnsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DatabaseColumnsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DatabaseColumnsProperty {
            private final java.util.List<java.lang.String> exclude;
            private final java.util.List<java.lang.String> include;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.exclude = software.amazon.jsii.Kernel.get(this, "exclude", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.include = software.amazon.jsii.Kernel.get(this, "include", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.exclude = builder.exclude;
                this.include = builder.include;
            }

            @Override
            public final java.util.List<java.lang.String> getExclude() {
                return this.exclude;
            }

            @Override
            public final java.util.List<java.lang.String> getInclude() {
                return this.include;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getExclude() != null) {
                    data.set("exclude", om.valueToTree(this.getExclude()));
                }
                if (this.getInclude() != null) {
                    data.set("include", om.valueToTree(this.getInclude()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.DatabaseColumnsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DatabaseColumnsProperty.Jsii$Proxy that = (DatabaseColumnsProperty.Jsii$Proxy) o;

                if (this.exclude != null ? !this.exclude.equals(that.exclude) : that.exclude != null) return false;
                return this.include != null ? this.include.equals(that.include) : that.include == null;
            }

            @Override
            public final int hashCode() {
                int result = this.exclude != null ? this.exclude.hashCode() : 0;
                result = 31 * result + (this.include != null ? this.include.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The structure to configure the authentication methods for Firehose to connect to source database endpoint.
     * <p>
     * Amazon Data Firehose is in preview release and is subject to change.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * DatabaseSourceAuthenticationConfigurationProperty databaseSourceAuthenticationConfigurationProperty = DatabaseSourceAuthenticationConfigurationProperty.builder()
     *         .secretsManagerConfiguration(SecretsManagerConfigurationProperty.builder()
     *                 .enabled(false)
     *                 // the properties below are optional
     *                 .roleArn("roleArn")
     *                 .secretArn("secretArn")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-databasesourceauthenticationconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-databasesourceauthenticationconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.DatabaseSourceAuthenticationConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(DatabaseSourceAuthenticationConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DatabaseSourceAuthenticationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-databasesourceauthenticationconfiguration.html#cfn-kinesisfirehose-deliverystream-databasesourceauthenticationconfiguration-secretsmanagerconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-databasesourceauthenticationconfiguration.html#cfn-kinesisfirehose-deliverystream-databasesourceauthenticationconfiguration-secretsmanagerconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getSecretsManagerConfiguration();

        /**
         * @return a {@link Builder} of {@link DatabaseSourceAuthenticationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DatabaseSourceAuthenticationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DatabaseSourceAuthenticationConfigurationProperty> {
            java.lang.Object secretsManagerConfiguration;

            /**
             * Sets the value of {@link DatabaseSourceAuthenticationConfigurationProperty#getSecretsManagerConfiguration}
             * @param secretsManagerConfiguration the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerConfiguration(software.amazon.awscdk.IResolvable secretsManagerConfiguration) {
                this.secretsManagerConfiguration = secretsManagerConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DatabaseSourceAuthenticationConfigurationProperty#getSecretsManagerConfiguration}
             * @param secretsManagerConfiguration the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerConfiguration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.SecretsManagerConfigurationProperty secretsManagerConfiguration) {
                this.secretsManagerConfiguration = secretsManagerConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DatabaseSourceAuthenticationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DatabaseSourceAuthenticationConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DatabaseSourceAuthenticationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DatabaseSourceAuthenticationConfigurationProperty {
            private final java.lang.Object secretsManagerConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.secretsManagerConfiguration = software.amazon.jsii.Kernel.get(this, "secretsManagerConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.secretsManagerConfiguration = java.util.Objects.requireNonNull(builder.secretsManagerConfiguration, "secretsManagerConfiguration is required");
            }

            @Override
            public final java.lang.Object getSecretsManagerConfiguration() {
                return this.secretsManagerConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("secretsManagerConfiguration", om.valueToTree(this.getSecretsManagerConfiguration()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.DatabaseSourceAuthenticationConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DatabaseSourceAuthenticationConfigurationProperty.Jsii$Proxy that = (DatabaseSourceAuthenticationConfigurationProperty.Jsii$Proxy) o;

                return this.secretsManagerConfiguration.equals(that.secretsManagerConfiguration);
            }

            @Override
            public final int hashCode() {
                int result = this.secretsManagerConfiguration.hashCode();
                return result;
            }
        }
    }
    /**
     * The top level object for configuring streams with database as a source.
     * <p>
     * Amazon Data Firehose is in preview release and is subject to change.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * DatabaseSourceConfigurationProperty databaseSourceConfigurationProperty = DatabaseSourceConfigurationProperty.builder()
     *         .databases(DatabasesProperty.builder()
     *                 .exclude(List.of("exclude"))
     *                 .include(List.of("include"))
     *                 .build())
     *         .databaseSourceAuthenticationConfiguration(DatabaseSourceAuthenticationConfigurationProperty.builder()
     *                 .secretsManagerConfiguration(SecretsManagerConfigurationProperty.builder()
     *                         .enabled(false)
     *                         // the properties below are optional
     *                         .roleArn("roleArn")
     *                         .secretArn("secretArn")
     *                         .build())
     *                 .build())
     *         .databaseSourceVpcConfiguration(DatabaseSourceVPCConfigurationProperty.builder()
     *                 .vpcEndpointServiceName("vpcEndpointServiceName")
     *                 .build())
     *         .endpoint("endpoint")
     *         .port(123)
     *         .snapshotWatermarkTable("snapshotWatermarkTable")
     *         .tables(DatabaseTablesProperty.builder()
     *                 .exclude(List.of("exclude"))
     *                 .include(List.of("include"))
     *                 .build())
     *         .type("type")
     *         // the properties below are optional
     *         .columns(DatabaseColumnsProperty.builder()
     *                 .exclude(List.of("exclude"))
     *                 .include(List.of("include"))
     *                 .build())
     *         .digest("digest")
     *         .publicCertificate("publicCertificate")
     *         .sslMode("sslMode")
     *         .surrogateKeys(List.of("surrogateKeys"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-databasesourceconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-databasesourceconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.DatabaseSourceConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(DatabaseSourceConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DatabaseSourceConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The list of database patterns in source database endpoint for Firehose to read from.
         * <p>
         * Amazon Data Firehose is in preview release and is subject to change.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-databasesourceconfiguration.html#cfn-kinesisfirehose-deliverystream-databasesourceconfiguration-databases">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-databasesourceconfiguration.html#cfn-kinesisfirehose-deliverystream-databasesourceconfiguration-databases</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getDatabases();

        /**
         * The structure to configure the authentication methods for Firehose to connect to source database endpoint.
         * <p>
         * Amazon Data Firehose is in preview release and is subject to change.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-databasesourceconfiguration.html#cfn-kinesisfirehose-deliverystream-databasesourceconfiguration-databasesourceauthenticationconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-databasesourceconfiguration.html#cfn-kinesisfirehose-deliverystream-databasesourceconfiguration-databasesourceauthenticationconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getDatabaseSourceAuthenticationConfiguration();

        /**
         * The details of the VPC Endpoint Service which Firehose uses to create a PrivateLink to the database.
         * <p>
         * Amazon Data Firehose is in preview release and is subject to change.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-databasesourceconfiguration.html#cfn-kinesisfirehose-deliverystream-databasesourceconfiguration-databasesourcevpcconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-databasesourceconfiguration.html#cfn-kinesisfirehose-deliverystream-databasesourceconfiguration-databasesourcevpcconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getDatabaseSourceVpcConfiguration();

        /**
         * The endpoint of the database server.
         * <p>
         * Amazon Data Firehose is in preview release and is subject to change.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-databasesourceconfiguration.html#cfn-kinesisfirehose-deliverystream-databasesourceconfiguration-endpoint">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-databasesourceconfiguration.html#cfn-kinesisfirehose-deliverystream-databasesourceconfiguration-endpoint</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEndpoint();

        /**
         * The port of the database. This can be one of the following values.
         * <p>
         * <ul>
         * <li>3306 for MySQL database type</li>
         * <li>5432 for PostgreSQL database type</li>
         * </ul>
         * <p>
         * Amazon Data Firehose is in preview release and is subject to change.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-databasesourceconfiguration.html#cfn-kinesisfirehose-deliverystream-databasesourceconfiguration-port">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-databasesourceconfiguration.html#cfn-kinesisfirehose-deliverystream-databasesourceconfiguration-port</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getPort();

        /**
         * The fully qualified name of the table in source database endpoint that Firehose uses to track snapshot progress.
         * <p>
         * Amazon Data Firehose is in preview release and is subject to change.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-databasesourceconfiguration.html#cfn-kinesisfirehose-deliverystream-databasesourceconfiguration-snapshotwatermarktable">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-databasesourceconfiguration.html#cfn-kinesisfirehose-deliverystream-databasesourceconfiguration-snapshotwatermarktable</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSnapshotWatermarkTable();

        /**
         * The list of table patterns in source database endpoint for Firehose to read from.
         * <p>
         * Amazon Data Firehose is in preview release and is subject to change.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-databasesourceconfiguration.html#cfn-kinesisfirehose-deliverystream-databasesourceconfiguration-tables">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-databasesourceconfiguration.html#cfn-kinesisfirehose-deliverystream-databasesourceconfiguration-tables</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getTables();

        /**
         * The type of database engine. This can be one of the following values.
         * <p>
         * <ul>
         * <li>MySQL</li>
         * <li>PostgreSQL</li>
         * </ul>
         * <p>
         * Amazon Data Firehose is in preview release and is subject to change.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-databasesourceconfiguration.html#cfn-kinesisfirehose-deliverystream-databasesourceconfiguration-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-databasesourceconfiguration.html#cfn-kinesisfirehose-deliverystream-databasesourceconfiguration-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * The list of column patterns in source database endpoint for Firehose to read from.
         * <p>
         * Amazon Data Firehose is in preview release and is subject to change.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-databasesourceconfiguration.html#cfn-kinesisfirehose-deliverystream-databasesourceconfiguration-columns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-databasesourceconfiguration.html#cfn-kinesisfirehose-deliverystream-databasesourceconfiguration-columns</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getColumns() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-databasesourceconfiguration.html#cfn-kinesisfirehose-deliverystream-databasesourceconfiguration-digest">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-databasesourceconfiguration.html#cfn-kinesisfirehose-deliverystream-databasesourceconfiguration-digest</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDigest() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-databasesourceconfiguration.html#cfn-kinesisfirehose-deliverystream-databasesourceconfiguration-publiccertificate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-databasesourceconfiguration.html#cfn-kinesisfirehose-deliverystream-databasesourceconfiguration-publiccertificate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPublicCertificate() {
            return null;
        }

        /**
         * The mode to enable or disable SSL when Firehose connects to the database endpoint.
         * <p>
         * Amazon Data Firehose is in preview release and is subject to change.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-databasesourceconfiguration.html#cfn-kinesisfirehose-deliverystream-databasesourceconfiguration-sslmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-databasesourceconfiguration.html#cfn-kinesisfirehose-deliverystream-databasesourceconfiguration-sslmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSslMode() {
            return null;
        }

        /**
         * The optional list of table and column names used as unique key columns when taking snapshot if the tables don’t have primary keys configured.
         * <p>
         * Amazon Data Firehose is in preview release and is subject to change.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-databasesourceconfiguration.html#cfn-kinesisfirehose-deliverystream-databasesourceconfiguration-surrogatekeys">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-databasesourceconfiguration.html#cfn-kinesisfirehose-deliverystream-databasesourceconfiguration-surrogatekeys</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSurrogateKeys() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DatabaseSourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DatabaseSourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DatabaseSourceConfigurationProperty> {
            java.lang.Object databases;
            java.lang.Object databaseSourceAuthenticationConfiguration;
            java.lang.Object databaseSourceVpcConfiguration;
            java.lang.String endpoint;
            java.lang.Number port;
            java.lang.String snapshotWatermarkTable;
            java.lang.Object tables;
            java.lang.String type;
            java.lang.Object columns;
            java.lang.String digest;
            java.lang.String publicCertificate;
            java.lang.String sslMode;
            java.util.List<java.lang.String> surrogateKeys;

            /**
             * Sets the value of {@link DatabaseSourceConfigurationProperty#getDatabases}
             * @param databases The list of database patterns in source database endpoint for Firehose to read from. This parameter is required.
             *                  Amazon Data Firehose is in preview release and is subject to change.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databases(software.amazon.awscdk.IResolvable databases) {
                this.databases = databases;
                return this;
            }

            /**
             * Sets the value of {@link DatabaseSourceConfigurationProperty#getDatabases}
             * @param databases The list of database patterns in source database endpoint for Firehose to read from. This parameter is required.
             *                  Amazon Data Firehose is in preview release and is subject to change.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databases(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.DatabasesProperty databases) {
                this.databases = databases;
                return this;
            }

            /**
             * Sets the value of {@link DatabaseSourceConfigurationProperty#getDatabaseSourceAuthenticationConfiguration}
             * @param databaseSourceAuthenticationConfiguration The structure to configure the authentication methods for Firehose to connect to source database endpoint. This parameter is required.
             *                                                  Amazon Data Firehose is in preview release and is subject to change.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseSourceAuthenticationConfiguration(software.amazon.awscdk.IResolvable databaseSourceAuthenticationConfiguration) {
                this.databaseSourceAuthenticationConfiguration = databaseSourceAuthenticationConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DatabaseSourceConfigurationProperty#getDatabaseSourceAuthenticationConfiguration}
             * @param databaseSourceAuthenticationConfiguration The structure to configure the authentication methods for Firehose to connect to source database endpoint. This parameter is required.
             *                                                  Amazon Data Firehose is in preview release and is subject to change.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseSourceAuthenticationConfiguration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.DatabaseSourceAuthenticationConfigurationProperty databaseSourceAuthenticationConfiguration) {
                this.databaseSourceAuthenticationConfiguration = databaseSourceAuthenticationConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DatabaseSourceConfigurationProperty#getDatabaseSourceVpcConfiguration}
             * @param databaseSourceVpcConfiguration The details of the VPC Endpoint Service which Firehose uses to create a PrivateLink to the database. This parameter is required.
             *                                       Amazon Data Firehose is in preview release and is subject to change.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseSourceVpcConfiguration(software.amazon.awscdk.IResolvable databaseSourceVpcConfiguration) {
                this.databaseSourceVpcConfiguration = databaseSourceVpcConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DatabaseSourceConfigurationProperty#getDatabaseSourceVpcConfiguration}
             * @param databaseSourceVpcConfiguration The details of the VPC Endpoint Service which Firehose uses to create a PrivateLink to the database. This parameter is required.
             *                                       Amazon Data Firehose is in preview release and is subject to change.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseSourceVpcConfiguration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.DatabaseSourceVPCConfigurationProperty databaseSourceVpcConfiguration) {
                this.databaseSourceVpcConfiguration = databaseSourceVpcConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link DatabaseSourceConfigurationProperty#getEndpoint}
             * @param endpoint The endpoint of the database server. This parameter is required.
             *                 Amazon Data Firehose is in preview release and is subject to change.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endpoint(java.lang.String endpoint) {
                this.endpoint = endpoint;
                return this;
            }

            /**
             * Sets the value of {@link DatabaseSourceConfigurationProperty#getPort}
             * @param port The port of the database. This can be one of the following values. This parameter is required.
             *             <ul>
             *             <li>3306 for MySQL database type</li>
             *             <li>5432 for PostgreSQL database type</li>
             *             </ul>
             *             <p>
             *             Amazon Data Firehose is in preview release and is subject to change.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder port(java.lang.Number port) {
                this.port = port;
                return this;
            }

            /**
             * Sets the value of {@link DatabaseSourceConfigurationProperty#getSnapshotWatermarkTable}
             * @param snapshotWatermarkTable The fully qualified name of the table in source database endpoint that Firehose uses to track snapshot progress. This parameter is required.
             *                               Amazon Data Firehose is in preview release and is subject to change.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder snapshotWatermarkTable(java.lang.String snapshotWatermarkTable) {
                this.snapshotWatermarkTable = snapshotWatermarkTable;
                return this;
            }

            /**
             * Sets the value of {@link DatabaseSourceConfigurationProperty#getTables}
             * @param tables The list of table patterns in source database endpoint for Firehose to read from. This parameter is required.
             *               Amazon Data Firehose is in preview release and is subject to change.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tables(software.amazon.awscdk.IResolvable tables) {
                this.tables = tables;
                return this;
            }

            /**
             * Sets the value of {@link DatabaseSourceConfigurationProperty#getTables}
             * @param tables The list of table patterns in source database endpoint for Firehose to read from. This parameter is required.
             *               Amazon Data Firehose is in preview release and is subject to change.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tables(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.DatabaseTablesProperty tables) {
                this.tables = tables;
                return this;
            }

            /**
             * Sets the value of {@link DatabaseSourceConfigurationProperty#getType}
             * @param type The type of database engine. This can be one of the following values. This parameter is required.
             *             <ul>
             *             <li>MySQL</li>
             *             <li>PostgreSQL</li>
             *             </ul>
             *             <p>
             *             Amazon Data Firehose is in preview release and is subject to change.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link DatabaseSourceConfigurationProperty#getColumns}
             * @param columns The list of column patterns in source database endpoint for Firehose to read from.
             *                Amazon Data Firehose is in preview release and is subject to change.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columns(software.amazon.awscdk.IResolvable columns) {
                this.columns = columns;
                return this;
            }

            /**
             * Sets the value of {@link DatabaseSourceConfigurationProperty#getColumns}
             * @param columns The list of column patterns in source database endpoint for Firehose to read from.
             *                Amazon Data Firehose is in preview release and is subject to change.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columns(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.DatabaseColumnsProperty columns) {
                this.columns = columns;
                return this;
            }

            /**
             * Sets the value of {@link DatabaseSourceConfigurationProperty#getDigest}
             * @param digest the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder digest(java.lang.String digest) {
                this.digest = digest;
                return this;
            }

            /**
             * Sets the value of {@link DatabaseSourceConfigurationProperty#getPublicCertificate}
             * @param publicCertificate the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder publicCertificate(java.lang.String publicCertificate) {
                this.publicCertificate = publicCertificate;
                return this;
            }

            /**
             * Sets the value of {@link DatabaseSourceConfigurationProperty#getSslMode}
             * @param sslMode The mode to enable or disable SSL when Firehose connects to the database endpoint.
             *                Amazon Data Firehose is in preview release and is subject to change.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sslMode(java.lang.String sslMode) {
                this.sslMode = sslMode;
                return this;
            }

            /**
             * Sets the value of {@link DatabaseSourceConfigurationProperty#getSurrogateKeys}
             * @param surrogateKeys The optional list of table and column names used as unique key columns when taking snapshot if the tables don’t have primary keys configured.
             *                      Amazon Data Firehose is in preview release and is subject to change.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder surrogateKeys(java.util.List<java.lang.String> surrogateKeys) {
                this.surrogateKeys = surrogateKeys;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DatabaseSourceConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DatabaseSourceConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DatabaseSourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DatabaseSourceConfigurationProperty {
            private final java.lang.Object databases;
            private final java.lang.Object databaseSourceAuthenticationConfiguration;
            private final java.lang.Object databaseSourceVpcConfiguration;
            private final java.lang.String endpoint;
            private final java.lang.Number port;
            private final java.lang.String snapshotWatermarkTable;
            private final java.lang.Object tables;
            private final java.lang.String type;
            private final java.lang.Object columns;
            private final java.lang.String digest;
            private final java.lang.String publicCertificate;
            private final java.lang.String sslMode;
            private final java.util.List<java.lang.String> surrogateKeys;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.databases = software.amazon.jsii.Kernel.get(this, "databases", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.databaseSourceAuthenticationConfiguration = software.amazon.jsii.Kernel.get(this, "databaseSourceAuthenticationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.databaseSourceVpcConfiguration = software.amazon.jsii.Kernel.get(this, "databaseSourceVpcConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.endpoint = software.amazon.jsii.Kernel.get(this, "endpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.snapshotWatermarkTable = software.amazon.jsii.Kernel.get(this, "snapshotWatermarkTable", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tables = software.amazon.jsii.Kernel.get(this, "tables", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.columns = software.amazon.jsii.Kernel.get(this, "columns", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.digest = software.amazon.jsii.Kernel.get(this, "digest", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.publicCertificate = software.amazon.jsii.Kernel.get(this, "publicCertificate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sslMode = software.amazon.jsii.Kernel.get(this, "sslMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.surrogateKeys = software.amazon.jsii.Kernel.get(this, "surrogateKeys", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.databases = java.util.Objects.requireNonNull(builder.databases, "databases is required");
                this.databaseSourceAuthenticationConfiguration = java.util.Objects.requireNonNull(builder.databaseSourceAuthenticationConfiguration, "databaseSourceAuthenticationConfiguration is required");
                this.databaseSourceVpcConfiguration = java.util.Objects.requireNonNull(builder.databaseSourceVpcConfiguration, "databaseSourceVpcConfiguration is required");
                this.endpoint = java.util.Objects.requireNonNull(builder.endpoint, "endpoint is required");
                this.port = java.util.Objects.requireNonNull(builder.port, "port is required");
                this.snapshotWatermarkTable = java.util.Objects.requireNonNull(builder.snapshotWatermarkTable, "snapshotWatermarkTable is required");
                this.tables = java.util.Objects.requireNonNull(builder.tables, "tables is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.columns = builder.columns;
                this.digest = builder.digest;
                this.publicCertificate = builder.publicCertificate;
                this.sslMode = builder.sslMode;
                this.surrogateKeys = builder.surrogateKeys;
            }

            @Override
            public final java.lang.Object getDatabases() {
                return this.databases;
            }

            @Override
            public final java.lang.Object getDatabaseSourceAuthenticationConfiguration() {
                return this.databaseSourceAuthenticationConfiguration;
            }

            @Override
            public final java.lang.Object getDatabaseSourceVpcConfiguration() {
                return this.databaseSourceVpcConfiguration;
            }

            @Override
            public final java.lang.String getEndpoint() {
                return this.endpoint;
            }

            @Override
            public final java.lang.Number getPort() {
                return this.port;
            }

            @Override
            public final java.lang.String getSnapshotWatermarkTable() {
                return this.snapshotWatermarkTable;
            }

            @Override
            public final java.lang.Object getTables() {
                return this.tables;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.Object getColumns() {
                return this.columns;
            }

            @Override
            public final java.lang.String getDigest() {
                return this.digest;
            }

            @Override
            public final java.lang.String getPublicCertificate() {
                return this.publicCertificate;
            }

            @Override
            public final java.lang.String getSslMode() {
                return this.sslMode;
            }

            @Override
            public final java.util.List<java.lang.String> getSurrogateKeys() {
                return this.surrogateKeys;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("databases", om.valueToTree(this.getDatabases()));
                data.set("databaseSourceAuthenticationConfiguration", om.valueToTree(this.getDatabaseSourceAuthenticationConfiguration()));
                data.set("databaseSourceVpcConfiguration", om.valueToTree(this.getDatabaseSourceVpcConfiguration()));
                data.set("endpoint", om.valueToTree(this.getEndpoint()));
                data.set("port", om.valueToTree(this.getPort()));
                data.set("snapshotWatermarkTable", om.valueToTree(this.getSnapshotWatermarkTable()));
                data.set("tables", om.valueToTree(this.getTables()));
                data.set("type", om.valueToTree(this.getType()));
                if (this.getColumns() != null) {
                    data.set("columns", om.valueToTree(this.getColumns()));
                }
                if (this.getDigest() != null) {
                    data.set("digest", om.valueToTree(this.getDigest()));
                }
                if (this.getPublicCertificate() != null) {
                    data.set("publicCertificate", om.valueToTree(this.getPublicCertificate()));
                }
                if (this.getSslMode() != null) {
                    data.set("sslMode", om.valueToTree(this.getSslMode()));
                }
                if (this.getSurrogateKeys() != null) {
                    data.set("surrogateKeys", om.valueToTree(this.getSurrogateKeys()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.DatabaseSourceConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DatabaseSourceConfigurationProperty.Jsii$Proxy that = (DatabaseSourceConfigurationProperty.Jsii$Proxy) o;

                if (!databases.equals(that.databases)) return false;
                if (!databaseSourceAuthenticationConfiguration.equals(that.databaseSourceAuthenticationConfiguration)) return false;
                if (!databaseSourceVpcConfiguration.equals(that.databaseSourceVpcConfiguration)) return false;
                if (!endpoint.equals(that.endpoint)) return false;
                if (!port.equals(that.port)) return false;
                if (!snapshotWatermarkTable.equals(that.snapshotWatermarkTable)) return false;
                if (!tables.equals(that.tables)) return false;
                if (!type.equals(that.type)) return false;
                if (this.columns != null ? !this.columns.equals(that.columns) : that.columns != null) return false;
                if (this.digest != null ? !this.digest.equals(that.digest) : that.digest != null) return false;
                if (this.publicCertificate != null ? !this.publicCertificate.equals(that.publicCertificate) : that.publicCertificate != null) return false;
                if (this.sslMode != null ? !this.sslMode.equals(that.sslMode) : that.sslMode != null) return false;
                return this.surrogateKeys != null ? this.surrogateKeys.equals(that.surrogateKeys) : that.surrogateKeys == null;
            }

            @Override
            public final int hashCode() {
                int result = this.databases.hashCode();
                result = 31 * result + (this.databaseSourceAuthenticationConfiguration.hashCode());
                result = 31 * result + (this.databaseSourceVpcConfiguration.hashCode());
                result = 31 * result + (this.endpoint.hashCode());
                result = 31 * result + (this.port.hashCode());
                result = 31 * result + (this.snapshotWatermarkTable.hashCode());
                result = 31 * result + (this.tables.hashCode());
                result = 31 * result + (this.type.hashCode());
                result = 31 * result + (this.columns != null ? this.columns.hashCode() : 0);
                result = 31 * result + (this.digest != null ? this.digest.hashCode() : 0);
                result = 31 * result + (this.publicCertificate != null ? this.publicCertificate.hashCode() : 0);
                result = 31 * result + (this.sslMode != null ? this.sslMode.hashCode() : 0);
                result = 31 * result + (this.surrogateKeys != null ? this.surrogateKeys.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The structure for details of the VPC Endpoint Service which Firehose uses to create a PrivateLink to the database.
     * <p>
     * Amazon Data Firehose is in preview release and is subject to change.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * DatabaseSourceVPCConfigurationProperty databaseSourceVPCConfigurationProperty = DatabaseSourceVPCConfigurationProperty.builder()
     *         .vpcEndpointServiceName("vpcEndpointServiceName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-databasesourcevpcconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-databasesourcevpcconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.DatabaseSourceVPCConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(DatabaseSourceVPCConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DatabaseSourceVPCConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The VPC endpoint service name which Firehose uses to create a PrivateLink to the database.
         * <p>
         * The endpoint service must have the Firehose service principle <code>firehose.amazonaws.com</code> as an allowed principal on the VPC endpoint service. The VPC endpoint service name is a string that looks like <code>com.amazonaws.vpce.&lt;region&gt;.&lt;vpc-endpoint-service-id&gt;</code> .
         * <p>
         * Amazon Data Firehose is in preview release and is subject to change.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-databasesourcevpcconfiguration.html#cfn-kinesisfirehose-deliverystream-databasesourcevpcconfiguration-vpcendpointservicename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-databasesourcevpcconfiguration.html#cfn-kinesisfirehose-deliverystream-databasesourcevpcconfiguration-vpcendpointservicename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getVpcEndpointServiceName();

        /**
         * @return a {@link Builder} of {@link DatabaseSourceVPCConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DatabaseSourceVPCConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DatabaseSourceVPCConfigurationProperty> {
            java.lang.String vpcEndpointServiceName;

            /**
             * Sets the value of {@link DatabaseSourceVPCConfigurationProperty#getVpcEndpointServiceName}
             * @param vpcEndpointServiceName The VPC endpoint service name which Firehose uses to create a PrivateLink to the database. This parameter is required.
             *                               The endpoint service must have the Firehose service principle <code>firehose.amazonaws.com</code> as an allowed principal on the VPC endpoint service. The VPC endpoint service name is a string that looks like <code>com.amazonaws.vpce.&lt;region&gt;.&lt;vpc-endpoint-service-id&gt;</code> .
             *                               <p>
             *                               Amazon Data Firehose is in preview release and is subject to change.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcEndpointServiceName(java.lang.String vpcEndpointServiceName) {
                this.vpcEndpointServiceName = vpcEndpointServiceName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DatabaseSourceVPCConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DatabaseSourceVPCConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DatabaseSourceVPCConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DatabaseSourceVPCConfigurationProperty {
            private final java.lang.String vpcEndpointServiceName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.vpcEndpointServiceName = software.amazon.jsii.Kernel.get(this, "vpcEndpointServiceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.vpcEndpointServiceName = java.util.Objects.requireNonNull(builder.vpcEndpointServiceName, "vpcEndpointServiceName is required");
            }

            @Override
            public final java.lang.String getVpcEndpointServiceName() {
                return this.vpcEndpointServiceName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("vpcEndpointServiceName", om.valueToTree(this.getVpcEndpointServiceName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.DatabaseSourceVPCConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DatabaseSourceVPCConfigurationProperty.Jsii$Proxy that = (DatabaseSourceVPCConfigurationProperty.Jsii$Proxy) o;

                return this.vpcEndpointServiceName.equals(that.vpcEndpointServiceName);
            }

            @Override
            public final int hashCode() {
                int result = this.vpcEndpointServiceName.hashCode();
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * DatabaseTablesProperty databaseTablesProperty = DatabaseTablesProperty.builder()
     *         .exclude(List.of("exclude"))
     *         .include(List.of("include"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-databasetables.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-databasetables.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.DatabaseTablesProperty")
    @software.amazon.jsii.Jsii.Proxy(DatabaseTablesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DatabaseTablesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-databasetables.html#cfn-kinesisfirehose-deliverystream-databasetables-exclude">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-databasetables.html#cfn-kinesisfirehose-deliverystream-databasetables-exclude</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExclude() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-databasetables.html#cfn-kinesisfirehose-deliverystream-databasetables-include">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-databasetables.html#cfn-kinesisfirehose-deliverystream-databasetables-include</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getInclude() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DatabaseTablesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DatabaseTablesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DatabaseTablesProperty> {
            java.util.List<java.lang.String> exclude;
            java.util.List<java.lang.String> include;

            /**
             * Sets the value of {@link DatabaseTablesProperty#getExclude}
             * @param exclude the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exclude(java.util.List<java.lang.String> exclude) {
                this.exclude = exclude;
                return this;
            }

            /**
             * Sets the value of {@link DatabaseTablesProperty#getInclude}
             * @param include the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder include(java.util.List<java.lang.String> include) {
                this.include = include;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DatabaseTablesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DatabaseTablesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DatabaseTablesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DatabaseTablesProperty {
            private final java.util.List<java.lang.String> exclude;
            private final java.util.List<java.lang.String> include;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.exclude = software.amazon.jsii.Kernel.get(this, "exclude", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.include = software.amazon.jsii.Kernel.get(this, "include", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.exclude = builder.exclude;
                this.include = builder.include;
            }

            @Override
            public final java.util.List<java.lang.String> getExclude() {
                return this.exclude;
            }

            @Override
            public final java.util.List<java.lang.String> getInclude() {
                return this.include;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getExclude() != null) {
                    data.set("exclude", om.valueToTree(this.getExclude()));
                }
                if (this.getInclude() != null) {
                    data.set("include", om.valueToTree(this.getInclude()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.DatabaseTablesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DatabaseTablesProperty.Jsii$Proxy that = (DatabaseTablesProperty.Jsii$Proxy) o;

                if (this.exclude != null ? !this.exclude.equals(that.exclude) : that.exclude != null) return false;
                return this.include != null ? this.include.equals(that.include) : that.include == null;
            }

            @Override
            public final int hashCode() {
                int result = this.exclude != null ? this.exclude.hashCode() : 0;
                result = 31 * result + (this.include != null ? this.include.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * DatabasesProperty databasesProperty = DatabasesProperty.builder()
     *         .exclude(List.of("exclude"))
     *         .include(List.of("include"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-databases.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-databases.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.DatabasesProperty")
    @software.amazon.jsii.Jsii.Proxy(DatabasesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DatabasesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-databases.html#cfn-kinesisfirehose-deliverystream-databases-exclude">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-databases.html#cfn-kinesisfirehose-deliverystream-databases-exclude</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExclude() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-databases.html#cfn-kinesisfirehose-deliverystream-databases-include">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-databases.html#cfn-kinesisfirehose-deliverystream-databases-include</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getInclude() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DatabasesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DatabasesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DatabasesProperty> {
            java.util.List<java.lang.String> exclude;
            java.util.List<java.lang.String> include;

            /**
             * Sets the value of {@link DatabasesProperty#getExclude}
             * @param exclude the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exclude(java.util.List<java.lang.String> exclude) {
                this.exclude = exclude;
                return this;
            }

            /**
             * Sets the value of {@link DatabasesProperty#getInclude}
             * @param include the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder include(java.util.List<java.lang.String> include) {
                this.include = include;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DatabasesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DatabasesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DatabasesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DatabasesProperty {
            private final java.util.List<java.lang.String> exclude;
            private final java.util.List<java.lang.String> include;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.exclude = software.amazon.jsii.Kernel.get(this, "exclude", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.include = software.amazon.jsii.Kernel.get(this, "include", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.exclude = builder.exclude;
                this.include = builder.include;
            }

            @Override
            public final java.util.List<java.lang.String> getExclude() {
                return this.exclude;
            }

            @Override
            public final java.util.List<java.lang.String> getInclude() {
                return this.include;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getExclude() != null) {
                    data.set("exclude", om.valueToTree(this.getExclude()));
                }
                if (this.getInclude() != null) {
                    data.set("include", om.valueToTree(this.getInclude()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.DatabasesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DatabasesProperty.Jsii$Proxy that = (DatabasesProperty.Jsii$Proxy) o;

                if (this.exclude != null ? !this.exclude.equals(that.exclude) : that.exclude != null) return false;
                return this.include != null ? this.include.equals(that.include) : that.include == null;
            }

            @Override
            public final int hashCode() {
                int result = this.exclude != null ? this.exclude.hashCode() : 0;
                result = 31 * result + (this.include != null ? this.include.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the type and Amazon Resource Name (ARN) of the CMK to use for Server-Side Encryption (SSE).
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * DeliveryStreamEncryptionConfigurationInputProperty deliveryStreamEncryptionConfigurationInputProperty = DeliveryStreamEncryptionConfigurationInputProperty.builder()
     *         .keyType("keyType")
     *         // the properties below are optional
     *         .keyArn("keyArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-deliverystreamencryptionconfigurationinput.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-deliverystreamencryptionconfigurationinput.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.DeliveryStreamEncryptionConfigurationInputProperty")
    @software.amazon.jsii.Jsii.Proxy(DeliveryStreamEncryptionConfigurationInputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DeliveryStreamEncryptionConfigurationInputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates the type of customer master key (CMK) to use for encryption.
         * <p>
         * The default setting is <code>AWS_OWNED_CMK</code> . For more information about CMKs, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#master_keys">Customer Master Keys (CMKs)</a> .
         * <p>
         * You can use a CMK of type CUSTOMER_MANAGED_CMK to encrypt up to 500 delivery streams.
         * <p>
         * <blockquote>
         * <p>
         * To encrypt your delivery stream, use symmetric CMKs. Kinesis Data Firehose doesn't support asymmetric CMKs. For information about symmetric and asymmetric CMKs, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symm-asymm-concepts.html">About Symmetric and Asymmetric CMKs</a> in the AWS Key Management Service developer guide.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-deliverystreamencryptionconfigurationinput.html#cfn-kinesisfirehose-deliverystream-deliverystreamencryptionconfigurationinput-keytype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-deliverystreamencryptionconfigurationinput.html#cfn-kinesisfirehose-deliverystream-deliverystreamencryptionconfigurationinput-keytype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKeyType();

        /**
         * If you set <code>KeyType</code> to <code>CUSTOMER_MANAGED_CMK</code> , you must specify the Amazon Resource Name (ARN) of the CMK.
         * <p>
         * If you set <code>KeyType</code> to <code>AWS _OWNED_CMK</code> , Firehose uses a service-account CMK.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-deliverystreamencryptionconfigurationinput.html#cfn-kinesisfirehose-deliverystream-deliverystreamencryptionconfigurationinput-keyarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-deliverystreamencryptionconfigurationinput.html#cfn-kinesisfirehose-deliverystream-deliverystreamencryptionconfigurationinput-keyarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKeyArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DeliveryStreamEncryptionConfigurationInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DeliveryStreamEncryptionConfigurationInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DeliveryStreamEncryptionConfigurationInputProperty> {
            java.lang.String keyType;
            java.lang.String keyArn;

            /**
             * Sets the value of {@link DeliveryStreamEncryptionConfigurationInputProperty#getKeyType}
             * @param keyType Indicates the type of customer master key (CMK) to use for encryption. This parameter is required.
             *                The default setting is <code>AWS_OWNED_CMK</code> . For more information about CMKs, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#master_keys">Customer Master Keys (CMKs)</a> .
             *                <p>
             *                You can use a CMK of type CUSTOMER_MANAGED_CMK to encrypt up to 500 delivery streams.
             *                <p>
             *                <blockquote>
             *                <p>
             *                To encrypt your delivery stream, use symmetric CMKs. Kinesis Data Firehose doesn't support asymmetric CMKs. For information about symmetric and asymmetric CMKs, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symm-asymm-concepts.html">About Symmetric and Asymmetric CMKs</a> in the AWS Key Management Service developer guide.
             *                <p>
             *                </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyType(java.lang.String keyType) {
                this.keyType = keyType;
                return this;
            }

            /**
             * Sets the value of {@link DeliveryStreamEncryptionConfigurationInputProperty#getKeyArn}
             * @param keyArn If you set <code>KeyType</code> to <code>CUSTOMER_MANAGED_CMK</code> , you must specify the Amazon Resource Name (ARN) of the CMK.
             *               If you set <code>KeyType</code> to <code>AWS _OWNED_CMK</code> , Firehose uses a service-account CMK.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyArn(java.lang.String keyArn) {
                this.keyArn = keyArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DeliveryStreamEncryptionConfigurationInputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DeliveryStreamEncryptionConfigurationInputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DeliveryStreamEncryptionConfigurationInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeliveryStreamEncryptionConfigurationInputProperty {
            private final java.lang.String keyType;
            private final java.lang.String keyArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.keyType = software.amazon.jsii.Kernel.get(this, "keyType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.keyArn = software.amazon.jsii.Kernel.get(this, "keyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.keyType = java.util.Objects.requireNonNull(builder.keyType, "keyType is required");
                this.keyArn = builder.keyArn;
            }

            @Override
            public final java.lang.String getKeyType() {
                return this.keyType;
            }

            @Override
            public final java.lang.String getKeyArn() {
                return this.keyArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("keyType", om.valueToTree(this.getKeyType()));
                if (this.getKeyArn() != null) {
                    data.set("keyArn", om.valueToTree(this.getKeyArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.DeliveryStreamEncryptionConfigurationInputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DeliveryStreamEncryptionConfigurationInputProperty.Jsii$Proxy that = (DeliveryStreamEncryptionConfigurationInputProperty.Jsii$Proxy) o;

                if (!keyType.equals(that.keyType)) return false;
                return this.keyArn != null ? this.keyArn.equals(that.keyArn) : that.keyArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.keyType.hashCode();
                result = 31 * result + (this.keyArn != null ? this.keyArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The deserializer you want Kinesis Data Firehose to use for converting the input data from JSON.
     * <p>
     * Kinesis Data Firehose then serializes the data to its final format using the <code>Serializer</code> . Kinesis Data Firehose supports two types of deserializers: the <a href="https://docs.aws.amazon.com/https://cwiki.apache.org/confluence/display/Hive/LanguageManual+DDL#LanguageManualDDL-JSON">Apache Hive JSON SerDe</a> and the <a href="https://docs.aws.amazon.com/https://github.com/rcongiu/Hive-JSON-Serde">OpenX JSON SerDe</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * DeserializerProperty deserializerProperty = DeserializerProperty.builder()
     *         .hiveJsonSerDe(HiveJsonSerDeProperty.builder()
     *                 .timestampFormats(List.of("timestampFormats"))
     *                 .build())
     *         .openXJsonSerDe(OpenXJsonSerDeProperty.builder()
     *                 .caseInsensitive(false)
     *                 .columnToJsonKeyMappings(Map.of(
     *                         "columnToJsonKeyMappingsKey", "columnToJsonKeyMappings"))
     *                 .convertDotsInJsonKeysToUnderscores(false)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-deserializer.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-deserializer.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.DeserializerProperty")
    @software.amazon.jsii.Jsii.Proxy(DeserializerProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DeserializerProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The native Hive / HCatalog JsonSerDe.
         * <p>
         * Used by Firehose for deserializing data, which means converting it from the JSON format in preparation for serializing it to the Parquet or ORC format. This is one of two deserializers you can choose, depending on which one offers the functionality you need. The other option is the OpenX SerDe.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-deserializer.html#cfn-kinesisfirehose-deliverystream-deserializer-hivejsonserde">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-deserializer.html#cfn-kinesisfirehose-deliverystream-deserializer-hivejsonserde</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHiveJsonSerDe() {
            return null;
        }

        /**
         * The OpenX SerDe.
         * <p>
         * Used by Firehose for deserializing data, which means converting it from the JSON format in preparation for serializing it to the Parquet or ORC format. This is one of two deserializers you can choose, depending on which one offers the functionality you need. The other option is the native Hive / HCatalog JsonSerDe.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-deserializer.html#cfn-kinesisfirehose-deliverystream-deserializer-openxjsonserde">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-deserializer.html#cfn-kinesisfirehose-deliverystream-deserializer-openxjsonserde</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOpenXJsonSerDe() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DeserializerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DeserializerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DeserializerProperty> {
            java.lang.Object hiveJsonSerDe;
            java.lang.Object openXJsonSerDe;

            /**
             * Sets the value of {@link DeserializerProperty#getHiveJsonSerDe}
             * @param hiveJsonSerDe The native Hive / HCatalog JsonSerDe.
             *                      Used by Firehose for deserializing data, which means converting it from the JSON format in preparation for serializing it to the Parquet or ORC format. This is one of two deserializers you can choose, depending on which one offers the functionality you need. The other option is the OpenX SerDe.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hiveJsonSerDe(software.amazon.awscdk.IResolvable hiveJsonSerDe) {
                this.hiveJsonSerDe = hiveJsonSerDe;
                return this;
            }

            /**
             * Sets the value of {@link DeserializerProperty#getHiveJsonSerDe}
             * @param hiveJsonSerDe The native Hive / HCatalog JsonSerDe.
             *                      Used by Firehose for deserializing data, which means converting it from the JSON format in preparation for serializing it to the Parquet or ORC format. This is one of two deserializers you can choose, depending on which one offers the functionality you need. The other option is the OpenX SerDe.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hiveJsonSerDe(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.HiveJsonSerDeProperty hiveJsonSerDe) {
                this.hiveJsonSerDe = hiveJsonSerDe;
                return this;
            }

            /**
             * Sets the value of {@link DeserializerProperty#getOpenXJsonSerDe}
             * @param openXJsonSerDe The OpenX SerDe.
             *                       Used by Firehose for deserializing data, which means converting it from the JSON format in preparation for serializing it to the Parquet or ORC format. This is one of two deserializers you can choose, depending on which one offers the functionality you need. The other option is the native Hive / HCatalog JsonSerDe.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder openXJsonSerDe(software.amazon.awscdk.IResolvable openXJsonSerDe) {
                this.openXJsonSerDe = openXJsonSerDe;
                return this;
            }

            /**
             * Sets the value of {@link DeserializerProperty#getOpenXJsonSerDe}
             * @param openXJsonSerDe The OpenX SerDe.
             *                       Used by Firehose for deserializing data, which means converting it from the JSON format in preparation for serializing it to the Parquet or ORC format. This is one of two deserializers you can choose, depending on which one offers the functionality you need. The other option is the native Hive / HCatalog JsonSerDe.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder openXJsonSerDe(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.OpenXJsonSerDeProperty openXJsonSerDe) {
                this.openXJsonSerDe = openXJsonSerDe;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DeserializerProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DeserializerProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DeserializerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeserializerProperty {
            private final java.lang.Object hiveJsonSerDe;
            private final java.lang.Object openXJsonSerDe;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.hiveJsonSerDe = software.amazon.jsii.Kernel.get(this, "hiveJsonSerDe", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.openXJsonSerDe = software.amazon.jsii.Kernel.get(this, "openXJsonSerDe", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.hiveJsonSerDe = builder.hiveJsonSerDe;
                this.openXJsonSerDe = builder.openXJsonSerDe;
            }

            @Override
            public final java.lang.Object getHiveJsonSerDe() {
                return this.hiveJsonSerDe;
            }

            @Override
            public final java.lang.Object getOpenXJsonSerDe() {
                return this.openXJsonSerDe;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getHiveJsonSerDe() != null) {
                    data.set("hiveJsonSerDe", om.valueToTree(this.getHiveJsonSerDe()));
                }
                if (this.getOpenXJsonSerDe() != null) {
                    data.set("openXJsonSerDe", om.valueToTree(this.getOpenXJsonSerDe()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.DeserializerProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DeserializerProperty.Jsii$Proxy that = (DeserializerProperty.Jsii$Proxy) o;

                if (this.hiveJsonSerDe != null ? !this.hiveJsonSerDe.equals(that.hiveJsonSerDe) : that.hiveJsonSerDe != null) return false;
                return this.openXJsonSerDe != null ? this.openXJsonSerDe.equals(that.openXJsonSerDe) : that.openXJsonSerDe == null;
            }

            @Override
            public final int hashCode() {
                int result = this.hiveJsonSerDe != null ? this.hiveJsonSerDe.hashCode() : 0;
                result = 31 * result + (this.openXJsonSerDe != null ? this.openXJsonSerDe.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes the configuration of a destination in Apache Iceberg Tables.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * DestinationTableConfigurationProperty destinationTableConfigurationProperty = DestinationTableConfigurationProperty.builder()
     *         .destinationDatabaseName("destinationDatabaseName")
     *         .destinationTableName("destinationTableName")
     *         // the properties below are optional
     *         .s3ErrorOutputPrefix("s3ErrorOutputPrefix")
     *         .uniqueKeys(List.of("uniqueKeys"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-destinationtableconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-destinationtableconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.DestinationTableConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(DestinationTableConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DestinationTableConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the Apache Iceberg database.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-destinationtableconfiguration.html#cfn-kinesisfirehose-deliverystream-destinationtableconfiguration-destinationdatabasename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-destinationtableconfiguration.html#cfn-kinesisfirehose-deliverystream-destinationtableconfiguration-destinationdatabasename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDestinationDatabaseName();

        /**
         * Specifies the name of the Apache Iceberg Table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-destinationtableconfiguration.html#cfn-kinesisfirehose-deliverystream-destinationtableconfiguration-destinationtablename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-destinationtableconfiguration.html#cfn-kinesisfirehose-deliverystream-destinationtableconfiguration-destinationtablename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDestinationTableName();

        /**
         * The table specific S3 error output prefix.
         * <p>
         * All the errors that occurred while delivering to this table will be prefixed with this value in S3 destination.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-destinationtableconfiguration.html#cfn-kinesisfirehose-deliverystream-destinationtableconfiguration-s3erroroutputprefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-destinationtableconfiguration.html#cfn-kinesisfirehose-deliverystream-destinationtableconfiguration-s3erroroutputprefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3ErrorOutputPrefix() {
            return null;
        }

        /**
         * A list of unique keys for a given Apache Iceberg table.
         * <p>
         * Firehose will use these for running Create, Update, or Delete operations on the given Iceberg table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-destinationtableconfiguration.html#cfn-kinesisfirehose-deliverystream-destinationtableconfiguration-uniquekeys">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-destinationtableconfiguration.html#cfn-kinesisfirehose-deliverystream-destinationtableconfiguration-uniquekeys</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getUniqueKeys() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DestinationTableConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DestinationTableConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DestinationTableConfigurationProperty> {
            java.lang.String destinationDatabaseName;
            java.lang.String destinationTableName;
            java.lang.String s3ErrorOutputPrefix;
            java.util.List<java.lang.String> uniqueKeys;

            /**
             * Sets the value of {@link DestinationTableConfigurationProperty#getDestinationDatabaseName}
             * @param destinationDatabaseName The name of the Apache Iceberg database. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationDatabaseName(java.lang.String destinationDatabaseName) {
                this.destinationDatabaseName = destinationDatabaseName;
                return this;
            }

            /**
             * Sets the value of {@link DestinationTableConfigurationProperty#getDestinationTableName}
             * @param destinationTableName Specifies the name of the Apache Iceberg Table. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationTableName(java.lang.String destinationTableName) {
                this.destinationTableName = destinationTableName;
                return this;
            }

            /**
             * Sets the value of {@link DestinationTableConfigurationProperty#getS3ErrorOutputPrefix}
             * @param s3ErrorOutputPrefix The table specific S3 error output prefix.
             *                            All the errors that occurred while delivering to this table will be prefixed with this value in S3 destination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3ErrorOutputPrefix(java.lang.String s3ErrorOutputPrefix) {
                this.s3ErrorOutputPrefix = s3ErrorOutputPrefix;
                return this;
            }

            /**
             * Sets the value of {@link DestinationTableConfigurationProperty#getUniqueKeys}
             * @param uniqueKeys A list of unique keys for a given Apache Iceberg table.
             *                   Firehose will use these for running Create, Update, or Delete operations on the given Iceberg table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder uniqueKeys(java.util.List<java.lang.String> uniqueKeys) {
                this.uniqueKeys = uniqueKeys;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DestinationTableConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DestinationTableConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DestinationTableConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DestinationTableConfigurationProperty {
            private final java.lang.String destinationDatabaseName;
            private final java.lang.String destinationTableName;
            private final java.lang.String s3ErrorOutputPrefix;
            private final java.util.List<java.lang.String> uniqueKeys;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.destinationDatabaseName = software.amazon.jsii.Kernel.get(this, "destinationDatabaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.destinationTableName = software.amazon.jsii.Kernel.get(this, "destinationTableName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3ErrorOutputPrefix = software.amazon.jsii.Kernel.get(this, "s3ErrorOutputPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.uniqueKeys = software.amazon.jsii.Kernel.get(this, "uniqueKeys", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.destinationDatabaseName = java.util.Objects.requireNonNull(builder.destinationDatabaseName, "destinationDatabaseName is required");
                this.destinationTableName = java.util.Objects.requireNonNull(builder.destinationTableName, "destinationTableName is required");
                this.s3ErrorOutputPrefix = builder.s3ErrorOutputPrefix;
                this.uniqueKeys = builder.uniqueKeys;
            }

            @Override
            public final java.lang.String getDestinationDatabaseName() {
                return this.destinationDatabaseName;
            }

            @Override
            public final java.lang.String getDestinationTableName() {
                return this.destinationTableName;
            }

            @Override
            public final java.lang.String getS3ErrorOutputPrefix() {
                return this.s3ErrorOutputPrefix;
            }

            @Override
            public final java.util.List<java.lang.String> getUniqueKeys() {
                return this.uniqueKeys;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("destinationDatabaseName", om.valueToTree(this.getDestinationDatabaseName()));
                data.set("destinationTableName", om.valueToTree(this.getDestinationTableName()));
                if (this.getS3ErrorOutputPrefix() != null) {
                    data.set("s3ErrorOutputPrefix", om.valueToTree(this.getS3ErrorOutputPrefix()));
                }
                if (this.getUniqueKeys() != null) {
                    data.set("uniqueKeys", om.valueToTree(this.getUniqueKeys()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.DestinationTableConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DestinationTableConfigurationProperty.Jsii$Proxy that = (DestinationTableConfigurationProperty.Jsii$Proxy) o;

                if (!destinationDatabaseName.equals(that.destinationDatabaseName)) return false;
                if (!destinationTableName.equals(that.destinationTableName)) return false;
                if (this.s3ErrorOutputPrefix != null ? !this.s3ErrorOutputPrefix.equals(that.s3ErrorOutputPrefix) : that.s3ErrorOutputPrefix != null) return false;
                return this.uniqueKeys != null ? this.uniqueKeys.equals(that.uniqueKeys) : that.uniqueKeys == null;
            }

            @Override
            public final int hashCode() {
                int result = this.destinationDatabaseName.hashCode();
                result = 31 * result + (this.destinationTableName.hashCode());
                result = 31 * result + (this.s3ErrorOutputPrefix != null ? this.s3ErrorOutputPrefix.hashCode() : 0);
                result = 31 * result + (this.uniqueKeys != null ? this.uniqueKeys.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The structure that configures parameters such as <code>ThroughputHintInMBs</code> for a stream configured with Direct PUT as a source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * DirectPutSourceConfigurationProperty directPutSourceConfigurationProperty = DirectPutSourceConfigurationProperty.builder()
     *         .throughputHintInMBs(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-directputsourceconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-directputsourceconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.DirectPutSourceConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(DirectPutSourceConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DirectPutSourceConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The value that you configure for this parameter is for information purpose only and does not affect Firehose delivery throughput limit.
         * <p>
         * You can use the <a href="https://docs.aws.amazon.com/https://support.console.aws.amazon.com/support/home#/case/create%3FissueType=service-limit-increase%26limitType=kinesis-firehose-limits">Firehose Limits form</a> to request a throughput limit increase.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-directputsourceconfiguration.html#cfn-kinesisfirehose-deliverystream-directputsourceconfiguration-throughputhintinmbs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-directputsourceconfiguration.html#cfn-kinesisfirehose-deliverystream-directputsourceconfiguration-throughputhintinmbs</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getThroughputHintInMBs() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DirectPutSourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DirectPutSourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DirectPutSourceConfigurationProperty> {
            java.lang.Number throughputHintInMBs;

            /**
             * Sets the value of {@link DirectPutSourceConfigurationProperty#getThroughputHintInMBs}
             * @param throughputHintInMBs The value that you configure for this parameter is for information purpose only and does not affect Firehose delivery throughput limit.
             *                            You can use the <a href="https://docs.aws.amazon.com/https://support.console.aws.amazon.com/support/home#/case/create%3FissueType=service-limit-increase%26limitType=kinesis-firehose-limits">Firehose Limits form</a> to request a throughput limit increase.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder throughputHintInMBs(java.lang.Number throughputHintInMBs) {
                this.throughputHintInMBs = throughputHintInMBs;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DirectPutSourceConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DirectPutSourceConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DirectPutSourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DirectPutSourceConfigurationProperty {
            private final java.lang.Number throughputHintInMBs;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.throughputHintInMBs = software.amazon.jsii.Kernel.get(this, "throughputHintInMBs", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.throughputHintInMBs = builder.throughputHintInMBs;
            }

            @Override
            public final java.lang.Number getThroughputHintInMBs() {
                return this.throughputHintInMBs;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getThroughputHintInMBs() != null) {
                    data.set("throughputHintInMBs", om.valueToTree(this.getThroughputHintInMBs()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.DirectPutSourceConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DirectPutSourceConfigurationProperty.Jsii$Proxy that = (DirectPutSourceConfigurationProperty.Jsii$Proxy) o;

                return this.throughputHintInMBs != null ? this.throughputHintInMBs.equals(that.throughputHintInMBs) : that.throughputHintInMBs == null;
            }

            @Override
            public final int hashCode() {
                int result = this.throughputHintInMBs != null ? this.throughputHintInMBs.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Indicates the method for setting up document ID.
     * <p>
     * The supported methods are Firehose generated document ID and OpenSearch Service generated document ID.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * DocumentIdOptionsProperty documentIdOptionsProperty = DocumentIdOptionsProperty.builder()
     *         .defaultDocumentIdFormat("defaultDocumentIdFormat")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-documentidoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-documentidoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.DocumentIdOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(DocumentIdOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DocumentIdOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * When the <code>FIREHOSE_DEFAULT</code> option is chosen, Firehose generates a unique document ID for each record based on a unique internal identifier.
         * <p>
         * The generated document ID is stable across multiple delivery attempts, which helps prevent the same record from being indexed multiple times with different document IDs.
         * <p>
         * When the <code>NO_DOCUMENT_ID</code> option is chosen, Firehose does not include any document IDs in the requests it sends to the Amazon OpenSearch Service. This causes the Amazon OpenSearch Service domain to generate document IDs. In case of multiple delivery attempts, this may cause the same record to be indexed more than once with different document IDs. This option enables write-heavy operations, such as the ingestion of logs and observability data, to consume less resources in the Amazon OpenSearch Service domain, resulting in improved performance.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-documentidoptions.html#cfn-kinesisfirehose-deliverystream-documentidoptions-defaultdocumentidformat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-documentidoptions.html#cfn-kinesisfirehose-deliverystream-documentidoptions-defaultdocumentidformat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDefaultDocumentIdFormat();

        /**
         * @return a {@link Builder} of {@link DocumentIdOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DocumentIdOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DocumentIdOptionsProperty> {
            java.lang.String defaultDocumentIdFormat;

            /**
             * Sets the value of {@link DocumentIdOptionsProperty#getDefaultDocumentIdFormat}
             * @param defaultDocumentIdFormat When the <code>FIREHOSE_DEFAULT</code> option is chosen, Firehose generates a unique document ID for each record based on a unique internal identifier. This parameter is required.
             *                                The generated document ID is stable across multiple delivery attempts, which helps prevent the same record from being indexed multiple times with different document IDs.
             *                                <p>
             *                                When the <code>NO_DOCUMENT_ID</code> option is chosen, Firehose does not include any document IDs in the requests it sends to the Amazon OpenSearch Service. This causes the Amazon OpenSearch Service domain to generate document IDs. In case of multiple delivery attempts, this may cause the same record to be indexed more than once with different document IDs. This option enables write-heavy operations, such as the ingestion of logs and observability data, to consume less resources in the Amazon OpenSearch Service domain, resulting in improved performance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultDocumentIdFormat(java.lang.String defaultDocumentIdFormat) {
                this.defaultDocumentIdFormat = defaultDocumentIdFormat;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DocumentIdOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DocumentIdOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DocumentIdOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DocumentIdOptionsProperty {
            private final java.lang.String defaultDocumentIdFormat;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.defaultDocumentIdFormat = software.amazon.jsii.Kernel.get(this, "defaultDocumentIdFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.defaultDocumentIdFormat = java.util.Objects.requireNonNull(builder.defaultDocumentIdFormat, "defaultDocumentIdFormat is required");
            }

            @Override
            public final java.lang.String getDefaultDocumentIdFormat() {
                return this.defaultDocumentIdFormat;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("defaultDocumentIdFormat", om.valueToTree(this.getDefaultDocumentIdFormat()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.DocumentIdOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DocumentIdOptionsProperty.Jsii$Proxy that = (DocumentIdOptionsProperty.Jsii$Proxy) o;

                return this.defaultDocumentIdFormat.equals(that.defaultDocumentIdFormat);
            }

            @Override
            public final int hashCode() {
                int result = this.defaultDocumentIdFormat.hashCode();
                return result;
            }
        }
    }
    /**
     * The <code>DynamicPartitioningConfiguration</code> property type specifies the configuration of the dynamic partitioning mechanism that creates targeted data sets from the streaming data by partitioning it based on partition keys.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * DynamicPartitioningConfigurationProperty dynamicPartitioningConfigurationProperty = DynamicPartitioningConfigurationProperty.builder()
     *         .enabled(false)
     *         .retryOptions(RetryOptionsProperty.builder()
     *                 .durationInSeconds(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-dynamicpartitioningconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-dynamicpartitioningconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.DynamicPartitioningConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(DynamicPartitioningConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DynamicPartitioningConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether dynamic partitioning is enabled for this Kinesis Data Firehose delivery stream.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-dynamicpartitioningconfiguration.html#cfn-kinesisfirehose-deliverystream-dynamicpartitioningconfiguration-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-dynamicpartitioningconfiguration.html#cfn-kinesisfirehose-deliverystream-dynamicpartitioningconfiguration-enabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * Specifies the retry behavior in case Kinesis Data Firehose is unable to deliver data to an Amazon S3 prefix.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-dynamicpartitioningconfiguration.html#cfn-kinesisfirehose-deliverystream-dynamicpartitioningconfiguration-retryoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-dynamicpartitioningconfiguration.html#cfn-kinesisfirehose-deliverystream-dynamicpartitioningconfiguration-retryoptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRetryOptions() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DynamicPartitioningConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DynamicPartitioningConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DynamicPartitioningConfigurationProperty> {
            java.lang.Object enabled;
            java.lang.Object retryOptions;

            /**
             * Sets the value of {@link DynamicPartitioningConfigurationProperty#getEnabled}
             * @param enabled Specifies whether dynamic partitioning is enabled for this Kinesis Data Firehose delivery stream.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link DynamicPartitioningConfigurationProperty#getEnabled}
             * @param enabled Specifies whether dynamic partitioning is enabled for this Kinesis Data Firehose delivery stream.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link DynamicPartitioningConfigurationProperty#getRetryOptions}
             * @param retryOptions Specifies the retry behavior in case Kinesis Data Firehose is unable to deliver data to an Amazon S3 prefix.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retryOptions(software.amazon.awscdk.IResolvable retryOptions) {
                this.retryOptions = retryOptions;
                return this;
            }

            /**
             * Sets the value of {@link DynamicPartitioningConfigurationProperty#getRetryOptions}
             * @param retryOptions Specifies the retry behavior in case Kinesis Data Firehose is unable to deliver data to an Amazon S3 prefix.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retryOptions(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.RetryOptionsProperty retryOptions) {
                this.retryOptions = retryOptions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DynamicPartitioningConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DynamicPartitioningConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DynamicPartitioningConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DynamicPartitioningConfigurationProperty {
            private final java.lang.Object enabled;
            private final java.lang.Object retryOptions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.retryOptions = software.amazon.jsii.Kernel.get(this, "retryOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = builder.enabled;
                this.retryOptions = builder.retryOptions;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.Object getRetryOptions() {
                return this.retryOptions;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }
                if (this.getRetryOptions() != null) {
                    data.set("retryOptions", om.valueToTree(this.getRetryOptions()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.DynamicPartitioningConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DynamicPartitioningConfigurationProperty.Jsii$Proxy that = (DynamicPartitioningConfigurationProperty.Jsii$Proxy) o;

                if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
                return this.retryOptions != null ? this.retryOptions.equals(that.retryOptions) : that.retryOptions == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled != null ? this.enabled.hashCode() : 0;
                result = 31 * result + (this.retryOptions != null ? this.retryOptions.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The <code>ElasticsearchBufferingHints</code> property type specifies how Amazon Kinesis Data Firehose (Kinesis Data Firehose) buffers incoming data while delivering it to the destination.
     * <p>
     * The first buffer condition that is satisfied triggers Kinesis Data Firehose to deliver the data.
     * <p>
     * ElasticsearchBufferingHints is the property type for the <code>BufferingHints</code> property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration.html">Amazon Kinesis Data Firehose DeliveryStream ElasticsearchDestinationConfiguration</a> property type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * ElasticsearchBufferingHintsProperty elasticsearchBufferingHintsProperty = ElasticsearchBufferingHintsProperty.builder()
     *         .intervalInSeconds(123)
     *         .sizeInMBs(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchbufferinghints.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchbufferinghints.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.ElasticsearchBufferingHintsProperty")
    @software.amazon.jsii.Jsii.Proxy(ElasticsearchBufferingHintsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ElasticsearchBufferingHintsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The length of time, in seconds, that Kinesis Data Firehose buffers incoming data before delivering it to the destination.
         * <p>
         * For valid values, see the <code>IntervalInSeconds</code> content for the <a href="https://docs.aws.amazon.com/firehose/latest/APIReference/API_BufferingHints.html">BufferingHints</a> data type in the <em>Amazon Kinesis Data Firehose API Reference</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchbufferinghints.html#cfn-kinesisfirehose-deliverystream-elasticsearchbufferinghints-intervalinseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchbufferinghints.html#cfn-kinesisfirehose-deliverystream-elasticsearchbufferinghints-intervalinseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getIntervalInSeconds() {
            return null;
        }

        /**
         * The size of the buffer, in MBs, that Kinesis Data Firehose uses for incoming data before delivering it to the destination.
         * <p>
         * For valid values, see the <code>SizeInMBs</code> content for the <a href="https://docs.aws.amazon.com/firehose/latest/APIReference/API_BufferingHints.html">BufferingHints</a> data type in the <em>Amazon Kinesis Data Firehose API Reference</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchbufferinghints.html#cfn-kinesisfirehose-deliverystream-elasticsearchbufferinghints-sizeinmbs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchbufferinghints.html#cfn-kinesisfirehose-deliverystream-elasticsearchbufferinghints-sizeinmbs</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSizeInMBs() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ElasticsearchBufferingHintsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ElasticsearchBufferingHintsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ElasticsearchBufferingHintsProperty> {
            java.lang.Number intervalInSeconds;
            java.lang.Number sizeInMBs;

            /**
             * Sets the value of {@link ElasticsearchBufferingHintsProperty#getIntervalInSeconds}
             * @param intervalInSeconds The length of time, in seconds, that Kinesis Data Firehose buffers incoming data before delivering it to the destination.
             *                          For valid values, see the <code>IntervalInSeconds</code> content for the <a href="https://docs.aws.amazon.com/firehose/latest/APIReference/API_BufferingHints.html">BufferingHints</a> data type in the <em>Amazon Kinesis Data Firehose API Reference</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder intervalInSeconds(java.lang.Number intervalInSeconds) {
                this.intervalInSeconds = intervalInSeconds;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchBufferingHintsProperty#getSizeInMBs}
             * @param sizeInMBs The size of the buffer, in MBs, that Kinesis Data Firehose uses for incoming data before delivering it to the destination.
             *                  For valid values, see the <code>SizeInMBs</code> content for the <a href="https://docs.aws.amazon.com/firehose/latest/APIReference/API_BufferingHints.html">BufferingHints</a> data type in the <em>Amazon Kinesis Data Firehose API Reference</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sizeInMBs(java.lang.Number sizeInMBs) {
                this.sizeInMBs = sizeInMBs;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ElasticsearchBufferingHintsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ElasticsearchBufferingHintsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ElasticsearchBufferingHintsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ElasticsearchBufferingHintsProperty {
            private final java.lang.Number intervalInSeconds;
            private final java.lang.Number sizeInMBs;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.intervalInSeconds = software.amazon.jsii.Kernel.get(this, "intervalInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.sizeInMBs = software.amazon.jsii.Kernel.get(this, "sizeInMBs", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.intervalInSeconds = builder.intervalInSeconds;
                this.sizeInMBs = builder.sizeInMBs;
            }

            @Override
            public final java.lang.Number getIntervalInSeconds() {
                return this.intervalInSeconds;
            }

            @Override
            public final java.lang.Number getSizeInMBs() {
                return this.sizeInMBs;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getIntervalInSeconds() != null) {
                    data.set("intervalInSeconds", om.valueToTree(this.getIntervalInSeconds()));
                }
                if (this.getSizeInMBs() != null) {
                    data.set("sizeInMBs", om.valueToTree(this.getSizeInMBs()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.ElasticsearchBufferingHintsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ElasticsearchBufferingHintsProperty.Jsii$Proxy that = (ElasticsearchBufferingHintsProperty.Jsii$Proxy) o;

                if (this.intervalInSeconds != null ? !this.intervalInSeconds.equals(that.intervalInSeconds) : that.intervalInSeconds != null) return false;
                return this.sizeInMBs != null ? this.sizeInMBs.equals(that.sizeInMBs) : that.sizeInMBs == null;
            }

            @Override
            public final int hashCode() {
                int result = this.intervalInSeconds != null ? this.intervalInSeconds.hashCode() : 0;
                result = 31 * result + (this.sizeInMBs != null ? this.sizeInMBs.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The <code>ElasticsearchDestinationConfiguration</code> property type specifies an Amazon Elasticsearch Service (Amazon ES) domain that Amazon Kinesis Data Firehose (Kinesis Data Firehose) delivers data to.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * ElasticsearchDestinationConfigurationProperty elasticsearchDestinationConfigurationProperty = ElasticsearchDestinationConfigurationProperty.builder()
     *         .indexName("indexName")
     *         .roleArn("roleArn")
     *         .s3Configuration(S3DestinationConfigurationProperty.builder()
     *                 .bucketArn("bucketArn")
     *                 .roleArn("roleArn")
     *                 // the properties below are optional
     *                 .bufferingHints(BufferingHintsProperty.builder()
     *                         .intervalInSeconds(123)
     *                         .sizeInMBs(123)
     *                         .build())
     *                 .cloudWatchLoggingOptions(CloudWatchLoggingOptionsProperty.builder()
     *                         .enabled(false)
     *                         .logGroupName("logGroupName")
     *                         .logStreamName("logStreamName")
     *                         .build())
     *                 .compressionFormat("compressionFormat")
     *                 .encryptionConfiguration(EncryptionConfigurationProperty.builder()
     *                         .kmsEncryptionConfig(KMSEncryptionConfigProperty.builder()
     *                                 .awskmsKeyArn("awskmsKeyArn")
     *                                 .build())
     *                         .noEncryptionConfig("noEncryptionConfig")
     *                         .build())
     *                 .errorOutputPrefix("errorOutputPrefix")
     *                 .prefix("prefix")
     *                 .build())
     *         // the properties below are optional
     *         .bufferingHints(ElasticsearchBufferingHintsProperty.builder()
     *                 .intervalInSeconds(123)
     *                 .sizeInMBs(123)
     *                 .build())
     *         .cloudWatchLoggingOptions(CloudWatchLoggingOptionsProperty.builder()
     *                 .enabled(false)
     *                 .logGroupName("logGroupName")
     *                 .logStreamName("logStreamName")
     *                 .build())
     *         .clusterEndpoint("clusterEndpoint")
     *         .documentIdOptions(DocumentIdOptionsProperty.builder()
     *                 .defaultDocumentIdFormat("defaultDocumentIdFormat")
     *                 .build())
     *         .domainArn("domainArn")
     *         .indexRotationPeriod("indexRotationPeriod")
     *         .processingConfiguration(ProcessingConfigurationProperty.builder()
     *                 .enabled(false)
     *                 .processors(List.of(ProcessorProperty.builder()
     *                         .type("type")
     *                         // the properties below are optional
     *                         .parameters(List.of(ProcessorParameterProperty.builder()
     *                                 .parameterName("parameterName")
     *                                 .parameterValue("parameterValue")
     *                                 .build()))
     *                         .build()))
     *                 .build())
     *         .retryOptions(ElasticsearchRetryOptionsProperty.builder()
     *                 .durationInSeconds(123)
     *                 .build())
     *         .s3BackupMode("s3BackupMode")
     *         .typeName("typeName")
     *         .vpcConfiguration(VpcConfigurationProperty.builder()
     *                 .roleArn("roleArn")
     *                 .securityGroupIds(List.of("securityGroupIds"))
     *                 .subnetIds(List.of("subnetIds"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.ElasticsearchDestinationConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ElasticsearchDestinationConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ElasticsearchDestinationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the Elasticsearch index to which Kinesis Data Firehose adds data for indexing.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration-indexname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration-indexname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getIndexName();

        /**
         * The Amazon Resource Name (ARN) of the IAM role to be assumed by Kinesis Data Firehose for calling the Amazon ES Configuration API and for indexing documents.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/controlling-access.html">Controlling Access with Amazon Kinesis Data Firehose</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * The S3 bucket where Kinesis Data Firehose backs up incoming data.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration-s3configuration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration-s3configuration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getS3Configuration();

        /**
         * Configures how Kinesis Data Firehose buffers incoming data while delivering it to the Amazon ES domain.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration-bufferinghints">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration-bufferinghints</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBufferingHints() {
            return null;
        }

        /**
         * The Amazon CloudWatch Logs logging options for the delivery stream.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration-cloudwatchloggingoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration-cloudwatchloggingoptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCloudWatchLoggingOptions() {
            return null;
        }

        /**
         * The endpoint to use when communicating with the cluster.
         * <p>
         * Specify either this <code>ClusterEndpoint</code> or the <code>DomainARN</code> field.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration-clusterendpoint">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration-clusterendpoint</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getClusterEndpoint() {
            return null;
        }

        /**
         * Indicates the method for setting up document ID.
         * <p>
         * The supported methods are Firehose generated document ID and OpenSearch Service generated document ID.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration-documentidoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration-documentidoptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDocumentIdOptions() {
            return null;
        }

        /**
         * The ARN of the Amazon ES domain.
         * <p>
         * The IAM role must have permissions for <code>DescribeElasticsearchDomain</code> , <code>DescribeElasticsearchDomains</code> , and <code>DescribeElasticsearchDomainConfig</code> after assuming the role specified in <em>RoleARN</em> .
         * <p>
         * Specify either <code>ClusterEndpoint</code> or <code>DomainARN</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration-domainarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration-domainarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDomainArn() {
            return null;
        }

        /**
         * The frequency of Elasticsearch index rotation.
         * <p>
         * If you enable index rotation, Kinesis Data Firehose appends a portion of the UTC arrival timestamp to the specified index name, and rotates the appended timestamp accordingly. For more information, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-index-rotation">Index Rotation for the Amazon ES Destination</a> in the <em>Amazon Kinesis Data Firehose Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration-indexrotationperiod">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration-indexrotationperiod</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIndexRotationPeriod() {
            return null;
        }

        /**
         * The data processing configuration for the Kinesis Data Firehose delivery stream.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration-processingconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration-processingconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getProcessingConfiguration() {
            return null;
        }

        /**
         * The retry behavior when Kinesis Data Firehose is unable to deliver data to Amazon ES.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration-retryoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration-retryoptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRetryOptions() {
            return null;
        }

        /**
         * The condition under which Kinesis Data Firehose delivers data to Amazon Simple Storage Service (Amazon S3).
         * <p>
         * You can send Amazon S3 all documents (all data) or only the documents that Kinesis Data Firehose could not deliver to the Amazon ES destination. For more information and valid values, see the <code>S3BackupMode</code> content for the <a href="https://docs.aws.amazon.com/firehose/latest/APIReference/API_ElasticsearchDestinationConfiguration.html">ElasticsearchDestinationConfiguration</a> data type in the <em>Amazon Kinesis Data Firehose API Reference</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration-s3backupmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration-s3backupmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3BackupMode() {
            return null;
        }

        /**
         * The Elasticsearch type name that Amazon ES adds to documents when indexing data.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration-typename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration-typename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTypeName() {
            return null;
        }

        /**
         * The details of the VPC of the Amazon ES destination.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration-vpcconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration-vpcconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVpcConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ElasticsearchDestinationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ElasticsearchDestinationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ElasticsearchDestinationConfigurationProperty> {
            java.lang.String indexName;
            java.lang.String roleArn;
            java.lang.Object s3Configuration;
            java.lang.Object bufferingHints;
            java.lang.Object cloudWatchLoggingOptions;
            java.lang.String clusterEndpoint;
            java.lang.Object documentIdOptions;
            java.lang.String domainArn;
            java.lang.String indexRotationPeriod;
            java.lang.Object processingConfiguration;
            java.lang.Object retryOptions;
            java.lang.String s3BackupMode;
            java.lang.String typeName;
            java.lang.Object vpcConfiguration;

            /**
             * Sets the value of {@link ElasticsearchDestinationConfigurationProperty#getIndexName}
             * @param indexName The name of the Elasticsearch index to which Kinesis Data Firehose adds data for indexing. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder indexName(java.lang.String indexName) {
                this.indexName = indexName;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchDestinationConfigurationProperty#getRoleArn}
             * @param roleArn The Amazon Resource Name (ARN) of the IAM role to be assumed by Kinesis Data Firehose for calling the Amazon ES Configuration API and for indexing documents. This parameter is required.
             *                For more information, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/controlling-access.html">Controlling Access with Amazon Kinesis Data Firehose</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchDestinationConfigurationProperty#getS3Configuration}
             * @param s3Configuration The S3 bucket where Kinesis Data Firehose backs up incoming data. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Configuration(software.amazon.awscdk.IResolvable s3Configuration) {
                this.s3Configuration = s3Configuration;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchDestinationConfigurationProperty#getS3Configuration}
             * @param s3Configuration The S3 bucket where Kinesis Data Firehose backs up incoming data. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Configuration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.S3DestinationConfigurationProperty s3Configuration) {
                this.s3Configuration = s3Configuration;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchDestinationConfigurationProperty#getBufferingHints}
             * @param bufferingHints Configures how Kinesis Data Firehose buffers incoming data while delivering it to the Amazon ES domain.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bufferingHints(software.amazon.awscdk.IResolvable bufferingHints) {
                this.bufferingHints = bufferingHints;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchDestinationConfigurationProperty#getBufferingHints}
             * @param bufferingHints Configures how Kinesis Data Firehose buffers incoming data while delivering it to the Amazon ES domain.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bufferingHints(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.ElasticsearchBufferingHintsProperty bufferingHints) {
                this.bufferingHints = bufferingHints;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchDestinationConfigurationProperty#getCloudWatchLoggingOptions}
             * @param cloudWatchLoggingOptions The Amazon CloudWatch Logs logging options for the delivery stream.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchLoggingOptions(software.amazon.awscdk.IResolvable cloudWatchLoggingOptions) {
                this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchDestinationConfigurationProperty#getCloudWatchLoggingOptions}
             * @param cloudWatchLoggingOptions The Amazon CloudWatch Logs logging options for the delivery stream.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchLoggingOptions(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.CloudWatchLoggingOptionsProperty cloudWatchLoggingOptions) {
                this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchDestinationConfigurationProperty#getClusterEndpoint}
             * @param clusterEndpoint The endpoint to use when communicating with the cluster.
             *                        Specify either this <code>ClusterEndpoint</code> or the <code>DomainARN</code> field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clusterEndpoint(java.lang.String clusterEndpoint) {
                this.clusterEndpoint = clusterEndpoint;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchDestinationConfigurationProperty#getDocumentIdOptions}
             * @param documentIdOptions Indicates the method for setting up document ID.
             *                          The supported methods are Firehose generated document ID and OpenSearch Service generated document ID.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder documentIdOptions(software.amazon.awscdk.IResolvable documentIdOptions) {
                this.documentIdOptions = documentIdOptions;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchDestinationConfigurationProperty#getDocumentIdOptions}
             * @param documentIdOptions Indicates the method for setting up document ID.
             *                          The supported methods are Firehose generated document ID and OpenSearch Service generated document ID.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder documentIdOptions(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.DocumentIdOptionsProperty documentIdOptions) {
                this.documentIdOptions = documentIdOptions;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchDestinationConfigurationProperty#getDomainArn}
             * @param domainArn The ARN of the Amazon ES domain.
             *                  The IAM role must have permissions for <code>DescribeElasticsearchDomain</code> , <code>DescribeElasticsearchDomains</code> , and <code>DescribeElasticsearchDomainConfig</code> after assuming the role specified in <em>RoleARN</em> .
             *                  <p>
             *                  Specify either <code>ClusterEndpoint</code> or <code>DomainARN</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder domainArn(java.lang.String domainArn) {
                this.domainArn = domainArn;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchDestinationConfigurationProperty#getIndexRotationPeriod}
             * @param indexRotationPeriod The frequency of Elasticsearch index rotation.
             *                            If you enable index rotation, Kinesis Data Firehose appends a portion of the UTC arrival timestamp to the specified index name, and rotates the appended timestamp accordingly. For more information, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-index-rotation">Index Rotation for the Amazon ES Destination</a> in the <em>Amazon Kinesis Data Firehose Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder indexRotationPeriod(java.lang.String indexRotationPeriod) {
                this.indexRotationPeriod = indexRotationPeriod;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchDestinationConfigurationProperty#getProcessingConfiguration}
             * @param processingConfiguration The data processing configuration for the Kinesis Data Firehose delivery stream.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder processingConfiguration(software.amazon.awscdk.IResolvable processingConfiguration) {
                this.processingConfiguration = processingConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchDestinationConfigurationProperty#getProcessingConfiguration}
             * @param processingConfiguration The data processing configuration for the Kinesis Data Firehose delivery stream.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder processingConfiguration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.ProcessingConfigurationProperty processingConfiguration) {
                this.processingConfiguration = processingConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchDestinationConfigurationProperty#getRetryOptions}
             * @param retryOptions The retry behavior when Kinesis Data Firehose is unable to deliver data to Amazon ES.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retryOptions(software.amazon.awscdk.IResolvable retryOptions) {
                this.retryOptions = retryOptions;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchDestinationConfigurationProperty#getRetryOptions}
             * @param retryOptions The retry behavior when Kinesis Data Firehose is unable to deliver data to Amazon ES.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retryOptions(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.ElasticsearchRetryOptionsProperty retryOptions) {
                this.retryOptions = retryOptions;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchDestinationConfigurationProperty#getS3BackupMode}
             * @param s3BackupMode The condition under which Kinesis Data Firehose delivers data to Amazon Simple Storage Service (Amazon S3).
             *                     You can send Amazon S3 all documents (all data) or only the documents that Kinesis Data Firehose could not deliver to the Amazon ES destination. For more information and valid values, see the <code>S3BackupMode</code> content for the <a href="https://docs.aws.amazon.com/firehose/latest/APIReference/API_ElasticsearchDestinationConfiguration.html">ElasticsearchDestinationConfiguration</a> data type in the <em>Amazon Kinesis Data Firehose API Reference</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3BackupMode(java.lang.String s3BackupMode) {
                this.s3BackupMode = s3BackupMode;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchDestinationConfigurationProperty#getTypeName}
             * @param typeName The Elasticsearch type name that Amazon ES adds to documents when indexing data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder typeName(java.lang.String typeName) {
                this.typeName = typeName;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchDestinationConfigurationProperty#getVpcConfiguration}
             * @param vpcConfiguration The details of the VPC of the Amazon ES destination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcConfiguration(software.amazon.awscdk.IResolvable vpcConfiguration) {
                this.vpcConfiguration = vpcConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ElasticsearchDestinationConfigurationProperty#getVpcConfiguration}
             * @param vpcConfiguration The details of the VPC of the Amazon ES destination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcConfiguration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.VpcConfigurationProperty vpcConfiguration) {
                this.vpcConfiguration = vpcConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ElasticsearchDestinationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ElasticsearchDestinationConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ElasticsearchDestinationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ElasticsearchDestinationConfigurationProperty {
            private final java.lang.String indexName;
            private final java.lang.String roleArn;
            private final java.lang.Object s3Configuration;
            private final java.lang.Object bufferingHints;
            private final java.lang.Object cloudWatchLoggingOptions;
            private final java.lang.String clusterEndpoint;
            private final java.lang.Object documentIdOptions;
            private final java.lang.String domainArn;
            private final java.lang.String indexRotationPeriod;
            private final java.lang.Object processingConfiguration;
            private final java.lang.Object retryOptions;
            private final java.lang.String s3BackupMode;
            private final java.lang.String typeName;
            private final java.lang.Object vpcConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.indexName = software.amazon.jsii.Kernel.get(this, "indexName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3Configuration = software.amazon.jsii.Kernel.get(this, "s3Configuration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.bufferingHints = software.amazon.jsii.Kernel.get(this, "bufferingHints", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.cloudWatchLoggingOptions = software.amazon.jsii.Kernel.get(this, "cloudWatchLoggingOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.clusterEndpoint = software.amazon.jsii.Kernel.get(this, "clusterEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.documentIdOptions = software.amazon.jsii.Kernel.get(this, "documentIdOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.domainArn = software.amazon.jsii.Kernel.get(this, "domainArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.indexRotationPeriod = software.amazon.jsii.Kernel.get(this, "indexRotationPeriod", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.processingConfiguration = software.amazon.jsii.Kernel.get(this, "processingConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.retryOptions = software.amazon.jsii.Kernel.get(this, "retryOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.s3BackupMode = software.amazon.jsii.Kernel.get(this, "s3BackupMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.typeName = software.amazon.jsii.Kernel.get(this, "typeName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.vpcConfiguration = software.amazon.jsii.Kernel.get(this, "vpcConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.indexName = java.util.Objects.requireNonNull(builder.indexName, "indexName is required");
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
                this.s3Configuration = java.util.Objects.requireNonNull(builder.s3Configuration, "s3Configuration is required");
                this.bufferingHints = builder.bufferingHints;
                this.cloudWatchLoggingOptions = builder.cloudWatchLoggingOptions;
                this.clusterEndpoint = builder.clusterEndpoint;
                this.documentIdOptions = builder.documentIdOptions;
                this.domainArn = builder.domainArn;
                this.indexRotationPeriod = builder.indexRotationPeriod;
                this.processingConfiguration = builder.processingConfiguration;
                this.retryOptions = builder.retryOptions;
                this.s3BackupMode = builder.s3BackupMode;
                this.typeName = builder.typeName;
                this.vpcConfiguration = builder.vpcConfiguration;
            }

            @Override
            public final java.lang.String getIndexName() {
                return this.indexName;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.Object getS3Configuration() {
                return this.s3Configuration;
            }

            @Override
            public final java.lang.Object getBufferingHints() {
                return this.bufferingHints;
            }

            @Override
            public final java.lang.Object getCloudWatchLoggingOptions() {
                return this.cloudWatchLoggingOptions;
            }

            @Override
            public final java.lang.String getClusterEndpoint() {
                return this.clusterEndpoint;
            }

            @Override
            public final java.lang.Object getDocumentIdOptions() {
                return this.documentIdOptions;
            }

            @Override
            public final java.lang.String getDomainArn() {
                return this.domainArn;
            }

            @Override
            public final java.lang.String getIndexRotationPeriod() {
                return this.indexRotationPeriod;
            }

            @Override
            public final java.lang.Object getProcessingConfiguration() {
                return this.processingConfiguration;
            }

            @Override
            public final java.lang.Object getRetryOptions() {
                return this.retryOptions;
            }

            @Override
            public final java.lang.String getS3BackupMode() {
                return this.s3BackupMode;
            }

            @Override
            public final java.lang.String getTypeName() {
                return this.typeName;
            }

            @Override
            public final java.lang.Object getVpcConfiguration() {
                return this.vpcConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("indexName", om.valueToTree(this.getIndexName()));
                data.set("roleArn", om.valueToTree(this.getRoleArn()));
                data.set("s3Configuration", om.valueToTree(this.getS3Configuration()));
                if (this.getBufferingHints() != null) {
                    data.set("bufferingHints", om.valueToTree(this.getBufferingHints()));
                }
                if (this.getCloudWatchLoggingOptions() != null) {
                    data.set("cloudWatchLoggingOptions", om.valueToTree(this.getCloudWatchLoggingOptions()));
                }
                if (this.getClusterEndpoint() != null) {
                    data.set("clusterEndpoint", om.valueToTree(this.getClusterEndpoint()));
                }
                if (this.getDocumentIdOptions() != null) {
                    data.set("documentIdOptions", om.valueToTree(this.getDocumentIdOptions()));
                }
                if (this.getDomainArn() != null) {
                    data.set("domainArn", om.valueToTree(this.getDomainArn()));
                }
                if (this.getIndexRotationPeriod() != null) {
                    data.set("indexRotationPeriod", om.valueToTree(this.getIndexRotationPeriod()));
                }
                if (this.getProcessingConfiguration() != null) {
                    data.set("processingConfiguration", om.valueToTree(this.getProcessingConfiguration()));
                }
                if (this.getRetryOptions() != null) {
                    data.set("retryOptions", om.valueToTree(this.getRetryOptions()));
                }
                if (this.getS3BackupMode() != null) {
                    data.set("s3BackupMode", om.valueToTree(this.getS3BackupMode()));
                }
                if (this.getTypeName() != null) {
                    data.set("typeName", om.valueToTree(this.getTypeName()));
                }
                if (this.getVpcConfiguration() != null) {
                    data.set("vpcConfiguration", om.valueToTree(this.getVpcConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.ElasticsearchDestinationConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ElasticsearchDestinationConfigurationProperty.Jsii$Proxy that = (ElasticsearchDestinationConfigurationProperty.Jsii$Proxy) o;

                if (!indexName.equals(that.indexName)) return false;
                if (!roleArn.equals(that.roleArn)) return false;
                if (!s3Configuration.equals(that.s3Configuration)) return false;
                if (this.bufferingHints != null ? !this.bufferingHints.equals(that.bufferingHints) : that.bufferingHints != null) return false;
                if (this.cloudWatchLoggingOptions != null ? !this.cloudWatchLoggingOptions.equals(that.cloudWatchLoggingOptions) : that.cloudWatchLoggingOptions != null) return false;
                if (this.clusterEndpoint != null ? !this.clusterEndpoint.equals(that.clusterEndpoint) : that.clusterEndpoint != null) return false;
                if (this.documentIdOptions != null ? !this.documentIdOptions.equals(that.documentIdOptions) : that.documentIdOptions != null) return false;
                if (this.domainArn != null ? !this.domainArn.equals(that.domainArn) : that.domainArn != null) return false;
                if (this.indexRotationPeriod != null ? !this.indexRotationPeriod.equals(that.indexRotationPeriod) : that.indexRotationPeriod != null) return false;
                if (this.processingConfiguration != null ? !this.processingConfiguration.equals(that.processingConfiguration) : that.processingConfiguration != null) return false;
                if (this.retryOptions != null ? !this.retryOptions.equals(that.retryOptions) : that.retryOptions != null) return false;
                if (this.s3BackupMode != null ? !this.s3BackupMode.equals(that.s3BackupMode) : that.s3BackupMode != null) return false;
                if (this.typeName != null ? !this.typeName.equals(that.typeName) : that.typeName != null) return false;
                return this.vpcConfiguration != null ? this.vpcConfiguration.equals(that.vpcConfiguration) : that.vpcConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.indexName.hashCode();
                result = 31 * result + (this.roleArn.hashCode());
                result = 31 * result + (this.s3Configuration.hashCode());
                result = 31 * result + (this.bufferingHints != null ? this.bufferingHints.hashCode() : 0);
                result = 31 * result + (this.cloudWatchLoggingOptions != null ? this.cloudWatchLoggingOptions.hashCode() : 0);
                result = 31 * result + (this.clusterEndpoint != null ? this.clusterEndpoint.hashCode() : 0);
                result = 31 * result + (this.documentIdOptions != null ? this.documentIdOptions.hashCode() : 0);
                result = 31 * result + (this.domainArn != null ? this.domainArn.hashCode() : 0);
                result = 31 * result + (this.indexRotationPeriod != null ? this.indexRotationPeriod.hashCode() : 0);
                result = 31 * result + (this.processingConfiguration != null ? this.processingConfiguration.hashCode() : 0);
                result = 31 * result + (this.retryOptions != null ? this.retryOptions.hashCode() : 0);
                result = 31 * result + (this.s3BackupMode != null ? this.s3BackupMode.hashCode() : 0);
                result = 31 * result + (this.typeName != null ? this.typeName.hashCode() : 0);
                result = 31 * result + (this.vpcConfiguration != null ? this.vpcConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The <code>ElasticsearchRetryOptions</code> property type configures the retry behavior for when Amazon Kinesis Data Firehose (Kinesis Data Firehose) can't deliver data to Amazon Elasticsearch Service (Amazon ES).
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * ElasticsearchRetryOptionsProperty elasticsearchRetryOptionsProperty = ElasticsearchRetryOptionsProperty.builder()
     *         .durationInSeconds(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchretryoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchretryoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.ElasticsearchRetryOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(ElasticsearchRetryOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ElasticsearchRetryOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * After an initial failure to deliver to Amazon ES, the total amount of time during which Kinesis Data Firehose re-attempts delivery (including the first attempt).
         * <p>
         * If Kinesis Data Firehose can't deliver the data within the specified time, it writes the data to the backup S3 bucket. For valid values, see the <code>DurationInSeconds</code> content for the <a href="https://docs.aws.amazon.com/firehose/latest/APIReference/API_ElasticsearchRetryOptions.html">ElasticsearchRetryOptions</a> data type in the <em>Amazon Kinesis Data Firehose API Reference</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchretryoptions.html#cfn-kinesisfirehose-deliverystream-elasticsearchretryoptions-durationinseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchretryoptions.html#cfn-kinesisfirehose-deliverystream-elasticsearchretryoptions-durationinseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDurationInSeconds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ElasticsearchRetryOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ElasticsearchRetryOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ElasticsearchRetryOptionsProperty> {
            java.lang.Number durationInSeconds;

            /**
             * Sets the value of {@link ElasticsearchRetryOptionsProperty#getDurationInSeconds}
             * @param durationInSeconds After an initial failure to deliver to Amazon ES, the total amount of time during which Kinesis Data Firehose re-attempts delivery (including the first attempt).
             *                          If Kinesis Data Firehose can't deliver the data within the specified time, it writes the data to the backup S3 bucket. For valid values, see the <code>DurationInSeconds</code> content for the <a href="https://docs.aws.amazon.com/firehose/latest/APIReference/API_ElasticsearchRetryOptions.html">ElasticsearchRetryOptions</a> data type in the <em>Amazon Kinesis Data Firehose API Reference</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder durationInSeconds(java.lang.Number durationInSeconds) {
                this.durationInSeconds = durationInSeconds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ElasticsearchRetryOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ElasticsearchRetryOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ElasticsearchRetryOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ElasticsearchRetryOptionsProperty {
            private final java.lang.Number durationInSeconds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.durationInSeconds = software.amazon.jsii.Kernel.get(this, "durationInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.durationInSeconds = builder.durationInSeconds;
            }

            @Override
            public final java.lang.Number getDurationInSeconds() {
                return this.durationInSeconds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDurationInSeconds() != null) {
                    data.set("durationInSeconds", om.valueToTree(this.getDurationInSeconds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.ElasticsearchRetryOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ElasticsearchRetryOptionsProperty.Jsii$Proxy that = (ElasticsearchRetryOptionsProperty.Jsii$Proxy) o;

                return this.durationInSeconds != null ? this.durationInSeconds.equals(that.durationInSeconds) : that.durationInSeconds == null;
            }

            @Override
            public final int hashCode() {
                int result = this.durationInSeconds != null ? this.durationInSeconds.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The <code>EncryptionConfiguration</code> property type specifies the encryption settings that Amazon Kinesis Data Firehose (Kinesis Data Firehose) uses when delivering data to Amazon Simple Storage Service (Amazon S3).
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * EncryptionConfigurationProperty encryptionConfigurationProperty = EncryptionConfigurationProperty.builder()
     *         .kmsEncryptionConfig(KMSEncryptionConfigProperty.builder()
     *                 .awskmsKeyArn("awskmsKeyArn")
     *                 .build())
     *         .noEncryptionConfig("noEncryptionConfig")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-encryptionconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-encryptionconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.EncryptionConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(EncryptionConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EncryptionConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The AWS Key Management Service ( AWS KMS) encryption key that Amazon S3 uses to encrypt your data.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-encryptionconfiguration.html#cfn-kinesisfirehose-deliverystream-encryptionconfiguration-kmsencryptionconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-encryptionconfiguration.html#cfn-kinesisfirehose-deliverystream-encryptionconfiguration-kmsencryptionconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getKmsEncryptionConfig() {
            return null;
        }

        /**
         * Disables encryption.
         * <p>
         * For valid values, see the <code>NoEncryptionConfig</code> content for the <a href="https://docs.aws.amazon.com/firehose/latest/APIReference/API_EncryptionConfiguration.html">EncryptionConfiguration</a> data type in the <em>Amazon Kinesis Data Firehose API Reference</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-encryptionconfiguration.html#cfn-kinesisfirehose-deliverystream-encryptionconfiguration-noencryptionconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-encryptionconfiguration.html#cfn-kinesisfirehose-deliverystream-encryptionconfiguration-noencryptionconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNoEncryptionConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EncryptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EncryptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EncryptionConfigurationProperty> {
            java.lang.Object kmsEncryptionConfig;
            java.lang.String noEncryptionConfig;

            /**
             * Sets the value of {@link EncryptionConfigurationProperty#getKmsEncryptionConfig}
             * @param kmsEncryptionConfig The AWS Key Management Service ( AWS KMS) encryption key that Amazon S3 uses to encrypt your data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsEncryptionConfig(software.amazon.awscdk.IResolvable kmsEncryptionConfig) {
                this.kmsEncryptionConfig = kmsEncryptionConfig;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionConfigurationProperty#getKmsEncryptionConfig}
             * @param kmsEncryptionConfig The AWS Key Management Service ( AWS KMS) encryption key that Amazon S3 uses to encrypt your data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsEncryptionConfig(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.KMSEncryptionConfigProperty kmsEncryptionConfig) {
                this.kmsEncryptionConfig = kmsEncryptionConfig;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionConfigurationProperty#getNoEncryptionConfig}
             * @param noEncryptionConfig Disables encryption.
             *                           For valid values, see the <code>NoEncryptionConfig</code> content for the <a href="https://docs.aws.amazon.com/firehose/latest/APIReference/API_EncryptionConfiguration.html">EncryptionConfiguration</a> data type in the <em>Amazon Kinesis Data Firehose API Reference</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder noEncryptionConfig(java.lang.String noEncryptionConfig) {
                this.noEncryptionConfig = noEncryptionConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EncryptionConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EncryptionConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EncryptionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EncryptionConfigurationProperty {
            private final java.lang.Object kmsEncryptionConfig;
            private final java.lang.String noEncryptionConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.kmsEncryptionConfig = software.amazon.jsii.Kernel.get(this, "kmsEncryptionConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.noEncryptionConfig = software.amazon.jsii.Kernel.get(this, "noEncryptionConfig", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.kmsEncryptionConfig = builder.kmsEncryptionConfig;
                this.noEncryptionConfig = builder.noEncryptionConfig;
            }

            @Override
            public final java.lang.Object getKmsEncryptionConfig() {
                return this.kmsEncryptionConfig;
            }

            @Override
            public final java.lang.String getNoEncryptionConfig() {
                return this.noEncryptionConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getKmsEncryptionConfig() != null) {
                    data.set("kmsEncryptionConfig", om.valueToTree(this.getKmsEncryptionConfig()));
                }
                if (this.getNoEncryptionConfig() != null) {
                    data.set("noEncryptionConfig", om.valueToTree(this.getNoEncryptionConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.EncryptionConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EncryptionConfigurationProperty.Jsii$Proxy that = (EncryptionConfigurationProperty.Jsii$Proxy) o;

                if (this.kmsEncryptionConfig != null ? !this.kmsEncryptionConfig.equals(that.kmsEncryptionConfig) : that.kmsEncryptionConfig != null) return false;
                return this.noEncryptionConfig != null ? this.noEncryptionConfig.equals(that.noEncryptionConfig) : that.noEncryptionConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.kmsEncryptionConfig != null ? this.kmsEncryptionConfig.hashCode() : 0;
                result = 31 * result + (this.noEncryptionConfig != null ? this.noEncryptionConfig.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The <code>ExtendedS3DestinationConfiguration</code> property type configures an Amazon S3 destination for an Amazon Kinesis Data Firehose delivery stream.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * ExtendedS3DestinationConfigurationProperty extendedS3DestinationConfigurationProperty = ExtendedS3DestinationConfigurationProperty.builder()
     *         .bucketArn("bucketArn")
     *         .roleArn("roleArn")
     *         // the properties below are optional
     *         .bufferingHints(BufferingHintsProperty.builder()
     *                 .intervalInSeconds(123)
     *                 .sizeInMBs(123)
     *                 .build())
     *         .cloudWatchLoggingOptions(CloudWatchLoggingOptionsProperty.builder()
     *                 .enabled(false)
     *                 .logGroupName("logGroupName")
     *                 .logStreamName("logStreamName")
     *                 .build())
     *         .compressionFormat("compressionFormat")
     *         .customTimeZone("customTimeZone")
     *         .dataFormatConversionConfiguration(DataFormatConversionConfigurationProperty.builder()
     *                 .enabled(false)
     *                 .inputFormatConfiguration(InputFormatConfigurationProperty.builder()
     *                         .deserializer(DeserializerProperty.builder()
     *                                 .hiveJsonSerDe(HiveJsonSerDeProperty.builder()
     *                                         .timestampFormats(List.of("timestampFormats"))
     *                                         .build())
     *                                 .openXJsonSerDe(OpenXJsonSerDeProperty.builder()
     *                                         .caseInsensitive(false)
     *                                         .columnToJsonKeyMappings(Map.of(
     *                                                 "columnToJsonKeyMappingsKey", "columnToJsonKeyMappings"))
     *                                         .convertDotsInJsonKeysToUnderscores(false)
     *                                         .build())
     *                                 .build())
     *                         .build())
     *                 .outputFormatConfiguration(OutputFormatConfigurationProperty.builder()
     *                         .serializer(SerializerProperty.builder()
     *                                 .orcSerDe(OrcSerDeProperty.builder()
     *                                         .blockSizeBytes(123)
     *                                         .bloomFilterColumns(List.of("bloomFilterColumns"))
     *                                         .bloomFilterFalsePositiveProbability(123)
     *                                         .compression("compression")
     *                                         .dictionaryKeyThreshold(123)
     *                                         .enablePadding(false)
     *                                         .formatVersion("formatVersion")
     *                                         .paddingTolerance(123)
     *                                         .rowIndexStride(123)
     *                                         .stripeSizeBytes(123)
     *                                         .build())
     *                                 .parquetSerDe(ParquetSerDeProperty.builder()
     *                                         .blockSizeBytes(123)
     *                                         .compression("compression")
     *                                         .enableDictionaryCompression(false)
     *                                         .maxPaddingBytes(123)
     *                                         .pageSizeBytes(123)
     *                                         .writerVersion("writerVersion")
     *                                         .build())
     *                                 .build())
     *                         .build())
     *                 .schemaConfiguration(SchemaConfigurationProperty.builder()
     *                         .catalogId("catalogId")
     *                         .databaseName("databaseName")
     *                         .region("region")
     *                         .roleArn("roleArn")
     *                         .tableName("tableName")
     *                         .versionId("versionId")
     *                         .build())
     *                 .build())
     *         .dynamicPartitioningConfiguration(DynamicPartitioningConfigurationProperty.builder()
     *                 .enabled(false)
     *                 .retryOptions(RetryOptionsProperty.builder()
     *                         .durationInSeconds(123)
     *                         .build())
     *                 .build())
     *         .encryptionConfiguration(EncryptionConfigurationProperty.builder()
     *                 .kmsEncryptionConfig(KMSEncryptionConfigProperty.builder()
     *                         .awskmsKeyArn("awskmsKeyArn")
     *                         .build())
     *                 .noEncryptionConfig("noEncryptionConfig")
     *                 .build())
     *         .errorOutputPrefix("errorOutputPrefix")
     *         .fileExtension("fileExtension")
     *         .prefix("prefix")
     *         .processingConfiguration(ProcessingConfigurationProperty.builder()
     *                 .enabled(false)
     *                 .processors(List.of(ProcessorProperty.builder()
     *                         .type("type")
     *                         // the properties below are optional
     *                         .parameters(List.of(ProcessorParameterProperty.builder()
     *                                 .parameterName("parameterName")
     *                                 .parameterValue("parameterValue")
     *                                 .build()))
     *                         .build()))
     *                 .build())
     *         .s3BackupConfiguration(S3DestinationConfigurationProperty.builder()
     *                 .bucketArn("bucketArn")
     *                 .roleArn("roleArn")
     *                 // the properties below are optional
     *                 .bufferingHints(BufferingHintsProperty.builder()
     *                         .intervalInSeconds(123)
     *                         .sizeInMBs(123)
     *                         .build())
     *                 .cloudWatchLoggingOptions(CloudWatchLoggingOptionsProperty.builder()
     *                         .enabled(false)
     *                         .logGroupName("logGroupName")
     *                         .logStreamName("logStreamName")
     *                         .build())
     *                 .compressionFormat("compressionFormat")
     *                 .encryptionConfiguration(EncryptionConfigurationProperty.builder()
     *                         .kmsEncryptionConfig(KMSEncryptionConfigProperty.builder()
     *                                 .awskmsKeyArn("awskmsKeyArn")
     *                                 .build())
     *                         .noEncryptionConfig("noEncryptionConfig")
     *                         .build())
     *                 .errorOutputPrefix("errorOutputPrefix")
     *                 .prefix("prefix")
     *                 .build())
     *         .s3BackupMode("s3BackupMode")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-extendeds3destinationconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-extendeds3destinationconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.ExtendedS3DestinationConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ExtendedS3DestinationConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ExtendedS3DestinationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the Amazon S3 bucket.
         * <p>
         * For constraints, see <a href="https://docs.aws.amazon.com/firehose/latest/APIReference/API_ExtendedS3DestinationConfiguration.html">ExtendedS3DestinationConfiguration</a> in the <em>Amazon Kinesis Data Firehose API Reference</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-extendeds3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-extendeds3destinationconfiguration-bucketarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-extendeds3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-extendeds3destinationconfiguration-bucketarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucketArn();

        /**
         * The Amazon Resource Name (ARN) of the AWS credentials.
         * <p>
         * For constraints, see <a href="https://docs.aws.amazon.com/firehose/latest/APIReference/API_ExtendedS3DestinationConfiguration.html">ExtendedS3DestinationConfiguration</a> in the <em>Amazon Kinesis Data Firehose API Reference</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-extendeds3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-extendeds3destinationconfiguration-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-extendeds3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-extendeds3destinationconfiguration-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * The buffering option.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-extendeds3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-extendeds3destinationconfiguration-bufferinghints">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-extendeds3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-extendeds3destinationconfiguration-bufferinghints</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBufferingHints() {
            return null;
        }

        /**
         * The Amazon CloudWatch logging options for your Firehose stream.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-extendeds3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-extendeds3destinationconfiguration-cloudwatchloggingoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-extendeds3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-extendeds3destinationconfiguration-cloudwatchloggingoptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCloudWatchLoggingOptions() {
            return null;
        }

        /**
         * The compression format.
         * <p>
         * If no value is specified, the default is <code>UNCOMPRESSED</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-extendeds3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-extendeds3destinationconfiguration-compressionformat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-extendeds3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-extendeds3destinationconfiguration-compressionformat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCompressionFormat() {
            return null;
        }

        /**
         * The time zone you prefer.
         * <p>
         * UTC is the default.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-extendeds3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-extendeds3destinationconfiguration-customtimezone">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-extendeds3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-extendeds3destinationconfiguration-customtimezone</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCustomTimeZone() {
            return null;
        }

        /**
         * The serializer, deserializer, and schema for converting data from the JSON format to the Parquet or ORC format before writing it to Amazon S3.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-extendeds3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-extendeds3destinationconfiguration-dataformatconversionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-extendeds3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-extendeds3destinationconfiguration-dataformatconversionconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDataFormatConversionConfiguration() {
            return null;
        }

        /**
         * The configuration of the dynamic partitioning mechanism that creates targeted data sets from the streaming data by partitioning it based on partition keys.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-extendeds3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-extendeds3destinationconfiguration-dynamicpartitioningconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-extendeds3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-extendeds3destinationconfiguration-dynamicpartitioningconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDynamicPartitioningConfiguration() {
            return null;
        }

        /**
         * The encryption configuration for the Kinesis Data Firehose delivery stream.
         * <p>
         * The default value is <code>NoEncryption</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-extendeds3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-extendeds3destinationconfiguration-encryptionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-extendeds3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-extendeds3destinationconfiguration-encryptionconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEncryptionConfiguration() {
            return null;
        }

        /**
         * A prefix that Kinesis Data Firehose evaluates and adds to failed records before writing them to S3.
         * <p>
         * This prefix appears immediately following the bucket name. For information about how to specify this prefix, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">Custom Prefixes for Amazon S3 Objects</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-extendeds3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-extendeds3destinationconfiguration-erroroutputprefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-extendeds3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-extendeds3destinationconfiguration-erroroutputprefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getErrorOutputPrefix() {
            return null;
        }

        /**
         * Specify a file extension.
         * <p>
         * It will override the default file extension
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-extendeds3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-extendeds3destinationconfiguration-fileextension">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-extendeds3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-extendeds3destinationconfiguration-fileextension</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFileExtension() {
            return null;
        }

        /**
         * The <code>YYYY/MM/DD/HH</code> time format prefix is automatically used for delivered Amazon S3 files.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/firehose/latest/APIReference/API_ExtendedS3DestinationConfiguration.html">ExtendedS3DestinationConfiguration</a> in the <em>Amazon Kinesis Data Firehose API Reference</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-extendeds3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-extendeds3destinationconfiguration-prefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-extendeds3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-extendeds3destinationconfiguration-prefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPrefix() {
            return null;
        }

        /**
         * The data processing configuration for the Kinesis Data Firehose delivery stream.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-extendeds3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-extendeds3destinationconfiguration-processingconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-extendeds3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-extendeds3destinationconfiguration-processingconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getProcessingConfiguration() {
            return null;
        }

        /**
         * The configuration for backup in Amazon S3.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-extendeds3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-extendeds3destinationconfiguration-s3backupconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-extendeds3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-extendeds3destinationconfiguration-s3backupconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3BackupConfiguration() {
            return null;
        }

        /**
         * The Amazon S3 backup mode.
         * <p>
         * After you create a Firehose stream, you can update it to enable Amazon S3 backup if it is disabled. If backup is enabled, you can't update the Firehose stream to disable it.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-extendeds3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-extendeds3destinationconfiguration-s3backupmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-extendeds3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-extendeds3destinationconfiguration-s3backupmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3BackupMode() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ExtendedS3DestinationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ExtendedS3DestinationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ExtendedS3DestinationConfigurationProperty> {
            java.lang.String bucketArn;
            java.lang.String roleArn;
            java.lang.Object bufferingHints;
            java.lang.Object cloudWatchLoggingOptions;
            java.lang.String compressionFormat;
            java.lang.String customTimeZone;
            java.lang.Object dataFormatConversionConfiguration;
            java.lang.Object dynamicPartitioningConfiguration;
            java.lang.Object encryptionConfiguration;
            java.lang.String errorOutputPrefix;
            java.lang.String fileExtension;
            java.lang.String prefix;
            java.lang.Object processingConfiguration;
            java.lang.Object s3BackupConfiguration;
            java.lang.String s3BackupMode;

            /**
             * Sets the value of {@link ExtendedS3DestinationConfigurationProperty#getBucketArn}
             * @param bucketArn The Amazon Resource Name (ARN) of the Amazon S3 bucket. This parameter is required.
             *                  For constraints, see <a href="https://docs.aws.amazon.com/firehose/latest/APIReference/API_ExtendedS3DestinationConfiguration.html">ExtendedS3DestinationConfiguration</a> in the <em>Amazon Kinesis Data Firehose API Reference</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketArn(java.lang.String bucketArn) {
                this.bucketArn = bucketArn;
                return this;
            }

            /**
             * Sets the value of {@link ExtendedS3DestinationConfigurationProperty#getRoleArn}
             * @param roleArn The Amazon Resource Name (ARN) of the AWS credentials. This parameter is required.
             *                For constraints, see <a href="https://docs.aws.amazon.com/firehose/latest/APIReference/API_ExtendedS3DestinationConfiguration.html">ExtendedS3DestinationConfiguration</a> in the <em>Amazon Kinesis Data Firehose API Reference</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link ExtendedS3DestinationConfigurationProperty#getBufferingHints}
             * @param bufferingHints The buffering option.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bufferingHints(software.amazon.awscdk.IResolvable bufferingHints) {
                this.bufferingHints = bufferingHints;
                return this;
            }

            /**
             * Sets the value of {@link ExtendedS3DestinationConfigurationProperty#getBufferingHints}
             * @param bufferingHints The buffering option.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bufferingHints(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.BufferingHintsProperty bufferingHints) {
                this.bufferingHints = bufferingHints;
                return this;
            }

            /**
             * Sets the value of {@link ExtendedS3DestinationConfigurationProperty#getCloudWatchLoggingOptions}
             * @param cloudWatchLoggingOptions The Amazon CloudWatch logging options for your Firehose stream.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchLoggingOptions(software.amazon.awscdk.IResolvable cloudWatchLoggingOptions) {
                this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
                return this;
            }

            /**
             * Sets the value of {@link ExtendedS3DestinationConfigurationProperty#getCloudWatchLoggingOptions}
             * @param cloudWatchLoggingOptions The Amazon CloudWatch logging options for your Firehose stream.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchLoggingOptions(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.CloudWatchLoggingOptionsProperty cloudWatchLoggingOptions) {
                this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
                return this;
            }

            /**
             * Sets the value of {@link ExtendedS3DestinationConfigurationProperty#getCompressionFormat}
             * @param compressionFormat The compression format.
             *                          If no value is specified, the default is <code>UNCOMPRESSED</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder compressionFormat(java.lang.String compressionFormat) {
                this.compressionFormat = compressionFormat;
                return this;
            }

            /**
             * Sets the value of {@link ExtendedS3DestinationConfigurationProperty#getCustomTimeZone}
             * @param customTimeZone The time zone you prefer.
             *                       UTC is the default.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customTimeZone(java.lang.String customTimeZone) {
                this.customTimeZone = customTimeZone;
                return this;
            }

            /**
             * Sets the value of {@link ExtendedS3DestinationConfigurationProperty#getDataFormatConversionConfiguration}
             * @param dataFormatConversionConfiguration The serializer, deserializer, and schema for converting data from the JSON format to the Parquet or ORC format before writing it to Amazon S3.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataFormatConversionConfiguration(software.amazon.awscdk.IResolvable dataFormatConversionConfiguration) {
                this.dataFormatConversionConfiguration = dataFormatConversionConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ExtendedS3DestinationConfigurationProperty#getDataFormatConversionConfiguration}
             * @param dataFormatConversionConfiguration The serializer, deserializer, and schema for converting data from the JSON format to the Parquet or ORC format before writing it to Amazon S3.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataFormatConversionConfiguration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.DataFormatConversionConfigurationProperty dataFormatConversionConfiguration) {
                this.dataFormatConversionConfiguration = dataFormatConversionConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ExtendedS3DestinationConfigurationProperty#getDynamicPartitioningConfiguration}
             * @param dynamicPartitioningConfiguration The configuration of the dynamic partitioning mechanism that creates targeted data sets from the streaming data by partitioning it based on partition keys.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dynamicPartitioningConfiguration(software.amazon.awscdk.IResolvable dynamicPartitioningConfiguration) {
                this.dynamicPartitioningConfiguration = dynamicPartitioningConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ExtendedS3DestinationConfigurationProperty#getDynamicPartitioningConfiguration}
             * @param dynamicPartitioningConfiguration The configuration of the dynamic partitioning mechanism that creates targeted data sets from the streaming data by partitioning it based on partition keys.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dynamicPartitioningConfiguration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.DynamicPartitioningConfigurationProperty dynamicPartitioningConfiguration) {
                this.dynamicPartitioningConfiguration = dynamicPartitioningConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ExtendedS3DestinationConfigurationProperty#getEncryptionConfiguration}
             * @param encryptionConfiguration The encryption configuration for the Kinesis Data Firehose delivery stream.
             *                                The default value is <code>NoEncryption</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionConfiguration(software.amazon.awscdk.IResolvable encryptionConfiguration) {
                this.encryptionConfiguration = encryptionConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ExtendedS3DestinationConfigurationProperty#getEncryptionConfiguration}
             * @param encryptionConfiguration The encryption configuration for the Kinesis Data Firehose delivery stream.
             *                                The default value is <code>NoEncryption</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionConfiguration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.EncryptionConfigurationProperty encryptionConfiguration) {
                this.encryptionConfiguration = encryptionConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ExtendedS3DestinationConfigurationProperty#getErrorOutputPrefix}
             * @param errorOutputPrefix A prefix that Kinesis Data Firehose evaluates and adds to failed records before writing them to S3.
             *                          This prefix appears immediately following the bucket name. For information about how to specify this prefix, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">Custom Prefixes for Amazon S3 Objects</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder errorOutputPrefix(java.lang.String errorOutputPrefix) {
                this.errorOutputPrefix = errorOutputPrefix;
                return this;
            }

            /**
             * Sets the value of {@link ExtendedS3DestinationConfigurationProperty#getFileExtension}
             * @param fileExtension Specify a file extension.
             *                      It will override the default file extension
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fileExtension(java.lang.String fileExtension) {
                this.fileExtension = fileExtension;
                return this;
            }

            /**
             * Sets the value of {@link ExtendedS3DestinationConfigurationProperty#getPrefix}
             * @param prefix The <code>YYYY/MM/DD/HH</code> time format prefix is automatically used for delivered Amazon S3 files.
             *               For more information, see <a href="https://docs.aws.amazon.com/firehose/latest/APIReference/API_ExtendedS3DestinationConfiguration.html">ExtendedS3DestinationConfiguration</a> in the <em>Amazon Kinesis Data Firehose API Reference</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prefix(java.lang.String prefix) {
                this.prefix = prefix;
                return this;
            }

            /**
             * Sets the value of {@link ExtendedS3DestinationConfigurationProperty#getProcessingConfiguration}
             * @param processingConfiguration The data processing configuration for the Kinesis Data Firehose delivery stream.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder processingConfiguration(software.amazon.awscdk.IResolvable processingConfiguration) {
                this.processingConfiguration = processingConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ExtendedS3DestinationConfigurationProperty#getProcessingConfiguration}
             * @param processingConfiguration The data processing configuration for the Kinesis Data Firehose delivery stream.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder processingConfiguration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.ProcessingConfigurationProperty processingConfiguration) {
                this.processingConfiguration = processingConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ExtendedS3DestinationConfigurationProperty#getS3BackupConfiguration}
             * @param s3BackupConfiguration The configuration for backup in Amazon S3.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3BackupConfiguration(software.amazon.awscdk.IResolvable s3BackupConfiguration) {
                this.s3BackupConfiguration = s3BackupConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ExtendedS3DestinationConfigurationProperty#getS3BackupConfiguration}
             * @param s3BackupConfiguration The configuration for backup in Amazon S3.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3BackupConfiguration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.S3DestinationConfigurationProperty s3BackupConfiguration) {
                this.s3BackupConfiguration = s3BackupConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ExtendedS3DestinationConfigurationProperty#getS3BackupMode}
             * @param s3BackupMode The Amazon S3 backup mode.
             *                     After you create a Firehose stream, you can update it to enable Amazon S3 backup if it is disabled. If backup is enabled, you can't update the Firehose stream to disable it.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3BackupMode(java.lang.String s3BackupMode) {
                this.s3BackupMode = s3BackupMode;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ExtendedS3DestinationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ExtendedS3DestinationConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ExtendedS3DestinationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ExtendedS3DestinationConfigurationProperty {
            private final java.lang.String bucketArn;
            private final java.lang.String roleArn;
            private final java.lang.Object bufferingHints;
            private final java.lang.Object cloudWatchLoggingOptions;
            private final java.lang.String compressionFormat;
            private final java.lang.String customTimeZone;
            private final java.lang.Object dataFormatConversionConfiguration;
            private final java.lang.Object dynamicPartitioningConfiguration;
            private final java.lang.Object encryptionConfiguration;
            private final java.lang.String errorOutputPrefix;
            private final java.lang.String fileExtension;
            private final java.lang.String prefix;
            private final java.lang.Object processingConfiguration;
            private final java.lang.Object s3BackupConfiguration;
            private final java.lang.String s3BackupMode;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucketArn = software.amazon.jsii.Kernel.get(this, "bucketArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.bufferingHints = software.amazon.jsii.Kernel.get(this, "bufferingHints", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.cloudWatchLoggingOptions = software.amazon.jsii.Kernel.get(this, "cloudWatchLoggingOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.compressionFormat = software.amazon.jsii.Kernel.get(this, "compressionFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.customTimeZone = software.amazon.jsii.Kernel.get(this, "customTimeZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dataFormatConversionConfiguration = software.amazon.jsii.Kernel.get(this, "dataFormatConversionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dynamicPartitioningConfiguration = software.amazon.jsii.Kernel.get(this, "dynamicPartitioningConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.encryptionConfiguration = software.amazon.jsii.Kernel.get(this, "encryptionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.errorOutputPrefix = software.amazon.jsii.Kernel.get(this, "errorOutputPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.fileExtension = software.amazon.jsii.Kernel.get(this, "fileExtension", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.prefix = software.amazon.jsii.Kernel.get(this, "prefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.processingConfiguration = software.amazon.jsii.Kernel.get(this, "processingConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.s3BackupConfiguration = software.amazon.jsii.Kernel.get(this, "s3BackupConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.s3BackupMode = software.amazon.jsii.Kernel.get(this, "s3BackupMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucketArn = java.util.Objects.requireNonNull(builder.bucketArn, "bucketArn is required");
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
                this.bufferingHints = builder.bufferingHints;
                this.cloudWatchLoggingOptions = builder.cloudWatchLoggingOptions;
                this.compressionFormat = builder.compressionFormat;
                this.customTimeZone = builder.customTimeZone;
                this.dataFormatConversionConfiguration = builder.dataFormatConversionConfiguration;
                this.dynamicPartitioningConfiguration = builder.dynamicPartitioningConfiguration;
                this.encryptionConfiguration = builder.encryptionConfiguration;
                this.errorOutputPrefix = builder.errorOutputPrefix;
                this.fileExtension = builder.fileExtension;
                this.prefix = builder.prefix;
                this.processingConfiguration = builder.processingConfiguration;
                this.s3BackupConfiguration = builder.s3BackupConfiguration;
                this.s3BackupMode = builder.s3BackupMode;
            }

            @Override
            public final java.lang.String getBucketArn() {
                return this.bucketArn;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.Object getBufferingHints() {
                return this.bufferingHints;
            }

            @Override
            public final java.lang.Object getCloudWatchLoggingOptions() {
                return this.cloudWatchLoggingOptions;
            }

            @Override
            public final java.lang.String getCompressionFormat() {
                return this.compressionFormat;
            }

            @Override
            public final java.lang.String getCustomTimeZone() {
                return this.customTimeZone;
            }

            @Override
            public final java.lang.Object getDataFormatConversionConfiguration() {
                return this.dataFormatConversionConfiguration;
            }

            @Override
            public final java.lang.Object getDynamicPartitioningConfiguration() {
                return this.dynamicPartitioningConfiguration;
            }

            @Override
            public final java.lang.Object getEncryptionConfiguration() {
                return this.encryptionConfiguration;
            }

            @Override
            public final java.lang.String getErrorOutputPrefix() {
                return this.errorOutputPrefix;
            }

            @Override
            public final java.lang.String getFileExtension() {
                return this.fileExtension;
            }

            @Override
            public final java.lang.String getPrefix() {
                return this.prefix;
            }

            @Override
            public final java.lang.Object getProcessingConfiguration() {
                return this.processingConfiguration;
            }

            @Override
            public final java.lang.Object getS3BackupConfiguration() {
                return this.s3BackupConfiguration;
            }

            @Override
            public final java.lang.String getS3BackupMode() {
                return this.s3BackupMode;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucketArn", om.valueToTree(this.getBucketArn()));
                data.set("roleArn", om.valueToTree(this.getRoleArn()));
                if (this.getBufferingHints() != null) {
                    data.set("bufferingHints", om.valueToTree(this.getBufferingHints()));
                }
                if (this.getCloudWatchLoggingOptions() != null) {
                    data.set("cloudWatchLoggingOptions", om.valueToTree(this.getCloudWatchLoggingOptions()));
                }
                if (this.getCompressionFormat() != null) {
                    data.set("compressionFormat", om.valueToTree(this.getCompressionFormat()));
                }
                if (this.getCustomTimeZone() != null) {
                    data.set("customTimeZone", om.valueToTree(this.getCustomTimeZone()));
                }
                if (this.getDataFormatConversionConfiguration() != null) {
                    data.set("dataFormatConversionConfiguration", om.valueToTree(this.getDataFormatConversionConfiguration()));
                }
                if (this.getDynamicPartitioningConfiguration() != null) {
                    data.set("dynamicPartitioningConfiguration", om.valueToTree(this.getDynamicPartitioningConfiguration()));
                }
                if (this.getEncryptionConfiguration() != null) {
                    data.set("encryptionConfiguration", om.valueToTree(this.getEncryptionConfiguration()));
                }
                if (this.getErrorOutputPrefix() != null) {
                    data.set("errorOutputPrefix", om.valueToTree(this.getErrorOutputPrefix()));
                }
                if (this.getFileExtension() != null) {
                    data.set("fileExtension", om.valueToTree(this.getFileExtension()));
                }
                if (this.getPrefix() != null) {
                    data.set("prefix", om.valueToTree(this.getPrefix()));
                }
                if (this.getProcessingConfiguration() != null) {
                    data.set("processingConfiguration", om.valueToTree(this.getProcessingConfiguration()));
                }
                if (this.getS3BackupConfiguration() != null) {
                    data.set("s3BackupConfiguration", om.valueToTree(this.getS3BackupConfiguration()));
                }
                if (this.getS3BackupMode() != null) {
                    data.set("s3BackupMode", om.valueToTree(this.getS3BackupMode()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.ExtendedS3DestinationConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ExtendedS3DestinationConfigurationProperty.Jsii$Proxy that = (ExtendedS3DestinationConfigurationProperty.Jsii$Proxy) o;

                if (!bucketArn.equals(that.bucketArn)) return false;
                if (!roleArn.equals(that.roleArn)) return false;
                if (this.bufferingHints != null ? !this.bufferingHints.equals(that.bufferingHints) : that.bufferingHints != null) return false;
                if (this.cloudWatchLoggingOptions != null ? !this.cloudWatchLoggingOptions.equals(that.cloudWatchLoggingOptions) : that.cloudWatchLoggingOptions != null) return false;
                if (this.compressionFormat != null ? !this.compressionFormat.equals(that.compressionFormat) : that.compressionFormat != null) return false;
                if (this.customTimeZone != null ? !this.customTimeZone.equals(that.customTimeZone) : that.customTimeZone != null) return false;
                if (this.dataFormatConversionConfiguration != null ? !this.dataFormatConversionConfiguration.equals(that.dataFormatConversionConfiguration) : that.dataFormatConversionConfiguration != null) return false;
                if (this.dynamicPartitioningConfiguration != null ? !this.dynamicPartitioningConfiguration.equals(that.dynamicPartitioningConfiguration) : that.dynamicPartitioningConfiguration != null) return false;
                if (this.encryptionConfiguration != null ? !this.encryptionConfiguration.equals(that.encryptionConfiguration) : that.encryptionConfiguration != null) return false;
                if (this.errorOutputPrefix != null ? !this.errorOutputPrefix.equals(that.errorOutputPrefix) : that.errorOutputPrefix != null) return false;
                if (this.fileExtension != null ? !this.fileExtension.equals(that.fileExtension) : that.fileExtension != null) return false;
                if (this.prefix != null ? !this.prefix.equals(that.prefix) : that.prefix != null) return false;
                if (this.processingConfiguration != null ? !this.processingConfiguration.equals(that.processingConfiguration) : that.processingConfiguration != null) return false;
                if (this.s3BackupConfiguration != null ? !this.s3BackupConfiguration.equals(that.s3BackupConfiguration) : that.s3BackupConfiguration != null) return false;
                return this.s3BackupMode != null ? this.s3BackupMode.equals(that.s3BackupMode) : that.s3BackupMode == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bucketArn.hashCode();
                result = 31 * result + (this.roleArn.hashCode());
                result = 31 * result + (this.bufferingHints != null ? this.bufferingHints.hashCode() : 0);
                result = 31 * result + (this.cloudWatchLoggingOptions != null ? this.cloudWatchLoggingOptions.hashCode() : 0);
                result = 31 * result + (this.compressionFormat != null ? this.compressionFormat.hashCode() : 0);
                result = 31 * result + (this.customTimeZone != null ? this.customTimeZone.hashCode() : 0);
                result = 31 * result + (this.dataFormatConversionConfiguration != null ? this.dataFormatConversionConfiguration.hashCode() : 0);
                result = 31 * result + (this.dynamicPartitioningConfiguration != null ? this.dynamicPartitioningConfiguration.hashCode() : 0);
                result = 31 * result + (this.encryptionConfiguration != null ? this.encryptionConfiguration.hashCode() : 0);
                result = 31 * result + (this.errorOutputPrefix != null ? this.errorOutputPrefix.hashCode() : 0);
                result = 31 * result + (this.fileExtension != null ? this.fileExtension.hashCode() : 0);
                result = 31 * result + (this.prefix != null ? this.prefix.hashCode() : 0);
                result = 31 * result + (this.processingConfiguration != null ? this.processingConfiguration.hashCode() : 0);
                result = 31 * result + (this.s3BackupConfiguration != null ? this.s3BackupConfiguration.hashCode() : 0);
                result = 31 * result + (this.s3BackupMode != null ? this.s3BackupMode.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The native Hive / HCatalog JsonSerDe.
     * <p>
     * Used by Firehose for deserializing data, which means converting it from the JSON format in preparation for serializing it to the Parquet or ORC format. This is one of two deserializers you can choose, depending on which one offers the functionality you need. The other option is the OpenX SerDe.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * HiveJsonSerDeProperty hiveJsonSerDeProperty = HiveJsonSerDeProperty.builder()
     *         .timestampFormats(List.of("timestampFormats"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-hivejsonserde.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-hivejsonserde.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.HiveJsonSerDeProperty")
    @software.amazon.jsii.Jsii.Proxy(HiveJsonSerDeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HiveJsonSerDeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates how you want Firehose to parse the date and timestamps that may be present in your input data JSON.
         * <p>
         * To specify these format strings, follow the pattern syntax of JodaTime's DateTimeFormat format strings. For more information, see <a href="https://docs.aws.amazon.com/https://www.joda.org/joda-time/apidocs/org/joda/time/format/DateTimeFormat.html">Class DateTimeFormat</a> . You can also use the special value <code>millis</code> to parse timestamps in epoch milliseconds. If you don't specify a format, Firehose uses <code>java.sql.Timestamp::valueOf</code> by default.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-hivejsonserde.html#cfn-kinesisfirehose-deliverystream-hivejsonserde-timestampformats">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-hivejsonserde.html#cfn-kinesisfirehose-deliverystream-hivejsonserde-timestampformats</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getTimestampFormats() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HiveJsonSerDeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HiveJsonSerDeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HiveJsonSerDeProperty> {
            java.util.List<java.lang.String> timestampFormats;

            /**
             * Sets the value of {@link HiveJsonSerDeProperty#getTimestampFormats}
             * @param timestampFormats Indicates how you want Firehose to parse the date and timestamps that may be present in your input data JSON.
             *                         To specify these format strings, follow the pattern syntax of JodaTime's DateTimeFormat format strings. For more information, see <a href="https://docs.aws.amazon.com/https://www.joda.org/joda-time/apidocs/org/joda/time/format/DateTimeFormat.html">Class DateTimeFormat</a> . You can also use the special value <code>millis</code> to parse timestamps in epoch milliseconds. If you don't specify a format, Firehose uses <code>java.sql.Timestamp::valueOf</code> by default.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timestampFormats(java.util.List<java.lang.String> timestampFormats) {
                this.timestampFormats = timestampFormats;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HiveJsonSerDeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HiveJsonSerDeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HiveJsonSerDeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HiveJsonSerDeProperty {
            private final java.util.List<java.lang.String> timestampFormats;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.timestampFormats = software.amazon.jsii.Kernel.get(this, "timestampFormats", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.timestampFormats = builder.timestampFormats;
            }

            @Override
            public final java.util.List<java.lang.String> getTimestampFormats() {
                return this.timestampFormats;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getTimestampFormats() != null) {
                    data.set("timestampFormats", om.valueToTree(this.getTimestampFormats()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.HiveJsonSerDeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HiveJsonSerDeProperty.Jsii$Proxy that = (HiveJsonSerDeProperty.Jsii$Proxy) o;

                return this.timestampFormats != null ? this.timestampFormats.equals(that.timestampFormats) : that.timestampFormats == null;
            }

            @Override
            public final int hashCode() {
                int result = this.timestampFormats != null ? this.timestampFormats.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Describes the metadata that's delivered to the specified HTTP endpoint destination.
     * <p>
     * Kinesis Firehose supports any custom HTTP endpoint or HTTP endpoints owned by supported third-party service providers, including Datadog, MongoDB, and New Relic.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * HttpEndpointCommonAttributeProperty httpEndpointCommonAttributeProperty = HttpEndpointCommonAttributeProperty.builder()
     *         .attributeName("attributeName")
     *         .attributeValue("attributeValue")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointcommonattribute.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointcommonattribute.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.HttpEndpointCommonAttributeProperty")
    @software.amazon.jsii.Jsii.Proxy(HttpEndpointCommonAttributeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HttpEndpointCommonAttributeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the HTTP endpoint common attribute.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointcommonattribute.html#cfn-kinesisfirehose-deliverystream-httpendpointcommonattribute-attributename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointcommonattribute.html#cfn-kinesisfirehose-deliverystream-httpendpointcommonattribute-attributename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAttributeName();

        /**
         * The value of the HTTP endpoint common attribute.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointcommonattribute.html#cfn-kinesisfirehose-deliverystream-httpendpointcommonattribute-attributevalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointcommonattribute.html#cfn-kinesisfirehose-deliverystream-httpendpointcommonattribute-attributevalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAttributeValue();

        /**
         * @return a {@link Builder} of {@link HttpEndpointCommonAttributeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HttpEndpointCommonAttributeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HttpEndpointCommonAttributeProperty> {
            java.lang.String attributeName;
            java.lang.String attributeValue;

            /**
             * Sets the value of {@link HttpEndpointCommonAttributeProperty#getAttributeName}
             * @param attributeName The name of the HTTP endpoint common attribute. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attributeName(java.lang.String attributeName) {
                this.attributeName = attributeName;
                return this;
            }

            /**
             * Sets the value of {@link HttpEndpointCommonAttributeProperty#getAttributeValue}
             * @param attributeValue The value of the HTTP endpoint common attribute. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attributeValue(java.lang.String attributeValue) {
                this.attributeValue = attributeValue;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HttpEndpointCommonAttributeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HttpEndpointCommonAttributeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HttpEndpointCommonAttributeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HttpEndpointCommonAttributeProperty {
            private final java.lang.String attributeName;
            private final java.lang.String attributeValue;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.attributeName = software.amazon.jsii.Kernel.get(this, "attributeName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.attributeValue = software.amazon.jsii.Kernel.get(this, "attributeValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.attributeName = java.util.Objects.requireNonNull(builder.attributeName, "attributeName is required");
                this.attributeValue = java.util.Objects.requireNonNull(builder.attributeValue, "attributeValue is required");
            }

            @Override
            public final java.lang.String getAttributeName() {
                return this.attributeName;
            }

            @Override
            public final java.lang.String getAttributeValue() {
                return this.attributeValue;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("attributeName", om.valueToTree(this.getAttributeName()));
                data.set("attributeValue", om.valueToTree(this.getAttributeValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.HttpEndpointCommonAttributeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HttpEndpointCommonAttributeProperty.Jsii$Proxy that = (HttpEndpointCommonAttributeProperty.Jsii$Proxy) o;

                if (!attributeName.equals(that.attributeName)) return false;
                return this.attributeValue.equals(that.attributeValue);
            }

            @Override
            public final int hashCode() {
                int result = this.attributeName.hashCode();
                result = 31 * result + (this.attributeValue.hashCode());
                return result;
            }
        }
    }
    /**
     * Describes the configuration of the HTTP endpoint to which Kinesis Firehose delivers data.
     * <p>
     * Kinesis Firehose supports any custom HTTP endpoint or HTTP endpoints owned by supported third-party service providers, including Datadog, MongoDB, and New Relic.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * HttpEndpointConfigurationProperty httpEndpointConfigurationProperty = HttpEndpointConfigurationProperty.builder()
     *         .url("url")
     *         // the properties below are optional
     *         .accessKey("accessKey")
     *         .name("name")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.HttpEndpointConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(HttpEndpointConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HttpEndpointConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The URL of the HTTP endpoint selected as the destination.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointconfiguration.html#cfn-kinesisfirehose-deliverystream-httpendpointconfiguration-url">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointconfiguration.html#cfn-kinesisfirehose-deliverystream-httpendpointconfiguration-url</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getUrl();

        /**
         * The access key required for Kinesis Firehose to authenticate with the HTTP endpoint selected as the destination.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointconfiguration.html#cfn-kinesisfirehose-deliverystream-httpendpointconfiguration-accesskey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointconfiguration.html#cfn-kinesisfirehose-deliverystream-httpendpointconfiguration-accesskey</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAccessKey() {
            return null;
        }

        /**
         * The name of the HTTP endpoint selected as the destination.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointconfiguration.html#cfn-kinesisfirehose-deliverystream-httpendpointconfiguration-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointconfiguration.html#cfn-kinesisfirehose-deliverystream-httpendpointconfiguration-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HttpEndpointConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HttpEndpointConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HttpEndpointConfigurationProperty> {
            java.lang.String url;
            java.lang.String accessKey;
            java.lang.String name;

            /**
             * Sets the value of {@link HttpEndpointConfigurationProperty#getUrl}
             * @param url The URL of the HTTP endpoint selected as the destination. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder url(java.lang.String url) {
                this.url = url;
                return this;
            }

            /**
             * Sets the value of {@link HttpEndpointConfigurationProperty#getAccessKey}
             * @param accessKey The access key required for Kinesis Firehose to authenticate with the HTTP endpoint selected as the destination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessKey(java.lang.String accessKey) {
                this.accessKey = accessKey;
                return this;
            }

            /**
             * Sets the value of {@link HttpEndpointConfigurationProperty#getName}
             * @param name The name of the HTTP endpoint selected as the destination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HttpEndpointConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HttpEndpointConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HttpEndpointConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HttpEndpointConfigurationProperty {
            private final java.lang.String url;
            private final java.lang.String accessKey;
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.url = software.amazon.jsii.Kernel.get(this, "url", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.accessKey = software.amazon.jsii.Kernel.get(this, "accessKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.url = java.util.Objects.requireNonNull(builder.url, "url is required");
                this.accessKey = builder.accessKey;
                this.name = builder.name;
            }

            @Override
            public final java.lang.String getUrl() {
                return this.url;
            }

            @Override
            public final java.lang.String getAccessKey() {
                return this.accessKey;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("url", om.valueToTree(this.getUrl()));
                if (this.getAccessKey() != null) {
                    data.set("accessKey", om.valueToTree(this.getAccessKey()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.HttpEndpointConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HttpEndpointConfigurationProperty.Jsii$Proxy that = (HttpEndpointConfigurationProperty.Jsii$Proxy) o;

                if (!url.equals(that.url)) return false;
                if (this.accessKey != null ? !this.accessKey.equals(that.accessKey) : that.accessKey != null) return false;
                return this.name != null ? this.name.equals(that.name) : that.name == null;
            }

            @Override
            public final int hashCode() {
                int result = this.url.hashCode();
                result = 31 * result + (this.accessKey != null ? this.accessKey.hashCode() : 0);
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes the configuration of the HTTP endpoint destination.
     * <p>
     * Kinesis Firehose supports any custom HTTP endpoint or HTTP endpoints owned by supported third-party service providers, including Datadog, MongoDB, and New Relic.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * HttpEndpointDestinationConfigurationProperty httpEndpointDestinationConfigurationProperty = HttpEndpointDestinationConfigurationProperty.builder()
     *         .endpointConfiguration(HttpEndpointConfigurationProperty.builder()
     *                 .url("url")
     *                 // the properties below are optional
     *                 .accessKey("accessKey")
     *                 .name("name")
     *                 .build())
     *         .s3Configuration(S3DestinationConfigurationProperty.builder()
     *                 .bucketArn("bucketArn")
     *                 .roleArn("roleArn")
     *                 // the properties below are optional
     *                 .bufferingHints(BufferingHintsProperty.builder()
     *                         .intervalInSeconds(123)
     *                         .sizeInMBs(123)
     *                         .build())
     *                 .cloudWatchLoggingOptions(CloudWatchLoggingOptionsProperty.builder()
     *                         .enabled(false)
     *                         .logGroupName("logGroupName")
     *                         .logStreamName("logStreamName")
     *                         .build())
     *                 .compressionFormat("compressionFormat")
     *                 .encryptionConfiguration(EncryptionConfigurationProperty.builder()
     *                         .kmsEncryptionConfig(KMSEncryptionConfigProperty.builder()
     *                                 .awskmsKeyArn("awskmsKeyArn")
     *                                 .build())
     *                         .noEncryptionConfig("noEncryptionConfig")
     *                         .build())
     *                 .errorOutputPrefix("errorOutputPrefix")
     *                 .prefix("prefix")
     *                 .build())
     *         // the properties below are optional
     *         .bufferingHints(BufferingHintsProperty.builder()
     *                 .intervalInSeconds(123)
     *                 .sizeInMBs(123)
     *                 .build())
     *         .cloudWatchLoggingOptions(CloudWatchLoggingOptionsProperty.builder()
     *                 .enabled(false)
     *                 .logGroupName("logGroupName")
     *                 .logStreamName("logStreamName")
     *                 .build())
     *         .processingConfiguration(ProcessingConfigurationProperty.builder()
     *                 .enabled(false)
     *                 .processors(List.of(ProcessorProperty.builder()
     *                         .type("type")
     *                         // the properties below are optional
     *                         .parameters(List.of(ProcessorParameterProperty.builder()
     *                                 .parameterName("parameterName")
     *                                 .parameterValue("parameterValue")
     *                                 .build()))
     *                         .build()))
     *                 .build())
     *         .requestConfiguration(HttpEndpointRequestConfigurationProperty.builder()
     *                 .commonAttributes(List.of(HttpEndpointCommonAttributeProperty.builder()
     *                         .attributeName("attributeName")
     *                         .attributeValue("attributeValue")
     *                         .build()))
     *                 .contentEncoding("contentEncoding")
     *                 .build())
     *         .retryOptions(RetryOptionsProperty.builder()
     *                 .durationInSeconds(123)
     *                 .build())
     *         .roleArn("roleArn")
     *         .s3BackupMode("s3BackupMode")
     *         .secretsManagerConfiguration(SecretsManagerConfigurationProperty.builder()
     *                 .enabled(false)
     *                 // the properties below are optional
     *                 .roleArn("roleArn")
     *                 .secretArn("secretArn")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.HttpEndpointDestinationConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(HttpEndpointDestinationConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HttpEndpointDestinationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The configuration of the HTTP endpoint selected as the destination.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration-endpointconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration-endpointconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEndpointConfiguration();

        /**
         * Describes the configuration of a destination in Amazon S3.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration-s3configuration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration-s3configuration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getS3Configuration();

        /**
         * The buffering options that can be used before data is delivered to the specified destination.
         * <p>
         * Kinesis Data Firehose treats these options as hints, and it might choose to use more optimal values. The SizeInMBs and IntervalInSeconds parameters are optional. However, if you specify a value for one of them, you must also provide a value for the other.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration-bufferinghints">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration-bufferinghints</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBufferingHints() {
            return null;
        }

        /**
         * Describes the Amazon CloudWatch logging options for your delivery stream.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration-cloudwatchloggingoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration-cloudwatchloggingoptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCloudWatchLoggingOptions() {
            return null;
        }

        /**
         * Describes the data processing configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration-processingconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration-processingconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getProcessingConfiguration() {
            return null;
        }

        /**
         * The configuration of the request sent to the HTTP endpoint specified as the destination.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration-requestconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration-requestconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRequestConfiguration() {
            return null;
        }

        /**
         * Describes the retry behavior in case Kinesis Data Firehose is unable to deliver data to the specified HTTP endpoint destination, or if it doesn't receive a valid acknowledgment of receipt from the specified HTTP endpoint destination.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration-retryoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration-retryoptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRetryOptions() {
            return null;
        }

        /**
         * Kinesis Data Firehose uses this IAM role for all the permissions that the delivery stream needs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRoleArn() {
            return null;
        }

        /**
         * Describes the S3 bucket backup options for the data that Kinesis Data Firehose delivers to the HTTP endpoint destination.
         * <p>
         * You can back up all documents (AllData) or only the documents that Kinesis Data Firehose could not deliver to the specified HTTP endpoint destination (FailedDataOnly).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration-s3backupmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration-s3backupmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3BackupMode() {
            return null;
        }

        /**
         * The configuration that defines how you access secrets for HTTP Endpoint destination.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration-secretsmanagerconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration-secretsmanagerconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSecretsManagerConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HttpEndpointDestinationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HttpEndpointDestinationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HttpEndpointDestinationConfigurationProperty> {
            java.lang.Object endpointConfiguration;
            java.lang.Object s3Configuration;
            java.lang.Object bufferingHints;
            java.lang.Object cloudWatchLoggingOptions;
            java.lang.Object processingConfiguration;
            java.lang.Object requestConfiguration;
            java.lang.Object retryOptions;
            java.lang.String roleArn;
            java.lang.String s3BackupMode;
            java.lang.Object secretsManagerConfiguration;

            /**
             * Sets the value of {@link HttpEndpointDestinationConfigurationProperty#getEndpointConfiguration}
             * @param endpointConfiguration The configuration of the HTTP endpoint selected as the destination. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endpointConfiguration(software.amazon.awscdk.IResolvable endpointConfiguration) {
                this.endpointConfiguration = endpointConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link HttpEndpointDestinationConfigurationProperty#getEndpointConfiguration}
             * @param endpointConfiguration The configuration of the HTTP endpoint selected as the destination. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endpointConfiguration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.HttpEndpointConfigurationProperty endpointConfiguration) {
                this.endpointConfiguration = endpointConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link HttpEndpointDestinationConfigurationProperty#getS3Configuration}
             * @param s3Configuration Describes the configuration of a destination in Amazon S3. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Configuration(software.amazon.awscdk.IResolvable s3Configuration) {
                this.s3Configuration = s3Configuration;
                return this;
            }

            /**
             * Sets the value of {@link HttpEndpointDestinationConfigurationProperty#getS3Configuration}
             * @param s3Configuration Describes the configuration of a destination in Amazon S3. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Configuration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.S3DestinationConfigurationProperty s3Configuration) {
                this.s3Configuration = s3Configuration;
                return this;
            }

            /**
             * Sets the value of {@link HttpEndpointDestinationConfigurationProperty#getBufferingHints}
             * @param bufferingHints The buffering options that can be used before data is delivered to the specified destination.
             *                       Kinesis Data Firehose treats these options as hints, and it might choose to use more optimal values. The SizeInMBs and IntervalInSeconds parameters are optional. However, if you specify a value for one of them, you must also provide a value for the other.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bufferingHints(software.amazon.awscdk.IResolvable bufferingHints) {
                this.bufferingHints = bufferingHints;
                return this;
            }

            /**
             * Sets the value of {@link HttpEndpointDestinationConfigurationProperty#getBufferingHints}
             * @param bufferingHints The buffering options that can be used before data is delivered to the specified destination.
             *                       Kinesis Data Firehose treats these options as hints, and it might choose to use more optimal values. The SizeInMBs and IntervalInSeconds parameters are optional. However, if you specify a value for one of them, you must also provide a value for the other.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bufferingHints(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.BufferingHintsProperty bufferingHints) {
                this.bufferingHints = bufferingHints;
                return this;
            }

            /**
             * Sets the value of {@link HttpEndpointDestinationConfigurationProperty#getCloudWatchLoggingOptions}
             * @param cloudWatchLoggingOptions Describes the Amazon CloudWatch logging options for your delivery stream.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchLoggingOptions(software.amazon.awscdk.IResolvable cloudWatchLoggingOptions) {
                this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
                return this;
            }

            /**
             * Sets the value of {@link HttpEndpointDestinationConfigurationProperty#getCloudWatchLoggingOptions}
             * @param cloudWatchLoggingOptions Describes the Amazon CloudWatch logging options for your delivery stream.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchLoggingOptions(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.CloudWatchLoggingOptionsProperty cloudWatchLoggingOptions) {
                this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
                return this;
            }

            /**
             * Sets the value of {@link HttpEndpointDestinationConfigurationProperty#getProcessingConfiguration}
             * @param processingConfiguration Describes the data processing configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder processingConfiguration(software.amazon.awscdk.IResolvable processingConfiguration) {
                this.processingConfiguration = processingConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link HttpEndpointDestinationConfigurationProperty#getProcessingConfiguration}
             * @param processingConfiguration Describes the data processing configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder processingConfiguration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.ProcessingConfigurationProperty processingConfiguration) {
                this.processingConfiguration = processingConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link HttpEndpointDestinationConfigurationProperty#getRequestConfiguration}
             * @param requestConfiguration The configuration of the request sent to the HTTP endpoint specified as the destination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requestConfiguration(software.amazon.awscdk.IResolvable requestConfiguration) {
                this.requestConfiguration = requestConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link HttpEndpointDestinationConfigurationProperty#getRequestConfiguration}
             * @param requestConfiguration The configuration of the request sent to the HTTP endpoint specified as the destination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requestConfiguration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.HttpEndpointRequestConfigurationProperty requestConfiguration) {
                this.requestConfiguration = requestConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link HttpEndpointDestinationConfigurationProperty#getRetryOptions}
             * @param retryOptions Describes the retry behavior in case Kinesis Data Firehose is unable to deliver data to the specified HTTP endpoint destination, or if it doesn't receive a valid acknowledgment of receipt from the specified HTTP endpoint destination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retryOptions(software.amazon.awscdk.IResolvable retryOptions) {
                this.retryOptions = retryOptions;
                return this;
            }

            /**
             * Sets the value of {@link HttpEndpointDestinationConfigurationProperty#getRetryOptions}
             * @param retryOptions Describes the retry behavior in case Kinesis Data Firehose is unable to deliver data to the specified HTTP endpoint destination, or if it doesn't receive a valid acknowledgment of receipt from the specified HTTP endpoint destination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retryOptions(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.RetryOptionsProperty retryOptions) {
                this.retryOptions = retryOptions;
                return this;
            }

            /**
             * Sets the value of {@link HttpEndpointDestinationConfigurationProperty#getRoleArn}
             * @param roleArn Kinesis Data Firehose uses this IAM role for all the permissions that the delivery stream needs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link HttpEndpointDestinationConfigurationProperty#getS3BackupMode}
             * @param s3BackupMode Describes the S3 bucket backup options for the data that Kinesis Data Firehose delivers to the HTTP endpoint destination.
             *                     You can back up all documents (AllData) or only the documents that Kinesis Data Firehose could not deliver to the specified HTTP endpoint destination (FailedDataOnly).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3BackupMode(java.lang.String s3BackupMode) {
                this.s3BackupMode = s3BackupMode;
                return this;
            }

            /**
             * Sets the value of {@link HttpEndpointDestinationConfigurationProperty#getSecretsManagerConfiguration}
             * @param secretsManagerConfiguration The configuration that defines how you access secrets for HTTP Endpoint destination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerConfiguration(software.amazon.awscdk.IResolvable secretsManagerConfiguration) {
                this.secretsManagerConfiguration = secretsManagerConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link HttpEndpointDestinationConfigurationProperty#getSecretsManagerConfiguration}
             * @param secretsManagerConfiguration The configuration that defines how you access secrets for HTTP Endpoint destination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerConfiguration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.SecretsManagerConfigurationProperty secretsManagerConfiguration) {
                this.secretsManagerConfiguration = secretsManagerConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HttpEndpointDestinationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HttpEndpointDestinationConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HttpEndpointDestinationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HttpEndpointDestinationConfigurationProperty {
            private final java.lang.Object endpointConfiguration;
            private final java.lang.Object s3Configuration;
            private final java.lang.Object bufferingHints;
            private final java.lang.Object cloudWatchLoggingOptions;
            private final java.lang.Object processingConfiguration;
            private final java.lang.Object requestConfiguration;
            private final java.lang.Object retryOptions;
            private final java.lang.String roleArn;
            private final java.lang.String s3BackupMode;
            private final java.lang.Object secretsManagerConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.endpointConfiguration = software.amazon.jsii.Kernel.get(this, "endpointConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.s3Configuration = software.amazon.jsii.Kernel.get(this, "s3Configuration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.bufferingHints = software.amazon.jsii.Kernel.get(this, "bufferingHints", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.cloudWatchLoggingOptions = software.amazon.jsii.Kernel.get(this, "cloudWatchLoggingOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.processingConfiguration = software.amazon.jsii.Kernel.get(this, "processingConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.requestConfiguration = software.amazon.jsii.Kernel.get(this, "requestConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.retryOptions = software.amazon.jsii.Kernel.get(this, "retryOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3BackupMode = software.amazon.jsii.Kernel.get(this, "s3BackupMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secretsManagerConfiguration = software.amazon.jsii.Kernel.get(this, "secretsManagerConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.endpointConfiguration = java.util.Objects.requireNonNull(builder.endpointConfiguration, "endpointConfiguration is required");
                this.s3Configuration = java.util.Objects.requireNonNull(builder.s3Configuration, "s3Configuration is required");
                this.bufferingHints = builder.bufferingHints;
                this.cloudWatchLoggingOptions = builder.cloudWatchLoggingOptions;
                this.processingConfiguration = builder.processingConfiguration;
                this.requestConfiguration = builder.requestConfiguration;
                this.retryOptions = builder.retryOptions;
                this.roleArn = builder.roleArn;
                this.s3BackupMode = builder.s3BackupMode;
                this.secretsManagerConfiguration = builder.secretsManagerConfiguration;
            }

            @Override
            public final java.lang.Object getEndpointConfiguration() {
                return this.endpointConfiguration;
            }

            @Override
            public final java.lang.Object getS3Configuration() {
                return this.s3Configuration;
            }

            @Override
            public final java.lang.Object getBufferingHints() {
                return this.bufferingHints;
            }

            @Override
            public final java.lang.Object getCloudWatchLoggingOptions() {
                return this.cloudWatchLoggingOptions;
            }

            @Override
            public final java.lang.Object getProcessingConfiguration() {
                return this.processingConfiguration;
            }

            @Override
            public final java.lang.Object getRequestConfiguration() {
                return this.requestConfiguration;
            }

            @Override
            public final java.lang.Object getRetryOptions() {
                return this.retryOptions;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.String getS3BackupMode() {
                return this.s3BackupMode;
            }

            @Override
            public final java.lang.Object getSecretsManagerConfiguration() {
                return this.secretsManagerConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("endpointConfiguration", om.valueToTree(this.getEndpointConfiguration()));
                data.set("s3Configuration", om.valueToTree(this.getS3Configuration()));
                if (this.getBufferingHints() != null) {
                    data.set("bufferingHints", om.valueToTree(this.getBufferingHints()));
                }
                if (this.getCloudWatchLoggingOptions() != null) {
                    data.set("cloudWatchLoggingOptions", om.valueToTree(this.getCloudWatchLoggingOptions()));
                }
                if (this.getProcessingConfiguration() != null) {
                    data.set("processingConfiguration", om.valueToTree(this.getProcessingConfiguration()));
                }
                if (this.getRequestConfiguration() != null) {
                    data.set("requestConfiguration", om.valueToTree(this.getRequestConfiguration()));
                }
                if (this.getRetryOptions() != null) {
                    data.set("retryOptions", om.valueToTree(this.getRetryOptions()));
                }
                if (this.getRoleArn() != null) {
                    data.set("roleArn", om.valueToTree(this.getRoleArn()));
                }
                if (this.getS3BackupMode() != null) {
                    data.set("s3BackupMode", om.valueToTree(this.getS3BackupMode()));
                }
                if (this.getSecretsManagerConfiguration() != null) {
                    data.set("secretsManagerConfiguration", om.valueToTree(this.getSecretsManagerConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.HttpEndpointDestinationConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HttpEndpointDestinationConfigurationProperty.Jsii$Proxy that = (HttpEndpointDestinationConfigurationProperty.Jsii$Proxy) o;

                if (!endpointConfiguration.equals(that.endpointConfiguration)) return false;
                if (!s3Configuration.equals(that.s3Configuration)) return false;
                if (this.bufferingHints != null ? !this.bufferingHints.equals(that.bufferingHints) : that.bufferingHints != null) return false;
                if (this.cloudWatchLoggingOptions != null ? !this.cloudWatchLoggingOptions.equals(that.cloudWatchLoggingOptions) : that.cloudWatchLoggingOptions != null) return false;
                if (this.processingConfiguration != null ? !this.processingConfiguration.equals(that.processingConfiguration) : that.processingConfiguration != null) return false;
                if (this.requestConfiguration != null ? !this.requestConfiguration.equals(that.requestConfiguration) : that.requestConfiguration != null) return false;
                if (this.retryOptions != null ? !this.retryOptions.equals(that.retryOptions) : that.retryOptions != null) return false;
                if (this.roleArn != null ? !this.roleArn.equals(that.roleArn) : that.roleArn != null) return false;
                if (this.s3BackupMode != null ? !this.s3BackupMode.equals(that.s3BackupMode) : that.s3BackupMode != null) return false;
                return this.secretsManagerConfiguration != null ? this.secretsManagerConfiguration.equals(that.secretsManagerConfiguration) : that.secretsManagerConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.endpointConfiguration.hashCode();
                result = 31 * result + (this.s3Configuration.hashCode());
                result = 31 * result + (this.bufferingHints != null ? this.bufferingHints.hashCode() : 0);
                result = 31 * result + (this.cloudWatchLoggingOptions != null ? this.cloudWatchLoggingOptions.hashCode() : 0);
                result = 31 * result + (this.processingConfiguration != null ? this.processingConfiguration.hashCode() : 0);
                result = 31 * result + (this.requestConfiguration != null ? this.requestConfiguration.hashCode() : 0);
                result = 31 * result + (this.retryOptions != null ? this.retryOptions.hashCode() : 0);
                result = 31 * result + (this.roleArn != null ? this.roleArn.hashCode() : 0);
                result = 31 * result + (this.s3BackupMode != null ? this.s3BackupMode.hashCode() : 0);
                result = 31 * result + (this.secretsManagerConfiguration != null ? this.secretsManagerConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration of the HTTP endpoint request.
     * <p>
     * Kinesis Firehose supports any custom HTTP endpoint or HTTP endpoints owned by supported third-party service providers, including Datadog, MongoDB, and New Relic.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * HttpEndpointRequestConfigurationProperty httpEndpointRequestConfigurationProperty = HttpEndpointRequestConfigurationProperty.builder()
     *         .commonAttributes(List.of(HttpEndpointCommonAttributeProperty.builder()
     *                 .attributeName("attributeName")
     *                 .attributeValue("attributeValue")
     *                 .build()))
     *         .contentEncoding("contentEncoding")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointrequestconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointrequestconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.HttpEndpointRequestConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(HttpEndpointRequestConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HttpEndpointRequestConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Describes the metadata sent to the HTTP endpoint destination.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointrequestconfiguration.html#cfn-kinesisfirehose-deliverystream-httpendpointrequestconfiguration-commonattributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointrequestconfiguration.html#cfn-kinesisfirehose-deliverystream-httpendpointrequestconfiguration-commonattributes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCommonAttributes() {
            return null;
        }

        /**
         * Kinesis Data Firehose uses the content encoding to compress the body of a request before sending the request to the destination.
         * <p>
         * For more information, see Content-Encoding in MDN Web Docs, the official Mozilla documentation.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointrequestconfiguration.html#cfn-kinesisfirehose-deliverystream-httpendpointrequestconfiguration-contentencoding">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointrequestconfiguration.html#cfn-kinesisfirehose-deliverystream-httpendpointrequestconfiguration-contentencoding</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getContentEncoding() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HttpEndpointRequestConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HttpEndpointRequestConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HttpEndpointRequestConfigurationProperty> {
            java.lang.Object commonAttributes;
            java.lang.String contentEncoding;

            /**
             * Sets the value of {@link HttpEndpointRequestConfigurationProperty#getCommonAttributes}
             * @param commonAttributes Describes the metadata sent to the HTTP endpoint destination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder commonAttributes(software.amazon.awscdk.IResolvable commonAttributes) {
                this.commonAttributes = commonAttributes;
                return this;
            }

            /**
             * Sets the value of {@link HttpEndpointRequestConfigurationProperty#getCommonAttributes}
             * @param commonAttributes Describes the metadata sent to the HTTP endpoint destination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder commonAttributes(java.util.List<? extends java.lang.Object> commonAttributes) {
                this.commonAttributes = commonAttributes;
                return this;
            }

            /**
             * Sets the value of {@link HttpEndpointRequestConfigurationProperty#getContentEncoding}
             * @param contentEncoding Kinesis Data Firehose uses the content encoding to compress the body of a request before sending the request to the destination.
             *                        For more information, see Content-Encoding in MDN Web Docs, the official Mozilla documentation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder contentEncoding(java.lang.String contentEncoding) {
                this.contentEncoding = contentEncoding;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HttpEndpointRequestConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HttpEndpointRequestConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HttpEndpointRequestConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HttpEndpointRequestConfigurationProperty {
            private final java.lang.Object commonAttributes;
            private final java.lang.String contentEncoding;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.commonAttributes = software.amazon.jsii.Kernel.get(this, "commonAttributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.contentEncoding = software.amazon.jsii.Kernel.get(this, "contentEncoding", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.commonAttributes = builder.commonAttributes;
                this.contentEncoding = builder.contentEncoding;
            }

            @Override
            public final java.lang.Object getCommonAttributes() {
                return this.commonAttributes;
            }

            @Override
            public final java.lang.String getContentEncoding() {
                return this.contentEncoding;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCommonAttributes() != null) {
                    data.set("commonAttributes", om.valueToTree(this.getCommonAttributes()));
                }
                if (this.getContentEncoding() != null) {
                    data.set("contentEncoding", om.valueToTree(this.getContentEncoding()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.HttpEndpointRequestConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HttpEndpointRequestConfigurationProperty.Jsii$Proxy that = (HttpEndpointRequestConfigurationProperty.Jsii$Proxy) o;

                if (this.commonAttributes != null ? !this.commonAttributes.equals(that.commonAttributes) : that.commonAttributes != null) return false;
                return this.contentEncoding != null ? this.contentEncoding.equals(that.contentEncoding) : that.contentEncoding == null;
            }

            @Override
            public final int hashCode() {
                int result = this.commonAttributes != null ? this.commonAttributes.hashCode() : 0;
                result = 31 * result + (this.contentEncoding != null ? this.contentEncoding.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the destination configure settings for Apache Iceberg Table.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * IcebergDestinationConfigurationProperty icebergDestinationConfigurationProperty = IcebergDestinationConfigurationProperty.builder()
     *         .catalogConfiguration(CatalogConfigurationProperty.builder()
     *                 .catalogArn("catalogArn")
     *                 .build())
     *         .roleArn("roleArn")
     *         .s3Configuration(S3DestinationConfigurationProperty.builder()
     *                 .bucketArn("bucketArn")
     *                 .roleArn("roleArn")
     *                 // the properties below are optional
     *                 .bufferingHints(BufferingHintsProperty.builder()
     *                         .intervalInSeconds(123)
     *                         .sizeInMBs(123)
     *                         .build())
     *                 .cloudWatchLoggingOptions(CloudWatchLoggingOptionsProperty.builder()
     *                         .enabled(false)
     *                         .logGroupName("logGroupName")
     *                         .logStreamName("logStreamName")
     *                         .build())
     *                 .compressionFormat("compressionFormat")
     *                 .encryptionConfiguration(EncryptionConfigurationProperty.builder()
     *                         .kmsEncryptionConfig(KMSEncryptionConfigProperty.builder()
     *                                 .awskmsKeyArn("awskmsKeyArn")
     *                                 .build())
     *                         .noEncryptionConfig("noEncryptionConfig")
     *                         .build())
     *                 .errorOutputPrefix("errorOutputPrefix")
     *                 .prefix("prefix")
     *                 .build())
     *         // the properties below are optional
     *         .appendOnly(false)
     *         .bufferingHints(BufferingHintsProperty.builder()
     *                 .intervalInSeconds(123)
     *                 .sizeInMBs(123)
     *                 .build())
     *         .cloudWatchLoggingOptions(CloudWatchLoggingOptionsProperty.builder()
     *                 .enabled(false)
     *                 .logGroupName("logGroupName")
     *                 .logStreamName("logStreamName")
     *                 .build())
     *         .destinationTableConfigurationList(List.of(DestinationTableConfigurationProperty.builder()
     *                 .destinationDatabaseName("destinationDatabaseName")
     *                 .destinationTableName("destinationTableName")
     *                 // the properties below are optional
     *                 .s3ErrorOutputPrefix("s3ErrorOutputPrefix")
     *                 .uniqueKeys(List.of("uniqueKeys"))
     *                 .build()))
     *         .processingConfiguration(ProcessingConfigurationProperty.builder()
     *                 .enabled(false)
     *                 .processors(List.of(ProcessorProperty.builder()
     *                         .type("type")
     *                         // the properties below are optional
     *                         .parameters(List.of(ProcessorParameterProperty.builder()
     *                                 .parameterName("parameterName")
     *                                 .parameterValue("parameterValue")
     *                                 .build()))
     *                         .build()))
     *                 .build())
     *         .retryOptions(RetryOptionsProperty.builder()
     *                 .durationInSeconds(123)
     *                 .build())
     *         .s3BackupMode("s3BackupMode")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-icebergdestinationconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-icebergdestinationconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.IcebergDestinationConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(IcebergDestinationConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IcebergDestinationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Configuration describing where the destination Apache Iceberg Tables are persisted.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-icebergdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-icebergdestinationconfiguration-catalogconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-icebergdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-icebergdestinationconfiguration-catalogconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getCatalogConfiguration();

        /**
         * The Amazon Resource Name (ARN) of the IAM role to be assumed by Firehose for calling Apache Iceberg Tables.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-icebergdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-icebergdestinationconfiguration-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-icebergdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-icebergdestinationconfiguration-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-icebergdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-icebergdestinationconfiguration-s3configuration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-icebergdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-icebergdestinationconfiguration-s3configuration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getS3Configuration();

        /**
         * Describes whether all incoming data for this delivery stream will be append only (inserts only and not for updates and deletes) for Iceberg delivery.
         * <p>
         * This feature is only applicable for Apache Iceberg Tables.
         * <p>
         * The default value is false. If you set this value to true, Firehose automatically increases the throughput limit of a stream based on the throttling levels of the stream. If you set this parameter to true for a stream with updates and deletes, you will see out of order delivery.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-icebergdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-icebergdestinationconfiguration-appendonly">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-icebergdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-icebergdestinationconfiguration-appendonly</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAppendOnly() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-icebergdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-icebergdestinationconfiguration-bufferinghints">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-icebergdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-icebergdestinationconfiguration-bufferinghints</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBufferingHints() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-icebergdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-icebergdestinationconfiguration-cloudwatchloggingoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-icebergdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-icebergdestinationconfiguration-cloudwatchloggingoptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCloudWatchLoggingOptions() {
            return null;
        }

        /**
         * Provides a list of <code>DestinationTableConfigurations</code> which Firehose uses to deliver data to Apache Iceberg Tables.
         * <p>
         * Firehose will write data with insert if table specific configuration is not provided here.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-icebergdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-icebergdestinationconfiguration-destinationtableconfigurationlist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-icebergdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-icebergdestinationconfiguration-destinationtableconfigurationlist</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDestinationTableConfigurationList() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-icebergdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-icebergdestinationconfiguration-processingconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-icebergdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-icebergdestinationconfiguration-processingconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getProcessingConfiguration() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-icebergdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-icebergdestinationconfiguration-retryoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-icebergdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-icebergdestinationconfiguration-retryoptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRetryOptions() {
            return null;
        }

        /**
         * Describes how Firehose will backup records.
         * <p>
         * Currently,S3 backup only supports <code>FailedDataOnly</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-icebergdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-icebergdestinationconfiguration-s3backupmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-icebergdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-icebergdestinationconfiguration-s3backupmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3BackupMode() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IcebergDestinationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IcebergDestinationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IcebergDestinationConfigurationProperty> {
            java.lang.Object catalogConfiguration;
            java.lang.String roleArn;
            java.lang.Object s3Configuration;
            java.lang.Object appendOnly;
            java.lang.Object bufferingHints;
            java.lang.Object cloudWatchLoggingOptions;
            java.lang.Object destinationTableConfigurationList;
            java.lang.Object processingConfiguration;
            java.lang.Object retryOptions;
            java.lang.String s3BackupMode;

            /**
             * Sets the value of {@link IcebergDestinationConfigurationProperty#getCatalogConfiguration}
             * @param catalogConfiguration Configuration describing where the destination Apache Iceberg Tables are persisted. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder catalogConfiguration(software.amazon.awscdk.IResolvable catalogConfiguration) {
                this.catalogConfiguration = catalogConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link IcebergDestinationConfigurationProperty#getCatalogConfiguration}
             * @param catalogConfiguration Configuration describing where the destination Apache Iceberg Tables are persisted. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder catalogConfiguration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.CatalogConfigurationProperty catalogConfiguration) {
                this.catalogConfiguration = catalogConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link IcebergDestinationConfigurationProperty#getRoleArn}
             * @param roleArn The Amazon Resource Name (ARN) of the IAM role to be assumed by Firehose for calling Apache Iceberg Tables. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link IcebergDestinationConfigurationProperty#getS3Configuration}
             * @param s3Configuration the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Configuration(software.amazon.awscdk.IResolvable s3Configuration) {
                this.s3Configuration = s3Configuration;
                return this;
            }

            /**
             * Sets the value of {@link IcebergDestinationConfigurationProperty#getS3Configuration}
             * @param s3Configuration the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Configuration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.S3DestinationConfigurationProperty s3Configuration) {
                this.s3Configuration = s3Configuration;
                return this;
            }

            /**
             * Sets the value of {@link IcebergDestinationConfigurationProperty#getAppendOnly}
             * @param appendOnly Describes whether all incoming data for this delivery stream will be append only (inserts only and not for updates and deletes) for Iceberg delivery.
             *                   This feature is only applicable for Apache Iceberg Tables.
             *                   <p>
             *                   The default value is false. If you set this value to true, Firehose automatically increases the throughput limit of a stream based on the throttling levels of the stream. If you set this parameter to true for a stream with updates and deletes, you will see out of order delivery.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder appendOnly(java.lang.Boolean appendOnly) {
                this.appendOnly = appendOnly;
                return this;
            }

            /**
             * Sets the value of {@link IcebergDestinationConfigurationProperty#getAppendOnly}
             * @param appendOnly Describes whether all incoming data for this delivery stream will be append only (inserts only and not for updates and deletes) for Iceberg delivery.
             *                   This feature is only applicable for Apache Iceberg Tables.
             *                   <p>
             *                   The default value is false. If you set this value to true, Firehose automatically increases the throughput limit of a stream based on the throttling levels of the stream. If you set this parameter to true for a stream with updates and deletes, you will see out of order delivery.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder appendOnly(software.amazon.awscdk.IResolvable appendOnly) {
                this.appendOnly = appendOnly;
                return this;
            }

            /**
             * Sets the value of {@link IcebergDestinationConfigurationProperty#getBufferingHints}
             * @param bufferingHints the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bufferingHints(software.amazon.awscdk.IResolvable bufferingHints) {
                this.bufferingHints = bufferingHints;
                return this;
            }

            /**
             * Sets the value of {@link IcebergDestinationConfigurationProperty#getBufferingHints}
             * @param bufferingHints the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bufferingHints(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.BufferingHintsProperty bufferingHints) {
                this.bufferingHints = bufferingHints;
                return this;
            }

            /**
             * Sets the value of {@link IcebergDestinationConfigurationProperty#getCloudWatchLoggingOptions}
             * @param cloudWatchLoggingOptions the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchLoggingOptions(software.amazon.awscdk.IResolvable cloudWatchLoggingOptions) {
                this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
                return this;
            }

            /**
             * Sets the value of {@link IcebergDestinationConfigurationProperty#getCloudWatchLoggingOptions}
             * @param cloudWatchLoggingOptions the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchLoggingOptions(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.CloudWatchLoggingOptionsProperty cloudWatchLoggingOptions) {
                this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
                return this;
            }

            /**
             * Sets the value of {@link IcebergDestinationConfigurationProperty#getDestinationTableConfigurationList}
             * @param destinationTableConfigurationList Provides a list of <code>DestinationTableConfigurations</code> which Firehose uses to deliver data to Apache Iceberg Tables.
             *                                          Firehose will write data with insert if table specific configuration is not provided here.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationTableConfigurationList(software.amazon.awscdk.IResolvable destinationTableConfigurationList) {
                this.destinationTableConfigurationList = destinationTableConfigurationList;
                return this;
            }

            /**
             * Sets the value of {@link IcebergDestinationConfigurationProperty#getDestinationTableConfigurationList}
             * @param destinationTableConfigurationList Provides a list of <code>DestinationTableConfigurations</code> which Firehose uses to deliver data to Apache Iceberg Tables.
             *                                          Firehose will write data with insert if table specific configuration is not provided here.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationTableConfigurationList(java.util.List<? extends java.lang.Object> destinationTableConfigurationList) {
                this.destinationTableConfigurationList = destinationTableConfigurationList;
                return this;
            }

            /**
             * Sets the value of {@link IcebergDestinationConfigurationProperty#getProcessingConfiguration}
             * @param processingConfiguration the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder processingConfiguration(software.amazon.awscdk.IResolvable processingConfiguration) {
                this.processingConfiguration = processingConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link IcebergDestinationConfigurationProperty#getProcessingConfiguration}
             * @param processingConfiguration the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder processingConfiguration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.ProcessingConfigurationProperty processingConfiguration) {
                this.processingConfiguration = processingConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link IcebergDestinationConfigurationProperty#getRetryOptions}
             * @param retryOptions the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retryOptions(software.amazon.awscdk.IResolvable retryOptions) {
                this.retryOptions = retryOptions;
                return this;
            }

            /**
             * Sets the value of {@link IcebergDestinationConfigurationProperty#getRetryOptions}
             * @param retryOptions the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retryOptions(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.RetryOptionsProperty retryOptions) {
                this.retryOptions = retryOptions;
                return this;
            }

            /**
             * Sets the value of {@link IcebergDestinationConfigurationProperty#getS3BackupMode}
             * @param s3BackupMode Describes how Firehose will backup records.
             *                     Currently,S3 backup only supports <code>FailedDataOnly</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3BackupMode(java.lang.String s3BackupMode) {
                this.s3BackupMode = s3BackupMode;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IcebergDestinationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IcebergDestinationConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IcebergDestinationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IcebergDestinationConfigurationProperty {
            private final java.lang.Object catalogConfiguration;
            private final java.lang.String roleArn;
            private final java.lang.Object s3Configuration;
            private final java.lang.Object appendOnly;
            private final java.lang.Object bufferingHints;
            private final java.lang.Object cloudWatchLoggingOptions;
            private final java.lang.Object destinationTableConfigurationList;
            private final java.lang.Object processingConfiguration;
            private final java.lang.Object retryOptions;
            private final java.lang.String s3BackupMode;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.catalogConfiguration = software.amazon.jsii.Kernel.get(this, "catalogConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3Configuration = software.amazon.jsii.Kernel.get(this, "s3Configuration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.appendOnly = software.amazon.jsii.Kernel.get(this, "appendOnly", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.bufferingHints = software.amazon.jsii.Kernel.get(this, "bufferingHints", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.cloudWatchLoggingOptions = software.amazon.jsii.Kernel.get(this, "cloudWatchLoggingOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.destinationTableConfigurationList = software.amazon.jsii.Kernel.get(this, "destinationTableConfigurationList", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.processingConfiguration = software.amazon.jsii.Kernel.get(this, "processingConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.retryOptions = software.amazon.jsii.Kernel.get(this, "retryOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.s3BackupMode = software.amazon.jsii.Kernel.get(this, "s3BackupMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.catalogConfiguration = java.util.Objects.requireNonNull(builder.catalogConfiguration, "catalogConfiguration is required");
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
                this.s3Configuration = java.util.Objects.requireNonNull(builder.s3Configuration, "s3Configuration is required");
                this.appendOnly = builder.appendOnly;
                this.bufferingHints = builder.bufferingHints;
                this.cloudWatchLoggingOptions = builder.cloudWatchLoggingOptions;
                this.destinationTableConfigurationList = builder.destinationTableConfigurationList;
                this.processingConfiguration = builder.processingConfiguration;
                this.retryOptions = builder.retryOptions;
                this.s3BackupMode = builder.s3BackupMode;
            }

            @Override
            public final java.lang.Object getCatalogConfiguration() {
                return this.catalogConfiguration;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.Object getS3Configuration() {
                return this.s3Configuration;
            }

            @Override
            public final java.lang.Object getAppendOnly() {
                return this.appendOnly;
            }

            @Override
            public final java.lang.Object getBufferingHints() {
                return this.bufferingHints;
            }

            @Override
            public final java.lang.Object getCloudWatchLoggingOptions() {
                return this.cloudWatchLoggingOptions;
            }

            @Override
            public final java.lang.Object getDestinationTableConfigurationList() {
                return this.destinationTableConfigurationList;
            }

            @Override
            public final java.lang.Object getProcessingConfiguration() {
                return this.processingConfiguration;
            }

            @Override
            public final java.lang.Object getRetryOptions() {
                return this.retryOptions;
            }

            @Override
            public final java.lang.String getS3BackupMode() {
                return this.s3BackupMode;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("catalogConfiguration", om.valueToTree(this.getCatalogConfiguration()));
                data.set("roleArn", om.valueToTree(this.getRoleArn()));
                data.set("s3Configuration", om.valueToTree(this.getS3Configuration()));
                if (this.getAppendOnly() != null) {
                    data.set("appendOnly", om.valueToTree(this.getAppendOnly()));
                }
                if (this.getBufferingHints() != null) {
                    data.set("bufferingHints", om.valueToTree(this.getBufferingHints()));
                }
                if (this.getCloudWatchLoggingOptions() != null) {
                    data.set("cloudWatchLoggingOptions", om.valueToTree(this.getCloudWatchLoggingOptions()));
                }
                if (this.getDestinationTableConfigurationList() != null) {
                    data.set("destinationTableConfigurationList", om.valueToTree(this.getDestinationTableConfigurationList()));
                }
                if (this.getProcessingConfiguration() != null) {
                    data.set("processingConfiguration", om.valueToTree(this.getProcessingConfiguration()));
                }
                if (this.getRetryOptions() != null) {
                    data.set("retryOptions", om.valueToTree(this.getRetryOptions()));
                }
                if (this.getS3BackupMode() != null) {
                    data.set("s3BackupMode", om.valueToTree(this.getS3BackupMode()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.IcebergDestinationConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IcebergDestinationConfigurationProperty.Jsii$Proxy that = (IcebergDestinationConfigurationProperty.Jsii$Proxy) o;

                if (!catalogConfiguration.equals(that.catalogConfiguration)) return false;
                if (!roleArn.equals(that.roleArn)) return false;
                if (!s3Configuration.equals(that.s3Configuration)) return false;
                if (this.appendOnly != null ? !this.appendOnly.equals(that.appendOnly) : that.appendOnly != null) return false;
                if (this.bufferingHints != null ? !this.bufferingHints.equals(that.bufferingHints) : that.bufferingHints != null) return false;
                if (this.cloudWatchLoggingOptions != null ? !this.cloudWatchLoggingOptions.equals(that.cloudWatchLoggingOptions) : that.cloudWatchLoggingOptions != null) return false;
                if (this.destinationTableConfigurationList != null ? !this.destinationTableConfigurationList.equals(that.destinationTableConfigurationList) : that.destinationTableConfigurationList != null) return false;
                if (this.processingConfiguration != null ? !this.processingConfiguration.equals(that.processingConfiguration) : that.processingConfiguration != null) return false;
                if (this.retryOptions != null ? !this.retryOptions.equals(that.retryOptions) : that.retryOptions != null) return false;
                return this.s3BackupMode != null ? this.s3BackupMode.equals(that.s3BackupMode) : that.s3BackupMode == null;
            }

            @Override
            public final int hashCode() {
                int result = this.catalogConfiguration.hashCode();
                result = 31 * result + (this.roleArn.hashCode());
                result = 31 * result + (this.s3Configuration.hashCode());
                result = 31 * result + (this.appendOnly != null ? this.appendOnly.hashCode() : 0);
                result = 31 * result + (this.bufferingHints != null ? this.bufferingHints.hashCode() : 0);
                result = 31 * result + (this.cloudWatchLoggingOptions != null ? this.cloudWatchLoggingOptions.hashCode() : 0);
                result = 31 * result + (this.destinationTableConfigurationList != null ? this.destinationTableConfigurationList.hashCode() : 0);
                result = 31 * result + (this.processingConfiguration != null ? this.processingConfiguration.hashCode() : 0);
                result = 31 * result + (this.retryOptions != null ? this.retryOptions.hashCode() : 0);
                result = 31 * result + (this.s3BackupMode != null ? this.s3BackupMode.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the deserializer you want to use to convert the format of the input data.
     * <p>
     * This parameter is required if <code>Enabled</code> is set to true.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * InputFormatConfigurationProperty inputFormatConfigurationProperty = InputFormatConfigurationProperty.builder()
     *         .deserializer(DeserializerProperty.builder()
     *                 .hiveJsonSerDe(HiveJsonSerDeProperty.builder()
     *                         .timestampFormats(List.of("timestampFormats"))
     *                         .build())
     *                 .openXJsonSerDe(OpenXJsonSerDeProperty.builder()
     *                         .caseInsensitive(false)
     *                         .columnToJsonKeyMappings(Map.of(
     *                                 "columnToJsonKeyMappingsKey", "columnToJsonKeyMappings"))
     *                         .convertDotsInJsonKeysToUnderscores(false)
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-inputformatconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-inputformatconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.InputFormatConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(InputFormatConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InputFormatConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies which deserializer to use.
         * <p>
         * You can choose either the Apache Hive JSON SerDe or the OpenX JSON SerDe. If both are non-null, the server rejects the request.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-inputformatconfiguration.html#cfn-kinesisfirehose-deliverystream-inputformatconfiguration-deserializer">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-inputformatconfiguration.html#cfn-kinesisfirehose-deliverystream-inputformatconfiguration-deserializer</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDeserializer() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InputFormatConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InputFormatConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InputFormatConfigurationProperty> {
            java.lang.Object deserializer;

            /**
             * Sets the value of {@link InputFormatConfigurationProperty#getDeserializer}
             * @param deserializer Specifies which deserializer to use.
             *                     You can choose either the Apache Hive JSON SerDe or the OpenX JSON SerDe. If both are non-null, the server rejects the request.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deserializer(software.amazon.awscdk.IResolvable deserializer) {
                this.deserializer = deserializer;
                return this;
            }

            /**
             * Sets the value of {@link InputFormatConfigurationProperty#getDeserializer}
             * @param deserializer Specifies which deserializer to use.
             *                     You can choose either the Apache Hive JSON SerDe or the OpenX JSON SerDe. If both are non-null, the server rejects the request.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deserializer(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.DeserializerProperty deserializer) {
                this.deserializer = deserializer;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InputFormatConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InputFormatConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InputFormatConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InputFormatConfigurationProperty {
            private final java.lang.Object deserializer;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.deserializer = software.amazon.jsii.Kernel.get(this, "deserializer", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.deserializer = builder.deserializer;
            }

            @Override
            public final java.lang.Object getDeserializer() {
                return this.deserializer;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDeserializer() != null) {
                    data.set("deserializer", om.valueToTree(this.getDeserializer()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.InputFormatConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InputFormatConfigurationProperty.Jsii$Proxy that = (InputFormatConfigurationProperty.Jsii$Proxy) o;

                return this.deserializer != null ? this.deserializer.equals(that.deserializer) : that.deserializer == null;
            }

            @Override
            public final int hashCode() {
                int result = this.deserializer != null ? this.deserializer.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The <code>KMSEncryptionConfig</code> property type specifies the AWS Key Management Service ( AWS KMS) encryption key that Amazon Simple Storage Service (Amazon S3) uses to encrypt data delivered by the Amazon Kinesis Data Firehose (Kinesis Data Firehose) stream.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * KMSEncryptionConfigProperty kMSEncryptionConfigProperty = KMSEncryptionConfigProperty.builder()
     *         .awskmsKeyArn("awskmsKeyArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-kmsencryptionconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-kmsencryptionconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.KMSEncryptionConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(KMSEncryptionConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KMSEncryptionConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the AWS KMS encryption key that Amazon S3 uses to encrypt data delivered by the Kinesis Data Firehose stream.
         * <p>
         * The key must belong to the same region as the destination S3 bucket.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-kmsencryptionconfig.html#cfn-kinesisfirehose-deliverystream-kmsencryptionconfig-awskmskeyarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-kmsencryptionconfig.html#cfn-kinesisfirehose-deliverystream-kmsencryptionconfig-awskmskeyarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAwskmsKeyArn();

        /**
         * @return a {@link Builder} of {@link KMSEncryptionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KMSEncryptionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KMSEncryptionConfigProperty> {
            java.lang.String awskmsKeyArn;

            /**
             * Sets the value of {@link KMSEncryptionConfigProperty#getAwskmsKeyArn}
             * @param awskmsKeyArn The Amazon Resource Name (ARN) of the AWS KMS encryption key that Amazon S3 uses to encrypt data delivered by the Kinesis Data Firehose stream. This parameter is required.
             *                     The key must belong to the same region as the destination S3 bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awskmsKeyArn(java.lang.String awskmsKeyArn) {
                this.awskmsKeyArn = awskmsKeyArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KMSEncryptionConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KMSEncryptionConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KMSEncryptionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KMSEncryptionConfigProperty {
            private final java.lang.String awskmsKeyArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.awskmsKeyArn = software.amazon.jsii.Kernel.get(this, "awskmsKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.awskmsKeyArn = java.util.Objects.requireNonNull(builder.awskmsKeyArn, "awskmsKeyArn is required");
            }

            @Override
            public final java.lang.String getAwskmsKeyArn() {
                return this.awskmsKeyArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("awskmsKeyArn", om.valueToTree(this.getAwskmsKeyArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.KMSEncryptionConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KMSEncryptionConfigProperty.Jsii$Proxy that = (KMSEncryptionConfigProperty.Jsii$Proxy) o;

                return this.awskmsKeyArn.equals(that.awskmsKeyArn);
            }

            @Override
            public final int hashCode() {
                int result = this.awskmsKeyArn.hashCode();
                return result;
            }
        }
    }
    /**
     * The <code>KinesisStreamSourceConfiguration</code> property type specifies the stream and role Amazon Resource Names (ARNs) for a Kinesis stream used as the source for a delivery stream.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * KinesisStreamSourceConfigurationProperty kinesisStreamSourceConfigurationProperty = KinesisStreamSourceConfigurationProperty.builder()
     *         .kinesisStreamArn("kinesisStreamArn")
     *         .roleArn("roleArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-kinesisstreamsourceconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-kinesisstreamsourceconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.KinesisStreamSourceConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(KinesisStreamSourceConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KinesisStreamSourceConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ARN of the source Kinesis data stream.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-kinesisstreamsourceconfiguration.html#cfn-kinesisfirehose-deliverystream-kinesisstreamsourceconfiguration-kinesisstreamarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-kinesisstreamsourceconfiguration.html#cfn-kinesisfirehose-deliverystream-kinesisstreamsourceconfiguration-kinesisstreamarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKinesisStreamArn();

        /**
         * The ARN of the role that provides access to the source Kinesis data stream.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-kinesisstreamsourceconfiguration.html#cfn-kinesisfirehose-deliverystream-kinesisstreamsourceconfiguration-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-kinesisstreamsourceconfiguration.html#cfn-kinesisfirehose-deliverystream-kinesisstreamsourceconfiguration-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * @return a {@link Builder} of {@link KinesisStreamSourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KinesisStreamSourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KinesisStreamSourceConfigurationProperty> {
            java.lang.String kinesisStreamArn;
            java.lang.String roleArn;

            /**
             * Sets the value of {@link KinesisStreamSourceConfigurationProperty#getKinesisStreamArn}
             * @param kinesisStreamArn The ARN of the source Kinesis data stream. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kinesisStreamArn(java.lang.String kinesisStreamArn) {
                this.kinesisStreamArn = kinesisStreamArn;
                return this;
            }

            /**
             * Sets the value of {@link KinesisStreamSourceConfigurationProperty#getRoleArn}
             * @param roleArn The ARN of the role that provides access to the source Kinesis data stream. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KinesisStreamSourceConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KinesisStreamSourceConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KinesisStreamSourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KinesisStreamSourceConfigurationProperty {
            private final java.lang.String kinesisStreamArn;
            private final java.lang.String roleArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.kinesisStreamArn = software.amazon.jsii.Kernel.get(this, "kinesisStreamArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.kinesisStreamArn = java.util.Objects.requireNonNull(builder.kinesisStreamArn, "kinesisStreamArn is required");
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
            }

            @Override
            public final java.lang.String getKinesisStreamArn() {
                return this.kinesisStreamArn;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("kinesisStreamArn", om.valueToTree(this.getKinesisStreamArn()));
                data.set("roleArn", om.valueToTree(this.getRoleArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.KinesisStreamSourceConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KinesisStreamSourceConfigurationProperty.Jsii$Proxy that = (KinesisStreamSourceConfigurationProperty.Jsii$Proxy) o;

                if (!kinesisStreamArn.equals(that.kinesisStreamArn)) return false;
                return this.roleArn.equals(that.roleArn);
            }

            @Override
            public final int hashCode() {
                int result = this.kinesisStreamArn.hashCode();
                result = 31 * result + (this.roleArn.hashCode());
                return result;
            }
        }
    }
    /**
     * The configuration for the Amazon MSK cluster to be used as the source for a delivery stream.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * MSKSourceConfigurationProperty mSKSourceConfigurationProperty = MSKSourceConfigurationProperty.builder()
     *         .authenticationConfiguration(AuthenticationConfigurationProperty.builder()
     *                 .connectivity("connectivity")
     *                 .roleArn("roleArn")
     *                 .build())
     *         .mskClusterArn("mskClusterArn")
     *         .topicName("topicName")
     *         // the properties below are optional
     *         .readFromTimestamp("readFromTimestamp")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-msksourceconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-msksourceconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.MSKSourceConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(MSKSourceConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MSKSourceConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The authentication configuration of the Amazon MSK cluster.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-msksourceconfiguration.html#cfn-kinesisfirehose-deliverystream-msksourceconfiguration-authenticationconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-msksourceconfiguration.html#cfn-kinesisfirehose-deliverystream-msksourceconfiguration-authenticationconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getAuthenticationConfiguration();

        /**
         * The ARN of the Amazon MSK cluster.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-msksourceconfiguration.html#cfn-kinesisfirehose-deliverystream-msksourceconfiguration-mskclusterarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-msksourceconfiguration.html#cfn-kinesisfirehose-deliverystream-msksourceconfiguration-mskclusterarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMskClusterArn();

        /**
         * The topic name within the Amazon MSK cluster.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-msksourceconfiguration.html#cfn-kinesisfirehose-deliverystream-msksourceconfiguration-topicname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-msksourceconfiguration.html#cfn-kinesisfirehose-deliverystream-msksourceconfiguration-topicname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTopicName();

        /**
         * The start date and time in UTC for the offset position within your MSK topic from where Firehose begins to read.
         * <p>
         * By default, this is set to timestamp when Firehose becomes Active.
         * <p>
         * If you want to create a Firehose stream with Earliest start position from SDK or CLI, you need to set the <code>ReadFromTimestamp</code> parameter to Epoch (1970-01-01T00:00:00Z).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-msksourceconfiguration.html#cfn-kinesisfirehose-deliverystream-msksourceconfiguration-readfromtimestamp">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-msksourceconfiguration.html#cfn-kinesisfirehose-deliverystream-msksourceconfiguration-readfromtimestamp</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getReadFromTimestamp() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MSKSourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MSKSourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MSKSourceConfigurationProperty> {
            java.lang.Object authenticationConfiguration;
            java.lang.String mskClusterArn;
            java.lang.String topicName;
            java.lang.String readFromTimestamp;

            /**
             * Sets the value of {@link MSKSourceConfigurationProperty#getAuthenticationConfiguration}
             * @param authenticationConfiguration The authentication configuration of the Amazon MSK cluster. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authenticationConfiguration(software.amazon.awscdk.IResolvable authenticationConfiguration) {
                this.authenticationConfiguration = authenticationConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link MSKSourceConfigurationProperty#getAuthenticationConfiguration}
             * @param authenticationConfiguration The authentication configuration of the Amazon MSK cluster. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authenticationConfiguration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.AuthenticationConfigurationProperty authenticationConfiguration) {
                this.authenticationConfiguration = authenticationConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link MSKSourceConfigurationProperty#getMskClusterArn}
             * @param mskClusterArn The ARN of the Amazon MSK cluster. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mskClusterArn(java.lang.String mskClusterArn) {
                this.mskClusterArn = mskClusterArn;
                return this;
            }

            /**
             * Sets the value of {@link MSKSourceConfigurationProperty#getTopicName}
             * @param topicName The topic name within the Amazon MSK cluster. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder topicName(java.lang.String topicName) {
                this.topicName = topicName;
                return this;
            }

            /**
             * Sets the value of {@link MSKSourceConfigurationProperty#getReadFromTimestamp}
             * @param readFromTimestamp The start date and time in UTC for the offset position within your MSK topic from where Firehose begins to read.
             *                          By default, this is set to timestamp when Firehose becomes Active.
             *                          <p>
             *                          If you want to create a Firehose stream with Earliest start position from SDK or CLI, you need to set the <code>ReadFromTimestamp</code> parameter to Epoch (1970-01-01T00:00:00Z).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder readFromTimestamp(java.lang.String readFromTimestamp) {
                this.readFromTimestamp = readFromTimestamp;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MSKSourceConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MSKSourceConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MSKSourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MSKSourceConfigurationProperty {
            private final java.lang.Object authenticationConfiguration;
            private final java.lang.String mskClusterArn;
            private final java.lang.String topicName;
            private final java.lang.String readFromTimestamp;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.authenticationConfiguration = software.amazon.jsii.Kernel.get(this, "authenticationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.mskClusterArn = software.amazon.jsii.Kernel.get(this, "mskClusterArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.topicName = software.amazon.jsii.Kernel.get(this, "topicName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.readFromTimestamp = software.amazon.jsii.Kernel.get(this, "readFromTimestamp", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.authenticationConfiguration = java.util.Objects.requireNonNull(builder.authenticationConfiguration, "authenticationConfiguration is required");
                this.mskClusterArn = java.util.Objects.requireNonNull(builder.mskClusterArn, "mskClusterArn is required");
                this.topicName = java.util.Objects.requireNonNull(builder.topicName, "topicName is required");
                this.readFromTimestamp = builder.readFromTimestamp;
            }

            @Override
            public final java.lang.Object getAuthenticationConfiguration() {
                return this.authenticationConfiguration;
            }

            @Override
            public final java.lang.String getMskClusterArn() {
                return this.mskClusterArn;
            }

            @Override
            public final java.lang.String getTopicName() {
                return this.topicName;
            }

            @Override
            public final java.lang.String getReadFromTimestamp() {
                return this.readFromTimestamp;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("authenticationConfiguration", om.valueToTree(this.getAuthenticationConfiguration()));
                data.set("mskClusterArn", om.valueToTree(this.getMskClusterArn()));
                data.set("topicName", om.valueToTree(this.getTopicName()));
                if (this.getReadFromTimestamp() != null) {
                    data.set("readFromTimestamp", om.valueToTree(this.getReadFromTimestamp()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.MSKSourceConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MSKSourceConfigurationProperty.Jsii$Proxy that = (MSKSourceConfigurationProperty.Jsii$Proxy) o;

                if (!authenticationConfiguration.equals(that.authenticationConfiguration)) return false;
                if (!mskClusterArn.equals(that.mskClusterArn)) return false;
                if (!topicName.equals(that.topicName)) return false;
                return this.readFromTimestamp != null ? this.readFromTimestamp.equals(that.readFromTimestamp) : that.readFromTimestamp == null;
            }

            @Override
            public final int hashCode() {
                int result = this.authenticationConfiguration.hashCode();
                result = 31 * result + (this.mskClusterArn.hashCode());
                result = 31 * result + (this.topicName.hashCode());
                result = 31 * result + (this.readFromTimestamp != null ? this.readFromTimestamp.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The OpenX SerDe.
     * <p>
     * Used by Firehose for deserializing data, which means converting it from the JSON format in preparation for serializing it to the Parquet or ORC format. This is one of two deserializers you can choose, depending on which one offers the functionality you need. The other option is the native Hive / HCatalog JsonSerDe.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * OpenXJsonSerDeProperty openXJsonSerDeProperty = OpenXJsonSerDeProperty.builder()
     *         .caseInsensitive(false)
     *         .columnToJsonKeyMappings(Map.of(
     *                 "columnToJsonKeyMappingsKey", "columnToJsonKeyMappings"))
     *         .convertDotsInJsonKeysToUnderscores(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-openxjsonserde.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-openxjsonserde.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.OpenXJsonSerDeProperty")
    @software.amazon.jsii.Jsii.Proxy(OpenXJsonSerDeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OpenXJsonSerDeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * When set to <code>true</code> , which is the default, Firehose converts JSON keys to lowercase before deserializing them.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-openxjsonserde.html#cfn-kinesisfirehose-deliverystream-openxjsonserde-caseinsensitive">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-openxjsonserde.html#cfn-kinesisfirehose-deliverystream-openxjsonserde-caseinsensitive</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCaseInsensitive() {
            return null;
        }

        /**
         * Maps column names to JSON keys that aren't identical to the column names.
         * <p>
         * This is useful when the JSON contains keys that are Hive keywords. For example, <code>timestamp</code> is a Hive keyword. If you have a JSON key named <code>timestamp</code> , set this parameter to <code>{"ts": "timestamp"}</code> to map this key to a column named <code>ts</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-openxjsonserde.html#cfn-kinesisfirehose-deliverystream-openxjsonserde-columntojsonkeymappings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-openxjsonserde.html#cfn-kinesisfirehose-deliverystream-openxjsonserde-columntojsonkeymappings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getColumnToJsonKeyMappings() {
            return null;
        }

        /**
         * When set to <code>true</code> , specifies that the names of the keys include dots and that you want Firehose to replace them with underscores.
         * <p>
         * This is useful because Apache Hive does not allow dots in column names. For example, if the JSON contains a key whose name is "a.b", you can define the column name to be "a_b" when using this option.
         * <p>
         * The default is <code>false</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-openxjsonserde.html#cfn-kinesisfirehose-deliverystream-openxjsonserde-convertdotsinjsonkeystounderscores">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-openxjsonserde.html#cfn-kinesisfirehose-deliverystream-openxjsonserde-convertdotsinjsonkeystounderscores</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConvertDotsInJsonKeysToUnderscores() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OpenXJsonSerDeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OpenXJsonSerDeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OpenXJsonSerDeProperty> {
            java.lang.Object caseInsensitive;
            java.lang.Object columnToJsonKeyMappings;
            java.lang.Object convertDotsInJsonKeysToUnderscores;

            /**
             * Sets the value of {@link OpenXJsonSerDeProperty#getCaseInsensitive}
             * @param caseInsensitive When set to <code>true</code> , which is the default, Firehose converts JSON keys to lowercase before deserializing them.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder caseInsensitive(java.lang.Boolean caseInsensitive) {
                this.caseInsensitive = caseInsensitive;
                return this;
            }

            /**
             * Sets the value of {@link OpenXJsonSerDeProperty#getCaseInsensitive}
             * @param caseInsensitive When set to <code>true</code> , which is the default, Firehose converts JSON keys to lowercase before deserializing them.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder caseInsensitive(software.amazon.awscdk.IResolvable caseInsensitive) {
                this.caseInsensitive = caseInsensitive;
                return this;
            }

            /**
             * Sets the value of {@link OpenXJsonSerDeProperty#getColumnToJsonKeyMappings}
             * @param columnToJsonKeyMappings Maps column names to JSON keys that aren't identical to the column names.
             *                                This is useful when the JSON contains keys that are Hive keywords. For example, <code>timestamp</code> is a Hive keyword. If you have a JSON key named <code>timestamp</code> , set this parameter to <code>{"ts": "timestamp"}</code> to map this key to a column named <code>ts</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnToJsonKeyMappings(java.util.Map<java.lang.String, java.lang.String> columnToJsonKeyMappings) {
                this.columnToJsonKeyMappings = columnToJsonKeyMappings;
                return this;
            }

            /**
             * Sets the value of {@link OpenXJsonSerDeProperty#getColumnToJsonKeyMappings}
             * @param columnToJsonKeyMappings Maps column names to JSON keys that aren't identical to the column names.
             *                                This is useful when the JSON contains keys that are Hive keywords. For example, <code>timestamp</code> is a Hive keyword. If you have a JSON key named <code>timestamp</code> , set this parameter to <code>{"ts": "timestamp"}</code> to map this key to a column named <code>ts</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnToJsonKeyMappings(software.amazon.awscdk.IResolvable columnToJsonKeyMappings) {
                this.columnToJsonKeyMappings = columnToJsonKeyMappings;
                return this;
            }

            /**
             * Sets the value of {@link OpenXJsonSerDeProperty#getConvertDotsInJsonKeysToUnderscores}
             * @param convertDotsInJsonKeysToUnderscores When set to <code>true</code> , specifies that the names of the keys include dots and that you want Firehose to replace them with underscores.
             *                                           This is useful because Apache Hive does not allow dots in column names. For example, if the JSON contains a key whose name is "a.b", you can define the column name to be "a_b" when using this option.
             *                                           <p>
             *                                           The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder convertDotsInJsonKeysToUnderscores(java.lang.Boolean convertDotsInJsonKeysToUnderscores) {
                this.convertDotsInJsonKeysToUnderscores = convertDotsInJsonKeysToUnderscores;
                return this;
            }

            /**
             * Sets the value of {@link OpenXJsonSerDeProperty#getConvertDotsInJsonKeysToUnderscores}
             * @param convertDotsInJsonKeysToUnderscores When set to <code>true</code> , specifies that the names of the keys include dots and that you want Firehose to replace them with underscores.
             *                                           This is useful because Apache Hive does not allow dots in column names. For example, if the JSON contains a key whose name is "a.b", you can define the column name to be "a_b" when using this option.
             *                                           <p>
             *                                           The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder convertDotsInJsonKeysToUnderscores(software.amazon.awscdk.IResolvable convertDotsInJsonKeysToUnderscores) {
                this.convertDotsInJsonKeysToUnderscores = convertDotsInJsonKeysToUnderscores;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OpenXJsonSerDeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OpenXJsonSerDeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OpenXJsonSerDeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OpenXJsonSerDeProperty {
            private final java.lang.Object caseInsensitive;
            private final java.lang.Object columnToJsonKeyMappings;
            private final java.lang.Object convertDotsInJsonKeysToUnderscores;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.caseInsensitive = software.amazon.jsii.Kernel.get(this, "caseInsensitive", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.columnToJsonKeyMappings = software.amazon.jsii.Kernel.get(this, "columnToJsonKeyMappings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.convertDotsInJsonKeysToUnderscores = software.amazon.jsii.Kernel.get(this, "convertDotsInJsonKeysToUnderscores", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.caseInsensitive = builder.caseInsensitive;
                this.columnToJsonKeyMappings = builder.columnToJsonKeyMappings;
                this.convertDotsInJsonKeysToUnderscores = builder.convertDotsInJsonKeysToUnderscores;
            }

            @Override
            public final java.lang.Object getCaseInsensitive() {
                return this.caseInsensitive;
            }

            @Override
            public final java.lang.Object getColumnToJsonKeyMappings() {
                return this.columnToJsonKeyMappings;
            }

            @Override
            public final java.lang.Object getConvertDotsInJsonKeysToUnderscores() {
                return this.convertDotsInJsonKeysToUnderscores;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCaseInsensitive() != null) {
                    data.set("caseInsensitive", om.valueToTree(this.getCaseInsensitive()));
                }
                if (this.getColumnToJsonKeyMappings() != null) {
                    data.set("columnToJsonKeyMappings", om.valueToTree(this.getColumnToJsonKeyMappings()));
                }
                if (this.getConvertDotsInJsonKeysToUnderscores() != null) {
                    data.set("convertDotsInJsonKeysToUnderscores", om.valueToTree(this.getConvertDotsInJsonKeysToUnderscores()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.OpenXJsonSerDeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OpenXJsonSerDeProperty.Jsii$Proxy that = (OpenXJsonSerDeProperty.Jsii$Proxy) o;

                if (this.caseInsensitive != null ? !this.caseInsensitive.equals(that.caseInsensitive) : that.caseInsensitive != null) return false;
                if (this.columnToJsonKeyMappings != null ? !this.columnToJsonKeyMappings.equals(that.columnToJsonKeyMappings) : that.columnToJsonKeyMappings != null) return false;
                return this.convertDotsInJsonKeysToUnderscores != null ? this.convertDotsInJsonKeysToUnderscores.equals(that.convertDotsInJsonKeysToUnderscores) : that.convertDotsInJsonKeysToUnderscores == null;
            }

            @Override
            public final int hashCode() {
                int result = this.caseInsensitive != null ? this.caseInsensitive.hashCode() : 0;
                result = 31 * result + (this.columnToJsonKeyMappings != null ? this.columnToJsonKeyMappings.hashCode() : 0);
                result = 31 * result + (this.convertDotsInJsonKeysToUnderscores != null ? this.convertDotsInJsonKeysToUnderscores.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A serializer to use for converting data to the ORC format before storing it in Amazon S3.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/https://orc.apache.org/docs/">Apache ORC</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * OrcSerDeProperty orcSerDeProperty = OrcSerDeProperty.builder()
     *         .blockSizeBytes(123)
     *         .bloomFilterColumns(List.of("bloomFilterColumns"))
     *         .bloomFilterFalsePositiveProbability(123)
     *         .compression("compression")
     *         .dictionaryKeyThreshold(123)
     *         .enablePadding(false)
     *         .formatVersion("formatVersion")
     *         .paddingTolerance(123)
     *         .rowIndexStride(123)
     *         .stripeSizeBytes(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.OrcSerDeProperty")
    @software.amazon.jsii.Jsii.Proxy(OrcSerDeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OrcSerDeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Hadoop Distributed File System (HDFS) block size.
         * <p>
         * This is useful if you intend to copy the data from Amazon S3 to HDFS before querying. The default is 256 MiB and the minimum is 64 MiB. Firehose uses this value for padding calculations.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-blocksizebytes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-blocksizebytes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getBlockSizeBytes() {
            return null;
        }

        /**
         * The column names for which you want Firehose to create bloom filters.
         * <p>
         * The default is <code>null</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-bloomfiltercolumns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-bloomfiltercolumns</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getBloomFilterColumns() {
            return null;
        }

        /**
         * The Bloom filter false positive probability (FPP).
         * <p>
         * The lower the FPP, the bigger the Bloom filter. The default value is 0.05, the minimum is 0, and the maximum is 1.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-bloomfilterfalsepositiveprobability">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-bloomfilterfalsepositiveprobability</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getBloomFilterFalsePositiveProbability() {
            return null;
        }

        /**
         * The compression code to use over data blocks.
         * <p>
         * The default is <code>SNAPPY</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-compression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-compression</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCompression() {
            return null;
        }

        /**
         * Represents the fraction of the total number of non-null rows.
         * <p>
         * To turn off dictionary encoding, set this fraction to a number that is less than the number of distinct keys in a dictionary. To always use dictionary encoding, set this threshold to 1.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-dictionarykeythreshold">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-dictionarykeythreshold</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDictionaryKeyThreshold() {
            return null;
        }

        /**
         * Set this to <code>true</code> to indicate that you want stripes to be padded to the HDFS block boundaries.
         * <p>
         * This is useful if you intend to copy the data from Amazon S3 to HDFS before querying. The default is <code>false</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-enablepadding">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-enablepadding</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnablePadding() {
            return null;
        }

        /**
         * The version of the file to write.
         * <p>
         * The possible values are <code>V0_11</code> and <code>V0_12</code> . The default is <code>V0_12</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-formatversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-formatversion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFormatVersion() {
            return null;
        }

        /**
         * A number between 0 and 1 that defines the tolerance for block padding as a decimal fraction of stripe size.
         * <p>
         * The default value is 0.05, which means 5 percent of stripe size.
         * <p>
         * For the default values of 64 MiB ORC stripes and 256 MiB HDFS blocks, the default block padding tolerance of 5 percent reserves a maximum of 3.2 MiB for padding within the 256 MiB block. In such a case, if the available size within the block is more than 3.2 MiB, a new, smaller stripe is inserted to fit within that space. This ensures that no stripe crosses block boundaries and causes remote reads within a node-local task.
         * <p>
         * Kinesis Data Firehose ignores this parameter when <code>EnablePadding</code> is <code>false</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-paddingtolerance">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-paddingtolerance</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPaddingTolerance() {
            return null;
        }

        /**
         * The number of rows between index entries.
         * <p>
         * The default is 10,000 and the minimum is 1,000.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-rowindexstride">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-rowindexstride</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getRowIndexStride() {
            return null;
        }

        /**
         * The number of bytes in each stripe.
         * <p>
         * The default is 64 MiB and the minimum is 8 MiB.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-stripesizebytes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-stripesizebytes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getStripeSizeBytes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OrcSerDeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OrcSerDeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OrcSerDeProperty> {
            java.lang.Number blockSizeBytes;
            java.util.List<java.lang.String> bloomFilterColumns;
            java.lang.Number bloomFilterFalsePositiveProbability;
            java.lang.String compression;
            java.lang.Number dictionaryKeyThreshold;
            java.lang.Object enablePadding;
            java.lang.String formatVersion;
            java.lang.Number paddingTolerance;
            java.lang.Number rowIndexStride;
            java.lang.Number stripeSizeBytes;

            /**
             * Sets the value of {@link OrcSerDeProperty#getBlockSizeBytes}
             * @param blockSizeBytes The Hadoop Distributed File System (HDFS) block size.
             *                       This is useful if you intend to copy the data from Amazon S3 to HDFS before querying. The default is 256 MiB and the minimum is 64 MiB. Firehose uses this value for padding calculations.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder blockSizeBytes(java.lang.Number blockSizeBytes) {
                this.blockSizeBytes = blockSizeBytes;
                return this;
            }

            /**
             * Sets the value of {@link OrcSerDeProperty#getBloomFilterColumns}
             * @param bloomFilterColumns The column names for which you want Firehose to create bloom filters.
             *                           The default is <code>null</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bloomFilterColumns(java.util.List<java.lang.String> bloomFilterColumns) {
                this.bloomFilterColumns = bloomFilterColumns;
                return this;
            }

            /**
             * Sets the value of {@link OrcSerDeProperty#getBloomFilterFalsePositiveProbability}
             * @param bloomFilterFalsePositiveProbability The Bloom filter false positive probability (FPP).
             *                                            The lower the FPP, the bigger the Bloom filter. The default value is 0.05, the minimum is 0, and the maximum is 1.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bloomFilterFalsePositiveProbability(java.lang.Number bloomFilterFalsePositiveProbability) {
                this.bloomFilterFalsePositiveProbability = bloomFilterFalsePositiveProbability;
                return this;
            }

            /**
             * Sets the value of {@link OrcSerDeProperty#getCompression}
             * @param compression The compression code to use over data blocks.
             *                    The default is <code>SNAPPY</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder compression(java.lang.String compression) {
                this.compression = compression;
                return this;
            }

            /**
             * Sets the value of {@link OrcSerDeProperty#getDictionaryKeyThreshold}
             * @param dictionaryKeyThreshold Represents the fraction of the total number of non-null rows.
             *                               To turn off dictionary encoding, set this fraction to a number that is less than the number of distinct keys in a dictionary. To always use dictionary encoding, set this threshold to 1.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dictionaryKeyThreshold(java.lang.Number dictionaryKeyThreshold) {
                this.dictionaryKeyThreshold = dictionaryKeyThreshold;
                return this;
            }

            /**
             * Sets the value of {@link OrcSerDeProperty#getEnablePadding}
             * @param enablePadding Set this to <code>true</code> to indicate that you want stripes to be padded to the HDFS block boundaries.
             *                      This is useful if you intend to copy the data from Amazon S3 to HDFS before querying. The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enablePadding(java.lang.Boolean enablePadding) {
                this.enablePadding = enablePadding;
                return this;
            }

            /**
             * Sets the value of {@link OrcSerDeProperty#getEnablePadding}
             * @param enablePadding Set this to <code>true</code> to indicate that you want stripes to be padded to the HDFS block boundaries.
             *                      This is useful if you intend to copy the data from Amazon S3 to HDFS before querying. The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enablePadding(software.amazon.awscdk.IResolvable enablePadding) {
                this.enablePadding = enablePadding;
                return this;
            }

            /**
             * Sets the value of {@link OrcSerDeProperty#getFormatVersion}
             * @param formatVersion The version of the file to write.
             *                      The possible values are <code>V0_11</code> and <code>V0_12</code> . The default is <code>V0_12</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder formatVersion(java.lang.String formatVersion) {
                this.formatVersion = formatVersion;
                return this;
            }

            /**
             * Sets the value of {@link OrcSerDeProperty#getPaddingTolerance}
             * @param paddingTolerance A number between 0 and 1 that defines the tolerance for block padding as a decimal fraction of stripe size.
             *                         The default value is 0.05, which means 5 percent of stripe size.
             *                         <p>
             *                         For the default values of 64 MiB ORC stripes and 256 MiB HDFS blocks, the default block padding tolerance of 5 percent reserves a maximum of 3.2 MiB for padding within the 256 MiB block. In such a case, if the available size within the block is more than 3.2 MiB, a new, smaller stripe is inserted to fit within that space. This ensures that no stripe crosses block boundaries and causes remote reads within a node-local task.
             *                         <p>
             *                         Kinesis Data Firehose ignores this parameter when <code>EnablePadding</code> is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder paddingTolerance(java.lang.Number paddingTolerance) {
                this.paddingTolerance = paddingTolerance;
                return this;
            }

            /**
             * Sets the value of {@link OrcSerDeProperty#getRowIndexStride}
             * @param rowIndexStride The number of rows between index entries.
             *                       The default is 10,000 and the minimum is 1,000.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rowIndexStride(java.lang.Number rowIndexStride) {
                this.rowIndexStride = rowIndexStride;
                return this;
            }

            /**
             * Sets the value of {@link OrcSerDeProperty#getStripeSizeBytes}
             * @param stripeSizeBytes The number of bytes in each stripe.
             *                        The default is 64 MiB and the minimum is 8 MiB.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stripeSizeBytes(java.lang.Number stripeSizeBytes) {
                this.stripeSizeBytes = stripeSizeBytes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OrcSerDeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OrcSerDeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OrcSerDeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OrcSerDeProperty {
            private final java.lang.Number blockSizeBytes;
            private final java.util.List<java.lang.String> bloomFilterColumns;
            private final java.lang.Number bloomFilterFalsePositiveProbability;
            private final java.lang.String compression;
            private final java.lang.Number dictionaryKeyThreshold;
            private final java.lang.Object enablePadding;
            private final java.lang.String formatVersion;
            private final java.lang.Number paddingTolerance;
            private final java.lang.Number rowIndexStride;
            private final java.lang.Number stripeSizeBytes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.blockSizeBytes = software.amazon.jsii.Kernel.get(this, "blockSizeBytes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.bloomFilterColumns = software.amazon.jsii.Kernel.get(this, "bloomFilterColumns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.bloomFilterFalsePositiveProbability = software.amazon.jsii.Kernel.get(this, "bloomFilterFalsePositiveProbability", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.compression = software.amazon.jsii.Kernel.get(this, "compression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dictionaryKeyThreshold = software.amazon.jsii.Kernel.get(this, "dictionaryKeyThreshold", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.enablePadding = software.amazon.jsii.Kernel.get(this, "enablePadding", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.formatVersion = software.amazon.jsii.Kernel.get(this, "formatVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.paddingTolerance = software.amazon.jsii.Kernel.get(this, "paddingTolerance", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.rowIndexStride = software.amazon.jsii.Kernel.get(this, "rowIndexStride", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.stripeSizeBytes = software.amazon.jsii.Kernel.get(this, "stripeSizeBytes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.blockSizeBytes = builder.blockSizeBytes;
                this.bloomFilterColumns = builder.bloomFilterColumns;
                this.bloomFilterFalsePositiveProbability = builder.bloomFilterFalsePositiveProbability;
                this.compression = builder.compression;
                this.dictionaryKeyThreshold = builder.dictionaryKeyThreshold;
                this.enablePadding = builder.enablePadding;
                this.formatVersion = builder.formatVersion;
                this.paddingTolerance = builder.paddingTolerance;
                this.rowIndexStride = builder.rowIndexStride;
                this.stripeSizeBytes = builder.stripeSizeBytes;
            }

            @Override
            public final java.lang.Number getBlockSizeBytes() {
                return this.blockSizeBytes;
            }

            @Override
            public final java.util.List<java.lang.String> getBloomFilterColumns() {
                return this.bloomFilterColumns;
            }

            @Override
            public final java.lang.Number getBloomFilterFalsePositiveProbability() {
                return this.bloomFilterFalsePositiveProbability;
            }

            @Override
            public final java.lang.String getCompression() {
                return this.compression;
            }

            @Override
            public final java.lang.Number getDictionaryKeyThreshold() {
                return this.dictionaryKeyThreshold;
            }

            @Override
            public final java.lang.Object getEnablePadding() {
                return this.enablePadding;
            }

            @Override
            public final java.lang.String getFormatVersion() {
                return this.formatVersion;
            }

            @Override
            public final java.lang.Number getPaddingTolerance() {
                return this.paddingTolerance;
            }

            @Override
            public final java.lang.Number getRowIndexStride() {
                return this.rowIndexStride;
            }

            @Override
            public final java.lang.Number getStripeSizeBytes() {
                return this.stripeSizeBytes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBlockSizeBytes() != null) {
                    data.set("blockSizeBytes", om.valueToTree(this.getBlockSizeBytes()));
                }
                if (this.getBloomFilterColumns() != null) {
                    data.set("bloomFilterColumns", om.valueToTree(this.getBloomFilterColumns()));
                }
                if (this.getBloomFilterFalsePositiveProbability() != null) {
                    data.set("bloomFilterFalsePositiveProbability", om.valueToTree(this.getBloomFilterFalsePositiveProbability()));
                }
                if (this.getCompression() != null) {
                    data.set("compression", om.valueToTree(this.getCompression()));
                }
                if (this.getDictionaryKeyThreshold() != null) {
                    data.set("dictionaryKeyThreshold", om.valueToTree(this.getDictionaryKeyThreshold()));
                }
                if (this.getEnablePadding() != null) {
                    data.set("enablePadding", om.valueToTree(this.getEnablePadding()));
                }
                if (this.getFormatVersion() != null) {
                    data.set("formatVersion", om.valueToTree(this.getFormatVersion()));
                }
                if (this.getPaddingTolerance() != null) {
                    data.set("paddingTolerance", om.valueToTree(this.getPaddingTolerance()));
                }
                if (this.getRowIndexStride() != null) {
                    data.set("rowIndexStride", om.valueToTree(this.getRowIndexStride()));
                }
                if (this.getStripeSizeBytes() != null) {
                    data.set("stripeSizeBytes", om.valueToTree(this.getStripeSizeBytes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.OrcSerDeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OrcSerDeProperty.Jsii$Proxy that = (OrcSerDeProperty.Jsii$Proxy) o;

                if (this.blockSizeBytes != null ? !this.blockSizeBytes.equals(that.blockSizeBytes) : that.blockSizeBytes != null) return false;
                if (this.bloomFilterColumns != null ? !this.bloomFilterColumns.equals(that.bloomFilterColumns) : that.bloomFilterColumns != null) return false;
                if (this.bloomFilterFalsePositiveProbability != null ? !this.bloomFilterFalsePositiveProbability.equals(that.bloomFilterFalsePositiveProbability) : that.bloomFilterFalsePositiveProbability != null) return false;
                if (this.compression != null ? !this.compression.equals(that.compression) : that.compression != null) return false;
                if (this.dictionaryKeyThreshold != null ? !this.dictionaryKeyThreshold.equals(that.dictionaryKeyThreshold) : that.dictionaryKeyThreshold != null) return false;
                if (this.enablePadding != null ? !this.enablePadding.equals(that.enablePadding) : that.enablePadding != null) return false;
                if (this.formatVersion != null ? !this.formatVersion.equals(that.formatVersion) : that.formatVersion != null) return false;
                if (this.paddingTolerance != null ? !this.paddingTolerance.equals(that.paddingTolerance) : that.paddingTolerance != null) return false;
                if (this.rowIndexStride != null ? !this.rowIndexStride.equals(that.rowIndexStride) : that.rowIndexStride != null) return false;
                return this.stripeSizeBytes != null ? this.stripeSizeBytes.equals(that.stripeSizeBytes) : that.stripeSizeBytes == null;
            }

            @Override
            public final int hashCode() {
                int result = this.blockSizeBytes != null ? this.blockSizeBytes.hashCode() : 0;
                result = 31 * result + (this.bloomFilterColumns != null ? this.bloomFilterColumns.hashCode() : 0);
                result = 31 * result + (this.bloomFilterFalsePositiveProbability != null ? this.bloomFilterFalsePositiveProbability.hashCode() : 0);
                result = 31 * result + (this.compression != null ? this.compression.hashCode() : 0);
                result = 31 * result + (this.dictionaryKeyThreshold != null ? this.dictionaryKeyThreshold.hashCode() : 0);
                result = 31 * result + (this.enablePadding != null ? this.enablePadding.hashCode() : 0);
                result = 31 * result + (this.formatVersion != null ? this.formatVersion.hashCode() : 0);
                result = 31 * result + (this.paddingTolerance != null ? this.paddingTolerance.hashCode() : 0);
                result = 31 * result + (this.rowIndexStride != null ? this.rowIndexStride.hashCode() : 0);
                result = 31 * result + (this.stripeSizeBytes != null ? this.stripeSizeBytes.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the serializer that you want Firehose to use to convert the format of your data before it writes it to Amazon S3.
     * <p>
     * This parameter is required if <code>Enabled</code> is set to true.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * OutputFormatConfigurationProperty outputFormatConfigurationProperty = OutputFormatConfigurationProperty.builder()
     *         .serializer(SerializerProperty.builder()
     *                 .orcSerDe(OrcSerDeProperty.builder()
     *                         .blockSizeBytes(123)
     *                         .bloomFilterColumns(List.of("bloomFilterColumns"))
     *                         .bloomFilterFalsePositiveProbability(123)
     *                         .compression("compression")
     *                         .dictionaryKeyThreshold(123)
     *                         .enablePadding(false)
     *                         .formatVersion("formatVersion")
     *                         .paddingTolerance(123)
     *                         .rowIndexStride(123)
     *                         .stripeSizeBytes(123)
     *                         .build())
     *                 .parquetSerDe(ParquetSerDeProperty.builder()
     *                         .blockSizeBytes(123)
     *                         .compression("compression")
     *                         .enableDictionaryCompression(false)
     *                         .maxPaddingBytes(123)
     *                         .pageSizeBytes(123)
     *                         .writerVersion("writerVersion")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-outputformatconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-outputformatconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.OutputFormatConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(OutputFormatConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OutputFormatConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies which serializer to use.
         * <p>
         * You can choose either the ORC SerDe or the Parquet SerDe. If both are non-null, the server rejects the request.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-outputformatconfiguration.html#cfn-kinesisfirehose-deliverystream-outputformatconfiguration-serializer">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-outputformatconfiguration.html#cfn-kinesisfirehose-deliverystream-outputformatconfiguration-serializer</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSerializer() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OutputFormatConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OutputFormatConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OutputFormatConfigurationProperty> {
            java.lang.Object serializer;

            /**
             * Sets the value of {@link OutputFormatConfigurationProperty#getSerializer}
             * @param serializer Specifies which serializer to use.
             *                   You can choose either the ORC SerDe or the Parquet SerDe. If both are non-null, the server rejects the request.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serializer(software.amazon.awscdk.IResolvable serializer) {
                this.serializer = serializer;
                return this;
            }

            /**
             * Sets the value of {@link OutputFormatConfigurationProperty#getSerializer}
             * @param serializer Specifies which serializer to use.
             *                   You can choose either the ORC SerDe or the Parquet SerDe. If both are non-null, the server rejects the request.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serializer(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.SerializerProperty serializer) {
                this.serializer = serializer;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OutputFormatConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OutputFormatConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OutputFormatConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OutputFormatConfigurationProperty {
            private final java.lang.Object serializer;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.serializer = software.amazon.jsii.Kernel.get(this, "serializer", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.serializer = builder.serializer;
            }

            @Override
            public final java.lang.Object getSerializer() {
                return this.serializer;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSerializer() != null) {
                    data.set("serializer", om.valueToTree(this.getSerializer()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.OutputFormatConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OutputFormatConfigurationProperty.Jsii$Proxy that = (OutputFormatConfigurationProperty.Jsii$Proxy) o;

                return this.serializer != null ? this.serializer.equals(that.serializer) : that.serializer == null;
            }

            @Override
            public final int hashCode() {
                int result = this.serializer != null ? this.serializer.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * A serializer to use for converting data to the Parquet format before storing it in Amazon S3.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/https://parquet.apache.org/docs/">Apache Parquet</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * ParquetSerDeProperty parquetSerDeProperty = ParquetSerDeProperty.builder()
     *         .blockSizeBytes(123)
     *         .compression("compression")
     *         .enableDictionaryCompression(false)
     *         .maxPaddingBytes(123)
     *         .pageSizeBytes(123)
     *         .writerVersion("writerVersion")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-parquetserde.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-parquetserde.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.ParquetSerDeProperty")
    @software.amazon.jsii.Jsii.Proxy(ParquetSerDeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ParquetSerDeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Hadoop Distributed File System (HDFS) block size.
         * <p>
         * This is useful if you intend to copy the data from Amazon S3 to HDFS before querying. The default is 256 MiB and the minimum is 64 MiB. Firehose uses this value for padding calculations.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-parquetserde.html#cfn-kinesisfirehose-deliverystream-parquetserde-blocksizebytes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-parquetserde.html#cfn-kinesisfirehose-deliverystream-parquetserde-blocksizebytes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getBlockSizeBytes() {
            return null;
        }

        /**
         * The compression code to use over data blocks.
         * <p>
         * The possible values are <code>UNCOMPRESSED</code> , <code>SNAPPY</code> , and <code>GZIP</code> , with the default being <code>SNAPPY</code> . Use <code>SNAPPY</code> for higher decompression speed. Use <code>GZIP</code> if the compression ratio is more important than speed.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-parquetserde.html#cfn-kinesisfirehose-deliverystream-parquetserde-compression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-parquetserde.html#cfn-kinesisfirehose-deliverystream-parquetserde-compression</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCompression() {
            return null;
        }

        /**
         * Indicates whether to enable dictionary compression.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-parquetserde.html#cfn-kinesisfirehose-deliverystream-parquetserde-enabledictionarycompression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-parquetserde.html#cfn-kinesisfirehose-deliverystream-parquetserde-enabledictionarycompression</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnableDictionaryCompression() {
            return null;
        }

        /**
         * The maximum amount of padding to apply.
         * <p>
         * This is useful if you intend to copy the data from Amazon S3 to HDFS before querying. The default is 0.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-parquetserde.html#cfn-kinesisfirehose-deliverystream-parquetserde-maxpaddingbytes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-parquetserde.html#cfn-kinesisfirehose-deliverystream-parquetserde-maxpaddingbytes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxPaddingBytes() {
            return null;
        }

        /**
         * The Parquet page size.
         * <p>
         * Column chunks are divided into pages. A page is conceptually an indivisible unit (in terms of compression and encoding). The minimum value is 64 KiB and the default is 1 MiB.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-parquetserde.html#cfn-kinesisfirehose-deliverystream-parquetserde-pagesizebytes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-parquetserde.html#cfn-kinesisfirehose-deliverystream-parquetserde-pagesizebytes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPageSizeBytes() {
            return null;
        }

        /**
         * Indicates the version of row format to output.
         * <p>
         * The possible values are <code>V1</code> and <code>V2</code> . The default is <code>V1</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-parquetserde.html#cfn-kinesisfirehose-deliverystream-parquetserde-writerversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-parquetserde.html#cfn-kinesisfirehose-deliverystream-parquetserde-writerversion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getWriterVersion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ParquetSerDeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ParquetSerDeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ParquetSerDeProperty> {
            java.lang.Number blockSizeBytes;
            java.lang.String compression;
            java.lang.Object enableDictionaryCompression;
            java.lang.Number maxPaddingBytes;
            java.lang.Number pageSizeBytes;
            java.lang.String writerVersion;

            /**
             * Sets the value of {@link ParquetSerDeProperty#getBlockSizeBytes}
             * @param blockSizeBytes The Hadoop Distributed File System (HDFS) block size.
             *                       This is useful if you intend to copy the data from Amazon S3 to HDFS before querying. The default is 256 MiB and the minimum is 64 MiB. Firehose uses this value for padding calculations.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder blockSizeBytes(java.lang.Number blockSizeBytes) {
                this.blockSizeBytes = blockSizeBytes;
                return this;
            }

            /**
             * Sets the value of {@link ParquetSerDeProperty#getCompression}
             * @param compression The compression code to use over data blocks.
             *                    The possible values are <code>UNCOMPRESSED</code> , <code>SNAPPY</code> , and <code>GZIP</code> , with the default being <code>SNAPPY</code> . Use <code>SNAPPY</code> for higher decompression speed. Use <code>GZIP</code> if the compression ratio is more important than speed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder compression(java.lang.String compression) {
                this.compression = compression;
                return this;
            }

            /**
             * Sets the value of {@link ParquetSerDeProperty#getEnableDictionaryCompression}
             * @param enableDictionaryCompression Indicates whether to enable dictionary compression.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableDictionaryCompression(java.lang.Boolean enableDictionaryCompression) {
                this.enableDictionaryCompression = enableDictionaryCompression;
                return this;
            }

            /**
             * Sets the value of {@link ParquetSerDeProperty#getEnableDictionaryCompression}
             * @param enableDictionaryCompression Indicates whether to enable dictionary compression.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableDictionaryCompression(software.amazon.awscdk.IResolvable enableDictionaryCompression) {
                this.enableDictionaryCompression = enableDictionaryCompression;
                return this;
            }

            /**
             * Sets the value of {@link ParquetSerDeProperty#getMaxPaddingBytes}
             * @param maxPaddingBytes The maximum amount of padding to apply.
             *                        This is useful if you intend to copy the data from Amazon S3 to HDFS before querying. The default is 0.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxPaddingBytes(java.lang.Number maxPaddingBytes) {
                this.maxPaddingBytes = maxPaddingBytes;
                return this;
            }

            /**
             * Sets the value of {@link ParquetSerDeProperty#getPageSizeBytes}
             * @param pageSizeBytes The Parquet page size.
             *                      Column chunks are divided into pages. A page is conceptually an indivisible unit (in terms of compression and encoding). The minimum value is 64 KiB and the default is 1 MiB.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pageSizeBytes(java.lang.Number pageSizeBytes) {
                this.pageSizeBytes = pageSizeBytes;
                return this;
            }

            /**
             * Sets the value of {@link ParquetSerDeProperty#getWriterVersion}
             * @param writerVersion Indicates the version of row format to output.
             *                      The possible values are <code>V1</code> and <code>V2</code> . The default is <code>V1</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder writerVersion(java.lang.String writerVersion) {
                this.writerVersion = writerVersion;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ParquetSerDeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ParquetSerDeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ParquetSerDeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ParquetSerDeProperty {
            private final java.lang.Number blockSizeBytes;
            private final java.lang.String compression;
            private final java.lang.Object enableDictionaryCompression;
            private final java.lang.Number maxPaddingBytes;
            private final java.lang.Number pageSizeBytes;
            private final java.lang.String writerVersion;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.blockSizeBytes = software.amazon.jsii.Kernel.get(this, "blockSizeBytes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.compression = software.amazon.jsii.Kernel.get(this, "compression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.enableDictionaryCompression = software.amazon.jsii.Kernel.get(this, "enableDictionaryCompression", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.maxPaddingBytes = software.amazon.jsii.Kernel.get(this, "maxPaddingBytes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.pageSizeBytes = software.amazon.jsii.Kernel.get(this, "pageSizeBytes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.writerVersion = software.amazon.jsii.Kernel.get(this, "writerVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.blockSizeBytes = builder.blockSizeBytes;
                this.compression = builder.compression;
                this.enableDictionaryCompression = builder.enableDictionaryCompression;
                this.maxPaddingBytes = builder.maxPaddingBytes;
                this.pageSizeBytes = builder.pageSizeBytes;
                this.writerVersion = builder.writerVersion;
            }

            @Override
            public final java.lang.Number getBlockSizeBytes() {
                return this.blockSizeBytes;
            }

            @Override
            public final java.lang.String getCompression() {
                return this.compression;
            }

            @Override
            public final java.lang.Object getEnableDictionaryCompression() {
                return this.enableDictionaryCompression;
            }

            @Override
            public final java.lang.Number getMaxPaddingBytes() {
                return this.maxPaddingBytes;
            }

            @Override
            public final java.lang.Number getPageSizeBytes() {
                return this.pageSizeBytes;
            }

            @Override
            public final java.lang.String getWriterVersion() {
                return this.writerVersion;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBlockSizeBytes() != null) {
                    data.set("blockSizeBytes", om.valueToTree(this.getBlockSizeBytes()));
                }
                if (this.getCompression() != null) {
                    data.set("compression", om.valueToTree(this.getCompression()));
                }
                if (this.getEnableDictionaryCompression() != null) {
                    data.set("enableDictionaryCompression", om.valueToTree(this.getEnableDictionaryCompression()));
                }
                if (this.getMaxPaddingBytes() != null) {
                    data.set("maxPaddingBytes", om.valueToTree(this.getMaxPaddingBytes()));
                }
                if (this.getPageSizeBytes() != null) {
                    data.set("pageSizeBytes", om.valueToTree(this.getPageSizeBytes()));
                }
                if (this.getWriterVersion() != null) {
                    data.set("writerVersion", om.valueToTree(this.getWriterVersion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.ParquetSerDeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ParquetSerDeProperty.Jsii$Proxy that = (ParquetSerDeProperty.Jsii$Proxy) o;

                if (this.blockSizeBytes != null ? !this.blockSizeBytes.equals(that.blockSizeBytes) : that.blockSizeBytes != null) return false;
                if (this.compression != null ? !this.compression.equals(that.compression) : that.compression != null) return false;
                if (this.enableDictionaryCompression != null ? !this.enableDictionaryCompression.equals(that.enableDictionaryCompression) : that.enableDictionaryCompression != null) return false;
                if (this.maxPaddingBytes != null ? !this.maxPaddingBytes.equals(that.maxPaddingBytes) : that.maxPaddingBytes != null) return false;
                if (this.pageSizeBytes != null ? !this.pageSizeBytes.equals(that.pageSizeBytes) : that.pageSizeBytes != null) return false;
                return this.writerVersion != null ? this.writerVersion.equals(that.writerVersion) : that.writerVersion == null;
            }

            @Override
            public final int hashCode() {
                int result = this.blockSizeBytes != null ? this.blockSizeBytes.hashCode() : 0;
                result = 31 * result + (this.compression != null ? this.compression.hashCode() : 0);
                result = 31 * result + (this.enableDictionaryCompression != null ? this.enableDictionaryCompression.hashCode() : 0);
                result = 31 * result + (this.maxPaddingBytes != null ? this.maxPaddingBytes.hashCode() : 0);
                result = 31 * result + (this.pageSizeBytes != null ? this.pageSizeBytes.hashCode() : 0);
                result = 31 * result + (this.writerVersion != null ? this.writerVersion.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The <code>ProcessingConfiguration</code> property configures data processing for an Amazon Kinesis Data Firehose delivery stream.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * ProcessingConfigurationProperty processingConfigurationProperty = ProcessingConfigurationProperty.builder()
     *         .enabled(false)
     *         .processors(List.of(ProcessorProperty.builder()
     *                 .type("type")
     *                 // the properties below are optional
     *                 .parameters(List.of(ProcessorParameterProperty.builder()
     *                         .parameterName("parameterName")
     *                         .parameterValue("parameterValue")
     *                         .build()))
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-processingconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-processingconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.ProcessingConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ProcessingConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ProcessingConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates whether data processing is enabled (true) or disabled (false).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-processingconfiguration.html#cfn-kinesisfirehose-deliverystream-processingconfiguration-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-processingconfiguration.html#cfn-kinesisfirehose-deliverystream-processingconfiguration-enabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * The data processors.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-processingconfiguration.html#cfn-kinesisfirehose-deliverystream-processingconfiguration-processors">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-processingconfiguration.html#cfn-kinesisfirehose-deliverystream-processingconfiguration-processors</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getProcessors() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ProcessingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ProcessingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ProcessingConfigurationProperty> {
            java.lang.Object enabled;
            java.lang.Object processors;

            /**
             * Sets the value of {@link ProcessingConfigurationProperty#getEnabled}
             * @param enabled Indicates whether data processing is enabled (true) or disabled (false).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link ProcessingConfigurationProperty#getEnabled}
             * @param enabled Indicates whether data processing is enabled (true) or disabled (false).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link ProcessingConfigurationProperty#getProcessors}
             * @param processors The data processors.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder processors(software.amazon.awscdk.IResolvable processors) {
                this.processors = processors;
                return this;
            }

            /**
             * Sets the value of {@link ProcessingConfigurationProperty#getProcessors}
             * @param processors The data processors.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder processors(java.util.List<? extends java.lang.Object> processors) {
                this.processors = processors;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProcessingConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ProcessingConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ProcessingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProcessingConfigurationProperty {
            private final java.lang.Object enabled;
            private final java.lang.Object processors;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.processors = software.amazon.jsii.Kernel.get(this, "processors", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = builder.enabled;
                this.processors = builder.processors;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.Object getProcessors() {
                return this.processors;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }
                if (this.getProcessors() != null) {
                    data.set("processors", om.valueToTree(this.getProcessors()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.ProcessingConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ProcessingConfigurationProperty.Jsii$Proxy that = (ProcessingConfigurationProperty.Jsii$Proxy) o;

                if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
                return this.processors != null ? this.processors.equals(that.processors) : that.processors == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled != null ? this.enabled.hashCode() : 0;
                result = 31 * result + (this.processors != null ? this.processors.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The <code>ProcessorParameter</code> property specifies a processor parameter in a data processor for an Amazon Kinesis Data Firehose delivery stream.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * ProcessorParameterProperty processorParameterProperty = ProcessorParameterProperty.builder()
     *         .parameterName("parameterName")
     *         .parameterValue("parameterValue")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-processorparameter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-processorparameter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.ProcessorParameterProperty")
    @software.amazon.jsii.Jsii.Proxy(ProcessorParameterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ProcessorParameterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the parameter.
         * <p>
         * Currently the following default values are supported: 3 for <code>NumberOfRetries</code> and 60 for the <code>BufferIntervalInSeconds</code> . The <code>BufferSizeInMBs</code> ranges between 0.2 MB and up to 3MB. The default buffering hint is 1MB for all destinations, except Splunk. For Splunk, the default buffering hint is 256 KB.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-processorparameter.html#cfn-kinesisfirehose-deliverystream-processorparameter-parametername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-processorparameter.html#cfn-kinesisfirehose-deliverystream-processorparameter-parametername</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getParameterName();

        /**
         * The parameter value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-processorparameter.html#cfn-kinesisfirehose-deliverystream-processorparameter-parametervalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-processorparameter.html#cfn-kinesisfirehose-deliverystream-processorparameter-parametervalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getParameterValue();

        /**
         * @return a {@link Builder} of {@link ProcessorParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ProcessorParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ProcessorParameterProperty> {
            java.lang.String parameterName;
            java.lang.String parameterValue;

            /**
             * Sets the value of {@link ProcessorParameterProperty#getParameterName}
             * @param parameterName The name of the parameter. This parameter is required.
             *                      Currently the following default values are supported: 3 for <code>NumberOfRetries</code> and 60 for the <code>BufferIntervalInSeconds</code> . The <code>BufferSizeInMBs</code> ranges between 0.2 MB and up to 3MB. The default buffering hint is 1MB for all destinations, except Splunk. For Splunk, the default buffering hint is 256 KB.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parameterName(java.lang.String parameterName) {
                this.parameterName = parameterName;
                return this;
            }

            /**
             * Sets the value of {@link ProcessorParameterProperty#getParameterValue}
             * @param parameterValue The parameter value. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parameterValue(java.lang.String parameterValue) {
                this.parameterValue = parameterValue;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProcessorParameterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ProcessorParameterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ProcessorParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProcessorParameterProperty {
            private final java.lang.String parameterName;
            private final java.lang.String parameterValue;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.parameterName = software.amazon.jsii.Kernel.get(this, "parameterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.parameterValue = software.amazon.jsii.Kernel.get(this, "parameterValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.parameterName = java.util.Objects.requireNonNull(builder.parameterName, "parameterName is required");
                this.parameterValue = java.util.Objects.requireNonNull(builder.parameterValue, "parameterValue is required");
            }

            @Override
            public final java.lang.String getParameterName() {
                return this.parameterName;
            }

            @Override
            public final java.lang.String getParameterValue() {
                return this.parameterValue;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("parameterName", om.valueToTree(this.getParameterName()));
                data.set("parameterValue", om.valueToTree(this.getParameterValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.ProcessorParameterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ProcessorParameterProperty.Jsii$Proxy that = (ProcessorParameterProperty.Jsii$Proxy) o;

                if (!parameterName.equals(that.parameterName)) return false;
                return this.parameterValue.equals(that.parameterValue);
            }

            @Override
            public final int hashCode() {
                int result = this.parameterName.hashCode();
                result = 31 * result + (this.parameterValue.hashCode());
                return result;
            }
        }
    }
    /**
     * The <code>Processor</code> property specifies a data processor for an Amazon Kinesis Data Firehose delivery stream.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * ProcessorProperty processorProperty = ProcessorProperty.builder()
     *         .type("type")
     *         // the properties below are optional
     *         .parameters(List.of(ProcessorParameterProperty.builder()
     *                 .parameterName("parameterName")
     *                 .parameterValue("parameterValue")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-processor.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-processor.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.ProcessorProperty")
    @software.amazon.jsii.Jsii.Proxy(ProcessorProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ProcessorProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of processor.
         * <p>
         * Valid values: <code>Lambda</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-processor.html#cfn-kinesisfirehose-deliverystream-processor-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-processor.html#cfn-kinesisfirehose-deliverystream-processor-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * The processor parameters.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-processor.html#cfn-kinesisfirehose-deliverystream-processor-parameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-processor.html#cfn-kinesisfirehose-deliverystream-processor-parameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getParameters() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ProcessorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ProcessorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ProcessorProperty> {
            java.lang.String type;
            java.lang.Object parameters;

            /**
             * Sets the value of {@link ProcessorProperty#getType}
             * @param type The type of processor. This parameter is required.
             *             Valid values: <code>Lambda</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link ProcessorProperty#getParameters}
             * @param parameters The processor parameters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parameters(software.amazon.awscdk.IResolvable parameters) {
                this.parameters = parameters;
                return this;
            }

            /**
             * Sets the value of {@link ProcessorProperty#getParameters}
             * @param parameters The processor parameters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parameters(java.util.List<? extends java.lang.Object> parameters) {
                this.parameters = parameters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProcessorProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ProcessorProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ProcessorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProcessorProperty {
            private final java.lang.String type;
            private final java.lang.Object parameters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.parameters = software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.parameters = builder.parameters;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.Object getParameters() {
                return this.parameters;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                if (this.getParameters() != null) {
                    data.set("parameters", om.valueToTree(this.getParameters()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.ProcessorProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ProcessorProperty.Jsii$Proxy that = (ProcessorProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                return this.parameters != null ? this.parameters.equals(that.parameters) : that.parameters == null;
            }

            @Override
            public final int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The <code>RedshiftDestinationConfiguration</code> property type specifies an Amazon Redshift cluster to which Amazon Kinesis Data Firehose (Kinesis Data Firehose) delivers data.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * RedshiftDestinationConfigurationProperty redshiftDestinationConfigurationProperty = RedshiftDestinationConfigurationProperty.builder()
     *         .clusterJdbcurl("clusterJdbcurl")
     *         .copyCommand(CopyCommandProperty.builder()
     *                 .dataTableName("dataTableName")
     *                 // the properties below are optional
     *                 .copyOptions("copyOptions")
     *                 .dataTableColumns("dataTableColumns")
     *                 .build())
     *         .roleArn("roleArn")
     *         .s3Configuration(S3DestinationConfigurationProperty.builder()
     *                 .bucketArn("bucketArn")
     *                 .roleArn("roleArn")
     *                 // the properties below are optional
     *                 .bufferingHints(BufferingHintsProperty.builder()
     *                         .intervalInSeconds(123)
     *                         .sizeInMBs(123)
     *                         .build())
     *                 .cloudWatchLoggingOptions(CloudWatchLoggingOptionsProperty.builder()
     *                         .enabled(false)
     *                         .logGroupName("logGroupName")
     *                         .logStreamName("logStreamName")
     *                         .build())
     *                 .compressionFormat("compressionFormat")
     *                 .encryptionConfiguration(EncryptionConfigurationProperty.builder()
     *                         .kmsEncryptionConfig(KMSEncryptionConfigProperty.builder()
     *                                 .awskmsKeyArn("awskmsKeyArn")
     *                                 .build())
     *                         .noEncryptionConfig("noEncryptionConfig")
     *                         .build())
     *                 .errorOutputPrefix("errorOutputPrefix")
     *                 .prefix("prefix")
     *                 .build())
     *         // the properties below are optional
     *         .cloudWatchLoggingOptions(CloudWatchLoggingOptionsProperty.builder()
     *                 .enabled(false)
     *                 .logGroupName("logGroupName")
     *                 .logStreamName("logStreamName")
     *                 .build())
     *         .password("password")
     *         .processingConfiguration(ProcessingConfigurationProperty.builder()
     *                 .enabled(false)
     *                 .processors(List.of(ProcessorProperty.builder()
     *                         .type("type")
     *                         // the properties below are optional
     *                         .parameters(List.of(ProcessorParameterProperty.builder()
     *                                 .parameterName("parameterName")
     *                                 .parameterValue("parameterValue")
     *                                 .build()))
     *                         .build()))
     *                 .build())
     *         .retryOptions(RedshiftRetryOptionsProperty.builder()
     *                 .durationInSeconds(123)
     *                 .build())
     *         .s3BackupConfiguration(S3DestinationConfigurationProperty.builder()
     *                 .bucketArn("bucketArn")
     *                 .roleArn("roleArn")
     *                 // the properties below are optional
     *                 .bufferingHints(BufferingHintsProperty.builder()
     *                         .intervalInSeconds(123)
     *                         .sizeInMBs(123)
     *                         .build())
     *                 .cloudWatchLoggingOptions(CloudWatchLoggingOptionsProperty.builder()
     *                         .enabled(false)
     *                         .logGroupName("logGroupName")
     *                         .logStreamName("logStreamName")
     *                         .build())
     *                 .compressionFormat("compressionFormat")
     *                 .encryptionConfiguration(EncryptionConfigurationProperty.builder()
     *                         .kmsEncryptionConfig(KMSEncryptionConfigProperty.builder()
     *                                 .awskmsKeyArn("awskmsKeyArn")
     *                                 .build())
     *                         .noEncryptionConfig("noEncryptionConfig")
     *                         .build())
     *                 .errorOutputPrefix("errorOutputPrefix")
     *                 .prefix("prefix")
     *                 .build())
     *         .s3BackupMode("s3BackupMode")
     *         .secretsManagerConfiguration(SecretsManagerConfigurationProperty.builder()
     *                 .enabled(false)
     *                 // the properties below are optional
     *                 .roleArn("roleArn")
     *                 .secretArn("secretArn")
     *                 .build())
     *         .username("username")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-redshiftdestinationconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-redshiftdestinationconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.RedshiftDestinationConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(RedshiftDestinationConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RedshiftDestinationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The connection string that Kinesis Data Firehose uses to connect to the Amazon Redshift cluster.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-redshiftdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-redshiftdestinationconfiguration-clusterjdbcurl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-redshiftdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-redshiftdestinationconfiguration-clusterjdbcurl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getClusterJdbcurl();

        /**
         * Configures the Amazon Redshift <code>COPY</code> command that Kinesis Data Firehose uses to load data into the cluster from the Amazon S3 bucket.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-redshiftdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-redshiftdestinationconfiguration-copycommand">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-redshiftdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-redshiftdestinationconfiguration-copycommand</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getCopyCommand();

        /**
         * The ARN of the AWS Identity and Access Management (IAM) role that grants Kinesis Data Firehose access to your Amazon S3 bucket and AWS KMS (if you enable data encryption).
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/controlling-access.html#using-iam-rs">Grant Kinesis Data Firehose Access to an Amazon Redshift Destination</a> in the <em>Amazon Kinesis Data Firehose Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-redshiftdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-redshiftdestinationconfiguration-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-redshiftdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-redshiftdestinationconfiguration-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * The S3 bucket where Kinesis Data Firehose first delivers data.
         * <p>
         * After the data is in the bucket, Kinesis Data Firehose uses the <code>COPY</code> command to load the data into the Amazon Redshift cluster. For the Amazon S3 bucket's compression format, don't specify <code>SNAPPY</code> or <code>ZIP</code> because the Amazon Redshift <code>COPY</code> command doesn't support them.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-redshiftdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-redshiftdestinationconfiguration-s3configuration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-redshiftdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-redshiftdestinationconfiguration-s3configuration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getS3Configuration();

        /**
         * The CloudWatch logging options for your Firehose stream.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-redshiftdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-redshiftdestinationconfiguration-cloudwatchloggingoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-redshiftdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-redshiftdestinationconfiguration-cloudwatchloggingoptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCloudWatchLoggingOptions() {
            return null;
        }

        /**
         * The password for the Amazon Redshift user that you specified in the <code>Username</code> property.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-redshiftdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-redshiftdestinationconfiguration-password">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-redshiftdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-redshiftdestinationconfiguration-password</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPassword() {
            return null;
        }

        /**
         * The data processing configuration for the Kinesis Data Firehose delivery stream.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-redshiftdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-redshiftdestinationconfiguration-processingconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-redshiftdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-redshiftdestinationconfiguration-processingconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getProcessingConfiguration() {
            return null;
        }

        /**
         * The retry behavior in case Firehose is unable to deliver documents to Amazon Redshift.
         * <p>
         * Default value is 3600 (60 minutes).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-redshiftdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-redshiftdestinationconfiguration-retryoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-redshiftdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-redshiftdestinationconfiguration-retryoptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRetryOptions() {
            return null;
        }

        /**
         * The configuration for backup in Amazon S3.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-redshiftdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-redshiftdestinationconfiguration-s3backupconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-redshiftdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-redshiftdestinationconfiguration-s3backupconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3BackupConfiguration() {
            return null;
        }

        /**
         * The Amazon S3 backup mode.
         * <p>
         * After you create a Firehose stream, you can update it to enable Amazon S3 backup if it is disabled. If backup is enabled, you can't update the Firehose stream to disable it.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-redshiftdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-redshiftdestinationconfiguration-s3backupmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-redshiftdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-redshiftdestinationconfiguration-s3backupmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3BackupMode() {
            return null;
        }

        /**
         * The configuration that defines how you access secrets for Amazon Redshift.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-redshiftdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-redshiftdestinationconfiguration-secretsmanagerconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-redshiftdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-redshiftdestinationconfiguration-secretsmanagerconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSecretsManagerConfiguration() {
            return null;
        }

        /**
         * The Amazon Redshift user that has permission to access the Amazon Redshift cluster.
         * <p>
         * This user must have <code>INSERT</code> privileges for copying data from the Amazon S3 bucket to the cluster.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-redshiftdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-redshiftdestinationconfiguration-username">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-redshiftdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-redshiftdestinationconfiguration-username</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUsername() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RedshiftDestinationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RedshiftDestinationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RedshiftDestinationConfigurationProperty> {
            java.lang.String clusterJdbcurl;
            java.lang.Object copyCommand;
            java.lang.String roleArn;
            java.lang.Object s3Configuration;
            java.lang.Object cloudWatchLoggingOptions;
            java.lang.String password;
            java.lang.Object processingConfiguration;
            java.lang.Object retryOptions;
            java.lang.Object s3BackupConfiguration;
            java.lang.String s3BackupMode;
            java.lang.Object secretsManagerConfiguration;
            java.lang.String username;

            /**
             * Sets the value of {@link RedshiftDestinationConfigurationProperty#getClusterJdbcurl}
             * @param clusterJdbcurl The connection string that Kinesis Data Firehose uses to connect to the Amazon Redshift cluster. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clusterJdbcurl(java.lang.String clusterJdbcurl) {
                this.clusterJdbcurl = clusterJdbcurl;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftDestinationConfigurationProperty#getCopyCommand}
             * @param copyCommand Configures the Amazon Redshift <code>COPY</code> command that Kinesis Data Firehose uses to load data into the cluster from the Amazon S3 bucket. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder copyCommand(software.amazon.awscdk.IResolvable copyCommand) {
                this.copyCommand = copyCommand;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftDestinationConfigurationProperty#getCopyCommand}
             * @param copyCommand Configures the Amazon Redshift <code>COPY</code> command that Kinesis Data Firehose uses to load data into the cluster from the Amazon S3 bucket. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder copyCommand(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.CopyCommandProperty copyCommand) {
                this.copyCommand = copyCommand;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftDestinationConfigurationProperty#getRoleArn}
             * @param roleArn The ARN of the AWS Identity and Access Management (IAM) role that grants Kinesis Data Firehose access to your Amazon S3 bucket and AWS KMS (if you enable data encryption). This parameter is required.
             *                For more information, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/controlling-access.html#using-iam-rs">Grant Kinesis Data Firehose Access to an Amazon Redshift Destination</a> in the <em>Amazon Kinesis Data Firehose Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftDestinationConfigurationProperty#getS3Configuration}
             * @param s3Configuration The S3 bucket where Kinesis Data Firehose first delivers data. This parameter is required.
             *                        After the data is in the bucket, Kinesis Data Firehose uses the <code>COPY</code> command to load the data into the Amazon Redshift cluster. For the Amazon S3 bucket's compression format, don't specify <code>SNAPPY</code> or <code>ZIP</code> because the Amazon Redshift <code>COPY</code> command doesn't support them.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Configuration(software.amazon.awscdk.IResolvable s3Configuration) {
                this.s3Configuration = s3Configuration;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftDestinationConfigurationProperty#getS3Configuration}
             * @param s3Configuration The S3 bucket where Kinesis Data Firehose first delivers data. This parameter is required.
             *                        After the data is in the bucket, Kinesis Data Firehose uses the <code>COPY</code> command to load the data into the Amazon Redshift cluster. For the Amazon S3 bucket's compression format, don't specify <code>SNAPPY</code> or <code>ZIP</code> because the Amazon Redshift <code>COPY</code> command doesn't support them.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Configuration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.S3DestinationConfigurationProperty s3Configuration) {
                this.s3Configuration = s3Configuration;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftDestinationConfigurationProperty#getCloudWatchLoggingOptions}
             * @param cloudWatchLoggingOptions The CloudWatch logging options for your Firehose stream.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchLoggingOptions(software.amazon.awscdk.IResolvable cloudWatchLoggingOptions) {
                this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftDestinationConfigurationProperty#getCloudWatchLoggingOptions}
             * @param cloudWatchLoggingOptions The CloudWatch logging options for your Firehose stream.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchLoggingOptions(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.CloudWatchLoggingOptionsProperty cloudWatchLoggingOptions) {
                this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftDestinationConfigurationProperty#getPassword}
             * @param password The password for the Amazon Redshift user that you specified in the <code>Username</code> property.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder password(java.lang.String password) {
                this.password = password;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftDestinationConfigurationProperty#getProcessingConfiguration}
             * @param processingConfiguration The data processing configuration for the Kinesis Data Firehose delivery stream.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder processingConfiguration(software.amazon.awscdk.IResolvable processingConfiguration) {
                this.processingConfiguration = processingConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftDestinationConfigurationProperty#getProcessingConfiguration}
             * @param processingConfiguration The data processing configuration for the Kinesis Data Firehose delivery stream.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder processingConfiguration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.ProcessingConfigurationProperty processingConfiguration) {
                this.processingConfiguration = processingConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftDestinationConfigurationProperty#getRetryOptions}
             * @param retryOptions The retry behavior in case Firehose is unable to deliver documents to Amazon Redshift.
             *                     Default value is 3600 (60 minutes).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retryOptions(software.amazon.awscdk.IResolvable retryOptions) {
                this.retryOptions = retryOptions;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftDestinationConfigurationProperty#getRetryOptions}
             * @param retryOptions The retry behavior in case Firehose is unable to deliver documents to Amazon Redshift.
             *                     Default value is 3600 (60 minutes).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retryOptions(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.RedshiftRetryOptionsProperty retryOptions) {
                this.retryOptions = retryOptions;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftDestinationConfigurationProperty#getS3BackupConfiguration}
             * @param s3BackupConfiguration The configuration for backup in Amazon S3.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3BackupConfiguration(software.amazon.awscdk.IResolvable s3BackupConfiguration) {
                this.s3BackupConfiguration = s3BackupConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftDestinationConfigurationProperty#getS3BackupConfiguration}
             * @param s3BackupConfiguration The configuration for backup in Amazon S3.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3BackupConfiguration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.S3DestinationConfigurationProperty s3BackupConfiguration) {
                this.s3BackupConfiguration = s3BackupConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftDestinationConfigurationProperty#getS3BackupMode}
             * @param s3BackupMode The Amazon S3 backup mode.
             *                     After you create a Firehose stream, you can update it to enable Amazon S3 backup if it is disabled. If backup is enabled, you can't update the Firehose stream to disable it.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3BackupMode(java.lang.String s3BackupMode) {
                this.s3BackupMode = s3BackupMode;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftDestinationConfigurationProperty#getSecretsManagerConfiguration}
             * @param secretsManagerConfiguration The configuration that defines how you access secrets for Amazon Redshift.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerConfiguration(software.amazon.awscdk.IResolvable secretsManagerConfiguration) {
                this.secretsManagerConfiguration = secretsManagerConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftDestinationConfigurationProperty#getSecretsManagerConfiguration}
             * @param secretsManagerConfiguration The configuration that defines how you access secrets for Amazon Redshift.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerConfiguration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.SecretsManagerConfigurationProperty secretsManagerConfiguration) {
                this.secretsManagerConfiguration = secretsManagerConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftDestinationConfigurationProperty#getUsername}
             * @param username The Amazon Redshift user that has permission to access the Amazon Redshift cluster.
             *                 This user must have <code>INSERT</code> privileges for copying data from the Amazon S3 bucket to the cluster.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder username(java.lang.String username) {
                this.username = username;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RedshiftDestinationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RedshiftDestinationConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RedshiftDestinationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RedshiftDestinationConfigurationProperty {
            private final java.lang.String clusterJdbcurl;
            private final java.lang.Object copyCommand;
            private final java.lang.String roleArn;
            private final java.lang.Object s3Configuration;
            private final java.lang.Object cloudWatchLoggingOptions;
            private final java.lang.String password;
            private final java.lang.Object processingConfiguration;
            private final java.lang.Object retryOptions;
            private final java.lang.Object s3BackupConfiguration;
            private final java.lang.String s3BackupMode;
            private final java.lang.Object secretsManagerConfiguration;
            private final java.lang.String username;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.clusterJdbcurl = software.amazon.jsii.Kernel.get(this, "clusterJdbcurl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.copyCommand = software.amazon.jsii.Kernel.get(this, "copyCommand", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3Configuration = software.amazon.jsii.Kernel.get(this, "s3Configuration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.cloudWatchLoggingOptions = software.amazon.jsii.Kernel.get(this, "cloudWatchLoggingOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.password = software.amazon.jsii.Kernel.get(this, "password", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.processingConfiguration = software.amazon.jsii.Kernel.get(this, "processingConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.retryOptions = software.amazon.jsii.Kernel.get(this, "retryOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.s3BackupConfiguration = software.amazon.jsii.Kernel.get(this, "s3BackupConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.s3BackupMode = software.amazon.jsii.Kernel.get(this, "s3BackupMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secretsManagerConfiguration = software.amazon.jsii.Kernel.get(this, "secretsManagerConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.username = software.amazon.jsii.Kernel.get(this, "username", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.clusterJdbcurl = java.util.Objects.requireNonNull(builder.clusterJdbcurl, "clusterJdbcurl is required");
                this.copyCommand = java.util.Objects.requireNonNull(builder.copyCommand, "copyCommand is required");
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
                this.s3Configuration = java.util.Objects.requireNonNull(builder.s3Configuration, "s3Configuration is required");
                this.cloudWatchLoggingOptions = builder.cloudWatchLoggingOptions;
                this.password = builder.password;
                this.processingConfiguration = builder.processingConfiguration;
                this.retryOptions = builder.retryOptions;
                this.s3BackupConfiguration = builder.s3BackupConfiguration;
                this.s3BackupMode = builder.s3BackupMode;
                this.secretsManagerConfiguration = builder.secretsManagerConfiguration;
                this.username = builder.username;
            }

            @Override
            public final java.lang.String getClusterJdbcurl() {
                return this.clusterJdbcurl;
            }

            @Override
            public final java.lang.Object getCopyCommand() {
                return this.copyCommand;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.Object getS3Configuration() {
                return this.s3Configuration;
            }

            @Override
            public final java.lang.Object getCloudWatchLoggingOptions() {
                return this.cloudWatchLoggingOptions;
            }

            @Override
            public final java.lang.String getPassword() {
                return this.password;
            }

            @Override
            public final java.lang.Object getProcessingConfiguration() {
                return this.processingConfiguration;
            }

            @Override
            public final java.lang.Object getRetryOptions() {
                return this.retryOptions;
            }

            @Override
            public final java.lang.Object getS3BackupConfiguration() {
                return this.s3BackupConfiguration;
            }

            @Override
            public final java.lang.String getS3BackupMode() {
                return this.s3BackupMode;
            }

            @Override
            public final java.lang.Object getSecretsManagerConfiguration() {
                return this.secretsManagerConfiguration;
            }

            @Override
            public final java.lang.String getUsername() {
                return this.username;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("clusterJdbcurl", om.valueToTree(this.getClusterJdbcurl()));
                data.set("copyCommand", om.valueToTree(this.getCopyCommand()));
                data.set("roleArn", om.valueToTree(this.getRoleArn()));
                data.set("s3Configuration", om.valueToTree(this.getS3Configuration()));
                if (this.getCloudWatchLoggingOptions() != null) {
                    data.set("cloudWatchLoggingOptions", om.valueToTree(this.getCloudWatchLoggingOptions()));
                }
                if (this.getPassword() != null) {
                    data.set("password", om.valueToTree(this.getPassword()));
                }
                if (this.getProcessingConfiguration() != null) {
                    data.set("processingConfiguration", om.valueToTree(this.getProcessingConfiguration()));
                }
                if (this.getRetryOptions() != null) {
                    data.set("retryOptions", om.valueToTree(this.getRetryOptions()));
                }
                if (this.getS3BackupConfiguration() != null) {
                    data.set("s3BackupConfiguration", om.valueToTree(this.getS3BackupConfiguration()));
                }
                if (this.getS3BackupMode() != null) {
                    data.set("s3BackupMode", om.valueToTree(this.getS3BackupMode()));
                }
                if (this.getSecretsManagerConfiguration() != null) {
                    data.set("secretsManagerConfiguration", om.valueToTree(this.getSecretsManagerConfiguration()));
                }
                if (this.getUsername() != null) {
                    data.set("username", om.valueToTree(this.getUsername()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.RedshiftDestinationConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RedshiftDestinationConfigurationProperty.Jsii$Proxy that = (RedshiftDestinationConfigurationProperty.Jsii$Proxy) o;

                if (!clusterJdbcurl.equals(that.clusterJdbcurl)) return false;
                if (!copyCommand.equals(that.copyCommand)) return false;
                if (!roleArn.equals(that.roleArn)) return false;
                if (!s3Configuration.equals(that.s3Configuration)) return false;
                if (this.cloudWatchLoggingOptions != null ? !this.cloudWatchLoggingOptions.equals(that.cloudWatchLoggingOptions) : that.cloudWatchLoggingOptions != null) return false;
                if (this.password != null ? !this.password.equals(that.password) : that.password != null) return false;
                if (this.processingConfiguration != null ? !this.processingConfiguration.equals(that.processingConfiguration) : that.processingConfiguration != null) return false;
                if (this.retryOptions != null ? !this.retryOptions.equals(that.retryOptions) : that.retryOptions != null) return false;
                if (this.s3BackupConfiguration != null ? !this.s3BackupConfiguration.equals(that.s3BackupConfiguration) : that.s3BackupConfiguration != null) return false;
                if (this.s3BackupMode != null ? !this.s3BackupMode.equals(that.s3BackupMode) : that.s3BackupMode != null) return false;
                if (this.secretsManagerConfiguration != null ? !this.secretsManagerConfiguration.equals(that.secretsManagerConfiguration) : that.secretsManagerConfiguration != null) return false;
                return this.username != null ? this.username.equals(that.username) : that.username == null;
            }

            @Override
            public final int hashCode() {
                int result = this.clusterJdbcurl.hashCode();
                result = 31 * result + (this.copyCommand.hashCode());
                result = 31 * result + (this.roleArn.hashCode());
                result = 31 * result + (this.s3Configuration.hashCode());
                result = 31 * result + (this.cloudWatchLoggingOptions != null ? this.cloudWatchLoggingOptions.hashCode() : 0);
                result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
                result = 31 * result + (this.processingConfiguration != null ? this.processingConfiguration.hashCode() : 0);
                result = 31 * result + (this.retryOptions != null ? this.retryOptions.hashCode() : 0);
                result = 31 * result + (this.s3BackupConfiguration != null ? this.s3BackupConfiguration.hashCode() : 0);
                result = 31 * result + (this.s3BackupMode != null ? this.s3BackupMode.hashCode() : 0);
                result = 31 * result + (this.secretsManagerConfiguration != null ? this.secretsManagerConfiguration.hashCode() : 0);
                result = 31 * result + (this.username != null ? this.username.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configures retry behavior in case Firehose is unable to deliver documents to Amazon Redshift.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * RedshiftRetryOptionsProperty redshiftRetryOptionsProperty = RedshiftRetryOptionsProperty.builder()
     *         .durationInSeconds(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-redshiftretryoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-redshiftretryoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.RedshiftRetryOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(RedshiftRetryOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RedshiftRetryOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The length of time during which Firehose retries delivery after a failure, starting from the initial request and including the first attempt.
         * <p>
         * The default value is 3600 seconds (60 minutes). Firehose does not retry if the value of <code>DurationInSeconds</code> is 0 (zero) or if the first delivery attempt takes longer than the current value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-redshiftretryoptions.html#cfn-kinesisfirehose-deliverystream-redshiftretryoptions-durationinseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-redshiftretryoptions.html#cfn-kinesisfirehose-deliverystream-redshiftretryoptions-durationinseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDurationInSeconds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RedshiftRetryOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RedshiftRetryOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RedshiftRetryOptionsProperty> {
            java.lang.Number durationInSeconds;

            /**
             * Sets the value of {@link RedshiftRetryOptionsProperty#getDurationInSeconds}
             * @param durationInSeconds The length of time during which Firehose retries delivery after a failure, starting from the initial request and including the first attempt.
             *                          The default value is 3600 seconds (60 minutes). Firehose does not retry if the value of <code>DurationInSeconds</code> is 0 (zero) or if the first delivery attempt takes longer than the current value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder durationInSeconds(java.lang.Number durationInSeconds) {
                this.durationInSeconds = durationInSeconds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RedshiftRetryOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RedshiftRetryOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RedshiftRetryOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RedshiftRetryOptionsProperty {
            private final java.lang.Number durationInSeconds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.durationInSeconds = software.amazon.jsii.Kernel.get(this, "durationInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.durationInSeconds = builder.durationInSeconds;
            }

            @Override
            public final java.lang.Number getDurationInSeconds() {
                return this.durationInSeconds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDurationInSeconds() != null) {
                    data.set("durationInSeconds", om.valueToTree(this.getDurationInSeconds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.RedshiftRetryOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RedshiftRetryOptionsProperty.Jsii$Proxy that = (RedshiftRetryOptionsProperty.Jsii$Proxy) o;

                return this.durationInSeconds != null ? this.durationInSeconds.equals(that.durationInSeconds) : that.durationInSeconds == null;
            }

            @Override
            public final int hashCode() {
                int result = this.durationInSeconds != null ? this.durationInSeconds.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Describes the retry behavior in case Kinesis Data Firehose is unable to deliver data to the specified HTTP endpoint destination, or if it doesn't receive a valid acknowledgment of receipt from the specified HTTP endpoint destination.
     * <p>
     * Kinesis Firehose supports any custom HTTP endpoint or HTTP endpoints owned by supported third-party service providers, including Datadog, MongoDB, and New Relic.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * RetryOptionsProperty retryOptionsProperty = RetryOptionsProperty.builder()
     *         .durationInSeconds(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-retryoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-retryoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.RetryOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(RetryOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RetryOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The total amount of time that Kinesis Data Firehose spends on retries.
         * <p>
         * This duration starts after the initial attempt to send data to the custom destination via HTTPS endpoint fails. It doesn't include the periods during which Kinesis Data Firehose waits for acknowledgment from the specified destination after each attempt.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-retryoptions.html#cfn-kinesisfirehose-deliverystream-retryoptions-durationinseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-retryoptions.html#cfn-kinesisfirehose-deliverystream-retryoptions-durationinseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDurationInSeconds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RetryOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RetryOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RetryOptionsProperty> {
            java.lang.Number durationInSeconds;

            /**
             * Sets the value of {@link RetryOptionsProperty#getDurationInSeconds}
             * @param durationInSeconds The total amount of time that Kinesis Data Firehose spends on retries.
             *                          This duration starts after the initial attempt to send data to the custom destination via HTTPS endpoint fails. It doesn't include the periods during which Kinesis Data Firehose waits for acknowledgment from the specified destination after each attempt.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder durationInSeconds(java.lang.Number durationInSeconds) {
                this.durationInSeconds = durationInSeconds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RetryOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RetryOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RetryOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RetryOptionsProperty {
            private final java.lang.Number durationInSeconds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.durationInSeconds = software.amazon.jsii.Kernel.get(this, "durationInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.durationInSeconds = builder.durationInSeconds;
            }

            @Override
            public final java.lang.Number getDurationInSeconds() {
                return this.durationInSeconds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDurationInSeconds() != null) {
                    data.set("durationInSeconds", om.valueToTree(this.getDurationInSeconds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.RetryOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RetryOptionsProperty.Jsii$Proxy that = (RetryOptionsProperty.Jsii$Proxy) o;

                return this.durationInSeconds != null ? this.durationInSeconds.equals(that.durationInSeconds) : that.durationInSeconds == null;
            }

            @Override
            public final int hashCode() {
                int result = this.durationInSeconds != null ? this.durationInSeconds.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The <code>S3DestinationConfiguration</code> property type specifies an Amazon Simple Storage Service (Amazon S3) destination to which Amazon Kinesis Data Firehose (Kinesis Data Firehose) delivers data.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * S3DestinationConfigurationProperty s3DestinationConfigurationProperty = S3DestinationConfigurationProperty.builder()
     *         .bucketArn("bucketArn")
     *         .roleArn("roleArn")
     *         // the properties below are optional
     *         .bufferingHints(BufferingHintsProperty.builder()
     *                 .intervalInSeconds(123)
     *                 .sizeInMBs(123)
     *                 .build())
     *         .cloudWatchLoggingOptions(CloudWatchLoggingOptionsProperty.builder()
     *                 .enabled(false)
     *                 .logGroupName("logGroupName")
     *                 .logStreamName("logStreamName")
     *                 .build())
     *         .compressionFormat("compressionFormat")
     *         .encryptionConfiguration(EncryptionConfigurationProperty.builder()
     *                 .kmsEncryptionConfig(KMSEncryptionConfigProperty.builder()
     *                         .awskmsKeyArn("awskmsKeyArn")
     *                         .build())
     *                 .noEncryptionConfig("noEncryptionConfig")
     *                 .build())
     *         .errorOutputPrefix("errorOutputPrefix")
     *         .prefix("prefix")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-s3destinationconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-s3destinationconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.S3DestinationConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(S3DestinationConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3DestinationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the Amazon S3 bucket to send data to.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-s3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-s3destinationconfiguration-bucketarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-s3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-s3destinationconfiguration-bucketarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucketArn();

        /**
         * The ARN of an AWS Identity and Access Management (IAM) role that grants Kinesis Data Firehose access to your Amazon S3 bucket and AWS KMS (if you enable data encryption).
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/controlling-access.html#using-iam-s3">Grant Kinesis Data Firehose Access to an Amazon S3 Destination</a> in the <em>Amazon Kinesis Data Firehose Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-s3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-s3destinationconfiguration-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-s3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-s3destinationconfiguration-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * Configures how Kinesis Data Firehose buffers incoming data while delivering it to the Amazon S3 bucket.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-s3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-s3destinationconfiguration-bufferinghints">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-s3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-s3destinationconfiguration-bufferinghints</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBufferingHints() {
            return null;
        }

        /**
         * The CloudWatch logging options for your Firehose stream.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-s3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-s3destinationconfiguration-cloudwatchloggingoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-s3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-s3destinationconfiguration-cloudwatchloggingoptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCloudWatchLoggingOptions() {
            return null;
        }

        /**
         * The type of compression that Kinesis Data Firehose uses to compress the data that it delivers to the Amazon S3 bucket.
         * <p>
         * For valid values, see the <code>CompressionFormat</code> content for the <a href="https://docs.aws.amazon.com/firehose/latest/APIReference/API_S3DestinationConfiguration.html">S3DestinationConfiguration</a> data type in the <em>Amazon Kinesis Data Firehose API Reference</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-s3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-s3destinationconfiguration-compressionformat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-s3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-s3destinationconfiguration-compressionformat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCompressionFormat() {
            return null;
        }

        /**
         * Configures Amazon Simple Storage Service (Amazon S3) server-side encryption.
         * <p>
         * Kinesis Data Firehose uses AWS Key Management Service ( AWS KMS) to encrypt the data that it delivers to your Amazon S3 bucket.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-s3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-s3destinationconfiguration-encryptionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-s3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-s3destinationconfiguration-encryptionconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEncryptionConfiguration() {
            return null;
        }

        /**
         * A prefix that Kinesis Data Firehose evaluates and adds to failed records before writing them to S3.
         * <p>
         * This prefix appears immediately following the bucket name. For information about how to specify this prefix, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">Custom Prefixes for Amazon S3 Objects</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-s3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-s3destinationconfiguration-erroroutputprefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-s3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-s3destinationconfiguration-erroroutputprefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getErrorOutputPrefix() {
            return null;
        }

        /**
         * A prefix that Kinesis Data Firehose adds to the files that it delivers to the Amazon S3 bucket.
         * <p>
         * The prefix helps you identify the files that Kinesis Data Firehose delivered.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-s3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-s3destinationconfiguration-prefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-s3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-s3destinationconfiguration-prefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPrefix() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3DestinationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3DestinationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3DestinationConfigurationProperty> {
            java.lang.String bucketArn;
            java.lang.String roleArn;
            java.lang.Object bufferingHints;
            java.lang.Object cloudWatchLoggingOptions;
            java.lang.String compressionFormat;
            java.lang.Object encryptionConfiguration;
            java.lang.String errorOutputPrefix;
            java.lang.String prefix;

            /**
             * Sets the value of {@link S3DestinationConfigurationProperty#getBucketArn}
             * @param bucketArn The Amazon Resource Name (ARN) of the Amazon S3 bucket to send data to. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketArn(java.lang.String bucketArn) {
                this.bucketArn = bucketArn;
                return this;
            }

            /**
             * Sets the value of {@link S3DestinationConfigurationProperty#getRoleArn}
             * @param roleArn The ARN of an AWS Identity and Access Management (IAM) role that grants Kinesis Data Firehose access to your Amazon S3 bucket and AWS KMS (if you enable data encryption). This parameter is required.
             *                For more information, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/controlling-access.html#using-iam-s3">Grant Kinesis Data Firehose Access to an Amazon S3 Destination</a> in the <em>Amazon Kinesis Data Firehose Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link S3DestinationConfigurationProperty#getBufferingHints}
             * @param bufferingHints Configures how Kinesis Data Firehose buffers incoming data while delivering it to the Amazon S3 bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bufferingHints(software.amazon.awscdk.IResolvable bufferingHints) {
                this.bufferingHints = bufferingHints;
                return this;
            }

            /**
             * Sets the value of {@link S3DestinationConfigurationProperty#getBufferingHints}
             * @param bufferingHints Configures how Kinesis Data Firehose buffers incoming data while delivering it to the Amazon S3 bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bufferingHints(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.BufferingHintsProperty bufferingHints) {
                this.bufferingHints = bufferingHints;
                return this;
            }

            /**
             * Sets the value of {@link S3DestinationConfigurationProperty#getCloudWatchLoggingOptions}
             * @param cloudWatchLoggingOptions The CloudWatch logging options for your Firehose stream.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchLoggingOptions(software.amazon.awscdk.IResolvable cloudWatchLoggingOptions) {
                this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
                return this;
            }

            /**
             * Sets the value of {@link S3DestinationConfigurationProperty#getCloudWatchLoggingOptions}
             * @param cloudWatchLoggingOptions The CloudWatch logging options for your Firehose stream.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchLoggingOptions(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.CloudWatchLoggingOptionsProperty cloudWatchLoggingOptions) {
                this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
                return this;
            }

            /**
             * Sets the value of {@link S3DestinationConfigurationProperty#getCompressionFormat}
             * @param compressionFormat The type of compression that Kinesis Data Firehose uses to compress the data that it delivers to the Amazon S3 bucket.
             *                          For valid values, see the <code>CompressionFormat</code> content for the <a href="https://docs.aws.amazon.com/firehose/latest/APIReference/API_S3DestinationConfiguration.html">S3DestinationConfiguration</a> data type in the <em>Amazon Kinesis Data Firehose API Reference</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder compressionFormat(java.lang.String compressionFormat) {
                this.compressionFormat = compressionFormat;
                return this;
            }

            /**
             * Sets the value of {@link S3DestinationConfigurationProperty#getEncryptionConfiguration}
             * @param encryptionConfiguration Configures Amazon Simple Storage Service (Amazon S3) server-side encryption.
             *                                Kinesis Data Firehose uses AWS Key Management Service ( AWS KMS) to encrypt the data that it delivers to your Amazon S3 bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionConfiguration(software.amazon.awscdk.IResolvable encryptionConfiguration) {
                this.encryptionConfiguration = encryptionConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link S3DestinationConfigurationProperty#getEncryptionConfiguration}
             * @param encryptionConfiguration Configures Amazon Simple Storage Service (Amazon S3) server-side encryption.
             *                                Kinesis Data Firehose uses AWS Key Management Service ( AWS KMS) to encrypt the data that it delivers to your Amazon S3 bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionConfiguration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.EncryptionConfigurationProperty encryptionConfiguration) {
                this.encryptionConfiguration = encryptionConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link S3DestinationConfigurationProperty#getErrorOutputPrefix}
             * @param errorOutputPrefix A prefix that Kinesis Data Firehose evaluates and adds to failed records before writing them to S3.
             *                          This prefix appears immediately following the bucket name. For information about how to specify this prefix, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html">Custom Prefixes for Amazon S3 Objects</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder errorOutputPrefix(java.lang.String errorOutputPrefix) {
                this.errorOutputPrefix = errorOutputPrefix;
                return this;
            }

            /**
             * Sets the value of {@link S3DestinationConfigurationProperty#getPrefix}
             * @param prefix A prefix that Kinesis Data Firehose adds to the files that it delivers to the Amazon S3 bucket.
             *               The prefix helps you identify the files that Kinesis Data Firehose delivered.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prefix(java.lang.String prefix) {
                this.prefix = prefix;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3DestinationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3DestinationConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3DestinationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3DestinationConfigurationProperty {
            private final java.lang.String bucketArn;
            private final java.lang.String roleArn;
            private final java.lang.Object bufferingHints;
            private final java.lang.Object cloudWatchLoggingOptions;
            private final java.lang.String compressionFormat;
            private final java.lang.Object encryptionConfiguration;
            private final java.lang.String errorOutputPrefix;
            private final java.lang.String prefix;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucketArn = software.amazon.jsii.Kernel.get(this, "bucketArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.bufferingHints = software.amazon.jsii.Kernel.get(this, "bufferingHints", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.cloudWatchLoggingOptions = software.amazon.jsii.Kernel.get(this, "cloudWatchLoggingOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.compressionFormat = software.amazon.jsii.Kernel.get(this, "compressionFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.encryptionConfiguration = software.amazon.jsii.Kernel.get(this, "encryptionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.errorOutputPrefix = software.amazon.jsii.Kernel.get(this, "errorOutputPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.prefix = software.amazon.jsii.Kernel.get(this, "prefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucketArn = java.util.Objects.requireNonNull(builder.bucketArn, "bucketArn is required");
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
                this.bufferingHints = builder.bufferingHints;
                this.cloudWatchLoggingOptions = builder.cloudWatchLoggingOptions;
                this.compressionFormat = builder.compressionFormat;
                this.encryptionConfiguration = builder.encryptionConfiguration;
                this.errorOutputPrefix = builder.errorOutputPrefix;
                this.prefix = builder.prefix;
            }

            @Override
            public final java.lang.String getBucketArn() {
                return this.bucketArn;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.Object getBufferingHints() {
                return this.bufferingHints;
            }

            @Override
            public final java.lang.Object getCloudWatchLoggingOptions() {
                return this.cloudWatchLoggingOptions;
            }

            @Override
            public final java.lang.String getCompressionFormat() {
                return this.compressionFormat;
            }

            @Override
            public final java.lang.Object getEncryptionConfiguration() {
                return this.encryptionConfiguration;
            }

            @Override
            public final java.lang.String getErrorOutputPrefix() {
                return this.errorOutputPrefix;
            }

            @Override
            public final java.lang.String getPrefix() {
                return this.prefix;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucketArn", om.valueToTree(this.getBucketArn()));
                data.set("roleArn", om.valueToTree(this.getRoleArn()));
                if (this.getBufferingHints() != null) {
                    data.set("bufferingHints", om.valueToTree(this.getBufferingHints()));
                }
                if (this.getCloudWatchLoggingOptions() != null) {
                    data.set("cloudWatchLoggingOptions", om.valueToTree(this.getCloudWatchLoggingOptions()));
                }
                if (this.getCompressionFormat() != null) {
                    data.set("compressionFormat", om.valueToTree(this.getCompressionFormat()));
                }
                if (this.getEncryptionConfiguration() != null) {
                    data.set("encryptionConfiguration", om.valueToTree(this.getEncryptionConfiguration()));
                }
                if (this.getErrorOutputPrefix() != null) {
                    data.set("errorOutputPrefix", om.valueToTree(this.getErrorOutputPrefix()));
                }
                if (this.getPrefix() != null) {
                    data.set("prefix", om.valueToTree(this.getPrefix()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.S3DestinationConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3DestinationConfigurationProperty.Jsii$Proxy that = (S3DestinationConfigurationProperty.Jsii$Proxy) o;

                if (!bucketArn.equals(that.bucketArn)) return false;
                if (!roleArn.equals(that.roleArn)) return false;
                if (this.bufferingHints != null ? !this.bufferingHints.equals(that.bufferingHints) : that.bufferingHints != null) return false;
                if (this.cloudWatchLoggingOptions != null ? !this.cloudWatchLoggingOptions.equals(that.cloudWatchLoggingOptions) : that.cloudWatchLoggingOptions != null) return false;
                if (this.compressionFormat != null ? !this.compressionFormat.equals(that.compressionFormat) : that.compressionFormat != null) return false;
                if (this.encryptionConfiguration != null ? !this.encryptionConfiguration.equals(that.encryptionConfiguration) : that.encryptionConfiguration != null) return false;
                if (this.errorOutputPrefix != null ? !this.errorOutputPrefix.equals(that.errorOutputPrefix) : that.errorOutputPrefix != null) return false;
                return this.prefix != null ? this.prefix.equals(that.prefix) : that.prefix == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bucketArn.hashCode();
                result = 31 * result + (this.roleArn.hashCode());
                result = 31 * result + (this.bufferingHints != null ? this.bufferingHints.hashCode() : 0);
                result = 31 * result + (this.cloudWatchLoggingOptions != null ? this.cloudWatchLoggingOptions.hashCode() : 0);
                result = 31 * result + (this.compressionFormat != null ? this.compressionFormat.hashCode() : 0);
                result = 31 * result + (this.encryptionConfiguration != null ? this.encryptionConfiguration.hashCode() : 0);
                result = 31 * result + (this.errorOutputPrefix != null ? this.errorOutputPrefix.hashCode() : 0);
                result = 31 * result + (this.prefix != null ? this.prefix.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the schema to which you want Firehose to configure your data before it writes it to Amazon S3.
     * <p>
     * This parameter is required if <code>Enabled</code> is set to true.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * SchemaConfigurationProperty schemaConfigurationProperty = SchemaConfigurationProperty.builder()
     *         .catalogId("catalogId")
     *         .databaseName("databaseName")
     *         .region("region")
     *         .roleArn("roleArn")
     *         .tableName("tableName")
     *         .versionId("versionId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-schemaconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-schemaconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.SchemaConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(SchemaConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SchemaConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ID of the AWS Glue Data Catalog.
         * <p>
         * If you don't supply this, the AWS account ID is used by default.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-schemaconfiguration.html#cfn-kinesisfirehose-deliverystream-schemaconfiguration-catalogid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-schemaconfiguration.html#cfn-kinesisfirehose-deliverystream-schemaconfiguration-catalogid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCatalogId() {
            return null;
        }

        /**
         * Specifies the name of the AWS Glue database that contains the schema for the output data.
         * <p>
         * <blockquote>
         * <p>
         * If the <code>SchemaConfiguration</code> request parameter is used as part of invoking the <code>CreateDeliveryStream</code> API, then the <code>DatabaseName</code> property is required and its value must be specified.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-schemaconfiguration.html#cfn-kinesisfirehose-deliverystream-schemaconfiguration-databasename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-schemaconfiguration.html#cfn-kinesisfirehose-deliverystream-schemaconfiguration-databasename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDatabaseName() {
            return null;
        }

        /**
         * If you don't specify an AWS Region, the default is the current Region.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-schemaconfiguration.html#cfn-kinesisfirehose-deliverystream-schemaconfiguration-region">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-schemaconfiguration.html#cfn-kinesisfirehose-deliverystream-schemaconfiguration-region</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRegion() {
            return null;
        }

        /**
         * The role that Firehose can use to access AWS Glue.
         * <p>
         * This role must be in the same account you use for Firehose. Cross-account roles aren't allowed.
         * <p>
         * <blockquote>
         * <p>
         * If the <code>SchemaConfiguration</code> request parameter is used as part of invoking the <code>CreateDeliveryStream</code> API, then the <code>RoleARN</code> property is required and its value must be specified.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-schemaconfiguration.html#cfn-kinesisfirehose-deliverystream-schemaconfiguration-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-schemaconfiguration.html#cfn-kinesisfirehose-deliverystream-schemaconfiguration-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRoleArn() {
            return null;
        }

        /**
         * Specifies the AWS Glue table that contains the column information that constitutes your data schema.
         * <p>
         * <blockquote>
         * <p>
         * If the <code>SchemaConfiguration</code> request parameter is used as part of invoking the <code>CreateDeliveryStream</code> API, then the <code>TableName</code> property is required and its value must be specified.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-schemaconfiguration.html#cfn-kinesisfirehose-deliverystream-schemaconfiguration-tablename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-schemaconfiguration.html#cfn-kinesisfirehose-deliverystream-schemaconfiguration-tablename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTableName() {
            return null;
        }

        /**
         * Specifies the table version for the output data schema.
         * <p>
         * If you don't specify this version ID, or if you set it to <code>LATEST</code> , Firehose uses the most recent version. This means that any updates to the table are automatically picked up.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-schemaconfiguration.html#cfn-kinesisfirehose-deliverystream-schemaconfiguration-versionid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-schemaconfiguration.html#cfn-kinesisfirehose-deliverystream-schemaconfiguration-versionid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVersionId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SchemaConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SchemaConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SchemaConfigurationProperty> {
            java.lang.String catalogId;
            java.lang.String databaseName;
            java.lang.String region;
            java.lang.String roleArn;
            java.lang.String tableName;
            java.lang.String versionId;

            /**
             * Sets the value of {@link SchemaConfigurationProperty#getCatalogId}
             * @param catalogId The ID of the AWS Glue Data Catalog.
             *                  If you don't supply this, the AWS account ID is used by default.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder catalogId(java.lang.String catalogId) {
                this.catalogId = catalogId;
                return this;
            }

            /**
             * Sets the value of {@link SchemaConfigurationProperty#getDatabaseName}
             * @param databaseName Specifies the name of the AWS Glue database that contains the schema for the output data.
             *                     <blockquote>
             *                     <p>
             *                     If the <code>SchemaConfiguration</code> request parameter is used as part of invoking the <code>CreateDeliveryStream</code> API, then the <code>DatabaseName</code> property is required and its value must be specified.
             *                     <p>
             *                     </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseName(java.lang.String databaseName) {
                this.databaseName = databaseName;
                return this;
            }

            /**
             * Sets the value of {@link SchemaConfigurationProperty#getRegion}
             * @param region If you don't specify an AWS Region, the default is the current Region.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder region(java.lang.String region) {
                this.region = region;
                return this;
            }

            /**
             * Sets the value of {@link SchemaConfigurationProperty#getRoleArn}
             * @param roleArn The role that Firehose can use to access AWS Glue.
             *                This role must be in the same account you use for Firehose. Cross-account roles aren't allowed.
             *                <p>
             *                <blockquote>
             *                <p>
             *                If the <code>SchemaConfiguration</code> request parameter is used as part of invoking the <code>CreateDeliveryStream</code> API, then the <code>RoleARN</code> property is required and its value must be specified.
             *                <p>
             *                </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link SchemaConfigurationProperty#getTableName}
             * @param tableName Specifies the AWS Glue table that contains the column information that constitutes your data schema.
             *                  <blockquote>
             *                  <p>
             *                  If the <code>SchemaConfiguration</code> request parameter is used as part of invoking the <code>CreateDeliveryStream</code> API, then the <code>TableName</code> property is required and its value must be specified.
             *                  <p>
             *                  </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tableName(java.lang.String tableName) {
                this.tableName = tableName;
                return this;
            }

            /**
             * Sets the value of {@link SchemaConfigurationProperty#getVersionId}
             * @param versionId Specifies the table version for the output data schema.
             *                  If you don't specify this version ID, or if you set it to <code>LATEST</code> , Firehose uses the most recent version. This means that any updates to the table are automatically picked up.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder versionId(java.lang.String versionId) {
                this.versionId = versionId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SchemaConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SchemaConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SchemaConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SchemaConfigurationProperty {
            private final java.lang.String catalogId;
            private final java.lang.String databaseName;
            private final java.lang.String region;
            private final java.lang.String roleArn;
            private final java.lang.String tableName;
            private final java.lang.String versionId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.catalogId = software.amazon.jsii.Kernel.get(this, "catalogId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.databaseName = software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.region = software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tableName = software.amazon.jsii.Kernel.get(this, "tableName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.versionId = software.amazon.jsii.Kernel.get(this, "versionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.catalogId = builder.catalogId;
                this.databaseName = builder.databaseName;
                this.region = builder.region;
                this.roleArn = builder.roleArn;
                this.tableName = builder.tableName;
                this.versionId = builder.versionId;
            }

            @Override
            public final java.lang.String getCatalogId() {
                return this.catalogId;
            }

            @Override
            public final java.lang.String getDatabaseName() {
                return this.databaseName;
            }

            @Override
            public final java.lang.String getRegion() {
                return this.region;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.String getTableName() {
                return this.tableName;
            }

            @Override
            public final java.lang.String getVersionId() {
                return this.versionId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCatalogId() != null) {
                    data.set("catalogId", om.valueToTree(this.getCatalogId()));
                }
                if (this.getDatabaseName() != null) {
                    data.set("databaseName", om.valueToTree(this.getDatabaseName()));
                }
                if (this.getRegion() != null) {
                    data.set("region", om.valueToTree(this.getRegion()));
                }
                if (this.getRoleArn() != null) {
                    data.set("roleArn", om.valueToTree(this.getRoleArn()));
                }
                if (this.getTableName() != null) {
                    data.set("tableName", om.valueToTree(this.getTableName()));
                }
                if (this.getVersionId() != null) {
                    data.set("versionId", om.valueToTree(this.getVersionId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.SchemaConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SchemaConfigurationProperty.Jsii$Proxy that = (SchemaConfigurationProperty.Jsii$Proxy) o;

                if (this.catalogId != null ? !this.catalogId.equals(that.catalogId) : that.catalogId != null) return false;
                if (this.databaseName != null ? !this.databaseName.equals(that.databaseName) : that.databaseName != null) return false;
                if (this.region != null ? !this.region.equals(that.region) : that.region != null) return false;
                if (this.roleArn != null ? !this.roleArn.equals(that.roleArn) : that.roleArn != null) return false;
                if (this.tableName != null ? !this.tableName.equals(that.tableName) : that.tableName != null) return false;
                return this.versionId != null ? this.versionId.equals(that.versionId) : that.versionId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.catalogId != null ? this.catalogId.hashCode() : 0;
                result = 31 * result + (this.databaseName != null ? this.databaseName.hashCode() : 0);
                result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
                result = 31 * result + (this.roleArn != null ? this.roleArn.hashCode() : 0);
                result = 31 * result + (this.tableName != null ? this.tableName.hashCode() : 0);
                result = 31 * result + (this.versionId != null ? this.versionId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The structure that defines how Firehose accesses the secret.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * SecretsManagerConfigurationProperty secretsManagerConfigurationProperty = SecretsManagerConfigurationProperty.builder()
     *         .enabled(false)
     *         // the properties below are optional
     *         .roleArn("roleArn")
     *         .secretArn("secretArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-secretsmanagerconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-secretsmanagerconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.SecretsManagerConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(SecretsManagerConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SecretsManagerConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether you want to use the secrets manager feature.
         * <p>
         * When set as <code>True</code> the secrets manager configuration overwrites the existing secrets in the destination configuration. When it's set to <code>False</code> Firehose falls back to the credentials in the destination configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-secretsmanagerconfiguration.html#cfn-kinesisfirehose-deliverystream-secretsmanagerconfiguration-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-secretsmanagerconfiguration.html#cfn-kinesisfirehose-deliverystream-secretsmanagerconfiguration-enabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEnabled();

        /**
         * Specifies the role that Firehose assumes when calling the Secrets Manager API operation.
         * <p>
         * When you provide the role, it overrides any destination specific role defined in the destination configuration. If you do not provide the then we use the destination specific role. This parameter is required for Splunk.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-secretsmanagerconfiguration.html#cfn-kinesisfirehose-deliverystream-secretsmanagerconfiguration-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-secretsmanagerconfiguration.html#cfn-kinesisfirehose-deliverystream-secretsmanagerconfiguration-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRoleArn() {
            return null;
        }

        /**
         * The ARN of the secret that stores your credentials.
         * <p>
         * It must be in the same region as the Firehose stream and the role. The secret ARN can reside in a different account than the Firehose stream and role as Firehose supports cross-account secret access. This parameter is required when <em>Enabled</em> is set to <code>True</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-secretsmanagerconfiguration.html#cfn-kinesisfirehose-deliverystream-secretsmanagerconfiguration-secretarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-secretsmanagerconfiguration.html#cfn-kinesisfirehose-deliverystream-secretsmanagerconfiguration-secretarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SecretsManagerConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SecretsManagerConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SecretsManagerConfigurationProperty> {
            java.lang.Object enabled;
            java.lang.String roleArn;
            java.lang.String secretArn;

            /**
             * Sets the value of {@link SecretsManagerConfigurationProperty#getEnabled}
             * @param enabled Specifies whether you want to use the secrets manager feature. This parameter is required.
             *                When set as <code>True</code> the secrets manager configuration overwrites the existing secrets in the destination configuration. When it's set to <code>False</code> Firehose falls back to the credentials in the destination configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link SecretsManagerConfigurationProperty#getEnabled}
             * @param enabled Specifies whether you want to use the secrets manager feature. This parameter is required.
             *                When set as <code>True</code> the secrets manager configuration overwrites the existing secrets in the destination configuration. When it's set to <code>False</code> Firehose falls back to the credentials in the destination configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link SecretsManagerConfigurationProperty#getRoleArn}
             * @param roleArn Specifies the role that Firehose assumes when calling the Secrets Manager API operation.
             *                When you provide the role, it overrides any destination specific role defined in the destination configuration. If you do not provide the then we use the destination specific role. This parameter is required for Splunk.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link SecretsManagerConfigurationProperty#getSecretArn}
             * @param secretArn The ARN of the secret that stores your credentials.
             *                  It must be in the same region as the Firehose stream and the role. The secret ARN can reside in a different account than the Firehose stream and role as Firehose supports cross-account secret access. This parameter is required when <em>Enabled</em> is set to <code>True</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretArn(java.lang.String secretArn) {
                this.secretArn = secretArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SecretsManagerConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SecretsManagerConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SecretsManagerConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SecretsManagerConfigurationProperty {
            private final java.lang.Object enabled;
            private final java.lang.String roleArn;
            private final java.lang.String secretArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secretArn = software.amazon.jsii.Kernel.get(this, "secretArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = java.util.Objects.requireNonNull(builder.enabled, "enabled is required");
                this.roleArn = builder.roleArn;
                this.secretArn = builder.secretArn;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.String getSecretArn() {
                return this.secretArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("enabled", om.valueToTree(this.getEnabled()));
                if (this.getRoleArn() != null) {
                    data.set("roleArn", om.valueToTree(this.getRoleArn()));
                }
                if (this.getSecretArn() != null) {
                    data.set("secretArn", om.valueToTree(this.getSecretArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.SecretsManagerConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SecretsManagerConfigurationProperty.Jsii$Proxy that = (SecretsManagerConfigurationProperty.Jsii$Proxy) o;

                if (!enabled.equals(that.enabled)) return false;
                if (this.roleArn != null ? !this.roleArn.equals(that.roleArn) : that.roleArn != null) return false;
                return this.secretArn != null ? this.secretArn.equals(that.secretArn) : that.secretArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled.hashCode();
                result = 31 * result + (this.roleArn != null ? this.roleArn.hashCode() : 0);
                result = 31 * result + (this.secretArn != null ? this.secretArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The serializer that you want Firehose to use to convert data to the target format before writing it to Amazon S3.
     * <p>
     * Firehose supports two types of serializers: the ORC SerDe and the Parquet SerDe.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * SerializerProperty serializerProperty = SerializerProperty.builder()
     *         .orcSerDe(OrcSerDeProperty.builder()
     *                 .blockSizeBytes(123)
     *                 .bloomFilterColumns(List.of("bloomFilterColumns"))
     *                 .bloomFilterFalsePositiveProbability(123)
     *                 .compression("compression")
     *                 .dictionaryKeyThreshold(123)
     *                 .enablePadding(false)
     *                 .formatVersion("formatVersion")
     *                 .paddingTolerance(123)
     *                 .rowIndexStride(123)
     *                 .stripeSizeBytes(123)
     *                 .build())
     *         .parquetSerDe(ParquetSerDeProperty.builder()
     *                 .blockSizeBytes(123)
     *                 .compression("compression")
     *                 .enableDictionaryCompression(false)
     *                 .maxPaddingBytes(123)
     *                 .pageSizeBytes(123)
     *                 .writerVersion("writerVersion")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-serializer.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-serializer.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.SerializerProperty")
    @software.amazon.jsii.Jsii.Proxy(SerializerProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SerializerProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A serializer to use for converting data to the ORC format before storing it in Amazon S3.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/https://orc.apache.org/docs/">Apache ORC</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-serializer.html#cfn-kinesisfirehose-deliverystream-serializer-orcserde">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-serializer.html#cfn-kinesisfirehose-deliverystream-serializer-orcserde</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOrcSerDe() {
            return null;
        }

        /**
         * A serializer to use for converting data to the Parquet format before storing it in Amazon S3.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/https://parquet.apache.org/docs/contribution-guidelines/">Apache Parquet</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-serializer.html#cfn-kinesisfirehose-deliverystream-serializer-parquetserde">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-serializer.html#cfn-kinesisfirehose-deliverystream-serializer-parquetserde</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getParquetSerDe() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SerializerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SerializerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SerializerProperty> {
            java.lang.Object orcSerDe;
            java.lang.Object parquetSerDe;

            /**
             * Sets the value of {@link SerializerProperty#getOrcSerDe}
             * @param orcSerDe A serializer to use for converting data to the ORC format before storing it in Amazon S3.
             *                 For more information, see <a href="https://docs.aws.amazon.com/https://orc.apache.org/docs/">Apache ORC</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder orcSerDe(software.amazon.awscdk.IResolvable orcSerDe) {
                this.orcSerDe = orcSerDe;
                return this;
            }

            /**
             * Sets the value of {@link SerializerProperty#getOrcSerDe}
             * @param orcSerDe A serializer to use for converting data to the ORC format before storing it in Amazon S3.
             *                 For more information, see <a href="https://docs.aws.amazon.com/https://orc.apache.org/docs/">Apache ORC</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder orcSerDe(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.OrcSerDeProperty orcSerDe) {
                this.orcSerDe = orcSerDe;
                return this;
            }

            /**
             * Sets the value of {@link SerializerProperty#getParquetSerDe}
             * @param parquetSerDe A serializer to use for converting data to the Parquet format before storing it in Amazon S3.
             *                     For more information, see <a href="https://docs.aws.amazon.com/https://parquet.apache.org/docs/contribution-guidelines/">Apache Parquet</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parquetSerDe(software.amazon.awscdk.IResolvable parquetSerDe) {
                this.parquetSerDe = parquetSerDe;
                return this;
            }

            /**
             * Sets the value of {@link SerializerProperty#getParquetSerDe}
             * @param parquetSerDe A serializer to use for converting data to the Parquet format before storing it in Amazon S3.
             *                     For more information, see <a href="https://docs.aws.amazon.com/https://parquet.apache.org/docs/contribution-guidelines/">Apache Parquet</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parquetSerDe(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.ParquetSerDeProperty parquetSerDe) {
                this.parquetSerDe = parquetSerDe;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SerializerProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SerializerProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SerializerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SerializerProperty {
            private final java.lang.Object orcSerDe;
            private final java.lang.Object parquetSerDe;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.orcSerDe = software.amazon.jsii.Kernel.get(this, "orcSerDe", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.parquetSerDe = software.amazon.jsii.Kernel.get(this, "parquetSerDe", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.orcSerDe = builder.orcSerDe;
                this.parquetSerDe = builder.parquetSerDe;
            }

            @Override
            public final java.lang.Object getOrcSerDe() {
                return this.orcSerDe;
            }

            @Override
            public final java.lang.Object getParquetSerDe() {
                return this.parquetSerDe;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getOrcSerDe() != null) {
                    data.set("orcSerDe", om.valueToTree(this.getOrcSerDe()));
                }
                if (this.getParquetSerDe() != null) {
                    data.set("parquetSerDe", om.valueToTree(this.getParquetSerDe()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.SerializerProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SerializerProperty.Jsii$Proxy that = (SerializerProperty.Jsii$Proxy) o;

                if (this.orcSerDe != null ? !this.orcSerDe.equals(that.orcSerDe) : that.orcSerDe != null) return false;
                return this.parquetSerDe != null ? this.parquetSerDe.equals(that.parquetSerDe) : that.parquetSerDe == null;
            }

            @Override
            public final int hashCode() {
                int result = this.orcSerDe != null ? this.orcSerDe.hashCode() : 0;
                result = 31 * result + (this.parquetSerDe != null ? this.parquetSerDe.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes the buffering to perform before delivering data to the Snowflake destination.
     * <p>
     * If you do not specify any value, Firehose uses the default values.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * SnowflakeBufferingHintsProperty snowflakeBufferingHintsProperty = SnowflakeBufferingHintsProperty.builder()
     *         .intervalInSeconds(123)
     *         .sizeInMBs(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-snowflakebufferinghints.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-snowflakebufferinghints.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.SnowflakeBufferingHintsProperty")
    @software.amazon.jsii.Jsii.Proxy(SnowflakeBufferingHintsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SnowflakeBufferingHintsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Buffer incoming data for the specified period of time, in seconds, before delivering it to the destination.
         * <p>
         * The default value is 0.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-snowflakebufferinghints.html#cfn-kinesisfirehose-deliverystream-snowflakebufferinghints-intervalinseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-snowflakebufferinghints.html#cfn-kinesisfirehose-deliverystream-snowflakebufferinghints-intervalinseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getIntervalInSeconds() {
            return null;
        }

        /**
         * Buffer incoming data to the specified size, in MBs, before delivering it to the destination.
         * <p>
         * The default value is 128.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-snowflakebufferinghints.html#cfn-kinesisfirehose-deliverystream-snowflakebufferinghints-sizeinmbs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-snowflakebufferinghints.html#cfn-kinesisfirehose-deliverystream-snowflakebufferinghints-sizeinmbs</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSizeInMBs() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SnowflakeBufferingHintsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SnowflakeBufferingHintsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SnowflakeBufferingHintsProperty> {
            java.lang.Number intervalInSeconds;
            java.lang.Number sizeInMBs;

            /**
             * Sets the value of {@link SnowflakeBufferingHintsProperty#getIntervalInSeconds}
             * @param intervalInSeconds Buffer incoming data for the specified period of time, in seconds, before delivering it to the destination.
             *                          The default value is 0.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder intervalInSeconds(java.lang.Number intervalInSeconds) {
                this.intervalInSeconds = intervalInSeconds;
                return this;
            }

            /**
             * Sets the value of {@link SnowflakeBufferingHintsProperty#getSizeInMBs}
             * @param sizeInMBs Buffer incoming data to the specified size, in MBs, before delivering it to the destination.
             *                  The default value is 128.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sizeInMBs(java.lang.Number sizeInMBs) {
                this.sizeInMBs = sizeInMBs;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SnowflakeBufferingHintsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SnowflakeBufferingHintsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SnowflakeBufferingHintsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SnowflakeBufferingHintsProperty {
            private final java.lang.Number intervalInSeconds;
            private final java.lang.Number sizeInMBs;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.intervalInSeconds = software.amazon.jsii.Kernel.get(this, "intervalInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.sizeInMBs = software.amazon.jsii.Kernel.get(this, "sizeInMBs", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.intervalInSeconds = builder.intervalInSeconds;
                this.sizeInMBs = builder.sizeInMBs;
            }

            @Override
            public final java.lang.Number getIntervalInSeconds() {
                return this.intervalInSeconds;
            }

            @Override
            public final java.lang.Number getSizeInMBs() {
                return this.sizeInMBs;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getIntervalInSeconds() != null) {
                    data.set("intervalInSeconds", om.valueToTree(this.getIntervalInSeconds()));
                }
                if (this.getSizeInMBs() != null) {
                    data.set("sizeInMBs", om.valueToTree(this.getSizeInMBs()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.SnowflakeBufferingHintsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SnowflakeBufferingHintsProperty.Jsii$Proxy that = (SnowflakeBufferingHintsProperty.Jsii$Proxy) o;

                if (this.intervalInSeconds != null ? !this.intervalInSeconds.equals(that.intervalInSeconds) : that.intervalInSeconds != null) return false;
                return this.sizeInMBs != null ? this.sizeInMBs.equals(that.sizeInMBs) : that.sizeInMBs == null;
            }

            @Override
            public final int hashCode() {
                int result = this.intervalInSeconds != null ? this.intervalInSeconds.hashCode() : 0;
                result = 31 * result + (this.sizeInMBs != null ? this.sizeInMBs.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configure Snowflake destination.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * SnowflakeDestinationConfigurationProperty snowflakeDestinationConfigurationProperty = SnowflakeDestinationConfigurationProperty.builder()
     *         .accountUrl("accountUrl")
     *         .database("database")
     *         .roleArn("roleArn")
     *         .s3Configuration(S3DestinationConfigurationProperty.builder()
     *                 .bucketArn("bucketArn")
     *                 .roleArn("roleArn")
     *                 // the properties below are optional
     *                 .bufferingHints(BufferingHintsProperty.builder()
     *                         .intervalInSeconds(123)
     *                         .sizeInMBs(123)
     *                         .build())
     *                 .cloudWatchLoggingOptions(CloudWatchLoggingOptionsProperty.builder()
     *                         .enabled(false)
     *                         .logGroupName("logGroupName")
     *                         .logStreamName("logStreamName")
     *                         .build())
     *                 .compressionFormat("compressionFormat")
     *                 .encryptionConfiguration(EncryptionConfigurationProperty.builder()
     *                         .kmsEncryptionConfig(KMSEncryptionConfigProperty.builder()
     *                                 .awskmsKeyArn("awskmsKeyArn")
     *                                 .build())
     *                         .noEncryptionConfig("noEncryptionConfig")
     *                         .build())
     *                 .errorOutputPrefix("errorOutputPrefix")
     *                 .prefix("prefix")
     *                 .build())
     *         .schema("schema")
     *         .table("table")
     *         // the properties below are optional
     *         .bufferingHints(SnowflakeBufferingHintsProperty.builder()
     *                 .intervalInSeconds(123)
     *                 .sizeInMBs(123)
     *                 .build())
     *         .cloudWatchLoggingOptions(CloudWatchLoggingOptionsProperty.builder()
     *                 .enabled(false)
     *                 .logGroupName("logGroupName")
     *                 .logStreamName("logStreamName")
     *                 .build())
     *         .contentColumnName("contentColumnName")
     *         .dataLoadingOption("dataLoadingOption")
     *         .keyPassphrase("keyPassphrase")
     *         .metaDataColumnName("metaDataColumnName")
     *         .privateKey("privateKey")
     *         .processingConfiguration(ProcessingConfigurationProperty.builder()
     *                 .enabled(false)
     *                 .processors(List.of(ProcessorProperty.builder()
     *                         .type("type")
     *                         // the properties below are optional
     *                         .parameters(List.of(ProcessorParameterProperty.builder()
     *                                 .parameterName("parameterName")
     *                                 .parameterValue("parameterValue")
     *                                 .build()))
     *                         .build()))
     *                 .build())
     *         .retryOptions(SnowflakeRetryOptionsProperty.builder()
     *                 .durationInSeconds(123)
     *                 .build())
     *         .s3BackupMode("s3BackupMode")
     *         .secretsManagerConfiguration(SecretsManagerConfigurationProperty.builder()
     *                 .enabled(false)
     *                 // the properties below are optional
     *                 .roleArn("roleArn")
     *                 .secretArn("secretArn")
     *                 .build())
     *         .snowflakeRoleConfiguration(SnowflakeRoleConfigurationProperty.builder()
     *                 .enabled(false)
     *                 .snowflakeRole("snowflakeRole")
     *                 .build())
     *         .snowflakeVpcConfiguration(SnowflakeVpcConfigurationProperty.builder()
     *                 .privateLinkVpceId("privateLinkVpceId")
     *                 .build())
     *         .user("user")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-snowflakedestinationconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-snowflakedestinationconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.SnowflakeDestinationConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(SnowflakeDestinationConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SnowflakeDestinationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * URL for accessing your Snowflake account.
         * <p>
         * This URL must include your <a href="https://docs.aws.amazon.com/https://docs.snowflake.com/en/user-guide/admin-account-identifier">account identifier</a> . Note that the protocol (https://) and port number are optional.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-snowflakedestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-snowflakedestinationconfiguration-accounturl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-snowflakedestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-snowflakedestinationconfiguration-accounturl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAccountUrl();

        /**
         * All data in Snowflake is maintained in databases.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-snowflakedestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-snowflakedestinationconfiguration-database">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-snowflakedestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-snowflakedestinationconfiguration-database</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDatabase();

        /**
         * The Amazon Resource Name (ARN) of the Snowflake role.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-snowflakedestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-snowflakedestinationconfiguration-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-snowflakedestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-snowflakedestinationconfiguration-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-snowflakedestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-snowflakedestinationconfiguration-s3configuration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-snowflakedestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-snowflakedestinationconfiguration-s3configuration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getS3Configuration();

        /**
         * Each database consists of one or more schemas, which are logical groupings of database objects, such as tables and views.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-snowflakedestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-snowflakedestinationconfiguration-schema">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-snowflakedestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-snowflakedestinationconfiguration-schema</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSchema();

        /**
         * All data in Snowflake is stored in database tables, logically structured as collections of columns and rows.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-snowflakedestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-snowflakedestinationconfiguration-table">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-snowflakedestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-snowflakedestinationconfiguration-table</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTable();

        /**
         * Describes the buffering to perform before delivering data to the Snowflake destination.
         * <p>
         * If you do not specify any value, Firehose uses the default values.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-snowflakedestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-snowflakedestinationconfiguration-bufferinghints">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-snowflakedestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-snowflakedestinationconfiguration-bufferinghints</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBufferingHints() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-snowflakedestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-snowflakedestinationconfiguration-cloudwatchloggingoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-snowflakedestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-snowflakedestinationconfiguration-cloudwatchloggingoptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCloudWatchLoggingOptions() {
            return null;
        }

        /**
         * The name of the record content column.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-snowflakedestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-snowflakedestinationconfiguration-contentcolumnname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-snowflakedestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-snowflakedestinationconfiguration-contentcolumnname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getContentColumnName() {
            return null;
        }

        /**
         * Choose to load JSON keys mapped to table column names or choose to split the JSON payload where content is mapped to a record content column and source metadata is mapped to a record metadata column.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-snowflakedestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-snowflakedestinationconfiguration-dataloadingoption">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-snowflakedestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-snowflakedestinationconfiguration-dataloadingoption</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDataLoadingOption() {
            return null;
        }

        /**
         * Passphrase to decrypt the private key when the key is encrypted.
         * <p>
         * For information, see <a href="https://docs.aws.amazon.com/https://docs.snowflake.com/en/user-guide/data-load-snowpipe-streaming-configuration#using-key-pair-authentication-key-rotation">Using Key Pair Authentication &amp; Key Rotation</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-snowflakedestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-snowflakedestinationconfiguration-keypassphrase">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-snowflakedestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-snowflakedestinationconfiguration-keypassphrase</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKeyPassphrase() {
            return null;
        }

        /**
         * Specify a column name in the table, where the metadata information has to be loaded.
         * <p>
         * When you enable this field, you will see the following column in the snowflake table, which differs based on the source type.
         * <p>
         * For Direct PUT as source
         * <p>
         * <code>{ "firehoseDeliveryStreamName" : "streamname", "IngestionTime" : "timestamp" }</code>
         * <p>
         * For Kinesis Data Stream as source
         * <p>
         * <code>"kinesisStreamName" : "streamname", "kinesisShardId" : "Id", "kinesisPartitionKey" : "key", "kinesisSequenceNumber" : "1234", "subsequenceNumber" : "2334", "IngestionTime" : "timestamp" }</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-snowflakedestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-snowflakedestinationconfiguration-metadatacolumnname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-snowflakedestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-snowflakedestinationconfiguration-metadatacolumnname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMetaDataColumnName() {
            return null;
        }

        /**
         * The private key used to encrypt your Snowflake client.
         * <p>
         * For information, see <a href="https://docs.aws.amazon.com/https://docs.snowflake.com/en/user-guide/data-load-snowpipe-streaming-configuration#using-key-pair-authentication-key-rotation">Using Key Pair Authentication &amp; Key Rotation</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-snowflakedestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-snowflakedestinationconfiguration-privatekey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-snowflakedestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-snowflakedestinationconfiguration-privatekey</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPrivateKey() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-snowflakedestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-snowflakedestinationconfiguration-processingconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-snowflakedestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-snowflakedestinationconfiguration-processingconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getProcessingConfiguration() {
            return null;
        }

        /**
         * The time period where Firehose will retry sending data to the chosen HTTP endpoint.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-snowflakedestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-snowflakedestinationconfiguration-retryoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-snowflakedestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-snowflakedestinationconfiguration-retryoptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRetryOptions() {
            return null;
        }

        /**
         * Choose an S3 backup mode.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-snowflakedestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-snowflakedestinationconfiguration-s3backupmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-snowflakedestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-snowflakedestinationconfiguration-s3backupmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3BackupMode() {
            return null;
        }

        /**
         * The configuration that defines how you access secrets for Snowflake.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-snowflakedestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-snowflakedestinationconfiguration-secretsmanagerconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-snowflakedestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-snowflakedestinationconfiguration-secretsmanagerconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSecretsManagerConfiguration() {
            return null;
        }

        /**
         * Optionally configure a Snowflake role.
         * <p>
         * Otherwise the default user role will be used.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-snowflakedestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-snowflakedestinationconfiguration-snowflakeroleconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-snowflakedestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-snowflakedestinationconfiguration-snowflakeroleconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSnowflakeRoleConfiguration() {
            return null;
        }

        /**
         * The VPCE ID for Firehose to privately connect with Snowflake.
         * <p>
         * The ID format is com.amazonaws.vpce.[region].vpce-svc-&lt;[id]&gt;. For more information, see <a href="https://docs.aws.amazon.com/https://docs.snowflake.com/en/user-guide/admin-security-privatelink">Amazon PrivateLink &amp; Snowflake</a>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-snowflakedestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-snowflakedestinationconfiguration-snowflakevpcconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-snowflakedestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-snowflakedestinationconfiguration-snowflakevpcconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSnowflakeVpcConfiguration() {
            return null;
        }

        /**
         * User login name for the Snowflake account.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-snowflakedestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-snowflakedestinationconfiguration-user">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-snowflakedestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-snowflakedestinationconfiguration-user</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUser() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SnowflakeDestinationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SnowflakeDestinationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SnowflakeDestinationConfigurationProperty> {
            java.lang.String accountUrl;
            java.lang.String database;
            java.lang.String roleArn;
            java.lang.Object s3Configuration;
            java.lang.String schema;
            java.lang.String table;
            java.lang.Object bufferingHints;
            java.lang.Object cloudWatchLoggingOptions;
            java.lang.String contentColumnName;
            java.lang.String dataLoadingOption;
            java.lang.String keyPassphrase;
            java.lang.String metaDataColumnName;
            java.lang.String privateKey;
            java.lang.Object processingConfiguration;
            java.lang.Object retryOptions;
            java.lang.String s3BackupMode;
            java.lang.Object secretsManagerConfiguration;
            java.lang.Object snowflakeRoleConfiguration;
            java.lang.Object snowflakeVpcConfiguration;
            java.lang.String user;

            /**
             * Sets the value of {@link SnowflakeDestinationConfigurationProperty#getAccountUrl}
             * @param accountUrl URL for accessing your Snowflake account. This parameter is required.
             *                   This URL must include your <a href="https://docs.aws.amazon.com/https://docs.snowflake.com/en/user-guide/admin-account-identifier">account identifier</a> . Note that the protocol (https://) and port number are optional.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accountUrl(java.lang.String accountUrl) {
                this.accountUrl = accountUrl;
                return this;
            }

            /**
             * Sets the value of {@link SnowflakeDestinationConfigurationProperty#getDatabase}
             * @param database All data in Snowflake is maintained in databases. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder database(java.lang.String database) {
                this.database = database;
                return this;
            }

            /**
             * Sets the value of {@link SnowflakeDestinationConfigurationProperty#getRoleArn}
             * @param roleArn The Amazon Resource Name (ARN) of the Snowflake role. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link SnowflakeDestinationConfigurationProperty#getS3Configuration}
             * @param s3Configuration the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Configuration(software.amazon.awscdk.IResolvable s3Configuration) {
                this.s3Configuration = s3Configuration;
                return this;
            }

            /**
             * Sets the value of {@link SnowflakeDestinationConfigurationProperty#getS3Configuration}
             * @param s3Configuration the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Configuration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.S3DestinationConfigurationProperty s3Configuration) {
                this.s3Configuration = s3Configuration;
                return this;
            }

            /**
             * Sets the value of {@link SnowflakeDestinationConfigurationProperty#getSchema}
             * @param schema Each database consists of one or more schemas, which are logical groupings of database objects, such as tables and views. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder schema(java.lang.String schema) {
                this.schema = schema;
                return this;
            }

            /**
             * Sets the value of {@link SnowflakeDestinationConfigurationProperty#getTable}
             * @param table All data in Snowflake is stored in database tables, logically structured as collections of columns and rows. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder table(java.lang.String table) {
                this.table = table;
                return this;
            }

            /**
             * Sets the value of {@link SnowflakeDestinationConfigurationProperty#getBufferingHints}
             * @param bufferingHints Describes the buffering to perform before delivering data to the Snowflake destination.
             *                       If you do not specify any value, Firehose uses the default values.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bufferingHints(software.amazon.awscdk.IResolvable bufferingHints) {
                this.bufferingHints = bufferingHints;
                return this;
            }

            /**
             * Sets the value of {@link SnowflakeDestinationConfigurationProperty#getBufferingHints}
             * @param bufferingHints Describes the buffering to perform before delivering data to the Snowflake destination.
             *                       If you do not specify any value, Firehose uses the default values.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bufferingHints(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.SnowflakeBufferingHintsProperty bufferingHints) {
                this.bufferingHints = bufferingHints;
                return this;
            }

            /**
             * Sets the value of {@link SnowflakeDestinationConfigurationProperty#getCloudWatchLoggingOptions}
             * @param cloudWatchLoggingOptions the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchLoggingOptions(software.amazon.awscdk.IResolvable cloudWatchLoggingOptions) {
                this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
                return this;
            }

            /**
             * Sets the value of {@link SnowflakeDestinationConfigurationProperty#getCloudWatchLoggingOptions}
             * @param cloudWatchLoggingOptions the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchLoggingOptions(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.CloudWatchLoggingOptionsProperty cloudWatchLoggingOptions) {
                this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
                return this;
            }

            /**
             * Sets the value of {@link SnowflakeDestinationConfigurationProperty#getContentColumnName}
             * @param contentColumnName The name of the record content column.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder contentColumnName(java.lang.String contentColumnName) {
                this.contentColumnName = contentColumnName;
                return this;
            }

            /**
             * Sets the value of {@link SnowflakeDestinationConfigurationProperty#getDataLoadingOption}
             * @param dataLoadingOption Choose to load JSON keys mapped to table column names or choose to split the JSON payload where content is mapped to a record content column and source metadata is mapped to a record metadata column.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataLoadingOption(java.lang.String dataLoadingOption) {
                this.dataLoadingOption = dataLoadingOption;
                return this;
            }

            /**
             * Sets the value of {@link SnowflakeDestinationConfigurationProperty#getKeyPassphrase}
             * @param keyPassphrase Passphrase to decrypt the private key when the key is encrypted.
             *                      For information, see <a href="https://docs.aws.amazon.com/https://docs.snowflake.com/en/user-guide/data-load-snowpipe-streaming-configuration#using-key-pair-authentication-key-rotation">Using Key Pair Authentication &amp; Key Rotation</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyPassphrase(java.lang.String keyPassphrase) {
                this.keyPassphrase = keyPassphrase;
                return this;
            }

            /**
             * Sets the value of {@link SnowflakeDestinationConfigurationProperty#getMetaDataColumnName}
             * @param metaDataColumnName Specify a column name in the table, where the metadata information has to be loaded.
             *                           When you enable this field, you will see the following column in the snowflake table, which differs based on the source type.
             *                           <p>
             *                           For Direct PUT as source
             *                           <p>
             *                           <code>{ "firehoseDeliveryStreamName" : "streamname", "IngestionTime" : "timestamp" }</code>
             *                           <p>
             *                           For Kinesis Data Stream as source
             *                           <p>
             *                           <code>"kinesisStreamName" : "streamname", "kinesisShardId" : "Id", "kinesisPartitionKey" : "key", "kinesisSequenceNumber" : "1234", "subsequenceNumber" : "2334", "IngestionTime" : "timestamp" }</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metaDataColumnName(java.lang.String metaDataColumnName) {
                this.metaDataColumnName = metaDataColumnName;
                return this;
            }

            /**
             * Sets the value of {@link SnowflakeDestinationConfigurationProperty#getPrivateKey}
             * @param privateKey The private key used to encrypt your Snowflake client.
             *                   For information, see <a href="https://docs.aws.amazon.com/https://docs.snowflake.com/en/user-guide/data-load-snowpipe-streaming-configuration#using-key-pair-authentication-key-rotation">Using Key Pair Authentication &amp; Key Rotation</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder privateKey(java.lang.String privateKey) {
                this.privateKey = privateKey;
                return this;
            }

            /**
             * Sets the value of {@link SnowflakeDestinationConfigurationProperty#getProcessingConfiguration}
             * @param processingConfiguration the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder processingConfiguration(software.amazon.awscdk.IResolvable processingConfiguration) {
                this.processingConfiguration = processingConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link SnowflakeDestinationConfigurationProperty#getProcessingConfiguration}
             * @param processingConfiguration the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder processingConfiguration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.ProcessingConfigurationProperty processingConfiguration) {
                this.processingConfiguration = processingConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link SnowflakeDestinationConfigurationProperty#getRetryOptions}
             * @param retryOptions The time period where Firehose will retry sending data to the chosen HTTP endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retryOptions(software.amazon.awscdk.IResolvable retryOptions) {
                this.retryOptions = retryOptions;
                return this;
            }

            /**
             * Sets the value of {@link SnowflakeDestinationConfigurationProperty#getRetryOptions}
             * @param retryOptions The time period where Firehose will retry sending data to the chosen HTTP endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retryOptions(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.SnowflakeRetryOptionsProperty retryOptions) {
                this.retryOptions = retryOptions;
                return this;
            }

            /**
             * Sets the value of {@link SnowflakeDestinationConfigurationProperty#getS3BackupMode}
             * @param s3BackupMode Choose an S3 backup mode.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3BackupMode(java.lang.String s3BackupMode) {
                this.s3BackupMode = s3BackupMode;
                return this;
            }

            /**
             * Sets the value of {@link SnowflakeDestinationConfigurationProperty#getSecretsManagerConfiguration}
             * @param secretsManagerConfiguration The configuration that defines how you access secrets for Snowflake.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerConfiguration(software.amazon.awscdk.IResolvable secretsManagerConfiguration) {
                this.secretsManagerConfiguration = secretsManagerConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link SnowflakeDestinationConfigurationProperty#getSecretsManagerConfiguration}
             * @param secretsManagerConfiguration The configuration that defines how you access secrets for Snowflake.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretsManagerConfiguration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.SecretsManagerConfigurationProperty secretsManagerConfiguration) {
                this.secretsManagerConfiguration = secretsManagerConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link SnowflakeDestinationConfigurationProperty#getSnowflakeRoleConfiguration}
             * @param snowflakeRoleConfiguration Optionally configure a Snowflake role.
             *                                   Otherwise the default user role will be used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder snowflakeRoleConfiguration(software.amazon.awscdk.IResolvable snowflakeRoleConfiguration) {
                this.snowflakeRoleConfiguration = snowflakeRoleConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link SnowflakeDestinationConfigurationProperty#getSnowflakeRoleConfiguration}
             * @param snowflakeRoleConfiguration Optionally configure a Snowflake role.
             *                                   Otherwise the default user role will be used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder snowflakeRoleConfiguration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.SnowflakeRoleConfigurationProperty snowflakeRoleConfiguration) {
                this.snowflakeRoleConfiguration = snowflakeRoleConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link SnowflakeDestinationConfigurationProperty#getSnowflakeVpcConfiguration}
             * @param snowflakeVpcConfiguration The VPCE ID for Firehose to privately connect with Snowflake.
             *                                  The ID format is com.amazonaws.vpce.[region].vpce-svc-&lt;[id]&gt;. For more information, see <a href="https://docs.aws.amazon.com/https://docs.snowflake.com/en/user-guide/admin-security-privatelink">Amazon PrivateLink &amp; Snowflake</a>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder snowflakeVpcConfiguration(software.amazon.awscdk.IResolvable snowflakeVpcConfiguration) {
                this.snowflakeVpcConfiguration = snowflakeVpcConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link SnowflakeDestinationConfigurationProperty#getSnowflakeVpcConfiguration}
             * @param snowflakeVpcConfiguration The VPCE ID for Firehose to privately connect with Snowflake.
             *                                  The ID format is com.amazonaws.vpce.[region].vpce-svc-&lt;[id]&gt;. For more information, see <a href="https://docs.aws.amazon.com/https://docs.snowflake.com/en/user-guide/admin-security-privatelink">Amazon PrivateLink &amp; Snowflake</a>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder snowflakeVpcConfiguration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.SnowflakeVpcConfigurationProperty snowflakeVpcConfiguration) {
                this.snowflakeVpcConfiguration = snowflakeVpcConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link SnowflakeDestinationConfigurationProperty#getUser}
             * @param user User login name for the Snowflake account.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder user(java.lang.String user) {
                this.user = user;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SnowflakeDestinationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SnowflakeDestinationConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SnowflakeDestinationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SnowflakeDestinationConfigurationProperty {
            private final java.lang.String accountUrl;
            private final java.lang.String database;
            private final java.lang.String roleArn;
            private final java.lang.Object s3Configuration;
            private final java.lang.String schema;
            private final java.lang.String table;
            private final java.lang.Object bufferingHints;
            private final java.lang.Object cloudWatchLoggingOptions;
            private final java.lang.String contentColumnName;
            private final java.lang.String dataLoadingOption;
            private final java.lang.String keyPassphrase;
            private final java.lang.String metaDataColumnName;
            private final java.lang.String privateKey;
            private final java.lang.Object processingConfiguration;
            private final java.lang.Object retryOptions;
            private final java.lang.String s3BackupMode;
            private final java.lang.Object secretsManagerConfiguration;
            private final java.lang.Object snowflakeRoleConfiguration;
            private final java.lang.Object snowflakeVpcConfiguration;
            private final java.lang.String user;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.accountUrl = software.amazon.jsii.Kernel.get(this, "accountUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.database = software.amazon.jsii.Kernel.get(this, "database", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3Configuration = software.amazon.jsii.Kernel.get(this, "s3Configuration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.schema = software.amazon.jsii.Kernel.get(this, "schema", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.table = software.amazon.jsii.Kernel.get(this, "table", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.bufferingHints = software.amazon.jsii.Kernel.get(this, "bufferingHints", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.cloudWatchLoggingOptions = software.amazon.jsii.Kernel.get(this, "cloudWatchLoggingOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.contentColumnName = software.amazon.jsii.Kernel.get(this, "contentColumnName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dataLoadingOption = software.amazon.jsii.Kernel.get(this, "dataLoadingOption", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.keyPassphrase = software.amazon.jsii.Kernel.get(this, "keyPassphrase", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.metaDataColumnName = software.amazon.jsii.Kernel.get(this, "metaDataColumnName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.privateKey = software.amazon.jsii.Kernel.get(this, "privateKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.processingConfiguration = software.amazon.jsii.Kernel.get(this, "processingConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.retryOptions = software.amazon.jsii.Kernel.get(this, "retryOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.s3BackupMode = software.amazon.jsii.Kernel.get(this, "s3BackupMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secretsManagerConfiguration = software.amazon.jsii.Kernel.get(this, "secretsManagerConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.snowflakeRoleConfiguration = software.amazon.jsii.Kernel.get(this, "snowflakeRoleConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.snowflakeVpcConfiguration = software.amazon.jsii.Kernel.get(this, "snowflakeVpcConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.user = software.amazon.jsii.Kernel.get(this, "user", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.accountUrl = java.util.Objects.requireNonNull(builder.accountUrl, "accountUrl is required");
                this.database = java.util.Objects.requireNonNull(builder.database, "database is required");
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
                this.s3Configuration = java.util.Objects.requireNonNull(builder.s3Configuration, "s3Configuration is required");
                this.schema = java.util.Objects.requireNonNull(builder.schema, "schema is required");
                this.table = java.util.Objects.requireNonNull(builder.table, "table is required");
                this.bufferingHints = builder.bufferingHints;
                this.cloudWatchLoggingOptions = builder.cloudWatchLoggingOptions;
                this.contentColumnName = builder.contentColumnName;
                this.dataLoadingOption = builder.dataLoadingOption;
                this.keyPassphrase = builder.keyPassphrase;
                this.metaDataColumnName = builder.metaDataColumnName;
                this.privateKey = builder.privateKey;
                this.processingConfiguration = builder.processingConfiguration;
                this.retryOptions = builder.retryOptions;
                this.s3BackupMode = builder.s3BackupMode;
                this.secretsManagerConfiguration = builder.secretsManagerConfiguration;
                this.snowflakeRoleConfiguration = builder.snowflakeRoleConfiguration;
                this.snowflakeVpcConfiguration = builder.snowflakeVpcConfiguration;
                this.user = builder.user;
            }

            @Override
            public final java.lang.String getAccountUrl() {
                return this.accountUrl;
            }

            @Override
            public final java.lang.String getDatabase() {
                return this.database;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.Object getS3Configuration() {
                return this.s3Configuration;
            }

            @Override
            public final java.lang.String getSchema() {
                return this.schema;
            }

            @Override
            public final java.lang.String getTable() {
                return this.table;
            }

            @Override
            public final java.lang.Object getBufferingHints() {
                return this.bufferingHints;
            }

            @Override
            public final java.lang.Object getCloudWatchLoggingOptions() {
                return this.cloudWatchLoggingOptions;
            }

            @Override
            public final java.lang.String getContentColumnName() {
                return this.contentColumnName;
            }

            @Override
            public final java.lang.String getDataLoadingOption() {
                return this.dataLoadingOption;
            }

            @Override
            public final java.lang.String getKeyPassphrase() {
                return this.keyPassphrase;
            }

            @Override
            public final java.lang.String getMetaDataColumnName() {
                return this.metaDataColumnName;
            }

            @Override
            public final java.lang.String getPrivateKey() {
                return this.privateKey;
            }

            @Override
            public final java.lang.Object getProcessingConfiguration() {
                return this.processingConfiguration;
            }

            @Override
            public final java.lang.Object getRetryOptions() {
                return this.retryOptions;
            }

            @Override
            public final java.lang.String getS3BackupMode() {
                return this.s3BackupMode;
            }

            @Override
            public final java.lang.Object getSecretsManagerConfiguration() {
                return this.secretsManagerConfiguration;
            }

            @Override
            public final java.lang.Object getSnowflakeRoleConfiguration() {
                return this.snowflakeRoleConfiguration;
            }

            @Override
            public final java.lang.Object getSnowflakeVpcConfiguration() {
                return this.snowflakeVpcConfiguration;
            }

            @Override
            public final java.lang.String getUser() {
                return this.user;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("accountUrl", om.valueToTree(this.getAccountUrl()));
                data.set("database", om.valueToTree(this.getDatabase()));
                data.set("roleArn", om.valueToTree(this.getRoleArn()));
                data.set("s3Configuration", om.valueToTree(this.getS3Configuration()));
                data.set("schema", om.valueToTree(this.getSchema()));
                data.set("table", om.valueToTree(this.getTable()));
                if (this.getBufferingHints() != null) {
                    data.set("bufferingHints", om.valueToTree(this.getBufferingHints()));
                }
                if (this.getCloudWatchLoggingOptions() != null) {
                    data.set("cloudWatchLoggingOptions", om.valueToTree(this.getCloudWatchLoggingOptions()));
                }
                if (this.getContentColumnName() != null) {
                    data.set("contentColumnName", om.valueToTree(this.getContentColumnName()));
                }
                if (this.getDataLoadingOption() != null) {
                    data.set("dataLoadingOption", om.valueToTree(this.getDataLoadingOption()));
                }
                if (this.getKeyPassphrase() != null) {
                    data.set("keyPassphrase", om.valueToTree(this.getKeyPassphrase()));
                }
                if (this.getMetaDataColumnName() != null) {
                    data.set("metaDataColumnName", om.valueToTree(this.getMetaDataColumnName()));
                }
                if (this.getPrivateKey() != null) {
                    data.set("privateKey", om.valueToTree(this.getPrivateKey()));
                }
                if (this.getProcessingConfiguration() != null) {
                    data.set("processingConfiguration", om.valueToTree(this.getProcessingConfiguration()));
                }
                if (this.getRetryOptions() != null) {
                    data.set("retryOptions", om.valueToTree(this.getRetryOptions()));
                }
                if (this.getS3BackupMode() != null) {
                    data.set("s3BackupMode", om.valueToTree(this.getS3BackupMode()));
                }
                if (this.getSecretsManagerConfiguration() != null) {
                    data.set("secretsManagerConfiguration", om.valueToTree(this.getSecretsManagerConfiguration()));
                }
                if (this.getSnowflakeRoleConfiguration() != null) {
                    data.set("snowflakeRoleConfiguration", om.valueToTree(this.getSnowflakeRoleConfiguration()));
                }
                if (this.getSnowflakeVpcConfiguration() != null) {
                    data.set("snowflakeVpcConfiguration", om.valueToTree(this.getSnowflakeVpcConfiguration()));
                }
                if (this.getUser() != null) {
                    data.set("user", om.valueToTree(this.getUser()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.SnowflakeDestinationConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SnowflakeDestinationConfigurationProperty.Jsii$Proxy that = (SnowflakeDestinationConfigurationProperty.Jsii$Proxy) o;

                if (!accountUrl.equals(that.accountUrl)) return false;
                if (!database.equals(that.database)) return false;
                if (!roleArn.equals(that.roleArn)) return false;
                if (!s3Configuration.equals(that.s3Configuration)) return false;
                if (!schema.equals(that.schema)) return false;
                if (!table.equals(that.table)) return false;
                if (this.bufferingHints != null ? !this.bufferingHints.equals(that.bufferingHints) : that.bufferingHints != null) return false;
                if (this.cloudWatchLoggingOptions != null ? !this.cloudWatchLoggingOptions.equals(that.cloudWatchLoggingOptions) : that.cloudWatchLoggingOptions != null) return false;
                if (this.contentColumnName != null ? !this.contentColumnName.equals(that.contentColumnName) : that.contentColumnName != null) return false;
                if (this.dataLoadingOption != null ? !this.dataLoadingOption.equals(that.dataLoadingOption) : that.dataLoadingOption != null) return false;
                if (this.keyPassphrase != null ? !this.keyPassphrase.equals(that.keyPassphrase) : that.keyPassphrase != null) return false;
                if (this.metaDataColumnName != null ? !this.metaDataColumnName.equals(that.metaDataColumnName) : that.metaDataColumnName != null) return false;
                if (this.privateKey != null ? !this.privateKey.equals(that.privateKey) : that.privateKey != null) return false;
                if (this.processingConfiguration != null ? !this.processingConfiguration.equals(that.processingConfiguration) : that.processingConfiguration != null) return false;
                if (this.retryOptions != null ? !this.retryOptions.equals(that.retryOptions) : that.retryOptions != null) return false;
                if (this.s3BackupMode != null ? !this.s3BackupMode.equals(that.s3BackupMode) : that.s3BackupMode != null) return false;
                if (this.secretsManagerConfiguration != null ? !this.secretsManagerConfiguration.equals(that.secretsManagerConfiguration) : that.secretsManagerConfiguration != null) return false;
                if (this.snowflakeRoleConfiguration != null ? !this.snowflakeRoleConfiguration.equals(that.snowflakeRoleConfiguration) : that.snowflakeRoleConfiguration != null) return false;
                if (this.snowflakeVpcConfiguration != null ? !this.snowflakeVpcConfiguration.equals(that.snowflakeVpcConfiguration) : that.snowflakeVpcConfiguration != null) return false;
                return this.user != null ? this.user.equals(that.user) : that.user == null;
            }

            @Override
            public final int hashCode() {
                int result = this.accountUrl.hashCode();
                result = 31 * result + (this.database.hashCode());
                result = 31 * result + (this.roleArn.hashCode());
                result = 31 * result + (this.s3Configuration.hashCode());
                result = 31 * result + (this.schema.hashCode());
                result = 31 * result + (this.table.hashCode());
                result = 31 * result + (this.bufferingHints != null ? this.bufferingHints.hashCode() : 0);
                result = 31 * result + (this.cloudWatchLoggingOptions != null ? this.cloudWatchLoggingOptions.hashCode() : 0);
                result = 31 * result + (this.contentColumnName != null ? this.contentColumnName.hashCode() : 0);
                result = 31 * result + (this.dataLoadingOption != null ? this.dataLoadingOption.hashCode() : 0);
                result = 31 * result + (this.keyPassphrase != null ? this.keyPassphrase.hashCode() : 0);
                result = 31 * result + (this.metaDataColumnName != null ? this.metaDataColumnName.hashCode() : 0);
                result = 31 * result + (this.privateKey != null ? this.privateKey.hashCode() : 0);
                result = 31 * result + (this.processingConfiguration != null ? this.processingConfiguration.hashCode() : 0);
                result = 31 * result + (this.retryOptions != null ? this.retryOptions.hashCode() : 0);
                result = 31 * result + (this.s3BackupMode != null ? this.s3BackupMode.hashCode() : 0);
                result = 31 * result + (this.secretsManagerConfiguration != null ? this.secretsManagerConfiguration.hashCode() : 0);
                result = 31 * result + (this.snowflakeRoleConfiguration != null ? this.snowflakeRoleConfiguration.hashCode() : 0);
                result = 31 * result + (this.snowflakeVpcConfiguration != null ? this.snowflakeVpcConfiguration.hashCode() : 0);
                result = 31 * result + (this.user != null ? this.user.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specify how long Firehose retries sending data to the New Relic HTTP endpoint.
     * <p>
     * After sending data, Firehose first waits for an acknowledgment from the HTTP endpoint. If an error occurs or the acknowledgment doesn’t arrive within the acknowledgment timeout period, Firehose starts the retry duration counter. It keeps retrying until the retry duration expires. After that, Firehose considers it a data delivery failure and backs up the data to your Amazon S3 bucket. Every time that Firehose sends data to the HTTP endpoint (either the initial attempt or a retry), it restarts the acknowledgement timeout counter and waits for an acknowledgement from the HTTP endpoint. Even if the retry duration expires, Firehose still waits for the acknowledgment until it receives it or the acknowledgement timeout period is reached. If the acknowledgment times out, Firehose determines whether there's time left in the retry counter. If there is time left, it retries again and repeats the logic until it receives an acknowledgment or determines that the retry time has expired. If you don't want Firehose to retry sending data, set this value to 0.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * SnowflakeRetryOptionsProperty snowflakeRetryOptionsProperty = SnowflakeRetryOptionsProperty.builder()
     *         .durationInSeconds(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-snowflakeretryoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-snowflakeretryoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.SnowflakeRetryOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(SnowflakeRetryOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SnowflakeRetryOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * the time period where Firehose will retry sending data to the chosen HTTP endpoint.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-snowflakeretryoptions.html#cfn-kinesisfirehose-deliverystream-snowflakeretryoptions-durationinseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-snowflakeretryoptions.html#cfn-kinesisfirehose-deliverystream-snowflakeretryoptions-durationinseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDurationInSeconds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SnowflakeRetryOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SnowflakeRetryOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SnowflakeRetryOptionsProperty> {
            java.lang.Number durationInSeconds;

            /**
             * Sets the value of {@link SnowflakeRetryOptionsProperty#getDurationInSeconds}
             * @param durationInSeconds the time period where Firehose will retry sending data to the chosen HTTP endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder durationInSeconds(java.lang.Number durationInSeconds) {
                this.durationInSeconds = durationInSeconds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SnowflakeRetryOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SnowflakeRetryOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SnowflakeRetryOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SnowflakeRetryOptionsProperty {
            private final java.lang.Number durationInSeconds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.durationInSeconds = software.amazon.jsii.Kernel.get(this, "durationInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.durationInSeconds = builder.durationInSeconds;
            }

            @Override
            public final java.lang.Number getDurationInSeconds() {
                return this.durationInSeconds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDurationInSeconds() != null) {
                    data.set("durationInSeconds", om.valueToTree(this.getDurationInSeconds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.SnowflakeRetryOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SnowflakeRetryOptionsProperty.Jsii$Proxy that = (SnowflakeRetryOptionsProperty.Jsii$Proxy) o;

                return this.durationInSeconds != null ? this.durationInSeconds.equals(that.durationInSeconds) : that.durationInSeconds == null;
            }

            @Override
            public final int hashCode() {
                int result = this.durationInSeconds != null ? this.durationInSeconds.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Optionally configure a Snowflake role.
     * <p>
     * Otherwise the default user role will be used.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * SnowflakeRoleConfigurationProperty snowflakeRoleConfigurationProperty = SnowflakeRoleConfigurationProperty.builder()
     *         .enabled(false)
     *         .snowflakeRole("snowflakeRole")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-snowflakeroleconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-snowflakeroleconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.SnowflakeRoleConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(SnowflakeRoleConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SnowflakeRoleConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Enable Snowflake role.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-snowflakeroleconfiguration.html#cfn-kinesisfirehose-deliverystream-snowflakeroleconfiguration-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-snowflakeroleconfiguration.html#cfn-kinesisfirehose-deliverystream-snowflakeroleconfiguration-enabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * The Snowflake role you wish to configure.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-snowflakeroleconfiguration.html#cfn-kinesisfirehose-deliverystream-snowflakeroleconfiguration-snowflakerole">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-snowflakeroleconfiguration.html#cfn-kinesisfirehose-deliverystream-snowflakeroleconfiguration-snowflakerole</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSnowflakeRole() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SnowflakeRoleConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SnowflakeRoleConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SnowflakeRoleConfigurationProperty> {
            java.lang.Object enabled;
            java.lang.String snowflakeRole;

            /**
             * Sets the value of {@link SnowflakeRoleConfigurationProperty#getEnabled}
             * @param enabled Enable Snowflake role.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link SnowflakeRoleConfigurationProperty#getEnabled}
             * @param enabled Enable Snowflake role.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link SnowflakeRoleConfigurationProperty#getSnowflakeRole}
             * @param snowflakeRole The Snowflake role you wish to configure.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder snowflakeRole(java.lang.String snowflakeRole) {
                this.snowflakeRole = snowflakeRole;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SnowflakeRoleConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SnowflakeRoleConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SnowflakeRoleConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SnowflakeRoleConfigurationProperty {
            private final java.lang.Object enabled;
            private final java.lang.String snowflakeRole;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.snowflakeRole = software.amazon.jsii.Kernel.get(this, "snowflakeRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = builder.enabled;
                this.snowflakeRole = builder.snowflakeRole;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.String getSnowflakeRole() {
                return this.snowflakeRole;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }
                if (this.getSnowflakeRole() != null) {
                    data.set("snowflakeRole", om.valueToTree(this.getSnowflakeRole()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.SnowflakeRoleConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SnowflakeRoleConfigurationProperty.Jsii$Proxy that = (SnowflakeRoleConfigurationProperty.Jsii$Proxy) o;

                if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
                return this.snowflakeRole != null ? this.snowflakeRole.equals(that.snowflakeRole) : that.snowflakeRole == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled != null ? this.enabled.hashCode() : 0;
                result = 31 * result + (this.snowflakeRole != null ? this.snowflakeRole.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configure a Snowflake VPC.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.kinesisfirehose.*;
     * SnowflakeVpcConfigurationProperty snowflakeVpcConfigurationProperty = SnowflakeVpcConfigurationProperty.builder()
     *         .privateLinkVpceId("privateLinkVpceId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-snowflakevpcconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-snowflakevpcconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStream.SnowflakeVpcConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(SnowflakeVpcConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SnowflakeVpcConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The VPCE ID for Firehose to privately connect with Snowflake.
         * <p>
         * The ID format is com.amazonaws.vpce.[region].vpce-svc-&lt;[id]&gt;. For more information, see <a href="https://docs.aws.amazon.com/https://docs.snowflake.com/en/user-guide/admin-security-privatelink">Amazon PrivateLink &amp; Snowflake</a>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-snowflakevpcconfiguration.html#cfn-kinesisfirehose-deliverystream-snowflakevpcconfiguration-privatelinkvpceid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-snowflakevpcconfiguration.html#cfn-kinesisfirehose-deliverystream-snowflakevpcconfiguration-privatelinkvpceid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPrivateLinkVpceId();

        /**
         * @return a {@link Builder} of {@link SnowflakeVpcConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SnowflakeVpcConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SnowflakeVpcConfigurationProperty> {
            java.lang.String privateLinkVpceId;

            /**
             * Sets the value of {@link SnowflakeVpcConfigurationProperty#getPrivateLinkVpceId}
             * @param privateLinkVpceId The VPCE ID for Firehose to privately connect with Snowflake. This parameter is required.
             *                          The ID format is com.amazonaws.vpce.[region].vpce-svc-&lt;[id]&gt;. For more information, see <a href="https://docs.aws.amazon.com/https://docs.snowflake.com/en/user-guide/admin-security-privatelink">Amazon PrivateLink &amp; Snowflake</a>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder privateLinkVpceId(java.lang.String privateLinkVpceId) {
                this.privateLinkVpceId = privateLinkVpceId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SnowflakeVpcConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SnowflakeVpcConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SnowflakeVpcConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SnowflakeVpcConfigurationProperty {
            private final java.lang.String privateLinkVpceId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
  