package software.amazon.awscdk.services.iotcoredeviceadvisor;

/**
 * Creates a Device Advisor test suite.
 * <p>
 * Requires permission to access the <a href="https://docs.aws.amazon.com//service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">CreateSuiteDefinition</a> action.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iotcoredeviceadvisor.*;
 * Object suiteDefinitionConfiguration;
 * CfnSuiteDefinition cfnSuiteDefinition = CfnSuiteDefinition.Builder.create(this, "MyCfnSuiteDefinition")
 *         .suiteDefinitionConfiguration(suiteDefinitionConfiguration)
 *         // the properties below are optional
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotcoredeviceadvisor-suitedefinition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotcoredeviceadvisor-suitedefinition.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:14.790Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotcoredeviceadvisor.CfnSuiteDefinition")
public class CfnSuiteDefinition extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnSuiteDefinition(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnSuiteDefinition(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.iotcoredeviceadvisor.CfnSuiteDefinition.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnSuiteDefinition(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iotcoredeviceadvisor.CfnSuiteDefinitionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Arn of the Suite Definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrSuiteDefinitionArn() {
        return software.amazon.jsii.Kernel.get(this, "attrSuiteDefinitionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The version of the Suite Definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrSuiteDefinitionId() {
        return software.amazon.jsii.Kernel.get(this, "attrSuiteDefinitionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the Suite Definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrSuiteDefinitionVersion() {
        return software.amazon.jsii.Kernel.get(this, "attrSuiteDefinitionVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The configuration of the Suite Definition.
     * <p>
     * Listed below are the required elements of the <code>SuiteDefinitionConfiguration</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getSuiteDefinitionConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "suiteDefinitionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The configuration of the Suite Definition.
     * <p>
     * Listed below are the required elements of the <code>SuiteDefinitionConfiguration</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSuiteDefinitionConfiguration(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "suiteDefinitionConfiguration", java.util.Objects.requireNonNull(value, "suiteDefinitionConfiguration is required"));
    }

    /**
     * Metadata that can be used to manage the the Suite Definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Metadata that can be used to manage the the Suite Definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * Information of a test device.
     * <p>
     * A thing ARN, certificate ARN or device role ARN is required.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotcoredeviceadvisor.*;
     * DeviceUnderTestProperty deviceUnderTestProperty = DeviceUnderTestProperty.builder()
     *         .certificateArn("certificateArn")
     *         .thingArn("thingArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotcoredeviceadvisor-suitedefinition-deviceundertest.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotcoredeviceadvisor-suitedefinition-deviceundertest.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotcoredeviceadvisor.CfnSuiteDefinition.DeviceUnderTestProperty")
    @software.amazon.jsii.Jsii.Proxy(DeviceUnderTestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DeviceUnderTestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Lists device's certificate ARN.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotcoredeviceadvisor-suitedefinition-deviceundertest.html#cfn-iotcoredeviceadvisor-suitedefinition-deviceundertest-certificatearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotcoredeviceadvisor-suitedefinition-deviceundertest.html#cfn-iotcoredeviceadvisor-suitedefinition-deviceundertest-certificatearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCertificateArn() {
            return null;
        }

        /**
         * Lists device's thing ARN.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotcoredeviceadvisor-suitedefinition-deviceundertest.html#cfn-iotcoredeviceadvisor-suitedefinition-deviceundertest-thingarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotcoredeviceadvisor-suitedefinition-deviceundertest.html#cfn-iotcoredeviceadvisor-suitedefinition-deviceundertest-thingarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getThingArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DeviceUnderTestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DeviceUnderTestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DeviceUnderTestProperty> {
            java.lang.String certificateArn;
            java.lang.String thingArn;

            /**
             * Sets the value of {@link DeviceUnderTestProperty#getCertificateArn}
             * @param certificateArn Lists device's certificate ARN.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder certificateArn(java.lang.String certificateArn) {
                this.certificateArn = certificateArn;
                return this;
            }

            /**
             * Sets the value of {@link DeviceUnderTestProperty#getThingArn}
             * @param thingArn Lists device's thing ARN.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder thingArn(java.lang.String thingArn) {
                this.thingArn = thingArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DeviceUnderTestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DeviceUnderTestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DeviceUnderTestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeviceUnderTestProperty {
            private final java.lang.String certificateArn;
            private final java.lang.String thingArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.certificateArn = software.amazon.jsii.Kernel.get(this, "certificateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.thingArn = software.amazon.jsii.Kernel.get(this, "thingArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.certificateArn = builder.certificateArn;
                this.thingArn = builder.thingArn;
            }

            @Override
            public final java.lang.String getCertificateArn() {
                return this.certificateArn;
            }

            @Override
            public final java.lang.String getThingArn() {
                return this.thingArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCertificateArn() != null) {
                    data.set("certificateArn", om.valueToTree(this.getCertificateArn()));
                }
                if (this.getThingArn() != null) {
                    data.set("thingArn", om.valueToTree(this.getThingArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotcoredeviceadvisor.CfnSuiteDefinition.DeviceUnderTestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DeviceUnderTestProperty.Jsii$Proxy that = (DeviceUnderTestProperty.Jsii$Proxy) o;

                if (this.certificateArn != null ? !this.certificateArn.equals(that.certificateArn) : that.certificateArn != null) return false;
                return this.thingArn != null ? this.thingArn.equals(that.thingArn) : that.thingArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.certificateArn != null ? this.certificateArn.hashCode() : 0;
                result = 31 * result + (this.thingArn != null ? this.thingArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Gets the suite definition configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotcoredeviceadvisor.*;
     * SuiteDefinitionConfigurationProperty suiteDefinitionConfigurationProperty = SuiteDefinitionConfigurationProperty.builder()
     *         .devicePermissionRoleArn("devicePermissionRoleArn")
     *         .rootGroup("rootGroup")
     *         // the properties below are optional
     *         .devices(List.of(DeviceUnderTestProperty.builder()
     *                 .certificateArn("certificateArn")
     *                 .thingArn("thingArn")
     *                 .build()))
     *         .intendedForQualification(false)
     *         .suiteDefinitionName("suiteDefinitionName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotcoredeviceadvisor-suitedefinition-suitedefinitionconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotcoredeviceadvisor-suitedefinition-suitedefinitionconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotcoredeviceadvisor.CfnSuiteDefinition.SuiteDefinitionConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(SuiteDefinitionConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SuiteDefinitionConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Gets the device permission ARN.
         * <p>
         * This is a required parameter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotcoredeviceadvisor-suitedefinition-suitedefinitionconfiguration.html#cfn-iotcoredeviceadvisor-suitedefinition-suitedefinitionconfiguration-devicepermissionrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotcoredeviceadvisor-suitedefinition-suitedefinitionconfiguration.html#cfn-iotcoredeviceadvisor-suitedefinition-suitedefinitionconfiguration-devicepermissionrolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDevicePermissionRoleArn();

        /**
         * Gets the test suite root group.
         * <p>
         * This is a required parameter. For updating or creating the latest qualification suite, if <code>intendedForQualification</code> is set to true, <code>rootGroup</code> can be an empty string. If <code>intendedForQualification</code> is false, <code>rootGroup</code> cannot be an empty string. If <code>rootGroup</code> is empty, and <code>intendedForQualification</code> is set to true, all the qualification tests are included, and the configuration is default.
         * <p>
         * For a qualification suite, the minimum length is 0, and the maximum is 2048. For a non-qualification suite, the minimum length is 1, and the maximum is 2048.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotcoredeviceadvisor-suitedefinition-suitedefinitionconfiguration.html#cfn-iotcoredeviceadvisor-suitedefinition-suitedefinitionconfiguration-rootgroup">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotcoredeviceadvisor-suitedefinition-suitedefinitionconfiguration.html#cfn-iotcoredeviceadvisor-suitedefinition-suitedefinitionconfiguration-rootgroup</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRootGroup();

        /**
         * Gets the devices configured.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotcoredeviceadvisor-suitedefinition-suitedefinitionconfiguration.html#cfn-iotcoredeviceadvisor-suitedefinition-suitedefinitionconfiguration-devices">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotcoredeviceadvisor-suitedefinition-suitedefinitionconfiguration.html#cfn-iotcoredeviceadvisor-suitedefinition-suitedefinitionconfiguration-devices</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDevices() {
            return null;
        }

        /**
         * Gets the tests intended for qualification in a suite.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotcoredeviceadvisor-suitedefinition-suitedefinitionconfiguration.html#cfn-iotcoredeviceadvisor-suitedefinition-suitedefinitionconfiguration-intendedforqualification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotcoredeviceadvisor-suitedefinition-suitedefinitionconfiguration.html#cfn-iotcoredeviceadvisor-suitedefinition-suitedefinitionconfiguration-intendedforqualification</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIntendedForQualification() {
            return null;
        }

        /**
         * Gets the suite definition name.
         * <p>
         * This is a required parameter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotcoredeviceadvisor-suitedefinition-suitedefinitionconfiguration.html#cfn-iotcoredeviceadvisor-suitedefinition-suitedefinitionconfiguration-suitedefinitionname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotcoredeviceadvisor-suitedefinition-suitedefinitionconfiguration.html#cfn-iotcoredeviceadvisor-suitedefinition-suitedefinitionconfiguration-suitedefinitionname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSuiteDefinitionName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SuiteDefinitionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SuiteDefinitionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SuiteDefinitionConfigurationProperty> {
            java.lang.String devicePermissionRoleArn;
            java.lang.String rootGroup;
            java.lang.Object devices;
            java.lang.Object intendedForQualification;
            java.lang.String suiteDefinitionName;

            /**
             * Sets the value of {@link SuiteDefinitionConfigurationProperty#getDevicePermissionRoleArn}
             * @param devicePermissionRoleArn Gets the device permission ARN. This parameter is required.
             *                                This is a required parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder devicePermissionRoleArn(java.lang.String devicePermissionRoleArn) {
                this.devicePermissionRoleArn = devicePermissionRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link SuiteDefinitionConfigurationProperty#getRootGroup}
             * @param rootGroup Gets the test suite root group. This parameter is required.
             *                  This is a required parameter. For updating or creating the latest qualification suite, if <code>intendedForQualification</code> is set to true, <code>rootGroup</code> can be an empty string. If <code>intendedForQualification</code> is false, <code>rootGroup</code> cannot be an empty string. If <code>rootGroup</code> is empty, and <code>intendedForQualification</code> is set to true, all the qualification tests are included, and the configuration is default.
             *                  <p>
             *                  For a qualification suite, the minimum length is 0, and the maximum is 2048. For a non-qualification suite, the minimum length is 1, and the maximum is 2048.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rootGroup(java.lang.String rootGroup) {
                this.rootGroup = rootGroup;
                return this;
            }

            /**
             * Sets the value of {@link SuiteDefinitionConfigurationProperty#getDevices}
             * @param devices Gets the devices configured.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder devices(software.amazon.awscdk.IResolvable devices) {
                this.devices = devices;
                return this;
            }

            /**
             * Sets the value of {@link SuiteDefinitionConfigurationProperty#getDevices}
             * @param devices Gets the devices configured.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder devices(java.util.List<? extends java.lang.Object> devices) {
                this.devices = devices;
                return this;
            }

            /**
             * Sets the value of {@link SuiteDefinitionConfigurationProperty#getIntendedForQualification}
             * @param intendedForQualification Gets the tests intended for qualification in a suite.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder intendedForQualification(java.lang.Boolean intendedForQualification) {
                this.intendedForQualification = intendedForQualification;
                return this;
            }

            /**
             * Sets the value of {@link SuiteDefinitionConfigurationProperty#getIntendedForQualification}
             * @param intendedForQualification Gets the tests intended for qualification in a suite.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder intendedForQualification(software.amazon.awscdk.IResolvable intendedForQualification) {
                this.intendedForQualification = intendedForQualification;
                return this;
            }

            /**
             * Sets the value of {@link SuiteDefinitionConfigurationProperty#getSuiteDefinitionName}
             * @param suiteDefinitionName Gets the suite definition name.
             *                            This is a required parameter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder suiteDefinitionName(java.lang.String suiteDefinitionName) {
                this.suiteDefinitionName = suiteDefinitionName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SuiteDefinitionConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SuiteDefinitionConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SuiteDefinitionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SuiteDefinitionConfigurationProperty {
            private final java.lang.String devicePermissionRoleArn;
            private final java.lang.String rootGroup;
            private final java.lang.Object devices;
            private final java.lang.Object intendedForQualification;
            private final java.lang.String suiteDefinitionName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.devicePermissionRoleArn = software.amazon.jsii.Kernel.get(this, "devicePermissionRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.rootGroup = software.amazon.jsii.Kernel.get(this, "rootGroup", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.devices = software.amazon.jsii.Kernel.get(this, "devices", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.intendedForQualification = software.amazon.jsii.Kernel.get(this, "intendedForQualification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.suiteDefinitionName = software.amazon.jsii.Kernel.get(this, "suiteDefinitionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.devicePermissionRoleArn = java.util.Objects.requireNonNull(builder.devicePermissionRoleArn, "devicePermissionRoleArn is required");
                this.rootGroup = java.util.Objects.requireNonNull(builder.rootGroup, "rootGroup is required");
                this.devices = builder.devices;
                this.intendedForQualification = builder.intendedForQualification;
                this.suiteDefinitionName = builder.suiteDefinitionName;
            }

            @Override
            public final java.lang.String getDevicePermissionRoleArn() {
                return this.devicePermissionRoleArn;
            }

            @Override
            public final java.lang.String getRootGroup() {
                return this.rootGroup;
            }

            @Override
            public final java.lang.Object getDevices() {
                return this.devices;
            }

            @Override
            public final java.lang.Object getIntendedForQualification() {
                return this.intendedForQualification;
            }

            @Override
            public final java.lang.String getSuiteDefinitionName() {
                return this.suiteDefinitionName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("devicePermissionRoleArn", om.valueToTree(this.getDevicePermissionRoleArn()));
                data.set("rootGroup", om.valueToTree(this.getRootGroup()));
                if (this.getDevices() != null) {
                    data.set("devices", om.valueToTree(this.getDevices()));
                }
                if (this.getIntendedForQualification() != null) {
                    data.set("intendedForQualification", om.valueToTree(this.getIntendedForQualification()));
                }
                if (this.getSuiteDefinitionName() != null) {
                    data.set("suiteDefinitionName", om.valueToTree(this.getSuiteDefinitionName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotcoredeviceadvisor.CfnSuiteDefinition.SuiteDefinitionConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SuiteDefinitionConfigurationProperty.Jsii$Proxy that = (SuiteDefinitionConfigurationProperty.Jsii$Proxy) o;

                if (!devicePermissionRoleArn.equals(that.devicePermissionRoleArn)) return false;
                if (!rootGroup.equals(that.rootGroup)) return false;
                if (this.devices != null ? !this.devices.equals(that.devices) : that.devices != null) return false;
                if (this.intendedForQualification != null ? !this.intendedForQualification.equals(that.intendedForQualification) : that.intendedForQualification != null) return false;
                return this.suiteDefinitionName != null ? this.suiteDefinitionName.equals(that.suiteDefinitionName) : that.suiteDefinitionName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.devicePermissionRoleArn.hashCode();
                result = 31 * result + (this.rootGroup.hashCode());
                result = 31 * result + (this.devices != null ? this.devices.hashCode() : 0);
                result = 31 * result + (this.intendedForQualification != null ? this.intendedForQualification.hashCode() : 0);
                result = 31 * result + (this.suiteDefinitionName != null ? this.suiteDefinitionName.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.iotcoredeviceadvisor.CfnSuiteDefinition}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.iotcoredeviceadvisor.CfnSuiteDefinition> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.iotcoredeviceadvisor.CfnSuiteDefinitionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.iotcoredeviceadvisor.CfnSuiteDefinitionProps.Builder();
        }

        /**
         * The configuration of the Suite Definition. Listed below are the required elements of the <code>SuiteDefinitionConfiguration</code> .
         * <p>
         * <ul>
         * <li><em><strong>devicePermissionRoleArn</strong></em> - The device permission arn.</li>
         * </ul>
         * <p>
         * This is a required element.
         * <p>
         * <em>Type:</em> String
         * <p>
         * <ul>
         * <li><em><strong>devices</strong></em> - The list of configured devices under test. For more information on devices under test, see <a href="https://docs.aws.amazon.com/iot/latest/apireference/API_iotdeviceadvisor_DeviceUnderTest.html">DeviceUnderTest</a></li>
         * </ul>
         * <p>
         * Not a required element.
         * <p>
         * <em>Type:</em> List of devices under test
         * <p>
         * <ul>
         * <li><em><strong>intendedForQualification</strong></em> - The tests intended for qualification in a suite.</li>
         * </ul>
         * <p>
         * Not a required element.
         * <p>
         * <em>Type:</em> Boolean
         * <p>
         * <ul>
         * <li><em><strong>rootGroup</strong></em> - The test suite root group. For more information on creating and using root groups see the <a href="https://docs.aws.amazon.com/iot/latest/developerguide/device-advisor-workflow.html">Device Advisor workflow</a> .</li>
         * </ul>
         * <p>
         * This is a required element.
         * <p>
         * <em>Type:</em> String
         * <p>
         * <ul>
         * <li><em><strong>suiteDefinitionName</strong></em> - The Suite Definition Configuration name.</li>
         * </ul>
         * <p>
         * This is a required element.
         * <p>
         * <em>Type:</em> String
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotcoredeviceadvisor-suitedefinition.html#cfn-iotcoredeviceadvisor-suitedefinition-suitedefinitionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotcoredeviceadvisor-suitedefinition.html#cfn-iotcoredeviceadvisor-suitedefinition-suitedefinitionconfiguration</a>
         * @param suiteDefinitionConfiguration The configuration of the Suite Definition. Listed below are the required elements of the <code>SuiteDefinitionConfiguration</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder suiteDefinitionConfiguration(final java.lang.Object suiteDefinitionConfiguration) {
            this.props.suiteDefinitionConfiguration(suiteDefinitionConfiguration);
            return this;
        }

        /**
         * Metadata that can be used to manage the the Suite Definition.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotcoredeviceadvisor-suitedefinition.html#cfn-iotcoredeviceadvisor-suitedefinition-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotcoredeviceadvisor-suitedefinition.html#cfn-iotcoredeviceadvisor-suitedefinition-tags</a>
         * @param tags Metadata that can be used to manage the the Suite Definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.iotcoredeviceadvisor.CfnSuiteDefinition}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.iotcoredeviceadvisor.CfnSuiteDefinition build() {
            return new software.amazon.awscdk.services.iotcoredeviceadvisor.CfnSuiteDefinition(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
