package software.amazon.awscdk.services.imagebuilder;

/**
 * Properties for defining a <code>CfnInfrastructureConfiguration</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.imagebuilder.*;
 * CfnInfrastructureConfigurationProps cfnInfrastructureConfigurationProps = CfnInfrastructureConfigurationProps.builder()
 *         .instanceProfileName("instanceProfileName")
 *         .name("name")
 *         // the properties below are optional
 *         .description("description")
 *         .instanceMetadataOptions(InstanceMetadataOptionsProperty.builder()
 *                 .httpPutResponseHopLimit(123)
 *                 .httpTokens("httpTokens")
 *                 .build())
 *         .instanceTypes(List.of("instanceTypes"))
 *         .keyPair("keyPair")
 *         .logging(LoggingProperty.builder()
 *                 .s3Logs(S3LogsProperty.builder()
 *                         .s3BucketName("s3BucketName")
 *                         .s3KeyPrefix("s3KeyPrefix")
 *                         .build())
 *                 .build())
 *         .placement(PlacementProperty.builder()
 *                 .availabilityZone("availabilityZone")
 *                 .hostId("hostId")
 *                 .hostResourceGroupArn("hostResourceGroupArn")
 *                 .tenancy("tenancy")
 *                 .build())
 *         .resourceTags(Map.of(
 *                 "resourceTagsKey", "resourceTags"))
 *         .securityGroupIds(List.of("securityGroupIds"))
 *         .snsTopicArn("snsTopicArn")
 *         .subnetId("subnetId")
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .terminateInstanceOnFailure(false)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:14.553Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_imagebuilder.CfnInfrastructureConfigurationProps")
@software.amazon.jsii.Jsii.Proxy(CfnInfrastructureConfigurationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnInfrastructureConfigurationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The instance profile to associate with the instance used to customize your Amazon EC2 AMI.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-instanceprofilename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-instanceprofilename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getInstanceProfileName();

    /**
     * The name of the infrastructure configuration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The description of the infrastructure configuration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The instance metadata options that you can set for the HTTP requests that pipeline builds use to launch EC2 build and test instances.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-instancemetadataoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-instancemetadataoptions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getInstanceMetadataOptions() {
        return null;
    }

    /**
     * The instance types of the infrastructure configuration.
     * <p>
     * You can specify one or more instance types to use for this build. The service will pick one of these instance types based on availability.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-instancetypes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-instancetypes</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getInstanceTypes() {
        return null;
    }

    /**
     * The key pair of the infrastructure configuration.
     * <p>
     * You can use this to log on to and debug the instance used to create your image.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-keypair">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-keypair</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKeyPair() {
        return null;
    }

    /**
     * The logging configuration of the infrastructure configuration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-logging">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-logging</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLogging() {
        return null;
    }

    /**
     * The instance placement settings that define where the instances that are launched from your image will run.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-placement">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-placement</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPlacement() {
        return null;
    }

    /**
     * The metadata tags to assign to the Amazon EC2 instance that Image Builder launches during the build process.
     * <p>
     * Tags are formatted as key value pairs.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-resourcetags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-resourcetags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getResourceTags() {
        return null;
    }

    /**
     * The security group IDs to associate with the instance used to customize your Amazon EC2 AMI.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-securitygroupids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-securitygroupids</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroupIds() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) for the SNS topic to which we send image build event notifications.
     * <p>
     * <blockquote>
     * <p>
     * EC2 Image Builder is unable to send notifications to SNS topics that are encrypted using keys from other accounts. The key that is used to encrypt the SNS topic must reside in the account that the Image Builder service runs under.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-snstopicarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-snstopicarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSnsTopicArn() {
        return null;
    }

    /**
     * The subnet ID in which to place the instance used to customize your Amazon EC2 AMI.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-subnetid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-subnetid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSubnetId() {
        return null;
    }

    /**
     * The metadata tags to assign to the infrastructure configuration resource that Image Builder creates as output.
     * <p>
     * Tags are formatted as key value pairs.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * The terminate instance on failure setting of the infrastructure configuration.
     * <p>
     * Set to false if you want Image Builder to retain the instance used to configure your AMI if the build or test phase of your workflow fails.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-terminateinstanceonfailure">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-imagebuilder-infrastructureconfiguration.html#cfn-imagebuilder-infrastructureconfiguration-terminateinstanceonfailure</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTerminateInstanceOnFailure() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnInfrastructureConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnInfrastructureConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnInfrastructureConfigurationProps> {
        java.lang.String instanceProfileName;
        java.lang.String name;
        java.lang.String description;
        java.lang.Object instanceMetadataOptions;
        java.util.List<java.lang.String> instanceTypes;
        java.lang.String keyPair;
        java.lang.Object logging;
        java.lang.Object placement;
        java.lang.Object resourceTags;
        java.util.List<java.lang.String> securityGroupIds;
        java.lang.String snsTopicArn;
        java.lang.String subnetId;
        java.util.Map<java.lang.String, java.lang.String> tags;
        java.lang.Object terminateInstanceOnFailure;

        /**
         * Sets the value of {@link CfnInfrastructureConfigurationProps#getInstanceProfileName}
         * @param instanceProfileName The instance profile to associate with the instance used to customize your Amazon EC2 AMI. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceProfileName(java.lang.String instanceProfileName) {
            this.instanceProfileName = instanceProfileName;
            return this;
        }

        /**
         * Sets the value of {@link CfnInfrastructureConfigurationProps#getName}
         * @param name The name of the infrastructure configuration. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnInfrastructureConfigurationProps#getDescription}
         * @param description The description of the infrastructure configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnInfrastructureConfigurationProps#getInstanceMetadataOptions}
         * @param instanceMetadataOptions The instance metadata options that you can set for the HTTP requests that pipeline builds use to launch EC2 build and test instances.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceMetadataOptions(software.amazon.awscdk.IResolvable instanceMetadataOptions) {
            this.instanceMetadataOptions = instanceMetadataOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnInfrastructureConfigurationProps#getInstanceMetadataOptions}
         * @param instanceMetadataOptions The instance metadata options that you can set for the HTTP requests that pipeline builds use to launch EC2 build and test instances.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceMetadataOptions(software.amazon.awscdk.services.imagebuilder.CfnInfrastructureConfiguration.InstanceMetadataOptionsProperty instanceMetadataOptions) {
            this.instanceMetadataOptions = instanceMetadataOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnInfrastructureConfigurationProps#getInstanceTypes}
         * @param instanceTypes The instance types of the infrastructure configuration.
         *                      You can specify one or more instance types to use for this build. The service will pick one of these instance types based on availability.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceTypes(java.util.List<java.lang.String> instanceTypes) {
            this.instanceTypes = instanceTypes;
            return this;
        }

        /**
         * Sets the value of {@link CfnInfrastructureConfigurationProps#getKeyPair}
         * @param keyPair The key pair of the infrastructure configuration.
         *                You can use this to log on to and debug the instance used to create your image.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyPair(java.lang.String keyPair) {
            this.keyPair = keyPair;
            return this;
        }

        /**
         * Sets the value of {@link CfnInfrastructureConfigurationProps#getLogging}
         * @param logging The logging configuration of the infrastructure configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logging(software.amazon.awscdk.IResolvable logging) {
            this.logging = logging;
            return this;
        }

        /**
         * Sets the value of {@link CfnInfrastructureConfigurationProps#getLogging}
         * @param logging The logging configuration of the infrastructure configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logging(software.amazon.awscdk.services.imagebuilder.CfnInfrastructureConfiguration.LoggingProperty logging) {
            this.logging = logging;
            return this;
        }

        /**
         * Sets the value of {@link CfnInfrastructureConfigurationProps#getPlacement}
         * @param placement The instance placement settings that define where the instances that are launched from your image will run.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder placement(software.amazon.awscdk.IResolvable placement) {
            this.placement = placement;
            return this;
        }

        /**
         * Sets the value of {@link CfnInfrastructureConfigurationProps#getPlacement}
         * @param placement The instance placement settings that define where the instances that are launched from your image will run.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder placement(software.amazon.awscdk.services.imagebuilder.CfnInfrastructureConfiguration.PlacementProperty placement) {
            this.placement = placement;
            return this;
        }

        /**
         * Sets the value of {@link CfnInfrastructureConfigurationProps#getResourceTags}
         * @param resourceTags The metadata tags to assign to the Amazon EC2 instance that Image Builder launches during the build process.
         *                     Tags are formatted as key value pairs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceTags(java.util.Map<java.lang.String, java.lang.String> resourceTags) {
            this.resourceTags = resourceTags;
            return this;
        }

        /**
         * Sets the value of {@link CfnInfrastructureConfigurationProps#getResourceTags}
         * @param resourceTags The metadata tags to assign to the Amazon EC2 instance that Image Builder launches during the build process.
         *                     Tags are formatted as key value pairs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceTags(software.amazon.awscdk.IResolvable resourceTags) {
            this.resourceTags = resourceTags;
            return this;
        }

        /**
         * Sets the value of {@link CfnInfrastructureConfigurationProps#getSecurityGroupIds}
         * @param securityGroupIds The security group IDs to associate with the instance used to customize your Amazon EC2 AMI.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroupIds(java.util.List<java.lang.String> securityGroupIds) {
            this.securityGroupIds = securityGroupIds;
            return this;
        }

        /**
         * Sets the value of {@link CfnInfrastructureConfigurationProps#getSnsTopicArn}
         * @param snsTopicArn The Amazon Resource Name (ARN) for the SNS topic to which we send image build event notifications.
         *                    <blockquote>
         *                    <p>
         *                    EC2 Image Builder is unable to send notifications to SNS topics that are encrypted using keys from other accounts. The key that is used to encrypt the SNS topic must reside in the account that the Image Builder service runs under.
         *                    <p>
         *                    </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snsTopicArn(java.lang.String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnInfrastructureConfigurationProps#getSubnetId}
         * @param subnetId The subnet ID in which to place the instance used to customize your Amazon EC2 AMI.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetId(java.lang.String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        /**
         * Sets the value of {@link CfnInfrastructureConfigurationProps#getTags}
         * @param tags The metadata tags to assign to the infrastructure configuration resource that Image Builder creates as output.
         *             Tags are formatted as key value pairs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnInfrastructureConfigurationProps#getTerminateInstanceOnFailure}
         * @param terminateInstanceOnFailure The terminate instance on failure setting of the infrastructure configuration.
         *                                   Set to false if you want Image Builder to retain the instance used to configure your AMI if the build or test phase of your workflow fails.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder terminateInstanceOnFailure(java.lang.Boolean terminateInstanceOnFailure) {
            this.terminateInstanceOnFailure = terminateInstanceOnFailure;
            return this;
        }

        /**
         * Sets the value of {@link CfnInfrastructureConfigurationProps#getTerminateInstanceOnFailure}
         * @param terminateInstanceOnFailure The terminate instance on failure setting of the infrastructure configuration.
         *                                   Set to false if you want Image Builder to retain the instance used to configure your AMI if the build or test phase of your workflow fails.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder terminateInstanceOnFailure(software.amazon.awscdk.IResolvable terminateInstanceOnFailure) {
            this.terminateInstanceOnFailure = terminateInstanceOnFailure;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnInfrastructureConfigurationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnInfrastructureConfigurationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnInfrastructureConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnInfrastructureConfigurationProps {
        private final java.lang.String instanceProfileName;
        private final java.lang.String name;
        private final java.lang.String description;
        private final java.lang.Object instanceMetadataOptions;
        private final java.util.List<java.lang.String> instanceTypes;
        private final java.lang.String keyPair;
        private final java.lang.Object logging;
        private final java.lang.Object placement;
        private final java.lang.Object resourceTags;
        private final java.util.List<java.lang.String> securityGroupIds;
        private final java.lang.String snsTopicArn;
        private final java.lang.String subnetId;
        private final java.util.Map<java.lang.String, java.lang.String> tags;
        private final java.lang.Object terminateInstanceOnFailure;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.instanceProfileName = software.amazon.jsii.Kernel.get(this, "instanceProfileName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.instanceMetadataOptions = software.amazon.jsii.Kernel.get(this, "instanceMetadataOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.instanceTypes = software.amazon.jsii.Kernel.get(this, "instanceTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.keyPair = software.amazon.jsii.Kernel.get(this, "keyPair", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.logging = software.amazon.jsii.Kernel.get(this, "logging", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.placement = software.amazon.jsii.Kernel.get(this, "placement", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.resourceTags = software.amazon.jsii.Kernel.get(this, "resourceTags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.securityGroupIds = software.amazon.jsii.Kernel.get(this, "securityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.snsTopicArn = software.amazon.jsii.Kernel.get(this, "snsTopicArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.subnetId = software.amazon.jsii.Kernel.get(this, "subnetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.terminateInstanceOnFailure = software.amazon.jsii.Kernel.get(this, "terminateInstanceOnFailure", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.instanceProfileName = java.util.Objects.requireNonNull(builder.instanceProfileName, "instanceProfileName is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.description = builder.description;
            this.instanceMetadataOptions = builder.instanceMetadataOptions;
            this.instanceTypes = builder.instanceTypes;
            this.keyPair = builder.keyPair;
            this.logging = builder.logging;
            this.placement = builder.placement;
            this.resourceTags = builder.resourceTags;
            this.securityGroupIds = builder.securityGroupIds;
            this.snsTopicArn = builder.snsTopicArn;
            this.subnetId = builder.subnetId;
            this.tags = builder.tags;
            this.terminateInstanceOnFailure = builder.terminateInstanceOnFailure;
        }

        @Override
        public final java.lang.String getInstanceProfileName() {
            return this.instanceProfileName;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Object getInstanceMetadataOptions() {
            return this.instanceMetadataOptions;
        }

        @Override
        public final java.util.List<java.lang.String> getInstanceTypes() {
            return this.instanceTypes;
        }

        @Override
        public final java.lang.String getKeyPair() {
            return this.keyPair;
        }

        @Override
        public final java.lang.Object getLogging() {
            return this.logging;
        }

        @Override
        public final java.lang.Object getPlacement() {
            return this.placement;
        }

        @Override
        public final java.lang.Object getResourceTags() {
            return this.resourceTags;
        }

        @Override
        public final java.util.List<java.lang.String> getSecurityGroupIds() {
            return this.securityGroupIds;
        }

        @Override
        public final java.lang.String getSnsTopicArn() {
            return this.snsTopicArn;
        }

        @Override
        public final java.lang.String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getTerminateInstanceOnFailure() {
            return this.terminateInstanceOnFailure;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("instanceProfileName", om.valueToTree(this.getInstanceProfileName()));
            data.set("name", om.valueToTree(this.getName()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getInstanceMetadataOptions() != null) {
                data.set("instanceMetadataOptions", om.valueToTree(this.getInstanceMetadataOptions()));
            }
            if (this.getInstanceTypes() != null) {
                data.set("instanceTypes", om.valueToTree(this.getInstanceTypes()));
            }
            if (this.getKeyPair() != null) {
                data.set("keyPair", om.valueToTree(this.getKeyPair()));
            }
            if (this.getLogging() != null) {
                data.set("logging", om.valueToTree(this.getLogging()));
            }
            if (this.getPlacement() != null) {
                data.set("placement", om.valueToTree(this.getPlacement()));
            }
            if (this.getResourceTags() != null) {
                data.set("resourceTags", om.valueToTree(this.getResourceTags()));
            }
            if (this.getSecurityGroupIds() != null) {
                data.set("securityGroupIds", om.valueToTree(this.getSecurityGroupIds()));
            }
            if (this.getSnsTopicArn() != null) {
                data.set("snsTopicArn", om.valueToTree(this.getSnsTopicArn()));
            }
            if (this.getSubnetId() != null) {
                data.set("subnetId", om.valueToTree(this.getSubnetId()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTerminateInstanceOnFailure() != null) {
                data.set("terminateInstanceOnFailure", om.valueToTree(this.getTerminateInstanceOnFailure()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_imagebuilder.CfnInfrastructureConfigurationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnInfrastructureConfigurationProps.Jsii$Proxy that = (CfnInfrastructureConfigurationProps.Jsii$Proxy) o;

            if (!instanceProfileName.equals(that.instanceProfileName)) return false;
            if (!name.equals(that.name)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.instanceMetadataOptions != null ? !this.instanceMetadataOptions.equals(that.instanceMetadataOptions) : that.instanceMetadataOptions != null) return false;
            if (this.instanceTypes != null ? !this.instanceTypes.equals(that.instanceTypes) : that.instanceTypes != null) return false;
            if (this.keyPair != null ? !this.keyPair.equals(that.keyPair) : that.keyPair != null) return false;
            if (this.logging != null ? !this.logging.equals(that.logging) : that.logging != null) return false;
            if (this.placement != null ? !this.placement.equals(that.placement) : that.placement != null) return false;
            if (this.resourceTags != null ? !this.resourceTags.equals(that.resourceTags) : that.resourceTags != null) return false;
            if (this.securityGroupIds != null ? !this.securityGroupIds.equals(that.securityGroupIds) : that.securityGroupIds != null) return false;
            if (this.snsTopicArn != null ? !this.snsTopicArn.equals(that.snsTopicArn) : that.snsTopicArn != null) return false;
            if (this.subnetId != null ? !this.subnetId.equals(that.subnetId) : that.subnetId != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.terminateInstanceOnFailure != null ? this.terminateInstanceOnFailure.equals(that.terminateInstanceOnFailure) : that.terminateInstanceOnFailure == null;
        }

        @Override
        public final int hashCode() {
            int result = this.instanceProfileName.hashCode();
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.instanceMetadataOptions != null ? this.instanceMetadataOptions.hashCode() : 0);
            result = 31 * result + (this.instanceTypes != null ? this.instanceTypes.hashCode() : 0);
            result = 31 * result + (this.keyPair != null ? this.keyPair.hashCode() : 0);
            result = 31 * result + (this.logging != null ? this.logging.hashCode() : 0);
            result = 31 * result + (this.placement != null ? this.placement.hashCode() : 0);
            result = 31 * result + (this.resourceTags != null ? this.resourceTags.hashCode() : 0);
            result = 31 * result + (this.securityGroupIds != null ? this.securityGroupIds.hashCode() : 0);
            result = 31 * result + (this.snsTopicArn != null ? this.snsTopicArn.hashCode() : 0);
            result = 31 * result + (this.subnetId != null ? this.subnetId.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.terminateInstanceOnFailure != null ? this.terminateInstanceOnFailure.hashCode() : 0);
            return result;
        }
    }
}
