package software.amazon.awscdk.services.greengrass;

/**
 * The <code>AWS::Greengrass::FunctionDefinitionVersion</code> resource represents a function definition version for AWS IoT Greengrass .
 * <p>
 * A function definition version contains contain a list of functions.
 * <p>
 * <blockquote>
 * <p>
 * To create a function definition version, you must specify the ID of the function definition that you want to associate with the version. For information about creating a function definition, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-functiondefinition.html"><code>AWS::Greengrass::FunctionDefinition</code></a> .
 * <p>
 * After you create a function definition version that contains the functions you want to deploy, you must add it to your group version. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-group.html"><code>AWS::Greengrass::Group</code></a> .
 * <p>
 * </blockquote>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.greengrass.*;
 * Object variables;
 * CfnFunctionDefinitionVersion cfnFunctionDefinitionVersion = CfnFunctionDefinitionVersion.Builder.create(this, "MyCfnFunctionDefinitionVersion")
 *         .functionDefinitionId("functionDefinitionId")
 *         .functions(List.of(FunctionProperty.builder()
 *                 .functionArn("functionArn")
 *                 .functionConfiguration(FunctionConfigurationProperty.builder()
 *                         .encodingType("encodingType")
 *                         .environment(EnvironmentProperty.builder()
 *                                 .accessSysfs(false)
 *                                 .execution(ExecutionProperty.builder()
 *                                         .isolationMode("isolationMode")
 *                                         .runAs(RunAsProperty.builder()
 *                                                 .gid(123)
 *                                                 .uid(123)
 *                                                 .build())
 *                                         .build())
 *                                 .resourceAccessPolicies(List.of(ResourceAccessPolicyProperty.builder()
 *                                         .resourceId("resourceId")
 *                                         // the properties below are optional
 *                                         .permission("permission")
 *                                         .build()))
 *                                 .variables(variables)
 *                                 .build())
 *                         .execArgs("execArgs")
 *                         .executable("executable")
 *                         .memorySize(123)
 *                         .pinned(false)
 *                         .timeout(123)
 *                         .build())
 *                 .id("id")
 *                 .build()))
 *         // the properties below are optional
 *         .defaultConfig(DefaultConfigProperty.builder()
 *                 .execution(ExecutionProperty.builder()
 *                         .isolationMode("isolationMode")
 *                         .runAs(RunAsProperty.builder()
 *                                 .gid(123)
 *                                 .uid(123)
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-functiondefinitionversion.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-functiondefinitionversion.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:14.231Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_greengrass.CfnFunctionDefinitionVersion")
public class CfnFunctionDefinitionVersion extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnFunctionDefinitionVersion(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnFunctionDefinitionVersion(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.greengrass.CfnFunctionDefinitionVersion.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnFunctionDefinitionVersion(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.greengrass.CfnFunctionDefinitionVersionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The ID of the function definition associated with this version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getFunctionDefinitionId() {
        return software.amazon.jsii.Kernel.get(this, "functionDefinitionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the function definition associated with this version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFunctionDefinitionId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "functionDefinitionId", java.util.Objects.requireNonNull(value, "functionDefinitionId is required"));
    }

    /**
     * The functions in this version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getFunctions() {
        return software.amazon.jsii.Kernel.get(this, "functions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The functions in this version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFunctions(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "functions", java.util.Objects.requireNonNull(value, "functions is required"));
    }

    /**
     * The functions in this version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFunctions(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.greengrass.CfnFunctionDefinitionVersion.FunctionProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.greengrass.CfnFunctionDefinitionVersion.FunctionProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "functions", java.util.Objects.requireNonNull(value, "functions is required"));
    }

    /**
     * The default configuration that applies to all Lambda functions in the group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDefaultConfig() {
        return software.amazon.jsii.Kernel.get(this, "defaultConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The default configuration that applies to all Lambda functions in the group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefaultConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "defaultConfig", value);
    }

    /**
     * The default configuration that applies to all Lambda functions in the group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefaultConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.greengrass.CfnFunctionDefinitionVersion.DefaultConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "defaultConfig", value);
    }
    /**
     * The default configuration that applies to all Lambda functions in the function definition version.
     * <p>
     * Individual Lambda functions can override these settings.
     * <p>
     * In an AWS CloudFormation template, <code>DefaultConfig</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-functiondefinitionversion.html"><code>AWS::Greengrass::FunctionDefinitionVersion</code></a> resource.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.greengrass.*;
     * DefaultConfigProperty defaultConfigProperty = DefaultConfigProperty.builder()
     *         .execution(ExecutionProperty.builder()
     *                 .isolationMode("isolationMode")
     *                 .runAs(RunAsProperty.builder()
     *                         .gid(123)
     *                         .uid(123)
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-defaultconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-defaultconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_greengrass.CfnFunctionDefinitionVersion.DefaultConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(DefaultConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DefaultConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Configuration settings for the Lambda execution environment on the AWS IoT Greengrass core.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-defaultconfig.html#cfn-greengrass-functiondefinitionversion-defaultconfig-execution">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-defaultconfig.html#cfn-greengrass-functiondefinitionversion-defaultconfig-execution</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getExecution();

        /**
         * @return a {@link Builder} of {@link DefaultConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DefaultConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DefaultConfigProperty> {
            java.lang.Object execution;

            /**
             * Sets the value of {@link DefaultConfigProperty#getExecution}
             * @param execution Configuration settings for the Lambda execution environment on the AWS IoT Greengrass core. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder execution(software.amazon.awscdk.IResolvable execution) {
                this.execution = execution;
                return this;
            }

            /**
             * Sets the value of {@link DefaultConfigProperty#getExecution}
             * @param execution Configuration settings for the Lambda execution environment on the AWS IoT Greengrass core. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder execution(software.amazon.awscdk.services.greengrass.CfnFunctionDefinitionVersion.ExecutionProperty execution) {
                this.execution = execution;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DefaultConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DefaultConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DefaultConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DefaultConfigProperty {
            private final java.lang.Object execution;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.execution = software.amazon.jsii.Kernel.get(this, "execution", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.execution = java.util.Objects.requireNonNull(builder.execution, "execution is required");
            }

            @Override
            public final java.lang.Object getExecution() {
                return this.execution;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("execution", om.valueToTree(this.getExecution()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_greengrass.CfnFunctionDefinitionVersion.DefaultConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DefaultConfigProperty.Jsii$Proxy that = (DefaultConfigProperty.Jsii$Proxy) o;

                return this.execution.equals(that.execution);
            }

            @Override
            public final int hashCode() {
                int result = this.execution.hashCode();
                return result;
            }
        }
    }
    /**
     * The environment configuration for a Lambda function on the AWS IoT Greengrass core.
     * <p>
     * In an AWS CloudFormation template, <code>Environment</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-functionconfiguration.html"><code>FunctionConfiguration</code></a> property type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.greengrass.*;
     * Object variables;
     * EnvironmentProperty environmentProperty = EnvironmentProperty.builder()
     *         .accessSysfs(false)
     *         .execution(ExecutionProperty.builder()
     *                 .isolationMode("isolationMode")
     *                 .runAs(RunAsProperty.builder()
     *                         .gid(123)
     *                         .uid(123)
     *                         .build())
     *                 .build())
     *         .resourceAccessPolicies(List.of(ResourceAccessPolicyProperty.builder()
     *                 .resourceId("resourceId")
     *                 // the properties below are optional
     *                 .permission("permission")
     *                 .build()))
     *         .variables(variables)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-environment.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-environment.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_greengrass.CfnFunctionDefinitionVersion.EnvironmentProperty")
    @software.amazon.jsii.Jsii.Proxy(EnvironmentProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EnvironmentProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates whether the function is allowed to access the <code>/sys</code> directory on the core device, which allows the read device information from <code>/sys</code> .
         * <p>
         * <blockquote>
         * <p>
         * This property applies only to Lambda functions that run in a Greengrass container.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-environment.html#cfn-greengrass-functiondefinitionversion-environment-accesssysfs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-environment.html#cfn-greengrass-functiondefinitionversion-environment-accesssysfs</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAccessSysfs() {
            return null;
        }

        /**
         * Settings for the Lambda execution environment in AWS IoT Greengrass .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-environment.html#cfn-greengrass-functiondefinitionversion-environment-execution">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-environment.html#cfn-greengrass-functiondefinitionversion-environment-execution</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getExecution() {
            return null;
        }

        /**
         * A list of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-resourceinstance.html">resources</a> in the group that the function can access, with the corresponding read-only or read-write permissions. The maximum is 10 resources.
         * <p>
         * <blockquote>
         * <p>
         * This property applies only to Lambda functions that run in a Greengrass container.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-environment.html#cfn-greengrass-functiondefinitionversion-environment-resourceaccesspolicies">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-environment.html#cfn-greengrass-functiondefinitionversion-environment-resourceaccesspolicies</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResourceAccessPolicies() {
            return null;
        }

        /**
         * Environment variables for the Lambda function.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-environment.html#cfn-greengrass-functiondefinitionversion-environment-variables">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-environment.html#cfn-greengrass-functiondefinitionversion-environment-variables</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVariables() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EnvironmentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EnvironmentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EnvironmentProperty> {
            java.lang.Object accessSysfs;
            java.lang.Object execution;
            java.lang.Object resourceAccessPolicies;
            java.lang.Object variables;

            /**
             * Sets the value of {@link EnvironmentProperty#getAccessSysfs}
             * @param accessSysfs Indicates whether the function is allowed to access the <code>/sys</code> directory on the core device, which allows the read device information from <code>/sys</code> .
             *                    <blockquote>
             *                    <p>
             *                    This property applies only to Lambda functions that run in a Greengrass container.
             *                    <p>
             *                    </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessSysfs(java.lang.Boolean accessSysfs) {
                this.accessSysfs = accessSysfs;
                return this;
            }

            /**
             * Sets the value of {@link EnvironmentProperty#getAccessSysfs}
             * @param accessSysfs Indicates whether the function is allowed to access the <code>/sys</code> directory on the core device, which allows the read device information from <code>/sys</code> .
             *                    <blockquote>
             *                    <p>
             *                    This property applies only to Lambda functions that run in a Greengrass container.
             *                    <p>
             *                    </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessSysfs(software.amazon.awscdk.IResolvable accessSysfs) {
                this.accessSysfs = accessSysfs;
                return this;
            }

            /**
             * Sets the value of {@link EnvironmentProperty#getExecution}
             * @param execution Settings for the Lambda execution environment in AWS IoT Greengrass .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder execution(software.amazon.awscdk.IResolvable execution) {
                this.execution = execution;
                return this;
            }

            /**
             * Sets the value of {@link EnvironmentProperty#getExecution}
             * @param execution Settings for the Lambda execution environment in AWS IoT Greengrass .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder execution(software.amazon.awscdk.services.greengrass.CfnFunctionDefinitionVersion.ExecutionProperty execution) {
                this.execution = execution;
                return this;
            }

            /**
             * Sets the value of {@link EnvironmentProperty#getResourceAccessPolicies}
             * @param resourceAccessPolicies A list of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-resourceinstance.html">resources</a> in the group that the function can access, with the corresponding read-only or read-write permissions. The maximum is 10 resources.
             *                               <blockquote>
             *                               <p>
             *                               This property applies only to Lambda functions that run in a Greengrass container.
             *                               <p>
             *                               </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceAccessPolicies(software.amazon.awscdk.IResolvable resourceAccessPolicies) {
                this.resourceAccessPolicies = resourceAccessPolicies;
                return this;
            }

            /**
             * Sets the value of {@link EnvironmentProperty#getResourceAccessPolicies}
             * @param resourceAccessPolicies A list of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-resourceinstance.html">resources</a> in the group that the function can access, with the corresponding read-only or read-write permissions. The maximum is 10 resources.
             *                               <blockquote>
             *                               <p>
             *                               This property applies only to Lambda functions that run in a Greengrass container.
             *                               <p>
             *                               </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceAccessPolicies(java.util.List<? extends java.lang.Object> resourceAccessPolicies) {
                this.resourceAccessPolicies = resourceAccessPolicies;
                return this;
            }

            /**
             * Sets the value of {@link EnvironmentProperty#getVariables}
             * @param variables Environment variables for the Lambda function.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder variables(java.lang.Object variables) {
                this.variables = variables;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EnvironmentProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EnvironmentProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EnvironmentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EnvironmentProperty {
            private final java.lang.Object accessSysfs;
            private final java.lang.Object execution;
            private final java.lang.Object resourceAccessPolicies;
            private final java.lang.Object variables;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.accessSysfs = software.amazon.jsii.Kernel.get(this, "accessSysfs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.execution = software.amazon.jsii.Kernel.get(this, "execution", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.resourceAccessPolicies = software.amazon.jsii.Kernel.get(this, "resourceAccessPolicies", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.variables = software.amazon.jsii.Kernel.get(this, "variables", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.accessSysfs = builder.accessSysfs;
                this.execution = builder.execution;
                this.resourceAccessPolicies = builder.resourceAccessPolicies;
                this.variables = builder.variables;
            }

            @Override
            public final java.lang.Object getAccessSysfs() {
                return this.accessSysfs;
            }

            @Override
            public final java.lang.Object getExecution() {
                return this.execution;
            }

            @Override
            public final java.lang.Object getResourceAccessPolicies() {
                return this.resourceAccessPolicies;
            }

            @Override
            public final java.lang.Object getVariables() {
                return this.variables;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAccessSysfs() != null) {
                    data.set("accessSysfs", om.valueToTree(this.getAccessSysfs()));
                }
                if (this.getExecution() != null) {
                    data.set("execution", om.valueToTree(this.getExecution()));
                }
                if (this.getResourceAccessPolicies() != null) {
                    data.set("resourceAccessPolicies", om.valueToTree(this.getResourceAccessPolicies()));
                }
                if (this.getVariables() != null) {
                    data.set("variables", om.valueToTree(this.getVariables()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_greengrass.CfnFunctionDefinitionVersion.EnvironmentProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EnvironmentProperty.Jsii$Proxy that = (EnvironmentProperty.Jsii$Proxy) o;

                if (this.accessSysfs != null ? !this.accessSysfs.equals(that.accessSysfs) : that.accessSysfs != null) return false;
                if (this.execution != null ? !this.execution.equals(that.execution) : that.execution != null) return false;
                if (this.resourceAccessPolicies != null ? !this.resourceAccessPolicies.equals(that.resourceAccessPolicies) : that.resourceAccessPolicies != null) return false;
                return this.variables != null ? this.variables.equals(that.variables) : that.variables == null;
            }

            @Override
            public final int hashCode() {
                int result = this.accessSysfs != null ? this.accessSysfs.hashCode() : 0;
                result = 31 * result + (this.execution != null ? this.execution.hashCode() : 0);
                result = 31 * result + (this.resourceAccessPolicies != null ? this.resourceAccessPolicies.hashCode() : 0);
                result = 31 * result + (this.variables != null ? this.variables.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configuration settings for the Lambda execution environment on the AWS IoT Greengrass core.
     * <p>
     * In an AWS CloudFormation template, <code>Execution</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-defaultconfig.html"><code>DefaultConfig</code></a> property type for a function definition version and the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-environment.html"><code>Environment</code></a> property type for a function.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.greengrass.*;
     * ExecutionProperty executionProperty = ExecutionProperty.builder()
     *         .isolationMode("isolationMode")
     *         .runAs(RunAsProperty.builder()
     *                 .gid(123)
     *                 .uid(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-execution.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-execution.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_greengrass.CfnFunctionDefinitionVersion.ExecutionProperty")
    @software.amazon.jsii.Jsii.Proxy(ExecutionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ExecutionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The containerization that the Lambda function runs in.
         * <p>
         * Valid values are <code>GreengrassContainer</code> or <code>NoContainer</code> . Typically, this is <code>GreengrassContainer</code> . For more information, see <a href="https://docs.aws.amazon.com/greengrass/v1/developerguide/lambda-group-config.html#lambda-function-containerization">Containerization</a> in the <em>Developer Guide</em> .
         * <p>
         * <ul>
         * <li>When set on the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-defaultconfig.html"><code>DefaultConfig</code></a> property of a function definition version, this setting is used as the default containerization for all Lambda functions in the function definition version.</li>
         * <li>When set on the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-environment.html"><code>Environment</code></a> property of a function, this setting applies to the individual function and overrides the default. Omit this value to run the function with the default containerization.</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * We recommend that you run in a Greengrass container unless your business case requires that you run without containerization.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-execution.html#cfn-greengrass-functiondefinitionversion-execution-isolationmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-execution.html#cfn-greengrass-functiondefinitionversion-execution-isolationmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIsolationMode() {
            return null;
        }

        /**
         * The user and group permissions used to run the Lambda function.
         * <p>
         * Typically, this is the ggc_user and ggc_group. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v1/developerguide/lambda-group-config.html#lambda-access-identity.html">Run as</a> in the <em>Developer Guide</em> .
         * <p>
         * <ul>
         * <li>When set on the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-defaultconfig.html"><code>DefaultConfig</code></a> property of a function definition version, this setting is used as the default access identity for all Lambda functions in the function definition version.</li>
         * <li>When set on the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-environment.html"><code>Environment</code></a> property of a function, this setting applies to the individual function and overrides the default. You can override the user, group, or both. Omit this value to run the function with the default permissions.</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * Running as the root user increases risks to your data and device. Do not run as root (UID/GID=0) unless your business case requires it. For more information and requirements, see <a href="https://docs.aws.amazon.com/greengrass/v1/developerguide/lambda-group-config.html#lambda-running-as-root">Running a Lambda Function as Root</a> .
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-execution.html#cfn-greengrass-functiondefinitionversion-execution-runas">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-execution.html#cfn-greengrass-functiondefinitionversion-execution-runas</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRunAs() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ExecutionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ExecutionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ExecutionProperty> {
            java.lang.String isolationMode;
            java.lang.Object runAs;

            /**
             * Sets the value of {@link ExecutionProperty#getIsolationMode}
             * @param isolationMode The containerization that the Lambda function runs in.
             *                      Valid values are <code>GreengrassContainer</code> or <code>NoContainer</code> . Typically, this is <code>GreengrassContainer</code> . For more information, see <a href="https://docs.aws.amazon.com/greengrass/v1/developerguide/lambda-group-config.html#lambda-function-containerization">Containerization</a> in the <em>Developer Guide</em> .
             *                      <p>
             *                      <ul>
             *                      <li>When set on the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-defaultconfig.html"><code>DefaultConfig</code></a> property of a function definition version, this setting is used as the default containerization for all Lambda functions in the function definition version.</li>
             *                      <li>When set on the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-environment.html"><code>Environment</code></a> property of a function, this setting applies to the individual function and overrides the default. Omit this value to run the function with the default containerization.</li>
             *                      </ul>
             *                      <p>
             *                      <blockquote>
             *                      <p>
             *                      We recommend that you run in a Greengrass container unless your business case requires that you run without containerization.
             *                      <p>
             *                      </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isolationMode(java.lang.String isolationMode) {
                this.isolationMode = isolationMode;
                return this;
            }

            /**
             * Sets the value of {@link ExecutionProperty#getRunAs}
             * @param runAs The user and group permissions used to run the Lambda function.
             *              Typically, this is the ggc_user and ggc_group. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v1/developerguide/lambda-group-config.html#lambda-access-identity.html">Run as</a> in the <em>Developer Guide</em> .
             *              <p>
             *              <ul>
             *              <li>When set on the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-defaultconfig.html"><code>DefaultConfig</code></a> property of a function definition version, this setting is used as the default access identity for all Lambda functions in the function definition version.</li>
             *              <li>When set on the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-environment.html"><code>Environment</code></a> property of a function, this setting applies to the individual function and overrides the default. You can override the user, group, or both. Omit this value to run the function with the default permissions.</li>
             *              </ul>
             *              <p>
             *              <blockquote>
             *              <p>
             *              Running as the root user increases risks to your data and device. Do not run as root (UID/GID=0) unless your business case requires it. For more information and requirements, see <a href="https://docs.aws.amazon.com/greengrass/v1/developerguide/lambda-group-config.html#lambda-running-as-root">Running a Lambda Function as Root</a> .
             *              <p>
             *              </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder runAs(software.amazon.awscdk.IResolvable runAs) {
                this.runAs = runAs;
                return this;
            }

            /**
             * Sets the value of {@link ExecutionProperty#getRunAs}
             * @param runAs The user and group permissions used to run the Lambda function.
             *              Typically, this is the ggc_user and ggc_group. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v1/developerguide/lambda-group-config.html#lambda-access-identity.html">Run as</a> in the <em>Developer Guide</em> .
             *              <p>
             *              <ul>
             *              <li>When set on the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-defaultconfig.html"><code>DefaultConfig</code></a> property of a function definition version, this setting is used as the default access identity for all Lambda functions in the function definition version.</li>
             *              <li>When set on the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-environment.html"><code>Environment</code></a> property of a function, this setting applies to the individual function and overrides the default. You can override the user, group, or both. Omit this value to run the function with the default permissions.</li>
             *              </ul>
             *              <p>
             *              <blockquote>
             *              <p>
             *              Running as the root user increases risks to your data and device. Do not run as root (UID/GID=0) unless your business case requires it. For more information and requirements, see <a href="https://docs.aws.amazon.com/greengrass/v1/developerguide/lambda-group-config.html#lambda-running-as-root">Running a Lambda Function as Root</a> .
             *              <p>
             *              </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder runAs(software.amazon.awscdk.services.greengrass.CfnFunctionDefinitionVersion.RunAsProperty runAs) {
                this.runAs = runAs;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ExecutionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ExecutionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ExecutionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ExecutionProperty {
            private final java.lang.String isolationMode;
            private final java.lang.Object runAs;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.isolationMode = software.amazon.jsii.Kernel.get(this, "isolationMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.runAs = software.amazon.jsii.Kernel.get(this, "runAs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.isolationMode = builder.isolationMode;
                this.runAs = builder.runAs;
            }

            @Override
            public final java.lang.String getIsolationMode() {
                return this.isolationMode;
            }

            @Override
            public final java.lang.Object getRunAs() {
                return this.runAs;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getIsolationMode() != null) {
                    data.set("isolationMode", om.valueToTree(this.getIsolationMode()));
                }
                if (this.getRunAs() != null) {
                    data.set("runAs", om.valueToTree(this.getRunAs()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_greengrass.CfnFunctionDefinitionVersion.ExecutionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ExecutionProperty.Jsii$Proxy that = (ExecutionProperty.Jsii$Proxy) o;

                if (this.isolationMode != null ? !this.isolationMode.equals(that.isolationMode) : that.isolationMode != null) return false;
                return this.runAs != null ? this.runAs.equals(that.runAs) : that.runAs == null;
            }

            @Override
            public final int hashCode() {
                int result = this.isolationMode != null ? this.isolationMode.hashCode() : 0;
                result = 31 * result + (this.runAs != null ? this.runAs.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The group-specific configuration settings for a Lambda function.
     * <p>
     * These settings configure the function's behavior in the Greengrass group. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v1/developerguide/lambda-group-config.html">Controlling Execution of Greengrass Lambda Functions by Using Group-Specific Configuration</a> in the <em>Developer Guide</em> .
     * <p>
     * In an AWS CloudFormation template, <code>FunctionConfiguration</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-function.html"><code>Function</code></a> property type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.greengrass.*;
     * Object variables;
     * FunctionConfigurationProperty functionConfigurationProperty = FunctionConfigurationProperty.builder()
     *         .encodingType("encodingType")
     *         .environment(EnvironmentProperty.builder()
     *                 .accessSysfs(false)
     *                 .execution(ExecutionProperty.builder()
     *                         .isolationMode("isolationMode")
     *                         .runAs(RunAsProperty.builder()
     *                                 .gid(123)
     *                                 .uid(123)
     *                                 .build())
     *                         .build())
     *                 .resourceAccessPolicies(List.of(ResourceAccessPolicyProperty.builder()
     *                         .resourceId("resourceId")
     *                         // the properties below are optional
     *                         .permission("permission")
     *                         .build()))
     *                 .variables(variables)
     *                 .build())
     *         .execArgs("execArgs")
     *         .executable("executable")
     *         .memorySize(123)
     *         .pinned(false)
     *         .timeout(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-functionconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-functionconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_greengrass.CfnFunctionDefinitionVersion.FunctionConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(FunctionConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FunctionConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The expected encoding type of the input payload for the function.
         * <p>
         * Valid values are <code>json</code> (default) and <code>binary</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-functionconfiguration.html#cfn-greengrass-functiondefinitionversion-functionconfiguration-encodingtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-functionconfiguration.html#cfn-greengrass-functiondefinitionversion-functionconfiguration-encodingtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEncodingType() {
            return null;
        }

        /**
         * The environment configuration of the function.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-functionconfiguration.html#cfn-greengrass-functiondefinitionversion-functionconfiguration-environment">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-functionconfiguration.html#cfn-greengrass-functiondefinitionversion-functionconfiguration-environment</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnvironment() {
            return null;
        }

        /**
         * The execution arguments.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-functionconfiguration.html#cfn-greengrass-functiondefinitionversion-functionconfiguration-execargs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-functionconfiguration.html#cfn-greengrass-functiondefinitionversion-functionconfiguration-execargs</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExecArgs() {
            return null;
        }

        /**
         * The name of the function executable.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-functionconfiguration.html#cfn-greengrass-functiondefinitionversion-functionconfiguration-executable">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-functionconfiguration.html#cfn-greengrass-functiondefinitionversion-functionconfiguration-executable</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExecutable() {
            return null;
        }

        /**
         * The memory size (in KB) required by the function.
         * <p>
         * <blockquote>
         * <p>
         * This property applies only to Lambda functions that run in a Greengrass container.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-functionconfiguration.html#cfn-greengrass-functiondefinitionversion-functionconfiguration-memorysize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-functionconfiguration.html#cfn-greengrass-functiondefinitionversion-functionconfiguration-memorysize</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMemorySize() {
            return null;
        }

        /**
         * Indicates whether the function is pinned (or <em>long-lived</em> ).
         * <p>
         * Pinned functions start when the core starts and process all requests in the same container. The default value is false.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-functionconfiguration.html#cfn-greengrass-functiondefinitionversion-functionconfiguration-pinned">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-functionconfiguration.html#cfn-greengrass-functiondefinitionversion-functionconfiguration-pinned</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPinned() {
            return null;
        }

        /**
         * The allowed execution time (in seconds) after which the function should terminate.
         * <p>
         * For pinned functions, this timeout applies for each request.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-functionconfiguration.html#cfn-greengrass-functiondefinitionversion-functionconfiguration-timeout">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-functionconfiguration.html#cfn-greengrass-functiondefinitionversion-functionconfiguration-timeout</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTimeout() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FunctionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FunctionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FunctionConfigurationProperty> {
            java.lang.String encodingType;
            java.lang.Object environment;
            java.lang.String execArgs;
            java.lang.String executable;
            java.lang.Number memorySize;
            java.lang.Object pinned;
            java.lang.Number timeout;

            /**
             * Sets the value of {@link FunctionConfigurationProperty#getEncodingType}
             * @param encodingType The expected encoding type of the input payload for the function.
             *                     Valid values are <code>json</code> (default) and <code>binary</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encodingType(java.lang.String encodingType) {
                this.encodingType = encodingType;
                return this;
            }

            /**
             * Sets the value of {@link FunctionConfigurationProperty#getEnvironment}
             * @param environment The environment configuration of the function.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder environment(software.amazon.awscdk.IResolvable environment) {
                this.environment = environment;
                return this;
            }

            /**
             * Sets the value of {@link FunctionConfigurationProperty#getEnvironment}
             * @param environment The environment configuration of the function.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder environment(software.amazon.awscdk.services.greengrass.CfnFunctionDefinitionVersion.EnvironmentProperty environment) {
                this.environment = environment;
                return this;
            }

            /**
             * Sets the value of {@link FunctionConfigurationProperty#getExecArgs}
             * @param execArgs The execution arguments.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder execArgs(java.lang.String execArgs) {
                this.execArgs = execArgs;
                return this;
            }

            /**
             * Sets the value of {@link FunctionConfigurationProperty#getExecutable}
             * @param executable The name of the function executable.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder executable(java.lang.String executable) {
                this.executable = executable;
                return this;
            }

            /**
             * Sets the value of {@link FunctionConfigurationProperty#getMemorySize}
             * @param memorySize The memory size (in KB) required by the function.
             *                   <blockquote>
             *                   <p>
             *                   This property applies only to Lambda functions that run in a Greengrass container.
             *                   <p>
             *                   </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder memorySize(java.lang.Number memorySize) {
                this.memorySize = memorySize;
                return this;
            }

            /**
             * Sets the value of {@link FunctionConfigurationProperty#getPinned}
             * @param pinned Indicates whether the function is pinned (or <em>long-lived</em> ).
             *               Pinned functions start when the core starts and process all requests in the same container. The default value is false.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pinned(java.lang.Boolean pinned) {
                this.pinned = pinned;
                return this;
            }

            /**
             * Sets the value of {@link FunctionConfigurationProperty#getPinned}
             * @param pinned Indicates whether the function is pinned (or <em>long-lived</em> ).
             *               Pinned functions start when the core starts and process all requests in the same container. The default value is false.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pinned(software.amazon.awscdk.IResolvable pinned) {
                this.pinned = pinned;
                return this;
            }

            /**
             * Sets the value of {@link FunctionConfigurationProperty#getTimeout}
             * @param timeout The allowed execution time (in seconds) after which the function should terminate.
             *                For pinned functions, this timeout applies for each request.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeout(java.lang.Number timeout) {
                this.timeout = timeout;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FunctionConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FunctionConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FunctionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FunctionConfigurationProperty {
            private final java.lang.String encodingType;
            private final java.lang.Object environment;
            private final java.lang.String execArgs;
            private final java.lang.String executable;
            private final java.lang.Number memorySize;
            private final java.lang.Object pinned;
            private final java.lang.Number timeout;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.encodingType = software.amazon.jsii.Kernel.get(this, "encodingType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.environment = software.amazon.jsii.Kernel.get(this, "environment", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.execArgs = software.amazon.jsii.Kernel.get(this, "execArgs", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.executable = software.amazon.jsii.Kernel.get(this, "executable", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.memorySize = software.amazon.jsii.Kernel.get(this, "memorySize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.pinned = software.amazon.jsii.Kernel.get(this, "pinned", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.timeout = software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.encodingType = builder.encodingType;
                this.environment = builder.environment;
                this.execArgs = builder.execArgs;
                this.executable = builder.executable;
                this.memorySize = builder.memorySize;
                this.pinned = builder.pinned;
                this.timeout = builder.timeout;
            }

            @Override
            public final java.lang.String getEncodingType() {
                return this.encodingType;
            }

            @Override
            public final java.lang.Object getEnvironment() {
                return this.environment;
            }

            @Override
            public final java.lang.String getExecArgs() {
                return this.execArgs;
            }

            @Override
            public final java.lang.String getExecutable() {
                return this.executable;
            }

            @Override
            public final java.lang.Number getMemorySize() {
                return this.memorySize;
            }

            @Override
            public final java.lang.Object getPinned() {
                return this.pinned;
            }

            @Override
            public final java.lang.Number getTimeout() {
                return this.timeout;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEncodingType() != null) {
                    data.set("encodingType", om.valueToTree(this.getEncodingType()));
                }
                if (this.getEnvironment() != null) {
                    data.set("environment", om.valueToTree(this.getEnvironment()));
                }
                if (this.getExecArgs() != null) {
                    data.set("execArgs", om.valueToTree(this.getExecArgs()));
                }
                if (this.getExecutable() != null) {
                    data.set("executable", om.valueToTree(this.getExecutable()));
                }
                if (this.getMemorySize() != null) {
                    data.set("memorySize", om.valueToTree(this.getMemorySize()));
                }
                if (this.getPinned() != null) {
                    data.set("pinned", om.valueToTree(this.getPinned()));
                }
                if (this.getTimeout() != null) {
                    data.set("timeout", om.valueToTree(this.getTimeout()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_greengrass.CfnFunctionDefinitionVersion.FunctionConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FunctionConfigurationProperty.Jsii$Proxy that = (FunctionConfigurationProperty.Jsii$Proxy) o;

                if (this.encodingType != null ? !this.encodingType.equals(that.encodingType) : that.encodingType != null) return false;
                if (this.environment != null ? !this.environment.equals(that.environment) : that.environment != null) return false;
                if (this.execArgs != null ? !this.execArgs.equals(that.execArgs) : that.execArgs != null) return false;
                if (this.executable != null ? !this.executable.equals(that.executable) : that.executable != null) return false;
                if (this.memorySize != null ? !this.memorySize.equals(that.memorySize) : that.memorySize != null) return false;
                if (this.pinned != null ? !this.pinned.equals(that.pinned) : that.pinned != null) return false;
                return this.timeout != null ? this.timeout.equals(that.timeout) : that.timeout == null;
            }

            @Override
            public final int hashCode() {
                int result = this.encodingType != null ? this.encodingType.hashCode() : 0;
                result = 31 * result + (this.environment != null ? this.environment.hashCode() : 0);
                result = 31 * result + (this.execArgs != null ? this.execArgs.hashCode() : 0);
                result = 31 * result + (this.executable != null ? this.executable.hashCode() : 0);
                result = 31 * result + (this.memorySize != null ? this.memorySize.hashCode() : 0);
                result = 31 * result + (this.pinned != null ? this.pinned.hashCode() : 0);
                result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A function is a Lambda function that's referenced from an AWS IoT Greengrass group.
     * <p>
     * The function is deployed to a Greengrass core where it runs locally. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v1/developerguide/lambda-functions.html">Run Lambda Functions on the AWS IoT Greengrass Core</a> in the <em>Developer Guide</em> .
     * <p>
     * In an AWS CloudFormation template, the <code>Functions</code> property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-functiondefinitionversion.html"><code>AWS::Greengrass::FunctionDefinitionVersion</code></a> resource contains a list of <code>Function</code> property types.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.greengrass.*;
     * Object variables;
     * FunctionProperty functionProperty = FunctionProperty.builder()
     *         .functionArn("functionArn")
     *         .functionConfiguration(FunctionConfigurationProperty.builder()
     *                 .encodingType("encodingType")
     *                 .environment(EnvironmentProperty.builder()
     *                         .accessSysfs(false)
     *                         .execution(ExecutionProperty.builder()
     *                                 .isolationMode("isolationMode")
     *                                 .runAs(RunAsProperty.builder()
     *                                         .gid(123)
     *                                         .uid(123)
     *                                         .build())
     *                                 .build())
     *                         .resourceAccessPolicies(List.of(ResourceAccessPolicyProperty.builder()
     *                                 .resourceId("resourceId")
     *                                 // the properties below are optional
     *                                 .permission("permission")
     *                                 .build()))
     *                         .variables(variables)
     *                         .build())
     *                 .execArgs("execArgs")
     *                 .executable("executable")
     *                 .memorySize(123)
     *                 .pinned(false)
     *                 .timeout(123)
     *                 .build())
     *         .id("id")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-function.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-function.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_greengrass.CfnFunctionDefinitionVersion.FunctionProperty")
    @software.amazon.jsii.Jsii.Proxy(FunctionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FunctionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the alias (recommended) or version of the referenced Lambda function.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-function.html#cfn-greengrass-functiondefinitionversion-function-functionarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-function.html#cfn-greengrass-functiondefinitionversion-function-functionarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFunctionArn();

        /**
         * The group-specific settings of the Lambda function.
         * <p>
         * These settings configure the function's behavior in the Greengrass group.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-function.html#cfn-greengrass-functiondefinitionversion-function-functionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-function.html#cfn-greengrass-functiondefinitionversion-function-functionconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getFunctionConfiguration();

        /**
         * A descriptive or arbitrary ID for the function.
         * <p>
         * This value must be unique within the function definition version. Maximum length is 128 characters with pattern <code>[a-zA-Z0-9:_-]+</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-function.html#cfn-greengrass-functiondefinitionversion-function-id">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-function.html#cfn-greengrass-functiondefinitionversion-function-id</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getId();

        /**
         * @return a {@link Builder} of {@link FunctionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FunctionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FunctionProperty> {
            java.lang.String functionArn;
            java.lang.Object functionConfiguration;
            java.lang.String id;

            /**
             * Sets the value of {@link FunctionProperty#getFunctionArn}
             * @param functionArn The Amazon Resource Name (ARN) of the alias (recommended) or version of the referenced Lambda function. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder functionArn(java.lang.String functionArn) {
                this.functionArn = functionArn;
                return this;
            }

            /**
             * Sets the value of {@link FunctionProperty#getFunctionConfiguration}
             * @param functionConfiguration The group-specific settings of the Lambda function. This parameter is required.
             *                              These settings configure the function's behavior in the Greengrass group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder functionConfiguration(software.amazon.awscdk.IResolvable functionConfiguration) {
                this.functionConfiguration = functionConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link FunctionProperty#getFunctionConfiguration}
             * @param functionConfiguration The group-specific settings of the Lambda function. This parameter is required.
             *                              These settings configure the function's behavior in the Greengrass group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder functionConfiguration(software.amazon.awscdk.services.greengrass.CfnFunctionDefinitionVersion.FunctionConfigurationProperty functionConfiguration) {
                this.functionConfiguration = functionConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link FunctionProperty#getId}
             * @param id A descriptive or arbitrary ID for the function. This parameter is required.
             *           This value must be unique within the function definition version. Maximum length is 128 characters with pattern <code>[a-zA-Z0-9:_-]+</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder id(java.lang.String id) {
                this.id = id;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FunctionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FunctionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FunctionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FunctionProperty {
            private final java.lang.String functionArn;
            private final java.lang.Object functionConfiguration;
            private final java.lang.String id;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.functionArn = software.amazon.jsii.Kernel.get(this, "functionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.functionConfiguration = software.amazon.jsii.Kernel.get(this, "functionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.functionArn = java.util.Objects.requireNonNull(builder.functionArn, "functionArn is required");
                this.functionConfiguration = java.util.Objects.requireNonNull(builder.functionConfiguration, "functionConfiguration is required");
                this.id = java.util.Objects.requireNonNull(builder.id, "id is required");
            }

            @Override
            public final java.lang.String getFunctionArn() {
                return this.functionArn;
            }

            @Override
            public final java.lang.Object getFunctionConfiguration() {
                return this.functionConfiguration;
            }

            @Override
            public final java.lang.String getId() {
                return this.id;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("functionArn", om.valueToTree(this.getFunctionArn()));
                data.set("functionConfiguration", om.valueToTree(this.getFunctionConfiguration()));
                data.set("id", om.valueToTree(this.getId()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_greengrass.CfnFunctionDefinitionVersion.FunctionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FunctionProperty.Jsii$Proxy that = (FunctionProperty.Jsii$Proxy) o;

                if (!functionArn.equals(that.functionArn)) return false;
                if (!functionConfiguration.equals(that.functionConfiguration)) return false;
                return this.id.equals(that.id);
            }

            @Override
            public final int hashCode() {
                int result = this.functionArn.hashCode();
                result = 31 * result + (this.functionConfiguration.hashCode());
                result = 31 * result + (this.id.hashCode());
                return result;
            }
        }
    }
    /**
     * A list of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-resourcedefinitionversion-resourceinstance.html">resources</a> in the group that the function can access, with the corresponding read-only or read-write permissions. The maximum is 10 resources.
     * <p>
     * <blockquote>
     * <p>
     * This property applies only to Lambda functions that run in a Greengrass container.
     * <p>
     * </blockquote>
     * <p>
     * In an AWS CloudFormation template, <code>ResourceAccessPolicy</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-environment.html"><code>Environment</code></a> property type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.greengrass.*;
     * ResourceAccessPolicyProperty resourceAccessPolicyProperty = ResourceAccessPolicyProperty.builder()
     *         .resourceId("resourceId")
     *         // the properties below are optional
     *         .permission("permission")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-resourceaccesspolicy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-resourceaccesspolicy.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_greengrass.CfnFunctionDefinitionVersion.ResourceAccessPolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(ResourceAccessPolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ResourceAccessPolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ID of the resource.
         * <p>
         * This ID is assigned to the resource when you create the resource definition.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-resourceaccesspolicy.html#cfn-greengrass-functiondefinitionversion-resourceaccesspolicy-resourceid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-resourceaccesspolicy.html#cfn-greengrass-functiondefinitionversion-resourceaccesspolicy-resourceid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getResourceId();

        /**
         * The read-only or read-write access that the Lambda function has to the resource.
         * <p>
         * Valid values are <code>ro</code> or <code>rw</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-resourceaccesspolicy.html#cfn-greengrass-functiondefinitionversion-resourceaccesspolicy-permission">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-resourceaccesspolicy.html#cfn-greengrass-functiondefinitionversion-resourceaccesspolicy-permission</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPermission() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ResourceAccessPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ResourceAccessPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ResourceAccessPolicyProperty> {
            java.lang.String resourceId;
            java.lang.String permission;

            /**
             * Sets the value of {@link ResourceAccessPolicyProperty#getResourceId}
             * @param resourceId The ID of the resource. This parameter is required.
             *                   This ID is assigned to the resource when you create the resource definition.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceId(java.lang.String resourceId) {
                this.resourceId = resourceId;
                return this;
            }

            /**
             * Sets the value of {@link ResourceAccessPolicyProperty#getPermission}
             * @param permission The read-only or read-write access that the Lambda function has to the resource.
             *                   Valid values are <code>ro</code> or <code>rw</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder permission(java.lang.String permission) {
                this.permission = permission;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ResourceAccessPolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ResourceAccessPolicyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ResourceAccessPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResourceAccessPolicyProperty {
            private final java.lang.String resourceId;
            private final java.lang.String permission;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.resourceId = software.amazon.jsii.Kernel.get(this, "resourceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.permission = software.amazon.jsii.Kernel.get(this, "permission", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.resourceId = java.util.Objects.requireNonNull(builder.resourceId, "resourceId is required");
                this.permission = builder.permission;
            }

            @Override
            public final java.lang.String getResourceId() {
                return this.resourceId;
            }

            @Override
            public final java.lang.String getPermission() {
                return this.permission;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("resourceId", om.valueToTree(this.getResourceId()));
                if (this.getPermission() != null) {
                    data.set("permission", om.valueToTree(this.getPermission()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_greengrass.CfnFunctionDefinitionVersion.ResourceAccessPolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ResourceAccessPolicyProperty.Jsii$Proxy that = (ResourceAccessPolicyProperty.Jsii$Proxy) o;

                if (!resourceId.equals(that.resourceId)) return false;
                return this.permission != null ? this.permission.equals(that.permission) : that.permission == null;
            }

            @Override
            public final int hashCode() {
                int result = this.resourceId.hashCode();
                result = 31 * result + (this.permission != null ? this.permission.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The user and group permissions used to run the Lambda function.
     * <p>
     * This setting overrides the default access identity that's specified for the group (by default, ggc_user and ggc_group). You can override the user, group, or both. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v1/developerguide/lambda-group-config.html#lambda-access-identity.html">Run as</a> in the <em>Developer Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * Running as the root user increases risks to your data and device. Do not run as root (UID/GID=0) unless your business case requires it. For more information and requirements, see <a href="https://docs.aws.amazon.com/greengrass/v1/developerguide/lambda-group-config.html#lambda-running-as-root">Running a Lambda Function as Root</a> .
     * <p>
     * </blockquote>
     * <p>
     * In an AWS CloudFormation template, <code>RunAs</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-execution.html"><code>Execution</code></a> property type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.greengrass.*;
     * RunAsProperty runAsProperty = RunAsProperty.builder()
     *         .gid(123)
     *         .uid(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-runas.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-runas.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_greengrass.CfnFunctionDefinitionVersion.RunAsProperty")
    @software.amazon.jsii.Jsii.Proxy(RunAsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RunAsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The group ID whose permissions are used to run the Lambda function.
         * <p>
         * You can use the <code>getent group</code> command on your core device to look up the group ID.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-runas.html#cfn-greengrass-functiondefinitionversion-runas-gid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-runas.html#cfn-greengrass-functiondefinitionversion-runas-gid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getGid() {
            return null;
        }

        /**
         * The user ID whose permissions are used to run the Lambda function.
         * <p>
         * You can use the <code>getent passwd</code> command on your core device to look up the user ID.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-runas.html#cfn-greengrass-functiondefinitionversion-runas-uid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrass-functiondefinitionversion-runas.html#cfn-greengrass-functiondefinitionversion-runas-uid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getUid() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RunAsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RunAsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RunAsProperty> {
            java.lang.Number gid;
            java.lang.Number uid;

            /**
             * Sets the value of {@link RunAsProperty#getGid}
             * @param gid The group ID whose permissions are used to run the Lambda function.
             *            You can use the <code>getent group</code> command on your core device to look up the group ID.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder gid(java.lang.Number gid) {
                this.gid = gid;
                return this;
            }

            /**
             * Sets the value of {@link RunAsProperty#getUid}
             * @param uid The user ID whose permissions are used to run the Lambda function.
             *            You can use the <code>getent passwd</code> command on your core device to look up the user ID.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder uid(java.lang.Number uid) {
                this.uid = uid;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RunAsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RunAsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RunAsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RunAsProperty {
            private final java.lang.Number gid;
            private final java.lang.Number uid;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.gid = software.amazon.jsii.Kernel.get(this, "gid", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.uid = software.amazon.jsii.Kernel.get(this, "uid", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.gid = builder.gid;
                this.uid = builder.uid;
            }

            @Override
            public final java.lang.Number getGid() {
                return this.gid;
            }

            @Override
            public final java.lang.Number getUid() {
                return this.uid;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getGid() != null) {
                    data.set("gid", om.valueToTree(this.getGid()));
                }
                if (this.getUid() != null) {
                    data.set("uid", om.valueToTree(this.getUid()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_greengrass.CfnFunctionDefinitionVersion.RunAsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RunAsProperty.Jsii$Proxy that = (RunAsProperty.Jsii$Proxy) o;

                if (this.gid != null ? !this.gid.equals(that.gid) : that.gid != null) return false;
                return this.uid != null ? this.uid.equals(that.uid) : that.uid == null;
            }

            @Override
            public final int hashCode() {
                int result = this.gid != null ? this.gid.hashCode() : 0;
                result = 31 * result + (this.uid != null ? this.uid.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.greengrass.CfnFunctionDefinitionVersion}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.greengrass.CfnFunctionDefinitionVersion> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.greengrass.CfnFunctionDefinitionVersionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.greengrass.CfnFunctionDefinitionVersionProps.Builder();
        }

        /**
         * The ID of the function definition associated with this version.
         * <p>
         * This value is a GUID.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-functiondefinitionversion.html#cfn-greengrass-functiondefinitionversion-functiondefinitionid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-functiondefinitionversion.html#cfn-greengrass-functiondefinitionversion-functiondefinitionid</a>
         * @param functionDefinitionId The ID of the function definition associated with this version. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder functionDefinitionId(final java.lang.String functionDefinitionId) {
            this.props.functionDefinitionId(functionDefinitionId);
            return this;
        }

        /**
         * The functions in this version.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-functiondefinitionversion.html#cfn-greengrass-functiondefinitionversion-functions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-functiondefinitionversion.html#cfn-greengrass-functiondefinitionversion-functions</a>
         * @param functions The functions in this version. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder functions(final software.amazon.awscdk.IResolvable functions) {
            this.props.functions(functions);
            return this;
        }
        /**
         * The functions in this version.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-functiondefinitionversion.html#cfn-greengrass-functiondefinitionversion-functions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-functiondefinitionversion.html#cfn-greengrass-functiondefinitionversion-functions</a>
         * @param functions The functions in this version. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder functions(final java.util.List<? extends java.lang.Object> functions) {
            this.props.functions(functions);
            return this;
        }

        /**
         * The default configuration that applies to all Lambda functions in the group.
         * <p>
         * Individual Lambda functions can override these settings.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-functiondefinitionversion.html#cfn-greengrass-functiondefinitionversion-defaultconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-functiondefinitionversion.html#cfn-greengrass-functiondefinitionversion-defaultconfig</a>
         * @param defaultConfig The default configuration that applies to all Lambda functions in the group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultConfig(final software.amazon.awscdk.IResolvable defaultConfig) {
            this.props.defaultConfig(defaultConfig);
            return this;
        }
        /**
         * The default configuration that applies to all Lambda functions in the group.
         * <p>
         * Individual Lambda functions can override these settings.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-functiondefinitionversion.html#cfn-greengrass-functiondefinitionversion-defaultconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrass-functiondefinitionversion.html#cfn-greengrass-functiondefinitionversion-defaultconfig</a>
         * @param defaultConfig The default configuration that applies to all Lambda functions in the group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultConfig(final software.amazon.awscdk.services.greengrass.CfnFunctionDefinitionVersion.DefaultConfigProperty defaultConfig) {
            this.props.defaultConfig(defaultConfig);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.greengrass.CfnFunctionDefinitionVersion}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.greengrass.CfnFunctionDefinitionVersion build() {
            return new software.amazon.awscdk.services.greengrass.CfnFunctionDefinitionVersion(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
