package software.amazon.awscdk.services.glue;

/**
 * The <code>AWS::Glue::Table</code> resource specifies tabular data in the AWS Glue data catalog.
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/glue/latest/dg/tables-described.html">Defining Tables in the AWS Glue Data Catalog</a> and <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-tables.html#aws-glue-api-catalog-tables-Table">Table Structure</a> in the <em>AWS Glue Developer Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.glue.*;
 * Object parameters;
 * Object skewedColumnValueLocationMaps;
 * CfnTable cfnTable = CfnTable.Builder.create(this, "MyCfnTable")
 *         .catalogId("catalogId")
 *         .databaseName("databaseName")
 *         .tableInput(TableInputProperty.builder()
 *                 .description("description")
 *                 .name("name")
 *                 .owner("owner")
 *                 .parameters(parameters)
 *                 .partitionKeys(List.of(ColumnProperty.builder()
 *                         .name("name")
 *                         // the properties below are optional
 *                         .comment("comment")
 *                         .type("type")
 *                         .build()))
 *                 .retention(123)
 *                 .storageDescriptor(StorageDescriptorProperty.builder()
 *                         .bucketColumns(List.of("bucketColumns"))
 *                         .columns(List.of(ColumnProperty.builder()
 *                                 .name("name")
 *                                 // the properties below are optional
 *                                 .comment("comment")
 *                                 .type("type")
 *                                 .build()))
 *                         .compressed(false)
 *                         .inputFormat("inputFormat")
 *                         .location("location")
 *                         .numberOfBuckets(123)
 *                         .outputFormat("outputFormat")
 *                         .parameters(parameters)
 *                         .schemaReference(SchemaReferenceProperty.builder()
 *                                 .schemaId(SchemaIdProperty.builder()
 *                                         .registryName("registryName")
 *                                         .schemaArn("schemaArn")
 *                                         .schemaName("schemaName")
 *                                         .build())
 *                                 .schemaVersionId("schemaVersionId")
 *                                 .schemaVersionNumber(123)
 *                                 .build())
 *                         .serdeInfo(SerdeInfoProperty.builder()
 *                                 .name("name")
 *                                 .parameters(parameters)
 *                                 .serializationLibrary("serializationLibrary")
 *                                 .build())
 *                         .skewedInfo(SkewedInfoProperty.builder()
 *                                 .skewedColumnNames(List.of("skewedColumnNames"))
 *                                 .skewedColumnValueLocationMaps(skewedColumnValueLocationMaps)
 *                                 .skewedColumnValues(List.of("skewedColumnValues"))
 *                                 .build())
 *                         .sortColumns(List.of(OrderProperty.builder()
 *                                 .column("column")
 *                                 .sortOrder(123)
 *                                 .build()))
 *                         .storedAsSubDirectories(false)
 *                         .build())
 *                 .tableType("tableType")
 *                 .targetTable(TableIdentifierProperty.builder()
 *                         .catalogId("catalogId")
 *                         .databaseName("databaseName")
 *                         .name("name")
 *                         .region("region")
 *                         .build())
 *                 .viewExpandedText("viewExpandedText")
 *                 .viewOriginalText("viewOriginalText")
 *                 .build())
 *         // the properties below are optional
 *         .openTableFormatInput(OpenTableFormatInputProperty.builder()
 *                 .icebergInput(IcebergInputProperty.builder()
 *                         .metadataOperation("metadataOperation")
 *                         .version("version")
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-table.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-table.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:14.159Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnTable")
public class CfnTable extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnTable(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnTable(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.glue.CfnTable.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnTable(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.CfnTableProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The ID of the Data Catalog in which to create the <code>Table</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getCatalogId() {
        return software.amazon.jsii.Kernel.get(this, "catalogId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the Data Catalog in which to create the <code>Table</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCatalogId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "catalogId", java.util.Objects.requireNonNull(value, "catalogId is required"));
    }

    /**
     * The name of the database where the table metadata resides.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDatabaseName() {
        return software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the database where the table metadata resides.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDatabaseName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "databaseName", java.util.Objects.requireNonNull(value, "databaseName is required"));
    }

    /**
     * A structure used to define a table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getTableInput() {
        return software.amazon.jsii.Kernel.get(this, "tableInput", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A structure used to define a table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTableInput(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "tableInput", java.util.Objects.requireNonNull(value, "tableInput is required"));
    }

    /**
     * A structure used to define a table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTableInput(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.CfnTable.TableInputProperty value) {
        software.amazon.jsii.Kernel.set(this, "tableInput", java.util.Objects.requireNonNull(value, "tableInput is required"));
    }

    /**
     * Specifies an <code>OpenTableFormatInput</code> structure when creating an open format table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getOpenTableFormatInput() {
        return software.amazon.jsii.Kernel.get(this, "openTableFormatInput", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies an <code>OpenTableFormatInput</code> structure when creating an open format table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOpenTableFormatInput(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "openTableFormatInput", value);
    }

    /**
     * Specifies an <code>OpenTableFormatInput</code> structure when creating an open format table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOpenTableFormatInput(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.glue.CfnTable.OpenTableFormatInputProperty value) {
        software.amazon.jsii.Kernel.set(this, "openTableFormatInput", value);
    }
    /**
     * A column in a <code>Table</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.glue.*;
     * ColumnProperty columnProperty = ColumnProperty.builder()
     *         .name("name")
     *         // the properties below are optional
     *         .comment("comment")
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-column.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-column.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnTable.ColumnProperty")
    @software.amazon.jsii.Jsii.Proxy(ColumnProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ColumnProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the <code>Column</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-column.html#cfn-glue-table-column-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-column.html#cfn-glue-table-column-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * A free-form text comment.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-column.html#cfn-glue-table-column-comment">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-column.html#cfn-glue-table-column-comment</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getComment() {
            return null;
        }

        /**
         * The data type of the <code>Column</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-column.html#cfn-glue-table-column-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-column.html#cfn-glue-table-column-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ColumnProperty> {
            java.lang.String name;
            java.lang.String comment;
            java.lang.String type;

            /**
             * Sets the value of {@link ColumnProperty#getName}
             * @param name The name of the <code>Column</code> . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link ColumnProperty#getComment}
             * @param comment A free-form text comment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder comment(java.lang.String comment) {
                this.comment = comment;
                return this;
            }

            /**
             * Sets the value of {@link ColumnProperty#getType}
             * @param type The data type of the <code>Column</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ColumnProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ColumnProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ColumnProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ColumnProperty {
            private final java.lang.String name;
            private final java.lang.String comment;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.comment = software.amazon.jsii.Kernel.get(this, "comment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.comment = builder.comment;
                this.type = builder.type;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getComment() {
                return this.comment;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                if (this.getComment() != null) {
                    data.set("comment", om.valueToTree(this.getComment()));
                }
                if (this.getType() != null) {
                    data.set("type", om.valueToTree(this.getType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_glue.CfnTable.ColumnProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ColumnProperty.Jsii$Proxy that = (ColumnProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                if (this.comment != null ? !this.comment.equals(that.comment) : that.comment != null) return false;
                return this.type != null ? this.type.equals(that.type) : that.type == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.comment != null ? this.comment.hashCode() : 0);
                result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies an input structure that defines an Apache Iceberg metadata table.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.glue.*;
     * IcebergInputProperty icebergInputProperty = IcebergInputProperty.builder()
     *         .metadataOperation("metadataOperation")
     *         .version("version")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-iceberginput.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-iceberginput.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnTable.IcebergInputProperty")
    @software.amazon.jsii.Jsii.Proxy(IcebergInputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IcebergInputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A required metadata operation.
         * <p>
         * Can only be set to CREATE.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-iceberginput.html#cfn-glue-table-iceberginput-metadataoperation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-iceberginput.html#cfn-glue-table-iceberginput-metadataoperation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMetadataOperation() {
            return null;
        }

        /**
         * The table version for the Iceberg table.
         * <p>
         * Defaults to 2.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-iceberginput.html#cfn-glue-table-iceberginput-version">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-iceberginput.html#cfn-glue-table-iceberginput-version</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVersion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IcebergInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IcebergInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IcebergInputProperty> {
            java.lang.String metadataOperation;
            java.lang.String version;

            /**
             * Sets the value of {@link IcebergInputProperty#getMetadataOperation}
             * @param metadataOperation A required metadata operation.
             *                          Can only be set to CREATE.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metadataOperation(java.lang.String metadataOperation) {
                this.metadataOperation = metadataOperation;
                return this;
            }

            /**
             * Sets the value of {@link IcebergInputProperty#getVersion}
             * @param version The table version for the Iceberg table.
             *                Defaults to 2.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder version(java.lang.String version) {
                this.version = version;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IcebergInputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IcebergInputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IcebergInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IcebergInputProperty {
            private final java.lang.String metadataOperation;
            private final java.lang.String version;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.metadataOperation = software.amazon.jsii.Kernel.get(this, "metadataOperation", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.version = software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.metadataOperation = builder.metadataOperation;
                this.version = builder.version;
            }

            @Override
            public final java.lang.String getMetadataOperation() {
                return this.metadataOperation;
            }

            @Override
            public final java.lang.String getVersion() {
                return this.version;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMetadataOperation() != null) {
                    data.set("metadataOperation", om.valueToTree(this.getMetadataOperation()));
                }
                if (this.getVersion() != null) {
                    data.set("version", om.valueToTree(this.getVersion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_glue.CfnTable.IcebergInputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IcebergInputProperty.Jsii$Proxy that = (IcebergInputProperty.Jsii$Proxy) o;

                if (this.metadataOperation != null ? !this.metadataOperation.equals(that.metadataOperation) : that.metadataOperation != null) return false;
                return this.version != null ? this.version.equals(that.version) : that.version == null;
            }

            @Override
            public final int hashCode() {
                int result = this.metadataOperation != null ? this.metadataOperation.hashCode() : 0;
                result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies an <code>OpenTableFormatInput</code> structure when creating an open format table.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.glue.*;
     * OpenTableFormatInputProperty openTableFormatInputProperty = OpenTableFormatInputProperty.builder()
     *         .icebergInput(IcebergInputProperty.builder()
     *                 .metadataOperation("metadataOperation")
     *                 .version("version")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-opentableformatinput.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-opentableformatinput.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnTable.OpenTableFormatInputProperty")
    @software.amazon.jsii.Jsii.Proxy(OpenTableFormatInputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OpenTableFormatInputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies an <code>IcebergInput</code> structure that defines an Apache Iceberg metadata table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-opentableformatinput.html#cfn-glue-table-opentableformatinput-iceberginput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-opentableformatinput.html#cfn-glue-table-opentableformatinput-iceberginput</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIcebergInput() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OpenTableFormatInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OpenTableFormatInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OpenTableFormatInputProperty> {
            java.lang.Object icebergInput;

            /**
             * Sets the value of {@link OpenTableFormatInputProperty#getIcebergInput}
             * @param icebergInput Specifies an <code>IcebergInput</code> structure that defines an Apache Iceberg metadata table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder icebergInput(software.amazon.awscdk.IResolvable icebergInput) {
                this.icebergInput = icebergInput;
                return this;
            }

            /**
             * Sets the value of {@link OpenTableFormatInputProperty#getIcebergInput}
             * @param icebergInput Specifies an <code>IcebergInput</code> structure that defines an Apache Iceberg metadata table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder icebergInput(software.amazon.awscdk.services.glue.CfnTable.IcebergInputProperty icebergInput) {
                this.icebergInput = icebergInput;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OpenTableFormatInputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OpenTableFormatInputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OpenTableFormatInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OpenTableFormatInputProperty {
            private final java.lang.Object icebergInput;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.icebergInput = software.amazon.jsii.Kernel.get(this, "icebergInput", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.icebergInput = builder.icebergInput;
            }

            @Override
            public final java.lang.Object getIcebergInput() {
                return this.icebergInput;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getIcebergInput() != null) {
                    data.set("icebergInput", om.valueToTree(this.getIcebergInput()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_glue.CfnTable.OpenTableFormatInputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OpenTableFormatInputProperty.Jsii$Proxy that = (OpenTableFormatInputProperty.Jsii$Proxy) o;

                return this.icebergInput != null ? this.icebergInput.equals(that.icebergInput) : that.icebergInput == null;
            }

            @Override
            public final int hashCode() {
                int result = this.icebergInput != null ? this.icebergInput.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Specifies the sort order of a sorted column.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.glue.*;
     * OrderProperty orderProperty = OrderProperty.builder()
     *         .column("column")
     *         .sortOrder(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-order.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-order.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnTable.OrderProperty")
    @software.amazon.jsii.Jsii.Proxy(OrderProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OrderProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the column.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-order.html#cfn-glue-table-order-column">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-order.html#cfn-glue-table-order-column</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getColumn();

        /**
         * Indicates that the column is sorted in ascending order ( <code>== 1</code> ), or in descending order ( <code>==0</code> ).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-order.html#cfn-glue-table-order-sortorder">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-order.html#cfn-glue-table-order-sortorder</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getSortOrder();

        /**
         * @return a {@link Builder} of {@link OrderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OrderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OrderProperty> {
            java.lang.String column;
            java.lang.Number sortOrder;

            /**
             * Sets the value of {@link OrderProperty#getColumn}
             * @param column The name of the column. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder column(java.lang.String column) {
                this.column = column;
                return this;
            }

            /**
             * Sets the value of {@link OrderProperty#getSortOrder}
             * @param sortOrder Indicates that the column is sorted in ascending order ( <code>== 1</code> ), or in descending order ( <code>==0</code> ). This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sortOrder(java.lang.Number sortOrder) {
                this.sortOrder = sortOrder;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OrderProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OrderProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OrderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OrderProperty {
            private final java.lang.String column;
            private final java.lang.Number sortOrder;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.column = software.amazon.jsii.Kernel.get(this, "column", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sortOrder = software.amazon.jsii.Kernel.get(this, "sortOrder", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.column = java.util.Objects.requireNonNull(builder.column, "column is required");
                this.sortOrder = java.util.Objects.requireNonNull(builder.sortOrder, "sortOrder is required");
            }

            @Override
            public final java.lang.String getColumn() {
                return this.column;
            }

            @Override
            public final java.lang.Number getSortOrder() {
                return this.sortOrder;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("column", om.valueToTree(this.getColumn()));
                data.set("sortOrder", om.valueToTree(this.getSortOrder()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_glue.CfnTable.OrderProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OrderProperty.Jsii$Proxy that = (OrderProperty.Jsii$Proxy) o;

                if (!column.equals(that.column)) return false;
                return this.sortOrder.equals(that.sortOrder);
            }

            @Override
            public final int hashCode() {
                int result = this.column.hashCode();
                result = 31 * result + (this.sortOrder.hashCode());
                return result;
            }
        }
    }
    /**
     * A structure that contains schema identity fields.
     * <p>
     * Either this or the <code>SchemaVersionId</code> has to be
     * provided.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.glue.*;
     * SchemaIdProperty schemaIdProperty = SchemaIdProperty.builder()
     *         .registryName("registryName")
     *         .schemaArn("schemaArn")
     *         .schemaName("schemaName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-schemaid.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-schemaid.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnTable.SchemaIdProperty")
    @software.amazon.jsii.Jsii.Proxy(SchemaIdProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SchemaIdProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the schema registry that contains the schema.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-schemaid.html#cfn-glue-table-schemaid-registryname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-schemaid.html#cfn-glue-table-schemaid-registryname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRegistryName() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) of the schema.
         * <p>
         * One of <code>SchemaArn</code> or <code>SchemaName</code> has to be
         * provided.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-schemaid.html#cfn-glue-table-schemaid-schemaarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-schemaid.html#cfn-glue-table-schemaid-schemaarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSchemaArn() {
            return null;
        }

        /**
         * The name of the schema.
         * <p>
         * One of <code>SchemaArn</code> or <code>SchemaName</code> has to be provided.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-schemaid.html#cfn-glue-table-schemaid-schemaname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-schemaid.html#cfn-glue-table-schemaid-schemaname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSchemaName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SchemaIdProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SchemaIdProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SchemaIdProperty> {
            java.lang.String registryName;
            java.lang.String schemaArn;
            java.lang.String schemaName;

            /**
             * Sets the value of {@link SchemaIdProperty#getRegistryName}
             * @param registryName The name of the schema registry that contains the schema.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder registryName(java.lang.String registryName) {
                this.registryName = registryName;
                return this;
            }

            /**
             * Sets the value of {@link SchemaIdProperty#getSchemaArn}
             * @param schemaArn The Amazon Resource Name (ARN) of the schema.
             *                  One of <code>SchemaArn</code> or <code>SchemaName</code> has to be
             *                  provided.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder schemaArn(java.lang.String schemaArn) {
                this.schemaArn = schemaArn;
                return this;
            }

            /**
             * Sets the value of {@link SchemaIdProperty#getSchemaName}
             * @param schemaName The name of the schema.
             *                   One of <code>SchemaArn</code> or <code>SchemaName</code> has to be provided.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder schemaName(java.lang.String schemaName) {
                this.schemaName = schemaName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SchemaIdProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SchemaIdProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SchemaIdProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SchemaIdProperty {
            private final java.lang.String registryName;
            private final java.lang.String schemaArn;
            private final java.lang.String schemaName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.registryName = software.amazon.jsii.Kernel.get(this, "registryName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.schemaArn = software.amazon.jsii.Kernel.get(this, "schemaArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.schemaName = software.amazon.jsii.Kernel.get(this, "schemaName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.registryName = builder.registryName;
                this.schemaArn = builder.schemaArn;
                this.schemaName = builder.schemaName;
            }

            @Override
            public final java.lang.String getRegistryName() {
                return this.registryName;
            }

            @Override
            public final java.lang.String getSchemaArn() {
                return this.schemaArn;
            }

            @Override
            public final java.lang.String getSchemaName() {
                return this.schemaName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getRegistryName() != null) {
                    data.set("registryName", om.valueToTree(this.getRegistryName()));
                }
                if (this.getSchemaArn() != null) {
                    data.set("schemaArn", om.valueToTree(this.getSchemaArn()));
                }
                if (this.getSchemaName() != null) {
                    data.set("schemaName", om.valueToTree(this.getSchemaName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_glue.CfnTable.SchemaIdProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SchemaIdProperty.Jsii$Proxy that = (SchemaIdProperty.Jsii$Proxy) o;

                if (this.registryName != null ? !this.registryName.equals(that.registryName) : that.registryName != null) return false;
                if (this.schemaArn != null ? !this.schemaArn.equals(that.schemaArn) : that.schemaArn != null) return false;
                return this.schemaName != null ? this.schemaName.equals(that.schemaName) : that.schemaName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.registryName != null ? this.registryName.hashCode() : 0;
                result = 31 * result + (this.schemaArn != null ? this.schemaArn.hashCode() : 0);
                result = 31 * result + (this.schemaName != null ? this.schemaName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that references a schema stored in the AWS Glue Schema Registry.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.glue.*;
     * SchemaReferenceProperty schemaReferenceProperty = SchemaReferenceProperty.builder()
     *         .schemaId(SchemaIdProperty.builder()
     *                 .registryName("registryName")
     *                 .schemaArn("schemaArn")
     *                 .schemaName("schemaName")
     *                 .build())
     *         .schemaVersionId("schemaVersionId")
     *         .schemaVersionNumber(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-schemareference.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-schemareference.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnTable.SchemaReferenceProperty")
    @software.amazon.jsii.Jsii.Proxy(SchemaReferenceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SchemaReferenceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A structure that contains schema identity fields.
         * <p>
         * Either this or the <code>SchemaVersionId</code> has to be
         * provided.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-schemareference.html#cfn-glue-table-schemareference-schemaid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-schemareference.html#cfn-glue-table-schemareference-schemaid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSchemaId() {
            return null;
        }

        /**
         * The unique ID assigned to a version of the schema.
         * <p>
         * Either this or the <code>SchemaId</code> has to be provided.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-schemareference.html#cfn-glue-table-schemareference-schemaversionid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-schemareference.html#cfn-glue-table-schemareference-schemaversionid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSchemaVersionId() {
            return null;
        }

        /**
         * The version number of the schema.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-schemareference.html#cfn-glue-table-schemareference-schemaversionnumber">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-schemareference.html#cfn-glue-table-schemareference-schemaversionnumber</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSchemaVersionNumber() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SchemaReferenceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SchemaReferenceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SchemaReferenceProperty> {
            java.lang.Object schemaId;
            java.lang.String schemaVersionId;
            java.lang.Number schemaVersionNumber;

            /**
             * Sets the value of {@link SchemaReferenceProperty#getSchemaId}
             * @param schemaId A structure that contains schema identity fields.
             *                 Either this or the <code>SchemaVersionId</code> has to be
             *                 provided.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder schemaId(software.amazon.awscdk.IResolvable schemaId) {
                this.schemaId = schemaId;
                return this;
            }

            /**
             * Sets the value of {@link SchemaReferenceProperty#getSchemaId}
             * @param schemaId A structure that contains schema identity fields.
             *                 Either this or the <code>SchemaVersionId</code> has to be
             *                 provided.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder schemaId(software.amazon.awscdk.services.glue.CfnTable.SchemaIdProperty schemaId) {
                this.schemaId = schemaId;
                return this;
            }

            /**
             * Sets the value of {@link SchemaReferenceProperty#getSchemaVersionId}
             * @param schemaVersionId The unique ID assigned to a version of the schema.
             *                        Either this or the <code>SchemaId</code> has to be provided.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder schemaVersionId(java.lang.String schemaVersionId) {
                this.schemaVersionId = schemaVersionId;
                return this;
            }

            /**
             * Sets the value of {@link SchemaReferenceProperty#getSchemaVersionNumber}
             * @param schemaVersionNumber The version number of the schema.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder schemaVersionNumber(java.lang.Number schemaVersionNumber) {
                this.schemaVersionNumber = schemaVersionNumber;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SchemaReferenceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SchemaReferenceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SchemaReferenceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SchemaReferenceProperty {
            private final java.lang.Object schemaId;
            private final java.lang.String schemaVersionId;
            private final java.lang.Number schemaVersionNumber;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.schemaId = software.amazon.jsii.Kernel.get(this, "schemaId", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.schemaVersionId = software.amazon.jsii.Kernel.get(this, "schemaVersionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.schemaVersionNumber = software.amazon.jsii.Kernel.get(this, "schemaVersionNumber", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.schemaId = builder.schemaId;
                this.schemaVersionId = builder.schemaVersionId;
                this.schemaVersionNumber = builder.schemaVersionNumber;
            }

            @Override
            public final java.lang.Object getSchemaId() {
                return this.schemaId;
            }

            @Override
            public final java.lang.String getSchemaVersionId() {
                return this.schemaVersionId;
            }

            @Override
            public final java.lang.Number getSchemaVersionNumber() {
                return this.schemaVersionNumber;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSchemaId() != null) {
                    data.set("schemaId", om.valueToTree(this.getSchemaId()));
                }
                if (this.getSchemaVersionId() != null) {
                    data.set("schemaVersionId", om.valueToTree(this.getSchemaVersionId()));
                }
                if (this.getSchemaVersionNumber() != null) {
                    data.set("schemaVersionNumber", om.valueToTree(this.getSchemaVersionNumber()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_glue.CfnTable.SchemaReferenceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SchemaReferenceProperty.Jsii$Proxy that = (SchemaReferenceProperty.Jsii$Proxy) o;

                if (this.schemaId != null ? !this.schemaId.equals(that.schemaId) : that.schemaId != null) return false;
                if (this.schemaVersionId != null ? !this.schemaVersionId.equals(that.schemaVersionId) : that.schemaVersionId != null) return false;
                return this.schemaVersionNumber != null ? this.schemaVersionNumber.equals(that.schemaVersionNumber) : that.schemaVersionNumber == null;
            }

            @Override
            public final int hashCode() {
                int result = this.schemaId != null ? this.schemaId.hashCode() : 0;
                result = 31 * result + (this.schemaVersionId != null ? this.schemaVersionId.hashCode() : 0);
                result = 31 * result + (this.schemaVersionNumber != null ? this.schemaVersionNumber.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about a serialization/deserialization program (SerDe) that serves as an extractor and loader.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.glue.*;
     * Object parameters;
     * SerdeInfoProperty serdeInfoProperty = SerdeInfoProperty.builder()
     *         .name("name")
     *         .parameters(parameters)
     *         .serializationLibrary("serializationLibrary")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-serdeinfo.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-serdeinfo.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnTable.SerdeInfoProperty")
    @software.amazon.jsii.Jsii.Proxy(SerdeInfoProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SerdeInfoProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Name of the SerDe.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-serdeinfo.html#cfn-glue-table-serdeinfo-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-serdeinfo.html#cfn-glue-table-serdeinfo-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * These key-value pairs define initialization parameters for the SerDe.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-serdeinfo.html#cfn-glue-table-serdeinfo-parameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-serdeinfo.html#cfn-glue-table-serdeinfo-parameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getParameters() {
            return null;
        }

        /**
         * Usually the class that implements the SerDe.
         * <p>
         * An example is <code>org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-serdeinfo.html#cfn-glue-table-serdeinfo-serializationlibrary">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-serdeinfo.html#cfn-glue-table-serdeinfo-serializationlibrary</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSerializationLibrary() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SerdeInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SerdeInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SerdeInfoProperty> {
            java.lang.String name;
            java.lang.Object parameters;
            java.lang.String serializationLibrary;

            /**
             * Sets the value of {@link SerdeInfoProperty#getName}
             * @param name Name of the SerDe.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link SerdeInfoProperty#getParameters}
             * @param parameters These key-value pairs define initialization parameters for the SerDe.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parameters(java.lang.Object parameters) {
                this.parameters = parameters;
                return this;
            }

            /**
             * Sets the value of {@link SerdeInfoProperty#getSerializationLibrary}
             * @param serializationLibrary Usually the class that implements the SerDe.
             *                             An example is <code>org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serializationLibrary(java.lang.String serializationLibrary) {
                this.serializationLibrary = serializationLibrary;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SerdeInfoProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SerdeInfoProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SerdeInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SerdeInfoProperty {
            private final java.lang.String name;
            private final java.lang.Object parameters;
            private final java.lang.String serializationLibrary;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.parameters = software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.serializationLibrary = software.amazon.jsii.Kernel.get(this, "serializationLibrary", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = builder.name;
                this.parameters = builder.parameters;
                this.serializationLibrary = builder.serializationLibrary;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Object getParameters() {
                return this.parameters;
            }

            @Override
            public final java.lang.String getSerializationLibrary() {
                return this.serializationLibrary;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getParameters() != null) {
                    data.set("parameters", om.valueToTree(this.getParameters()));
                }
                if (this.getSerializationLibrary() != null) {
                    data.set("serializationLibrary", om.valueToTree(this.getSerializationLibrary()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_glue.CfnTable.SerdeInfoProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SerdeInfoProperty.Jsii$Proxy that = (SerdeInfoProperty.Jsii$Proxy) o;

                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) return false;
                return this.serializationLibrary != null ? this.serializationLibrary.equals(that.serializationLibrary) : that.serializationLibrary == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name != null ? this.name.hashCode() : 0;
                result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
                result = 31 * result + (this.serializationLibrary != null ? this.serializationLibrary.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies skewed values in a table.
     * <p>
     * Skewed values are those that occur with very high frequency.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.glue.*;
     * Object skewedColumnValueLocationMaps;
     * SkewedInfoProperty skewedInfoProperty = SkewedInfoProperty.builder()
     *         .skewedColumnNames(List.of("skewedColumnNames"))
     *         .skewedColumnValueLocationMaps(skewedColumnValueLocationMaps)
     *         .skewedColumnValues(List.of("skewedColumnValues"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-skewedinfo.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-skewedinfo.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnTable.SkewedInfoProperty")
    @software.amazon.jsii.Jsii.Proxy(SkewedInfoProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SkewedInfoProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of names of columns that contain skewed values.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-skewedinfo.html#cfn-glue-table-skewedinfo-skewedcolumnnames">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-skewedinfo.html#cfn-glue-table-skewedinfo-skewedcolumnnames</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSkewedColumnNames() {
            return null;
        }

        /**
         * A mapping of skewed values to the columns that contain them.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-skewedinfo.html#cfn-glue-table-skewedinfo-skewedcolumnvaluelocationmaps">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-skewedinfo.html#cfn-glue-table-skewedinfo-skewedcolumnvaluelocationmaps</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSkewedColumnValueLocationMaps() {
            return null;
        }

        /**
         * A list of values that appear so frequently as to be considered skewed.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-skewedinfo.html#cfn-glue-table-skewedinfo-skewedcolumnvalues">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-skewedinfo.html#cfn-glue-table-skewedinfo-skewedcolumnvalues</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSkewedColumnValues() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SkewedInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SkewedInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SkewedInfoProperty> {
            java.util.List<java.lang.String> skewedColumnNames;
            java.lang.Object skewedColumnValueLocationMaps;
            java.util.List<java.lang.String> skewedColumnValues;

            /**
             * Sets the value of {@link SkewedInfoProperty#getSkewedColumnNames}
             * @param skewedColumnNames A list of names of columns that contain skewed values.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder skewedColumnNames(java.util.List<java.lang.String> skewedColumnNames) {
                this.skewedColumnNames = skewedColumnNames;
                return this;
            }

            /**
             * Sets the value of {@link SkewedInfoProperty#getSkewedColumnValueLocationMaps}
             * @param skewedColumnValueLocationMaps A mapping of skewed values to the columns that contain them.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder skewedColumnValueLocationMaps(java.lang.Object skewedColumnValueLocationMaps) {
                this.skewedColumnValueLocationMaps = skewedColumnValueLocationMaps;
                return this;
            }

            /**
             * Sets the value of {@link SkewedInfoProperty#getSkewedColumnValues}
             * @param skewedColumnValues A list of values that appear so frequently as to be considered skewed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder skewedColumnValues(java.util.List<java.lang.String> skewedColumnValues) {
                this.skewedColumnValues = skewedColumnValues;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SkewedInfoProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SkewedInfoProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SkewedInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SkewedInfoProperty {
            private final java.util.List<java.lang.String> skewedColumnNames;
            private final java.lang.Object skewedColumnValueLocationMaps;
            private final java.util.List<java.lang.String> skewedColumnValues;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.skewedColumnNames = software.amazon.jsii.Kernel.get(this, "skewedColumnNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.skewedColumnValueLocationMaps = software.amazon.jsii.Kernel.get(this, "skewedColumnValueLocationMaps", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.skewedColumnValues = software.amazon.jsii.Kernel.get(this, "skewedColumnValues", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.skewedColumnNames = builder.skewedColumnNames;
                this.skewedColumnValueLocationMaps = builder.skewedColumnValueLocationMaps;
                this.skewedColumnValues = builder.skewedColumnValues;
            }

            @Override
            public final java.util.List<java.lang.String> getSkewedColumnNames() {
                return this.skewedColumnNames;
            }

            @Override
            public final java.lang.Object getSkewedColumnValueLocationMaps() {
                return this.skewedColumnValueLocationMaps;
            }

            @Override
            public final java.util.List<java.lang.String> getSkewedColumnValues() {
                return this.skewedColumnValues;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSkewedColumnNames() != null) {
                    data.set("skewedColumnNames", om.valueToTree(this.getSkewedColumnNames()));
                }
                if (this.getSkewedColumnValueLocationMaps() != null) {
                    data.set("skewedColumnValueLocationMaps", om.valueToTree(this.getSkewedColumnValueLocationMaps()));
                }
                if (this.getSkewedColumnValues() != null) {
                    data.set("skewedColumnValues", om.valueToTree(this.getSkewedColumnValues()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_glue.CfnTable.SkewedInfoProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SkewedInfoProperty.Jsii$Proxy that = (SkewedInfoProperty.Jsii$Proxy) o;

                if (this.skewedColumnNames != null ? !this.skewedColumnNames.equals(that.skewedColumnNames) : that.skewedColumnNames != null) return false;
                if (this.skewedColumnValueLocationMaps != null ? !this.skewedColumnValueLocationMaps.equals(that.skewedColumnValueLocationMaps) : that.skewedColumnValueLocationMaps != null) return false;
                return this.skewedColumnValues != null ? this.skewedColumnValues.equals(that.skewedColumnValues) : that.skewedColumnValues == null;
            }

            @Override
            public final int hashCode() {
                int result = this.skewedColumnNames != null ? this.skewedColumnNames.hashCode() : 0;
                result = 31 * result + (this.skewedColumnValueLocationMaps != null ? this.skewedColumnValueLocationMaps.hashCode() : 0);
                result = 31 * result + (this.skewedColumnValues != null ? this.skewedColumnValues.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes the physical storage of table data.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.glue.*;
     * Object parameters;
     * Object skewedColumnValueLocationMaps;
     * StorageDescriptorProperty storageDescriptorProperty = StorageDescriptorProperty.builder()
     *         .bucketColumns(List.of("bucketColumns"))
     *         .columns(List.of(ColumnProperty.builder()
     *                 .name("name")
     *                 // the properties below are optional
     *                 .comment("comment")
     *                 .type("type")
     *                 .build()))
     *         .compressed(false)
     *         .inputFormat("inputFormat")
     *         .location("location")
     *         .numberOfBuckets(123)
     *         .outputFormat("outputFormat")
     *         .parameters(parameters)
     *         .schemaReference(SchemaReferenceProperty.builder()
     *                 .schemaId(SchemaIdProperty.builder()
     *                         .registryName("registryName")
     *                         .schemaArn("schemaArn")
     *                         .schemaName("schemaName")
     *                         .build())
     *                 .schemaVersionId("schemaVersionId")
     *                 .schemaVersionNumber(123)
     *                 .build())
     *         .serdeInfo(SerdeInfoProperty.builder()
     *                 .name("name")
     *                 .parameters(parameters)
     *                 .serializationLibrary("serializationLibrary")
     *                 .build())
     *         .skewedInfo(SkewedInfoProperty.builder()
     *                 .skewedColumnNames(List.of("skewedColumnNames"))
     *                 .skewedColumnValueLocationMaps(skewedColumnValueLocationMaps)
     *                 .skewedColumnValues(List.of("skewedColumnValues"))
     *                 .build())
     *         .sortColumns(List.of(OrderProperty.builder()
     *                 .column("column")
     *                 .sortOrder(123)
     *                 .build()))
     *         .storedAsSubDirectories(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-storagedescriptor.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-storagedescriptor.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnTable.StorageDescriptorProperty")
    @software.amazon.jsii.Jsii.Proxy(StorageDescriptorProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StorageDescriptorProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of reducer grouping columns, clustering columns, and bucketing columns in the table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-storagedescriptor.html#cfn-glue-table-storagedescriptor-bucketcolumns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-storagedescriptor.html#cfn-glue-table-storagedescriptor-bucketcolumns</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getBucketColumns() {
            return null;
        }

        /**
         * A list of the <code>Columns</code> in the table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-storagedescriptor.html#cfn-glue-table-storagedescriptor-columns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-storagedescriptor.html#cfn-glue-table-storagedescriptor-columns</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getColumns() {
            return null;
        }

        /**
         * <code>True</code> if the data in the table is compressed, or <code>False</code> if not.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-storagedescriptor.html#cfn-glue-table-storagedescriptor-compressed">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-storagedescriptor.html#cfn-glue-table-storagedescriptor-compressed</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCompressed() {
            return null;
        }

        /**
         * The input format: <code>SequenceFileInputFormat</code> (binary), or <code>TextInputFormat</code> , or a custom format.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-storagedescriptor.html#cfn-glue-table-storagedescriptor-inputformat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-storagedescriptor.html#cfn-glue-table-storagedescriptor-inputformat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInputFormat() {
            return null;
        }

        /**
         * The physical location of the table.
         * <p>
         * By default, this takes the form of the warehouse location, followed by the database location in the warehouse, followed by the table name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-storagedescriptor.html#cfn-glue-table-storagedescriptor-location">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-storagedescriptor.html#cfn-glue-table-storagedescriptor-location</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLocation() {
            return null;
        }

        /**
         * Must be specified if the table contains any dimension columns.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-storagedescriptor.html#cfn-glue-table-storagedescriptor-numberofbuckets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-storagedescriptor.html#cfn-glue-table-storagedescriptor-numberofbuckets</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getNumberOfBuckets() {
            return null;
        }

        /**
         * The output format: <code>SequenceFileOutputFormat</code> (binary), or <code>IgnoreKeyTextOutputFormat</code> , or a custom format.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-storagedescriptor.html#cfn-glue-table-storagedescriptor-outputformat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-storagedescriptor.html#cfn-glue-table-storagedescriptor-outputformat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOutputFormat() {
            return null;
        }

        /**
         * The user-supplied properties in key-value form.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-storagedescriptor.html#cfn-glue-table-storagedescriptor-parameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-storagedescriptor.html#cfn-glue-table-storagedescriptor-parameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getParameters() {
            return null;
        }

        /**
         * An object that references a schema stored in the AWS Glue Schema Registry.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-storagedescriptor.html#cfn-glue-table-storagedescriptor-schemareference">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-storagedescriptor.html#cfn-glue-table-storagedescriptor-schemareference</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSchemaReference() {
            return null;
        }

        /**
         * The serialization/deserialization (SerDe) information.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-storagedescriptor.html#cfn-glue-table-storagedescriptor-serdeinfo">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-storagedescriptor.html#cfn-glue-table-storagedescriptor-serdeinfo</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSerdeInfo() {
            return null;
        }

        /**
         * The information about values that appear frequently in a column (skewed values).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-storagedescriptor.html#cfn-glue-table-storagedescriptor-skewedinfo">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-storagedescriptor.html#cfn-glue-table-storagedescriptor-skewedinfo</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSkewedInfo() {
            return null;
        }

        /**
         * A list specifying the sort order of each bucket in the table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-storagedescriptor.html#cfn-glue-table-storagedescriptor-sortcolumns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-storagedescriptor.html#cfn-glue-table-storagedescriptor-sortcolumns</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSortColumns() {
            return null;
        }

        /**
         * <code>True</code> if the table data is stored in subdirectories, or <code>False</code> if not.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-storagedescriptor.html#cfn-glue-table-storagedescriptor-storedassubdirectories">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-storagedescriptor.html#cfn-glue-table-storagedescriptor-storedassubdirectories</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStoredAsSubDirectories() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link StorageDescriptorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StorageDescriptorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StorageDescriptorProperty> {
            java.util.List<java.lang.String> bucketColumns;
            java.lang.Object columns;
            java.lang.Object compressed;
            java.lang.String inputFormat;
            java.lang.String location;
            java.lang.Number numberOfBuckets;
            java.lang.String outputFormat;
            java.lang.Object parameters;
            java.lang.Object schemaReference;
            java.lang.Object serdeInfo;
            java.lang.Object skewedInfo;
            java.lang.Object sortColumns;
            java.lang.Object storedAsSubDirectories;

            /**
             * Sets the value of {@link StorageDescriptorProperty#getBucketColumns}
             * @param bucketColumns A list of reducer grouping columns, clustering columns, and bucketing columns in the table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketColumns(java.util.List<java.lang.String> bucketColumns) {
                this.bucketColumns = bucketColumns;
                return this;
            }

            /**
             * Sets the value of {@link StorageDescriptorProperty#getColumns}
             * @param columns A list of the <code>Columns</code> in the table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columns(software.amazon.awscdk.IResolvable columns) {
                this.columns = columns;
                return this;
            }

            /**
             * Sets the value of {@link StorageDescriptorProperty#getColumns}
             * @param columns A list of the <code>Columns</code> in the table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columns(java.util.List<? extends java.lang.Object> columns) {
                this.columns = columns;
                return this;
            }

            /**
             * Sets the value of {@link StorageDescriptorProperty#getCompressed}
             * @param compressed <code>True</code> if the data in the table is compressed, or <code>False</code> if not.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder compressed(java.lang.Boolean compressed) {
                this.compressed = compressed;
                return this;
            }

            /**
             * Sets the value of {@link StorageDescriptorProperty#getCompressed}
             * @param compressed <code>True</code> if the data in the table is compressed, or <code>False</code> if not.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder compressed(software.amazon.awscdk.IResolvable compressed) {
                this.compressed = compressed;
                return this;
            }

            /**
             * Sets the value of {@link StorageDescriptorProperty#getInputFormat}
             * @param inputFormat The input format: <code>SequenceFileInputFormat</code> (binary), or <code>TextInputFormat</code> , or a custom format.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputFormat(java.lang.String inputFormat) {
                this.inputFormat = inputFormat;
                return this;
            }

            /**
             * Sets the value of {@link StorageDescriptorProperty#getLocation}
             * @param location The physical location of the table.
             *                 By default, this takes the form of the warehouse location, followed by the database location in the warehouse, followed by the table name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder location(java.lang.String location) {
                this.location = location;
                return this;
            }

            /**
             * Sets the value of {@link StorageDescriptorProperty#getNumberOfBuckets}
             * @param numberOfBuckets Must be specified if the table contains any dimension columns.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder numberOfBuckets(java.lang.Number numberOfBuckets) {
                this.numberOfBuckets = numberOfBuckets;
                return this;
            }

            /**
             * Sets the value of {@link StorageDescriptorProperty#getOutputFormat}
             * @param outputFormat The output format: <code>SequenceFileOutputFormat</code> (binary), or <code>IgnoreKeyTextOutputFormat</code> , or a custom format.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputFormat(java.lang.String outputFormat) {
                this.outputFormat = outputFormat;
                return this;
            }

            /**
             * Sets the value of {@link StorageDescriptorProperty#getParameters}
             * @param parameters The user-supplied properties in key-value form.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parameters(java.lang.Object parameters) {
                this.parameters = parameters;
                return this;
            }

            /**
             * Sets the value of {@link StorageDescriptorProperty#getSchemaReference}
             * @param schemaReference An object that references a schema stored in the AWS Glue Schema Registry.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder schemaReference(software.amazon.awscdk.IResolvable schemaReference) {
                this.schemaReference = schemaReference;
                return this;
            }

            /**
             * Sets the value of {@link StorageDescriptorProperty#getSchemaReference}
             * @param schemaReference An object that references a schema stored in the AWS Glue Schema Registry.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder schemaReference(software.amazon.awscdk.services.glue.CfnTable.SchemaReferenceProperty schemaReference) {
                this.schemaReference = schemaReference;
                return this;
            }

            /**
             * Sets the value of {@link StorageDescriptorProperty#getSerdeInfo}
             * @param serdeInfo The serialization/deserialization (SerDe) information.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serdeInfo(software.amazon.awscdk.IResolvable serdeInfo) {
                this.serdeInfo = serdeInfo;
                return this;
            }

            /**
             * Sets the value of {@link StorageDescriptorProperty#getSerdeInfo}
             * @param serdeInfo The serialization/deserialization (SerDe) information.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serdeInfo(software.amazon.awscdk.services.glue.CfnTable.SerdeInfoProperty serdeInfo) {
                this.serdeInfo = serdeInfo;
                return this;
            }

            /**
             * Sets the value of {@link StorageDescriptorProperty#getSkewedInfo}
             * @param skewedInfo The information about values that appear frequently in a column (skewed values).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder skewedInfo(software.amazon.awscdk.IResolvable skewedInfo) {
                this.skewedInfo = skewedInfo;
                return this;
            }

            /**
             * Sets the value of {@link StorageDescriptorProperty#getSkewedInfo}
             * @param skewedInfo The information about values that appear frequently in a column (skewed values).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder skewedInfo(software.amazon.awscdk.services.glue.CfnTable.SkewedInfoProperty skewedInfo) {
                this.skewedInfo = skewedInfo;
                return this;
            }

            /**
             * Sets the value of {@link StorageDescriptorProperty#getSortColumns}
             * @param sortColumns A list specifying the sort order of each bucket in the table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sortColumns(software.amazon.awscdk.IResolvable sortColumns) {
                this.sortColumns = sortColumns;
                return this;
            }

            /**
             * Sets the value of {@link StorageDescriptorProperty#getSortColumns}
             * @param sortColumns A list specifying the sort order of each bucket in the table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sortColumns(java.util.List<? extends java.lang.Object> sortColumns) {
                this.sortColumns = sortColumns;
                return this;
            }

            /**
             * Sets the value of {@link StorageDescriptorProperty#getStoredAsSubDirectories}
             * @param storedAsSubDirectories <code>True</code> if the table data is stored in subdirectories, or <code>False</code> if not.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder storedAsSubDirectories(java.lang.Boolean storedAsSubDirectories) {
                this.storedAsSubDirectories = storedAsSubDirectories;
                return this;
            }

            /**
             * Sets the value of {@link StorageDescriptorProperty#getStoredAsSubDirectories}
             * @param storedAsSubDirectories <code>True</code> if the table data is stored in subdirectories, or <code>False</code> if not.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder storedAsSubDirectories(software.amazon.awscdk.IResolvable storedAsSubDirectories) {
                this.storedAsSubDirectories = storedAsSubDirectories;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StorageDescriptorProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StorageDescriptorProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StorageDescriptorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StorageDescriptorProperty {
            private final java.util.List<java.lang.String> bucketColumns;
            private final java.lang.Object columns;
            private final java.lang.Object compressed;
            private final java.lang.String inputFormat;
            private final java.lang.String location;
            private final java.lang.Number numberOfBuckets;
            private final java.lang.String outputFormat;
            private final java.lang.Object parameters;
            private final java.lang.Object schemaReference;
            private final java.lang.Object serdeInfo;
            private final java.lang.Object skewedInfo;
            private final java.lang.Object sortColumns;
            private final java.lang.Object storedAsSubDirectories;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucketColumns = software.amazon.jsii.Kernel.get(this, "bucketColumns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.columns = software.amazon.jsii.Kernel.get(this, "columns", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.compressed = software.amazon.jsii.Kernel.get(this, "compressed", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.inputFormat = software.amazon.jsii.Kernel.get(this, "inputFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.location = software.amazon.jsii.Kernel.get(this, "location", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.numberOfBuckets = software.amazon.jsii.Kernel.get(this, "numberOfBuckets", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.outputFormat = software.amazon.jsii.Kernel.get(this, "outputFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.parameters = software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.schemaReference = software.amazon.jsii.Kernel.get(this, "schemaReference", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.serdeInfo = software.amazon.jsii.Kernel.get(this, "serdeInfo", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.skewedInfo = software.amazon.jsii.Kernel.get(this, "skewedInfo", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sortColumns = software.amazon.jsii.Kernel.get(this, "sortColumns", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.storedAsSubDirectories = software.amazon.jsii.Kernel.get(this, "storedAsSubDirectories", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucketColumns = builder.bucketColumns;
                this.columns = builder.columns;
                this.compressed = builder.compressed;
                this.inputFormat = builder.inputFormat;
                this.location = builder.location;
                this.numberOfBuckets = builder.numberOfBuckets;
                this.outputFormat = builder.outputFormat;
                this.parameters = builder.parameters;
                this.schemaReference = builder.schemaReference;
                this.serdeInfo = builder.serdeInfo;
                this.skewedInfo = builder.skewedInfo;
                this.sortColumns = builder.sortColumns;
                this.storedAsSubDirectories = builder.storedAsSubDirectories;
            }

            @Override
            public final java.util.List<java.lang.String> getBucketColumns() {
                return this.bucketColumns;
            }

            @Override
            public final java.lang.Object getColumns() {
                return this.columns;
            }

            @Override
            public final java.lang.Object getCompressed() {
                return this.compressed;
            }

            @Override
            public final java.lang.String getInputFormat() {
                return this.inputFormat;
            }

            @Override
            public final java.lang.String getLocation() {
                return this.location;
            }

            @Override
            public final java.lang.Number getNumberOfBuckets() {
                return this.numberOfBuckets;
            }

            @Override
            public final java.lang.String getOutputFormat() {
                return this.outputFormat;
            }

            @Override
            public final java.lang.Object getParameters() {
                return this.parameters;
            }

            @Override
            public final java.lang.Object getSchemaReference() {
                return this.schemaReference;
            }

            @Override
            public final java.lang.Object getSerdeInfo() {
                return this.serdeInfo;
            }

            @Override
            public final java.lang.Object getSkewedInfo() {
                return this.skewedInfo;
            }

            @Override
            public final java.lang.Object getSortColumns() {
                return this.sortColumns;
            }

            @Override
            public final java.lang.Object getStoredAsSubDirectories() {
                return this.storedAsSubDirectories;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBucketColumns() != null) {
                    data.set("bucketColumns", om.valueToTree(this.getBucketColumns()));
                }
                if (this.getColumns() != null) {
                    data.set("columns", om.valueToTree(this.getColumns()));
                }
                if (this.getCompressed() != null) {
                    data.set("compressed", om.valueToTree(this.getCompressed()));
                }
                if (this.getInputFormat() != null) {
                    data.set("inputFormat", om.valueToTree(this.getInputFormat()));
                }
                if (this.getLocation() != null) {
                    data.set("location", om.valueToTree(this.getLocation()));
                }
                if (this.getNumberOfBuckets() != null) {
                    data.set("numberOfBuckets", om.valueToTree(this.getNumberOfBuckets()));
                }
                if (this.getOutputFormat() != null) {
                    data.set("outputFormat", om.valueToTree(this.getOutputFormat()));
                }
                if (this.getParameters() != null) {
                    data.set("parameters", om.valueToTree(this.getParameters()));
                }
                if (this.getSchemaReference() != null) {
                    data.set("schemaReference", om.valueToTree(this.getSchemaReference()));
                }
                if (this.getSerdeInfo() != null) {
                    data.set("serdeInfo", om.valueToTree(this.getSerdeInfo()));
                }
                if (this.getSkewedInfo() != null) {
                    data.set("skewedInfo", om.valueToTree(this.getSkewedInfo()));
                }
                if (this.getSortColumns() != null) {
                    data.set("sortColumns", om.valueToTree(this.getSortColumns()));
                }
                if (this.getStoredAsSubDirectories() != null) {
                    data.set("storedAsSubDirectories", om.valueToTree(this.getStoredAsSubDirectories()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_glue.CfnTable.StorageDescriptorProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StorageDescriptorProperty.Jsii$Proxy that = (StorageDescriptorProperty.Jsii$Proxy) o;

                if (this.bucketColumns != null ? !this.bucketColumns.equals(that.bucketColumns) : that.bucketColumns != null) return false;
                if (this.columns != null ? !this.columns.equals(that.columns) : that.columns != null) return false;
                if (this.compressed != null ? !this.compressed.equals(that.compressed) : that.compressed != null) return false;
                if (this.inputFormat != null ? !this.inputFormat.equals(that.inputFormat) : that.inputFormat != null) return false;
                if (this.location != null ? !this.location.equals(that.location) : that.location != null) return false;
                if (this.numberOfBuckets != null ? !this.numberOfBuckets.equals(that.numberOfBuckets) : that.numberOfBuckets != null) return false;
                if (this.outputFormat != null ? !this.outputFormat.equals(that.outputFormat) : that.outputFormat != null) return false;
                if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) return false;
                if (this.schemaReference != null ? !this.schemaReference.equals(that.schemaReference) : that.schemaReference != null) return false;
                if (this.serdeInfo != null ? !this.serdeInfo.equals(that.serdeInfo) : that.serdeInfo != null) return false;
                if (this.skewedInfo != null ? !this.skewedInfo.equals(that.skewedInfo) : that.skewedInfo != null) return false;
                if (this.sortColumns != null ? !this.sortColumns.equals(that.sortColumns) : that.sortColumns != null) return false;
                return this.storedAsSubDirectories != null ? this.storedAsSubDirectories.equals(that.storedAsSubDirectories) : that.storedAsSubDirectories == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bucketColumns != null ? this.bucketColumns.hashCode() : 0;
                result = 31 * result + (this.columns != null ? this.columns.hashCode() : 0);
                result = 31 * result + (this.compressed != null ? this.compressed.hashCode() : 0);
                result = 31 * result + (this.inputFormat != null ? this.inputFormat.hashCode() : 0);
                result = 31 * result + (this.location != null ? this.location.hashCode() : 0);
                result = 31 * result + (this.numberOfBuckets != null ? this.numberOfBuckets.hashCode() : 0);
                result = 31 * result + (this.outputFormat != null ? this.outputFormat.hashCode() : 0);
                result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
                result = 31 * result + (this.schemaReference != null ? this.schemaReference.hashCode() : 0);
                result = 31 * result + (this.serdeInfo != null ? this.serdeInfo.hashCode() : 0);
                result = 31 * result + (this.skewedInfo != null ? this.skewedInfo.hashCode() : 0);
                result = 31 * result + (this.sortColumns != null ? this.sortColumns.hashCode() : 0);
                result = 31 * result + (this.storedAsSubDirectories != null ? this.storedAsSubDirectories.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A structure that describes a target table for resource linking.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.glue.*;
     * TableIdentifierProperty tableIdentifierProperty = TableIdentifierProperty.builder()
     *         .catalogId("catalogId")
     *         .databaseName("databaseName")
     *         .name("name")
     *         .region("region")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-tableidentifier.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-tableidentifier.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnTable.TableIdentifierProperty")
    @software.amazon.jsii.Jsii.Proxy(TableIdentifierProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TableIdentifierProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ID of the Data Catalog in which the table resides.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-tableidentifier.html#cfn-glue-table-tableidentifier-catalogid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-tableidentifier.html#cfn-glue-table-tableidentifier-catalogid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCatalogId() {
            return null;
        }

        /**
         * The name of the catalog database that contains the target table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-tableidentifier.html#cfn-glue-table-tableidentifier-databasename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-tableidentifier.html#cfn-glue-table-tableidentifier-databasename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDatabaseName() {
            return null;
        }

        /**
         * The name of the target table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-tableidentifier.html#cfn-glue-table-tableidentifier-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-tableidentifier.html#cfn-glue-table-tableidentifier-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * The Region of the table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-tableidentifier.html#cfn-glue-table-tableidentifier-region">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-tableidentifier.html#cfn-glue-table-tableidentifier-region</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRegion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TableIdentifierProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TableIdentifierProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TableIdentifierProperty> {
            java.lang.String catalogId;
            java.lang.String databaseName;
            java.lang.String name;
            java.lang.String region;

            /**
             * Sets the value of {@link TableIdentifierProperty#getCatalogId}
             * @param catalogId The ID of the Data Catalog in which the table resides.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder catalogId(java.lang.String catalogId) {
                this.catalogId = catalogId;
                return this;
            }

            /**
             * Sets the value of {@link TableIdentifierProperty#getDatabaseName}
             * @param databaseName The name of the catalog database that contains the target table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseName(java.lang.String databaseName) {
                this.databaseName = databaseName;
                return this;
            }

            /**
             * Sets the value of {@link TableIdentifierProperty#getName}
             * @param name The name of the target table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link TableIdentifierProperty#getRegion}
             * @param region The Region of the table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder region(java.lang.String region) {
                this.region = region;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TableIdentifierProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TableIdentifierProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TableIdentifierProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TableIdentifierProperty {
            private final java.lang.String catalogId;
            private final java.lang.String databaseName;
            private final java.lang.String name;
            private final java.lang.String region;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.catalogId = software.amazon.jsii.Kernel.get(this, "catalogId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.databaseName = software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.region = software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.catalogId = builder.catalogId;
                this.databaseName = builder.databaseName;
                this.name = builder.name;
                this.region = builder.region;
            }

            @Override
            public final java.lang.String getCatalogId() {
                return this.catalogId;
            }

            @Override
            public final java.lang.String getDatabaseName() {
                return this.databaseName;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getRegion() {
                return this.region;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCatalogId() != null) {
                    data.set("catalogId", om.valueToTree(this.getCatalogId()));
                }
                if (this.getDatabaseName() != null) {
                    data.set("databaseName", om.valueToTree(this.getDatabaseName()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getRegion() != null) {
                    data.set("region", om.valueToTree(this.getRegion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_glue.CfnTable.TableIdentifierProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TableIdentifierProperty.Jsii$Proxy that = (TableIdentifierProperty.Jsii$Proxy) o;

                if (this.catalogId != null ? !this.catalogId.equals(that.catalogId) : that.catalogId != null) return false;
                if (this.databaseName != null ? !this.databaseName.equals(that.databaseName) : that.databaseName != null) return false;
                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                return this.region != null ? this.region.equals(that.region) : that.region == null;
            }

            @Override
            public final int hashCode() {
                int result = this.catalogId != null ? this.catalogId.hashCode() : 0;
                result = 31 * result + (this.databaseName != null ? this.databaseName.hashCode() : 0);
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A structure used to define a table.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.glue.*;
     * Object parameters;
     * Object skewedColumnValueLocationMaps;
     * TableInputProperty tableInputProperty = TableInputProperty.builder()
     *         .description("description")
     *         .name("name")
     *         .owner("owner")
     *         .parameters(parameters)
     *         .partitionKeys(List.of(ColumnProperty.builder()
     *                 .name("name")
     *                 // the properties below are optional
     *                 .comment("comment")
     *                 .type("type")
     *                 .build()))
     *         .retention(123)
     *         .storageDescriptor(StorageDescriptorProperty.builder()
     *                 .bucketColumns(List.of("bucketColumns"))
     *                 .columns(List.of(ColumnProperty.builder()
     *                         .name("name")
     *                         // the properties below are optional
     *                         .comment("comment")
     *                         .type("type")
     *                         .build()))
     *                 .compressed(false)
     *                 .inputFormat("inputFormat")
     *                 .location("location")
     *                 .numberOfBuckets(123)
     *                 .outputFormat("outputFormat")
     *                 .parameters(parameters)
     *                 .schemaReference(SchemaReferenceProperty.builder()
     *                         .schemaId(SchemaIdProperty.builder()
     *                                 .registryName("registryName")
     *                                 .schemaArn("schemaArn")
     *                                 .schemaName("schemaName")
     *                                 .build())
     *                         .schemaVersionId("schemaVersionId")
     *                         .schemaVersionNumber(123)
     *                         .build())
     *                 .serdeInfo(SerdeInfoProperty.builder()
     *                         .name("name")
     *                         .parameters(parameters)
     *                         .serializationLibrary("serializationLibrary")
     *                         .build())
     *                 .skewedInfo(SkewedInfoProperty.builder()
     *                         .skewedColumnNames(List.of("skewedColumnNames"))
     *                         .skewedColumnValueLocationMaps(skewedColumnValueLocationMaps)
     *                         .skewedColumnValues(List.of("skewedColumnValues"))
     *                         .build())
     *                 .sortColumns(List.of(OrderProperty.builder()
     *                         .column("column")
     *                         .sortOrder(123)
     *                         .build()))
     *                 .storedAsSubDirectories(false)
     *                 .build())
     *         .tableType("tableType")
     *         .targetTable(TableIdentifierProperty.builder()
     *                 .catalogId("catalogId")
     *                 .databaseName("databaseName")
     *                 .name("name")
     *                 .region("region")
     *                 .build())
     *         .viewExpandedText("viewExpandedText")
     *         .viewOriginalText("viewOriginalText")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-tableinput.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-tableinput.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnTable.TableInputProperty")
    @software.amazon.jsii.Jsii.Proxy(TableInputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TableInputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A description of the table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-tableinput.html#cfn-glue-table-tableinput-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-tableinput.html#cfn-glue-table-tableinput-description</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * The table name.
         * <p>
         * For Hive compatibility, this is folded to lowercase when it is stored.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-tableinput.html#cfn-glue-table-tableinput-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-tableinput.html#cfn-glue-table-tableinput-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * The table owner.
         * <p>
         * Included for Apache Hive compatibility. Not used in the normal course of AWS Glue operations.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-tableinput.html#cfn-glue-table-tableinput-owner">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-tableinput.html#cfn-glue-table-tableinput-owner</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOwner() {
            return null;
        }

        /**
         * These key-value pairs define properties associated with the table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-tableinput.html#cfn-glue-table-tableinput-parameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-tableinput.html#cfn-glue-table-tableinput-parameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getParameters() {
            return null;
        }

        /**
         * A list of columns by which the table is partitioned. Only primitive types are supported as partition keys.
         * <p>
         * When you create a table used by Amazon Athena, and you do not specify any <code>partitionKeys</code> , you must at least set the value of <code>partitionKeys</code> to an empty list. For example:
         * <p>
         * <code>"PartitionKeys": []</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-tableinput.html#cfn-glue-table-tableinput-partitionkeys">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-tableinput.html#cfn-glue-table-tableinput-partitionkeys</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPartitionKeys() {
            return null;
        }

        /**
         * The retention time for this table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-tableinput.html#cfn-glue-table-tableinput-retention">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-tableinput.html#cfn-glue-table-tableinput-retention</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getRetention() {
            return null;
        }

        /**
         * A storage descriptor containing information about the physical storage of this table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-tableinput.html#cfn-glue-table-tableinput-storagedescriptor">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-tableinput.html#cfn-glue-table-tableinput-storagedescriptor</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStorageDescriptor() {
            return null;
        }

        /**
         * The type of this table.
         * <p>
         * AWS Glue will create tables with the <code>EXTERNAL_TABLE</code> type. Other services, such as Athena, may create tables with additional table types.
         * <p>
         * AWS Glue related table types:
         * <p>
         * <ul>
         * <li><strong>EXTERNAL_TABLE</strong> - Hive compatible attribute - indicates a non-Hive managed table.</li>
         * <li><strong>GOVERNED</strong> - Used by AWS Lake Formation . The AWS Glue Data Catalog understands <code>GOVERNED</code> .</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-tableinput.html#cfn-glue-table-tableinput-tabletype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-tableinput.html#cfn-glue-table-tableinput-tabletype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTableType() {
            return null;
        }

        /**
         * A <code>TableIdentifier</code> structure that describes a target table for resource linking.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-tableinput.html#cfn-glue-table-tableinput-targettable">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-tableinput.html#cfn-glue-table-tableinput-targettable</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTargetTable() {
            return null;
        }

        /**
         * Included for Apache Hive compatibility.
         * <p>
         * Not used in the normal course of AWS Glue operations.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-tableinput.html#cfn-glue-table-tableinput-viewexpandedtext">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-tableinput.html#cfn-glue-table-tableinput-viewexpandedtext</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getViewExpandedText() {
            return null;
        }

        /**
         * Included for Apache Hive compatibility.
         * <p>
         * Not used in the normal course of AWS Glue operations. If the table is a <code>VIRTUAL_VIEW</code> , certain Athena configuration encoded in base64.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-tableinput.html#cfn-glue-table-tableinput-vieworiginaltext">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-tableinput.html#cfn-glue-table-tableinput-vieworiginaltext</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getViewOriginalText() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TableInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TableInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TableInputProperty> {
            java.lang.String description;
            java.lang.String name;
            java.lang.String owner;
            java.lang.Object parameters;
            java.lang.Object partitionKeys;
            java.lang.Number retention;
            java.lang.Object storageDescriptor;
            java.lang.String tableType;
            java.lang.Object targetTable;
            java.lang.String viewExpandedText;
            java.lang.String viewOriginalText;

            /**
             * Sets the value of {@link TableInputProperty#getDescription}
             * @param description A description of the table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link TableInputProperty#getName}
             * @param name The table name.
             *             For Hive compatibility, this is folded to lowercase when it is stored.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link TableInputProperty#getOwner}
             * @param owner The table owner.
             *              Included for Apache Hive compatibility. Not used in the normal course of AWS Glue operations.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder owner(java.lang.String owner) {
                this.owner = owner;
                return this;
            }

            /**
             * Sets the value of {@link TableInputProperty#getParameters}
             * @param parameters These key-value pairs define properties associated with the table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parameters(java.lang.Object parameters) {
                this.parameters = parameters;
                return this;
            }

            /**
             * Sets the value of {@link TableInputProperty#getPartitionKeys}
             * @param partitionKeys A list of columns by which the table is partitioned. Only primitive types are supported as partition keys.
             *                      When you create a table used by Amazon Athena, and you do not specify any <code>partitionKeys</code> , you must at least set the value of <code>partitionKeys</code> to an empty list. For example:
             *                      <p>
             *                      <code>"PartitionKeys": []</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder partitionKeys(software.amazon.awscdk.IResolvable partitionKeys) {
                this.partitionKeys = partitionKeys;
                return this;
            }

            /**
             * Sets the value of {@link TableInputProperty#getPartitionKeys}
             * @param partitionKeys A list of columns by which the table is partitioned. Only primitive types are supported as partition keys.
             *                      When you create a table used by Amazon Athena, and you do not specify any <code>partitionKeys</code> , you must at least set the value of <code>partitionKeys</code> to an empty list. For example:
             *                      <p>
             *                      <code>"PartitionKeys": []</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder partitionKeys(java.util.List<? extends java.lang.Object> partitionKeys) {
                this.partitionKeys = partitionKeys;
                return this;
            }

            /**
             * Sets the value of {@link TableInputProperty#getRetention}
             * @param retention The retention time for this table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retention(java.lang.Number retention) {
                this.retention = retention;
                return this;
            }

            /**
             * Sets the value of {@link TableInputProperty#getStorageDescriptor}
             * @param storageDescriptor A storage descriptor containing information about the physical storage of this table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder storageDescriptor(software.amazon.awscdk.IResolvable storageDescriptor) {
                this.storageDescriptor = storageDescriptor;
                return this;
            }

            /**
             * Sets the value of {@link TableInputProperty#getStorageDescriptor}
             * @param storageDescriptor A storage descriptor containing information about the physical storage of this table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder storageDescriptor(software.amazon.awscdk.services.glue.CfnTable.StorageDescriptorProperty storageDescriptor) {
                this.storageDescriptor = storageDescriptor;
                return this;
            }

            /**
             * Sets the value of {@link TableInputProperty#getTableType}
             * @param tableType The type of this table.
             *                  AWS Glue will create tables with the <code>EXTERNAL_TABLE</code> type. Other services, such as Athena, may create tables with additional table types.
             *                  <p>
             *                  AWS Glue related table types:
             *                  <p>
             *                  <ul>
             *                  <li><strong>EXTERNAL_TABLE</strong> - Hive compatible attribute - indicates a non-Hive managed table.</li>
             *                  <li><strong>GOVERNED</strong> - Used by AWS Lake Formation . The AWS Glue Data Catalog understands <code>GOVERNED</code> .</li>
             *                  </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tableType(java.lang.String tableType) {
                this.tableType = tableType;
                return this;
            }

            /**
             * Sets the value of {@link TableInputProperty#getTargetTable}
             * @param targetTable A <code>TableIdentifier</code> structure that describes a target table for resource linking.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetTable(software.amazon.awscdk.IResolvable targetTable) {
                this.targetTable = targetTable;
                return this;
            }

            /**
             * Sets the value of {@link TableInputProperty#getTargetTable}
             * @param targetTable A <code>TableIdentifier</code> structure that describes a target table for resource linking.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetTable(software.amazon.awscdk.services.glue.CfnTable.TableIdentifierProperty targetTable) {
                this.targetTable = targetTable;
                return this;
            }

            /**
             * Sets the value of {@link TableInputProperty#getViewExpandedText}
             * @param viewExpandedText Included for Apache Hive compatibility.
             *                         Not used in the normal course of AWS Glue operations.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder viewExpandedText(java.lang.String viewExpandedText) {
                this.viewExpandedText = viewExpandedText;
                return this;
            }

            /**
             * Sets the value of {@link TableInputProperty#getViewOriginalText}
             * @param viewOriginalText Included for Apache Hive compatibility.
             *                         Not used in the normal course of AWS Glue operations. If the table is a <code>VIRTUAL_VIEW</code> , certain Athena configuration encoded in base64.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder viewOriginalText(java.lang.String viewOriginalText) {
                this.viewOriginalText = viewOriginalText;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TableInputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TableInputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TableInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TableInputProperty {
            private final java.lang.String description;
            private final java.lang.String name;
            private final java.lang.String owner;
            private final java.lang.Object parameters;
            private final java.lang.Object partitionKeys;
            private final java.lang.Number retention;
            private final java.lang.Object storageDescriptor;
            private final java.lang.String tableType;
            private final java.lang.Object targetTable;
            private final java.lang.String viewExpandedText;
            private final java.lang.String viewOriginalText;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.owner = software.amazon.jsii.Kernel.get(this, "owner", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.parameters = software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.partitionKeys = software.amazon.jsii.Kernel.get(this, "partitionKeys", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.retention = software.amazon.jsii.Kernel.get(this, "retention", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.storageDescriptor = software.amazon.jsii.Kernel.get(this, "storageDescriptor", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.tableType = software.amazon.jsii.Kernel.get(this, "tableType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.targetTable = software.amazon.jsii.Kernel.get(this, "targetTable", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.viewExpandedText = software.amazon.jsii.Kernel.get(this, "viewExpandedText", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.viewOriginalText = software.amazon.jsii.Kernel.get(this, "viewOriginalText", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.description = builder.description;
                this.name = builder.name;
                this.owner = builder.owner;
                this.parameters = builder.parameters;
                this.partitionKeys = builder.partitionKeys;
                this.retention = builder.retention;
                this.storageDescriptor = builder.storageDescriptor;
                this.tableType = builder.tableType;
                this.targetTable = builder.targetTable;
                this.viewExpandedText = builder.viewExpandedText;
                this.viewOriginalText = builder.viewOriginalText;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getOwner() {
                return this.owner;
            }

            @Override
            public final java.lang.Object getParameters() {
                return this.parameters;
            }

            @Override
            public final java.lang.Object getPartitionKeys() {
                return this.partitionKeys;
            }

            @Override
            public final java.lang.Number getRetention() {
                return this.retention;
            }

            @Override
            public final java.lang.Object getStorageDescriptor() {
                return this.storageDescriptor;
            }

            @Override
            public final java.lang.String getTableType() {
                return this.tableType;
            }

            @Override
            public final java.lang.Object getTargetTable() {
                return this.targetTable;
            }

            @Override
            public final java.lang.String getViewExpandedText() {
                return this.viewExpandedText;
            }

            @Override
            public final java.lang.String getViewOriginalText() {
                return this.viewOriginalText;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getOwner() != null) {
                    data.set("owner", om.valueToTree(this.getOwner()));
                }
                if (this.getParameters() != null) {
                    data.set("parameters", om.valueToTree(this.getParameters()));
                }
                if (this.getPartitionKeys() != null) {
                    data.set("partitionKeys", om.valueToTree(this.getPartitionKeys()));
                }
                if (this.getRetention() != null) {
                    data.set("retention", om.valueToTree(this.getRetention()));
                }
                if (this.getStorageDescriptor() != null) {
                    data.set("storageDescriptor", om.valueToTree(this.getStorageDescriptor()));
                }
                if (this.getTableType() != null) {
                    data.set("tableType", om.valueToTree(this.getTableType()));
                }
                if (this.getTargetTable() != null) {
                    data.set("targetTable", om.valueToTree(this.getTargetTable()));
                }
                if (this.getViewExpandedText() != null) {
                    data.set("viewExpandedText", om.valueToTree(this.getViewExpandedText()));
                }
                if (this.getViewOriginalText() != null) {
                    data.set("viewOriginalText", om.valueToTree(this.getViewOriginalText()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_glue.CfnTable.TableInputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TableInputProperty.Jsii$Proxy that = (TableInputProperty.Jsii$Proxy) o;

                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                if (this.owner != null ? !this.owner.equals(that.owner) : that.owner != null) return false;
                if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) return false;
                if (this.partitionKeys != null ? !this.partitionKeys.equals(that.partitionKeys) : that.partitionKeys != null) return false;
                if (this.retention != null ? !this.retention.equals(that.retention) : that.retention != null) return false;
                if (this.storageDescriptor != null ? !this.storageDescriptor.equals(that.storageDescriptor) : that.storageDescriptor != null) return false;
                if (this.tableType != null ? !this.tableType.equals(that.tableType) : that.tableType != null) return false;
                if (this.targetTable != null ? !this.targetTable.equals(that.targetTable) : that.targetTable != null) return false;
                if (this.viewExpandedText != null ? !this.viewExpandedText.equals(that.viewExpandedText) : that.viewExpandedText != null) return false;
                return this.viewOriginalText != null ? this.viewOriginalText.equals(that.viewOriginalText) : that.viewOriginalText == null;
            }

            @Override
            public final int hashCode() {
                int result = this.description != null ? this.description.hashCode() : 0;
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                result = 31 * result + (this.owner != null ? this.owner.hashCode() : 0);
                result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
                result = 31 * result + (this.partitionKeys != null ? this.partitionKeys.hashCode() : 0);
                result = 31 * result + (this.retention != null ? this.retention.hashCode() : 0);
                result = 31 * result + (this.storageDescriptor != null ? this.storageDescriptor.hashCode() : 0);
                result = 31 * result + (this.tableType != null ? this.tableType.hashCode() : 0);
                result = 31 * result + (this.targetTable != null ? this.targetTable.hashCode() : 0);
                result = 31 * result + (this.viewExpandedText != null ? this.viewExpandedText.hashCode() : 0);
                result = 31 * result + (this.viewOriginalText != null ? this.viewOriginalText.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.glue.CfnTable}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.glue.CfnTable> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.glue.CfnTableProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.glue.CfnTableProps.Builder();
        }

        /**
         * The ID of the Data Catalog in which to create the <code>Table</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-table.html#cfn-glue-table-catalogid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-table.html#cfn-glue-table-catalogid</a>
         * @param catalogId The ID of the Data Catalog in which to create the <code>Table</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder catalogId(final java.lang.String catalogId) {
            this.props.catalogId(catalogId);
            return this;
        }

        /**
         * The name of the database where the table metadata resides.
         * <p>
         * For Hive compatibility, this must be all lowercase.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-table.html#cfn-glue-table-databasename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-table.html#cfn-glue-table-databasename</a>
         * @param databaseName The name of the database where the table metadata resides. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder databaseName(final java.lang.String databaseName) {
            this.props.databaseName(databaseName);
            return this;
        }

        /**
         * A structure used to define a table.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-table.html#cfn-glue-table-tableinput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-table.html#cfn-glue-table-tableinput</a>
         * @param tableInput A structure used to define a table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tableInput(final software.amazon.awscdk.IResolvable tableInput) {
            this.props.tableInput(tableInput);
            return this;
        }
        /**
         * A structure used to define a table.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-table.html#cfn-glue-table-tableinput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-table.html#cfn-glue-table-tableinput</a>
         * @param tableInput A structure used to define a table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tableInput(final software.amazon.awscdk.services.glue.CfnTable.TableInputProperty tableInput) {
            this.props.tableInput(tableInput);
            return this;
        }

        /**
         * Specifies an <code>OpenTableFormatInput</code> structure when creating an open format table.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-table.html#cfn-glue-table-opentableformatinput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-table.html#cfn-glue-table-opentableformatinput</a>
         * @param openTableFormatInput Specifies an <code>OpenTableFormatInput</code> structure when creating an open format table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder openTableFormatInput(final software.amazon.awscdk.IResolvable openTableFormatInput) {
            this.props.openTableFormatInput(openTableFormatInput);
            return this;
        }
        /**
         * Specifies an <code>OpenTableFormatInput</code> structure when creating an open format table.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-table.html#cfn-glue-table-opentableformatinput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-glue-table.html#cfn-glue-table-opentableformatinput</a>
         * @param openTableFormatInput Specifies an <code>OpenTableFormatInput</code> structure when creating an open format table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder openTableFormatInput(final software.amazon.awscdk.services.glue.CfnTable.OpenTableFormatInputProperty openTableFormatInput) {
            this.props.openTableFormatInput(openTableFormatInput);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.glue.CfnTable}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.glue.CfnTable build() {
            return new software.amazon.awscdk.services.glue.CfnTable(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
