package software.amazon.awscdk.services.fsx;

/**
 * Properties for defining a <code>CfnStorageVirtualMachine</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.fsx.*;
 * CfnStorageVirtualMachineProps cfnStorageVirtualMachineProps = CfnStorageVirtualMachineProps.builder()
 *         .fileSystemId("fileSystemId")
 *         .name("name")
 *         // the properties below are optional
 *         .activeDirectoryConfiguration(ActiveDirectoryConfigurationProperty.builder()
 *                 .netBiosName("netBiosName")
 *                 .selfManagedActiveDirectoryConfiguration(SelfManagedActiveDirectoryConfigurationProperty.builder()
 *                         .dnsIps(List.of("dnsIps"))
 *                         .domainName("domainName")
 *                         .fileSystemAdministratorsGroup("fileSystemAdministratorsGroup")
 *                         .organizationalUnitDistinguishedName("organizationalUnitDistinguishedName")
 *                         .password("password")
 *                         .userName("userName")
 *                         .build())
 *                 .build())
 *         .rootVolumeSecurityStyle("rootVolumeSecurityStyle")
 *         .svmAdminPassword("svmAdminPassword")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-storagevirtualmachine.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-storagevirtualmachine.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:13.884Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fsx.CfnStorageVirtualMachineProps")
@software.amazon.jsii.Jsii.Proxy(CfnStorageVirtualMachineProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnStorageVirtualMachineProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Specifies the FSx for ONTAP file system on which to create the SVM.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-storagevirtualmachine.html#cfn-fsx-storagevirtualmachine-filesystemid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-storagevirtualmachine.html#cfn-fsx-storagevirtualmachine-filesystemid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFileSystemId();

    /**
     * The name of the SVM.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-storagevirtualmachine.html#cfn-fsx-storagevirtualmachine-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-storagevirtualmachine.html#cfn-fsx-storagevirtualmachine-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * Describes the Microsoft Active Directory configuration to which the SVM is joined, if applicable.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-storagevirtualmachine.html#cfn-fsx-storagevirtualmachine-activedirectoryconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-storagevirtualmachine.html#cfn-fsx-storagevirtualmachine-activedirectoryconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getActiveDirectoryConfiguration() {
        return null;
    }

    /**
     * The security style of the root volume of the SVM. Specify one of the following values:.
     * <p>
     * <ul>
     * <li><code>UNIX</code> if the file system is managed by a UNIX administrator, the majority of users are NFS clients, and an application accessing the data uses a UNIX user as the service account.</li>
     * <li><code>NTFS</code> if the file system is managed by a Microsoft Windows administrator, the majority of users are SMB clients, and an application accessing the data uses a Microsoft Windows user as the service account.</li>
     * <li><code>MIXED</code> This is an advanced setting. For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/volume-security-style.html">Volume security style</a> in the Amazon FSx for NetApp ONTAP User Guide.</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-storagevirtualmachine.html#cfn-fsx-storagevirtualmachine-rootvolumesecuritystyle">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-storagevirtualmachine.html#cfn-fsx-storagevirtualmachine-rootvolumesecuritystyle</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRootVolumeSecurityStyle() {
        return null;
    }

    /**
     * Specifies the password to use when logging on to the SVM using a secure shell (SSH) connection to the SVM's management endpoint.
     * <p>
     * Doing so enables you to manage the SVM using the NetApp ONTAP CLI or REST API. If you do not specify a password, you can still use the file system's <code>fsxadmin</code> user to manage the SVM. For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-resources-ontap-apps.html#vsadmin-ontap-cli">Managing SVMs using the NetApp ONTAP CLI</a> in the <em>FSx for ONTAP User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-storagevirtualmachine.html#cfn-fsx-storagevirtualmachine-svmadminpassword">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-storagevirtualmachine.html#cfn-fsx-storagevirtualmachine-svmadminpassword</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSvmAdminPassword() {
        return null;
    }

    /**
     * A list of <code>Tag</code> values, with a maximum of 50 elements.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-storagevirtualmachine.html#cfn-fsx-storagevirtualmachine-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-storagevirtualmachine.html#cfn-fsx-storagevirtualmachine-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnStorageVirtualMachineProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnStorageVirtualMachineProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnStorageVirtualMachineProps> {
        java.lang.String fileSystemId;
        java.lang.String name;
        java.lang.Object activeDirectoryConfiguration;
        java.lang.String rootVolumeSecurityStyle;
        java.lang.String svmAdminPassword;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnStorageVirtualMachineProps#getFileSystemId}
         * @param fileSystemId Specifies the FSx for ONTAP file system on which to create the SVM. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fileSystemId(java.lang.String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        /**
         * Sets the value of {@link CfnStorageVirtualMachineProps#getName}
         * @param name The name of the SVM. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnStorageVirtualMachineProps#getActiveDirectoryConfiguration}
         * @param activeDirectoryConfiguration Describes the Microsoft Active Directory configuration to which the SVM is joined, if applicable.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder activeDirectoryConfiguration(software.amazon.awscdk.IResolvable activeDirectoryConfiguration) {
            this.activeDirectoryConfiguration = activeDirectoryConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnStorageVirtualMachineProps#getActiveDirectoryConfiguration}
         * @param activeDirectoryConfiguration Describes the Microsoft Active Directory configuration to which the SVM is joined, if applicable.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder activeDirectoryConfiguration(software.amazon.awscdk.services.fsx.CfnStorageVirtualMachine.ActiveDirectoryConfigurationProperty activeDirectoryConfiguration) {
            this.activeDirectoryConfiguration = activeDirectoryConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnStorageVirtualMachineProps#getRootVolumeSecurityStyle}
         * @param rootVolumeSecurityStyle The security style of the root volume of the SVM. Specify one of the following values:.
         *                                <ul>
         *                                <li><code>UNIX</code> if the file system is managed by a UNIX administrator, the majority of users are NFS clients, and an application accessing the data uses a UNIX user as the service account.</li>
         *                                <li><code>NTFS</code> if the file system is managed by a Microsoft Windows administrator, the majority of users are SMB clients, and an application accessing the data uses a Microsoft Windows user as the service account.</li>
         *                                <li><code>MIXED</code> This is an advanced setting. For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/volume-security-style.html">Volume security style</a> in the Amazon FSx for NetApp ONTAP User Guide.</li>
         *                                </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rootVolumeSecurityStyle(java.lang.String rootVolumeSecurityStyle) {
            this.rootVolumeSecurityStyle = rootVolumeSecurityStyle;
            return this;
        }

        /**
         * Sets the value of {@link CfnStorageVirtualMachineProps#getSvmAdminPassword}
         * @param svmAdminPassword Specifies the password to use when logging on to the SVM using a secure shell (SSH) connection to the SVM's management endpoint.
         *                         Doing so enables you to manage the SVM using the NetApp ONTAP CLI or REST API. If you do not specify a password, you can still use the file system's <code>fsxadmin</code> user to manage the SVM. For more information, see <a href="https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-resources-ontap-apps.html#vsadmin-ontap-cli">Managing SVMs using the NetApp ONTAP CLI</a> in the <em>FSx for ONTAP User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder svmAdminPassword(java.lang.String svmAdminPassword) {
            this.svmAdminPassword = svmAdminPassword;
            return this;
        }

        /**
         * Sets the value of {@link CfnStorageVirtualMachineProps#getTags}
         * @param tags A list of <code>Tag</code> values, with a maximum of 50 elements.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnStorageVirtualMachineProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnStorageVirtualMachineProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnStorageVirtualMachineProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnStorageVirtualMachineProps {
        private final java.lang.String fileSystemId;
        private final java.lang.String name;
        private final java.lang.Object activeDirectoryConfiguration;
        private final java.lang.String rootVolumeSecurityStyle;
        private final java.lang.String svmAdminPassword;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.fileSystemId = software.amazon.jsii.Kernel.get(this, "fileSystemId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.activeDirectoryConfiguration = software.amazon.jsii.Kernel.get(this, "activeDirectoryConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.rootVolumeSecurityStyle = software.amazon.jsii.Kernel.get(this, "rootVolumeSecurityStyle", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.svmAdminPassword = software.amazon.jsii.Kernel.get(this, "svmAdminPassword", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.fileSystemId = java.util.Objects.requireNonNull(builder.fileSystemId, "fileSystemId is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.activeDirectoryConfiguration = builder.activeDirectoryConfiguration;
            this.rootVolumeSecurityStyle = builder.rootVolumeSecurityStyle;
            this.svmAdminPassword = builder.svmAdminPassword;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getFileSystemId() {
            return this.fileSystemId;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getActiveDirectoryConfiguration() {
            return this.activeDirectoryConfiguration;
        }

        @Override
        public final java.lang.String getRootVolumeSecurityStyle() {
            return this.rootVolumeSecurityStyle;
        }

        @Override
        public final java.lang.String getSvmAdminPassword() {
            return this.svmAdminPassword;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("fileSystemId", om.valueToTree(this.getFileSystemId()));
            data.set("name", om.valueToTree(this.getName()));
            if (this.getActiveDirectoryConfiguration() != null) {
                data.set("activeDirectoryConfiguration", om.valueToTree(this.getActiveDirectoryConfiguration()));
            }
            if (this.getRootVolumeSecurityStyle() != null) {
                data.set("rootVolumeSecurityStyle", om.valueToTree(this.getRootVolumeSecurityStyle()));
            }
            if (this.getSvmAdminPassword() != null) {
                data.set("svmAdminPassword", om.valueToTree(this.getSvmAdminPassword()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fsx.CfnStorageVirtualMachineProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnStorageVirtualMachineProps.Jsii$Proxy that = (CfnStorageVirtualMachineProps.Jsii$Proxy) o;

            if (!fileSystemId.equals(that.fileSystemId)) return false;
            if (!name.equals(that.name)) return false;
            if (this.activeDirectoryConfiguration != null ? !this.activeDirectoryConfiguration.equals(that.activeDirectoryConfiguration) : that.activeDirectoryConfiguration != null) return false;
            if (this.rootVolumeSecurityStyle != null ? !this.rootVolumeSecurityStyle.equals(that.rootVolumeSecurityStyle) : that.rootVolumeSecurityStyle != null) return false;
            if (this.svmAdminPassword != null ? !this.svmAdminPassword.equals(that.svmAdminPassword) : that.svmAdminPassword != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.fileSystemId.hashCode();
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.activeDirectoryConfiguration != null ? this.activeDirectoryConfiguration.hashCode() : 0);
            result = 31 * result + (this.rootVolumeSecurityStyle != null ? this.rootVolumeSecurityStyle.hashCode() : 0);
            result = 31 * result + (this.svmAdminPassword != null ? this.svmAdminPassword.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
