package software.amazon.awscdk.services.evidently;

/**
 * Properties for defining a <code>CfnLaunch</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.evidently.*;
 * CfnLaunchProps cfnLaunchProps = CfnLaunchProps.builder()
 *         .groups(List.of(LaunchGroupObjectProperty.builder()
 *                 .feature("feature")
 *                 .groupName("groupName")
 *                 .variation("variation")
 *                 // the properties below are optional
 *                 .description("description")
 *                 .build()))
 *         .name("name")
 *         .project("project")
 *         .scheduledSplitsConfig(List.of(StepConfigProperty.builder()
 *                 .groupWeights(List.of(GroupToWeightProperty.builder()
 *                         .groupName("groupName")
 *                         .splitWeight(123)
 *                         .build()))
 *                 .startTime("startTime")
 *                 // the properties below are optional
 *                 .segmentOverrides(List.of(SegmentOverrideProperty.builder()
 *                         .evaluationOrder(123)
 *                         .segment("segment")
 *                         .weights(List.of(GroupToWeightProperty.builder()
 *                                 .groupName("groupName")
 *                                 .splitWeight(123)
 *                                 .build()))
 *                         .build()))
 *                 .build()))
 *         // the properties below are optional
 *         .description("description")
 *         .executionStatus(ExecutionStatusObjectProperty.builder()
 *                 .status("status")
 *                 // the properties below are optional
 *                 .desiredState("desiredState")
 *                 .reason("reason")
 *                 .build())
 *         .metricMonitors(List.of(MetricDefinitionObjectProperty.builder()
 *                 .entityIdKey("entityIdKey")
 *                 .metricName("metricName")
 *                 .valueKey("valueKey")
 *                 // the properties below are optional
 *                 .eventPattern("eventPattern")
 *                 .unitLabel("unitLabel")
 *                 .build()))
 *         .randomizationSalt("randomizationSalt")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-launch.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-launch.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:13.721Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_evidently.CfnLaunchProps")
@software.amazon.jsii.Jsii.Proxy(CfnLaunchProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnLaunchProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * An array of structures that contains the feature and variations that are to be used for the launch.
     * <p>
     * You can up to five launch groups in a launch.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-launch.html#cfn-evidently-launch-groups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-launch.html#cfn-evidently-launch-groups</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getGroups();

    /**
     * The name for the launch.
     * <p>
     * It can include up to 127 characters.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-launch.html#cfn-evidently-launch-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-launch.html#cfn-evidently-launch-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The name or ARN of the project that you want to create the launch in.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-launch.html#cfn-evidently-launch-project">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-launch.html#cfn-evidently-launch-project</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getProject();

    /**
     * An array of structures that define the traffic allocation percentages among the feature variations during each step of the launch.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-launch.html#cfn-evidently-launch-scheduledsplitsconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-launch.html#cfn-evidently-launch-scheduledsplitsconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getScheduledSplitsConfig();

    /**
     * An optional description for the launch.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-launch.html#cfn-evidently-launch-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-launch.html#cfn-evidently-launch-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * A structure that you can use to start and stop the launch.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-launch.html#cfn-evidently-launch-executionstatus">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-launch.html#cfn-evidently-launch-executionstatus</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getExecutionStatus() {
        return null;
    }

    /**
     * An array of structures that define the metrics that will be used to monitor the launch performance.
     * <p>
     * You can have up to three metric monitors in the array.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-launch.html#cfn-evidently-launch-metricmonitors">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-launch.html#cfn-evidently-launch-metricmonitors</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMetricMonitors() {
        return null;
    }

    /**
     * When Evidently assigns a particular user session to a launch, it must use a randomization ID to determine which variation the user session is served.
     * <p>
     * This randomization ID is a combination of the entity ID and <code>randomizationSalt</code> . If you omit <code>randomizationSalt</code> , Evidently uses the launch name as the <code>randomizationsSalt</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-launch.html#cfn-evidently-launch-randomizationsalt">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-launch.html#cfn-evidently-launch-randomizationsalt</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRandomizationSalt() {
        return null;
    }

    /**
     * Assigns one or more tags (key-value pairs) to the launch.
     * <p>
     * Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.
     * <p>
     * Tags don't have any semantic meaning to AWS and are interpreted strictly as strings of characters.
     * <p>
     * You can associate as many as 50 tags with a launch.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS resources</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-launch.html#cfn-evidently-launch-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-evidently-launch.html#cfn-evidently-launch-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnLaunchProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnLaunchProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnLaunchProps> {
        java.lang.Object groups;
        java.lang.String name;
        java.lang.String project;
        java.lang.Object scheduledSplitsConfig;
        java.lang.String description;
        java.lang.Object executionStatus;
        java.lang.Object metricMonitors;
        java.lang.String randomizationSalt;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnLaunchProps#getGroups}
         * @param groups An array of structures that contains the feature and variations that are to be used for the launch. This parameter is required.
         *               You can up to five launch groups in a launch.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder groups(software.amazon.awscdk.IResolvable groups) {
            this.groups = groups;
            return this;
        }

        /**
         * Sets the value of {@link CfnLaunchProps#getGroups}
         * @param groups An array of structures that contains the feature and variations that are to be used for the launch. This parameter is required.
         *               You can up to five launch groups in a launch.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder groups(java.util.List<? extends java.lang.Object> groups) {
            this.groups = groups;
            return this;
        }

        /**
         * Sets the value of {@link CfnLaunchProps#getName}
         * @param name The name for the launch. This parameter is required.
         *             It can include up to 127 characters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnLaunchProps#getProject}
         * @param project The name or ARN of the project that you want to create the launch in. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder project(java.lang.String project) {
            this.project = project;
            return this;
        }

        /**
         * Sets the value of {@link CfnLaunchProps#getScheduledSplitsConfig}
         * @param scheduledSplitsConfig An array of structures that define the traffic allocation percentages among the feature variations during each step of the launch. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scheduledSplitsConfig(software.amazon.awscdk.IResolvable scheduledSplitsConfig) {
            this.scheduledSplitsConfig = scheduledSplitsConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnLaunchProps#getScheduledSplitsConfig}
         * @param scheduledSplitsConfig An array of structures that define the traffic allocation percentages among the feature variations during each step of the launch. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scheduledSplitsConfig(java.util.List<? extends java.lang.Object> scheduledSplitsConfig) {
            this.scheduledSplitsConfig = scheduledSplitsConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnLaunchProps#getDescription}
         * @param description An optional description for the launch.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnLaunchProps#getExecutionStatus}
         * @param executionStatus A structure that you can use to start and stop the launch.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executionStatus(software.amazon.awscdk.IResolvable executionStatus) {
            this.executionStatus = executionStatus;
            return this;
        }

        /**
         * Sets the value of {@link CfnLaunchProps#getExecutionStatus}
         * @param executionStatus A structure that you can use to start and stop the launch.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executionStatus(software.amazon.awscdk.services.evidently.CfnLaunch.ExecutionStatusObjectProperty executionStatus) {
            this.executionStatus = executionStatus;
            return this;
        }

        /**
         * Sets the value of {@link CfnLaunchProps#getMetricMonitors}
         * @param metricMonitors An array of structures that define the metrics that will be used to monitor the launch performance.
         *                       You can have up to three metric monitors in the array.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricMonitors(software.amazon.awscdk.IResolvable metricMonitors) {
            this.metricMonitors = metricMonitors;
            return this;
        }

        /**
         * Sets the value of {@link CfnLaunchProps#getMetricMonitors}
         * @param metricMonitors An array of structures that define the metrics that will be used to monitor the launch performance.
         *                       You can have up to three metric monitors in the array.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricMonitors(java.util.List<? extends java.lang.Object> metricMonitors) {
            this.metricMonitors = metricMonitors;
            return this;
        }

        /**
         * Sets the value of {@link CfnLaunchProps#getRandomizationSalt}
         * @param randomizationSalt When Evidently assigns a particular user session to a launch, it must use a randomization ID to determine which variation the user session is served.
         *                          This randomization ID is a combination of the entity ID and <code>randomizationSalt</code> . If you omit <code>randomizationSalt</code> , Evidently uses the launch name as the <code>randomizationsSalt</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder randomizationSalt(java.lang.String randomizationSalt) {
            this.randomizationSalt = randomizationSalt;
            return this;
        }

        /**
         * Sets the value of {@link CfnLaunchProps#getTags}
         * @param tags Assigns one or more tags (key-value pairs) to the launch.
         *             Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.
         *             <p>
         *             Tags don't have any semantic meaning to AWS and are interpreted strictly as strings of characters.
         *             <p>
         *             You can associate as many as 50 tags with a launch.
         *             <p>
         *             For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS resources</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnLaunchProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnLaunchProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnLaunchProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnLaunchProps {
        private final java.lang.Object groups;
        private final java.lang.String name;
        private final java.lang.String project;
        private final java.lang.Object scheduledSplitsConfig;
        private final java.lang.String description;
        private final java.lang.Object executionStatus;
        private final java.lang.Object metricMonitors;
        private final java.lang.String randomizationSalt;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.groups = software.amazon.jsii.Kernel.get(this, "groups", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.project = software.amazon.jsii.Kernel.get(this, "project", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.scheduledSplitsConfig = software.amazon.jsii.Kernel.get(this, "scheduledSplitsConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.executionStatus = software.amazon.jsii.Kernel.get(this, "executionStatus", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.metricMonitors = software.amazon.jsii.Kernel.get(this, "metricMonitors", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.randomizationSalt = software.amazon.jsii.Kernel.get(this, "randomizationSalt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.groups = java.util.Objects.requireNonNull(builder.groups, "groups is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.project = java.util.Objects.requireNonNull(builder.project, "project is required");
            this.scheduledSplitsConfig = java.util.Objects.requireNonNull(builder.scheduledSplitsConfig, "scheduledSplitsConfig is required");
            this.description = builder.description;
            this.executionStatus = builder.executionStatus;
            this.metricMonitors = builder.metricMonitors;
            this.randomizationSalt = builder.randomizationSalt;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getGroups() {
            return this.groups;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getProject() {
            return this.project;
        }

        @Override
        public final java.lang.Object getScheduledSplitsConfig() {
            return this.scheduledSplitsConfig;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Object getExecutionStatus() {
            return this.executionStatus;
        }

        @Override
        public final java.lang.Object getMetricMonitors() {
            return this.metricMonitors;
        }

        @Override
        public final java.lang.String getRandomizationSalt() {
            return this.randomizationSalt;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("groups", om.valueToTree(this.getGroups()));
            data.set("name", om.valueToTree(this.getName()));
            data.set("project", om.valueToTree(this.getProject()));
            data.set("scheduledSplitsConfig", om.valueToTree(this.getScheduledSplitsConfig()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getExecutionStatus() != null) {
                data.set("executionStatus", om.valueToTree(this.getExecutionStatus()));
            }
            if (this.getMetricMonitors() != null) {
                data.set("metricMonitors", om.valueToTree(this.getMetricMonitors()));
            }
            if (this.getRandomizationSalt() != null) {
                data.set("randomizationSalt", om.valueToTree(this.getRandomizationSalt()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_evidently.CfnLaunchProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnLaunchProps.Jsii$Proxy that = (CfnLaunchProps.Jsii$Proxy) o;

            if (!groups.equals(that.groups)) return false;
            if (!name.equals(that.name)) return false;
            if (!project.equals(that.project)) return false;
            if (!scheduledSplitsConfig.equals(that.scheduledSplitsConfig)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.executionStatus != null ? !this.executionStatus.equals(that.executionStatus) : that.executionStatus != null) return false;
            if (this.metricMonitors != null ? !this.metricMonitors.equals(that.metricMonitors) : that.metricMonitors != null) return false;
            if (this.randomizationSalt != null ? !this.randomizationSalt.equals(that.randomizationSalt) : that.randomizationSalt != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.groups.hashCode();
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.project.hashCode());
            result = 31 * result + (this.scheduledSplitsConfig.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.executionStatus != null ? this.executionStatus.hashCode() : 0);
            result = 31 * result + (this.metricMonitors != null ? this.metricMonitors.hashCode() : 0);
            result = 31 * result + (this.randomizationSalt != null ? this.randomizationSalt.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
