package software.amazon.awscdk.services.eks;

/**
 * Configuration props for EKS Fargate.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.cdk.lambdalayer.kubectl.v32.KubectlV32Layer;
 * FargateCluster cluster = FargateCluster.Builder.create(this, "MyCluster")
 *         .version(KubernetesVersion.V1_32)
 *         .kubectlLayer(new KubectlV32Layer(this, "kubectl"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:12.272Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.FargateClusterProps")
@software.amazon.jsii.Jsii.Proxy(FargateClusterProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface FargateClusterProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.eks.ClusterOptions {

    /**
     * Fargate Profile to create along with the cluster.
     * <p>
     * Default: - A profile called "default" with 'default' and 'kube-system'
     *   selectors will be created if this is left undefined.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.eks.FargateProfileOptions getDefaultProfile() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link FargateClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link FargateClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<FargateClusterProps> {
        software.amazon.awscdk.services.eks.FargateProfileOptions defaultProfile;
        software.amazon.awscdk.services.lambda.ILayerVersion kubectlLayer;
        software.amazon.awscdk.services.eks.AlbControllerOptions albController;
        software.amazon.awscdk.services.eks.AuthenticationMode authenticationMode;
        software.amazon.awscdk.services.lambda.ILayerVersion awscliLayer;
        java.util.Map<java.lang.String, java.lang.String> clusterHandlerEnvironment;
        software.amazon.awscdk.services.ec2.ISecurityGroup clusterHandlerSecurityGroup;
        java.util.List<software.amazon.awscdk.services.eks.ClusterLoggingTypes> clusterLogging;
        software.amazon.awscdk.services.eks.CoreDnsComputeType coreDnsComputeType;
        software.amazon.awscdk.services.eks.EndpointAccess endpointAccess;
        software.amazon.awscdk.services.eks.IpFamily ipFamily;
        java.util.Map<java.lang.String, java.lang.String> kubectlEnvironment;
        software.amazon.awscdk.Size kubectlMemory;
        software.amazon.awscdk.services.iam.IRole mastersRole;
        software.amazon.awscdk.services.lambda.ILayerVersion onEventLayer;
        java.lang.Boolean outputMastersRoleArn;
        java.lang.Boolean placeClusterHandlerInVpc;
        java.lang.Boolean prune;
        java.util.List<software.amazon.awscdk.services.eks.RemoteNodeNetwork> remoteNodeNetworks;
        java.util.List<software.amazon.awscdk.services.eks.RemotePodNetwork> remotePodNetworks;
        software.amazon.awscdk.services.kms.IKey secretsEncryptionKey;
        java.lang.String serviceIpv4Cidr;
        software.amazon.awscdk.services.eks.KubernetesVersion version;
        java.lang.String clusterName;
        java.lang.Boolean outputClusterName;
        java.lang.Boolean outputConfigCommand;
        software.amazon.awscdk.services.iam.IRole role;
        software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup;
        software.amazon.awscdk.services.ec2.IVpc vpc;
        java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection> vpcSubnets;

        /**
         * Sets the value of {@link FargateClusterProps#getDefaultProfile}
         * @param defaultProfile Fargate Profile to create along with the cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultProfile(software.amazon.awscdk.services.eks.FargateProfileOptions defaultProfile) {
            this.defaultProfile = defaultProfile;
            return this;
        }

        /**
         * Sets the value of {@link FargateClusterProps#getKubectlLayer}
         * @param kubectlLayer An AWS Lambda Layer which includes <code>kubectl</code> and Helm. This parameter is required.
         *                     This layer is used by the kubectl handler to apply manifests and install
         *                     helm charts. You must pick an appropriate releases of one of the
         *                     <code>&#64;aws-cdk/layer-kubectl-vXX</code> packages, that works with the version of
         *                     Kubernetes you have chosen.
         *                     <p>
         *                     The handler expects the layer to include the following executables:
         *                     <p>
         *                     <blockquote><pre>
         *                     /opt/helm/helm
         *                     /opt/kubectl/kubectl
         *                     </pre></blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kubectlLayer(software.amazon.awscdk.services.lambda.ILayerVersion kubectlLayer) {
            this.kubectlLayer = kubectlLayer;
            return this;
        }

        /**
         * Sets the value of {@link FargateClusterProps#getAlbController}
         * @param albController Install the AWS Load Balancer Controller onto the cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder albController(software.amazon.awscdk.services.eks.AlbControllerOptions albController) {
            this.albController = albController;
            return this;
        }

        /**
         * Sets the value of {@link FargateClusterProps#getAuthenticationMode}
         * @param authenticationMode The desired authentication mode for the cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authenticationMode(software.amazon.awscdk.services.eks.AuthenticationMode authenticationMode) {
            this.authenticationMode = authenticationMode;
            return this;
        }

        /**
         * Sets the value of {@link FargateClusterProps#getAwscliLayer}
         * @param awscliLayer An AWS Lambda layer that contains the <code>aws</code> CLI.
         *                    The handler expects the layer to include the following executables:
         *                    <p>
         *                    <blockquote><pre>
         *                    /opt/awscli/aws
         *                    </pre></blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder awscliLayer(software.amazon.awscdk.services.lambda.ILayerVersion awscliLayer) {
            this.awscliLayer = awscliLayer;
            return this;
        }

        /**
         * Sets the value of {@link FargateClusterProps#getClusterHandlerEnvironment}
         * @param clusterHandlerEnvironment Custom environment variables when interacting with the EKS endpoint to manage the cluster lifecycle.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterHandlerEnvironment(java.util.Map<java.lang.String, java.lang.String> clusterHandlerEnvironment) {
            this.clusterHandlerEnvironment = clusterHandlerEnvironment;
            return this;
        }

        /**
         * Sets the value of {@link FargateClusterProps#getClusterHandlerSecurityGroup}
         * @param clusterHandlerSecurityGroup A security group to associate with the Cluster Handler's Lambdas.
         *                                    The Cluster Handler's Lambdas are responsible for calling AWS's EKS API.
         *                                    <p>
         *                                    Requires <code>placeClusterHandlerInVpc</code> to be set to true.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterHandlerSecurityGroup(software.amazon.awscdk.services.ec2.ISecurityGroup clusterHandlerSecurityGroup) {
            this.clusterHandlerSecurityGroup = clusterHandlerSecurityGroup;
            return this;
        }

        /**
         * Sets the value of {@link FargateClusterProps#getClusterLogging}
         * @param clusterLogging The cluster log types which you want to enable.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder clusterLogging(java.util.List<? extends software.amazon.awscdk.services.eks.ClusterLoggingTypes> clusterLogging) {
            this.clusterLogging = (java.util.List<software.amazon.awscdk.services.eks.ClusterLoggingTypes>)clusterLogging;
            return this;
        }

        /**
         * Sets the value of {@link FargateClusterProps#getCoreDnsComputeType}
         * @param coreDnsComputeType Controls the "eks.amazonaws.com/compute-type" annotation in the CoreDNS configuration on your cluster to determine which compute type to use for CoreDNS.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder coreDnsComputeType(software.amazon.awscdk.services.eks.CoreDnsComputeType coreDnsComputeType) {
            this.coreDnsComputeType = coreDnsComputeType;
            return this;
        }

        /**
         * Sets the value of {@link FargateClusterProps#getEndpointAccess}
         * @param endpointAccess Configure access to the Kubernetes API server endpoint..
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointAccess(software.amazon.awscdk.services.eks.EndpointAccess endpointAccess) {
            this.endpointAccess = endpointAccess;
            return this;
        }

        /**
         * Sets the value of {@link FargateClusterProps#getIpFamily}
         * @param ipFamily Specify which IP family is used to assign Kubernetes pod and service IP addresses.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipFamily(software.amazon.awscdk.services.eks.IpFamily ipFamily) {
            this.ipFamily = ipFamily;
            return this;
        }

        /**
         * Sets the value of {@link FargateClusterProps#getKubectlEnvironment}
         * @param kubectlEnvironment Environment variables for the kubectl execution.
         *                           Only relevant for kubectl enabled clusters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kubectlEnvironment(java.util.Map<java.lang.String, java.lang.String> kubectlEnvironment) {
            this.kubectlEnvironment = kubectlEnvironment;
            return this;
        }

        /**
         * Sets the value of {@link FargateClusterProps#getKubectlMemory}
         * @param kubectlMemory Amount of memory to allocate to the provider's lambda function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kubectlMemory(software.amazon.awscdk.Size kubectlMemory) {
            this.kubectlMemory = kubectlMemory;
            return this;
        }

        /**
         * Sets the value of {@link FargateClusterProps#getMastersRole}
         * @param mastersRole An IAM role that will be added to the <code>system:masters</code> Kubernetes RBAC group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mastersRole(software.amazon.awscdk.services.iam.IRole mastersRole) {
            this.mastersRole = mastersRole;
            return this;
        }

        /**
         * Sets the value of {@link FargateClusterProps#getOnEventLayer}
         * @param onEventLayer An AWS Lambda Layer which includes the NPM dependency <code>proxy-agent</code>.
         *                     This layer
         *                     is used by the onEvent handler to route AWS SDK requests through a proxy.
         *                     <p>
         *                     By default, the provider will use the layer included in the
         *                     "aws-lambda-layer-node-proxy-agent" SAR application which is available in all
         *                     commercial regions.
         *                     <p>
         *                     To deploy the layer locally define it in your app as follows:
         *                     <p>
         *                     <blockquote><pre>
         *                     LayerVersion layer = LayerVersion.Builder.create(this, "proxy-agent-layer")
         *                             .code(Code.fromAsset(String.format("%s/layer.zip", __dirname)))
         *                             .compatibleRuntimes(List.of(Runtime.NODEJS_LATEST))
         *                             .build();
         *                     </pre></blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onEventLayer(software.amazon.awscdk.services.lambda.ILayerVersion onEventLayer) {
            this.onEventLayer = onEventLayer;
            return this;
        }

        /**
         * Sets the value of {@link FargateClusterProps#getOutputMastersRoleArn}
         * @param outputMastersRoleArn Determines whether a CloudFormation output with the ARN of the "masters" IAM role will be synthesized (if <code>mastersRole</code> is specified).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputMastersRoleArn(java.lang.Boolean outputMastersRoleArn) {
            this.outputMastersRoleArn = outputMastersRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link FargateClusterProps#getPlaceClusterHandlerInVpc}
         * @param placeClusterHandlerInVpc If set to true, the cluster handler functions will be placed in the private subnets of the cluster vpc, subject to the <code>vpcSubnets</code> selection strategy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder placeClusterHandlerInVpc(java.lang.Boolean placeClusterHandlerInVpc) {
            this.placeClusterHandlerInVpc = placeClusterHandlerInVpc;
            return this;
        }

        /**
         * Sets the value of {@link FargateClusterProps#getPrune}
         * @param prune Indicates whether Kubernetes resources added through <code>addManifest()</code> can be automatically pruned.
         *              When this is enabled (default), prune labels will be
         *              allocated and injected to each resource. These labels will then be used
         *              when issuing the <code>kubectl apply</code> operation with the <code>--prune</code> switch.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder prune(java.lang.Boolean prune) {
            this.prune = prune;
            return this;
        }

        /**
         * Sets the value of {@link FargateClusterProps#getRemoteNodeNetworks}
         * @param remoteNodeNetworks IPv4 CIDR blocks defining the expected address range of hybrid nodes that will join the cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder remoteNodeNetworks(java.util.List<? extends software.amazon.awscdk.services.eks.RemoteNodeNetwork> remoteNodeNetworks) {
            this.remoteNodeNetworks = (java.util.List<software.amazon.awscdk.services.eks.RemoteNodeNetwork>)remoteNodeNetworks;
            return this;
        }

        /**
         * Sets the value of {@link FargateClusterProps#getRemotePodNetworks}
         * @param remotePodNetworks IPv4 CIDR blocks for Pods running Kubernetes webhooks on hybrid nodes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder remotePodNetworks(java.util.List<? extends software.amazon.awscdk.services.eks.RemotePodNetwork> remotePodNetworks) {
            this.remotePodNetworks = (java.util.List<software.amazon.awscdk.services.eks.RemotePodNetwork>)remotePodNetworks;
            return this;
        }

        /**
         * Sets the value of {@link FargateClusterProps#getSecretsEncryptionKey}
         * @param secretsEncryptionKey KMS secret for envelope encryption for Kubernetes secrets.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secretsEncryptionKey(software.amazon.awscdk.services.kms.IKey secretsEncryptionKey) {
            this.secretsEncryptionKey = secretsEncryptionKey;
            return this;
        }

        /**
         * Sets the value of {@link FargateClusterProps#getServiceIpv4Cidr}
         * @param serviceIpv4Cidr The CIDR block to assign Kubernetes service IP addresses from.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceIpv4Cidr(java.lang.String serviceIpv4Cidr) {
            this.serviceIpv4Cidr = serviceIpv4Cidr;
            return this;
        }

        /**
         * Sets the value of {@link FargateClusterProps#getVersion}
         * @param version The Kubernetes version to run in the cluster. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder version(software.amazon.awscdk.services.eks.KubernetesVersion version) {
            this.version = version;
            return this;
        }

        /**
         * Sets the value of {@link FargateClusterProps#getClusterName}
         * @param clusterName Name for the cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterName(java.lang.String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        /**
         * Sets the value of {@link FargateClusterProps#getOutputClusterName}
         * @param outputClusterName Determines whether a CloudFormation output with the name of the cluster will be synthesized.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputClusterName(java.lang.Boolean outputClusterName) {
            this.outputClusterName = outputClusterName;
            return this;
        }

        /**
         * Sets the value of {@link FargateClusterProps#getOutputConfigCommand}
         * @param outputConfigCommand Determines whether a CloudFormation output with the <code>aws eks update-kubeconfig</code> command will be synthesized.
         *                            This command will include
         *                            the cluster name and, if applicable, the ARN of the masters IAM role.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputConfigCommand(java.lang.Boolean outputConfigCommand) {
            this.outputConfigCommand = outputConfigCommand;
            return this;
        }

        /**
         * Sets the value of {@link FargateClusterProps#getRole}
         * @param role Role that provides permissions for the Kubernetes control plane to make calls to AWS API operations on your behalf.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link FargateClusterProps#getSecurityGroup}
         * @param securityGroup Security Group to use for Control Plane ENIs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroup(software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup) {
            this.securityGroup = securityGroup;
            return this;
        }

        /**
         * Sets the value of {@link FargateClusterProps#getVpc}
         * @param vpc The VPC in which to create the Cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Sets the value of {@link FargateClusterProps#getVpcSubnets}
         * @param vpcSubnets Where to place EKS Control Plane ENIs.
         *                   For example, to only select private subnets, supply the following:
         *                   <p>
         *                   <code>vpcSubnets: [{ subnetType: ec2.SubnetType.PRIVATE_WITH_EGRESS }]</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder vpcSubnets(java.util.List<? extends software.amazon.awscdk.services.ec2.SubnetSelection> vpcSubnets) {
            this.vpcSubnets = (java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection>)vpcSubnets;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link FargateClusterProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public FargateClusterProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link FargateClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FargateClusterProps {
        private final software.amazon.awscdk.services.eks.FargateProfileOptions defaultProfile;
        private final software.amazon.awscdk.services.lambda.ILayerVersion kubectlLayer;
        private final software.amazon.awscdk.services.eks.AlbControllerOptions albController;
        private final software.amazon.awscdk.services.eks.AuthenticationMode authenticationMode;
        private final software.amazon.awscdk.services.lambda.ILayerVersion awscliLayer;
        private final java.util.Map<java.lang.String, java.lang.String> clusterHandlerEnvironment;
        private final software.amazon.awscdk.services.ec2.ISecurityGroup clusterHandlerSecurityGroup;
        private final java.util.List<software.amazon.awscdk.services.eks.ClusterLoggingTypes> clusterLogging;
        private final software.amazon.awscdk.services.eks.CoreDnsComputeType coreDnsComputeType;
        private final software.amazon.awscdk.services.eks.EndpointAccess endpointAccess;
        private final software.amazon.awscdk.services.eks.IpFamily ipFamily;
        private final java.util.Map<java.lang.String, java.lang.String> kubectlEnvironment;
        private final software.amazon.awscdk.Size kubectlMemory;
        private final software.amazon.awscdk.services.iam.IRole mastersRole;
        private final software.amazon.awscdk.services.lambda.ILayerVersion onEventLayer;
        private final java.lang.Boolean outputMastersRoleArn;
        private final java.lang.Boolean placeClusterHandlerInVpc;
        private final java.lang.Boolean prune;
        private final java.util.List<software.amazon.awscdk.services.eks.RemoteNodeNetwork> remoteNodeNetworks;
        private final java.util.List<software.amazon.awscdk.services.eks.RemotePodNetwork> remotePodNetworks;
        private final software.amazon.awscdk.services.kms.IKey secretsEncryptionKey;
        private final java.lang.String serviceIpv4Cidr;
        private final software.amazon.awscdk.services.eks.KubernetesVersion version;
        private final java.lang.String clusterName;
        private final java.lang.Boolean outputClusterName;
        private final java.lang.Boolean outputConfigCommand;
        private final software.amazon.awscdk.services.iam.IRole role;
        private final software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup;
        private final software.amazon.awscdk.services.ec2.IVpc vpc;
        private final java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection> vpcSubnets;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.defaultProfile = software.amazon.jsii.Kernel.get(this, "defaultProfile", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.FargateProfileOptions.class));
            this.kubectlLayer = software.amazon.jsii.Kernel.get(this, "kubectlLayer", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.ILayerVersion.class));
            this.albController = software.amazon.jsii.Kernel.get(this, "albController", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.AlbControllerOptions.class));
            this.authenticationMode = software.amazon.jsii.Kernel.get(this, "authenticationMode", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.AuthenticationMode.class));
            this.awscliLayer = software.amazon.jsii.Kernel.get(this, "awscliLayer", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.ILayerVersion.class));
            this.clusterHandlerEnvironment = software.amazon.jsii.Kernel.get(this, "clusterHandlerEnvironment", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.clusterHandlerSecurityGroup = software.amazon.jsii.Kernel.get(this, "clusterHandlerSecurityGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class));
            this.clusterLogging = software.amazon.jsii.Kernel.get(this, "clusterLogging", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.ClusterLoggingTypes.class)));
            this.coreDnsComputeType = software.amazon.jsii.Kernel.get(this, "coreDnsComputeType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.CoreDnsComputeType.class));
            this.endpointAccess = software.amazon.jsii.Kernel.get(this, "endpointAccess", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.EndpointAccess.class));
            this.ipFamily = software.amazon.jsii.Kernel.get(this, "ipFamily", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.IpFamily.class));
            this.kubectlEnvironment = software.amazon.jsii.Kernel.get(this, "kubectlEnvironment", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.kubectlMemory = software.amazon.jsii.Kernel.get(this, "kubectlMemory", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Size.class));
            this.mastersRole = software.amazon.jsii.Kernel.get(this, "mastersRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.onEventLayer = software.amazon.jsii.Kernel.get(this, "onEventLayer", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.ILayerVersion.class));
            this.outputMastersRoleArn = software.amazon.jsii.Kernel.get(this, "outputMastersRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.placeClusterHandlerInVpc = software.amazon.jsii.Kernel.get(this, "placeClusterHandlerInVpc", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.prune = software.amazon.jsii.Kernel.get(this, "prune", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.remoteNodeNetworks = software.amazon.jsii.Kernel.get(this, "remoteNodeNetworks", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.RemoteNodeNetwork.class)));
            this.remotePodNetworks = software.amazon.jsii.Kernel.get(this, "remotePodNetworks", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.RemotePodNetwork.class)));
            this.secretsEncryptionKey = software.amazon.jsii.Kernel.get(this, "secretsEncryptionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
            this.serviceIpv4Cidr = software.amazon.jsii.Kernel.get(this, "serviceIpv4Cidr", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.version = software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.KubernetesVersion.class));
            this.clusterName = software.amazon.jsii.Kernel.get(this, "clusterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.outputClusterName = software.amazon.jsii.Kernel.get(this, "outputClusterName", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.outputConfigCommand = software.amazon.jsii.Kernel.get(this, "outputConfigCommand", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.securityGroup = software.amazon.jsii.Kernel.get(this, "securityGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class));
            this.vpc = software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class));
            this.vpcSubnets = software.amazon.jsii.Kernel.get(this, "vpcSubnets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetSelection.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.defaultProfile = builder.defaultProfile;
            this.kubectlLayer = java.util.Objects.requireNonNull(builder.kubectlLayer, "kubectlLayer is required");
            this.albController = builder.albController;
            this.authenticationMode = builder.authenticationMode;
            this.awscliLayer = builder.awscliLayer;
            this.clusterHandlerEnvironment = builder.clusterHandlerEnvironment;
            this.clusterHandlerSecurityGroup = builder.clusterHandlerSecurityGroup;
            this.clusterLogging = (java.util.List<software.amazon.awscdk.services.eks.ClusterLoggingTypes>)builder.clusterLogging;
            this.coreDnsComputeType = builder.coreDnsComputeType;
            this.endpointAccess = builder.endpointAccess;
            this.ipFamily = builder.ipFamily;
            this.kubectlEnvironment = builder.kubectlEnvironment;
            this.kubectlMemory = builder.kubectlMemory;
            this.mastersRole = builder.mastersRole;
            this.onEventLayer = builder.onEventLayer;
            this.outputMastersRoleArn = builder.outputMastersRoleArn;
            this.placeClusterHandlerInVpc = builder.placeClusterHandlerInVpc;
            this.prune = builder.prune;
            this.remoteNodeNetworks = (java.util.List<software.amazon.awscdk.services.eks.RemoteNodeNetwork>)builder.remoteNodeNetworks;
            this.remotePodNetworks = (java.util.List<software.amazon.awscdk.services.eks.RemotePodNetwork>)builder.remotePodNetworks;
            this.secretsEncryptionKey = builder.secretsEncryptionKey;
            this.serviceIpv4Cidr = builder.serviceIpv4Cidr;
            this.version = java.util.Objects.requireNonNull(builder.version, "version is required");
            this.clusterName = builder.clusterName;
            this.outputClusterName = builder.outputClusterName;
            this.outputConfigCommand = builder.outputConfigCommand;
            this.role = builder.role;
            this.securityGroup = builder.securityGroup;
            this.vpc = builder.vpc;
            this.vpcSubnets = (java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection>)builder.vpcSubnets;
        }

        @Override
        public final software.amazon.awscdk.services.eks.FargateProfileOptions getDefaultProfile() {
            return this.defaultProfile;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.ILayerVersion getKubectlLayer() {
            return this.kubectlLayer;
        }

        @Override
        public final software.amazon.awscdk.services.eks.AlbControllerOptions getAlbController() {
            return this.albController;
        }

        @Override
        public final software.amazon.awscdk.services.eks.AuthenticationMode getAuthenticationMode() {
            return this.authenticationMode;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.ILayerVersion getAwscliLayer() {
            return this.awscliLayer;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getClusterHandlerEnvironment() {
            return this.clusterHandlerEnvironment;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.ISecurityGroup getClusterHandlerSecurityGroup() {
            return this.clusterHandlerSecurityGroup;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.eks.ClusterLoggingTypes> getClusterLogging() {
            return this.clusterLogging;
        }

        @Override
        public final software.amazon.awscdk.services.eks.CoreDnsComputeType getCoreDnsComputeType() {
            return this.coreDnsComputeType;
        }

        @Override
        public final software.amazon.awscdk.services.eks.EndpointAccess getEndpointAccess() {
            return this.endpointAccess;
        }

        @Override
        public final software.amazon.awscdk.services.eks.IpFamily getIpFamily() {
            return this.ipFamily;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getKubectlEnvironment() {
            return this.kubectlEnvironment;
        }

        @Override
        public final software.amazon.awscdk.Size getKubectlMemory() {
            return this.kubectlMemory;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getMastersRole() {
            return this.mastersRole;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.ILayerVersion getOnEventLayer() {
            return this.onEventLayer;
        }

        @Override
        public final java.lang.Boolean getOutputMastersRoleArn() {
            return this.outputMastersRoleArn;
        }

        @Override
        public final java.lang.Boolean getPlaceClusterHandlerInVpc() {
            return this.placeClusterHandlerInVpc;
        }

        @Override
        public final java.lang.Boolean getPrune() {
            return this.prune;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.eks.RemoteNodeNetwork> getRemoteNodeNetworks() {
            return this.remoteNodeNetworks;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.eks.RemotePodNetwork> getRemotePodNetworks() {
            return this.remotePodNetworks;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getSecretsEncryptionKey() {
            return this.secretsEncryptionKey;
        }

        @Override
        public final java.lang.String getServiceIpv4Cidr() {
            return this.serviceIpv4Cidr;
        }

        @Override
        public final software.amazon.awscdk.services.eks.KubernetesVersion getVersion() {
            return this.version;
        }

        @Override
        public final java.lang.String getClusterName() {
            return this.clusterName;
        }

        @Override
        public final java.lang.Boolean getOutputClusterName() {
            return this.outputClusterName;
        }

        @Override
        public final java.lang.Boolean getOutputConfigCommand() {
            return this.outputConfigCommand;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.ISecurityGroup getSecurityGroup() {
            return this.securityGroup;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection> getVpcSubnets() {
            return this.vpcSubnets;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getDefaultProfile() != null) {
                data.set("defaultProfile", om.valueToTree(this.getDefaultProfile()));
            }
            data.set("kubectlLayer", om.valueToTree(this.getKubectlLayer()));
            if (this.getAlbController() != null) {
                data.set("albController", om.valueToTree(this.getAlbController()));
            }
            if (this.getAuthenticationMode() != null) {
                data.set("authenticationMode", om.valueToTree(this.getAuthenticationMode()));
            }
            if (this.getAwscliLayer() != null) {
                data.set("awscliLayer", om.valueToTree(this.getAwscliLayer()));
            }
            if (this.getClusterHandlerEnvironment() != null) {
                data.set("clusterHandlerEnvironment", om.valueToTree(this.getClusterHandlerEnvironment()));
            }
            if (this.getClusterHandlerSecurityGroup() != null) {
                data.set("clusterHandlerSecurityGroup", om.valueToTree(this.getClusterHandlerSecurityGroup()));
            }
            if (this.getClusterLogging() != null) {
                data.set("clusterLogging", om.valueToTree(this.getClusterLogging()));
            }
            if (this.getCoreDnsComputeType() != null) {
                data.set("coreDnsComputeType", om.valueToTree(this.getCoreDnsComputeType()));
            }
            if (this.getEndpointAccess() != null) {
                data.set("endpointAccess", om.valueToTree(this.getEndpointAccess()));
            }
            if (this.getIpFamily() != null) {
                data.set("ipFamily", om.valueToTree(this.getIpFamily()));
            }
            if (this.getKubectlEnvironment() != null) {
                data.set("kubectlEnvironment", om.valueToTree(this.getKubectlEnvironment()));
            }
            if (this.getKubectlMemory() != null) {
                data.set("kubectlMemory", om.valueToTree(this.getKubectlMemory()));
            }
            if (this.getMastersRole() != null) {
                data.set("mastersRole", om.valueToTree(this.getMastersRole()));
            }
            if (this.getOnEventLayer() != null) {
                data.set("onEventLayer", om.valueToTree(this.getOnEventLayer()));
            }
            if (this.getOutputMastersRoleArn() != null) {
                data.set("outputMastersRoleArn", om.valueToTree(this.getOutputMastersRoleArn()));
            }
            if (this.getPlaceClusterHandlerInVpc() != null) {
                data.set("placeClusterHandlerInVpc", om.valueToTree(this.getPlaceClusterHandlerInVpc()));
            }
            if (this.getPrune() != null) {
                data.set("prune", om.valueToTree(this.getPrune()));
            }
            if (this.getRemoteNodeNetworks() != null) {
                data.set("remoteNodeNetworks", om.valueToTree(this.getRemoteNodeNetworks()));
            }
            if (this.getRemotePodNetworks() != null) {
                data.set("remotePodNetworks", om.valueToTree(this.getRemotePodNetworks()));
            }
            if (this.getSecretsEncryptionKey() != null) {
                data.set("secretsEncryptionKey", om.valueToTree(this.getSecretsEncryptionKey()));
            }
            if (this.getServiceIpv4Cidr() != null) {
                data.set("serviceIpv4Cidr", om.valueToTree(this.getServiceIpv4Cidr()));
            }
            data.set("version", om.valueToTree(this.getVersion()));
            if (this.getClusterName() != null) {
                data.set("clusterName", om.valueToTree(this.getClusterName()));
            }
            if (this.getOutputClusterName() != null) {
                data.set("outputClusterName", om.valueToTree(this.getOutputClusterName()));
            }
            if (this.getOutputConfigCommand() != null) {
                data.set("outputConfigCommand", om.valueToTree(this.getOutputConfigCommand()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }
            if (this.getSecurityGroup() != null) {
                data.set("securityGroup", om.valueToTree(this.getSecurityGroup()));
            }
            if (this.getVpc() != null) {
                data.set("vpc", om.valueToTree(this.getVpc()));
            }
            if (this.getVpcSubnets() != null) {
                data.set("vpcSubnets", om.valueToTree(this.getVpcSubnets()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_eks.FargateClusterProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            FargateClusterProps.Jsii$Proxy that = (FargateClusterProps.Jsii$Proxy) o;

            if (this.defaultProfile != null ? !this.defaultProfile.equals(that.defaultProfile) : that.defaultProfile != null) return false;
            if (!kubectlLayer.equals(that.kubectlLayer)) return false;
            if (this.albController != null ? !this.albController.equals(that.albController) : that.albController != null) return false;
            if (this.authenticationMode != null ? !this.authenticationMode.equals(that.authenticationMode) : that.authenticationMode != null) return false;
            if (this.awscliLayer != null ? !this.awscliLayer.equals(that.awscliLayer) : that.awscliLayer != null) return false;
            if (this.clusterHandlerEnvironment != null ? !this.clusterHandlerEnvironment.equals(that.clusterHandlerEnvironment) : that.clusterHandlerEnvironment != null) return false;
            if (this.clusterHandlerSecurityGroup != null ? !this.clusterHandlerSecurityGroup.equals(that.clusterHandlerSecurityGroup) : that.clusterHandlerSecurityGroup != null) return false;
            if (this.clusterLogging != null ? !this.clusterLogging.equals(that.clusterLogging) : that.clusterLogging != null) return false;
            if (this.coreDnsComputeType != null ? !this.coreDnsComputeType.equals(that.coreDnsComputeType) : that.coreDnsComputeType != null) return false;
            if (this.endpointAccess != null ? !this.endpointAccess.equals(that.endpointAccess) : that.endpointAccess != null) return false;
            if (this.ipFamily != null ? !this.ipFamily.equals(that.ipFamily) : that.ipFamily != null) return false;
            if (this.kubectlEnvironment != null ? !this.kubectlEnvironment.equals(that.kubectlEnvironment) : that.kubectlEnvironment != null) return false;
            if (this.kubectlMemory != null ? !this.kubectlMemory.equals(that.kubectlMemory) : that.kubectlMemory != null) return false;
            if (this.mastersRole != null ? !this.mastersRole.equals(that.mastersRole) : that.mastersRole != null) return false;
            if (this.onEventLayer != null ? !this.onEventLayer.equals(that.onEventLayer) : that.onEventLayer != null) return false;
            if (this.outputMastersRoleArn != null ? !this.outputMastersRoleArn.equals(that.outputMastersRoleArn) : that.outputMastersRoleArn != null) return false;
            if (this.placeClusterHandlerInVpc != null ? !this.placeClusterHandlerInVpc.equals(that.placeClusterHandlerInVpc) : that.placeClusterHandlerInVpc != null) return false;
            if (this.prune != null ? !this.prune.equals(that.prune) : that.prune != null) return false;
            if (this.remoteNodeNetworks != null ? !this.remoteNodeNetworks.equals(that.remoteNodeNetworks) : that.remoteNodeNetworks != null) return false;
            if (this.remotePodNetworks != null ? !this.remotePodNetworks.equals(that.remotePodNetworks) : that.remotePodNetworks != null) return false;
            if (this.secretsEncryptionKey != null ? !this.secretsEncryptionKey.equals(that.secretsEncryptionKey) : that.secretsEncryptionKey != null) return false;
            if (this.serviceIpv4Cidr != null ? !this.serviceIpv4Cidr.equals(that.serviceIpv4Cidr) : that.serviceIpv4Cidr != null) return false;
            if (!version.equals(that.version)) return false;
            if (this.clusterName != null ? !this.clusterName.equals(that.clusterName) : that.clusterName != null) return false;
            if (this.outputClusterName != null ? !this.outputClusterName.equals(that.outputClusterName) : that.outputClusterName != null) return false;
            if (this.outputConfigCommand != null ? !this.outputConfigCommand.equals(that.outputConfigCommand) : that.outputConfigCommand != null) return false;
            if (this.role != null ? !this.role.equals(that.role) : that.role != null) return false;
            if (this.securityGroup != null ? !this.securityGroup.equals(that.securityGroup) : that.securityGroup != null) return false;
            if (this.vpc != null ? !this.vpc.equals(that.vpc) : that.vpc != null) return false;
            return this.vpcSubnets != null ? this.vpcSubnets.equals(that.vpcSubnets) : that.vpcSubnets == null;
        }

        @Override
        public final int hashCode() {
            int result = this.defaultProfile != null ? this.defaultProfile.hashCode() : 0;
            result = 31 * result + (this.kubectlLayer.hashCode());
            result = 31 * result + (this.albController != null ? this.albController.hashCode() : 0);
            result = 31 * result + (this.authenticationMode != null ? this.authenticationMode.hashCode() : 0);
            result = 31 * result + (this.awscliLayer != null ? this.awscliLayer.hashCode() : 0);
            result = 31 * result + (this.clusterHandlerEnvironment != null ? this.clusterHandlerEnvironment.hashCode() : 0);
            result = 31 * result + (this.clusterHandlerSecurityGroup != null ? this.clusterHandlerSecurityGroup.hashCode() : 0);
            result = 31 * result + (this.clusterLogging != null ? this.clusterLogging.hashCode() : 0);
            result = 31 * result + (this.coreDnsComputeType != null ? this.coreDnsComputeType.hashCode() : 0);
            result = 31 * result + (this.endpointAccess != null ? this.endpointAccess.hashCode() : 0);
            result = 31 * result + (this.ipFamily != null ? this.ipFamily.hashCode() : 0);
            result = 31 * result + (this.kubectlEnvironment != null ? this.kubectlEnvironment.hashCode() : 0);
            result = 31 * result + (this.kubectlMemory != null ? this.kubectlMemory.hashCode() : 0);
            result = 31 * result + (this.mastersRole != null ? this.mastersRole.hashCode() : 0);
            result = 31 * result + (this.onEventLayer != null ? this.onEventLayer.hashCode() : 0);
            result = 31 * result + (this.outputMastersRoleArn != null ? this.outputMastersRoleArn.hashCode() : 0);
            result = 31 * result + (this.placeClusterHandlerInVpc != null ? this.placeClusterHandlerInVpc.hashCode() : 0);
            result = 31 * result + (this.prune != null ? this.prune.hashCode() : 0);
            result = 31 * result + (this.remoteNodeNetworks != null ? this.remoteNodeNetworks.hashCode() : 0);
            result = 31 * result + (this.remotePodNetworks != null ? this.remotePodNetworks.hashCode() : 0);
            result = 31 * result + (this.secretsEncryptionKey != null ? this.secretsEncryptionKey.hashCode() : 0);
            result = 31 * result + (this.serviceIpv4Cidr != null ? this.serviceIpv4Cidr.hashCode() : 0);
            result = 31 * result + (this.version.hashCode());
            result = 31 * result + (this.clusterName != null ? this.clusterName.hashCode() : 0);
            result = 31 * result + (this.outputClusterName != null ? this.outputClusterName.hashCode() : 0);
            result = 31 * result + (this.outputConfigCommand != null ? this.outputConfigCommand.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            result = 31 * result + (this.securityGroup != null ? this.securityGroup.hashCode() : 0);
            result = 31 * result + (this.vpc != null ? this.vpc.hashCode() : 0);
            result = 31 * result + (this.vpcSubnets != null ? this.vpcSubnets.hashCode() : 0);
            return result;
        }
    }
}
