package software.amazon.awscdk.services.ecs;

/**
 * This creates a service using the EC2 launch type on an ECS cluster.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Cluster cluster;
 * TaskDefinition taskDefinition;
 * Vpc vpc;
 * Ec2Service service = Ec2Service.Builder.create(this, "Service").cluster(cluster).taskDefinition(taskDefinition).minHealthyPercent(100).build();
 * LoadBalancer lb = LoadBalancer.Builder.create(this, "LB").vpc(vpc).build();
 * lb.addListener(LoadBalancerListener.builder().externalPort(80).build());
 * lb.addTarget(service.loadBalancerTarget(LoadBalancerTargetOptions.builder()
 *         .containerName("MyContainer")
 *         .containerPort(80)
 *         .build()));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:11.659Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.Ec2Service")
public class Ec2Service extends software.amazon.awscdk.services.ecs.BaseService implements software.amazon.awscdk.services.ecs.IEc2Service {

    protected Ec2Service(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Ec2Service(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Constructs a new instance of the Ec2Service class.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Ec2Service(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.Ec2ServiceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Imports from the specified service ARN.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param ec2ServiceArn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.IEc2Service fromEc2ServiceArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String ec2ServiceArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.Ec2Service.class, "fromEc2ServiceArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.IEc2Service.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(ec2ServiceArn, "ec2ServiceArn is required") });
    }

    /**
     * Imports from the specified service attributes.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.IBaseService fromEc2ServiceAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.Ec2ServiceAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.Ec2Service.class, "fromEc2ServiceAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.IBaseService.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Adds one or more placement constraints to use for tasks in the service.
     * <p>
     * For more information, see
     * <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-constraints.html">Amazon ECS Task Placement Constraints</a>.
     * <p>
     * @param constraints This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addPlacementConstraints(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.PlacementConstraint... constraints) {
        software.amazon.jsii.Kernel.call(this, "addPlacementConstraints", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(constraints).toArray(Object[]::new));
    }

    /**
     * Adds one or more placement strategies to use for tasks in the service.
     * <p>
     * For more information, see
     * <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-strategies.html">Amazon ECS Task Placement Strategies</a>.
     * <p>
     * @param strategies This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addPlacementStrategies(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.PlacementStrategy... strategies) {
        software.amazon.jsii.Kernel.call(this, "addPlacementStrategies", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(strategies).toArray(Object[]::new));
    }

    /**
     * Registers the service as a target of a Classic Load Balancer (CLB).
     * <p>
     * Don't call this. Call <code>loadBalancer.addTarget()</code> instead.
     * <p>
     * @param loadBalancer This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void attachToClassicLB(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancing.LoadBalancer loadBalancer) {
        software.amazon.jsii.Kernel.call(this, "attachToClassicLB", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(loadBalancer, "loadBalancer is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ecs.Ec2Service}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ecs.Ec2Service> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ecs.Ec2ServiceProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ecs.Ec2ServiceProps.Builder();
        }

        /**
         * The name of the cluster that hosts the service.
         * <p>
         * @return {@code this}
         * @param cluster The name of the cluster that hosts the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cluster(final software.amazon.awscdk.services.ecs.ICluster cluster) {
            this.props.cluster(cluster);
            return this;
        }

        /**
         * A list of Capacity Provider strategies used to place a service.
         * <p>
         * Default: - undefined
         * <p>
         * @return {@code this}
         * @param capacityProviderStrategies A list of Capacity Provider strategies used to place a service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder capacityProviderStrategies(final java.util.List<? extends software.amazon.awscdk.services.ecs.CapacityProviderStrategy> capacityProviderStrategies) {
            this.props.capacityProviderStrategies(capacityProviderStrategies);
            return this;
        }

        /**
         * Whether to enable the deployment circuit breaker.
         * <p>
         * If this property is defined, circuit breaker will be implicitly
         * enabled.
         * <p>
         * Default: - disabled
         * <p>
         * @return {@code this}
         * @param circuitBreaker Whether to enable the deployment circuit breaker. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder circuitBreaker(final software.amazon.awscdk.services.ecs.DeploymentCircuitBreaker circuitBreaker) {
            this.props.circuitBreaker(circuitBreaker);
            return this;
        }

        /**
         * The options for configuring an Amazon ECS service to use service discovery.
         * <p>
         * Default: - AWS Cloud Map service discovery is not enabled.
         * <p>
         * @return {@code this}
         * @param cloudMapOptions The options for configuring an Amazon ECS service to use service discovery. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudMapOptions(final software.amazon.awscdk.services.ecs.CloudMapOptions cloudMapOptions) {
            this.props.cloudMapOptions(cloudMapOptions);
            return this;
        }

        /**
         * The alarm(s) to monitor during deployment, and behavior to apply if at least one enters a state of alarm during the deployment or bake time.
         * <p>
         * Default: - No alarms will be monitored during deployment.
         * <p>
         * @return {@code this}
         * @param deploymentAlarms The alarm(s) to monitor during deployment, and behavior to apply if at least one enters a state of alarm during the deployment or bake time. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentAlarms(final software.amazon.awscdk.services.ecs.DeploymentAlarmConfig deploymentAlarms) {
            this.props.deploymentAlarms(deploymentAlarms);
            return this;
        }

        /**
         * Specifies which deployment controller to use for the service.
         * <p>
         * For more information, see
         * <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html">Amazon ECS Deployment Types</a>
         * <p>
         * Default: - Rolling update (ECS)
         * <p>
         * @return {@code this}
         * @param deploymentController Specifies which deployment controller to use for the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentController(final software.amazon.awscdk.services.ecs.DeploymentController deploymentController) {
            this.props.deploymentController(deploymentController);
            return this;
        }

        /**
         * The desired number of instantiations of the task definition to keep running on the service.
         * <p>
         * Default: - When creating the service, default is 1; when updating the service, default uses
         * the current task number.
         * <p>
         * @return {@code this}
         * @param desiredCount The desired number of instantiations of the task definition to keep running on the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder desiredCount(final java.lang.Number desiredCount) {
            this.props.desiredCount(desiredCount);
            return this;
        }

        /**
         * Specifies whether to enable Amazon ECS managed tags for the tasks within the service.
         * <p>
         * For more information, see
         * <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging Your Amazon ECS Resources</a>
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param enableEcsManagedTags Specifies whether to enable Amazon ECS managed tags for the tasks within the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableEcsManagedTags(final java.lang.Boolean enableEcsManagedTags) {
            this.props.enableEcsManagedTags(enableEcsManagedTags);
            return this;
        }

        /**
         * Whether to enable the ability to execute into a container.
         * <p>
         * Default: - undefined
         * <p>
         * @return {@code this}
         * @param enableExecuteCommand Whether to enable the ability to execute into a container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableExecuteCommand(final java.lang.Boolean enableExecuteCommand) {
            this.props.enableExecuteCommand(enableExecuteCommand);
            return this;
        }

        /**
         * The period of time, in seconds, that the Amazon ECS service scheduler ignores unhealthy Elastic Load Balancing target health checks after a task has first started.
         * <p>
         * Default: - defaults to 60 seconds if at least one load balancer is in-use and it is not already set
         * <p>
         * @return {@code this}
         * @param healthCheckGracePeriod The period of time, in seconds, that the Amazon ECS service scheduler ignores unhealthy Elastic Load Balancing target health checks after a task has first started. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheckGracePeriod(final software.amazon.awscdk.Duration healthCheckGracePeriod) {
            this.props.healthCheckGracePeriod(healthCheckGracePeriod);
            return this;
        }

        /**
         * The maximum number of tasks, specified as a percentage of the Amazon ECS service's DesiredCount value, that can run in a service during a deployment.
         * <p>
         * Default: - 100 if daemon, otherwise 200
         * <p>
         * @return {@code this}
         * @param maxHealthyPercent The maximum number of tasks, specified as a percentage of the Amazon ECS service's DesiredCount value, that can run in a service during a deployment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxHealthyPercent(final java.lang.Number maxHealthyPercent) {
            this.props.maxHealthyPercent(maxHealthyPercent);
            return this;
        }

        /**
         * The minimum number of tasks, specified as a percentage of the Amazon ECS service's DesiredCount value, that must continue to run and remain healthy during a deployment.
         * <p>
         * Default: - 0 if daemon, otherwise 50
         * <p>
         * @return {@code this}
         * @param minHealthyPercent The minimum number of tasks, specified as a percentage of the Amazon ECS service's DesiredCount value, that must continue to run and remain healthy during a deployment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minHealthyPercent(final java.lang.Number minHealthyPercent) {
            this.props.minHealthyPercent(minHealthyPercent);
            return this;
        }

        /**
         * Specifies whether to propagate the tags from the task definition or the service to the tasks in the service.
         * <p>
         * Valid values are: PropagatedTagSource.SERVICE, PropagatedTagSource.TASK_DEFINITION or PropagatedTagSource.NONE
         * <p>
         * Default: PropagatedTagSource.NONE
         * <p>
         * @return {@code this}
         * @param propagateTags Specifies whether to propagate the tags from the task definition or the service to the tasks in the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder propagateTags(final software.amazon.awscdk.services.ecs.PropagatedTagSource propagateTags) {
            this.props.propagateTags(propagateTags);
            return this;
        }

        /**
         * Configuration for Service Connect.
         * <p>
         * Default: No ports are advertised via Service Connect on this service, and the service
         * cannot make requests to other services via Service Connect.
         * <p>
         * @return {@code this}
         * @param serviceConnectConfiguration Configuration for Service Connect. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceConnectConfiguration(final software.amazon.awscdk.services.ecs.ServiceConnectProps serviceConnectConfiguration) {
            this.props.serviceConnectConfiguration(serviceConnectConfiguration);
            return this;
        }

        /**
         * The name of the service.
         * <p>
         * Default: - CloudFormation-generated name.
         * <p>
         * @return {@code this}
         * @param serviceName The name of the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceName(final java.lang.String serviceName) {
            this.props.serviceName(serviceName);
            return this;
        }

        /**
         * Revision number for the task definition or <code>latest</code> to use the latest active task revision.
         * <p>
         * Default: - Uses the revision of the passed task definition deployed by CloudFormation
         * <p>
         * @return {@code this}
         * @param taskDefinitionRevision Revision number for the task definition or <code>latest</code> to use the latest active task revision. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskDefinitionRevision(final software.amazon.awscdk.services.ecs.TaskDefinitionRevision taskDefinitionRevision) {
            this.props.taskDefinitionRevision(taskDefinitionRevision);
            return this;
        }

        /**
         * Configuration details for a volume used by the service.
         * <p>
         * This allows you to specify
         * details about the EBS volume that can be attched to ECS tasks.
         * <p>
         * Default: - undefined
         * <p>
         * @return {@code this}
         * @param volumeConfigurations Configuration details for a volume used by the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder volumeConfigurations(final java.util.List<? extends software.amazon.awscdk.services.ecs.ServiceManagedVolume> volumeConfigurations) {
            this.props.volumeConfigurations(volumeConfigurations);
            return this;
        }

        /**
         * The task definition to use for tasks in the service.
         * <p>
         * [disable-awslint:ref-via-interface]
         * <p>
         * @return {@code this}
         * @param taskDefinition The task definition to use for tasks in the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskDefinition(final software.amazon.awscdk.services.ecs.TaskDefinition taskDefinition) {
            this.props.taskDefinition(taskDefinition);
            return this;
        }

        /**
         * Specifies whether the task's elastic network interface receives a public IP address.
         * <p>
         * If true, each task will receive a public IP address.
         * <p>
         * This property is only used for tasks that use the awsvpc network mode.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param assignPublicIp Specifies whether the task's elastic network interface receives a public IP address. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assignPublicIp(final java.lang.Boolean assignPublicIp) {
            this.props.assignPublicIp(assignPublicIp);
            return this;
        }

        /**
         * Whether to use Availability Zone rebalancing for the service.
         * <p>
         * If enabled: <code>maxHealthyPercent</code> must be greater than 100; <code>daemon</code> must be false; if there
         * are any <code>placementStrategies</code>, the first must be "spread across Availability Zones"; there
         * must be no <code>placementConstraints</code> using <code>attribute:ecs.availability-zone</code>, and the
         * service must not be a target of a Classic Load Balancer.
         * <p>
         * Default: AvailabilityZoneRebalancing.DISABLED
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-rebalancing.html">https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-rebalancing.html</a>
         * @param availabilityZoneRebalancing Whether to use Availability Zone rebalancing for the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZoneRebalancing(final software.amazon.awscdk.services.ecs.AvailabilityZoneRebalancing availabilityZoneRebalancing) {
            this.props.availabilityZoneRebalancing(availabilityZoneRebalancing);
            return this;
        }

        /**
         * Specifies whether the service will use the daemon scheduling strategy.
         * <p>
         * If true, the service scheduler deploys exactly one task on each container instance in your cluster.
         * <p>
         * When you are using this strategy, do not specify a desired number of tasks or any task placement strategies.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param daemon Specifies whether the service will use the daemon scheduling strategy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder daemon(final java.lang.Boolean daemon) {
            this.props.daemon(daemon);
            return this;
        }

        /**
         * The placement constraints to use for tasks in the service.
         * <p>
         * For more information, see
         * <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-constraints.html">Amazon ECS Task Placement Constraints</a>.
         * <p>
         * Default: - No constraints.
         * <p>
         * @return {@code this}
         * @param placementConstraints The placement constraints to use for tasks in the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder placementConstraints(final java.util.List<? extends software.amazon.awscdk.services.ecs.PlacementConstraint> placementConstraints) {
            this.props.placementConstraints(placementConstraints);
            return this;
        }

        /**
         * The placement strategies to use for tasks in the service.
         * <p>
         * For more information, see
         * <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-strategies.html">Amazon ECS Task Placement Strategies</a>.
         * <p>
         * Default: - No strategies.
         * <p>
         * @return {@code this}
         * @param placementStrategies The placement strategies to use for tasks in the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder placementStrategies(final java.util.List<? extends software.amazon.awscdk.services.ecs.PlacementStrategy> placementStrategies) {
            this.props.placementStrategies(placementStrategies);
            return this;
        }

        /**
         * The security groups to associate with the service.
         * <p>
         * If you do not specify a security group, a new security group is created.
         * <p>
         * This property is only used for tasks that use the awsvpc network mode.
         * <p>
         * Default: - A new security group is created.
         * <p>
         * @return {@code this}
         * @param securityGroups The security groups to associate with the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroups(final java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.props.securityGroups(securityGroups);
            return this;
        }

        /**
         * The subnets to associate with the service.
         * <p>
         * This property is only used for tasks that use the awsvpc network mode.
         * <p>
         * Default: - Public subnets if `assignPublicIp` is set, otherwise the first available one of Private, Isolated, Public, in that order.
         * <p>
         * @return {@code this}
         * @param vpcSubnets The subnets to associate with the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSubnets(final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            this.props.vpcSubnets(vpcSubnets);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.ecs.Ec2Service}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ecs.Ec2Service build() {
            return new software.amazon.awscdk.services.ecs.Ec2Service(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
