package software.amazon.awscdk.services.ec2;

/**
 * Request for IPv6 CIDR block to be split up.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * CreateIpv6CidrBlocksRequest createIpv6CidrBlocksRequest = CreateIpv6CidrBlocksRequest.builder()
 *         .ipv6SelectedCidr("ipv6SelectedCidr")
 *         .subnetCount(123)
 *         // the properties below are optional
 *         .sizeMask("sizeMask")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:11.181Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CreateIpv6CidrBlocksRequest")
@software.amazon.jsii.Jsii.Proxy(CreateIpv6CidrBlocksRequest.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CreateIpv6CidrBlocksRequest extends software.amazon.jsii.JsiiSerializable {

    /**
     * The IPv6 CIDR block string representation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getIpv6SelectedCidr();

    /**
     * The number of subnets to assign CIDRs to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getSubnetCount();

    /**
     * Size of the covered bits in the CIDR.
     * <p>
     * Default: - 128 - 64 = /64 CIDR.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSizeMask() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CreateIpv6CidrBlocksRequest}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CreateIpv6CidrBlocksRequest}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CreateIpv6CidrBlocksRequest> {
        java.lang.String ipv6SelectedCidr;
        java.lang.Number subnetCount;
        java.lang.String sizeMask;

        /**
         * Sets the value of {@link CreateIpv6CidrBlocksRequest#getIpv6SelectedCidr}
         * @param ipv6SelectedCidr The IPv6 CIDR block string representation. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipv6SelectedCidr(java.lang.String ipv6SelectedCidr) {
            this.ipv6SelectedCidr = ipv6SelectedCidr;
            return this;
        }

        /**
         * Sets the value of {@link CreateIpv6CidrBlocksRequest#getSubnetCount}
         * @param subnetCount The number of subnets to assign CIDRs to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetCount(java.lang.Number subnetCount) {
            this.subnetCount = subnetCount;
            return this;
        }

        /**
         * Sets the value of {@link CreateIpv6CidrBlocksRequest#getSizeMask}
         * @param sizeMask Size of the covered bits in the CIDR.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sizeMask(java.lang.String sizeMask) {
            this.sizeMask = sizeMask;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CreateIpv6CidrBlocksRequest}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CreateIpv6CidrBlocksRequest build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CreateIpv6CidrBlocksRequest}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CreateIpv6CidrBlocksRequest {
        private final java.lang.String ipv6SelectedCidr;
        private final java.lang.Number subnetCount;
        private final java.lang.String sizeMask;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.ipv6SelectedCidr = software.amazon.jsii.Kernel.get(this, "ipv6SelectedCidr", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.subnetCount = software.amazon.jsii.Kernel.get(this, "subnetCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.sizeMask = software.amazon.jsii.Kernel.get(this, "sizeMask", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.ipv6SelectedCidr = java.util.Objects.requireNonNull(builder.ipv6SelectedCidr, "ipv6SelectedCidr is required");
            this.subnetCount = java.util.Objects.requireNonNull(builder.subnetCount, "subnetCount is required");
            this.sizeMask = builder.sizeMask;
        }

        @Override
        public final java.lang.String getIpv6SelectedCidr() {
            return this.ipv6SelectedCidr;
        }

        @Override
        public final java.lang.Number getSubnetCount() {
            return this.subnetCount;
        }

        @Override
        public final java.lang.String getSizeMask() {
            return this.sizeMask;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("ipv6SelectedCidr", om.valueToTree(this.getIpv6SelectedCidr()));
            data.set("subnetCount", om.valueToTree(this.getSubnetCount()));
            if (this.getSizeMask() != null) {
                data.set("sizeMask", om.valueToTree(this.getSizeMask()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CreateIpv6CidrBlocksRequest"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CreateIpv6CidrBlocksRequest.Jsii$Proxy that = (CreateIpv6CidrBlocksRequest.Jsii$Proxy) o;

            if (!ipv6SelectedCidr.equals(that.ipv6SelectedCidr)) return false;
            if (!subnetCount.equals(that.subnetCount)) return false;
            return this.sizeMask != null ? this.sizeMask.equals(that.sizeMask) : that.sizeMask == null;
        }

        @Override
        public final int hashCode() {
            int result = this.ipv6SelectedCidr.hashCode();
            result = 31 * result + (this.subnetCount.hashCode());
            result = 31 * result + (this.sizeMask != null ? this.sizeMask.hashCode() : 0);
            return result;
        }
    }
}
