package software.amazon.awscdk.services.customerprofiles;

/**
 * A segment definition resource of Amazon Connect Customer Profiles.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.customerprofiles.*;
 * CfnSegmentDefinition cfnSegmentDefinition = CfnSegmentDefinition.Builder.create(this, "MyCfnSegmentDefinition")
 *         .displayName("displayName")
 *         .domainName("domainName")
 *         .segmentDefinitionName("segmentDefinitionName")
 *         .segmentGroups(SegmentGroupProperty.builder()
 *                 .groups(List.of(GroupProperty.builder()
 *                         .dimensions(List.of(DimensionProperty.builder()
 *                                 .calculatedAttributes(Map.of(
 *                                         "calculatedAttributesKey", CalculatedAttributeDimensionProperty.builder()
 *                                                 .dimensionType("dimensionType")
 *                                                 .values(List.of("values"))
 *                                                 // the properties below are optional
 *                                                 .conditionOverrides(ConditionOverridesProperty.builder()
 *                                                         .range(RangeOverrideProperty.builder()
 *                                                                 .start(123)
 *                                                                 .unit("unit")
 *                                                                 // the properties below are optional
 *                                                                 .end(123)
 *                                                                 .build())
 *                                                         .build())
 *                                                 .build()))
 *                                 .profileAttributes(ProfileAttributesProperty.builder()
 *                                         .accountNumber(ProfileDimensionProperty.builder()
 *                                                 .dimensionType("dimensionType")
 *                                                 .values(List.of("values"))
 *                                                 .build())
 *                                         .additionalInformation(ExtraLengthValueProfileDimensionProperty.builder()
 *                                                 .dimensionType("dimensionType")
 *                                                 .values(List.of("values"))
 *                                                 .build())
 *                                         .address(AddressDimensionProperty.builder()
 *                                                 .city(ProfileDimensionProperty.builder()
 *                                                         .dimensionType("dimensionType")
 *                                                         .values(List.of("values"))
 *                                                         .build())
 *                                                 .country(ProfileDimensionProperty.builder()
 *                                                         .dimensionType("dimensionType")
 *                                                         .values(List.of("values"))
 *                                                         .build())
 *                                                 .county(ProfileDimensionProperty.builder()
 *                                                         .dimensionType("dimensionType")
 *                                                         .values(List.of("values"))
 *                                                         .build())
 *                                                 .postalCode(ProfileDimensionProperty.builder()
 *                                                         .dimensionType("dimensionType")
 *                                                         .values(List.of("values"))
 *                                                         .build())
 *                                                 .province(ProfileDimensionProperty.builder()
 *                                                         .dimensionType("dimensionType")
 *                                                         .values(List.of("values"))
 *                                                         .build())
 *                                                 .state(ProfileDimensionProperty.builder()
 *                                                         .dimensionType("dimensionType")
 *                                                         .values(List.of("values"))
 *                                                         .build())
 *                                                 .build())
 *                                         .attributes(Map.of(
 *                                                 "attributesKey", AttributeDimensionProperty.builder()
 *                                                         .dimensionType("dimensionType")
 *                                                         .values(List.of("values"))
 *                                                         .build()))
 *                                         .billingAddress(AddressDimensionProperty.builder()
 *                                                 .city(ProfileDimensionProperty.builder()
 *                                                         .dimensionType("dimensionType")
 *                                                         .values(List.of("values"))
 *                                                         .build())
 *                                                 .country(ProfileDimensionProperty.builder()
 *                                                         .dimensionType("dimensionType")
 *                                                         .values(List.of("values"))
 *                                                         .build())
 *                                                 .county(ProfileDimensionProperty.builder()
 *                                                         .dimensionType("dimensionType")
 *                                                         .values(List.of("values"))
 *                                                         .build())
 *                                                 .postalCode(ProfileDimensionProperty.builder()
 *                                                         .dimensionType("dimensionType")
 *                                                         .values(List.of("values"))
 *                                                         .build())
 *                                                 .province(ProfileDimensionProperty.builder()
 *                                                         .dimensionType("dimensionType")
 *                                                         .values(List.of("values"))
 *                                                         .build())
 *                                                 .state(ProfileDimensionProperty.builder()
 *                                                         .dimensionType("dimensionType")
 *                                                         .values(List.of("values"))
 *                                                         .build())
 *                                                 .build())
 *                                         .birthDate(DateDimensionProperty.builder()
 *                                                 .dimensionType("dimensionType")
 *                                                 .values(List.of("values"))
 *                                                 .build())
 *                                         .businessEmailAddress(ProfileDimensionProperty.builder()
 *                                                 .dimensionType("dimensionType")
 *                                                 .values(List.of("values"))
 *                                                 .build())
 *                                         .businessName(ProfileDimensionProperty.builder()
 *                                                 .dimensionType("dimensionType")
 *                                                 .values(List.of("values"))
 *                                                 .build())
 *                                         .businessPhoneNumber(ProfileDimensionProperty.builder()
 *                                                 .dimensionType("dimensionType")
 *                                                 .values(List.of("values"))
 *                                                 .build())
 *                                         .emailAddress(ProfileDimensionProperty.builder()
 *                                                 .dimensionType("dimensionType")
 *                                                 .values(List.of("values"))
 *                                                 .build())
 *                                         .firstName(ProfileDimensionProperty.builder()
 *                                                 .dimensionType("dimensionType")
 *                                                 .values(List.of("values"))
 *                                                 .build())
 *                                         .genderString(ProfileDimensionProperty.builder()
 *                                                 .dimensionType("dimensionType")
 *                                                 .values(List.of("values"))
 *                                                 .build())
 *                                         .homePhoneNumber(ProfileDimensionProperty.builder()
 *                                                 .dimensionType("dimensionType")
 *                                                 .values(List.of("values"))
 *                                                 .build())
 *                                         .lastName(ProfileDimensionProperty.builder()
 *                                                 .dimensionType("dimensionType")
 *                                                 .values(List.of("values"))
 *                                                 .build())
 *                                         .mailingAddress(AddressDimensionProperty.builder()
 *                                                 .city(ProfileDimensionProperty.builder()
 *                                                         .dimensionType("dimensionType")
 *                                                         .values(List.of("values"))
 *                                                         .build())
 *                                                 .country(ProfileDimensionProperty.builder()
 *                                                         .dimensionType("dimensionType")
 *                                                         .values(List.of("values"))
 *                                                         .build())
 *                                                 .county(ProfileDimensionProperty.builder()
 *                                                         .dimensionType("dimensionType")
 *                                                         .values(List.of("values"))
 *                                                         .build())
 *                                                 .postalCode(ProfileDimensionProperty.builder()
 *                                                         .dimensionType("dimensionType")
 *                                                         .values(List.of("values"))
 *                                                         .build())
 *                                                 .province(ProfileDimensionProperty.builder()
 *                                                         .dimensionType("dimensionType")
 *                                                         .values(List.of("values"))
 *                                                         .build())
 *                                                 .state(ProfileDimensionProperty.builder()
 *                                                         .dimensionType("dimensionType")
 *                                                         .values(List.of("values"))
 *                                                         .build())
 *                                                 .build())
 *                                         .middleName(ProfileDimensionProperty.builder()
 *                                                 .dimensionType("dimensionType")
 *                                                 .values(List.of("values"))
 *                                                 .build())
 *                                         .mobilePhoneNumber(ProfileDimensionProperty.builder()
 *                                                 .dimensionType("dimensionType")
 *                                                 .values(List.of("values"))
 *                                                 .build())
 *                                         .partyTypeString(ProfileDimensionProperty.builder()
 *                                                 .dimensionType("dimensionType")
 *                                                 .values(List.of("values"))
 *                                                 .build())
 *                                         .personalEmailAddress(ProfileDimensionProperty.builder()
 *                                                 .dimensionType("dimensionType")
 *                                                 .values(List.of("values"))
 *                                                 .build())
 *                                         .phoneNumber(ProfileDimensionProperty.builder()
 *                                                 .dimensionType("dimensionType")
 *                                                 .values(List.of("values"))
 *                                                 .build())
 *                                         .shippingAddress(AddressDimensionProperty.builder()
 *                                                 .city(ProfileDimensionProperty.builder()
 *                                                         .dimensionType("dimensionType")
 *                                                         .values(List.of("values"))
 *                                                         .build())
 *                                                 .country(ProfileDimensionProperty.builder()
 *                                                         .dimensionType("dimensionType")
 *                                                         .values(List.of("values"))
 *                                                         .build())
 *                                                 .county(ProfileDimensionProperty.builder()
 *                                                         .dimensionType("dimensionType")
 *                                                         .values(List.of("values"))
 *                                                         .build())
 *                                                 .postalCode(ProfileDimensionProperty.builder()
 *                                                         .dimensionType("dimensionType")
 *                                                         .values(List.of("values"))
 *                                                         .build())
 *                                                 .province(ProfileDimensionProperty.builder()
 *                                                         .dimensionType("dimensionType")
 *                                                         .values(List.of("values"))
 *                                                         .build())
 *                                                 .state(ProfileDimensionProperty.builder()
 *                                                         .dimensionType("dimensionType")
 *                                                         .values(List.of("values"))
 *                                                         .build())
 *                                                 .build())
 *                                         .build())
 *                                 .build()))
 *                         .sourceSegments(List.of(SourceSegmentProperty.builder()
 *                                 .segmentDefinitionName("segmentDefinitionName")
 *                                 .build()))
 *                         .sourceType("sourceType")
 *                         .type("type")
 *                         .build()))
 *                 .include("include")
 *                 .build())
 *         // the properties below are optional
 *         .description("description")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-segmentdefinition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-segmentdefinition.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:09.967Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_customerprofiles.CfnSegmentDefinition")
public class CfnSegmentDefinition extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnSegmentDefinition(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnSegmentDefinition(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.customerprofiles.CfnSegmentDefinition.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnSegmentDefinition(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.customerprofiles.CfnSegmentDefinitionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * When the segment definition was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrCreatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The arn of the segment definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrSegmentDefinitionArn() {
        return software.amazon.jsii.Kernel.get(this, "attrSegmentDefinitionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Display name of the segment definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDisplayName() {
        return software.amazon.jsii.Kernel.get(this, "displayName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Display name of the segment definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDisplayName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "displayName", java.util.Objects.requireNonNull(value, "displayName is required"));
    }

    /**
     * The name of the domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDomainName() {
        return software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDomainName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "domainName", java.util.Objects.requireNonNull(value, "domainName is required"));
    }

    /**
     * Name of the segment definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getSegmentDefinitionName() {
        return software.amazon.jsii.Kernel.get(this, "segmentDefinitionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Name of the segment definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSegmentDefinitionName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "segmentDefinitionName", java.util.Objects.requireNonNull(value, "segmentDefinitionName is required"));
    }

    /**
     * Contains all groups of the segment definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getSegmentGroups() {
        return software.amazon.jsii.Kernel.get(this, "segmentGroups", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Contains all groups of the segment definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSegmentGroups(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "segmentGroups", java.util.Objects.requireNonNull(value, "segmentGroups is required"));
    }

    /**
     * Contains all groups of the segment definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSegmentGroups(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.customerprofiles.CfnSegmentDefinition.SegmentGroupProperty value) {
        software.amazon.jsii.Kernel.set(this, "segmentGroups", java.util.Objects.requireNonNull(value, "segmentGroups is required"));
    }

    /**
     * The description of the segment definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The description of the segment definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * The tags belonging to the segment definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The tags belonging to the segment definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * Object that segments on Customer Profile's address object.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.customerprofiles.*;
     * AddressDimensionProperty addressDimensionProperty = AddressDimensionProperty.builder()
     *         .city(ProfileDimensionProperty.builder()
     *                 .dimensionType("dimensionType")
     *                 .values(List.of("values"))
     *                 .build())
     *         .country(ProfileDimensionProperty.builder()
     *                 .dimensionType("dimensionType")
     *                 .values(List.of("values"))
     *                 .build())
     *         .county(ProfileDimensionProperty.builder()
     *                 .dimensionType("dimensionType")
     *                 .values(List.of("values"))
     *                 .build())
     *         .postalCode(ProfileDimensionProperty.builder()
     *                 .dimensionType("dimensionType")
     *                 .values(List.of("values"))
     *                 .build())
     *         .province(ProfileDimensionProperty.builder()
     *                 .dimensionType("dimensionType")
     *                 .values(List.of("values"))
     *                 .build())
     *         .state(ProfileDimensionProperty.builder()
     *                 .dimensionType("dimensionType")
     *                 .values(List.of("values"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-addressdimension.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-addressdimension.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_customerprofiles.CfnSegmentDefinition.AddressDimensionProperty")
    @software.amazon.jsii.Jsii.Proxy(AddressDimensionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AddressDimensionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The city belonging to the address.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-addressdimension.html#cfn-customerprofiles-segmentdefinition-addressdimension-city">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-addressdimension.html#cfn-customerprofiles-segmentdefinition-addressdimension-city</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCity() {
            return null;
        }

        /**
         * The country belonging to the address.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-addressdimension.html#cfn-customerprofiles-segmentdefinition-addressdimension-country">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-addressdimension.html#cfn-customerprofiles-segmentdefinition-addressdimension-country</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCountry() {
            return null;
        }

        /**
         * The county belonging to the address.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-addressdimension.html#cfn-customerprofiles-segmentdefinition-addressdimension-county">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-addressdimension.html#cfn-customerprofiles-segmentdefinition-addressdimension-county</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCounty() {
            return null;
        }

        /**
         * The postal code belonging to the address.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-addressdimension.html#cfn-customerprofiles-segmentdefinition-addressdimension-postalcode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-addressdimension.html#cfn-customerprofiles-segmentdefinition-addressdimension-postalcode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPostalCode() {
            return null;
        }

        /**
         * The province belonging to the address.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-addressdimension.html#cfn-customerprofiles-segmentdefinition-addressdimension-province">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-addressdimension.html#cfn-customerprofiles-segmentdefinition-addressdimension-province</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getProvince() {
            return null;
        }

        /**
         * The state belonging to the address.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-addressdimension.html#cfn-customerprofiles-segmentdefinition-addressdimension-state">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-addressdimension.html#cfn-customerprofiles-segmentdefinition-addressdimension-state</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getState() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AddressDimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AddressDimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AddressDimensionProperty> {
            java.lang.Object city;
            java.lang.Object country;
            java.lang.Object county;
            java.lang.Object postalCode;
            java.lang.Object province;
            java.lang.Object state;

            /**
             * Sets the value of {@link AddressDimensionProperty#getCity}
             * @param city The city belonging to the address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder city(software.amazon.awscdk.IResolvable city) {
                this.city = city;
                return this;
            }

            /**
             * Sets the value of {@link AddressDimensionProperty#getCity}
             * @param city The city belonging to the address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder city(software.amazon.awscdk.services.customerprofiles.CfnSegmentDefinition.ProfileDimensionProperty city) {
                this.city = city;
                return this;
            }

            /**
             * Sets the value of {@link AddressDimensionProperty#getCountry}
             * @param country The country belonging to the address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder country(software.amazon.awscdk.IResolvable country) {
                this.country = country;
                return this;
            }

            /**
             * Sets the value of {@link AddressDimensionProperty#getCountry}
             * @param country The country belonging to the address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder country(software.amazon.awscdk.services.customerprofiles.CfnSegmentDefinition.ProfileDimensionProperty country) {
                this.country = country;
                return this;
            }

            /**
             * Sets the value of {@link AddressDimensionProperty#getCounty}
             * @param county The county belonging to the address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder county(software.amazon.awscdk.IResolvable county) {
                this.county = county;
                return this;
            }

            /**
             * Sets the value of {@link AddressDimensionProperty#getCounty}
             * @param county The county belonging to the address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder county(software.amazon.awscdk.services.customerprofiles.CfnSegmentDefinition.ProfileDimensionProperty county) {
                this.county = county;
                return this;
            }

            /**
             * Sets the value of {@link AddressDimensionProperty#getPostalCode}
             * @param postalCode The postal code belonging to the address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder postalCode(software.amazon.awscdk.IResolvable postalCode) {
                this.postalCode = postalCode;
                return this;
            }

            /**
             * Sets the value of {@link AddressDimensionProperty#getPostalCode}
             * @param postalCode The postal code belonging to the address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder postalCode(software.amazon.awscdk.services.customerprofiles.CfnSegmentDefinition.ProfileDimensionProperty postalCode) {
                this.postalCode = postalCode;
                return this;
            }

            /**
             * Sets the value of {@link AddressDimensionProperty#getProvince}
             * @param province The province belonging to the address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder province(software.amazon.awscdk.IResolvable province) {
                this.province = province;
                return this;
            }

            /**
             * Sets the value of {@link AddressDimensionProperty#getProvince}
             * @param province The province belonging to the address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder province(software.amazon.awscdk.services.customerprofiles.CfnSegmentDefinition.ProfileDimensionProperty province) {
                this.province = province;
                return this;
            }

            /**
             * Sets the value of {@link AddressDimensionProperty#getState}
             * @param state The state belonging to the address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder state(software.amazon.awscdk.IResolvable state) {
                this.state = state;
                return this;
            }

            /**
             * Sets the value of {@link AddressDimensionProperty#getState}
             * @param state The state belonging to the address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder state(software.amazon.awscdk.services.customerprofiles.CfnSegmentDefinition.ProfileDimensionProperty state) {
                this.state = state;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AddressDimensionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AddressDimensionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AddressDimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AddressDimensionProperty {
            private final java.lang.Object city;
            private final java.lang.Object country;
            private final java.lang.Object county;
            private final java.lang.Object postalCode;
            private final java.lang.Object province;
            private final java.lang.Object state;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.city = software.amazon.jsii.Kernel.get(this, "city", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.country = software.amazon.jsii.Kernel.get(this, "country", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.county = software.amazon.jsii.Kernel.get(this, "county", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.postalCode = software.amazon.jsii.Kernel.get(this, "postalCode", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.province = software.amazon.jsii.Kernel.get(this, "province", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.state = software.amazon.jsii.Kernel.get(this, "state", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.city = builder.city;
                this.country = builder.country;
                this.county = builder.county;
                this.postalCode = builder.postalCode;
                this.province = builder.province;
                this.state = builder.state;
            }

            @Override
            public final java.lang.Object getCity() {
                return this.city;
            }

            @Override
            public final java.lang.Object getCountry() {
                return this.country;
            }

            @Override
            public final java.lang.Object getCounty() {
                return this.county;
            }

            @Override
            public final java.lang.Object getPostalCode() {
                return this.postalCode;
            }

            @Override
            public final java.lang.Object getProvince() {
                return this.province;
            }

            @Override
            public final java.lang.Object getState() {
                return this.state;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCity() != null) {
                    data.set("city", om.valueToTree(this.getCity()));
                }
                if (this.getCountry() != null) {
                    data.set("country", om.valueToTree(this.getCountry()));
                }
                if (this.getCounty() != null) {
                    data.set("county", om.valueToTree(this.getCounty()));
                }
                if (this.getPostalCode() != null) {
                    data.set("postalCode", om.valueToTree(this.getPostalCode()));
                }
                if (this.getProvince() != null) {
                    data.set("province", om.valueToTree(this.getProvince()));
                }
                if (this.getState() != null) {
                    data.set("state", om.valueToTree(this.getState()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_customerprofiles.CfnSegmentDefinition.AddressDimensionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AddressDimensionProperty.Jsii$Proxy that = (AddressDimensionProperty.Jsii$Proxy) o;

                if (this.city != null ? !this.city.equals(that.city) : that.city != null) return false;
                if (this.country != null ? !this.country.equals(that.country) : that.country != null) return false;
                if (this.county != null ? !this.county.equals(that.county) : that.county != null) return false;
                if (this.postalCode != null ? !this.postalCode.equals(that.postalCode) : that.postalCode != null) return false;
                if (this.province != null ? !this.province.equals(that.province) : that.province != null) return false;
                return this.state != null ? this.state.equals(that.state) : that.state == null;
            }

            @Override
            public final int hashCode() {
                int result = this.city != null ? this.city.hashCode() : 0;
                result = 31 * result + (this.country != null ? this.country.hashCode() : 0);
                result = 31 * result + (this.county != null ? this.county.hashCode() : 0);
                result = 31 * result + (this.postalCode != null ? this.postalCode.hashCode() : 0);
                result = 31 * result + (this.province != null ? this.province.hashCode() : 0);
                result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Object that defines how to filter the incoming objects for the calculated attribute.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.customerprofiles.*;
     * AttributeDimensionProperty attributeDimensionProperty = AttributeDimensionProperty.builder()
     *         .dimensionType("dimensionType")
     *         .values(List.of("values"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-attributedimension.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-attributedimension.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_customerprofiles.CfnSegmentDefinition.AttributeDimensionProperty")
    @software.amazon.jsii.Jsii.Proxy(AttributeDimensionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AttributeDimensionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The action to segment with.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-attributedimension.html#cfn-customerprofiles-segmentdefinition-attributedimension-dimensiontype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-attributedimension.html#cfn-customerprofiles-segmentdefinition-attributedimension-dimensiontype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDimensionType();

        /**
         * The values to apply the DimensionType on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-attributedimension.html#cfn-customerprofiles-segmentdefinition-attributedimension-values">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-attributedimension.html#cfn-customerprofiles-segmentdefinition-attributedimension-values</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getValues();

        /**
         * @return a {@link Builder} of {@link AttributeDimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AttributeDimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AttributeDimensionProperty> {
            java.lang.String dimensionType;
            java.util.List<java.lang.String> values;

            /**
             * Sets the value of {@link AttributeDimensionProperty#getDimensionType}
             * @param dimensionType The action to segment with. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dimensionType(java.lang.String dimensionType) {
                this.dimensionType = dimensionType;
                return this;
            }

            /**
             * Sets the value of {@link AttributeDimensionProperty#getValues}
             * @param values The values to apply the DimensionType on. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder values(java.util.List<java.lang.String> values) {
                this.values = values;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AttributeDimensionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AttributeDimensionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AttributeDimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AttributeDimensionProperty {
            private final java.lang.String dimensionType;
            private final java.util.List<java.lang.String> values;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dimensionType = software.amazon.jsii.Kernel.get(this, "dimensionType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.values = software.amazon.jsii.Kernel.get(this, "values", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dimensionType = java.util.Objects.requireNonNull(builder.dimensionType, "dimensionType is required");
                this.values = java.util.Objects.requireNonNull(builder.values, "values is required");
            }

            @Override
            public final java.lang.String getDimensionType() {
                return this.dimensionType;
            }

            @Override
            public final java.util.List<java.lang.String> getValues() {
                return this.values;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("dimensionType", om.valueToTree(this.getDimensionType()));
                data.set("values", om.valueToTree(this.getValues()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_customerprofiles.CfnSegmentDefinition.AttributeDimensionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AttributeDimensionProperty.Jsii$Proxy that = (AttributeDimensionProperty.Jsii$Proxy) o;

                if (!dimensionType.equals(that.dimensionType)) return false;
                return this.values.equals(that.values);
            }

            @Override
            public final int hashCode() {
                int result = this.dimensionType.hashCode();
                result = 31 * result + (this.values.hashCode());
                return result;
            }
        }
    }
    /**
     * Object that segments on Customer Profile's Calculated Attributes.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.customerprofiles.*;
     * CalculatedAttributeDimensionProperty calculatedAttributeDimensionProperty = CalculatedAttributeDimensionProperty.builder()
     *         .dimensionType("dimensionType")
     *         .values(List.of("values"))
     *         // the properties below are optional
     *         .conditionOverrides(ConditionOverridesProperty.builder()
     *                 .range(RangeOverrideProperty.builder()
     *                         .start(123)
     *                         .unit("unit")
     *                         // the properties below are optional
     *                         .end(123)
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-calculatedattributedimension.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-calculatedattributedimension.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_customerprofiles.CfnSegmentDefinition.CalculatedAttributeDimensionProperty")
    @software.amazon.jsii.Jsii.Proxy(CalculatedAttributeDimensionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CalculatedAttributeDimensionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The action to segment with.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-calculatedattributedimension.html#cfn-customerprofiles-segmentdefinition-calculatedattributedimension-dimensiontype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-calculatedattributedimension.html#cfn-customerprofiles-segmentdefinition-calculatedattributedimension-dimensiontype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDimensionType();

        /**
         * The values to apply the DimensionType with.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-calculatedattributedimension.html#cfn-customerprofiles-segmentdefinition-calculatedattributedimension-values">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-calculatedattributedimension.html#cfn-customerprofiles-segmentdefinition-calculatedattributedimension-values</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getValues();

        /**
         * Applies the given condition over the initial Calculated Attribute's definition.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-calculatedattributedimension.html#cfn-customerprofiles-segmentdefinition-calculatedattributedimension-conditionoverrides">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-calculatedattributedimension.html#cfn-customerprofiles-segmentdefinition-calculatedattributedimension-conditionoverrides</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConditionOverrides() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CalculatedAttributeDimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CalculatedAttributeDimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CalculatedAttributeDimensionProperty> {
            java.lang.String dimensionType;
            java.util.List<java.lang.String> values;
            java.lang.Object conditionOverrides;

            /**
             * Sets the value of {@link CalculatedAttributeDimensionProperty#getDimensionType}
             * @param dimensionType The action to segment with. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dimensionType(java.lang.String dimensionType) {
                this.dimensionType = dimensionType;
                return this;
            }

            /**
             * Sets the value of {@link CalculatedAttributeDimensionProperty#getValues}
             * @param values The values to apply the DimensionType with. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder values(java.util.List<java.lang.String> values) {
                this.values = values;
                return this;
            }

            /**
             * Sets the value of {@link CalculatedAttributeDimensionProperty#getConditionOverrides}
             * @param conditionOverrides Applies the given condition over the initial Calculated Attribute's definition.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder conditionOverrides(software.amazon.awscdk.IResolvable conditionOverrides) {
                this.conditionOverrides = conditionOverrides;
                return this;
            }

            /**
             * Sets the value of {@link CalculatedAttributeDimensionProperty#getConditionOverrides}
             * @param conditionOverrides Applies the given condition over the initial Calculated Attribute's definition.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder conditionOverrides(software.amazon.awscdk.services.customerprofiles.CfnSegmentDefinition.ConditionOverridesProperty conditionOverrides) {
                this.conditionOverrides = conditionOverrides;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CalculatedAttributeDimensionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CalculatedAttributeDimensionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CalculatedAttributeDimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CalculatedAttributeDimensionProperty {
            private final java.lang.String dimensionType;
            private final java.util.List<java.lang.String> values;
            private final java.lang.Object conditionOverrides;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dimensionType = software.amazon.jsii.Kernel.get(this, "dimensionType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.values = software.amazon.jsii.Kernel.get(this, "values", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.conditionOverrides = software.amazon.jsii.Kernel.get(this, "conditionOverrides", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dimensionType = java.util.Objects.requireNonNull(builder.dimensionType, "dimensionType is required");
                this.values = java.util.Objects.requireNonNull(builder.values, "values is required");
                this.conditionOverrides = builder.conditionOverrides;
            }

            @Override
            public final java.lang.String getDimensionType() {
                return this.dimensionType;
            }

            @Override
            public final java.util.List<java.lang.String> getValues() {
                return this.values;
            }

            @Override
            public final java.lang.Object getConditionOverrides() {
                return this.conditionOverrides;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("dimensionType", om.valueToTree(this.getDimensionType()));
                data.set("values", om.valueToTree(this.getValues()));
                if (this.getConditionOverrides() != null) {
                    data.set("conditionOverrides", om.valueToTree(this.getConditionOverrides()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_customerprofiles.CfnSegmentDefinition.CalculatedAttributeDimensionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CalculatedAttributeDimensionProperty.Jsii$Proxy that = (CalculatedAttributeDimensionProperty.Jsii$Proxy) o;

                if (!dimensionType.equals(that.dimensionType)) return false;
                if (!values.equals(that.values)) return false;
                return this.conditionOverrides != null ? this.conditionOverrides.equals(that.conditionOverrides) : that.conditionOverrides == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dimensionType.hashCode();
                result = 31 * result + (this.values.hashCode());
                result = 31 * result + (this.conditionOverrides != null ? this.conditionOverrides.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object to override the original condition block of a calculated attribute.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.customerprofiles.*;
     * ConditionOverridesProperty conditionOverridesProperty = ConditionOverridesProperty.builder()
     *         .range(RangeOverrideProperty.builder()
     *                 .start(123)
     *                 .unit("unit")
     *                 // the properties below are optional
     *                 .end(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-conditionoverrides.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-conditionoverrides.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_customerprofiles.CfnSegmentDefinition.ConditionOverridesProperty")
    @software.amazon.jsii.Jsii.Proxy(ConditionOverridesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConditionOverridesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The relative time period over which data is included in the aggregation for this override.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-conditionoverrides.html#cfn-customerprofiles-segmentdefinition-conditionoverrides-range">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-conditionoverrides.html#cfn-customerprofiles-segmentdefinition-conditionoverrides-range</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRange() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConditionOverridesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConditionOverridesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConditionOverridesProperty> {
            java.lang.Object range;

            /**
             * Sets the value of {@link ConditionOverridesProperty#getRange}
             * @param range The relative time period over which data is included in the aggregation for this override.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder range(software.amazon.awscdk.IResolvable range) {
                this.range = range;
                return this;
            }

            /**
             * Sets the value of {@link ConditionOverridesProperty#getRange}
             * @param range The relative time period over which data is included in the aggregation for this override.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder range(software.amazon.awscdk.services.customerprofiles.CfnSegmentDefinition.RangeOverrideProperty range) {
                this.range = range;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConditionOverridesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConditionOverridesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConditionOverridesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConditionOverridesProperty {
            private final java.lang.Object range;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.range = software.amazon.jsii.Kernel.get(this, "range", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.range = builder.range;
            }

            @Override
            public final java.lang.Object getRange() {
                return this.range;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getRange() != null) {
                    data.set("range", om.valueToTree(this.getRange()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_customerprofiles.CfnSegmentDefinition.ConditionOverridesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConditionOverridesProperty.Jsii$Proxy that = (ConditionOverridesProperty.Jsii$Proxy) o;

                return this.range != null ? this.range.equals(that.range) : that.range == null;
            }

            @Override
            public final int hashCode() {
                int result = this.range != null ? this.range.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Object that segments on various Customer Profile's date fields.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.customerprofiles.*;
     * DateDimensionProperty dateDimensionProperty = DateDimensionProperty.builder()
     *         .dimensionType("dimensionType")
     *         .values(List.of("values"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-datedimension.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-datedimension.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_customerprofiles.CfnSegmentDefinition.DateDimensionProperty")
    @software.amazon.jsii.Jsii.Proxy(DateDimensionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DateDimensionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The action to segment on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-datedimension.html#cfn-customerprofiles-segmentdefinition-datedimension-dimensiontype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-datedimension.html#cfn-customerprofiles-segmentdefinition-datedimension-dimensiontype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDimensionType();

        /**
         * The values to apply the DimensionType on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-datedimension.html#cfn-customerprofiles-segmentdefinition-datedimension-values">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-datedimension.html#cfn-customerprofiles-segmentdefinition-datedimension-values</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getValues();

        /**
         * @return a {@link Builder} of {@link DateDimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DateDimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DateDimensionProperty> {
            java.lang.String dimensionType;
            java.util.List<java.lang.String> values;

            /**
             * Sets the value of {@link DateDimensionProperty#getDimensionType}
             * @param dimensionType The action to segment on. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dimensionType(java.lang.String dimensionType) {
                this.dimensionType = dimensionType;
                return this;
            }

            /**
             * Sets the value of {@link DateDimensionProperty#getValues}
             * @param values The values to apply the DimensionType on. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder values(java.util.List<java.lang.String> values) {
                this.values = values;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DateDimensionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DateDimensionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DateDimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DateDimensionProperty {
            private final java.lang.String dimensionType;
            private final java.util.List<java.lang.String> values;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dimensionType = software.amazon.jsii.Kernel.get(this, "dimensionType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.values = software.amazon.jsii.Kernel.get(this, "values", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dimensionType = java.util.Objects.requireNonNull(builder.dimensionType, "dimensionType is required");
                this.values = java.util.Objects.requireNonNull(builder.values, "values is required");
            }

            @Override
            public final java.lang.String getDimensionType() {
                return this.dimensionType;
            }

            @Override
            public final java.util.List<java.lang.String> getValues() {
                return this.values;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("dimensionType", om.valueToTree(this.getDimensionType()));
                data.set("values", om.valueToTree(this.getValues()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_customerprofiles.CfnSegmentDefinition.DateDimensionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DateDimensionProperty.Jsii$Proxy that = (DateDimensionProperty.Jsii$Proxy) o;

                if (!dimensionType.equals(that.dimensionType)) return false;
                return this.values.equals(that.values);
            }

            @Override
            public final int hashCode() {
                int result = this.dimensionType.hashCode();
                result = 31 * result + (this.values.hashCode());
                return result;
            }
        }
    }
    /**
     * Defines the attribute to segment on.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.customerprofiles.*;
     * DimensionProperty dimensionProperty = DimensionProperty.builder()
     *         .calculatedAttributes(Map.of(
     *                 "calculatedAttributesKey", CalculatedAttributeDimensionProperty.builder()
     *                         .dimensionType("dimensionType")
     *                         .values(List.of("values"))
     *                         // the properties below are optional
     *                         .conditionOverrides(ConditionOverridesProperty.builder()
     *                                 .range(RangeOverrideProperty.builder()
     *                                         .start(123)
     *                                         .unit("unit")
     *                                         // the properties below are optional
     *                                         .end(123)
     *                                         .build())
     *                                 .build())
     *                         .build()))
     *         .profileAttributes(ProfileAttributesProperty.builder()
     *                 .accountNumber(ProfileDimensionProperty.builder()
     *                         .dimensionType("dimensionType")
     *                         .values(List.of("values"))
     *                         .build())
     *                 .additionalInformation(ExtraLengthValueProfileDimensionProperty.builder()
     *                         .dimensionType("dimensionType")
     *                         .values(List.of("values"))
     *                         .build())
     *                 .address(AddressDimensionProperty.builder()
     *                         .city(ProfileDimensionProperty.builder()
     *                                 .dimensionType("dimensionType")
     *                                 .values(List.of("values"))
     *                                 .build())
     *                         .country(ProfileDimensionProperty.builder()
     *                                 .dimensionType("dimensionType")
     *                                 .values(List.of("values"))
     *                                 .build())
     *                         .county(ProfileDimensionProperty.builder()
     *                                 .dimensionType("dimensionType")
     *                                 .values(List.of("values"))
     *                                 .build())
     *                         .postalCode(ProfileDimensionProperty.builder()
     *                                 .dimensionType("dimensionType")
     *                                 .values(List.of("values"))
     *                                 .build())
     *                         .province(ProfileDimensionProperty.builder()
     *                                 .dimensionType("dimensionType")
     *                                 .values(List.of("values"))
     *                                 .build())
     *                         .state(ProfileDimensionProperty.builder()
     *                                 .dimensionType("dimensionType")
     *                                 .values(List.of("values"))
     *                                 .build())
     *                         .build())
     *                 .attributes(Map.of(
     *                         "attributesKey", AttributeDimensionProperty.builder()
     *                                 .dimensionType("dimensionType")
     *                                 .values(List.of("values"))
     *                                 .build()))
     *                 .billingAddress(AddressDimensionProperty.builder()
     *                         .city(ProfileDimensionProperty.builder()
     *                                 .dimensionType("dimensionType")
     *                                 .values(List.of("values"))
     *                                 .build())
     *                         .country(ProfileDimensionProperty.builder()
     *                                 .dimensionType("dimensionType")
     *                                 .values(List.of("values"))
     *                                 .build())
     *                         .county(ProfileDimensionProperty.builder()
     *                                 .dimensionType("dimensionType")
     *                                 .values(List.of("values"))
     *                                 .build())
     *                         .postalCode(ProfileDimensionProperty.builder()
     *                                 .dimensionType("dimensionType")
     *                                 .values(List.of("values"))
     *                                 .build())
     *                         .province(ProfileDimensionProperty.builder()
     *                                 .dimensionType("dimensionType")
     *                                 .values(List.of("values"))
     *                                 .build())
     *                         .state(ProfileDimensionProperty.builder()
     *                                 .dimensionType("dimensionType")
     *                                 .values(List.of("values"))
     *                                 .build())
     *                         .build())
     *                 .birthDate(DateDimensionProperty.builder()
     *                         .dimensionType("dimensionType")
     *                         .values(List.of("values"))
     *                         .build())
     *                 .businessEmailAddress(ProfileDimensionProperty.builder()
     *                         .dimensionType("dimensionType")
     *                         .values(List.of("values"))
     *                         .build())
     *                 .businessName(ProfileDimensionProperty.builder()
     *                         .dimensionType("dimensionType")
     *                         .values(List.of("values"))
     *                         .build())
     *                 .businessPhoneNumber(ProfileDimensionProperty.builder()
     *                         .dimensionType("dimensionType")
     *                         .values(List.of("values"))
     *                         .build())
     *                 .emailAddress(ProfileDimensionProperty.builder()
     *                         .dimensionType("dimensionType")
     *                         .values(List.of("values"))
     *                         .build())
     *                 .firstName(ProfileDimensionProperty.builder()
     *                         .dimensionType("dimensionType")
     *                         .values(List.of("values"))
     *                         .build())
     *                 .genderString(ProfileDimensionProperty.builder()
     *                         .dimensionType("dimensionType")
     *                         .values(List.of("values"))
     *                         .build())
     *                 .homePhoneNumber(ProfileDimensionProperty.builder()
     *                         .dimensionType("dimensionType")
     *                         .values(List.of("values"))
     *                         .build())
     *                 .lastName(ProfileDimensionProperty.builder()
     *                         .dimensionType("dimensionType")
     *                         .values(List.of("values"))
     *                         .build())
     *                 .mailingAddress(AddressDimensionProperty.builder()
     *                         .city(ProfileDimensionProperty.builder()
     *                                 .dimensionType("dimensionType")
     *                                 .values(List.of("values"))
     *                                 .build())
     *                         .country(ProfileDimensionProperty.builder()
     *                                 .dimensionType("dimensionType")
     *                                 .values(List.of("values"))
     *                                 .build())
     *                         .county(ProfileDimensionProperty.builder()
     *                                 .dimensionType("dimensionType")
     *                                 .values(List.of("values"))
     *                                 .build())
     *                         .postalCode(ProfileDimensionProperty.builder()
     *                                 .dimensionType("dimensionType")
     *                                 .values(List.of("values"))
     *                                 .build())
     *                         .province(ProfileDimensionProperty.builder()
     *                                 .dimensionType("dimensionType")
     *                                 .values(List.of("values"))
     *                                 .build())
     *                         .state(ProfileDimensionProperty.builder()
     *                                 .dimensionType("dimensionType")
     *                                 .values(List.of("values"))
     *                                 .build())
     *                         .build())
     *                 .middleName(ProfileDimensionProperty.builder()
     *                         .dimensionType("dimensionType")
     *                         .values(List.of("values"))
     *                         .build())
     *                 .mobilePhoneNumber(ProfileDimensionProperty.builder()
     *                         .dimensionType("dimensionType")
     *                         .values(List.of("values"))
     *                         .build())
     *                 .partyTypeString(ProfileDimensionProperty.builder()
     *                         .dimensionType("dimensionType")
     *                         .values(List.of("values"))
     *                         .build())
     *                 .personalEmailAddress(ProfileDimensionProperty.builder()
     *                         .dimensionType("dimensionType")
     *                         .values(List.of("values"))
     *                         .build())
     *                 .phoneNumber(ProfileDimensionProperty.builder()
     *                         .dimensionType("dimensionType")
     *                         .values(List.of("values"))
     *                         .build())
     *                 .shippingAddress(AddressDimensionProperty.builder()
     *                         .city(ProfileDimensionProperty.builder()
     *                                 .dimensionType("dimensionType")
     *                                 .values(List.of("values"))
     *                                 .build())
     *                         .country(ProfileDimensionProperty.builder()
     *                                 .dimensionType("dimensionType")
     *                                 .values(List.of("values"))
     *                                 .build())
     *                         .county(ProfileDimensionProperty.builder()
     *                                 .dimensionType("dimensionType")
     *                                 .values(List.of("values"))
     *                                 .build())
     *                         .postalCode(ProfileDimensionProperty.builder()
     *                                 .dimensionType("dimensionType")
     *                                 .values(List.of("values"))
     *                                 .build())
     *                         .province(ProfileDimensionProperty.builder()
     *                                 .dimensionType("dimensionType")
     *                                 .values(List.of("values"))
     *                                 .build())
     *                         .state(ProfileDimensionProperty.builder()
     *                                 .dimensionType("dimensionType")
     *                                 .values(List.of("values"))
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-dimension.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-dimension.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_customerprofiles.CfnSegmentDefinition.DimensionProperty")
    @software.amazon.jsii.Jsii.Proxy(DimensionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DimensionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Object that holds the calculated attributes to segment on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-dimension.html#cfn-customerprofiles-segmentdefinition-dimension-calculatedattributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-dimension.html#cfn-customerprofiles-segmentdefinition-dimension-calculatedattributes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCalculatedAttributes() {
            return null;
        }

        /**
         * Object that holds the profile attributes to segment on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-dimension.html#cfn-customerprofiles-segmentdefinition-dimension-profileattributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-dimension.html#cfn-customerprofiles-segmentdefinition-dimension-profileattributes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getProfileAttributes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DimensionProperty> {
            java.lang.Object calculatedAttributes;
            java.lang.Object profileAttributes;

            /**
             * Sets the value of {@link DimensionProperty#getCalculatedAttributes}
             * @param calculatedAttributes Object that holds the calculated attributes to segment on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder calculatedAttributes(software.amazon.awscdk.IResolvable calculatedAttributes) {
                this.calculatedAttributes = calculatedAttributes;
                return this;
            }

            /**
             * Sets the value of {@link DimensionProperty#getCalculatedAttributes}
             * @param calculatedAttributes Object that holds the calculated attributes to segment on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder calculatedAttributes(java.util.Map<java.lang.String, ? extends java.lang.Object> calculatedAttributes) {
                this.calculatedAttributes = calculatedAttributes;
                return this;
            }

            /**
             * Sets the value of {@link DimensionProperty#getProfileAttributes}
             * @param profileAttributes Object that holds the profile attributes to segment on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder profileAttributes(software.amazon.awscdk.IResolvable profileAttributes) {
                this.profileAttributes = profileAttributes;
                return this;
            }

            /**
             * Sets the value of {@link DimensionProperty#getProfileAttributes}
             * @param profileAttributes Object that holds the profile attributes to segment on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder profileAttributes(software.amazon.awscdk.services.customerprofiles.CfnSegmentDefinition.ProfileAttributesProperty profileAttributes) {
                this.profileAttributes = profileAttributes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DimensionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DimensionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DimensionProperty {
            private final java.lang.Object calculatedAttributes;
            private final java.lang.Object profileAttributes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.calculatedAttributes = software.amazon.jsii.Kernel.get(this, "calculatedAttributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.profileAttributes = software.amazon.jsii.Kernel.get(this, "profileAttributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.calculatedAttributes = builder.calculatedAttributes;
                this.profileAttributes = builder.profileAttributes;
            }

            @Override
            public final java.lang.Object getCalculatedAttributes() {
                return this.calculatedAttributes;
            }

            @Override
            public final java.lang.Object getProfileAttributes() {
                return this.profileAttributes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCalculatedAttributes() != null) {
                    data.set("calculatedAttributes", om.valueToTree(this.getCalculatedAttributes()));
                }
                if (this.getProfileAttributes() != null) {
                    data.set("profileAttributes", om.valueToTree(this.getProfileAttributes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_customerprofiles.CfnSegmentDefinition.DimensionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DimensionProperty.Jsii$Proxy that = (DimensionProperty.Jsii$Proxy) o;

                if (this.calculatedAttributes != null ? !this.calculatedAttributes.equals(that.calculatedAttributes) : that.calculatedAttributes != null) return false;
                return this.profileAttributes != null ? this.profileAttributes.equals(that.profileAttributes) : that.profileAttributes == null;
            }

            @Override
            public final int hashCode() {
                int result = this.calculatedAttributes != null ? this.calculatedAttributes.hashCode() : 0;
                result = 31 * result + (this.profileAttributes != null ? this.profileAttributes.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Object that segments on various Customer profile's fields that are larger than normal.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.customerprofiles.*;
     * ExtraLengthValueProfileDimensionProperty extraLengthValueProfileDimensionProperty = ExtraLengthValueProfileDimensionProperty.builder()
     *         .dimensionType("dimensionType")
     *         .values(List.of("values"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-extralengthvalueprofiledimension.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-extralengthvalueprofiledimension.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_customerprofiles.CfnSegmentDefinition.ExtraLengthValueProfileDimensionProperty")
    @software.amazon.jsii.Jsii.Proxy(ExtraLengthValueProfileDimensionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ExtraLengthValueProfileDimensionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The action to segment with.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-extralengthvalueprofiledimension.html#cfn-customerprofiles-segmentdefinition-extralengthvalueprofiledimension-dimensiontype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-extralengthvalueprofiledimension.html#cfn-customerprofiles-segmentdefinition-extralengthvalueprofiledimension-dimensiontype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDimensionType();

        /**
         * The values to apply the DimensionType on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-extralengthvalueprofiledimension.html#cfn-customerprofiles-segmentdefinition-extralengthvalueprofiledimension-values">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-extralengthvalueprofiledimension.html#cfn-customerprofiles-segmentdefinition-extralengthvalueprofiledimension-values</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getValues();

        /**
         * @return a {@link Builder} of {@link ExtraLengthValueProfileDimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ExtraLengthValueProfileDimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ExtraLengthValueProfileDimensionProperty> {
            java.lang.String dimensionType;
            java.util.List<java.lang.String> values;

            /**
             * Sets the value of {@link ExtraLengthValueProfileDimensionProperty#getDimensionType}
             * @param dimensionType The action to segment with. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dimensionType(java.lang.String dimensionType) {
                this.dimensionType = dimensionType;
                return this;
            }

            /**
             * Sets the value of {@link ExtraLengthValueProfileDimensionProperty#getValues}
             * @param values The values to apply the DimensionType on. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder values(java.util.List<java.lang.String> values) {
                this.values = values;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ExtraLengthValueProfileDimensionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ExtraLengthValueProfileDimensionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ExtraLengthValueProfileDimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ExtraLengthValueProfileDimensionProperty {
            private final java.lang.String dimensionType;
            private final java.util.List<java.lang.String> values;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dimensionType = software.amazon.jsii.Kernel.get(this, "dimensionType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.values = software.amazon.jsii.Kernel.get(this, "values", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dimensionType = java.util.Objects.requireNonNull(builder.dimensionType, "dimensionType is required");
                this.values = java.util.Objects.requireNonNull(builder.values, "values is required");
            }

            @Override
            public final java.lang.String getDimensionType() {
                return this.dimensionType;
            }

            @Override
            public final java.util.List<java.lang.String> getValues() {
                return this.values;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("dimensionType", om.valueToTree(this.getDimensionType()));
                data.set("values", om.valueToTree(this.getValues()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_customerprofiles.CfnSegmentDefinition.ExtraLengthValueProfileDimensionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ExtraLengthValueProfileDimensionProperty.Jsii$Proxy that = (ExtraLengthValueProfileDimensionProperty.Jsii$Proxy) o;

                if (!dimensionType.equals(that.dimensionType)) return false;
                return this.values.equals(that.values);
            }

            @Override
            public final int hashCode() {
                int result = this.dimensionType.hashCode();
                result = 31 * result + (this.values.hashCode());
                return result;
            }
        }
    }
    /**
     * Contains dimensions that determine what to segment on.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.customerprofiles.*;
     * GroupProperty groupProperty = GroupProperty.builder()
     *         .dimensions(List.of(DimensionProperty.builder()
     *                 .calculatedAttributes(Map.of(
     *                         "calculatedAttributesKey", CalculatedAttributeDimensionProperty.builder()
     *                                 .dimensionType("dimensionType")
     *                                 .values(List.of("values"))
     *                                 // the properties below are optional
     *                                 .conditionOverrides(ConditionOverridesProperty.builder()
     *                                         .range(RangeOverrideProperty.builder()
     *                                                 .start(123)
     *                                                 .unit("unit")
     *                                                 // the properties below are optional
     *                                                 .end(123)
     *                                                 .build())
     *                                         .build())
     *                                 .build()))
     *                 .profileAttributes(ProfileAttributesProperty.builder()
     *                         .accountNumber(ProfileDimensionProperty.builder()
     *                                 .dimensionType("dimensionType")
     *                                 .values(List.of("values"))
     *                                 .build())
     *                         .additionalInformation(ExtraLengthValueProfileDimensionProperty.builder()
     *                                 .dimensionType("dimensionType")
     *                                 .values(List.of("values"))
     *                                 .build())
     *                         .address(AddressDimensionProperty.builder()
     *                                 .city(ProfileDimensionProperty.builder()
     *                                         .dimensionType("dimensionType")
     *                                         .values(List.of("values"))
     *                                         .build())
     *                                 .country(ProfileDimensionProperty.builder()
     *                                         .dimensionType("dimensionType")
     *                                         .values(List.of("values"))
     *                                         .build())
     *                                 .county(ProfileDimensionProperty.builder()
     *                                         .dimensionType("dimensionType")
     *                                         .values(List.of("values"))
     *                                         .build())
     *                                 .postalCode(ProfileDimensionProperty.builder()
     *                                         .dimensionType("dimensionType")
     *                                         .values(List.of("values"))
     *                                         .build())
     *                                 .province(ProfileDimensionProperty.builder()
     *                                         .dimensionType("dimensionType")
     *                                         .values(List.of("values"))
     *                                         .build())
     *                                 .state(ProfileDimensionProperty.builder()
     *                                         .dimensionType("dimensionType")
     *                                         .values(List.of("values"))
     *                                         .build())
     *                                 .build())
     *                         .attributes(Map.of(
     *                                 "attributesKey", AttributeDimensionProperty.builder()
     *                                         .dimensionType("dimensionType")
     *                                         .values(List.of("values"))
     *                                         .build()))
     *                         .billingAddress(AddressDimensionProperty.builder()
     *                                 .city(ProfileDimensionProperty.builder()
     *                                         .dimensionType("dimensionType")
     *                                         .values(List.of("values"))
     *                                         .build())
     *                                 .country(ProfileDimensionProperty.builder()
     *                                         .dimensionType("dimensionType")
     *                                         .values(List.of("values"))
     *                                         .build())
     *                                 .county(ProfileDimensionProperty.builder()
     *                                         .dimensionType("dimensionType")
     *                                         .values(List.of("values"))
     *                                         .build())
     *                                 .postalCode(ProfileDimensionProperty.builder()
     *                                         .dimensionType("dimensionType")
     *                                         .values(List.of("values"))
     *                                         .build())
     *                                 .province(ProfileDimensionProperty.builder()
     *                                         .dimensionType("dimensionType")
     *                                         .values(List.of("values"))
     *                                         .build())
     *                                 .state(ProfileDimensionProperty.builder()
     *                                         .dimensionType("dimensionType")
     *                                         .values(List.of("values"))
     *                                         .build())
     *                                 .build())
     *                         .birthDate(DateDimensionProperty.builder()
     *                                 .dimensionType("dimensionType")
     *                                 .values(List.of("values"))
     *                                 .build())
     *                         .businessEmailAddress(ProfileDimensionProperty.builder()
     *                                 .dimensionType("dimensionType")
     *                                 .values(List.of("values"))
     *                                 .build())
     *                         .businessName(ProfileDimensionProperty.builder()
     *                                 .dimensionType("dimensionType")
     *                                 .values(List.of("values"))
     *                                 .build())
     *                         .businessPhoneNumber(ProfileDimensionProperty.builder()
     *                                 .dimensionType("dimensionType")
     *                                 .values(List.of("values"))
     *                                 .build())
     *                         .emailAddress(ProfileDimensionProperty.builder()
     *                                 .dimensionType("dimensionType")
     *                                 .values(List.of("values"))
     *                                 .build())
     *                         .firstName(ProfileDimensionProperty.builder()
     *                                 .dimensionType("dimensionType")
     *                                 .values(List.of("values"))
     *                                 .build())
     *                         .genderString(ProfileDimensionProperty.builder()
     *                                 .dimensionType("dimensionType")
     *                                 .values(List.of("values"))
     *                                 .build())
     *                         .homePhoneNumber(ProfileDimensionProperty.builder()
     *                                 .dimensionType("dimensionType")
     *                                 .values(List.of("values"))
     *                                 .build())
     *                         .lastName(ProfileDimensionProperty.builder()
     *                                 .dimensionType("dimensionType")
     *                                 .values(List.of("values"))
     *                                 .build())
     *                         .mailingAddress(AddressDimensionProperty.builder()
     *                                 .city(ProfileDimensionProperty.builder()
     *                                         .dimensionType("dimensionType")
     *                                         .values(List.of("values"))
     *                                         .build())
     *                                 .country(ProfileDimensionProperty.builder()
     *                                         .dimensionType("dimensionType")
     *                                         .values(List.of("values"))
     *                                         .build())
     *                                 .county(ProfileDimensionProperty.builder()
     *                                         .dimensionType("dimensionType")
     *                                         .values(List.of("values"))
     *                                         .build())
     *                                 .postalCode(ProfileDimensionProperty.builder()
     *                                         .dimensionType("dimensionType")
     *                                         .values(List.of("values"))
     *                                         .build())
     *                                 .province(ProfileDimensionProperty.builder()
     *                                         .dimensionType("dimensionType")
     *                                         .values(List.of("values"))
     *                                         .build())
     *                                 .state(ProfileDimensionProperty.builder()
     *                                         .dimensionType("dimensionType")
     *                                         .values(List.of("values"))
     *                                         .build())
     *                                 .build())
     *                         .middleName(ProfileDimensionProperty.builder()
     *                                 .dimensionType("dimensionType")
     *                                 .values(List.of("values"))
     *                                 .build())
     *                         .mobilePhoneNumber(ProfileDimensionProperty.builder()
     *                                 .dimensionType("dimensionType")
     *                                 .values(List.of("values"))
     *                                 .build())
     *                         .partyTypeString(ProfileDimensionProperty.builder()
     *                                 .dimensionType("dimensionType")
     *                                 .values(List.of("values"))
     *                                 .build())
     *                         .personalEmailAddress(ProfileDimensionProperty.builder()
     *                                 .dimensionType("dimensionType")
     *                                 .values(List.of("values"))
     *                                 .build())
     *                         .phoneNumber(ProfileDimensionProperty.builder()
     *                                 .dimensionType("dimensionType")
     *                                 .values(List.of("values"))
     *                                 .build())
     *                         .shippingAddress(AddressDimensionProperty.builder()
     *                                 .city(ProfileDimensionProperty.builder()
     *                                         .dimensionType("dimensionType")
     *                                         .values(List.of("values"))
     *                                         .build())
     *                                 .country(ProfileDimensionProperty.builder()
     *                                         .dimensionType("dimensionType")
     *                                         .values(List.of("values"))
     *                                         .build())
     *                                 .county(ProfileDimensionProperty.builder()
     *                                         .dimensionType("dimensionType")
     *                                         .values(List.of("values"))
     *                                         .build())
     *                                 .postalCode(ProfileDimensionProperty.builder()
     *                                         .dimensionType("dimensionType")
     *                                         .values(List.of("values"))
     *                                         .build())
     *                                 .province(ProfileDimensionProperty.builder()
     *                                         .dimensionType("dimensionType")
     *                                         .values(List.of("values"))
     *                                         .build())
     *                                 .state(ProfileDimensionProperty.builder()
     *                                         .dimensionType("dimensionType")
     *                                         .values(List.of("values"))
     *                                         .build())
     *                                 .build())
     *                         .build())
     *                 .build()))
     *         .sourceSegments(List.of(SourceSegmentProperty.builder()
     *                 .segmentDefinitionName("segmentDefinitionName")
     *                 .build()))
     *         .sourceType("sourceType")
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-group.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-group.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_customerprofiles.CfnSegmentDefinition.GroupProperty")
    @software.amazon.jsii.Jsii.Proxy(GroupProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GroupProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Defines the attributes to segment on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-group.html#cfn-customerprofiles-segmentdefinition-group-dimensions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-group.html#cfn-customerprofiles-segmentdefinition-group-dimensions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDimensions() {
            return null;
        }

        /**
         * Defines the starting source of data.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-group.html#cfn-customerprofiles-segmentdefinition-group-sourcesegments">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-group.html#cfn-customerprofiles-segmentdefinition-group-sourcesegments</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSourceSegments() {
            return null;
        }

        /**
         * Defines how to interact with the source data.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-group.html#cfn-customerprofiles-segmentdefinition-group-sourcetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-group.html#cfn-customerprofiles-segmentdefinition-group-sourcetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSourceType() {
            return null;
        }

        /**
         * Defines how to interact with the profiles found in the current filtering.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-group.html#cfn-customerprofiles-segmentdefinition-group-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-group.html#cfn-customerprofiles-segmentdefinition-group-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GroupProperty> {
            java.lang.Object dimensions;
            java.lang.Object sourceSegments;
            java.lang.String sourceType;
            java.lang.String type;

            /**
             * Sets the value of {@link GroupProperty#getDimensions}
             * @param dimensions Defines the attributes to segment on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dimensions(software.amazon.awscdk.IResolvable dimensions) {
                this.dimensions = dimensions;
                return this;
            }

            /**
             * Sets the value of {@link GroupProperty#getDimensions}
             * @param dimensions Defines the attributes to segment on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dimensions(java.util.List<? extends java.lang.Object> dimensions) {
                this.dimensions = dimensions;
                return this;
            }

            /**
             * Sets the value of {@link GroupProperty#getSourceSegments}
             * @param sourceSegments Defines the starting source of data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceSegments(software.amazon.awscdk.IResolvable sourceSegments) {
                this.sourceSegments = sourceSegments;
                return this;
            }

            /**
             * Sets the value of {@link GroupProperty#getSourceSegments}
             * @param sourceSegments Defines the starting source of data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceSegments(java.util.List<? extends java.lang.Object> sourceSegments) {
                this.sourceSegments = sourceSegments;
                return this;
            }

            /**
             * Sets the value of {@link GroupProperty#getSourceType}
             * @param sourceType Defines how to interact with the source data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceType(java.lang.String sourceType) {
                this.sourceType = sourceType;
                return this;
            }

            /**
             * Sets the value of {@link GroupProperty#getType}
             * @param type Defines how to interact with the profiles found in the current filtering.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GroupProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GroupProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GroupProperty {
            private final java.lang.Object dimensions;
            private final java.lang.Object sourceSegments;
            private final java.lang.String sourceType;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dimensions = software.amazon.jsii.Kernel.get(this, "dimensions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sourceSegments = software.amazon.jsii.Kernel.get(this, "sourceSegments", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sourceType = software.amazon.jsii.Kernel.get(this, "sourceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dimensions = builder.dimensions;
                this.sourceSegments = builder.sourceSegments;
                this.sourceType = builder.sourceType;
                this.type = builder.type;
            }

            @Override
            public final java.lang.Object getDimensions() {
                return this.dimensions;
            }

            @Override
            public final java.lang.Object getSourceSegments() {
                return this.sourceSegments;
            }

            @Override
            public final java.lang.String getSourceType() {
                return this.sourceType;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDimensions() != null) {
                    data.set("dimensions", om.valueToTree(this.getDimensions()));
                }
                if (this.getSourceSegments() != null) {
                    data.set("sourceSegments", om.valueToTree(this.getSourceSegments()));
                }
                if (this.getSourceType() != null) {
                    data.set("sourceType", om.valueToTree(this.getSourceType()));
                }
                if (this.getType() != null) {
                    data.set("type", om.valueToTree(this.getType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_customerprofiles.CfnSegmentDefinition.GroupProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GroupProperty.Jsii$Proxy that = (GroupProperty.Jsii$Proxy) o;

                if (this.dimensions != null ? !this.dimensions.equals(that.dimensions) : that.dimensions != null) return false;
                if (this.sourceSegments != null ? !this.sourceSegments.equals(that.sourceSegments) : that.sourceSegments != null) return false;
                if (this.sourceType != null ? !this.sourceType.equals(that.sourceType) : that.sourceType != null) return false;
                return this.type != null ? this.type.equals(that.type) : that.type == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dimensions != null ? this.dimensions.hashCode() : 0;
                result = 31 * result + (this.sourceSegments != null ? this.sourceSegments.hashCode() : 0);
                result = 31 * result + (this.sourceType != null ? this.sourceType.hashCode() : 0);
                result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The object used to segment on attributes within the customer profile.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.customerprofiles.*;
     * ProfileAttributesProperty profileAttributesProperty = ProfileAttributesProperty.builder()
     *         .accountNumber(ProfileDimensionProperty.builder()
     *                 .dimensionType("dimensionType")
     *                 .values(List.of("values"))
     *                 .build())
     *         .additionalInformation(ExtraLengthValueProfileDimensionProperty.builder()
     *                 .dimensionType("dimensionType")
     *                 .values(List.of("values"))
     *                 .build())
     *         .address(AddressDimensionProperty.builder()
     *                 .city(ProfileDimensionProperty.builder()
     *                         .dimensionType("dimensionType")
     *                         .values(List.of("values"))
     *                         .build())
     *                 .country(ProfileDimensionProperty.builder()
     *                         .dimensionType("dimensionType")
     *                         .values(List.of("values"))
     *                         .build())
     *                 .county(ProfileDimensionProperty.builder()
     *                         .dimensionType("dimensionType")
     *                         .values(List.of("values"))
     *                         .build())
     *                 .postalCode(ProfileDimensionProperty.builder()
     *                         .dimensionType("dimensionType")
     *                         .values(List.of("values"))
     *                         .build())
     *                 .province(ProfileDimensionProperty.builder()
     *                         .dimensionType("dimensionType")
     *                         .values(List.of("values"))
     *                         .build())
     *                 .state(ProfileDimensionProperty.builder()
     *                         .dimensionType("dimensionType")
     *                         .values(List.of("values"))
     *                         .build())
     *                 .build())
     *         .attributes(Map.of(
     *                 "attributesKey", AttributeDimensionProperty.builder()
     *                         .dimensionType("dimensionType")
     *                         .values(List.of("values"))
     *                         .build()))
     *         .billingAddress(AddressDimensionProperty.builder()
     *                 .city(ProfileDimensionProperty.builder()
     *                         .dimensionType("dimensionType")
     *                         .values(List.of("values"))
     *                         .build())
     *                 .country(ProfileDimensionProperty.builder()
     *                         .dimensionType("dimensionType")
     *                         .values(List.of("values"))
     *                         .build())
     *                 .county(ProfileDimensionProperty.builder()
     *                         .dimensionType("dimensionType")
     *                         .values(List.of("values"))
     *                         .build())
     *                 .postalCode(ProfileDimensionProperty.builder()
     *                         .dimensionType("dimensionType")
     *                         .values(List.of("values"))
     *                         .build())
     *                 .province(ProfileDimensionProperty.builder()
     *                         .dimensionType("dimensionType")
     *                         .values(List.of("values"))
     *                         .build())
     *                 .state(ProfileDimensionProperty.builder()
     *                         .dimensionType("dimensionType")
     *                         .values(List.of("values"))
     *                         .build())
     *                 .build())
     *         .birthDate(DateDimensionProperty.builder()
     *                 .dimensionType("dimensionType")
     *                 .values(List.of("values"))
     *                 .build())
     *         .businessEmailAddress(ProfileDimensionProperty.builder()
     *                 .dimensionType("dimensionType")
     *                 .values(List.of("values"))
     *                 .build())
     *         .businessName(ProfileDimensionProperty.builder()
     *                 .dimensionType("dimensionType")
     *                 .values(List.of("values"))
     *                 .build())
     *         .businessPhoneNumber(ProfileDimensionProperty.builder()
     *                 .dimensionType("dimensionType")
     *                 .values(List.of("values"))
     *                 .build())
     *         .emailAddress(ProfileDimensionProperty.builder()
     *                 .dimensionType("dimensionType")
     *                 .values(List.of("values"))
     *                 .build())
     *         .firstName(ProfileDimensionProperty.builder()
     *                 .dimensionType("dimensionType")
     *                 .values(List.of("values"))
     *                 .build())
     *         .genderString(ProfileDimensionProperty.builder()
     *                 .dimensionType("dimensionType")
     *                 .values(List.of("values"))
     *                 .build())
     *         .homePhoneNumber(ProfileDimensionProperty.builder()
     *                 .dimensionType("dimensionType")
     *                 .values(List.of("values"))
     *                 .build())
     *         .lastName(ProfileDimensionProperty.builder()
     *                 .dimensionType("dimensionType")
     *                 .values(List.of("values"))
     *                 .build())
     *         .mailingAddress(AddressDimensionProperty.builder()
     *                 .city(ProfileDimensionProperty.builder()
     *                         .dimensionType("dimensionType")
     *                         .values(List.of("values"))
     *                         .build())
     *                 .country(ProfileDimensionProperty.builder()
     *                         .dimensionType("dimensionType")
     *                         .values(List.of("values"))
     *                         .build())
     *                 .county(ProfileDimensionProperty.builder()
     *                         .dimensionType("dimensionType")
     *                         .values(List.of("values"))
     *                         .build())
     *                 .postalCode(ProfileDimensionProperty.builder()
     *                         .dimensionType("dimensionType")
     *                         .values(List.of("values"))
     *                         .build())
     *                 .province(ProfileDimensionProperty.builder()
     *                         .dimensionType("dimensionType")
     *                         .values(List.of("values"))
     *                         .build())
     *                 .state(ProfileDimensionProperty.builder()
     *                         .dimensionType("dimensionType")
     *                         .values(List.of("values"))
     *                         .build())
     *                 .build())
     *         .middleName(ProfileDimensionProperty.builder()
     *                 .dimensionType("dimensionType")
     *                 .values(List.of("values"))
     *                 .build())
     *         .mobilePhoneNumber(ProfileDimensionProperty.builder()
     *                 .dimensionType("dimensionType")
     *                 .values(List.of("values"))
     *                 .build())
     *         .partyTypeString(ProfileDimensionProperty.builder()
     *                 .dimensionType("dimensionType")
     *                 .values(List.of("values"))
     *                 .build())
     *         .personalEmailAddress(ProfileDimensionProperty.builder()
     *                 .dimensionType("dimensionType")
     *                 .values(List.of("values"))
     *                 .build())
     *         .phoneNumber(ProfileDimensionProperty.builder()
     *                 .dimensionType("dimensionType")
     *                 .values(List.of("values"))
     *                 .build())
     *         .shippingAddress(AddressDimensionProperty.builder()
     *                 .city(ProfileDimensionProperty.builder()
     *                         .dimensionType("dimensionType")
     *                         .values(List.of("values"))
     *                         .build())
     *                 .country(ProfileDimensionProperty.builder()
     *                         .dimensionType("dimensionType")
     *                         .values(List.of("values"))
     *                         .build())
     *                 .county(ProfileDimensionProperty.builder()
     *                         .dimensionType("dimensionType")
     *                         .values(List.of("values"))
     *                         .build())
     *                 .postalCode(ProfileDimensionProperty.builder()
     *                         .dimensionType("dimensionType")
     *                         .values(List.of("values"))
     *                         .build())
     *                 .province(ProfileDimensionProperty.builder()
     *                         .dimensionType("dimensionType")
     *                         .values(List.of("values"))
     *                         .build())
     *                 .state(ProfileDimensionProperty.builder()
     *                         .dimensionType("dimensionType")
     *                         .values(List.of("values"))
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-profileattributes.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-profileattributes.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_customerprofiles.CfnSegmentDefinition.ProfileAttributesProperty")
    @software.amazon.jsii.Jsii.Proxy(ProfileAttributesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ProfileAttributesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A field to describe values to segment on within account number.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-profileattributes.html#cfn-customerprofiles-segmentdefinition-profileattributes-accountnumber">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-profileattributes.html#cfn-customerprofiles-segmentdefinition-profileattributes-accountnumber</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAccountNumber() {
            return null;
        }

        /**
         * A field to describe values to segment on within additional information.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-profileattributes.html#cfn-customerprofiles-segmentdefinition-profileattributes-additionalinformation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-profileattributes.html#cfn-customerprofiles-segmentdefinition-profileattributes-additionalinformation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAdditionalInformation() {
            return null;
        }

        /**
         * A field to describe values to segment on within address.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-profileattributes.html#cfn-customerprofiles-segmentdefinition-profileattributes-address">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-profileattributes.html#cfn-customerprofiles-segmentdefinition-profileattributes-address</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAddress() {
            return null;
        }

        /**
         * A field to describe values to segment on within attributes.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-profileattributes.html#cfn-customerprofiles-segmentdefinition-profileattributes-attributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-profileattributes.html#cfn-customerprofiles-segmentdefinition-profileattributes-attributes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAttributes() {
            return null;
        }

        /**
         * A field to describe values to segment on within billing address.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-profileattributes.html#cfn-customerprofiles-segmentdefinition-profileattributes-billingaddress">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-profileattributes.html#cfn-customerprofiles-segmentdefinition-profileattributes-billingaddress</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBillingAddress() {
            return null;
        }

        /**
         * A field to describe values to segment on within birthDate.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-profileattributes.html#cfn-customerprofiles-segmentdefinition-profileattributes-birthdate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-profileattributes.html#cfn-customerprofiles-segmentdefinition-profileattributes-birthdate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBirthDate() {
            return null;
        }

        /**
         * A field to describe values to segment on within business email address.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-profileattributes.html#cfn-customerprofiles-segmentdefinition-profileattributes-businessemailaddress">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-profileattributes.html#cfn-customerprofiles-segmentdefinition-profileattributes-businessemailaddress</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBusinessEmailAddress() {
            return null;
        }

        /**
         * A field to describe values to segment on within business name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-profileattributes.html#cfn-customerprofiles-segmentdefinition-profileattributes-businessname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-profileattributes.html#cfn-customerprofiles-segmentdefinition-profileattributes-businessname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBusinessName() {
            return null;
        }

        /**
         * A field to describe values to segment on within business phone number.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-profileattributes.html#cfn-customerprofiles-segmentdefinition-profileattributes-businessphonenumber">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-profileattributes.html#cfn-customerprofiles-segmentdefinition-profileattributes-businessphonenumber</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBusinessPhoneNumber() {
            return null;
        }

        /**
         * A field to describe values to segment on within email address.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-profileattributes.html#cfn-customerprofiles-segmentdefinition-profileattributes-emailaddress">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-profileattributes.html#cfn-customerprofiles-segmentdefinition-profileattributes-emailaddress</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEmailAddress() {
            return null;
        }

        /**
         * A field to describe values to segment on within first name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-profileattributes.html#cfn-customerprofiles-segmentdefinition-profileattributes-firstname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-profileattributes.html#cfn-customerprofiles-segmentdefinition-profileattributes-firstname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFirstName() {
            return null;
        }

        /**
         * A field to describe values to segment on within genderString.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-profileattributes.html#cfn-customerprofiles-segmentdefinition-profileattributes-genderstring">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-profileattributes.html#cfn-customerprofiles-segmentdefinition-profileattributes-genderstring</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getGenderString() {
            return null;
        }

        /**
         * A field to describe values to segment on within home phone number.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-profileattributes.html#cfn-customerprofiles-segmentdefinition-profileattributes-homephonenumber">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-profileattributes.html#cfn-customerprofiles-segmentdefinition-profileattributes-homephonenumber</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHomePhoneNumber() {
            return null;
        }

        /**
         * A field to describe values to segment on within last name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-profileattributes.html#cfn-customerprofiles-segmentdefinition-profileattributes-lastname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-profileattributes.html#cfn-customerprofiles-segmentdefinition-profileattributes-lastname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLastName() {
            return null;
        }

        /**
         * A field to describe values to segment on within mailing address.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-profileattributes.html#cfn-customerprofiles-segmentdefinition-profileattributes-mailingaddress">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-profileattributes.html#cfn-customerprofiles-segmentdefinition-profileattributes-mailingaddress</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMailingAddress() {
            return null;
        }

        /**
         * A field to describe values to segment on within middle name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-profileattributes.html#cfn-customerprofiles-segmentdefinition-profileattributes-middlename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-profileattributes.html#cfn-customerprofiles-segmentdefinition-profileattributes-middlename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMiddleName() {
            return null;
        }

        /**
         * A field to describe values to segment on within mobile phone number.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-profileattributes.html#cfn-customerprofiles-segmentdefinition-profileattributes-mobilephonenumber">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-profileattributes.html#cfn-customerprofiles-segmentdefinition-profileattributes-mobilephonenumber</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMobilePhoneNumber() {
            return null;
        }

        /**
         * A field to describe values to segment on within partyTypeString.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-profileattributes.html#cfn-customerprofiles-segmentdefinition-profileattributes-partytypestring">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-profileattributes.html#cfn-customerprofiles-segmentdefinition-profileattributes-partytypestring</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPartyTypeString() {
            return null;
        }

        /**
         * A field to describe values to segment on within personal email address.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-profileattributes.html#cfn-customerprofiles-segmentdefinition-profileattributes-personalemailaddress">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-profileattributes.html#cfn-customerprofiles-segmentdefinition-profileattributes-personalemailaddress</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPersonalEmailAddress() {
            return null;
        }

        /**
         * A field to describe values to segment on within phone number.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-profileattributes.html#cfn-customerprofiles-segmentdefinition-profileattributes-phonenumber">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-profileattributes.html#cfn-customerprofiles-segmentdefinition-profileattributes-phonenumber</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPhoneNumber() {
            return null;
        }

        /**
         * A field to describe values to segment on within shipping address.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-profileattributes.html#cfn-customerprofiles-segmentdefinition-profileattributes-shippingaddress">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-profileattributes.html#cfn-customerprofiles-segmentdefinition-profileattributes-shippingaddress</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getShippingAddress() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ProfileAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ProfileAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ProfileAttributesProperty> {
            java.lang.Object accountNumber;
            java.lang.Object additionalInformation;
            java.lang.Object address;
            java.lang.Object attributes;
            java.lang.Object billingAddress;
            java.lang.Object birthDate;
            java.lang.Object businessEmailAddress;
            java.lang.Object businessName;
            java.lang.Object businessPhoneNumber;
            java.lang.Object emailAddress;
            java.lang.Object firstName;
            java.lang.Object genderString;
            java.lang.Object homePhoneNumber;
            java.lang.Object lastName;
            java.lang.Object mailingAddress;
            java.lang.Object middleName;
            java.lang.Object mobilePhoneNumber;
            java.lang.Object partyTypeString;
            java.lang.Object personalEmailAddress;
            java.lang.Object phoneNumber;
            java.lang.Object shippingAddress;

            /**
             * Sets the value of {@link ProfileAttributesProperty#getAccountNumber}
             * @param accountNumber A field to describe values to segment on within account number.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accountNumber(software.amazon.awscdk.IResolvable accountNumber) {
                this.accountNumber = accountNumber;
                return this;
            }

            /**
             * Sets the value of {@link ProfileAttributesProperty#getAccountNumber}
             * @param accountNumber A field to describe values to segment on within account number.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accountNumber(software.amazon.awscdk.services.customerprofiles.CfnSegmentDefinition.ProfileDimensionProperty accountNumber) {
                this.accountNumber = accountNumber;
                return this;
            }

            /**
             * Sets the value of {@link ProfileAttributesProperty#getAdditionalInformation}
             * @param additionalInformation A field to describe values to segment on within additional information.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder additionalInformation(software.amazon.awscdk.IResolvable additionalInformation) {
                this.additionalInformation = additionalInformation;
                return this;
            }

            /**
             * Sets the value of {@link ProfileAttributesProperty#getAdditionalInformation}
             * @param additionalInformation A field to describe values to segment on within additional information.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder additionalInformation(software.amazon.awscdk.services.customerprofiles.CfnSegmentDefinition.ExtraLengthValueProfileDimensionProperty additionalInformation) {
                this.additionalInformation = additionalInformation;
                return this;
            }

            /**
             * Sets the value of {@link ProfileAttributesProperty#getAddress}
             * @param address A field to describe values to segment on within address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder address(software.amazon.awscdk.IResolvable address) {
                this.address = address;
                return this;
            }

            /**
             * Sets the value of {@link ProfileAttributesProperty#getAddress}
             * @param address A field to describe values to segment on within address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder address(software.amazon.awscdk.services.customerprofiles.CfnSegmentDefinition.AddressDimensionProperty address) {
                this.address = address;
                return this;
            }

            /**
             * Sets the value of {@link ProfileAttributesProperty#getAttributes}
             * @param attributes A field to describe values to segment on within attributes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attributes(software.amazon.awscdk.IResolvable attributes) {
                this.attributes = attributes;
                return this;
            }

            /**
             * Sets the value of {@link ProfileAttributesProperty#getAttributes}
             * @param attributes A field to describe values to segment on within attributes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder attributes(java.util.Map<java.lang.String, ? extends java.lang.Object> attributes) {
                this.attributes = attributes;
                return this;
            }

            /**
             * Sets the value of {@link ProfileAttributesProperty#getBillingAddress}
             * @param billingAddress A field to describe values to segment on within billing address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder billingAddress(software.amazon.awscdk.IResolvable billingAddress) {
                this.billingAddress = billingAddress;
                return this;
            }

            /**
             * Sets the value of {@link ProfileAttributesProperty#getBillingAddress}
             * @param billingAddress A field to describe values to segment on within billing address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder billingAddress(software.amazon.awscdk.services.customerprofiles.CfnSegmentDefinition.AddressDimensionProperty billingAddress) {
                this.billingAddress = billingAddress;
                return this;
            }

            /**
             * Sets the value of {@link ProfileAttributesProperty#getBirthDate}
             * @param birthDate A field to describe values to segment on within birthDate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder birthDate(software.amazon.awscdk.IResolvable birthDate) {
                this.birthDate = birthDate;
                return this;
            }

            /**
             * Sets the value of {@link ProfileAttributesProperty#getBirthDate}
             * @param birthDate A field to describe values to segment on within birthDate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder birthDate(software.amazon.awscdk.services.customerprofiles.CfnSegmentDefinition.DateDimensionProperty birthDate) {
                this.birthDate = birthDate;
                return this;
            }

            /**
             * Sets the value of {@link ProfileAttributesProperty#getBusinessEmailAddress}
             * @param businessEmailAddress A field to describe values to segment on within business email address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder businessEmailAddress(software.amazon.awscdk.IResolvable businessEmailAddress) {
                this.businessEmailAddress = businessEmailAddress;
                return this;
            }

            /**
             * Sets the value of {@link ProfileAttributesProperty#getBusinessEmailAddress}
             * @param businessEmailAddress A field to describe values to segment on within business email address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder businessEmailAddress(software.amazon.awscdk.services.customerprofiles.CfnSegmentDefinition.ProfileDimensionProperty businessEmailAddress) {
                this.businessEmailAddress = businessEmailAddress;
                return this;
            }

            /**
             * Sets the value of {@link ProfileAttributesProperty#getBusinessName}
             * @param businessName A field to describe values to segment on within business name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder businessName(software.amazon.awscdk.IResolvable businessName) {
                this.businessName = businessName;
                return this;
            }

            /**
             * Sets the value of {@link ProfileAttributesProperty#getBusinessName}
             * @param businessName A field to describe values to segment on within business name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder businessName(software.amazon.awscdk.services.customerprofiles.CfnSegmentDefinition.ProfileDimensionProperty businessName) {
                this.businessName = businessName;
                return this;
            }

            /**
             * Sets the value of {@link ProfileAttributesProperty#getBusinessPhoneNumber}
             * @param businessPhoneNumber A field to describe values to segment on within business phone number.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder businessPhoneNumber(software.amazon.awscdk.IResolvable businessPhoneNumber) {
                this.businessPhoneNumber = businessPhoneNumber;
                return this;
            }

            /**
             * Sets the value of {@link ProfileAttributesProperty#getBusinessPhoneNumber}
             * @param businessPhoneNumber A field to describe values to segment on within business phone number.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder businessPhoneNumber(software.amazon.awscdk.services.customerprofiles.CfnSegmentDefinition.ProfileDimensionProperty businessPhoneNumber) {
                this.businessPhoneNumber = businessPhoneNumber;
                return this;
            }

            /**
             * Sets the value of {@link ProfileAttributesProperty#getEmailAddress}
             * @param emailAddress A field to describe values to segment on within email address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder emailAddress(software.amazon.awscdk.IResolvable emailAddress) {
                this.emailAddress = emailAddress;
                return this;
            }

            /**
             * Sets the value of {@link ProfileAttributesProperty#getEmailAddress}
             * @param emailAddress A field to describe values to segment on within email address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder emailAddress(software.amazon.awscdk.services.customerprofiles.CfnSegmentDefinition.ProfileDimensionProperty emailAddress) {
                this.emailAddress = emailAddress;
                return this;
            }

            /**
             * Sets the value of {@link ProfileAttributesProperty#getFirstName}
             * @param firstName A field to describe values to segment on within first name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder firstName(software.amazon.awscdk.IResolvable firstName) {
                this.firstName = firstName;
                return this;
            }

            /**
             * Sets the value of {@link ProfileAttributesProperty#getFirstName}
             * @param firstName A field to describe values to segment on within first name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder firstName(software.amazon.awscdk.services.customerprofiles.CfnSegmentDefinition.ProfileDimensionProperty firstName) {
                this.firstName = firstName;
                return this;
            }

            /**
             * Sets the value of {@link ProfileAttributesProperty#getGenderString}
             * @param genderString A field to describe values to segment on within genderString.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder genderString(software.amazon.awscdk.IResolvable genderString) {
                this.genderString = genderString;
                return this;
            }

            /**
             * Sets the value of {@link ProfileAttributesProperty#getGenderString}
             * @param genderString A field to describe values to segment on within genderString.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder genderString(software.amazon.awscdk.services.customerprofiles.CfnSegmentDefinition.ProfileDimensionProperty genderString) {
                this.genderString = genderString;
                return this;
            }

            /**
             * Sets the value of {@link ProfileAttributesProperty#getHomePhoneNumber}
             * @param homePhoneNumber A field to describe values to segment on within home phone number.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder homePhoneNumber(software.amazon.awscdk.IResolvable homePhoneNumber) {
                this.homePhoneNumber = homePhoneNumber;
                return this;
            }

            /**
             * Sets the value of {@link ProfileAttributesProperty#getHomePhoneNumber}
             * @param homePhoneNumber A field to describe values to segment on within home phone number.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder homePhoneNumber(software.amazon.awscdk.services.customerprofiles.CfnSegmentDefinition.ProfileDimensionProperty homePhoneNumber) {
                this.homePhoneNumber = homePhoneNumber;
                return this;
            }

            /**
             * Sets the value of {@link ProfileAttributesProperty#getLastName}
             * @param lastName A field to describe values to segment on within last name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lastName(software.amazon.awscdk.IResolvable lastName) {
                this.lastName = lastName;
                return this;
            }

            /**
             * Sets the value of {@link ProfileAttributesProperty#getLastName}
             * @param lastName A field to describe values to segment on within last name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lastName(software.amazon.awscdk.services.customerprofiles.CfnSegmentDefinition.ProfileDimensionProperty lastName) {
                this.lastName = lastName;
                return this;
            }

            /**
             * Sets the value of {@link ProfileAttributesProperty#getMailingAddress}
             * @param mailingAddress A field to describe values to segment on within mailing address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mailingAddress(software.amazon.awscdk.IResolvable mailingAddress) {
                this.mailingAddress = mailingAddress;
                return this;
            }

            /**
             * Sets the value of {@link ProfileAttributesProperty#getMailingAddress}
             * @param mailingAddress A field to describe values to segment on within mailing address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mailingAddress(software.amazon.awscdk.services.customerprofiles.CfnSegmentDefinition.AddressDimensionProperty mailingAddress) {
                this.mailingAddress = mailingAddress;
                return this;
            }

            /**
             * Sets the value of {@link ProfileAttributesProperty#getMiddleName}
             * @param middleName A field to describe values to segment on within middle name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder middleName(software.amazon.awscdk.IResolvable middleName) {
                this.middleName = middleName;
                return this;
            }

            /**
             * Sets the value of {@link ProfileAttributesProperty#getMiddleName}
             * @param middleName A field to describe values to segment on within middle name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder middleName(software.amazon.awscdk.services.customerprofiles.CfnSegmentDefinition.ProfileDimensionProperty middleName) {
                this.middleName = middleName;
                return this;
            }

            /**
             * Sets the value of {@link ProfileAttributesProperty#getMobilePhoneNumber}
             * @param mobilePhoneNumber A field to describe values to segment on within mobile phone number.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mobilePhoneNumber(software.amazon.awscdk.IResolvable mobilePhoneNumber) {
                this.mobilePhoneNumber = mobilePhoneNumber;
                return this;
            }

            /**
             * Sets the value of {@link ProfileAttributesProperty#getMobilePhoneNumber}
             * @param mobilePhoneNumber A field to describe values to segment on within mobile phone number.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mobilePhoneNumber(software.amazon.awscdk.services.customerprofiles.CfnSegmentDefinition.ProfileDimensionProperty mobilePhoneNumber) {
                this.mobilePhoneNumber = mobilePhoneNumber;
                return this;
            }

            /**
             * Sets the value of {@link ProfileAttributesProperty#getPartyTypeString}
             * @param partyTypeString A field to describe values to segment on within partyTypeString.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder partyTypeString(software.amazon.awscdk.IResolvable partyTypeString) {
                this.partyTypeString = partyTypeString;
                return this;
            }

            /**
             * Sets the value of {@link ProfileAttributesProperty#getPartyTypeString}
             * @param partyTypeString A field to describe values to segment on within partyTypeString.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder partyTypeString(software.amazon.awscdk.services.customerprofiles.CfnSegmentDefinition.ProfileDimensionProperty partyTypeString) {
                this.partyTypeString = partyTypeString;
                return this;
            }

            /**
             * Sets the value of {@link ProfileAttributesProperty#getPersonalEmailAddress}
             * @param personalEmailAddress A field to describe values to segment on within personal email address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder personalEmailAddress(software.amazon.awscdk.IResolvable personalEmailAddress) {
                this.personalEmailAddress = personalEmailAddress;
                return this;
            }

            /**
             * Sets the value of {@link ProfileAttributesProperty#getPersonalEmailAddress}
             * @param personalEmailAddress A field to describe values to segment on within personal email address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder personalEmailAddress(software.amazon.awscdk.services.customerprofiles.CfnSegmentDefinition.ProfileDimensionProperty personalEmailAddress) {
                this.personalEmailAddress = personalEmailAddress;
                return this;
            }

            /**
             * Sets the value of {@link ProfileAttributesProperty#getPhoneNumber}
             * @param phoneNumber A field to describe values to segment on within phone number.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder phoneNumber(software.amazon.awscdk.IResolvable phoneNumber) {
                this.phoneNumber = phoneNumber;
                return this;
            }

            /**
             * Sets the value of {@link ProfileAttributesProperty#getPhoneNumber}
             * @param phoneNumber A field to describe values to segment on within phone number.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder phoneNumber(software.amazon.awscdk.services.customerprofiles.CfnSegmentDefinition.ProfileDimensionProperty phoneNumber) {
                this.phoneNumber = phoneNumber;
                return this;
            }

            /**
             * Sets the value of {@link ProfileAttributesProperty#getShippingAddress}
             * @param shippingAddress A field to describe values to segment on within shipping address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder shippingAddress(software.amazon.awscdk.IResolvable shippingAddress) {
                this.shippingAddress = shippingAddress;
                return this;
            }

            /**
             * Sets the value of {@link ProfileAttributesProperty#getShippingAddress}
             * @param shippingAddress A field to describe values to segment on within shipping address.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder shippingAddress(software.amazon.awscdk.services.customerprofiles.CfnSegmentDefinition.AddressDimensionProperty shippingAddress) {
                this.shippingAddress = shippingAddress;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProfileAttributesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ProfileAttributesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ProfileAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProfileAttributesProperty {
            private final java.lang.Object accountNumber;
            private final java.lang.Object additionalInformation;
            private final java.lang.Object address;
            private final java.lang.Object attributes;
            private final java.lang.Object billingAddress;
            private final java.lang.Object birthDate;
            private final java.lang.Object businessEmailAddress;
            private final java.lang.Object businessName;
            private final java.lang.Object businessPhoneNumber;
            private final java.lang.Object emailAddress;
            private final java.lang.Object firstName;
            private final java.lang.Object genderString;
            private final java.lang.Object homePhoneNumber;
            private final java.lang.Object lastName;
            private final java.lang.Object mailingAddress;
            private final java.lang.Object middleName;
            private final java.lang.Object mobilePhoneNumber;
            private final java.lang.Object partyTypeString;
            private final java.lang.Object personalEmailAddress;
            private final java.lang.Object phoneNumber;
            private final java.lang.Object shippingAddress;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.accountNumber = software.amazon.jsii.Kernel.get(this, "accountNumber", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.additionalInformation = software.amazon.jsii.Kernel.get(this, "additionalInformation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.address = software.amazon.jsii.Kernel.get(this, "address", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.attributes = software.amazon.jsii.Kernel.get(this, "attributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.billingAddress = software.amazon.jsii.Kernel.get(this, "billingAddress", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.birthDate = software.amazon.jsii.Kernel.get(this, "birthDate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.businessEmailAddress = software.amazon.jsii.Kernel.get(this, "businessEmailAddress", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.businessName = software.amazon.jsii.Kernel.get(this, "businessName", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.businessPhoneNumber = software.amazon.jsii.Kernel.get(this, "businessPhoneNumber", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.emailAddress = software.amazon.jsii.Kernel.get(this, "emailAddress", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.firstName = software.amazon.jsii.Kernel.get(this, "firstName", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.genderString = software.amazon.jsii.Kernel.get(this, "genderString", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.homePhoneNumber = software.amazon.jsii.Kernel.get(this, "homePhoneNumber", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.lastName = software.amazon.jsii.Kernel.get(this, "lastName", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.mailingAddress = software.amazon.jsii.Kernel.get(this, "mailingAddress", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.middleName = software.amazon.jsii.Kernel.get(this, "middleName", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.mobilePhoneNumber = software.amazon.jsii.Kernel.get(this, "mobilePhoneNumber", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.partyTypeString = software.amazon.jsii.Kernel.get(this, "partyTypeString", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.personalEmailAddress = software.amazon.jsii.Kernel.get(this, "personalEmailAddress", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.phoneNumber = software.amazon.jsii.Kernel.get(this, "phoneNumber", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.shippingAddress = software.amazon.jsii.Kernel.get(this, "shippingAddress", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.accountNumber = builder.accountNumber;
                this.additionalInformation = builder.additionalInformation;
                this.address = builder.address;
                this.attributes = builder.attributes;
                this.billingAddress = builder.billingAddress;
                this.birthDate = builder.birthDate;
                this.businessEmailAddress = builder.businessEmailAddress;
                this.businessName = builder.businessName;
                this.businessPhoneNumber = builder.businessPhoneNumber;
                this.emailAddress = builder.emailAddress;
                this.firstName = builder.firstName;
                this.genderString = builder.genderString;
                this.homePhoneNumber = builder.homePhoneNumber;
                this.lastName = builder.lastName;
                this.mailingAddress = builder.mailingAddress;
                this.middleName = builder.middleName;
                this.mobilePhoneNumber = builder.mobilePhoneNumber;
                this.partyTypeString = builder.partyTypeString;
                this.personalEmailAddress = builder.personalEmailAddress;
                this.phoneNumber = builder.phoneNumber;
                this.shippingAddress = builder.shippingAddress;
            }

            @Override
            public final java.lang.Object getAccountNumber() {
                return this.accountNumber;
            }

            @Override
            public final java.lang.Object getAdditionalInformation() {
                return this.additionalInformation;
            }

            @Override
            public final java.lang.Object getAddress() {
                return this.address;
            }

            @Override
            public final java.lang.Object getAttributes() {
                return this.attributes;
            }

            @Override
            public final java.lang.Object getBillingAddress() {
                return this.billingAddress;
            }

            @Override
            public final java.lang.Object getBirthDate() {
                return this.birthDate;
            }

            @Override
            public final java.lang.Object getBusinessEmailAddress() {
                return this.businessEmailAddress;
            }

            @Override
            public final java.lang.Object getBusinessName() {
                return this.businessName;
            }

            @Override
            public final java.lang.Object getBusinessPhoneNumber() {
                return this.businessPhoneNumber;
            }

            @Override
            public final java.lang.Object getEmailAddress() {
                return this.emailAddress;
            }

            @Override
            public final java.lang.Object getFirstName() {
                return this.firstName;
            }

            @Override
            public final java.lang.Object getGenderString() {
                return this.genderString;
            }

            @Override
            public final java.lang.Object getHomePhoneNumber() {
                return this.homePhoneNumber;
            }

            @Override
            public final java.lang.Object getLastName() {
                return this.lastName;
            }

            @Override
            public final java.lang.Object getMailingAddress() {
                return this.mailingAddress;
            }

            @Override
            public final java.lang.Object getMiddleName() {
                return this.middleName;
            }

            @Override
            public final java.lang.Object getMobilePhoneNumber() {
                return this.mobilePhoneNumber;
            }

            @Override
            public final java.lang.Object getPartyTypeString() {
                return this.partyTypeString;
            }

            @Override
            public final java.lang.Object getPersonalEmailAddress() {
                return this.personalEmailAddress;
            }

            @Override
            public final java.lang.Object getPhoneNumber() {
                return this.phoneNumber;
            }

            @Override
            public final java.lang.Object getShippingAddress() {
                return this.shippingAddress;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAccountNumber() != null) {
                    data.set("accountNumber", om.valueToTree(this.getAccountNumber()));
                }
                if (this.getAdditionalInformation() != null) {
                    data.set("additionalInformation", om.valueToTree(this.getAdditionalInformation()));
                }
                if (this.getAddress() != null) {
                    data.set("address", om.valueToTree(this.getAddress()));
                }
                if (this.getAttributes() != null) {
                    data.set("attributes", om.valueToTree(this.getAttributes()));
                }
                if (this.getBillingAddress() != null) {
                    data.set("billingAddress", om.valueToTree(this.getBillingAddress()));
                }
                if (this.getBirthDate() != null) {
                    data.set("birthDate", om.valueToTree(this.getBirthDate()));
                }
                if (this.getBusinessEmailAddress() != null) {
                    data.set("businessEmailAddress", om.valueToTree(this.getBusinessEmailAddress()));
                }
                if (this.getBusinessName() != null) {
                    data.set("businessName", om.valueToTree(this.getBusinessName()));
                }
                if (this.getBusinessPhoneNumber() != null) {
                    data.set("businessPhoneNumber", om.valueToTree(this.getBusinessPhoneNumber()));
                }
                if (this.getEmailAddress() != null) {
                    data.set("emailAddress", om.valueToTree(this.getEmailAddress()));
                }
                if (this.getFirstName() != null) {
                    data.set("firstName", om.valueToTree(this.getFirstName()));
                }
                if (this.getGenderString() != null) {
                    data.set("genderString", om.valueToTree(this.getGenderString()));
                }
                if (this.getHomePhoneNumber() != null) {
                    data.set("homePhoneNumber", om.valueToTree(this.getHomePhoneNumber()));
                }
                if (this.getLastName() != null) {
                    data.set("lastName", om.valueToTree(this.getLastName()));
                }
                if (this.getMailingAddress() != null) {
                    data.set("mailingAddress", om.valueToTree(this.getMailingAddress()));
                }
                if (this.getMiddleName() != null) {
                    data.set("middleName", om.valueToTree(this.getMiddleName()));
                }
                if (this.getMobilePhoneNumber() != null) {
                    data.set("mobilePhoneNumber", om.valueToTree(this.getMobilePhoneNumber()));
                }
                if (this.getPartyTypeString() != null) {
                    data.set("partyTypeString", om.valueToTree(this.getPartyTypeString()));
                }
                if (this.getPersonalEmailAddress() != null) {
                    data.set("personalEmailAddress", om.valueToTree(this.getPersonalEmailAddress()));
                }
                if (this.getPhoneNumber() != null) {
                    data.set("phoneNumber", om.valueToTree(this.getPhoneNumber()));
                }
                if (this.getShippingAddress() != null) {
                    data.set("shippingAddress", om.valueToTree(this.getShippingAddress()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_customerprofiles.CfnSegmentDefinition.ProfileAttributesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ProfileAttributesProperty.Jsii$Proxy that = (ProfileAttributesProperty.Jsii$Proxy) o;

                if (this.accountNumber != null ? !this.accountNumber.equals(that.accountNumber) : that.accountNumber != null) return false;
                if (this.additionalInformation != null ? !this.additionalInformation.equals(that.additionalInformation) : that.additionalInformation != null) return false;
                if (this.address != null ? !this.address.equals(that.address) : that.address != null) return false;
                if (this.attributes != null ? !this.attributes.equals(that.attributes) : that.attributes != null) return false;
                if (this.billingAddress != null ? !this.billingAddress.equals(that.billingAddress) : that.billingAddress != null) return false;
                if (this.birthDate != null ? !this.birthDate.equals(that.birthDate) : that.birthDate != null) return false;
                if (this.businessEmailAddress != null ? !this.businessEmailAddress.equals(that.businessEmailAddress) : that.businessEmailAddress != null) return false;
                if (this.businessName != null ? !this.businessName.equals(that.businessName) : that.businessName != null) return false;
                if (this.businessPhoneNumber != null ? !this.businessPhoneNumber.equals(that.businessPhoneNumber) : that.businessPhoneNumber != null) return false;
                if (this.emailAddress != null ? !this.emailAddress.equals(that.emailAddress) : that.emailAddress != null) return false;
                if (this.firstName != null ? !this.firstName.equals(that.firstName) : that.firstName != null) return false;
                if (this.genderString != null ? !this.genderString.equals(that.genderString) : that.genderString != null) return false;
                if (this.homePhoneNumber != null ? !this.homePhoneNumber.equals(that.homePhoneNumber) : that.homePhoneNumber != null) return false;
                if (this.lastName != null ? !this.lastName.equals(that.lastName) : that.lastName != null) return false;
                if (this.mailingAddress != null ? !this.mailingAddress.equals(that.mailingAddress) : that.mailingAddress != null) return false;
                if (this.middleName != null ? !this.middleName.equals(that.middleName) : that.middleName != null) return false;
                if (this.mobilePhoneNumber != null ? !this.mobilePhoneNumber.equals(that.mobilePhoneNumber) : that.mobilePhoneNumber != null) return false;
                if (this.partyTypeString != null ? !this.partyTypeString.equals(that.partyTypeString) : that.partyTypeString != null) return false;
                if (this.personalEmailAddress != null ? !this.personalEmailAddress.equals(that.personalEmailAddress) : that.personalEmailAddress != null) return false;
                if (this.phoneNumber != null ? !this.phoneNumber.equals(that.phoneNumber) : that.phoneNumber != null) return false;
                return this.shippingAddress != null ? this.shippingAddress.equals(that.shippingAddress) : that.shippingAddress == null;
            }

            @Override
            public final int hashCode() {
                int result = this.accountNumber != null ? this.accountNumber.hashCode() : 0;
                result = 31 * result + (this.additionalInformation != null ? this.additionalInformation.hashCode() : 0);
                result = 31 * result + (this.address != null ? this.address.hashCode() : 0);
                result = 31 * result + (this.attributes != null ? this.attributes.hashCode() : 0);
                result = 31 * result + (this.billingAddress != null ? this.billingAddress.hashCode() : 0);
                result = 31 * result + (this.birthDate != null ? this.birthDate.hashCode() : 0);
                result = 31 * result + (this.businessEmailAddress != null ? this.businessEmailAddress.hashCode() : 0);
                result = 31 * result + (this.businessName != null ? this.businessName.hashCode() : 0);
                result = 31 * result + (this.businessPhoneNumber != null ? this.businessPhoneNumber.hashCode() : 0);
                result = 31 * result + (this.emailAddress != null ? this.emailAddress.hashCode() : 0);
                result = 31 * result + (this.firstName != null ? this.firstName.hashCode() : 0);
                result = 31 * result + (this.genderString != null ? this.genderString.hashCode() : 0);
                result = 31 * result + (this.homePhoneNumber != null ? this.homePhoneNumber.hashCode() : 0);
                result = 31 * result + (this.lastName != null ? this.lastName.hashCode() : 0);
                result = 31 * result + (this.mailingAddress != null ? this.mailingAddress.hashCode() : 0);
                result = 31 * result + (this.middleName != null ? this.middleName.hashCode() : 0);
                result = 31 * result + (this.mobilePhoneNumber != null ? this.mobilePhoneNumber.hashCode() : 0);
                result = 31 * result + (this.partyTypeString != null ? this.partyTypeString.hashCode() : 0);
                result = 31 * result + (this.personalEmailAddress != null ? this.personalEmailAddress.hashCode() : 0);
                result = 31 * result + (this.phoneNumber != null ? this.phoneNumber.hashCode() : 0);
                result = 31 * result + (this.shippingAddress != null ? this.shippingAddress.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Object that segments on various Customer profile's fields that are larger than normal.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.customerprofiles.*;
     * ProfileDimensionProperty profileDimensionProperty = ProfileDimensionProperty.builder()
     *         .dimensionType("dimensionType")
     *         .values(List.of("values"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-profiledimension.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-profiledimension.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_customerprofiles.CfnSegmentDefinition.ProfileDimensionProperty")
    @software.amazon.jsii.Jsii.Proxy(ProfileDimensionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ProfileDimensionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The action to segment on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-profiledimension.html#cfn-customerprofiles-segmentdefinition-profiledimension-dimensiontype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-profiledimension.html#cfn-customerprofiles-segmentdefinition-profiledimension-dimensiontype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDimensionType();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-profiledimension.html#cfn-customerprofiles-segmentdefinition-profiledimension-values">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-profiledimension.html#cfn-customerprofiles-segmentdefinition-profiledimension-values</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getValues();

        /**
         * @return a {@link Builder} of {@link ProfileDimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ProfileDimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ProfileDimensionProperty> {
            java.lang.String dimensionType;
            java.util.List<java.lang.String> values;

            /**
             * Sets the value of {@link ProfileDimensionProperty#getDimensionType}
             * @param dimensionType The action to segment on. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dimensionType(java.lang.String dimensionType) {
                this.dimensionType = dimensionType;
                return this;
            }

            /**
             * Sets the value of {@link ProfileDimensionProperty#getValues}
             * @param values the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder values(java.util.List<java.lang.String> values) {
                this.values = values;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProfileDimensionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ProfileDimensionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ProfileDimensionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProfileDimensionProperty {
            private final java.lang.String dimensionType;
            private final java.util.List<java.lang.String> values;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dimensionType = software.amazon.jsii.Kernel.get(this, "dimensionType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.values = software.amazon.jsii.Kernel.get(this, "values", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dimensionType = java.util.Objects.requireNonNull(builder.dimensionType, "dimensionType is required");
                this.values = java.util.Objects.requireNonNull(builder.values, "values is required");
            }

            @Override
            public final java.lang.String getDimensionType() {
                return this.dimensionType;
            }

            @Override
            public final java.util.List<java.lang.String> getValues() {
                return this.values;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("dimensionType", om.valueToTree(this.getDimensionType()));
                data.set("values", om.valueToTree(this.getValues()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_customerprofiles.CfnSegmentDefinition.ProfileDimensionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ProfileDimensionProperty.Jsii$Proxy that = (ProfileDimensionProperty.Jsii$Proxy) o;

                if (!dimensionType.equals(that.dimensionType)) return false;
                return this.values.equals(that.values);
            }

            @Override
            public final int hashCode() {
                int result = this.dimensionType.hashCode();
                result = 31 * result + (this.values.hashCode());
                return result;
            }
        }
    }
    /**
     * Overrides the original range on a calculated attribute definition.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.customerprofiles.*;
     * RangeOverrideProperty rangeOverrideProperty = RangeOverrideProperty.builder()
     *         .start(123)
     *         .unit("unit")
     *         // the properties below are optional
     *         .end(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-rangeoverride.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-rangeoverride.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_customerprofiles.CfnSegmentDefinition.RangeOverrideProperty")
    @software.amazon.jsii.Jsii.Proxy(RangeOverrideProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RangeOverrideProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The start time of when to include objects.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-rangeoverride.html#cfn-customerprofiles-segmentdefinition-rangeoverride-start">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-rangeoverride.html#cfn-customerprofiles-segmentdefinition-rangeoverride-start</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getStart();

        /**
         * The unit for start and end.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-rangeoverride.html#cfn-customerprofiles-segmentdefinition-rangeoverride-unit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-rangeoverride.html#cfn-customerprofiles-segmentdefinition-rangeoverride-unit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getUnit();

        /**
         * The end time of when to include objects.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-rangeoverride.html#cfn-customerprofiles-segmentdefinition-rangeoverride-end">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-rangeoverride.html#cfn-customerprofiles-segmentdefinition-rangeoverride-end</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getEnd() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RangeOverrideProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RangeOverrideProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RangeOverrideProperty> {
            java.lang.Number start;
            java.lang.String unit;
            java.lang.Number end;

            /**
             * Sets the value of {@link RangeOverrideProperty#getStart}
             * @param start The start time of when to include objects. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder start(java.lang.Number start) {
                this.start = start;
                return this;
            }

            /**
             * Sets the value of {@link RangeOverrideProperty#getUnit}
             * @param unit The unit for start and end. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder unit(java.lang.String unit) {
                this.unit = unit;
                return this;
            }

            /**
             * Sets the value of {@link RangeOverrideProperty#getEnd}
             * @param end The end time of when to include objects.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder end(java.lang.Number end) {
                this.end = end;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RangeOverrideProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RangeOverrideProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RangeOverrideProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RangeOverrideProperty {
            private final java.lang.Number start;
            private final java.lang.String unit;
            private final java.lang.Number end;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.start = software.amazon.jsii.Kernel.get(this, "start", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.unit = software.amazon.jsii.Kernel.get(this, "unit", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.end = software.amazon.jsii.Kernel.get(this, "end", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.start = java.util.Objects.requireNonNull(builder.start, "start is required");
                this.unit = java.util.Objects.requireNonNull(builder.unit, "unit is required");
                this.end = builder.end;
            }

            @Override
            public final java.lang.Number getStart() {
                return this.start;
            }

            @Override
            public final java.lang.String getUnit() {
                return this.unit;
            }

            @Override
            public final java.lang.Number getEnd() {
                return this.end;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("start", om.valueToTree(this.getStart()));
                data.set("unit", om.valueToTree(this.getUnit()));
                if (this.getEnd() != null) {
                    data.set("end", om.valueToTree(this.getEnd()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_customerprofiles.CfnSegmentDefinition.RangeOverrideProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RangeOverrideProperty.Jsii$Proxy that = (RangeOverrideProperty.Jsii$Proxy) o;

                if (!start.equals(that.start)) return false;
                if (!unit.equals(that.unit)) return false;
                return this.end != null ? this.end.equals(that.end) : that.end == null;
            }

            @Override
            public final int hashCode() {
                int result = this.start.hashCode();
                result = 31 * result + (this.unit.hashCode());
                result = 31 * result + (this.end != null ? this.end.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains all groups of the segment definition.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.customerprofiles.*;
     * SegmentGroupProperty segmentGroupProperty = SegmentGroupProperty.builder()
     *         .groups(List.of(GroupProperty.builder()
     *                 .dimensions(List.of(DimensionProperty.builder()
     *                         .calculatedAttributes(Map.of(
     *                                 "calculatedAttributesKey", CalculatedAttributeDimensionProperty.builder()
     *                                         .dimensionType("dimensionType")
     *                                         .values(List.of("values"))
     *                                         // the properties below are optional
     *                                         .conditionOverrides(ConditionOverridesProperty.builder()
     *                                                 .range(RangeOverrideProperty.builder()
     *                                                         .start(123)
     *                                                         .unit("unit")
     *                                                         // the properties below are optional
     *                                                         .end(123)
     *                                                         .build())
     *                                                 .build())
     *                                         .build()))
     *                         .profileAttributes(ProfileAttributesProperty.builder()
     *                                 .accountNumber(ProfileDimensionProperty.builder()
     *                                         .dimensionType("dimensionType")
     *                                         .values(List.of("values"))
     *                                         .build())
     *                                 .additionalInformation(ExtraLengthValueProfileDimensionProperty.builder()
     *                                         .dimensionType("dimensionType")
     *                                         .values(List.of("values"))
     *                                         .build())
     *                                 .address(AddressDimensionProperty.builder()
     *                                         .city(ProfileDimensionProperty.builder()
     *                                                 .dimensionType("dimensionType")
     *                                                 .values(List.of("values"))
     *                                                 .build())
     *                                         .country(ProfileDimensionProperty.builder()
     *                                                 .dimensionType("dimensionType")
     *                                                 .values(List.of("values"))
     *                                                 .build())
     *                                         .county(ProfileDimensionProperty.builder()
     *                                                 .dimensionType("dimensionType")
     *                                                 .values(List.of("values"))
     *                                                 .build())
     *                                         .postalCode(ProfileDimensionProperty.builder()
     *                                                 .dimensionType("dimensionType")
     *                                                 .values(List.of("values"))
     *                                                 .build())
     *                                         .province(ProfileDimensionProperty.builder()
     *                                                 .dimensionType("dimensionType")
     *                                                 .values(List.of("values"))
     *                                                 .build())
     *                                         .state(ProfileDimensionProperty.builder()
     *                                                 .dimensionType("dimensionType")
     *                                                 .values(List.of("values"))
     *                                                 .build())
     *                                         .build())
     *                                 .attributes(Map.of(
     *                                         "attributesKey", AttributeDimensionProperty.builder()
     *                                                 .dimensionType("dimensionType")
     *                                                 .values(List.of("values"))
     *                                                 .build()))
     *                                 .billingAddress(AddressDimensionProperty.builder()
     *                                         .city(ProfileDimensionProperty.builder()
     *                                                 .dimensionType("dimensionType")
     *                                                 .values(List.of("values"))
     *                                                 .build())
     *                                         .country(ProfileDimensionProperty.builder()
     *                                                 .dimensionType("dimensionType")
     *                                                 .values(List.of("values"))
     *                                                 .build())
     *                                         .county(ProfileDimensionProperty.builder()
     *                                                 .dimensionType("dimensionType")
     *                                                 .values(List.of("values"))
     *                                                 .build())
     *                                         .postalCode(ProfileDimensionProperty.builder()
     *                                                 .dimensionType("dimensionType")
     *                                                 .values(List.of("values"))
     *                                                 .build())
     *                                         .province(ProfileDimensionProperty.builder()
     *                                                 .dimensionType("dimensionType")
     *                                                 .values(List.of("values"))
     *                                                 .build())
     *                                         .state(ProfileDimensionProperty.builder()
     *                                                 .dimensionType("dimensionType")
     *                                                 .values(List.of("values"))
     *                                                 .build())
     *                                         .build())
     *                                 .birthDate(DateDimensionProperty.builder()
     *                                         .dimensionType("dimensionType")
     *                                         .values(List.of("values"))
     *                                         .build())
     *                                 .businessEmailAddress(ProfileDimensionProperty.builder()
     *                                         .dimensionType("dimensionType")
     *                                         .values(List.of("values"))
     *                                         .build())
     *                                 .businessName(ProfileDimensionProperty.builder()
     *                                         .dimensionType("dimensionType")
     *                                         .values(List.of("values"))
     *                                         .build())
     *                                 .businessPhoneNumber(ProfileDimensionProperty.builder()
     *                                         .dimensionType("dimensionType")
     *                                         .values(List.of("values"))
     *                                         .build())
     *                                 .emailAddress(ProfileDimensionProperty.builder()
     *                                         .dimensionType("dimensionType")
     *                                         .values(List.of("values"))
     *                                         .build())
     *                                 .firstName(ProfileDimensionProperty.builder()
     *                                         .dimensionType("dimensionType")
     *                                         .values(List.of("values"))
     *                                         .build())
     *                                 .genderString(ProfileDimensionProperty.builder()
     *                                         .dimensionType("dimensionType")
     *                                         .values(List.of("values"))
     *                                         .build())
     *                                 .homePhoneNumber(ProfileDimensionProperty.builder()
     *                                         .dimensionType("dimensionType")
     *                                         .values(List.of("values"))
     *                                         .build())
     *                                 .lastName(ProfileDimensionProperty.builder()
     *                                         .dimensionType("dimensionType")
     *                                         .values(List.of("values"))
     *                                         .build())
     *                                 .mailingAddress(AddressDimensionProperty.builder()
     *                                         .city(ProfileDimensionProperty.builder()
     *                                                 .dimensionType("dimensionType")
     *                                                 .values(List.of("values"))
     *                                                 .build())
     *                                         .country(ProfileDimensionProperty.builder()
     *                                                 .dimensionType("dimensionType")
     *                                                 .values(List.of("values"))
     *                                                 .build())
     *                                         .county(ProfileDimensionProperty.builder()
     *                                                 .dimensionType("dimensionType")
     *                                                 .values(List.of("values"))
     *                                                 .build())
     *                                         .postalCode(ProfileDimensionProperty.builder()
     *                                                 .dimensionType("dimensionType")
     *                                                 .values(List.of("values"))
     *                                                 .build())
     *                                         .province(ProfileDimensionProperty.builder()
     *                                                 .dimensionType("dimensionType")
     *                                                 .values(List.of("values"))
     *                                                 .build())
     *                                         .state(ProfileDimensionProperty.builder()
     *                                                 .dimensionType("dimensionType")
     *                                                 .values(List.of("values"))
     *                                                 .build())
     *                                         .build())
     *                                 .middleName(ProfileDimensionProperty.builder()
     *                                         .dimensionType("dimensionType")
     *                                         .values(List.of("values"))
     *                                         .build())
     *                                 .mobilePhoneNumber(ProfileDimensionProperty.builder()
     *                                         .dimensionType("dimensionType")
     *                                         .values(List.of("values"))
     *                                         .build())
     *                                 .partyTypeString(ProfileDimensionProperty.builder()
     *                                         .dimensionType("dimensionType")
     *                                         .values(List.of("values"))
     *                                         .build())
     *                                 .personalEmailAddress(ProfileDimensionProperty.builder()
     *                                         .dimensionType("dimensionType")
     *                                         .values(List.of("values"))
     *                                         .build())
     *                                 .phoneNumber(ProfileDimensionProperty.builder()
     *                                         .dimensionType("dimensionType")
     *                                         .values(List.of("values"))
     *                                         .build())
     *                                 .shippingAddress(AddressDimensionProperty.builder()
     *                                         .city(ProfileDimensionProperty.builder()
     *                                                 .dimensionType("dimensionType")
     *                                                 .values(List.of("values"))
     *                                                 .build())
     *                                         .country(ProfileDimensionProperty.builder()
     *                                                 .dimensionType("dimensionType")
     *                                                 .values(List.of("values"))
     *                                                 .build())
     *                                         .county(ProfileDimensionProperty.builder()
     *                                                 .dimensionType("dimensionType")
     *                                                 .values(List.of("values"))
     *                                                 .build())
     *                                         .postalCode(ProfileDimensionProperty.builder()
     *                                                 .dimensionType("dimensionType")
     *                                                 .values(List.of("values"))
     *                                                 .build())
     *                                         .province(ProfileDimensionProperty.builder()
     *                                                 .dimensionType("dimensionType")
     *                                                 .values(List.of("values"))
     *                                                 .build())
     *                                         .state(ProfileDimensionProperty.builder()
     *                                                 .dimensionType("dimensionType")
     *                                                 .values(List.of("values"))
     *                                                 .build())
     *                                         .build())
     *                                 .build())
     *                         .build()))
     *                 .sourceSegments(List.of(SourceSegmentProperty.builder()
     *                         .segmentDefinitionName("segmentDefinitionName")
     *                         .build()))
     *                 .sourceType("sourceType")
     *                 .type("type")
     *                 .build()))
     *         .include("include")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-segmentgroup.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-segmentgroup.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_customerprofiles.CfnSegmentDefinition.SegmentGroupProperty")
    @software.amazon.jsii.Jsii.Proxy(SegmentGroupProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SegmentGroupProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Holds the list of groups within the segment definition.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-segmentgroup.html#cfn-customerprofiles-segmentdefinition-segmentgroup-groups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-segmentgroup.html#cfn-customerprofiles-segmentdefinition-segmentgroup-groups</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getGroups() {
            return null;
        }

        /**
         * Defines whether to include or exclude the profiles that fit the segment criteria.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-segmentgroup.html#cfn-customerprofiles-segmentdefinition-segmentgroup-include">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-segmentgroup.html#cfn-customerprofiles-segmentdefinition-segmentgroup-include</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInclude() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SegmentGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SegmentGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SegmentGroupProperty> {
            java.lang.Object groups;
            java.lang.String include;

            /**
             * Sets the value of {@link SegmentGroupProperty#getGroups}
             * @param groups Holds the list of groups within the segment definition.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder groups(software.amazon.awscdk.IResolvable groups) {
                this.groups = groups;
                return this;
            }

            /**
             * Sets the value of {@link SegmentGroupProperty#getGroups}
             * @param groups Holds the list of groups within the segment definition.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder groups(java.util.List<? extends java.lang.Object> groups) {
                this.groups = groups;
                return this;
            }

            /**
             * Sets the value of {@link SegmentGroupProperty#getInclude}
             * @param include Defines whether to include or exclude the profiles that fit the segment criteria.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder include(java.lang.String include) {
                this.include = include;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SegmentGroupProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SegmentGroupProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SegmentGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SegmentGroupProperty {
            private final java.lang.Object groups;
            private final java.lang.String include;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.groups = software.amazon.jsii.Kernel.get(this, "groups", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.include = software.amazon.jsii.Kernel.get(this, "include", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.groups = builder.groups;
                this.include = builder.include;
            }

            @Override
            public final java.lang.Object getGroups() {
                return this.groups;
            }

            @Override
            public final java.lang.String getInclude() {
                return this.include;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getGroups() != null) {
                    data.set("groups", om.valueToTree(this.getGroups()));
                }
                if (this.getInclude() != null) {
                    data.set("include", om.valueToTree(this.getInclude()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_customerprofiles.CfnSegmentDefinition.SegmentGroupProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SegmentGroupProperty.Jsii$Proxy that = (SegmentGroupProperty.Jsii$Proxy) o;

                if (this.groups != null ? !this.groups.equals(that.groups) : that.groups != null) return false;
                return this.include != null ? this.include.equals(that.include) : that.include == null;
            }

            @Override
            public final int hashCode() {
                int result = this.groups != null ? this.groups.hashCode() : 0;
                result = 31 * result + (this.include != null ? this.include.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The source segments to build off of.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.customerprofiles.*;
     * SourceSegmentProperty sourceSegmentProperty = SourceSegmentProperty.builder()
     *         .segmentDefinitionName("segmentDefinitionName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-sourcesegment.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-sourcesegment.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_customerprofiles.CfnSegmentDefinition.SourceSegmentProperty")
    @software.amazon.jsii.Jsii.Proxy(SourceSegmentProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SourceSegmentProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the source segment.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-sourcesegment.html#cfn-customerprofiles-segmentdefinition-sourcesegment-segmentdefinitionname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-customerprofiles-segmentdefinition-sourcesegment.html#cfn-customerprofiles-segmentdefinition-sourcesegment-segmentdefinitionname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSegmentDefinitionName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SourceSegmentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SourceSegmentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SourceSegmentProperty> {
            java.lang.String segmentDefinitionName;

            /**
             * Sets the value of {@link SourceSegmentProperty#getSegmentDefinitionName}
             * @param segmentDefinitionName The name of the source segment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder segmentDefinitionName(java.lang.String segmentDefinitionName) {
                this.segmentDefinitionName = segmentDefinitionName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SourceSegmentProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SourceSegmentProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SourceSegmentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SourceSegmentProperty {
            private final java.lang.String segmentDefinitionName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.segmentDefinitionName = software.amazon.jsii.Kernel.get(this, "segmentDefinitionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.segmentDefinitionName = builder.segmentDefinitionName;
            }

            @Override
            public final java.lang.String getSegmentDefinitionName() {
                return this.segmentDefinitionName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSegmentDefinitionName() != null) {
                    data.set("segmentDefinitionName", om.valueToTree(this.getSegmentDefinitionName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_customerprofiles.CfnSegmentDefinition.SourceSegmentProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SourceSegmentProperty.Jsii$Proxy that = (SourceSegmentProperty.Jsii$Proxy) o;

                return this.segmentDefinitionName != null ? this.segmentDefinitionName.equals(that.segmentDefinitionName) : that.segmentDefinitionName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.segmentDefinitionName != null ? this.segmentDefinitionName.hashCode() : 0;
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.customerprofiles.CfnSegmentDefinition}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.customerprofiles.CfnSegmentDefinition> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.customerprofiles.CfnSegmentDefinitionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.customerprofiles.CfnSegmentDefinitionProps.Builder();
        }

        /**
         * Display name of the segment definition.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-segmentdefinition.html#cfn-customerprofiles-segmentdefinition-displayname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-segmentdefinition.html#cfn-customerprofiles-segmentdefinition-displayname</a>
         * @param displayName Display name of the segment definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder displayName(final java.lang.String displayName) {
            this.props.displayName(displayName);
            return this;
        }

        /**
         * The name of the domain.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-segmentdefinition.html#cfn-customerprofiles-segmentdefinition-domainname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-segmentdefinition.html#cfn-customerprofiles-segmentdefinition-domainname</a>
         * @param domainName The name of the domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(final java.lang.String domainName) {
            this.props.domainName(domainName);
            return this;
        }

        /**
         * Name of the segment definition.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-segmentdefinition.html#cfn-customerprofiles-segmentdefinition-segmentdefinitionname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-segmentdefinition.html#cfn-customerprofiles-segmentdefinition-segmentdefinitionname</a>
         * @param segmentDefinitionName Name of the segment definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder segmentDefinitionName(final java.lang.String segmentDefinitionName) {
            this.props.segmentDefinitionName(segmentDefinitionName);
            return this;
        }

        /**
         * Contains all groups of the segment definition.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-segmentdefinition.html#cfn-customerprofiles-segmentdefinition-segmentgroups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-segmentdefinition.html#cfn-customerprofiles-segmentdefinition-segmentgroups</a>
         * @param segmentGroups Contains all groups of the segment definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder segmentGroups(final software.amazon.awscdk.IResolvable segmentGroups) {
            this.props.segmentGroups(segmentGroups);
            return this;
        }
        /**
         * Contains all groups of the segment definition.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-segmentdefinition.html#cfn-customerprofiles-segmentdefinition-segmentgroups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-segmentdefinition.html#cfn-customerprofiles-segmentdefinition-segmentgroups</a>
         * @param segmentGroups Contains all groups of the segment definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder segmentGroups(final software.amazon.awscdk.services.customerprofiles.CfnSegmentDefinition.SegmentGroupProperty segmentGroups) {
            this.props.segmentGroups(segmentGroups);
            return this;
        }

        /**
         * The description of the segment definition.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-segmentdefinition.html#cfn-customerprofiles-segmentdefinition-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-segmentdefinition.html#cfn-customerprofiles-segmentdefinition-description</a>
         * @param description The description of the segment definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The tags belonging to the segment definition.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-segmentdefinition.html#cfn-customerprofiles-segmentdefinition-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-customerprofiles-segmentdefinition.html#cfn-customerprofiles-segmentdefinition-tags</a>
         * @param tags The tags belonging to the segment definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.customerprofiles.CfnSegmentDefinition}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.customerprofiles.CfnSegmentDefinition build() {
            return new software.amazon.awscdk.services.customerprofiles.CfnSegmentDefinition(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
