package software.amazon.awscdk.services.codepipeline.actions;

/**
 * Options in common between both StackSet actions.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.codepipeline.actions.*;
 * CommonCloudFormationStackSetOptions commonCloudFormationStackSetOptions = CommonCloudFormationStackSetOptions.builder()
 *         .failureTolerancePercentage(123)
 *         .maxAccountConcurrencyPercentage(123)
 *         .stackSetRegion("stackSetRegion")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:09.371Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline_actions.CommonCloudFormationStackSetOptions")
@software.amazon.jsii.Jsii.Proxy(CommonCloudFormationStackSetOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CommonCloudFormationStackSetOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The percentage of accounts per Region for which this stack operation can fail before AWS CloudFormation stops the operation in that Region.
     * <p>
     * If
     * the operation is stopped in a Region, AWS CloudFormation doesn't attempt the operation in subsequent Regions. When calculating the number
     * of accounts based on the specified percentage, AWS CloudFormation rounds down to the next whole number.
     * <p>
     * Default: 0%
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getFailureTolerancePercentage() {
        return null;
    }

    /**
     * The maximum percentage of accounts in which to perform this operation at one time.
     * <p>
     * When calculating the number of accounts based on the specified
     * percentage, AWS CloudFormation rounds down to the next whole number. If rounding down would result in zero, AWS CloudFormation sets the number as
     * one instead. Although you use this setting to specify the maximum, for large deployments the actual number of accounts acted upon concurrently
     * may be lower due to service throttling.
     * <p>
     * Default: 1%
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxAccountConcurrencyPercentage() {
        return null;
    }

    /**
     * The AWS Region the StackSet is in.
     * <p>
     * Note that a cross-region Pipeline requires replication buckets to function correctly.
     * You can provide their names with the <code>PipelineProps.crossRegionReplicationBuckets</code> property.
     * If you don't, the CodePipeline Construct will create new Stacks in your CDK app containing those buckets,
     * that you will need to <code>cdk deploy</code> before deploying the main, Pipeline-containing Stack.
     * <p>
     * Default: - same region as the Pipeline
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStackSetRegion() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CommonCloudFormationStackSetOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CommonCloudFormationStackSetOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CommonCloudFormationStackSetOptions> {
        java.lang.Number failureTolerancePercentage;
        java.lang.Number maxAccountConcurrencyPercentage;
        java.lang.String stackSetRegion;

        /**
         * Sets the value of {@link CommonCloudFormationStackSetOptions#getFailureTolerancePercentage}
         * @param failureTolerancePercentage The percentage of accounts per Region for which this stack operation can fail before AWS CloudFormation stops the operation in that Region.
         *                                   If
         *                                   the operation is stopped in a Region, AWS CloudFormation doesn't attempt the operation in subsequent Regions. When calculating the number
         *                                   of accounts based on the specified percentage, AWS CloudFormation rounds down to the next whole number.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder failureTolerancePercentage(java.lang.Number failureTolerancePercentage) {
            this.failureTolerancePercentage = failureTolerancePercentage;
            return this;
        }

        /**
         * Sets the value of {@link CommonCloudFormationStackSetOptions#getMaxAccountConcurrencyPercentage}
         * @param maxAccountConcurrencyPercentage The maximum percentage of accounts in which to perform this operation at one time.
         *                                        When calculating the number of accounts based on the specified
         *                                        percentage, AWS CloudFormation rounds down to the next whole number. If rounding down would result in zero, AWS CloudFormation sets the number as
         *                                        one instead. Although you use this setting to specify the maximum, for large deployments the actual number of accounts acted upon concurrently
         *                                        may be lower due to service throttling.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxAccountConcurrencyPercentage(java.lang.Number maxAccountConcurrencyPercentage) {
            this.maxAccountConcurrencyPercentage = maxAccountConcurrencyPercentage;
            return this;
        }

        /**
         * Sets the value of {@link CommonCloudFormationStackSetOptions#getStackSetRegion}
         * @param stackSetRegion The AWS Region the StackSet is in.
         *                       Note that a cross-region Pipeline requires replication buckets to function correctly.
         *                       You can provide their names with the <code>PipelineProps.crossRegionReplicationBuckets</code> property.
         *                       If you don't, the CodePipeline Construct will create new Stacks in your CDK app containing those buckets,
         *                       that you will need to <code>cdk deploy</code> before deploying the main, Pipeline-containing Stack.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stackSetRegion(java.lang.String stackSetRegion) {
            this.stackSetRegion = stackSetRegion;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CommonCloudFormationStackSetOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CommonCloudFormationStackSetOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CommonCloudFormationStackSetOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CommonCloudFormationStackSetOptions {
        private final java.lang.Number failureTolerancePercentage;
        private final java.lang.Number maxAccountConcurrencyPercentage;
        private final java.lang.String stackSetRegion;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.failureTolerancePercentage = software.amazon.jsii.Kernel.get(this, "failureTolerancePercentage", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.maxAccountConcurrencyPercentage = software.amazon.jsii.Kernel.get(this, "maxAccountConcurrencyPercentage", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.stackSetRegion = software.amazon.jsii.Kernel.get(this, "stackSetRegion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.failureTolerancePercentage = builder.failureTolerancePercentage;
            this.maxAccountConcurrencyPercentage = builder.maxAccountConcurrencyPercentage;
            this.stackSetRegion = builder.stackSetRegion;
        }

        @Override
        public final java.lang.Number getFailureTolerancePercentage() {
            return this.failureTolerancePercentage;
        }

        @Override
        public final java.lang.Number getMaxAccountConcurrencyPercentage() {
            return this.maxAccountConcurrencyPercentage;
        }

        @Override
        public final java.lang.String getStackSetRegion() {
            return this.stackSetRegion;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getFailureTolerancePercentage() != null) {
                data.set("failureTolerancePercentage", om.valueToTree(this.getFailureTolerancePercentage()));
            }
            if (this.getMaxAccountConcurrencyPercentage() != null) {
                data.set("maxAccountConcurrencyPercentage", om.valueToTree(this.getMaxAccountConcurrencyPercentage()));
            }
            if (this.getStackSetRegion() != null) {
                data.set("stackSetRegion", om.valueToTree(this.getStackSetRegion()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline_actions.CommonCloudFormationStackSetOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CommonCloudFormationStackSetOptions.Jsii$Proxy that = (CommonCloudFormationStackSetOptions.Jsii$Proxy) o;

            if (this.failureTolerancePercentage != null ? !this.failureTolerancePercentage.equals(that.failureTolerancePercentage) : that.failureTolerancePercentage != null) return false;
            if (this.maxAccountConcurrencyPercentage != null ? !this.maxAccountConcurrencyPercentage.equals(that.maxAccountConcurrencyPercentage) : that.maxAccountConcurrencyPercentage != null) return false;
            return this.stackSetRegion != null ? this.stackSetRegion.equals(that.stackSetRegion) : that.stackSetRegion == null;
        }

        @Override
        public final int hashCode() {
            int result = this.failureTolerancePercentage != null ? this.failureTolerancePercentage.hashCode() : 0;
            result = 31 * result + (this.maxAccountConcurrencyPercentage != null ? this.maxAccountConcurrencyPercentage.hashCode() : 0);
            result = 31 * result + (this.stackSetRegion != null ? this.stackSetRegion.hashCode() : 0);
            return result;
        }
    }
}
