package software.amazon.awscdk.services.cloudwatch;

/**
 * A CloudWatch dashboard.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.cloudwatch.*;
 * Dashboard dashboard = Dashboard.Builder.create(this, "Dash")
 *         .defaultInterval(Duration.days(7))
 *         .variables(List.of(DashboardVariable.Builder.create()
 *                 .id("region2")
 *                 .type(VariableType.PATTERN)
 *                 .label("RegionPattern")
 *                 .inputType(VariableInputType.INPUT)
 *                 .value("us-east-1")
 *                 .defaultValue(DefaultValue.value("us-east-1"))
 *                 .visible(true)
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:08.863Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudwatch.Dashboard")
public class Dashboard extends software.amazon.awscdk.Resource {

    protected Dashboard(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Dashboard(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Dashboard(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.DashboardProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Dashboard(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Add a variable to the dashboard.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_dashboard_variables.html">https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_dashboard_variables.html</a>
     * @param variable This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addVariable(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.IVariable variable) {
        software.amazon.jsii.Kernel.call(this, "addVariable", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(variable, "variable is required") });
    }

    /**
     * Add a widget to the dashboard.
     * <p>
     * Widgets given in multiple calls to add() will be laid out stacked on
     * top of each other.
     * <p>
     * Multiple widgets added in the same call to add() will be laid out next
     * to each other.
     * <p>
     * @param widgets This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addWidgets(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.IWidget... widgets) {
        software.amazon.jsii.Kernel.call(this, "addWidgets", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(widgets).toArray(Object[]::new));
    }

    /**
     * ARN of this dashboard.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDashboardArn() {
        return software.amazon.jsii.Kernel.get(this, "dashboardArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of this dashboard.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDashboardName() {
        return software.amazon.jsii.Kernel.get(this, "dashboardName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cloudwatch.Dashboard}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cloudwatch.Dashboard> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.cloudwatch.DashboardProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * Name of the dashboard.
         * <p>
         * If set, must only contain alphanumerics, dash (-) and underscore (_)
         * <p>
         * Default: - automatically generated name
         * <p>
         * @return {@code this}
         * @param dashboardName Name of the dashboard. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dashboardName(final java.lang.String dashboardName) {
            this.props().dashboardName(dashboardName);
            return this;
        }

        /**
         * Interval duration for metrics. You can specify defaultInterval with the relative time(eg. cdk.Duration.days(7)).
         * <p>
         * Both properties <code>defaultInterval</code> and <code>start</code> cannot be set at once.
         * <p>
         * Default: When the dashboard loads, the defaultInterval time will be the default time range.
         * <p>
         * @return {@code this}
         * @param defaultInterval Interval duration for metrics. You can specify defaultInterval with the relative time(eg. cdk.Duration.days(7)). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultInterval(final software.amazon.awscdk.Duration defaultInterval) {
            this.props().defaultInterval(defaultInterval);
            return this;
        }

        /**
         * The end of the time range to use for each widget on the dashboard when the dashboard loads.
         * <p>
         * If you specify a value for end, you must also specify a value for start.
         * Specify an absolute time in the ISO 8601 format. For example, 2018-12-17T06:00:00.000Z.
         * <p>
         * Default: When the dashboard loads, the end date will be the current time.
         * <p>
         * @return {@code this}
         * @param end The end of the time range to use for each widget on the dashboard when the dashboard loads. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder end(final java.lang.String end) {
            this.props().end(end);
            return this;
        }

        /**
         * Use this field to specify the period for the graphs when the dashboard loads.
         * <p>
         * Specifying <code>Auto</code> causes the period of all graphs on the dashboard to automatically adapt to the time range of the dashboard.
         * Specifying <code>Inherit</code> ensures that the period set for each graph is always obeyed.
         * <p>
         * Default: Auto
         * <p>
         * @return {@code this}
         * @param periodOverride Use this field to specify the period for the graphs when the dashboard loads. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder periodOverride(final software.amazon.awscdk.services.cloudwatch.PeriodOverride periodOverride) {
            this.props().periodOverride(periodOverride);
            return this;
        }

        /**
         * The start of the time range to use for each widget on the dashboard.
         * <p>
         * You can specify start without specifying end to specify a relative time range that ends with the current time.
         * In this case, the value of start must begin with -P, and you can use M, H, D, W and M as abbreviations for
         * minutes, hours, days, weeks and months. For example, -PT8H shows the last 8 hours and -P3M shows the last three months.
         * You can also use start along with an end field, to specify an absolute time range.
         * When specifying an absolute time range, use the ISO 8601 format. For example, 2018-12-17T06:00:00.000Z.
         * <p>
         * Both properties <code>defaultInterval</code> and <code>start</code> cannot be set at once.
         * <p>
         * Default: When the dashboard loads, the start time will be the default time range.
         * <p>
         * @return {@code this}
         * @param start The start of the time range to use for each widget on the dashboard. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder start(final java.lang.String start) {
            this.props().start(start);
            return this;
        }

        /**
         * A list of dashboard variables.
         * <p>
         * Default: - No variables
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_dashboard_variables.html#cloudwatch_dashboard_variables_types">https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_dashboard_variables.html#cloudwatch_dashboard_variables_types</a>
         * @param variables A list of dashboard variables. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder variables(final java.util.List<? extends software.amazon.awscdk.services.cloudwatch.IVariable> variables) {
            this.props().variables(variables);
            return this;
        }

        /**
         * Initial set of widgets on the dashboard.
         * <p>
         * One array represents a row of widgets.
         * <p>
         * Default: - No widgets
         * <p>
         * @return {@code this}
         * @param widgets Initial set of widgets on the dashboard. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder widgets(final java.util.List<? extends java.util.List<? extends software.amazon.awscdk.services.cloudwatch.IWidget>> widgets) {
            this.props().widgets(widgets);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.cloudwatch.Dashboard}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cloudwatch.Dashboard build() {
            return new software.amazon.awscdk.services.cloudwatch.Dashboard(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.cloudwatch.DashboardProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.cloudwatch.DashboardProps.Builder();
            }
            return this.props;
        }
    }
}
