package software.amazon.awscdk.services.cloudfront.origins;

/**
 * Properties for configuring a S3 origin with OAC.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Bucket myBucket = new Bucket(this, "myBucket");
 * IOrigin s3Origin = S3BucketOrigin.withOriginAccessControl(myBucket, S3BucketOriginWithOACProps.builder()
 *         .originAccessLevels(List.of(AccessLevel.READ, AccessLevel.LIST))
 *         .build());
 * Distribution.Builder.create(this, "distribution")
 *         .defaultBehavior(BehaviorOptions.builder()
 *                 .origin(s3Origin)
 *                 .build())
 *         .defaultRootObject("index.html")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:08.734Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront_origins.S3BucketOriginWithOACProps")
@software.amazon.jsii.Jsii.Proxy(S3BucketOriginWithOACProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface S3BucketOriginWithOACProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.cloudfront.origins.S3BucketOriginBaseProps {

    /**
     * An optional Origin Access Control.
     * <p>
     * Default: - an Origin Access Control will be created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.IOriginAccessControl getOriginAccessControl() {
        return null;
    }

    /**
     * The level of permissions granted in the bucket policy and key policy (if applicable) to the CloudFront distribution.
     * <p>
     * Default: [AccessLevel.READ]
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.cloudfront.AccessLevel> getOriginAccessLevels() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link S3BucketOriginWithOACProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link S3BucketOriginWithOACProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<S3BucketOriginWithOACProps> {
        software.amazon.awscdk.services.cloudfront.IOriginAccessControl originAccessControl;
        java.util.List<software.amazon.awscdk.services.cloudfront.AccessLevel> originAccessLevels;
        java.lang.String originPath;
        java.lang.Number connectionAttempts;
        software.amazon.awscdk.Duration connectionTimeout;
        java.util.Map<java.lang.String, java.lang.String> customHeaders;
        java.lang.String originAccessControlId;
        java.lang.String originId;
        java.lang.Boolean originShieldEnabled;
        java.lang.String originShieldRegion;

        /**
         * Sets the value of {@link S3BucketOriginWithOACProps#getOriginAccessControl}
         * @param originAccessControl An optional Origin Access Control.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder originAccessControl(software.amazon.awscdk.services.cloudfront.IOriginAccessControl originAccessControl) {
            this.originAccessControl = originAccessControl;
            return this;
        }

        /**
         * Sets the value of {@link S3BucketOriginWithOACProps#getOriginAccessLevels}
         * @param originAccessLevels The level of permissions granted in the bucket policy and key policy (if applicable) to the CloudFront distribution.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder originAccessLevels(java.util.List<? extends software.amazon.awscdk.services.cloudfront.AccessLevel> originAccessLevels) {
            this.originAccessLevels = (java.util.List<software.amazon.awscdk.services.cloudfront.AccessLevel>)originAccessLevels;
            return this;
        }

        /**
         * Sets the value of {@link S3BucketOriginWithOACProps#getOriginPath}
         * @param originPath An optional path that CloudFront appends to the origin domain name when CloudFront requests content from the origin.
         *                   Must begin, but not end, with '/' (e.g., '/production/images').
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder originPath(java.lang.String originPath) {
            this.originPath = originPath;
            return this;
        }

        /**
         * Sets the value of {@link S3BucketOriginWithOACProps#getConnectionAttempts}
         * @param connectionAttempts The number of times that CloudFront attempts to connect to the origin;.
         *                           valid values are 1, 2, or 3 attempts.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionAttempts(java.lang.Number connectionAttempts) {
            this.connectionAttempts = connectionAttempts;
            return this;
        }

        /**
         * Sets the value of {@link S3BucketOriginWithOACProps#getConnectionTimeout}
         * @param connectionTimeout The number of seconds that CloudFront waits when trying to establish a connection to the origin.
         *                          Valid values are 1-10 seconds, inclusive.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionTimeout(software.amazon.awscdk.Duration connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        /**
         * Sets the value of {@link S3BucketOriginWithOACProps#getCustomHeaders}
         * @param customHeaders A list of HTTP header names and values that CloudFront adds to requests it sends to the origin.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customHeaders(java.util.Map<java.lang.String, java.lang.String> customHeaders) {
            this.customHeaders = customHeaders;
            return this;
        }

        /**
         * Sets the value of {@link S3BucketOriginWithOACProps#getOriginAccessControlId}
         * @param originAccessControlId The unique identifier of an origin access control for this origin.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder originAccessControlId(java.lang.String originAccessControlId) {
            this.originAccessControlId = originAccessControlId;
            return this;
        }

        /**
         * Sets the value of {@link S3BucketOriginWithOACProps#getOriginId}
         * @param originId A unique identifier for the origin.
         *                 This value must be unique within the distribution.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder originId(java.lang.String originId) {
            this.originId = originId;
            return this;
        }

        /**
         * Sets the value of {@link S3BucketOriginWithOACProps#getOriginShieldEnabled}
         * @param originShieldEnabled Origin Shield is enabled by setting originShieldRegion to a valid region, after this to disable Origin Shield again you must set this flag to false.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder originShieldEnabled(java.lang.Boolean originShieldEnabled) {
            this.originShieldEnabled = originShieldEnabled;
            return this;
        }

        /**
         * Sets the value of {@link S3BucketOriginWithOACProps#getOriginShieldRegion}
         * @param originShieldRegion When you enable Origin Shield in the AWS Region that has the lowest latency to your origin, you can get better network performance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder originShieldRegion(java.lang.String originShieldRegion) {
            this.originShieldRegion = originShieldRegion;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link S3BucketOriginWithOACProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public S3BucketOriginWithOACProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link S3BucketOriginWithOACProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3BucketOriginWithOACProps {
        private final software.amazon.awscdk.services.cloudfront.IOriginAccessControl originAccessControl;
        private final java.util.List<software.amazon.awscdk.services.cloudfront.AccessLevel> originAccessLevels;
        private final java.lang.String originPath;
        private final java.lang.Number connectionAttempts;
        private final software.amazon.awscdk.Duration connectionTimeout;
        private final java.util.Map<java.lang.String, java.lang.String> customHeaders;
        private final java.lang.String originAccessControlId;
        private final java.lang.String originId;
        private final java.lang.Boolean originShieldEnabled;
        private final java.lang.String originShieldRegion;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.originAccessControl = software.amazon.jsii.Kernel.get(this, "originAccessControl", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.IOriginAccessControl.class));
            this.originAccessLevels = software.amazon.jsii.Kernel.get(this, "originAccessLevels", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.AccessLevel.class)));
            this.originPath = software.amazon.jsii.Kernel.get(this, "originPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.connectionAttempts = software.amazon.jsii.Kernel.get(this, "connectionAttempts", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.connectionTimeout = software.amazon.jsii.Kernel.get(this, "connectionTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.customHeaders = software.amazon.jsii.Kernel.get(this, "customHeaders", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.originAccessControlId = software.amazon.jsii.Kernel.get(this, "originAccessControlId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.originId = software.amazon.jsii.Kernel.get(this, "originId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.originShieldEnabled = software.amazon.jsii.Kernel.get(this, "originShieldEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.originShieldRegion = software.amazon.jsii.Kernel.get(this, "originShieldRegion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.originAccessControl = builder.originAccessControl;
            this.originAccessLevels = (java.util.List<software.amazon.awscdk.services.cloudfront.AccessLevel>)builder.originAccessLevels;
            this.originPath = builder.originPath;
            this.connectionAttempts = builder.connectionAttempts;
            this.connectionTimeout = builder.connectionTimeout;
            this.customHeaders = builder.customHeaders;
            this.originAccessControlId = builder.originAccessControlId;
            this.originId = builder.originId;
            this.originShieldEnabled = builder.originShieldEnabled;
            this.originShieldRegion = builder.originShieldRegion;
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.IOriginAccessControl getOriginAccessControl() {
            return this.originAccessControl;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.cloudfront.AccessLevel> getOriginAccessLevels() {
            return this.originAccessLevels;
        }

        @Override
        public final java.lang.String getOriginPath() {
            return this.originPath;
        }

        @Override
        public final java.lang.Number getConnectionAttempts() {
            return this.connectionAttempts;
        }

        @Override
        public final software.amazon.awscdk.Duration getConnectionTimeout() {
            return this.connectionTimeout;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getCustomHeaders() {
            return this.customHeaders;
        }

        @Override
        public final java.lang.String getOriginAccessControlId() {
            return this.originAccessControlId;
        }

        @Override
        public final java.lang.String getOriginId() {
            return this.originId;
        }

        @Override
        public final java.lang.Boolean getOriginShieldEnabled() {
            return this.originShieldEnabled;
        }

        @Override
        public final java.lang.String getOriginShieldRegion() {
            return this.originShieldRegion;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getOriginAccessControl() != null) {
                data.set("originAccessControl", om.valueToTree(this.getOriginAccessControl()));
            }
            if (this.getOriginAccessLevels() != null) {
                data.set("originAccessLevels", om.valueToTree(this.getOriginAccessLevels()));
            }
            if (this.getOriginPath() != null) {
                data.set("originPath", om.valueToTree(this.getOriginPath()));
            }
            if (this.getConnectionAttempts() != null) {
                data.set("connectionAttempts", om.valueToTree(this.getConnectionAttempts()));
            }
            if (this.getConnectionTimeout() != null) {
                data.set("connectionTimeout", om.valueToTree(this.getConnectionTimeout()));
            }
            if (this.getCustomHeaders() != null) {
                data.set("customHeaders", om.valueToTree(this.getCustomHeaders()));
            }
            if (this.getOriginAccessControlId() != null) {
                data.set("originAccessControlId", om.valueToTree(this.getOriginAccessControlId()));
            }
            if (this.getOriginId() != null) {
                data.set("originId", om.valueToTree(this.getOriginId()));
            }
            if (this.getOriginShieldEnabled() != null) {
                data.set("originShieldEnabled", om.valueToTree(this.getOriginShieldEnabled()));
            }
            if (this.getOriginShieldRegion() != null) {
                data.set("originShieldRegion", om.valueToTree(this.getOriginShieldRegion()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront_origins.S3BucketOriginWithOACProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            S3BucketOriginWithOACProps.Jsii$Proxy that = (S3BucketOriginWithOACProps.Jsii$Proxy) o;

            if (this.originAccessControl != null ? !this.originAccessControl.equals(that.originAccessControl) : that.originAccessControl != null) return false;
            if (this.originAccessLevels != null ? !this.originAccessLevels.equals(that.originAccessLevels) : that.originAccessLevels != null) return false;
            if (this.originPath != null ? !this.originPath.equals(that.originPath) : that.originPath != null) return false;
            if (this.connectionAttempts != null ? !this.connectionAttempts.equals(that.connectionAttempts) : that.connectionAttempts != null) return false;
            if (this.connectionTimeout != null ? !this.connectionTimeout.equals(that.connectionTimeout) : that.connectionTimeout != null) return false;
            if (this.customHeaders != null ? !this.customHeaders.equals(that.customHeaders) : that.customHeaders != null) return false;
            if (this.originAccessControlId != null ? !this.originAccessControlId.equals(that.originAccessControlId) : that.originAccessControlId != null) return false;
            if (this.originId != null ? !this.originId.equals(that.originId) : that.originId != null) return false;
            if (this.originShieldEnabled != null ? !this.originShieldEnabled.equals(that.originShieldEnabled) : that.originShieldEnabled != null) return false;
            return this.originShieldRegion != null ? this.originShieldRegion.equals(that.originShieldRegion) : that.originShieldRegion == null;
        }

        @Override
        public final int hashCode() {
            int result = this.originAccessControl != null ? this.originAccessControl.hashCode() : 0;
            result = 31 * result + (this.originAccessLevels != null ? this.originAccessLevels.hashCode() : 0);
            result = 31 * result + (this.originPath != null ? this.originPath.hashCode() : 0);
            result = 31 * result + (this.connectionAttempts != null ? this.connectionAttempts.hashCode() : 0);
            result = 31 * result + (this.connectionTimeout != null ? this.connectionTimeout.hashCode() : 0);
            result = 31 * result + (this.customHeaders != null ? this.customHeaders.hashCode() : 0);
            result = 31 * result + (this.originAccessControlId != null ? this.originAccessControlId.hashCode() : 0);
            result = 31 * result + (this.originId != null ? this.originId.hashCode() : 0);
            result = 31 * result + (this.originShieldEnabled != null ? this.originShieldEnabled.hashCode() : 0);
            result = 31 * result + (this.originShieldRegion != null ? this.originShieldRegion.hashCode() : 0);
            return result;
        }
    }
}
