package software.amazon.awscdk.services.cloudfront;

/**
 * Properties for defining a <code>CfnCachePolicy</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cloudfront.*;
 * CfnCachePolicyProps cfnCachePolicyProps = CfnCachePolicyProps.builder()
 *         .cachePolicyConfig(CachePolicyConfigProperty.builder()
 *                 .defaultTtl(123)
 *                 .maxTtl(123)
 *                 .minTtl(123)
 *                 .name("name")
 *                 .parametersInCacheKeyAndForwardedToOrigin(ParametersInCacheKeyAndForwardedToOriginProperty.builder()
 *                         .cookiesConfig(CookiesConfigProperty.builder()
 *                                 .cookieBehavior("cookieBehavior")
 *                                 // the properties below are optional
 *                                 .cookies(List.of("cookies"))
 *                                 .build())
 *                         .enableAcceptEncodingGzip(false)
 *                         .headersConfig(HeadersConfigProperty.builder()
 *                                 .headerBehavior("headerBehavior")
 *                                 // the properties below are optional
 *                                 .headers(List.of("headers"))
 *                                 .build())
 *                         .queryStringsConfig(QueryStringsConfigProperty.builder()
 *                                 .queryStringBehavior("queryStringBehavior")
 *                                 // the properties below are optional
 *                                 .queryStrings(List.of("queryStrings"))
 *                                 .build())
 *                         // the properties below are optional
 *                         .enableAcceptEncodingBrotli(false)
 *                         .build())
 *                 // the properties below are optional
 *                 .comment("comment")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-cachepolicy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-cachepolicy.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:08.524Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnCachePolicyProps")
@software.amazon.jsii.Jsii.Proxy(CfnCachePolicyProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnCachePolicyProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The cache policy configuration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-cachepolicy.html#cfn-cloudfront-cachepolicy-cachepolicyconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-cachepolicy.html#cfn-cloudfront-cachepolicy-cachepolicyconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getCachePolicyConfig();

    /**
     * @return a {@link Builder} of {@link CfnCachePolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnCachePolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnCachePolicyProps> {
        java.lang.Object cachePolicyConfig;

        /**
         * Sets the value of {@link CfnCachePolicyProps#getCachePolicyConfig}
         * @param cachePolicyConfig The cache policy configuration. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cachePolicyConfig(software.amazon.awscdk.IResolvable cachePolicyConfig) {
            this.cachePolicyConfig = cachePolicyConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnCachePolicyProps#getCachePolicyConfig}
         * @param cachePolicyConfig The cache policy configuration. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cachePolicyConfig(software.amazon.awscdk.services.cloudfront.CfnCachePolicy.CachePolicyConfigProperty cachePolicyConfig) {
            this.cachePolicyConfig = cachePolicyConfig;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnCachePolicyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnCachePolicyProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnCachePolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnCachePolicyProps {
        private final java.lang.Object cachePolicyConfig;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.cachePolicyConfig = software.amazon.jsii.Kernel.get(this, "cachePolicyConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.cachePolicyConfig = java.util.Objects.requireNonNull(builder.cachePolicyConfig, "cachePolicyConfig is required");
        }

        @Override
        public final java.lang.Object getCachePolicyConfig() {
            return this.cachePolicyConfig;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("cachePolicyConfig", om.valueToTree(this.getCachePolicyConfig()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnCachePolicyProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnCachePolicyProps.Jsii$Proxy that = (CfnCachePolicyProps.Jsii$Proxy) o;

            return this.cachePolicyConfig.equals(that.cachePolicyConfig);
        }

        @Override
        public final int hashCode() {
            int result = this.cachePolicyConfig.hashCode();
            return result;
        }
    }
}
