/**
 * <h1>Amazon Bedrock Construct Library</h1>
 * <p>
 * Amazon Bedrock is a fully managed service that offers a choice of foundation models (FMs)
 * along with a broad set of capabilities for building generative AI applications.
 * <p>
 * This construct library provides a collection of constructs that can look up existing Bedrock models
 * for use with other services' CDK constructs, such as AWS Step Functions.
 * <p>
 * To look up a Bedrock base foundation model:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.bedrock.*;
 * 
 * 
 * FoundationModel.fromFoundationModelId(this, "Model", FoundationModelIdentifier.ANTHROPIC_CLAUDE_V2);
 * </pre></blockquote>
 * <p>
 * To look up a Bedrock provisioned throughput model:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.bedrock.*;
 * 
 * 
 * ProvisionedModel.fromProvisionedModelArn(this, "Model", "arn:aws:bedrock:us-east-2:123456789012:provisioned-model/abc-123");
 * </pre></blockquote>
 * <p>
 * There are no official hand-written (<a href="https://docs.aws.amazon.com/cdk/latest/guide/constructs.html#constructs_lib">L2</a>) constructs for provisioning Bedrock resources yet. Here are some suggestions on how to proceed:
 * <p>
 * <ul>
 * <li>Search <a href="https://constructs.dev/search?q=bedrock">Construct Hub for Bedrock construct libraries</a></li>
 * <li>Use the automatically generated <a href="https://docs.aws.amazon.com/cdk/latest/guide/constructs.html#constructs_l1_using">L1</a> constructs, in the same way you would use <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/AWS_Bedrock.html">the CloudFormation AWS::Bedrock resources</a> directly.</li>
 * </ul>
 */
package software.amazon.awscdk.services.bedrock;
