package software.amazon.awscdk.services.autoscaling;

/**
 * Options needed to bind a target to a lifecycle hook.
 * <p>
 * [disable-awslint:ref-via-interface] The lifecycle hook to attach to and an IRole to use
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.autoscaling.*;
 * import software.amazon.awscdk.services.iam.*;
 * LifecycleHook lifecycleHook;
 * Role role;
 * BindHookTargetOptions bindHookTargetOptions = BindHookTargetOptions.builder()
 *         .lifecycleHook(lifecycleHook)
 *         // the properties below are optional
 *         .role(role)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:07.537Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_autoscaling.BindHookTargetOptions")
@software.amazon.jsii.Jsii.Proxy(BindHookTargetOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BindHookTargetOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The lifecycle hook to attach to.
     * <p>
     * [disable-awslint:ref-via-interface]
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.LifecycleHook getLifecycleHook();

    /**
     * The role to use when attaching to the lifecycle hook.
     * <p>
     * [disable-awslint:ref-via-interface]
     * <p>
     * Default: : a role is not created unless the target arn is specified
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link BindHookTargetOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BindHookTargetOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<BindHookTargetOptions> {
        software.amazon.awscdk.services.autoscaling.LifecycleHook lifecycleHook;
        software.amazon.awscdk.services.iam.IRole role;

        /**
         * Sets the value of {@link BindHookTargetOptions#getLifecycleHook}
         * @param lifecycleHook The lifecycle hook to attach to. This parameter is required.
         *                      [disable-awslint:ref-via-interface]
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lifecycleHook(software.amazon.awscdk.services.autoscaling.LifecycleHook lifecycleHook) {
            this.lifecycleHook = lifecycleHook;
            return this;
        }

        /**
         * Sets the value of {@link BindHookTargetOptions#getRole}
         * @param role The role to use when attaching to the lifecycle hook.
         *             [disable-awslint:ref-via-interface]
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BindHookTargetOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public BindHookTargetOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link BindHookTargetOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BindHookTargetOptions {
        private final software.amazon.awscdk.services.autoscaling.LifecycleHook lifecycleHook;
        private final software.amazon.awscdk.services.iam.IRole role;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.lifecycleHook = software.amazon.jsii.Kernel.get(this, "lifecycleHook", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.LifecycleHook.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.lifecycleHook = java.util.Objects.requireNonNull(builder.lifecycleHook, "lifecycleHook is required");
            this.role = builder.role;
        }

        @Override
        public final software.amazon.awscdk.services.autoscaling.LifecycleHook getLifecycleHook() {
            return this.lifecycleHook;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("lifecycleHook", om.valueToTree(this.getLifecycleHook()));
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_autoscaling.BindHookTargetOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BindHookTargetOptions.Jsii$Proxy that = (BindHookTargetOptions.Jsii$Proxy) o;

            if (!lifecycleHook.equals(that.lifecycleHook)) return false;
            return this.role != null ? this.role.equals(that.role) : that.role == null;
        }

        @Override
        public final int hashCode() {
            int result = this.lifecycleHook.hashCode();
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            return result;
        }
    }
}
