package software.amazon.awscdk.services.apigateway;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * LambdaIntegration integration;
 * RestApi api = new RestApi(this, "hello-api");
 * Resource v1 = api.root.addResource("v1");
 * Resource echo = v1.addResource("echo");
 * Method echoMethod = echo.addMethod("GET", integration, MethodOptions.builder().apiKeyRequired(true).build());
 * UsagePlan plan = api.addUsagePlan("UsagePlan", UsagePlanProps.builder()
 *         .name("Easy")
 *         .throttle(ThrottleSettings.builder()
 *                 .rateLimit(10)
 *                 .burstLimit(2)
 *                 .build())
 *         .build());
 * IApiKey key = api.addApiKey("ApiKey");
 * plan.addApiKey(key);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:06.481Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigateway.UsagePlanProps")
@software.amazon.jsii.Jsii.Proxy(UsagePlanProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface UsagePlanProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * API Stages to be associated with the usage plan.
     * <p>
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.apigateway.UsagePlanPerApiStage> getApiStages() {
        return null;
    }

    /**
     * Represents usage plan purpose.
     * <p>
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * Name for this usage plan.
     * <p>
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * Number of requests clients can make in a given time period.
     * <p>
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.QuotaSettings getQuota() {
        return null;
    }

    /**
     * Overall throttle settings for the API.
     * <p>
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.ThrottleSettings getThrottle() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link UsagePlanProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link UsagePlanProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<UsagePlanProps> {
        java.util.List<software.amazon.awscdk.services.apigateway.UsagePlanPerApiStage> apiStages;
        java.lang.String description;
        java.lang.String name;
        software.amazon.awscdk.services.apigateway.QuotaSettings quota;
        software.amazon.awscdk.services.apigateway.ThrottleSettings throttle;

        /**
         * Sets the value of {@link UsagePlanProps#getApiStages}
         * @param apiStages API Stages to be associated with the usage plan.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder apiStages(java.util.List<? extends software.amazon.awscdk.services.apigateway.UsagePlanPerApiStage> apiStages) {
            this.apiStages = (java.util.List<software.amazon.awscdk.services.apigateway.UsagePlanPerApiStage>)apiStages;
            return this;
        }

        /**
         * Sets the value of {@link UsagePlanProps#getDescription}
         * @param description Represents usage plan purpose.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link UsagePlanProps#getName}
         * @param name Name for this usage plan.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link UsagePlanProps#getQuota}
         * @param quota Number of requests clients can make in a given time period.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder quota(software.amazon.awscdk.services.apigateway.QuotaSettings quota) {
            this.quota = quota;
            return this;
        }

        /**
         * Sets the value of {@link UsagePlanProps#getThrottle}
         * @param throttle Overall throttle settings for the API.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder throttle(software.amazon.awscdk.services.apigateway.ThrottleSettings throttle) {
            this.throttle = throttle;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link UsagePlanProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public UsagePlanProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link UsagePlanProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UsagePlanProps {
        private final java.util.List<software.amazon.awscdk.services.apigateway.UsagePlanPerApiStage> apiStages;
        private final java.lang.String description;
        private final java.lang.String name;
        private final software.amazon.awscdk.services.apigateway.QuotaSettings quota;
        private final software.amazon.awscdk.services.apigateway.ThrottleSettings throttle;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.apiStages = software.amazon.jsii.Kernel.get(this, "apiStages", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.UsagePlanPerApiStage.class)));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.quota = software.amazon.jsii.Kernel.get(this, "quota", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.QuotaSettings.class));
            this.throttle = software.amazon.jsii.Kernel.get(this, "throttle", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.ThrottleSettings.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.apiStages = (java.util.List<software.amazon.awscdk.services.apigateway.UsagePlanPerApiStage>)builder.apiStages;
            this.description = builder.description;
            this.name = builder.name;
            this.quota = builder.quota;
            this.throttle = builder.throttle;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.apigateway.UsagePlanPerApiStage> getApiStages() {
            return this.apiStages;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final software.amazon.awscdk.services.apigateway.QuotaSettings getQuota() {
            return this.quota;
        }

        @Override
        public final software.amazon.awscdk.services.apigateway.ThrottleSettings getThrottle() {
            return this.throttle;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getApiStages() != null) {
                data.set("apiStages", om.valueToTree(this.getApiStages()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getQuota() != null) {
                data.set("quota", om.valueToTree(this.getQuota()));
            }
            if (this.getThrottle() != null) {
                data.set("throttle", om.valueToTree(this.getThrottle()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigateway.UsagePlanProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            UsagePlanProps.Jsii$Proxy that = (UsagePlanProps.Jsii$Proxy) o;

            if (this.apiStages != null ? !this.apiStages.equals(that.apiStages) : that.apiStages != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.quota != null ? !this.quota.equals(that.quota) : that.quota != null) return false;
            return this.throttle != null ? this.throttle.equals(that.throttle) : that.throttle == null;
        }

        @Override
        public final int hashCode() {
            int result = this.apiStages != null ? this.apiStages.hashCode() : 0;
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.quota != null ? this.quota.hashCode() : 0);
            result = 31 * result + (this.throttle != null ? this.throttle.hashCode() : 0);
            return result;
        }
    }
}
