package software.amazon.awscdk.services.accessanalyzer;

/**
 * Properties for defining a <code>CfnAnalyzer</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.accessanalyzer.*;
 * CfnAnalyzerProps cfnAnalyzerProps = CfnAnalyzerProps.builder()
 *         .type("type")
 *         // the properties below are optional
 *         .analyzerConfiguration(AnalyzerConfigurationProperty.builder()
 *                 .unusedAccessConfiguration(UnusedAccessConfigurationProperty.builder()
 *                         .analysisRule(AnalysisRuleProperty.builder()
 *                                 .exclusions(List.of(AnalysisRuleCriteriaProperty.builder()
 *                                         .accountIds(List.of("accountIds"))
 *                                         .resourceTags(List.of(List.of(CfnTag.builder()
 *                                                 .key("key")
 *                                                 .value("value")
 *                                                 .build())))
 *                                         .build()))
 *                                 .build())
 *                         .unusedAccessAge(123)
 *                         .build())
 *                 .build())
 *         .analyzerName("analyzerName")
 *         .archiveRules(List.of(ArchiveRuleProperty.builder()
 *                 .filter(List.of(FilterProperty.builder()
 *                         .property("property")
 *                         // the properties below are optional
 *                         .contains(List.of("contains"))
 *                         .eq(List.of("eq"))
 *                         .exists(false)
 *                         .neq(List.of("neq"))
 *                         .build()))
 *                 .ruleName("ruleName")
 *                 .build()))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-accessanalyzer-analyzer.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-accessanalyzer-analyzer.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:06.078Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_accessanalyzer.CfnAnalyzerProps")
@software.amazon.jsii.Jsii.Proxy(CfnAnalyzerProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnAnalyzerProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The type represents the zone of trust for the analyzer.
     * <p>
     * <em>Allowed Values</em> : ACCOUNT | ORGANIZATION | ACCOUNT_UNUSED_ACCESS | ORGANIZATION_UNUSED_ACCESS
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-accessanalyzer-analyzer.html#cfn-accessanalyzer-analyzer-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-accessanalyzer-analyzer.html#cfn-accessanalyzer-analyzer-type</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getType();

    /**
     * Contains information about the configuration of an analyzer for an AWS organization or account.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-accessanalyzer-analyzer.html#cfn-accessanalyzer-analyzer-analyzerconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-accessanalyzer-analyzer.html#cfn-accessanalyzer-analyzer-analyzerconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAnalyzerConfiguration() {
        return null;
    }

    /**
     * The name of the analyzer.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-accessanalyzer-analyzer.html#cfn-accessanalyzer-analyzer-analyzername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-accessanalyzer-analyzer.html#cfn-accessanalyzer-analyzer-analyzername</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAnalyzerName() {
        return null;
    }

    /**
     * Specifies the archive rules to add for the analyzer.
     * <p>
     * Archive rules automatically archive findings that meet the criteria you define for the rule.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-accessanalyzer-analyzer.html#cfn-accessanalyzer-analyzer-archiverules">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-accessanalyzer-analyzer.html#cfn-accessanalyzer-analyzer-archiverules</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getArchiveRules() {
        return null;
    }

    /**
     * An array of key-value pairs to apply to the analyzer.
     * <p>
     * You can use the set of Unicode letters, digits, whitespace, <code>_</code> , <code>.</code> , <code>/</code> , <code>=</code> , <code>+</code> , and <code>-</code> .
     * <p>
     * For the tag key, you can specify a value that is 1 to 128 characters in length and cannot be prefixed with <code>aws:</code> .
     * <p>
     * For the tag value, you can specify a value that is 0 to 256 characters in length.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-accessanalyzer-analyzer.html#cfn-accessanalyzer-analyzer-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-accessanalyzer-analyzer.html#cfn-accessanalyzer-analyzer-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnAnalyzerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnAnalyzerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnAnalyzerProps> {
        java.lang.String type;
        java.lang.Object analyzerConfiguration;
        java.lang.String analyzerName;
        java.lang.Object archiveRules;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnAnalyzerProps#getType}
         * @param type The type represents the zone of trust for the analyzer. This parameter is required.
         *             <em>Allowed Values</em> : ACCOUNT | ORGANIZATION | ACCOUNT_UNUSED_ACCESS | ORGANIZATION_UNUSED_ACCESS
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(java.lang.String type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link CfnAnalyzerProps#getAnalyzerConfiguration}
         * @param analyzerConfiguration Contains information about the configuration of an analyzer for an AWS organization or account.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder analyzerConfiguration(software.amazon.awscdk.IResolvable analyzerConfiguration) {
            this.analyzerConfiguration = analyzerConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnAnalyzerProps#getAnalyzerConfiguration}
         * @param analyzerConfiguration Contains information about the configuration of an analyzer for an AWS organization or account.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder analyzerConfiguration(software.amazon.awscdk.services.accessanalyzer.CfnAnalyzer.AnalyzerConfigurationProperty analyzerConfiguration) {
            this.analyzerConfiguration = analyzerConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnAnalyzerProps#getAnalyzerName}
         * @param analyzerName The name of the analyzer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder analyzerName(java.lang.String analyzerName) {
            this.analyzerName = analyzerName;
            return this;
        }

        /**
         * Sets the value of {@link CfnAnalyzerProps#getArchiveRules}
         * @param archiveRules Specifies the archive rules to add for the analyzer.
         *                     Archive rules automatically archive findings that meet the criteria you define for the rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder archiveRules(software.amazon.awscdk.IResolvable archiveRules) {
            this.archiveRules = archiveRules;
            return this;
        }

        /**
         * Sets the value of {@link CfnAnalyzerProps#getArchiveRules}
         * @param archiveRules Specifies the archive rules to add for the analyzer.
         *                     Archive rules automatically archive findings that meet the criteria you define for the rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder archiveRules(java.util.List<? extends java.lang.Object> archiveRules) {
            this.archiveRules = archiveRules;
            return this;
        }

        /**
         * Sets the value of {@link CfnAnalyzerProps#getTags}
         * @param tags An array of key-value pairs to apply to the analyzer.
         *             You can use the set of Unicode letters, digits, whitespace, <code>_</code> , <code>.</code> , <code>/</code> , <code>=</code> , <code>+</code> , and <code>-</code> .
         *             <p>
         *             For the tag key, you can specify a value that is 1 to 128 characters in length and cannot be prefixed with <code>aws:</code> .
         *             <p>
         *             For the tag value, you can specify a value that is 0 to 256 characters in length.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnAnalyzerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnAnalyzerProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnAnalyzerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnAnalyzerProps {
        private final java.lang.String type;
        private final java.lang.Object analyzerConfiguration;
        private final java.lang.String analyzerName;
        private final java.lang.Object archiveRules;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.analyzerConfiguration = software.amazon.jsii.Kernel.get(this, "analyzerConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.analyzerName = software.amazon.jsii.Kernel.get(this, "analyzerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.archiveRules = software.amazon.jsii.Kernel.get(this, "archiveRules", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            this.analyzerConfiguration = builder.analyzerConfiguration;
            this.analyzerName = builder.analyzerName;
            this.archiveRules = builder.archiveRules;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getType() {
            return this.type;
        }

        @Override
        public final java.lang.Object getAnalyzerConfiguration() {
            return this.analyzerConfiguration;
        }

        @Override
        public final java.lang.String getAnalyzerName() {
            return this.analyzerName;
        }

        @Override
        public final java.lang.Object getArchiveRules() {
            return this.archiveRules;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("type", om.valueToTree(this.getType()));
            if (this.getAnalyzerConfiguration() != null) {
                data.set("analyzerConfiguration", om.valueToTree(this.getAnalyzerConfiguration()));
            }
            if (this.getAnalyzerName() != null) {
                data.set("analyzerName", om.valueToTree(this.getAnalyzerName()));
            }
            if (this.getArchiveRules() != null) {
                data.set("archiveRules", om.valueToTree(this.getArchiveRules()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_accessanalyzer.CfnAnalyzerProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnAnalyzerProps.Jsii$Proxy that = (CfnAnalyzerProps.Jsii$Proxy) o;

            if (!type.equals(that.type)) return false;
            if (this.analyzerConfiguration != null ? !this.analyzerConfiguration.equals(that.analyzerConfiguration) : that.analyzerConfiguration != null) return false;
            if (this.analyzerName != null ? !this.analyzerName.equals(that.analyzerName) : that.analyzerName != null) return false;
            if (this.archiveRules != null ? !this.archiveRules.equals(that.archiveRules) : that.archiveRules != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.type.hashCode();
            result = 31 * result + (this.analyzerConfiguration != null ? this.analyzerConfiguration.hashCode() : 0);
            result = 31 * result + (this.analyzerName != null ? this.analyzerName.hashCode() : 0);
            result = 31 * result + (this.archiveRules != null ? this.archiveRules.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
