package software.amazon.awscdk.pipelines;

/**
 * A set of files traveling through the deployment pipeline.
 * <p>
 * Individual steps in the pipeline produce or consume
 * <code>FileSet</code>s.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * public class MyJenkinsStep extends Step implements ICodePipelineActionFactory {
 *     public MyJenkinsStep(JenkinsProvider provider, FileSet input) {
 *         super("MyJenkinsStep");
 *         // This is necessary if your step accepts parameters, like environment variables,
 *         // that may contain outputs from other steps. It doesn't matter what the
 *         // structure is, as long as it contains the values that may contain outputs.
 *         this.discoverReferencedOutputs(Map.of(
 *                 "env", Map.of()));
 *     }
 *     public CodePipelineActionFactoryResult produceAction(IStage stage, ProduceActionOptions options) {
 *         // This is where you control what type of Action gets added to the
 *         // CodePipeline
 *         stage.addAction(
 *         JenkinsAction.Builder.create()
 *                 // Copy 'actionName' and 'runOrder' from the options
 *                 .actionName(options.getActionName())
 *                 .runOrder(options.getRunOrder())
 *                 // Jenkins-specific configuration
 *                 .type(JenkinsActionType.TEST)
 *                 .jenkinsProvider(this.provider)
 *                 .projectName("MyJenkinsProject")
 *                 // Translate the FileSet into a codepipeline.Artifact
 *                 .inputs(List.of(options.artifacts.toCodePipeline(this.input)))
 *                 .build());
 *         return CodePipelineActionFactoryResult.builder().runOrdersConsumed(1).build();
 *     }
 * }
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.110.0 (build 336b265)", date = "2025-04-22T23:08:22.646Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.pipelines.FileSet")
public class FileSet extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.pipelines.IFileSetProducer {

    protected FileSet(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected FileSet(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param id Human-readable descriptor for this file set (does not need to be unique). This parameter is required.
     * @param producer
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public FileSet(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.pipelines.Step producer) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), producer });
    }

    /**
     * @param id Human-readable descriptor for this file set (does not need to be unique). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public FileSet(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Mark the given Step as the producer for this FileSet.
     * <p>
     * This method can only be called once.
     * <p>
     * @param producer
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void producedBy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.pipelines.Step producer) {
        software.amazon.jsii.Kernel.call(this, "producedBy", software.amazon.jsii.NativeType.VOID, new Object[] { producer });
    }

    /**
     * Mark the given Step as the producer for this FileSet.
     * <p>
     * This method can only be called once.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void producedBy() {
        software.amazon.jsii.Kernel.call(this, "producedBy", software.amazon.jsii.NativeType.VOID);
    }

    /**
     * Return a string representation of this FileSet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String toString() {
        return software.amazon.jsii.Kernel.call(this, "toString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Human-readable descriptor for this file set (does not need to be unique).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getId() {
        return software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Step that produces this FileSet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.pipelines.Step getProducer() {
        return software.amazon.jsii.Kernel.get(this, "producer", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.Step.class));
    }

    /**
     * The primary output of a file set producer.
     * <p>
     * The primary output of a FileSet is itself.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.pipelines.FileSet getPrimaryOutput() {
        return software.amazon.jsii.Kernel.get(this, "primaryOutput", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.FileSet.class));
    }
}
