/*
 * Decompiled with CFR 0.152.
 */
package com.yel.image;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Matrix;
import android.support.v7.widget.AppCompatImageView;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.yel.image.R;

public class ScrollingImageView
extends AppCompatImageView {
    private float yPercent = 0.5f;
    private ScrollType mScrollType;
    private static final ScrollType[] mScrollTypeArray = new ScrollType[]{ScrollType.SCROLL_WHOLE, ScrollType.SCROLL_MIDDLE};

    public ScrollingImageView(Context context) {
        super(context);
        this.setup();
    }

    public ScrollingImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScrollingImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.ScrollingImageView, 0, 0);
        try {
            int index = a.getInteger(R.styleable.ScrollingImageView_scrollType, 0);
            this.setScrollType(mScrollTypeArray[index]);
        }
        finally {
            a.recycle();
        }
        RecyclerView temp = this.getRecyclerView((ViewGroup)this.getParent());
        System.out.println("temp: " + temp);
        this.setup();
    }

    private RecyclerView getRecyclerView(ViewGroup v) {
        if (v == null) {
            return null;
        }
        if (v instanceof RecyclerView) {
            return (RecyclerView)v;
        }
        return this.getRecyclerView((ViewGroup)v.getParent());
    }

    private void setup() {
        this.setScaleType(ImageView.ScaleType.MATRIX);
    }

    public void setScrollType(ScrollType scrollType) {
        if (this.mScrollType != scrollType) {
            this.mScrollType = scrollType;
        }
    }

    public ScrollType getScrollType() {
        return this.mScrollType;
    }

    public void setyPercent(float yPercent) {
        this.yPercent = yPercent;
        this.requestLayout();
    }

    private int getViewHeight() {
        return this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom();
    }

    protected boolean setFrame(int l, int t, int r, int b) {
        float scale;
        int drawableHeight;
        if (this.getDrawable() == null) {
            return super.setFrame(l, t, r, b);
        }
        Matrix matrix = this.getImageMatrix();
        float dx = 0.0f;
        float dy = 0.0f;
        int viewWidth = this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight();
        int viewHeight = this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom();
        int drawableWidth = this.getDrawable().getIntrinsicWidth();
        if (drawableWidth * viewHeight > (drawableHeight = this.getDrawable().getIntrinsicHeight()) * viewWidth) {
            scale = (float)viewHeight / (float)drawableHeight;
            dx = ((float)viewWidth - (float)drawableWidth * scale) * 0.5f;
        } else {
            scale = (float)viewWidth / (float)drawableWidth;
            if (this.mScrollType == ScrollType.SCROLL_WHOLE) {
                dy = (float)viewHeight - ((float)viewHeight + (float)drawableHeight * scale) * this.yPercent;
            } else if (this.mScrollType == ScrollType.SCROLL_MIDDLE) {
                dy = ((float)viewHeight - (float)drawableHeight * scale) * this.yPercent;
            }
        }
        matrix.setScale(scale, scale);
        matrix.postTranslate((float)Math.round(dx), (float)Math.round(dy));
        this.setImageMatrix(matrix);
        return super.setFrame(l, t, r, b);
    }

    public static class ScrollListener
    extends RecyclerView.OnScrollListener {
        int ydy = 0;
        private RecyclerView.LayoutManager layoutManager;
        private int id;
        private int index;

        public ScrollListener(RecyclerView.LayoutManager layoutManager, int id, int index) {
            this.layoutManager = layoutManager;
            this.id = id;
            this.index = index;
        }

        public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
            super.onScrolled(recyclerView, dx, dy);
            this.ydy += dy;
            System.out.println(this.ydy);
            View item = this.layoutManager.findViewByPosition(this.index);
            if (item != null) {
                float Offset = item.getTop();
                ScrollingImageView image = (ScrollingImageView)item.findViewById(this.id);
                int viewHeight = image.getViewHeight();
                int recyclerViewHeight = recyclerView.getHeight();
                double bottomDelta = recyclerViewHeight - viewHeight;
                if (image.getScrollType() == ScrollType.SCROLL_WHOLE) {
                    float ratio = (Offset + (float)viewHeight) / 1.0f / (float)(recyclerViewHeight + viewHeight);
                    image.setyPercent(ratio);
                } else if (image.getScrollType() == ScrollType.SCROLL_MIDDLE) {
                    if ((double)Offset > bottomDelta) {
                        image.setyPercent(1.0f);
                    } else if (Offset <= 0.0f) {
                        image.setyPercent(0.0f);
                    } else {
                        image.setyPercent((float)((double)Offset / bottomDelta));
                    }
                }
            }
        }
    }

    public static enum ScrollType {
        SCROLL_WHOLE(0),
        SCROLL_MIDDLE(1);

        final int nativeInt;

        private ScrollType(int ni) {
            this.nativeInt = ni;
        }
    }
}

